


#include "Gauges.h"
#include "g_includes.h"


#define Motor_Amendment 24


#define MOTOR_PHYSICAL_ZERO_INDEX 0


typedef struct
{
    INT8U MoveEn; 
} Gauges_Control_st_t;
#pragma ghs section bss = ".myNonInitArea"
_GaugesInfo GaugesInfo[Num_Of_Piecewise_Linear_App];
Gauges_Control_st_t stGaugesControl[4U];
INT8U Gauges_IG_Status = 0;
INT8U Gauges_IG_Status_Last = 0;

#pragma ghs section bss = default

INT8U Gauges_App_FindSector(INT16U Physical_Data, INT8U Index)
{
    INT8U i, Order, SectorID = 0;
    if (GaugesInfo[Index].Physical_Quantity[0] > GaugesInfo[Index].Physical_Quantity[GaugesInfo[Index].Parameter_Num - 1])
    {
        Order = 0; 
    }
    else
    {
        Order = 1; 
    }
    for (i = 0; i < (GaugesInfo[Index].Parameter_Num - 1); i++)
    {
        if (Order == 1)
        {
            if (Physical_Data >= GaugesInfo[Index].Physical_Quantity[i])
            {
                SectorID++;
            }
        }
        if (Order == 0)
        {
            if (Physical_Data <= GaugesInfo[Index].Physical_Quantity[i])
            {
                SectorID++;
            }
        }
    }
    return SectorID;
}


INT16U Motor_CalMicroStep(INT16U Physical_Data, INT8U Index)
{
    INT8U  SectorID = 0;   
    INT32U PerCentum = 0; 
    INT32U StepCn = 0;
    INT8U  ASCF = 0; 

    INT32U wTemp = 0;

    if (Index >= Num_Of_Piecewise_Linear_App)
    {
        return 0;
    }

    if ((GaugesInfo[Index].Parameter_Num < 2) || (GaugesInfo[Index].Parameter_Num > 8))
    {
        return 0;
    }
    if (GaugesInfo[Index].Physical_Quantity[1] > GaugesInfo[Index].Physical_Quantity[0])
    {
        ASCF = 1;
    }
    else if (GaugesInfo[Index].Physical_Quantity[1] < GaugesInfo[Index].Physical_Quantity[0]) 
    {
        ASCF = 2;
    }
    else
    {
        return 0;
    }
    if (ASCF == 1)
    {
        if (Physical_Data > GaugesInfo[Index].Physical_Quantity[GaugesInfo[Index].Parameter_Num - 1])
        {
            Physical_Data = GaugesInfo[Index].Physical_Quantity[GaugesInfo[Index].Parameter_Num - 1];
        }
        if (Physical_Data < GaugesInfo[Index].Physical_Quantity[0])
        {
            Physical_Data = GaugesInfo[Index].Physical_Quantity[0];
        }
    }
    if (ASCF == 2)
    {
        if (Physical_Data < GaugesInfo[Index].Physical_Quantity[GaugesInfo[Index].Parameter_Num - 1])
        {
            Physical_Data = GaugesInfo[Index].Physical_Quantity[GaugesInfo[Index].Parameter_Num - 1];
        }
        if (Physical_Data > GaugesInfo[Index].Physical_Quantity[0])
        {
            Physical_Data = GaugesInfo[Index].Physical_Quantity[0];
        }
    }
    SectorID = Gauges_App_FindSector(Physical_Data, Index);
    if (SectorID > (GaugesInfo[Index].Parameter_Num - 1))
    {
        return 0;
    }
    if (ASCF == 1)
    {
        wTemp = Physical_Data - GaugesInfo[Index].Physical_Quantity[SectorID - 1];
        PerCentum = wTemp * 1000;

        PerCentum = PerCentum / (GaugesInfo[Index].Physical_Quantity[SectorID] - GaugesInfo[Index].Physical_Quantity[SectorID - 1]);
    }
    if (ASCF == 2)
    {
        wTemp = GaugesInfo[Index].Physical_Quantity[SectorID - 1] - Physical_Data;
        PerCentum = wTemp * 1000;

        PerCentum = PerCentum / (GaugesInfo[Index].Physical_Quantity[SectorID - 1] - GaugesInfo[Index].Physical_Quantity[SectorID]);
    }

    wTemp = GaugesInfo[Index].MicroStep[SectorID] - GaugesInfo[Index].MicroStep[SectorID - 1];
    wTemp = wTemp * PerCentum;

    if ((wTemp % 1000) >= 500)
    {
        wTemp += 500;
    }
    StepCn = wTemp / 1000 + GaugesInfo[Index].MicroStep[SectorID - 1];
    return (INT16U)(StepCn);
}


INT16U Gauges_Parameter_Set_Motor(INT8U Index, INT16U Physical_Data)
{
    INT16U Step_buf = 0U;

    if (Index >= 4)
    {
        return 0;
    }


    if (Normal != bsp_GetMotorState(Index))
    {
       return 0;
    }

    if ((1 == Gauges_IG_Status) && (1 == Gauges_IG_Status_Last))
    {
        Step_buf = Motor_CalMicroStep(Physical_Data, Index);
        
    
        if (MeterPostion[Index].curPosition >= (GaugesInfo[Index].MicroStep[MOTOR_PHYSICAL_ZERO_INDEX] + Motor_Amendment))
        {
            stGaugesControl[Index].MoveEn = 1;
        }
        if ((1 == stGaugesControl[Index].MoveEn) && (Physical_Data <= GaugesInfo[Index].Physical_Quantity[MOTOR_PHYSICAL_ZERO_INDEX]))
        {
            if (Step_buf >= Motor_Amendment)
            {
                Step_buf -= Motor_Amendment;
            }
        }

        MeterPostion[Index].destPosition = Step_buf;
      


        return 1u;
    }
    else
    {
        return 0u;
    }
}


void Gauges_IGStatus_Set(INT8U IG_Status)
{
	//OFF-->ON
    if ((Gauges_IG_Status == 0) && (IG_Status == 1))
    {
        stGaugesControl[0].MoveEn = 0;
        stGaugesControl[1].MoveEn = 0;
        stGaugesControl[2].MoveEn = 0;
        stGaugesControl[3].MoveEn = 0;
    }

    Gauges_IG_Status = IG_Status;
}

void Gauges_Zero_Severces(void)
{
    if (Gauges_IG_Status_Last != Gauges_IG_Status)
    {
       
        if ((((Normal == bsp_GetMotorState(VehMotorNum)) && (GaugesInfo[VehMotorNum].Parameter_Num)) || (0 == GaugesInfo[VehMotorNum].Parameter_Num)) &&
        (((Normal == bsp_GetMotorState(RevMotorNum)) && (GaugesInfo[RevMotorNum].Parameter_Num)) || (0 == GaugesInfo[RevMotorNum].Parameter_Num)))
        {
            if (1 == Gauges_IG_Status) 
            {
                if ((MeterPostion[VehMotorNum].curPosition == MeterPostion[VehMotorNum].destPosition) &&
                (MeterPostion[RevMotorNum].curPosition == MeterPostion[RevMotorNum].destPosition))
                {
                    bsp_SetMotorMode(VehMotorNum, MinReset);

                    bsp_SetMotorMode(RevMotorNum, MinReset);


                    Gauges_IG_Status_Last = Gauges_IG_Status;
                }
            }
            else if (0 == Gauges_IG_Status) //ON-->OFF
            {
                MeterPostion[VehMotorNum].destPosition = 0;

                MeterPostion[RevMotorNum].destPosition = 0;


                Gauges_IG_Status_Last = Gauges_IG_Status;
            }
        }
       
    }
}

void Gauges_Variate_Init_Once(void)
{
    Gauges_IG_Status_Last = 0xFF;
    Gauges_IG_Status = 0;
}
