
#ifndef GUI_H_
#define GUI_H_

#include "g_includes.h"
#include "TYW_stdint.h"

#define GUI_DISP_MODE_OFF       (0U)
#define GUI_DISP_MODE_ON        (1U)
#define GUI_DISP_MODE_LINE      (2U)
#define GUI_DISP_MODE_TRIP_LINE (3U)
#define GUI_DISP_MODE_NONE      (4U)

extern uint16_t MidMapsData [];
extern uint16_t ChargeData [];
extern uint8_t  ChargeTitleIndex;
extern uint8_t  ChargeBottomIndex;

typedef struct
{
    uint8_t Gear;
	uint8_t Gear_Mode;
    uint8_t Blink;	
    
	uint32_t ODO_NUM;		
	uint32_t Trip_NUM;
	
	uint8_t Hour;
	uint8_t Minute;   
    
    uint16_t TRIP;
	uint16_t TRIPValid;
    
    uint16_t EndMileage;
	uint16_t EndMileageValid;
    uint16_t MileagePlace;
    
    uint16_t AvgSpeed;
	uint16_t AvgSpeedValid;
    uint16_t AvgSpeedPlace;
    
    uint16_t AvgOilCon;
	uint16_t AvgOilConValid;
    uint16_t AvgOilPlace;

    uint16_t InstantOilCon;
	uint16_t InstantOilConValid;
    uint16_t InstantOilPlace;
    uint16_t DataVSpeedPlace;

    uint16_t Maintenance;

    
	uint16_t TPMSValid;

    uint16_t Backlight;
	uint16_t BacklightValid;

    uint16_t Volume;
	uint16_t VolumeValid;

    uint16_t Time;
	uint16_t TimeValid;

    uint16_t PopupAlarmDis;
    uint16_t PopupAlarmOFF;

    uint8_t Clock_Colon;
	
	
    uint16_t TempValid;

	uint16_t Fuel;
    uint16_t FuelValid;
	uint16_t UREA;
    uint16_t UREAValid;
   
    
    uint16_t Valid; 

    uint8_t Menu_Cur;
    

} _GUIBackUp;
extern _GUIBackUp GUIBackUp;



extern void Draw_Graph_Engine(void);

extern void GUI_Display_Animation_Frame(uint16_t frame);
extern void GUI_PIC_Set(uint16_t u16POP_ID);
extern uint8_t* PIC_Address_Get(uint16_t u16PIC_Index);

extern void Draw_Graph_En_Set(uint8_t u8Enable);
extern uint8_t Draw_Graph_En_Get(void);


extern void GUI_Service(void);

extern void GUI_Display_PowerOn(void);

extern void GUI_Display_BackGround(void);
extern void Gui_Temp_Display(uint16_t Tempp);
extern uint16_t Gui_Temp_Data_Process(uint16_t TempValue);
extern void Gui_Fuel_Display(uint16_t Fuell,uint8_t Icon);
extern void Gui_UREA_Display(uint16_t UREAA, uint8_t Icon);
extern void GUI_BJ_ODO_Display(uint32_t Mileage);
extern void GUI_BJ_TIME_Display(uint8_t Hour, uint8_t Minute);
extern void GUI_BJ_Gear_Display(uint8_t Mode, uint8_t Valid );

extern void GUI_PopAlarm_Display(INT16U PopupAlarmDis);

void GUI_ECU_Display(void);
void Gui_TRIP(uint32_t MileageDisp);
void Gui_EndMileage(uint8_t Valid, uint16_t EndMileage);
void Gui_AvgSpeed(uint8_t Valid, uint8_t AvgSpeed);
void Gui_AvgOilCon(uint8_t Valid, uint8_t AvgOilCon, uint8_t Valid_M);
void Gui_InstantOilCon(uint8_t Valid, uint8_t InstantOilCon);
void Gui_Maintenance(uint16_t Maintenance);

void Gui_TPMS(void);
void GUI_TPMS_Left_Front_Display(_TPMS_Display_Infor LeftFront);
void GUI_TPMS_Right_Front_Display(_TPMS_Display_Infor RightFront);
void GUI_TPMS_Left_Rear_Display(_TPMS_Display_Infor LeftRear);
void GUI_TPMS_Left_Front_Display_FOUR(_TPMS_Display_Infor LeftFront);
void GUI_TPMS_Left_Rear_Display_FOUR(_TPMS_Display_Infor LeftRear);
void GUI_TPMS_Right_Front_Display_FOUR(_TPMS_Display_Infor RightFront);
void GUI_TPMS_Right_Rear_Display_FOUR(_TPMS_Display_Infor RightRear);
void GUI_TPMS_Right_Rear_Display(_TPMS_Display_Infor RightRear);
void GUI_TPMS_Left_Rear_Inside_Display(_TPMS_Display_Infor LeftRearInside);
void GUI_TPMS_Right_Rear_Inside_Display(_TPMS_Display_Infor RightRearInside);


void GUI_SET_Display(void);
void Gui_Backlight(uint8_t Backlight);
void Gui_Volume(uint8_t Volume);
void GUI_Clock_Display(uint8_t HOUR, uint8_t Minute);

void GUI_PopAlarm_IGOFF(void);
void GUI_BJ_TIME_MIDDLE_Display(uint8_t Hour, uint8_t Minute);
extern void Display_Diag_Ctrl(uint8_t u8Controlled, uint8_t u8Picture);
extern void Display_Ctrl_Init(void);
extern void Display_Ctrl_OFF_Init(void);

extern uint8_t Get_Coolant_Temp_Cur_Display_Value(void);
void Gui_LDWS(INT8U Volume);
#endif
