#include "RTE_GPIO.h"
#include "RTE_CAN.h"
#include "Rscan.h"
#include "dr7f701401.dvf.h"
#include "RSCAN_Table.h"
#include "CAN_Lib.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Diag_ID_Def.h"
#include "DoCAN_ISO15765.h"

#include "PowerManag_User.h"
#include "NMUserControl.h"
#include "NMUserControl.h"
#include "NM_Config.h"
#include "CAN_CFG.h"
#include "UDS_Common.h"

// static uint16_t Can_Init_Lock = 0U;

void Can_Lock_Clr(void)
{
    // Can_Init_Lock = 0u;
}

/***Middle***/
void Can_Init(void)
{
    /* filter 变量声明 */

    // uint32_t i;
    //  B_CANEN_OUT   = 1u;

    // B_CANEN2_OUT  = 1u;
    // B_CANSTB2_OUT = 1u;

    // C_CANSTB_OUT  = 0u;

    // if ( Can_Init_Lock != 0x55AAu )
    {

        RSCAN0_Config_st_t loc_can = {0};

        loc_can.stRSCANCh0.u32RSCANChEn                 = 1U;
        loc_can.stRSCANCh0.enRSCANChBps                 = RSCAN_Baud_Rate_500K;
        loc_can.stRSCANCh0.u32RSCANChRuleSize           = CANFD0_CH0_RX_RULE_SIZE;
        loc_can.stRSCANCh0.pfnRSCANConfirmCallBack      = Can0_Confirm;
        loc_can.stRSCANCh0.pfnRSCANReadMsgCallBack      = Can0_Read_Msg;
        loc_can.stRSCANCh0.pfnRSCANAbortConfirmCallBack = 0;

        loc_can.stRSCANCh1.u32RSCANChEn            = 0U;
        loc_can.stRSCANCh1.enRSCANChBps            = RSCAN_Baud_Rate_125K;
        loc_can.stRSCANCh1.u32RSCANChRuleSize      = CANFD0_CH1_RX_RULE_SIZE;
        loc_can.stRSCANCh1.pfnRSCANConfirmCallBack = 0;
        loc_can.stRSCANCh1.pfnRSCANReadMsgCallBack = 0;

        loc_can.stRSCANCh2.u32RSCANChEn            = 0U;
        loc_can.stRSCANCh2.enRSCANChBps            = RSCAN_Baud_Rate_500K;
        loc_can.stRSCANCh2.u32RSCANChRuleSize      = CANFD0_CH2_RX_RULE_SIZE;
        loc_can.stRSCANCh2.pfnRSCANConfirmCallBack = 0;
        loc_can.stRSCANCh2.pfnRSCANReadMsgCallBack = 0;
        RSCAN0_CH_Init(CANFD_RX_RULE_TABLE_LIST, &loc_can);
        // Can_Init_Lock = 0x55AAu;
    }

    CAN_STB_OUT = 0u;
}

void Can_DeInit(void)
{
}

uint8_t Can_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t loc_can;
    uint8_t        i      = 0;
    loc_can.u32CANID      = Msg->MsgID;
    loc_can.u8CANFrameIDE = 1;
    loc_can.u8CANLEN      = Msg->MsgDLC;
    for ( i = 0; i < 8; i++ )
    {
        loc_can.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }

    RSCAN0_CH0_Set_TXBUF_Data(Msg->MsgPro, &loc_can);

    return 0;
}
/*uint8_t Can_CH1_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t loc_can;
    uint8_t        i      = 0;
    loc_can.u32CANID      = Msg->MsgID;
    loc_can.u8CANFrameIDE = 0;
    loc_can.u8CANLEN      = Msg->MsgDLC;
    for ( i = 0; i < 8; i++ )
    {
        loc_can.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }

    RSCAN0_CH1_Set_TXBUF_Data(Msg->MsgPro, &loc_can);

    return 0;
}
uint8_t Can_CH2_Write(_CAN_Msg *Msg)
{
    CAN_Frame_st_t loc_can;
    uint8_t        i      = 0;
    loc_can.u32CANID      = Msg->MsgID;
    loc_can.u8CANFrameIDE = 0;
    loc_can.u8CANLEN      = Msg->MsgDLC;
    for ( i = 0; i < 8; i++ )
    {
        loc_can.unCANData.u8CANData [ i ] = Msg->Msg [ i ];
    }

    RSCAN0_CH2_Set_TXBUF_Data(Msg->MsgPro, &loc_can);

    return 0;
}*/
void Can_Sleep_Fun(void)
{
}

void Can_SleepController_Fun(void)
{
}

void Can_Wakeup_Fun(void)
{
}

void Can_Uds_Abort(void)
{
}

void Can_Abort_All(void)
{
}
#define CAN_NM_MAX  200U
#define CAN_APP_MAX 50U
uint32_t u32CANMesNMCnt  = 0;
uint32_t u32CANMesAPPCnt = 0;
void     CAN_Message_Time_Handle(void)
{
    if ( u32CANMesNMCnt < CAN_NM_MAX )
    {
        u32CANMesNMCnt++;
    }
    if ( u32CANMesAPPCnt < CAN_APP_MAX )
    {
        u32CANMesAPPCnt++;
    }
}
uint8_t CAN_NM_Online(void)
{
    uint8_t CANOnline = 0;
    if ( u32CANMesNMCnt >= CAN_NM_MAX )
    {
        CANOnline = 1;
    }
    return CANOnline;
}
uint8_t CAN_APP_Online(void)
{
    uint8_t CANOnline = 0;
    if ( u32CANMesAPPCnt >= CAN_APP_MAX )
    {
        CANOnline = 1;
    }
    return CANOnline;
}

/*****Lower  CH0*******/
void Can0_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    Co_Can_Buff_Set(&CAN_CH0_CanMsgOp, Co_Can_ConvertSubID_CAN_CH0(m_id), m_dlc, m_Msg);
    ReceivedMsg(m_id, m_dlc);
    if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    {
        DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    }
    // else
    // {
    //     APP_CAN_Data_Indication(m_id, m_dlc, m_Msg);
    // }
    if ( GetNmBusSleepSt( ) == 1 )
    {
        NM_RemoteWakeup_Fun( );
        Osek_APP_TX_Init( );
    }
    if ( (m_id >= NM_OSEK_ID_MIN) && (m_id <= NM_OSEK_ID_MAX) )
    {
        if ( CAN_GET_NM_REC( ) == 0u )
        {
            NM_Receive_isr_Fun(m_id, m_Msg);
        }
        u32CANMesNMCnt = 0U;
    }
    else
    {
        u32CANMesAPPCnt = 0U;
    }

    // if ((m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY))
    // {

    //     DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    // }

    PoMa_Sleep_Delay_Time_Clean( );
}

void Can0_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{

    if ( TransferStatus == 0x00 )
    {
        NM_TranMsgSuccessDetect( );
    }
    if ( Identifier == 0u )
    {
        DoCAN_L_Data_Confirm(DIAG_ID_Tx, 1);
    }
}

#if 0
/*****Lower  CH1*******/

void Can1_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    // Co_Can_Buff_Set(&CAN_CH2_CanMsgOp, Co_Can_ConvertSubID_CAN_CH2(m_id), m_dlc, m_Msg);
    //  if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    //  {
    //      DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg);
    //  }
    //  else
    //  {
    //      APP_CAN_Data_Indication(m_id, m_dlc, m_Msg);
    //  }
}

void Can1_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
}

/*****Lower  CH2*******/

void Can2_Read_Msg(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg [])
{
    // Co_Can_Buff_Set(&CAN_CH1_CanMsgOp, Co_Can_ConvertSubID_CAN_CH1(m_id), m_dlc, m_Msg);
    // ReceivedMsg(m_id, m_dlc);
    // if ( (m_id == DIAG_ID_Rx_FUN) || (m_id == DIAG_ID_Rx_PHY) )
    // {
    //     DoCAN_L_Data_Indication(m_id, m_dlc, m_Msg,1);
    // }
    // else
    // {
    //     //APP_CAN_Data_Indication(m_id, m_dlc, m_Msg);
    // }
}

void Can2_Confirm(uint32_t Identifier, uint8_t TransferStatus)
{
    // uint32_t MSG_ID;
    // MSG_ID = 0ul;
    // switch ( Identifier )
    // {
    //     case 1:
    //         ///DoCAN_L_Data_Confirm(&CAN2_TPParameter, CAN2_TPParameter.Diag_ID_Tx, TransferStatus);
    //         break;
    //     default:
    //         break;
    // }
}

#endif

void CAN_BUSOFF_Recover(void)
{
    RSCAN0_CH0_Busoff_Recover( );
}
void test_can(uint32_t u32ID)
{
    // uint8_t  i = 0;
    // _CAN_Msg Msg_t;
    // Msg_t.MsgID  = u32ID;
    // Msg_t.MsgDLC = 8;

    // for ( i = 0; i < 8; i++ )
    // {
    //     Msg_t.Msg [ i ] = 0;
    // }
    // Can_Write(&Msg_t);
}
