#include "Mileage.h"
#include "Mileage_user.h"
#include "Non_volatile_Memorys.h"
#include "g_includes.h"
#include "UDS_Common.h"
const Mile_Attribute_st_t stMileAttribute [ MILE_INDEX_MAX ] = {
    {9999999, 0, 1},
    {19999, 1, 0},
    {19999, 1, 0},
};
#pragma ghs section bss = ".myNonInitArea"
Mile_uint8_t        u8MileRamData [ MILE_RAM_DATA_LEN ];
#pragma ghs section bss = default

void Mile_Par_Save_Source(Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen)
{
    Mile_uint16_t i = 0;
    if ( u8MileDataLen >= 4 )
    {
        u8MileDataLen = 4;
    }
    for ( i = 0; i < u8MileDataLen; i++ )
    {
        NVMODO.Data [ i ] = pu8MileData [ i ];
    }
    NVM_Data_Update(NVM_ODO_DATA);
}
void Mile_Par_Save_Index(Mile_Index_en_t enMileIndex, Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen)
{
    if ( enMileIndex == MILE_INDEX_ODO )
    {
        Mile_uint16_t i = 0;
        if ( u8MileDataLen >= 4 )
        {
            u8MileDataLen = 4;
        }
        for ( i = 0; i < u8MileDataLen; i++ )
        {
            u8MileODORelated [ i ] = pu8MileData [ i ];
        }
        NVM_Data_Update(NVM_INDEX_ODO);
    }
}
void Mile_Par_Save_Snapshot(Mile_Snapshot_en_t enMileSnapshot, Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen)
{
    if ( enMileSnapshot < MILE_SNAP_MAX )
    {
        Mile_uint16_t i = 0;
        if ( u8MileDataLen >= 16 )
        {
            u8MileDataLen = 16;
        }
        for ( i = 0; i < u8MileDataLen; i++ )
        {
            u8MileSnapshotRelated [ enMileSnapshot ][ i ] = pu8MileData [ i ];
        }
        NVM_Data_Update(NVM_SNAPSHOT_FIRST + enMileSnapshot);
    }
}
void Mile_Gain_user(Mile_uint8_t u8MileData)
{
    Data_AvgFuel_Trip_ADD(u8MileData);
    AvgSpeed_Milleage_Add(u8MileData);
    Popups_Alarm_Trigger_Mileage(u8MileData);
}
const Mile_Init_st_t stMileInit = {
    MILE_SOURCE_VEHICLE,
    MILE_INDEX_MAX,
    MILE_SNAP_MAX,
    Mile_Par_Save_Source,
    Mile_Par_Save_Index,
    Mile_Par_Save_Snapshot,
    Mile_Gain_user,
    1800,
    10};
void Mileage_KL30_Init_Example(void)
{
    Mile_uint16_t i = 0;
    Mileage_KL30_Init(u8MileRamData, &stMileInit, stMileAttribute, &NVMODO.Data [ 0 ], 4);
    Mile_Parameter_Read_Index(MILE_INDEX_ODO, u8MileODORelated, 4);

    for ( i = 0; i < MILE_SNAP_MAX; i++ )
    {
        Mile_Parameter_Read_Snapshot(i, &u8MileSnapshotRelated [ i ][ 0 ], 16);
    }
}
void Mileage_Wakeup_Init_Example(void)
{
    Mileage_Wakeup_Init(u8MileRamData, &stMileInit, stMileAttribute);
}

uint16_t u16MaintRemain     = 0U;
uint16_t u16MaintRemainFlag = 0U;
uint32_t u32MaintODO        = 0UL;

void Maint_Service(void)
{
    uint32_t u32MaintData    = 0UL;
    uint32_t u32MaintData2   = 0UL;
    uint16_t u16MaintDataCfg = 0UL;
    u32MaintData             = Mile_Get_Index_Value(MILE_INDEX_ODO) / 10UL;

    if ( u8NVMMaintenance [ 8 ] )    // 次保
    {

        u16MaintDataCfg = Ser2EToDFlashInfo.DID_1E00 [ 2 ];
        u16MaintDataCfg <<= 8U;
        u16MaintDataCfg |= Ser2EToDFlashInfo.DID_1E00 [ 3 ];
    }
    else
    {
        u16MaintDataCfg = Ser2EToDFlashInfo.DID_1E00 [ 0 ];
        u16MaintDataCfg <<= 8U;
        u16MaintDataCfg |= Ser2EToDFlashInfo.DID_1E00 [ 1 ];
    }

    u32MaintData2 = (u32MaintODO + u16MaintDataCfg);

    if ( u32MaintData2 > u32MaintData )
    {
        u16MaintRemain = u32MaintData2 - u32MaintData;
    }
    else
    {
        u16MaintRemain = 0U;
    }
    if ( Ser2EToDFlashInfo.DID_1E00 [ 4 ] > 0x03 )
    {
        u16MaintDataCfg = 2000;
    }
    else
    {
        u16MaintDataCfg = (Ser2EToDFlashInfo.DID_1E00 [ 4 ] + 1) * 500;
    }

    if ( u16MaintRemain >= u16MaintDataCfg )
    {
        u16MaintRemainFlag = 0;
    }
    else
    {
        u16MaintRemainFlag = 1;
    }
}

void Maint_Init(void)
{
    uint32_t u32MaintData = 0UL;

    u32MaintData = u8NVMMaintenance [ 3 ];
    u32MaintODO  = (u32MaintData << 24U);
    u32MaintData = u8NVMMaintenance [ 2 ];
    u32MaintODO |= (u32MaintData << 16U);
    u32MaintData = u8NVMMaintenance [ 1 ];
    u32MaintODO |= (u32MaintData << 8U);
    u32MaintData = u8NVMMaintenance [ 0 ];
    u32MaintODO |= (u32MaintData);
    Maint_Service( );
}

/*保养复位，传入0：恢复到首保。传入1恢复到次保*/
void Maint_Reset(unsigned int u32MainNum)
{
    uint32_t u32MaintData = 0UL;
    u32MaintData          = Mile_Get_Index_Value(MILE_INDEX_ODO) / 10UL;

    u8NVMMaintenance [ 8 ] = u32MainNum;

    u8NVMMaintenance [ 3 ] = ( uint8_t )(u32MaintData >> 24U);
    u8NVMMaintenance [ 2 ] = ( uint8_t )(u32MaintData >> 16U);
    u8NVMMaintenance [ 1 ] = ( uint8_t )(u32MaintData >> 8U);
    u8NVMMaintenance [ 0 ] = ( uint8_t )(u32MaintData);

    NVM_Data_Update(NVM_MAINT_DATA);
    u32MaintODO = u32MaintData;
    Maint_Service( );
}
/*单位 KM */
unsigned int Maint_Get_Remain(void)
{
    return u16MaintRemain;
}
/*0:正常显示保养里程数  1：显示立即保养+扳手图标*/
unsigned int Maint_Get_Remain_Flag(void)
{
    return u16MaintRemainFlag;
}
