#include "EOL_Para.h"
#include "UDS_Common.h"

_EOL_F010 EOL_F010;


void EOL_InitVal(void)
{
    //uint8_t enResult = 0u;
    EOL_F010.F010_Byte[0] = 0x10;
    EOL_F010.F010_Byte[1] = 0x00;
    EOL_F010.F010_Byte[2] = 0x40;
    EOL_F010.F010_Byte[3] = 0x04;
    EOL_F010.F010_Byte[4] = 0x00;
    EOL_F010.F010_Byte[5] = 0x00;
    EOL_F010.F010_Byte[6] = 0x00;
    EOL_F010.F010_Byte[7] = 0x00;
    //enResult = write2EData(WriteEOLData);
}

void EOL_InitVal_TYW_Clear(void)
{
    uint8_t i;

    EOLToDFlashInfo.Flag = 0x7AA7A55Au;
    for (i = 0u; i < 8u; ++i)
    {
        EOLToDFlashInfo.DID_F010[i] = 0x00;
    }
    EOLToDFlashInfo.DID_F010[3] = 0x04;
    write2EData(WriteEOLData);
    
}

void EOL_SetF010(uint8_t EOL[], uint8_t len)
{
    uint8_t i;

    if (len == 8u)
    {
        for (i = 0u; i < sizeof(EOL_F010); i++)
        {
            EOL_F010.F010_Byte[i] = EOL[i];
        }
    }
}
 

_EOL_F010 EOL_GetF010(void)
{
    return EOL_F010;
}
/*
 * 0xF010 
 * EOL DataIdentifier
*/

/*BYTE 0*/
uint8_t Val_EOL_F010_EngineType(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)(EOL_F010.F010_Byte[0u] & 0x0F);
    return Res;
}

uint8_t Val_EOL_F010_TPMS(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)((EOL_F010.F010_Byte[0u] >> 4u) & 0x03);
    return Res;
}

uint8_t Val_EOL_F010_CrankTime(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)((EOL_F010.F010_Byte[0u] >> 6u) & 0x03);
    return Res;
}

/*BYTE 1*/
uint8_t Val_EOL_F010_FuelTank(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)(EOL_F010.F010_Byte[1u]);
    return Res;
}

/*BYTE 2*/
uint8_t Val_EOL_F010_AirBag_Ctrl(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)(EOL_F010.F010_Byte[2u] & 0x03);
    return Res;
}

uint8_t Val_EOL_F010_ESP_EN(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)((EOL_F010.F010_Byte[2u] >> 2u) & 0x0F);
    return Res;
}

uint8_t Val_EOL_F010_GearBoxType(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)((EOL_F010.F010_Byte[2u] >> 6u) & 0x03);
    return Res;
}

/*BYTE 3*/
uint8_t Val_EOL_F010_FourWheelAlarm(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)(EOL_F010.F010_Byte[3u] & 0x01);
    return Res;
}

uint8_t Val_EOL_F010_LWDS(void)
{
    uint8_t Res = 0u;
    Res = (uint8_t)((EOL_F010.F010_Byte[3u] >> 2u) & 0x01);
    return Res;
}
