#ifndef CAN_1939_H__
#define CAN_1939_H__
//#define CAN_1939_16BIT
#ifdef CAN_1939_16BIT
typedef unsigned char CAN_1939_uint8_t;
typedef unsigned int CAN_1939_uint16_t;
typedef unsigned long CAN_1939_uint32_t;
#else
typedef unsigned char CAN_1939_uint8_t;
typedef unsigned short CAN_1939_uint16_t;
typedef unsigned int CAN_1939_uint32_t;
typedef unsigned long long CAN_1939_uint64_t;
#endif
/*每个多包信息最长的数据长度*/
#define CAN1939_MESSAGE_LEN 42UL /*需要根据实际项目需求进行相关调整*/
typedef union {
	CAN_1939_uint8_t data[4];
	struct
	{
		CAN_1939_uint8_t SPNL;
		CAN_1939_uint8_t SPNM;
		CAN_1939_uint8_t FMI : 5;
		CAN_1939_uint8_t SPNH : 3;
		CAN_1939_uint8_t OC : 7;
		CAN_1939_uint8_t CM : 1;
	} BIT;
} DTC_1939;
typedef union {
	DTC_1939 DtcDefine[10];	   /*需要根据实际项目需求进行相关调整*/
	CAN_1939_uint8_t Data[40]; /*需要根据实际项目需求进行相关调整*/
} DtcData_un_t;
typedef struct
{
	CAN_1939_uint8_t LampStatus1;
	CAN_1939_uint8_t LampStatus2;
	DtcData_un_t DtcData;
} DtcList_Type;
typedef union {
	CAN_1939_uint8_t CAN1939Message[CAN1939_MESSAGE_LEN]; /*需要根据实际项目需求进行相关调整*/
	DtcList_Type CAN1939DtcList;
} CAN1939_Message_un_t;
//需要进行多包解析的源地址枚举
typedef enum
{
	CAN1939_SA_03 = 0,
	CAN1939_SA_00,
	CAN1939_SA_MAX,
} CAN_1939_SA_en_t;
/*********************************Do not modify the following********************************************************************/
/*********************************Do not modify the following********************************************************************/
/*********************************Do not modify the following********************************************************************/
/*本文件实现对于1939中广播公告消息的解析*/
#define CAN1939_RAM_DATA_LEN ((CAN1939_MESSAGE_LEN + 24UL) * CAN1939_SA_MAX)
typedef struct
{
	CAN_1939_uint32_t u32CAN1939BAMID;		 /*BAM 报文ID*/
	CAN_1939_uint32_t u32CAN1939DTID;		 /*DT 报文ID*/
	CAN_1939_uint16_t u16CAN1939TimeOutTime; /*超时时间，ms*/
} CAN1939_Attribute_st_t;
typedef struct
{
	/*源地址数量：CAN1939_SA_MAX*/
	CAN_1939_uint8_t u8CAN1939SANUM;
	/*接收解析数据长度：CAN1939_MESSAGE_LEN*/
	CAN_1939_uint8_t u8CAN1939MessageLen;
} CAN1939_Init_st_t;
/*操作函数返回状态*/
typedef enum
{
	CAN1939_SUCCESS = 0UL, /*函数操作成功*/
	CAN1939_FAIL,		   /*函数操作失败*/
} CAN1939_Type_en_t;
/*每次KL30和唤醒时调用*/
void CAN_J1939_Init(CAN_1939_uint8_t *pu8CAN1939RamData, const CAN1939_Attribute_st_t *pstCAN1939Attribute, CAN1939_Init_st_t *pstCAN1939Init);
/*The default length is 8 */ /*数据接收时调用*/
CAN1939_Type_en_t CAN_1939_Receive_Data(CAN_1939_SA_en_t enCAN1939SA, CAN_1939_uint32_t u32CAN1939ID, CAN_1939_uint8_t *pu8CAN1939Data);
/*服务函数，调用周期小于报文传输周期，一般建议小于50ms*/
void CAN_J1939_Multipacket_Service(CAN_1939_SA_en_t enCAN1939SA);
/*报文是否掉线  
0：掉线  1： 没掉线。*/
CAN_1939_uint8_t CAN_J1939_Get_Timeout_Flag(CAN_1939_SA_en_t enCAN1939SA);
/*获取数据更新标志   
2:数据有更新
other ：数据无更新*/
CAN_1939_uint8_t CAN_J1939_Get_Update_Flag(CAN_1939_SA_en_t enCAN1939SA);
/*获取数据长度*/
CAN_1939_uint16_t CAN_J1939_Get_Message_Len(CAN_1939_SA_en_t enCAN1939SA);
/*获取数据内容*/
CAN_1939_uint8_t *CAN_J1939_Get_Message_Content(CAN_1939_SA_en_t enCAN1939SA);
/*获取数据PGN*/
CAN_1939_uint32_t CAN_J1939_Get_Message_PGN(CAN_1939_SA_en_t enCAN1939SA);
/*清零更新标志*/
void CAN_J1939_Clear_Update_Flag(CAN_1939_SA_en_t enCAN1939SA);
/*多少毫秒调用一次就传入多少*/
void CAN_J1939_Time_Handle(CAN_1939_uint8_t u8CAN1939TimeBase);
#endif
