


#ifndef _GAUGES_H_
#define _GAUGES_H_
#include "TYW_stdint.h"

#define Num_Of_Piecewise_Linear_App 4



typedef struct
{
	INT16U Physical_Quantity[8];
	INT16U MicroStep[8];		
	INT8U  Parameter_Num;
} _GaugesInfo;


extern _GaugesInfo GaugesInfo[Num_Of_Piecewise_Linear_App];


extern void Gauges_Variate_Init_Once(void);

extern void Gauges_IGStatus_Set(INT8U IG_Status);

extern void Gauges_Zero_Severces(void);


extern INT16U Gauges_Parameter_Set_Motor(INT8U Index, INT16U Physical_Data);





extern void GaugesInfo_Init(void);
extern void Gauges_Management_Service(void);
extern void Gauges_Sleep_Init(void);
extern void Gauges_KL30_Init(void);
extern void Gauges_KL15ON_Init(void);
extern void Gauges_Wake_Up_Init(void);
extern void Gauges_KL15OFF_Init(void);
extern INT16U Motor_CalMicroStep(INT16U Physical_Data, INT8U Index);


#endif
