#ifndef POWER_MANAG_H__
#define POWER_MANAG_H__
/**************************************************************************/
//#define POWER_MANAG_PLATFORM_16BIT
#ifdef POWER_MANAG_PLATFORM_16BIT
typedef unsigned char PoMa_uint8_t;
typedef unsigned int PoMa_uint16_t;
typedef unsigned long PoMa_uint32_t;
#else
typedef unsigned char PoMa_uint8_t;
typedef unsigned short PoMa_uint16_t;
typedef unsigned int PoMa_uint32_t;
typedef unsigned long long PoMa_uint64_t;
#endif
/*需要识别出的电压状态，需按照电压从小到大的顺序进行排列*/
typedef enum
{
    POMA_VOLTAGE_LOW = 0U,
    POMA_VOLTAGE_NORMAL,
    POMA_VOLTAGE_HIGH,
    POMA_VOLTAGE_NUM,
} PoMa_Voltage_en_t;
/**************************Do not modify the following********************/
/**************************Do not modify the following********************/
/**************************Do not modify the following********************/
#define POMA_RAM_DATA_LEN (9U)
typedef enum
{
    POMA_IG_OFF = 0U,
    POMA_IG_ON,
    POMA_IG_SLEEP,
    POMA_IG_STATUS_MAX,
} PoMa_IG_Status_en_t;
/*复位源*/
typedef enum
{
    POMA_RESET_KL30 = 0U,
    POMA_RESET_WAKEUP,
} PoMa_Reset_en_t;
/*IG信号方式*/
typedef enum
{
    POMA_IG_LINE = 0U,
    POMA_IG_ADC,
    POMA_IG_TYPE_MAX,
} PoMa_IG_Type_en_t;
typedef PoMa_uint16_t (*pfunPoMa_Read)(void);
typedef void (*pfnPoMa_Exe)(void);
typedef void (*pfnPoMa_Delay)(PoMa_uint8_t u8DelayMs);
typedef struct
{
    /*进入的下限电压阈值*/ /** 单位mv **/
    PoMa_uint16_t u16PoMaEnterLow;
    /*进入的上限电压阈值*/ /** 单位mv **/
    PoMa_uint16_t u16PoMaEnterHigh;
    /*消抖时间*/ /** 进入防抖时间单位ms **/
    PoMa_uint16_t u16PoMaEnterDebounceTimer;
    /*进入的初始化函数*/
    pfnPoMa_Exe pfnPoMaEnterInitCB;
    /*退出的初始化函数*/
    pfnPoMa_Exe pfnPoMaExitInitCB;
} PoMa_Voltage_Attribute_st_t;
typedef struct
{
    pfnPoMa_Exe pfnPoMa_Init_KL30;   /*KL30初始化*/
    pfnPoMa_Exe pfnPoMa_Init_IGOFF;  /*IGOFF初始化:ON-->OFF*/
    pfnPoMa_Exe pfnPoMa_Init_IGON;   /*IGON初始化:OFF-->ON*/
    pfnPoMa_Exe pfnPoMa_Init_Wakeup; /*wakeup初始化:sleep-->OFF*/
    pfnPoMa_Exe pfnPoMa_Init_Sleep;  /*sleep初始化:OFF-->sleep*/
    pfnPoMa_Exe pfnPoMa_Sleep_Loop;  /*sleep stay 保持循环执行函数，理论上只有在XHY和RL78芯片上会用到。休眠时定时唤醒芯片的那种*/
    PoMa_IG_Type_en_t enPoMaIGType;          /*IG信号类型*/
    PoMa_uint16_t u16PoMaIGONVo;             /*当IG信号是电压信号时，判断IGON的门限电压。单位mv*/
    PoMa_uint16_t u16PoMaIGOFFVo;            /*当IG信号是电压信号时，判断IGOFF的门限电压。单位mv*/
    PoMa_uint16_t u16PoMaIGONDebounceTimer;  /*IGON 消抖时间。单位ms*/
    PoMa_uint16_t u16PoMaIGOFFDebounceTimer; /*IGOFF 消抖时间。单位ms*/
    pfunPoMa_Read pfnPoMaReadIGLine;    /*获取IG硬线信号接口*/
    pfunPoMa_Read pfnPoMaReadKL15;      /*获取IG电压信号接口*/
    pfunPoMa_Read pfnPoMaReadKL30;      /*获取KL30电压信号接口*/
    pfunPoMa_Read pfnPoMaReadKL15Force; /*立即转换一次IG电压信号接口*/
    pfunPoMa_Read pfnPoMaReadKL30Force; /*立即转换一次KL30电压信号接口*/
    pfunPoMa_Read pfnPoMaCheckSleep;  /*是否满足休眠条件,1：条件成立，0：条件不成立*/
    pfunPoMa_Read pfnPoMaCheckWakeup; /*是否满足唤醒条件,1：条件成立，0：条件不成立*/
    pfnPoMa_Delay pfnPoMaDelay;       /*延时函数，单位1MS*/
    PoMa_uint8_t u8PoMaDelayTime; /*首次上电延时时间，单位ms*/
    PoMa_uint8_t u8PoMaVoltageNum; /*电压状态数量 POMA_VOLTAGE_NUM*/
} PoMa_Init_st_t;

extern void PoMa_Init(PoMa_Reset_en_t enPoMaReset, PoMa_uint8_t *pu8PoMaRamData, const PoMa_Init_st_t *pstPoMaInit, const PoMa_Voltage_Attribute_st_t *pstPoMaVoltageAttribute);
/*多少毫秒调用一次就传入多少*/
extern void PoMa_Time_Service(PoMa_uint8_t u8PoMaTimeBase);
/*主循环实时调用*/
extern void PoMa_Service(void);
extern PoMa_IG_Status_en_t PoMa_Get_IG_Status(void);
extern PoMa_Voltage_en_t PoMa_Get_Voltage_Status(void);
#endif
