#ifndef TYW_FLASH_H
#define TYW_FLASH_H

#include "r_typedefs.h"

typedef enum
{
    R_SFMA0_ERR_OK = 0,
    R_SFMA0_ERR_NG,
    R_SFMA0_ERR_PARAM_INCORRECT,
    R_SFMA0_ERR_RANGE_UNIT,
    R_SFMA0_ERR_RANGE_PARAM,
    R_SFMA0_ERR_NOT_ACCEPTABLE,
    R_SFMA0_ERR_FATAL_OS,
    R_SFMA0_ERR_FATAL_HW,
    R_SFMA0_ERR_NOT_SUPPORT_CLOCK,
    R_SFMA0_ERR_NOT_SUPPORT_TRANSFER,
    R_SFMA0_ERR_SFLASH_PROTECTED,
    R_SFMA0_ERR_NOT_SUPPORTED
} r_sfma0_Error_t;

typedef struct
{
    uint8_t DTR_CMD;
    uint8_t DTR_MF0_7;
    uint8_t DTR_DummyCycle;
} SFMA_DDR_Parameter_t;

void TYW_FLASH_Init(void);
void TYW_FLASH_PreInit(void);
void TYW_FLASH_DDRPreInit(SFMA_DDR_Parameter_t *DDR_Parameter);


extern uint32_t TestBackupRam1;
#endif
