
#include "g_includes.h"
#include "DataProcess.h"
#include "UDS_2FService_Internal.h"
uint32_t VSpeedCal;
uint16_t  DataESpeedActual;
uint16_t  DataESpeedDisp; 
uint8_t   DataESpeedValid ;

#pragma ghs section bss = ".myNonInitArea"
_Light g_Light;
_Light g_nightLight;
uint32_t PowerIgnOnTimeLine = 0;
uint32_t PowerIgnOffTimeLine = 0;
#pragma ghs section bss = default
extern uint8_t DiagVSpeedValue[2];
extern uint8_t DiagESpeedValue[2];
extern uint8_t DiagBackLight;
uint8_t Can_Time_Normal = 0;

DataVSpeedSamplerStruct DataVSpeedSampler;
DataVSPeedDampingStruct DataVSPeedDamping;


uint16_t                ESpeedCAFD;     
// uint16_t                DataESpeedActual;
// uint16_t                DataESpeedDisp;
// uint8_t                 DataESpeedValid;
DataESpeedSamplerStruct DataESpeedSampler;
DataESpeedStruct        DataESpeed ;
DataFreESpeedSamplerStruct DataFreESpeedSampler;
DataESPeedDampingStruct DataESPeedDamping;
DataESpeedIdleStruct    DataESpeedIdle;


 uint16_t DataVSpeedActual;
 uint16_t DataVSpeedDisp;

 uint8_t  DataVSpeedValid;
 uint8_t DataOverSpeed;

_Gear_Struct Gear;

 uint8_t RangeDisUpdateTime;
extern uint16_t FuelRate;
uint8_t CAN_Time_Lost_Once = 1;



_TPMS_Display_Infor Left_Front_Display;
_TPMS_Display_Infor Left_Rear_Display;
_TPMS_Display_Infor Left_Rear_Inside_Display;
_TPMS_Display_Infor Right_Front_Display;
_TPMS_Display_Infor Right_Rear_Display;
_TPMS_Display_Infor Right_Rear_Inside_Display;
_TPMS_Display_Infor TPMS_Info;
_TPMS_Display_Infor Left_Front_Display_Backup;
_TPMS_Display_Infor Left_Rear_Display_Backup;
_TPMS_Display_Infor Left_Rear_Inside_Display_Backup;
_TPMS_Display_Infor Right_Front_Display_Backup;
_TPMS_Display_Infor Right_Rear_Display_Backup;
_TPMS_Display_Infor Right_Rear_Inside_Display_Backup;
_TPMS_Display_Infor TPMS_Info_Display_Backup;

Urea_Limited_Vehicle_Speed_Struct Urea_Limited_Vehicle_Speed;
Urea_Limited_Torque_Struct Urea_Limited_Torque;
 _Can_Receive_Struct  CanReceive;
uint32_t Data_MileageRolling_Counte = 0;
uint16_t Power_OFF_Delay_Time;
void Can_Receive_Init(void)
{
	CanReceive.Can_0CF00400 = 0;
	CanReceive.Can_0A18A006 = 0;
	CanReceive.Can_18FF2100 = 0;
	CanReceive.Can_18FEEE00 = 0;
	CanReceive.Can_18FEF100 = 0;
	CanReceive.Can_18FD0700 = 0;
	CanReceive.Can_18FEFF00 = 0;
	CanReceive.Can_18FEE400 = 0;
	CanReceive.Can_18FECA00 = 0;
	CanReceive.Can_18FD7C00 = 0;
	CanReceive.Can_18FF4C00 = 0;
	//CanReceive.Can_10FF4117 = 0;
	//CanReceive.Can_18FEFC17 = 0;
	//CanReceive.Can_18FEC1EE = 0;
	CanReceive.Can_10FF1021 = 0;
	CanReceive.Can_10FF7521 = 0;
	CanReceive.Can_18FEF433 = 0;
	CanReceive.Can_18FF9CF1 = 0;
	CanReceive.Can_18FECA03 = 0;
	CanReceive.Can_18FF4453 = 0;
	CanReceive.Can_18FFA8EE = 0;
	CanReceive.Can_18FFB078 = 0;
	CanReceive.Can_18FE4A03 = 0;
	CanReceive.Can_18F00503 = 0;
	CanReceive.Can_18FF9DF1 = 0;
	CanReceive.Can_18FE5BE8 = 0;
	CanReceive.Can_10F007E8 = 0;
}


void Can_18FEEE00_Receive(void)
{
	CanReceive.Can_18FEEE00 = 1;
}
void Can_18FEF100_Receive(void)
{
	CanReceive.Can_18FEF100 = 1;
}
void Can_18FD0700_Receive(void)
{
	CanReceive.Can_18FD0700 = 1;
}
void Can_18FEFF00_Receive(void)
{
	CanReceive.Can_18FEFF00 = 1;
}
void Can_18FEE400_Receive(void)
{
	CanReceive.Can_18FEE400 = 1;
}
void Can_18FECA00_Receive(void)
{
	CanReceive.Can_18FECA00 = 1;
}
void Can_18FD7C00_Receive(void)
{
	CanReceive.Can_18FD7C00 = 1;
}
void Can_18FF4C00_Receive(void)
{
	CanReceive.Can_18FF4C00 = 1;
}
//void Can_10FF4117_Receive(void)
//{
//	CanReceive.Can_10FF4117 = 1;
//}
//void Can_18FEFC17_Receive(void)
//{
//	CanReceive.Can_18FEFC17 = 1;
//}
//void Can_18FEC1EE_Receive(void)
//{
//	CanReceive.Can_18FEC1EE = 1;
//}
void Can_10FF1021_Receive(void)
{
	CanReceive.Can_10FF1021 = 1;
}
void Can_10FF7521_Receive(void)
{
	CanReceive.Can_10FF7521 = 1;
}
void Can_18FEF433_Receive(void)
{
	CanReceive.Can_18FEF433 = 1;
}
void Can_18FF9CF1_Receive(void)
{
	CanReceive.Can_18FF9CF1 = 1;
}
void Can_18FECA03_Receive(void)
{
	CanReceive.Can_18FECA03 = 1;
}
void Can_18FF4453_Receive(void)
{
	CanReceive.Can_18FF4453 = 1;
}
void Can_18FFA8EE_Receive(void)
{
	CanReceive.Can_18FFA8EE = 1;
}
void Can_18FFB078_Receive(void)
{
	CanReceive.Can_18FFB078 = 1;
}
void Can_18FE4A03_Receive(void)
{
	CanReceive.Can_18FE4A03 = 1;
}
void Can_18F00503_Receive(void)
{
	CanReceive.Can_18F00503 = 1;
}
void Can_18FF9DF1_Receive(void)
{
	CanReceive.Can_18FF9DF1 = 1;
}

void Can_0CF00400_Receive(void)
{
	CanReceive.Can_0CF00400 = 1;
}

void Can_0A18A006_Receive(void)
{
	CanReceive.Can_0A18A006 = 1;
}

void Can_18FF2100_Receive(void)
{
	CanReceive.Can_18FF2100 = 1;
}

void Can_18FE5BE8_Receive(void)
{
	CanReceive.Can_18FE5BE8 = 1;
}

void Can_10F007E8_Receive(void)
{
	CanReceive.Can_10F007E8 = 1;
}
void Data_30KL_Init(void)
{
	PowerIgnOnTimeLine = 0;
	PowerIgnOffTimeLine = 0;
	Data_MileageRolling_Counte = 0;
	Instantaneous_Fuel_Init();
	Fuel_Range_Init();
	Can_Receive_Init();
	Urea_Init();
	Gear_Init();
	MenuData.Lost = 0;
	MenuData.Ldws = 2;
}

void Data_15KL_Init(void)
{
	Can_Receive_Init();
	Urea_Init();
	Gear_Init();
	MenuData.Lost = 0;
}

void Flash_Init(void)
{
	g_LED.LedTime_1HZ = 0;
	g_LED.LedTime_1_5HZ = 0;
	g_LED.LedTime_2HZ = 0;
	g_LED.LedBlink_1HZ = 0;
	g_LED.LedBlink_1_5HZ = 0;
	g_LED.LedBlink_2HZ = 0;
}

void Flash_Service(void)
{
	if (g_LED.LedTime_1HZ < 250)
	{
		g_LED.LedTime_1HZ++;
	}
	else
	{
		g_LED.LedTime_1HZ = 0;
		g_LED.LedBlink_1HZ = !g_LED.LedBlink_1HZ;
	}

    if (g_LED.LedTime_1_5HZ < 187)
	{
		g_LED.LedTime_1_5HZ++;
	}
	else
	{
		g_LED.LedTime_1_5HZ = 0;
		g_LED.LedBlink_1_5HZ = !g_LED.LedBlink_1_5HZ;
	}

	if (g_LED.LedTime_2HZ < 125)
	{
		g_LED.LedTime_2HZ++;
	}
	else
	{
		g_LED.LedTime_2HZ = 0;
		g_LED.LedBlink_2HZ = !g_LED.LedBlink_2HZ;
	}

}


void Common_Input_Para(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        PowerIgnOffTimeLine = 0ul;
        if ( PowerIgnOnTimeLine < 0x7ffffffful )
        {
            PowerIgnOnTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if ( PowerIgnOffTimeLine < 0x7ffffffful )
        {
            PowerIgnOffTimeLine += 2u;
        }
    }
}

void Can_RX_ResetAllTimer_Self_Check(void)
{
	if(Common_GetIgnOnTime() == 3000)
	{
		Can_RX_ResetAllTimer(CAN_CH0);
	}
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

void Vehicle_Speed_Init(void)
{
	DataVSpeedActual = 0;
	DataVSpeedDisp = 0;
	//DataVSpeedHysteresis = 0;
	DataVSpeedValid = 0;
	DataVSpeedSampler.Timer = 0;
	DataVSpeedSampler.Backup = 0;
	DataVSpeedSampler.UseBackup = 0;
	DataVSpeedSampler.Cnt = 0;
	DataVSPeedDamping.Speed = 0;
	DataVSPeedDamping.Delta = 0;
	DataVSPeedDamping.Dir = DATA_APPR_DIR_INC;
}

void Data_Vehicle_Speed_Processing_Service(void)
{
	uint8_t i;
	uint16_t Delta;
	uint32_t VSpeed;
	uint32_t ABS_vehicle_speed;
	if(Get_DIAG_Vehicle_Speedsts() == 3)
	{
		ABS_vehicle_speed = (DiagVSpeedValue[0] << 8) + DiagVSpeedValue[1];
		VSpeed = ABS_vehicle_speed;
		VSpeed *= 5;
		VSpeed >>= 3;
		DataVSpeedActual = VSpeed;
	}
	else
	{
		ABS_vehicle_speed = Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP();
		if (SYS_OPR_STAT_IGN_ON)
		{
			if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_MSG_LOST) || (ABS_vehicle_speed > 0x1FFF) || (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() == 1)||(CanReceive.Can_0A18A006 != 1))
			{
				if ((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_MSG_LOST) ||(CanReceive.Can_0A18A006 != 1))
				{
					CanReceive.Can_0A18A006 = 0;
					DataVSpeedValid = 0;
					DataVSpeedActual = 0;
					DataVSpeedSampler.Backup = 0;
				}
				else // �յ���Чֵ
				{
					/*if (DataVSpeedSampler.Timer < 100)
					{
						if (DataVSpeedValid)
						{
							DataVSpeedSampler.Timer++;
							DataVSpeedActual = DataVSpeedSampler.Backup;
						}
						else
						{
							DataVSpeedSampler.Timer = 100;
							DataVSpeedActual = 0;
							DataVSpeedSampler.Backup = 0;
						}
					}
					else // //���յ��㹻�����Чֵ*/
					{
						DataVSpeedValid = 0;
						DataVSpeedActual = 0;
						DataVSpeedSampler.Backup = 0;
					}
				}
				DataVSpeedSampler.Cnt = 0;
			}
			else
			{
				if (DataVSpeedValid == 0)
				{
					DataVSpeedValid = 1;

					VSpeed = ABS_vehicle_speed;
					VSpeed *= 5;
					VSpeed >>= 3;

					DataVSpeedActual = VSpeed;
				}
				else
				{
					DataVSpeedSampler.Buffer[DataVSpeedSampler.Cnt] = ABS_vehicle_speed;

					i = DataVSpeedSampler.Cnt;
					while ((i > 0) && (DataVSpeedSampler.Buffer[i] < DataVSpeedSampler.Buffer[i - 1]))
					{
						VSpeed = DataVSpeedSampler.Buffer[i];
						DataVSpeedSampler.Buffer[i] = DataVSpeedSampler.Buffer[i - 1];
						DataVSpeedSampler.Buffer[i - 1] = VSpeed;
						i--;
					}

					DataVSpeedSampler.Cnt++;
					if (DataVSpeedSampler.Cnt >= 3)
					{
						DataVSpeedSampler.Cnt = 0;
						VSpeed = DataVSpeedSampler.Buffer[1];
						VSpeed *= 5;
						VSpeed >>= 3;

						DataVSpeedActual = VSpeed;
					}
				}

				DataVSpeedSampler.Timer = 0;
				DataVSpeedSampler.Backup = DataVSpeedActual;
			}
		}
		else
		{
			DataVSpeedValid = 0;
			DataVSpeedActual = 0;
			DataVSpeedSampler.Timer = 0;
			DataVSpeedSampler.Cnt = 0;
			DataVSpeedSampler.Backup = 0;
		}
	}

	// ��2�������ٵ����ᴦ��
	VSpeed = DataVSpeedActual;

	if (VSpeed > DataVSPeedDamping.Speed) // ʵ��ֵ�ȵ�ǰ��ʾֵ��ʱ
	{
		Delta = VSpeed - DataVSPeedDamping.Speed;

		if (DataVSPeedDamping.Dir == DATA_APPR_DIR_INC) // ��ʾֵ������ʵ��ֵ����,��ά�ֵ�ǰ������������ٶ�
		{
			if (DataVSPeedDamping.Delta < Delta) // ��ǰ����С����ʾֵ��ʵ��ֵ�Ĳ�ֵ,���������ӵ��ٶ�
			{
				DataVSPeedDamping.Delta += DATA_VSPEED_INC_STEP;
				if (DataVSPeedDamping.Delta > Delta)
					DataVSPeedDamping.Delta = Delta;
			}
			else // ��ǰ�������ڵ�����ʾֵ��ʵ��ֵ�Ĳ�ֵ,���������뵱ǰ��ֵͬ��,���ӵ��ٶȼ��𲽼�С
				DataVSPeedDamping.Delta = Delta;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)
				Delta = DATA_VSPEED_APPR_SPEED_MIN;

			DataVSPeedDamping.Speed += Delta;
			if (DataVSPeedDamping.Speed > VSpeed)
				DataVSPeedDamping.Speed = VSpeed;
		}
		else // ��ʾֵ���ڼ�С,�򾡿�������ٶ�Ϊ��Сʱ��������
		{
			if (DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP)
				DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
			else
				DataVSPeedDamping.Delta = 0;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
				DataVSPeedDamping.Dir = DATA_APPR_DIR_INC; // ��������
			else
			{
				if (DataVSPeedDamping.Speed > Delta)
					DataVSPeedDamping.Speed -= Delta;
				else
					DataVSPeedDamping.Speed = 0;
			}
		}
	}
	else if (VSpeed < DataVSPeedDamping.Speed) // ʵ��ֵ�ȵ�ǰ��ʾֵСʱ
	{
		Delta = DataVSPeedDamping.Speed - VSpeed;

		if (DataVSPeedDamping.Dir == DATA_APPR_DIR_INC) // ��ʾֵ��������,�򾡿�������ٶ�Ϊ��Сʱ��������
		{
			if (DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP)
				DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
			else
				DataVSPeedDamping.Delta = 0;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
				DataVSPeedDamping.Dir = DATA_APPR_DIR_DEC; // ��������
			else
			{
				DataVSPeedDamping.Speed += Delta;
				if (DataVSPeedDamping.Speed > 3000)
					DataVSPeedDamping.Speed = 3000;
			}
		}
		else // ��ʾֵ������ʵ��ֵ��С,��ά�ֵ�ǰ������������ٶ�
		{
			if (DataVSPeedDamping.Delta < Delta) // ��ǰ(��)����С����ʾֵ��ʵ��ֵ�Ĳ�ֵ,��������С���ٶ�
			{
				DataVSPeedDamping.Delta += DATA_VSPEED_INC_STEP;
				if (DataVSPeedDamping.Delta > Delta)
					DataVSPeedDamping.Delta = Delta;
			}
			else // ��ǰ(��)�������ڵ�����ʾֵ��ʵ��ֵ�Ĳ�ֵ,����(��)�����뵱ǰ��ֵͬ��,��С���ٶȼ��𲽼�С
				DataVSPeedDamping.Delta = Delta;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (Delta < DATA_VSPEED_APPR_SPEED_MIN)
				Delta = DATA_VSPEED_APPR_SPEED_MIN;

			if (DataVSPeedDamping.Speed < VSpeed + Delta)
				DataVSPeedDamping.Speed = VSpeed;
			else
				DataVSPeedDamping.Speed -= Delta;
		}
	}
	else // ʵ��ֵ�뵱ǰ��ʾֵ���ʱ
	{
		Delta = DataVSPeedDamping.Delta;
		Delta /= DATA_VSPEED_DAMPING_FACTOR;

		if (Delta > DATA_VSPEED_APPR_SPEED_MIN) // ��ǰ���ٶȲ�����С,˵����ֵ��������/��С��,�����ԭ����
		{
			if (DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP) // ��ʾֵԽ����ʵ��ֵ,��ȻҪ�ȼ�������С�ٶ�,�ٸı䷽�򷵻�ʵ��ֵ
				DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
			else
				DataVSPeedDamping.Delta = 0;

			Delta = DataVSPeedDamping.Delta;
			Delta /= DATA_VSPEED_DAMPING_FACTOR;

			if (DataVSPeedDamping.Dir == DATA_APPR_DIR_INC) // ��ʾֵ��ǰ�����ӷ���
			{
				if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
					DataVSPeedDamping.Dir = DATA_APPR_DIR_DEC; // ��������
				else
				{
					DataVSPeedDamping.Speed += Delta;
					if (DataVSPeedDamping.Speed > 2400)
						DataVSPeedDamping.Speed = 2400;
				}
			}
			else // ��ʾֵ��ǰ�Ǽ�С����
			{
				if (Delta < DATA_VSPEED_APPR_SPEED_MIN)		   // �Ѽ�������С�ٶ�
					DataVSPeedDamping.Dir = DATA_APPR_DIR_INC; // ��������
				else
				{
					if (DataVSPeedDamping.Speed > Delta)
						DataVSPeedDamping.Speed -= Delta;
					else
						DataVSPeedDamping.Speed = 0;
				}
			}
		}
	}

	// ��3����������ʾ����
	//if ((DataVSPeedDamping.Speed >= DataVSpeedHysteresis) || (DataVSPeedDamping.Speed < DATA_VSPEED_HYSTERESIS))
	//{
	//	DataVSpeedHysteresis = DataVSPeedDamping.Speed;
	//}
	//else
	//{
	//	if (DataVSpeedHysteresis - DataVSPeedDamping.Speed >= DATA_VSPEED_HYSTERESIS)
	//	{
	//		DataVSpeedHysteresis = DataVSPeedDamping.Speed;
	//	}
	//}

	VSpeedCal = (uint32_t)DataVSPeedDamping.Speed;
	
	if (VSpeedCal != 0)
	{
		if(VSpeedCal < 200)
		{
			VSpeedCal *= 103;
		    VSpeedCal /= 100;
		}
		else
		{
            VSpeedCal *= 103;
		    VSpeedCal /= 100;
		    VSpeedCal += 10;
		}
	}
	else
	{
		VSpeedCal = 0;
	}

	DataVSpeedDisp = (uint16_t)VSpeedCal;

	if (DataVSpeedDisp >= 1800)
	{
		DataVSpeedDisp = 1800;
	}
}

uint16_t Common_Get_Act_V_Speed(void)
{
	return DataVSpeedActual;
}

uint8_t Common_Get_Act_V_Speed_Valid(void)
{
	if(Get_DIAG_Vehicle_Speedsts() == 3)
	{
		return DataVSpeedValid = 0;
	}
	else
	{
		return DataVSpeedValid;
	}
    
}

uint16_t Get_DispVechileSpeed(void)
{
    return DataVSpeedDisp;
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////
void Engine_Speed_Init(void )
{
	DataESpeedIdle.Timer    = 0;
    DataESpeedActual        = 0;
    DataESpeedDisp          = 0;
    DataESpeedValid         = 0;
    DataESpeedSampler.Cnt   = 0;
    DataESPeedDamping.Speed = 0;
    DataESPeedDamping.Delta = 0;
    DataESPeedDamping.Dir   = DATA_APPR_DIR_INC;

    DataESpeed.u8Can_Valid   = 0;
    DataESpeed.u16Can_Actual = 0;

    DataESpeed.u8Res_Valid   = 0;
    DataESpeed.u16Res_Actual = 0;

    DataESpeed.u8FreIn_Valid   = 0;
    DataESpeed.u16FreIn_Actual = 0; 
    DataFreESpeedSampler.Cnt   = 0;    
}


void Data_Engine_Speed_Processing_Service(void )
{
    uint8_t  i;
    uint16_t ESpeed;
    uint16_t Delta;
    uint16_t EMS_Engine_Speed;
    uint16_t EMS_FreIn_Speed;
	if(Get_DIAG_Engine_Speedsts() == 3)
	{
		EMS_Engine_Speed = (DiagESpeedValue[0] << 8) + DiagESpeedValue[1];
		ESpeed =(EMS_Engine_Speed/8);
    	if ( ESpeed > 5000 )
    	    ESpeed = 5000;
    	DataESpeed.u16Can_Actual = ESpeed;
	}
	else
	{
		EMS_Engine_Speed = Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed();

		if ( SYS_OPR_STAT_IGN_ON)
    	{
    	    if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_LOST)||( EMS_Engine_Speed >= 0xFB00))
    	    {
    	        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_LOST)
    	        {
    	            DataESpeed.u16Can_Actual = 0;
    	            DataESpeed.u8Can_Valid   = 0;
    	            DataESpeedSampler.Backup = 0;
    	        }
    	        else
    	        {
    	            /*if(DataESpeedSampler.Timer < 100)
    	            {
    	                if(DataESpeed.u8Can_Valid)
    	                {
    	                   DataESpeedSampler.Timer++;
    	                   DataESpeed.u16Can_Actual = DataESpeedSampler.Backup;
    	                }
    	                else
    	                {
    	                    DataESpeedSampler.Timer = 100 ; 
    	                    DataESpeedSampler.Backup = 0; 
    	                    DataESpeed.u16Can_Actual = 0 ;
    	                }
    	            }
    	            else*/
    	            {
    	                DataESpeed.u8Can_Valid = 0;
    	                DataESpeed.u16Can_Actual = 0;
    	                DataESpeedSampler.Backup = 0;    
    	            }
    	        }
    	        DataESpeedSampler.Cnt = 0;   
    	    }
    	    else
    	    {
    	        if ( DataESpeed.u8Can_Valid == 0 )
    	        {
    	            DataESpeed.u8Can_Valid = 1;

    	            ESpeed =(EMS_Engine_Speed/8);
    	            if ( ESpeed > 5000 )
    	                ESpeed = 5000;
    	            DataESpeed.u16Can_Actual = ESpeed;
    	        }
    	        else
    	        {
    	            DataESpeedSampler.Buffer [ DataESpeedSampler.Cnt ] = EMS_Engine_Speed;

    	            i = DataESpeedSampler.Cnt;
    	            while ( (i > 0) && (DataESpeedSampler.Buffer [ i ] < DataESpeedSampler.Buffer [ i - 1 ]) )
    	            {
    	                ESpeed                             = DataESpeedSampler.Buffer [ i ];
    	                DataESpeedSampler.Buffer [ i ]     = DataESpeedSampler.Buffer [ i - 1 ];
    	                DataESpeedSampler.Buffer [ i - 1 ] = ESpeed;
    	                i--;
    	            }

    	            DataESpeedSampler.Cnt++;
    	            if ( DataESpeedSampler.Cnt >= 5 )
    	            {
    	                DataESpeedSampler.Cnt = 0;
    	                ESpeed = DataESpeedSampler.Buffer [ 3 ]/8;
    	                if ( ESpeed > 5000 )
    	                    ESpeed = 5000;
    	                DataESpeed.u16Can_Actual = ESpeed;
    	            }
    	        }
    	    	DataESpeedSampler.Timer = 0;
    	        DataESpeedSampler.Backup = DataESpeed.u16Can_Actual;
    	    }
    	}
    	else
    	{
    	    DataESpeed.u16Can_Actual    = 0;
    	    DataESpeed.u8Can_Valid      = 0;
    	    DataESpeedSampler.Timer     = 0;
    	    DataESpeedSampler.Cnt       = 0;
    	    DataESpeedSampler.Backup    = 0;
    	}
	}

    DataESpeedActual = DataESpeed.u16Can_Actual ; 
    DataESpeedValid = DataESpeed.u8Can_Valid  ;
//
    ESpeed = DataESpeedActual;

    if ( ESpeed > DataESPeedDamping.Speed )    
    {
        Delta = ESpeed - DataESPeedDamping.Speed;

        if ( DataESPeedDamping.Dir == DATA_APPR_DIR_INC )  
        {
            if ( DataESPeedDamping.Delta < Delta )    
            {
                DataESPeedDamping.Delta += DATA_ESPEED_INC_STEP;
                if ( DataESPeedDamping.Delta > Delta )
                    DataESPeedDamping.Delta = Delta;
            }
            else    
                DataESPeedDamping.Delta = Delta;

            Delta = DataESPeedDamping.Delta;
            Delta /= DATA_ESPEED_DAMPING_FACTOR;

            if ( Delta < DATA_ESPEED_APPR_SPEED_MIN )
                Delta = DATA_ESPEED_APPR_SPEED_MIN;

            DataESPeedDamping.Speed += Delta;
            if ( DataESPeedDamping.Speed > ESpeed )
                DataESPeedDamping.Speed = ESpeed;
        }
        else  
        {
            if ( DataESPeedDamping.Delta > DATA_ESPEED_DEC_STEP )
                DataESPeedDamping.Delta -= DATA_ESPEED_DEC_STEP;
            else
                DataESPeedDamping.Delta = 0;

            Delta = DataESPeedDamping.Delta;
            Delta /= DATA_ESPEED_DAMPING_FACTOR;

            if ( Delta < DATA_ESPEED_APPR_SPEED_MIN )        
                DataESPeedDamping.Dir = DATA_APPR_DIR_INC;    
            else
            {
                if ( DataESPeedDamping.Speed > Delta )
                    DataESPeedDamping.Speed -= Delta;
                else
                    DataESPeedDamping.Speed = 0;
            }
        }
    }
    else if ( ESpeed < DataESPeedDamping.Speed )   
    {
        Delta = DataESPeedDamping.Speed - ESpeed;

        if ( DataESPeedDamping.Dir == DATA_APPR_DIR_INC )   
        {
            if ( DataESPeedDamping.Delta > DATA_ESPEED_DEC_STEP )
                DataESPeedDamping.Delta -= DATA_ESPEED_DEC_STEP;
            else
                DataESPeedDamping.Delta = 0;

            Delta = DataESPeedDamping.Delta;
            Delta /= DATA_ESPEED_DAMPING_FACTOR;

            if ( Delta < DATA_ESPEED_APPR_SPEED_MIN )       
                DataESPeedDamping.Dir = DATA_APPR_DIR_DEC;   
            else
            {
                DataESPeedDamping.Speed += Delta;
                if ( DataESPeedDamping.Speed > 5000 )
                    DataESPeedDamping.Speed = 5000;
            }
        }
        else   
        {
            if ( DataESPeedDamping.Delta < Delta )  
            {
                DataESPeedDamping.Delta += DATA_ESPEED_INC_STEP;
                if ( DataESPeedDamping.Delta > Delta )
                    DataESPeedDamping.Delta = Delta;
            }
            else    
                DataESPeedDamping.Delta = Delta;

            Delta = DataESPeedDamping.Delta;
            Delta /= DATA_ESPEED_DAMPING_FACTOR;

            if ( Delta < DATA_ESPEED_APPR_SPEED_MIN )
                Delta = DATA_ESPEED_APPR_SPEED_MIN;

            if ( DataESPeedDamping.Speed < ESpeed + Delta )
                DataESPeedDamping.Speed = ESpeed;
            else
                DataESPeedDamping.Speed -= Delta;
        }
    }
    else    
    {
        Delta = DataESPeedDamping.Delta;
        Delta /= DATA_ESPEED_DAMPING_FACTOR;

        if ( Delta > DATA_ESPEED_APPR_SPEED_MIN )    
        {
            if ( DataESPeedDamping.Delta > DATA_ESPEED_DEC_STEP )    
                DataESPeedDamping.Delta -= DATA_ESPEED_DEC_STEP;
            else
                DataESPeedDamping.Delta = 0;

            Delta = DataESPeedDamping.Delta;
            Delta /= DATA_ESPEED_DAMPING_FACTOR;

            if ( DataESPeedDamping.Dir == DATA_APPR_DIR_INC )    
            {
                if ( Delta < DATA_ESPEED_APPR_SPEED_MIN )         
                    DataESPeedDamping.Dir = DATA_APPR_DIR_DEC;   
                else
                {
                    DataESPeedDamping.Speed += Delta;
                    if ( DataESPeedDamping.Speed > 5000 )
                        DataESPeedDamping.Speed = 5000;
                }
            }
            else   
            {
                if ( Delta < DATA_ESPEED_APPR_SPEED_MIN )         
                    DataESPeedDamping.Dir = DATA_APPR_DIR_INC;    
                else
                {
                    if ( DataESPeedDamping.Speed > Delta )
                        DataESPeedDamping.Speed -= Delta;
                    else
                        DataESPeedDamping.Speed = 0;
                }
            }
        }
    }

    //delt
    if ((DataESpeedDisp <= 80) || (DataESpeedDisp >= 5000) )    
    {
        DataESpeedDisp = DataESPeedDamping.Speed;
    }
    else
    {
        if ( DataESpeedDisp < DataESPeedDamping.Speed )
        {
            DataESpeedDisp = DataESPeedDamping.Speed;
        }
        else
        {
            Delta = DataESpeedDisp - DataESPeedDamping.Speed;
            if ( Delta >= DATA_ESPEED_HYSTERESIS )
                DataESpeedDisp = DataESPeedDamping.Speed;
        }
    }       
}

uint16_t Get_ActualEngineSpeed(void)
{
	return DataESpeedActual;
}

uint16_t Get_DispEngineSpeed(void)
{
    return DataESpeedDisp;
}

uint16_t Get_DataESpeedValid(void)
{
    return DataESpeedValid;
}
/******************************************************************************

*******************************************************************************

******************************************************************************/
void Coolant_Init(void )
{
	Coolant_Temperature_st.Value = 0; 
	Coolant_Temperature_st.Valid = 0;
	Coolant_Temperature_st.Symbol = Positive; 
	Coolant_Temperature_st.LED = 0;
	Coolant_Temperature_st.FastModeCnt = 0u;
	Coolant_Temperature_st.Mode = Fast_Mode;
	Coolant_Temperature_st.DampT = 0u;
	Coolant_Temperature_st.DampTCnt = 0u;
	Coolant_Temperature_st.destPosition = 0u;
	Coolant_Temperature_st.curPosition = 0u;
}

void Data_Coolant_Temp_Processing_Service(void)
{
	uint8_t Coolant_Temperautre ;
	
	Coolant_Temperautre  =  Get_CAN_CH0_ID_18FEEE00_Sig_EngCoolantTemp();

	if (SYS_OPR_STAT_IGN_ON)
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FEEE00_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_18FEEE00 != 1)/*||(Coolant_Temperautre > 0xFA)*/)
		{
			CanReceive.Can_18FEEE00 = 0;
			Coolant_Temperature_st.Value = 0; 
			Coolant_Temperature_st.Valid = 0;
			Coolant_Temperature_st.Symbol = Positive; 
		}
		else
		{
			Coolant_Temperature_st.Valid = 1;
			if(Coolant_Temperautre >= 40)
			{
				Coolant_Temperautre -= 40;
				Coolant_Temperature_st.Symbol = Positive; 
			}
			else
			{
				Coolant_Temperautre = 40 - Coolant_Temperautre;
				Coolant_Temperature_st.Symbol = Negative; 
			}
			Coolant_Temperature_st.Value = Coolant_Temperautre; 
		}
	}
	else
	{
		Coolant_Temperature_st.Value = 0;
		Coolant_Temperature_st.Valid = 0;
		Coolant_Temperature_st.Symbol = Positive;
		Coolant_Temperature_st.LED = 0;
	}
}

uint8_t Get_Coolant_Temp_Value(void )
{
	return Coolant_Temperature_st.Value;
}

uint8_t Get_Coolant_Temp_Valid(void )
{
	return Coolant_Temperature_st.Valid;
}

uint8_t Get_Coolant_Temp_Symbol(void )
{
	return Coolant_Temperature_st.Symbol;
}
/******************************************************************************
******************************************************************************/
extern uint32_t InsFuel_Cons;
void Instantaneous_Fuel_Init(void)
{
	Data_InsFuel.Valid = 0;
	Data_InsFuel.Value = 0;
	Data_InsFuel.FreshTime = 20;
	Data_InsFuel.Display_Value = 0;	
	Data_InsFuel.Value_Last = 0;
}

void Data_Instantaneous_Fuel_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FEF200_Msg_Count) == CAN_MSG_LOST)||(Data_InsFuel.Flg_18FEF200 != 1))
		{
			Data_InsFuel.Valid = 0;	
			Data_InsFuel.Flg_18FEF200 = 0;
		}
		else
		{
			if(FuelRate < 0xFFFF)
			{
				Data_InsFuel.Valid = 1;
			}
			
			if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_0A18A006 != 1))
		    {
				Data_InsFuel.Value = InsFuel_Cons;
		    }
		    else
		    {
				if((Common_Get_Act_V_Speed() < 50)||(Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() == 1))
				{
					Data_InsFuel.Value = InsFuel_Cons;	//100p	
				}
				else
				{
					Data_InsFuel.Value = (1000 * InsFuel_Cons) / Common_Get_Act_V_Speed();//100p	
				}
		    }
		}
	}
}

void Data_Instantaneous_Fuel_Display_Service(void)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		if(Common_GetIgnOnTime() < SELF_CHECK_TIME)
		{
			Data_InsFuel.FreshTime = 20;		
		}
		else
		{
			if(Data_InsFuel.Valid)	
			{
				// if(Data_InsFuel.Value_Last != Data_InsFuel.Value)
				// {
				// 	Data_InsFuel.FreshTime = 0;
				// 	Data_InsFuel.Value_Last = Data_InsFuel.Value;
				// }

				if(Data_InsFuel.V_Speed_backup != Common_Get_Act_V_Speed( ))
				{
					if((Common_Get_Act_V_Speed( ) >= 50)&&(Data_InsFuel.V_Speed_backup < 50)) 
					{
						//Data_InsFuel.FreshTime = 0;
						Data_InsFuel.Display_Flag = 1;
					}
			
					if((Common_Get_Act_V_Speed( ) < 50)&&(Data_InsFuel.V_Speed_backup >= 50)) 
					{
						//Data_InsFuel.FreshTime = 0;
						Data_InsFuel.Display_Flag = 0;
					}
					Data_InsFuel.V_Speed_backup = Common_Get_Act_V_Speed( );
				}

				Data_InsFuel.FreshTime++;
				if(Data_InsFuel.FreshTime >= 20)//2s
				{
					Data_InsFuel.FreshTime = 0;
					Data_InsFuel.Display_Value = Data_InsFuel.Value;//100p	
					Data_InsFuel.Display_Value /= 10;//10p	
					
					Data_InsFuel.Display_Unit = Data_InsFuel.Display_Flag;
				}


				if(Data_InsFuel.Display_Value > 199)
				{
					Data_InsFuel.Display_Value = 199 ; 	
				}
			}
			else
			{
				Data_InsFuel.FreshTime = 20;	
			}
		}
	}
	else
	{
		Data_InsFuel.FreshTime = 20;		
	}
}

uint16_t Get_InsFuel_Value(void)
{
	return Data_InsFuel.Display_Value;
}

uint8_t Get_InsFuel_Valid(void)
{
	return Data_InsFuel.Valid;
}

/********************************************************************************************/
/********************************************************************************************/
void Fuel_Range_Init(void)
{
	FuelMeter.Range = 0;
	FuelMeter.RangeValid = 0;
	FuelMeter.RangeDis = 0;
	FuelMeter.LastRange = 0;
}

void Fuel_RangeDis(void)
{
	if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_0A18A006 != 1)||(Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() == 1))
	{
		FuelMeter.Range = FuelMeter.LastRange;
	}
	else
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FEF200_Msg_Count) == CAN_MSG_LOST)||(FuelMeter.Flg_18FEF200 != 1))
		{
			FuelMeter.Range = FuelMeter.LastRange;
			FuelMeter.Flg_18FEF200 = 0;
		}
		else
		{
			FuelMeter.Range = GetDRMileage();   //rang 
			FuelMeter.LastRange = FuelMeter.Range;
		}
	}

    if((MinFuelData.Sensor_State == FuelSensorOpenCircuit)||(FuelMeter.Range <= 50)||(Get_LowFuelWarningSts() == 1))
    {
        FuelMeter.RangeValid = 0;
    }
    else
    {
        FuelMeter.RangeValid = 1;
		FuelMeter.RangeDis = FuelMeter.Range;
    }
}

uint16_t GetRangeDisValue(void)
{
    if(FuelMeter.RangeDis >= 999)
    {
        FuelMeter.RangeDis = 999;
    }
    return FuelMeter.RangeDis;
}

uint8_t GetRangeValid(void)
{
	return FuelMeter.RangeValid;
}


void GUI_Sound_Init(void)
{
	MenuData.Sound = 2;
	Buzzer_Volume_Set(MenuData.Sound );
}

void GUI_Light_Init(void)
{
    g_Light.Duty = 750;
	g_nightLight.Duty = 150;
}

DataEnternightmode nightmode;
/*开启远光灯延迟2s进入夜间模式*/
void Enter_night_mode(void)
{
	if( (Get_TelltalesLedSts(m_LED_High_Lamp) == 1))
	{
		
		if(nightmode.night_mode_time < 40)
		{
			nightmode.night_mode_time++;
		}
		else
		{
			nightmode.night_mode_sta = 1;
		}
	}
 	else
	{
		nightmode.night_mode_sta = 0;
		nightmode.night_mode_time = 0;
	}

}
/*获取夜间模式状态 1进入 0不进入*/
uint32_t Get_Enter_night_mode_sta(void)
{
	return nightmode.night_mode_sta;
}

void GUI_nightLightWeakup_Init(void)
{
	g_nightLight.Duty = 150;
}
void Gui_LightProc(void)
{
	if(SYS_OPR_STAT_HALT)
    {
       return;
    }
	if (SYS_OPR_STAT_IGN_ON)
	{
		if(Get_DIAG_BACKLIGHTsts() == 3)
		{
			if(DiagBackLight == 0)
			{
				PWM_Channel_Set_Duty(1, 0);//表盘
				PWM_Channel_Set_Duty(5, 0);//3.5
    			PWM_Channel_Set_Duty(3, 0);//指针
			}
			else if(DiagBackLight == 1)
			{
				PWM_Channel_Set_Duty(3, 200);//指针
				PWM_Channel_Set_Duty(1, 200);//表盘
				PWM_Channel_Set_Duty(5, 150);//3.5
			}
			else if(DiagBackLight == 2)
			{
				PWM_Channel_Set_Duty(1, 350);//表盘
				PWM_Channel_Set_Duty(3, 300);//指针
				PWM_Channel_Set_Duty(5, 280);//3.5
			}
			else if(DiagBackLight == 3)
			{
				PWM_Channel_Set_Duty(1, 450);//表盘
				PWM_Channel_Set_Duty(3, 450);//指针
				PWM_Channel_Set_Duty(5, 400);//3.5
			}
			else if(DiagBackLight == 4)
			{
				PWM_Channel_Set_Duty(1, 550);//表盘
				PWM_Channel_Set_Duty(3, 550);//指针
				PWM_Channel_Set_Duty(5, 550);//3.5
			}
			else if(DiagBackLight == 5)
			{
				PWM_Channel_Set_Duty(1, 650);//表盘
				PWM_Channel_Set_Duty(3, 650);//指针
				PWM_Channel_Set_Duty(5, 650);//3.5
			}
			else if(DiagBackLight == 6)
			{
				PWM_Channel_Set_Duty(1, 850);//表盘
				PWM_Channel_Set_Duty(3, 850);//指针
				PWM_Channel_Set_Duty(5, 780);//3.5
			}
			else if(DiagBackLight == 7)
			{
				PWM_Channel_Set_Duty(1, 900);//表盘
				PWM_Channel_Set_Duty(3, 900);//指针
				PWM_Channel_Set_Duty(5, 900);//3.5
			}
			else
			{
				if(DiagBackLight == 8)
				{
					PWM_Channel_Set_Duty(1, 1000);//表盘
					PWM_Channel_Set_Duty(3, 1000);//指针
					PWM_Channel_Set_Duty(5, 1000);//3.5
				}
			}
		}
		else
		{
			if((Get_TelltalesLedSts(m_LED_Park_Lamp) == 1) || (Get_Enter_night_mode_sta() == 1))
			{
				switch (g_nightLight.Duty)
				{
				case 150:
					PWM_Channel_Set_Duty(3, 200);//指针
					PWM_Channel_Set_Duty(1, 200);//表盘
					PWM_Channel_Set_Duty(5, 150);//3.5
					break;
				case 250:
					PWM_Channel_Set_Duty(1, 350);//表盘
					PWM_Channel_Set_Duty(3, 300);//指针
					PWM_Channel_Set_Duty(5, 280);//3.5
					break;
				case 350:
					PWM_Channel_Set_Duty(1, 450);//表盘
					PWM_Channel_Set_Duty(3, 450);//指针
					PWM_Channel_Set_Duty(5, 400);//3.5
					break;
				case 450:
					PWM_Channel_Set_Duty(1, 550);//表盘
					PWM_Channel_Set_Duty(3, 550);//指针
					PWM_Channel_Set_Duty(5, 550);//3.5
					break;
				case 550:
					PWM_Channel_Set_Duty(1, 650);//表盘
					PWM_Channel_Set_Duty(3, 650);//指针
					PWM_Channel_Set_Duty(5, 650);//3.5
					break;
				case 650:
					PWM_Channel_Set_Duty(1, 850);//表盘
					PWM_Channel_Set_Duty(3, 850);//指针
					PWM_Channel_Set_Duty(5, 780);//3.5
					break;
				case 750:
					PWM_Channel_Set_Duty(1, 900);//表盘
					PWM_Channel_Set_Duty(3, 900);//指针
					PWM_Channel_Set_Duty(5, 900);//3.5
					break;
				case 850:
					PWM_Channel_Set_Duty(1, 1000);//表盘
					PWM_Channel_Set_Duty(3, 1000);//指针
					PWM_Channel_Set_Duty(5, 1000);//3.5
					break;
				default:
					break;
				}
				
			}
			else//close lamp
			{
				switch (g_Light.Duty)
				{
				case 150:
					PWM_Channel_Set_Duty(3, 200);//指针
					PWM_Channel_Set_Duty(1, 200);//表盘
					PWM_Channel_Set_Duty(5, 150);//3.5
					break;
				case 250:
					PWM_Channel_Set_Duty(1, 350);//表盘
					PWM_Channel_Set_Duty(3, 300);//指针
					PWM_Channel_Set_Duty(5, 280);//3.5
					break;
				case 350:
					PWM_Channel_Set_Duty(1, 450);//表盘
					PWM_Channel_Set_Duty(3, 450);//指针
					PWM_Channel_Set_Duty(5, 400);//3.5
					break;
				case 450:
					PWM_Channel_Set_Duty(1, 550);//表盘
					PWM_Channel_Set_Duty(3, 550);//指针
					PWM_Channel_Set_Duty(5, 550);//3.5
					break;
				case 550:
					PWM_Channel_Set_Duty(1, 650);//表盘
					PWM_Channel_Set_Duty(3, 650);//指针
					PWM_Channel_Set_Duty(5, 650);//3.5
					break;
				case 650:
					PWM_Channel_Set_Duty(1, 850);//表盘
					PWM_Channel_Set_Duty(3, 850);//指针
					PWM_Channel_Set_Duty(5, 780);//3.5
					break;
				case 750:
					PWM_Channel_Set_Duty(1, 900);//表盘
					PWM_Channel_Set_Duty(3, 900);//指针
					PWM_Channel_Set_Duty(5, 900);//3.5
					break;
				case 850:
					PWM_Channel_Set_Duty(1, 1000);//表盘
					PWM_Channel_Set_Duty(3, 1000);//指针
					PWM_Channel_Set_Duty(5, 1000);//3.5
					break;
				default:
					break;
				}
				// }
				// else
				// {
				// 	PWM_Channel_Set_Duty(1, 0);//表盘
    			//     PWM_Channel_Set_Duty(3, 0);//指针
				// }
			}
		}
	}
	else
	{
		if((Pop_Alarm_Get_Current() == POP_ALARM_POSITION_LIGHT)||(Pop_Alarm_Get_Current() == POP_ALARM_KEY))
		{
			if((Get_TelltalesLedSts(m_LED_Park_Lamp) == 1) || (Get_Enter_night_mode_sta() == 1))
			{
				switch (g_nightLight.Duty)
				{
				case 150: 
					PWM_Channel_Set_Duty(5, 150);//3.5
					break;
				case 250:
					PWM_Channel_Set_Duty(5, 280);//3.5
					break;
				case 350:
					PWM_Channel_Set_Duty(5, 400);//3.5
					break;
				case 450:
					PWM_Channel_Set_Duty(5, 550);//3.5
					break;
				case 550:
					PWM_Channel_Set_Duty(5, 650);//3.5
					break;
				case 650:
					PWM_Channel_Set_Duty(5, 780);//3.5
					break;
				case 750:
					PWM_Channel_Set_Duty(5, 900);//3.5
					break;
				case 850:
					PWM_Channel_Set_Duty(5, 1000);//3.5
					break;
				default:
					break;
				}
			}
			else
			{
				switch (g_Light.Duty)
				{
				case 150:
					PWM_Channel_Set_Duty(5, 150);//3.5
					break;
				case 250:
					PWM_Channel_Set_Duty(5, 280);//3.5
					break;
				case 350:
					PWM_Channel_Set_Duty(5, 400);//3.5
					break;
				case 450:
					PWM_Channel_Set_Duty(5, 550);//3.5
					break;
				case 550:
					PWM_Channel_Set_Duty(5, 650);//3.5
					break;
				case 650:
					PWM_Channel_Set_Duty(5, 780);//3.5
					break;
				case 750:
					PWM_Channel_Set_Duty(5, 900);//3.5
					break;
				case 850:
					PWM_Channel_Set_Duty(5, 1000);//3.5
					break;
				default:
					break;
				}
			}
			
		}
		else
		{
			if (Common_GetIgnOffTime() >= 20000)
			{
				PWM_Channel_Set_Duty(5, 0);//3.5
			}
			else
			{
				if((Get_TelltalesLedSts(m_LED_Park_Lamp) == 1) || (Get_Enter_night_mode_sta() == 1))
				{
					switch (g_nightLight.Duty)
					{
					case 150: 
						PWM_Channel_Set_Duty(5, 150);//3.5
						break;
					case 250:
						PWM_Channel_Set_Duty(5, 280);//3.5
						break;
					case 350:
						PWM_Channel_Set_Duty(5, 400);//3.5
						break;
					case 450:
						PWM_Channel_Set_Duty(5, 550);//3.5
						break;
					case 550:
						PWM_Channel_Set_Duty(5, 650);//3.5
						break;
					case 650:
						PWM_Channel_Set_Duty(5, 780);//3.5
						break;
					case 750:
						PWM_Channel_Set_Duty(5, 900);//3.5
						break;
					case 850:
						PWM_Channel_Set_Duty(5, 1000);//3.5
						break;
					default:
						break;
					}
				}
				else
				{
					switch (g_Light.Duty)
					{
					case 150:
						PWM_Channel_Set_Duty(5, 150);//3.5
						break;
					case 250:
						PWM_Channel_Set_Duty(5, 280);//3.5
						break;
					case 350:
						PWM_Channel_Set_Duty(5, 400);//3.5
						break;
					case 450:
						PWM_Channel_Set_Duty(5, 550);//3.5
						break;
					case 550:
						PWM_Channel_Set_Duty(5, 650);//3.5
						break;
					case 650:
						PWM_Channel_Set_Duty(5, 780);//3.5
						break;
					case 750:
						PWM_Channel_Set_Duty(5, 900);//3.5
						break;
					case 850:
						PWM_Channel_Set_Duty(5, 1000);//3.5
						break;
					default:
						break;
					}
				}
			}
		}
		PWM_Channel_Set_Duty(1, 0);//表盘
    	PWM_Channel_Set_Duty(3, 0);//指针
	}
}

void Data_TPMS_30_15KL_Processing(void)
{
	TPMS_Info.Pop_Check = 0;

	Left_Front_Display.LED_Blink = 0;
	Left_Rear_Display.LED_Blink = 0;
	Left_Rear_Inside_Display.LED_Blink = 0;
	Right_Front_Display.LED_Blink = 0;
	Right_Rear_Display.LED_Blink = 0;
	Right_Rear_Inside_Display.LED_Blink = 0;

	Left_Front_Display.Press_Valid = 0;
	Left_Rear_Display.Press_Valid = 0;
	Left_Rear_Inside_Display.Press_Valid = 0;
	Right_Front_Display.Press_Valid = 0;
	Right_Rear_Display.Press_Valid = 0;
	Right_Rear_Inside_Display.Press_Valid = 0;

	Left_Front_Display.Press_Value = 0;
	Left_Rear_Display.Press_Value = 0;
	Left_Rear_Inside_Display.Press_Value = 0;
	Right_Front_Display.Press_Value = 0;
	Right_Rear_Display.Press_Value = 0;
	Right_Rear_Inside_Display.Press_Value = 0;

	Left_Front_Display.Temp_Valid = 0;
	Left_Rear_Display.Temp_Valid = 0;
	Left_Rear_Inside_Display.Temp_Valid = 0;
	Right_Front_Display.Temp_Valid = 0;
	Right_Rear_Display.Temp_Valid = 0;
	Right_Rear_Inside_Display.Temp_Valid = 0;

	Left_Front_Display.Temp_Symbol = 0;
	Left_Rear_Display.Temp_Symbol = 0;
	Left_Rear_Inside_Display.Temp_Symbol = 0;
	Right_Front_Display.Temp_Symbol = 0;
	Right_Rear_Display.Temp_Symbol = 0;
	Right_Rear_Inside_Display.Temp_Symbol = 0;

	Left_Front_Display.Temp_Value = 0;
	Left_Rear_Display.Temp_Value = 0;
	Left_Rear_Inside_Display.Temp_Value = 0;
	Right_Front_Display.Temp_Value = 0;
	Right_Rear_Display.Temp_Value = 0;
	Right_Rear_Inside_Display.Temp_Value = 0;

	Left_Front_Display.Press_St = 0;
	Left_Front_Display.Temp_St = 0;
	Left_Front_Display.Fast_Press = 0;
	Left_Front_Display.Sensor_Loss = 0;

	Left_Rear_Display.Press_St = 0;
	Left_Rear_Display.Temp_St = 0;
	Left_Rear_Display.Fast_Press = 0;
	Left_Rear_Display.Sensor_Loss = 0;

	Left_Rear_Inside_Display.Press_St = 0;
	Left_Rear_Inside_Display.Temp_St = 0;
	Left_Rear_Inside_Display.Fast_Press = 0;
	Left_Rear_Inside_Display.Sensor_Loss = 0;

	Right_Front_Display.Press_St = 0;
	Right_Front_Display.Temp_St = 0;
	Right_Front_Display.Fast_Press = 0;
	Right_Front_Display.Sensor_Loss = 0;

	Right_Rear_Inside_Display.Press_St = 0;
	Right_Rear_Inside_Display.Temp_St = 0;
	Right_Rear_Inside_Display.Fast_Press = 0;
	Right_Rear_Inside_Display.Sensor_Loss = 0;

	Right_Rear_Display.Press_St = 0;
	Right_Rear_Display.Temp_St = 0;
	Right_Rear_Display.Fast_Press = 0;
	Right_Rear_Display.Sensor_Loss = 0;

	Left_Front_Display.Wheel_ID_Time = 0;
	Left_Rear_Display.Wheel_ID_Time = 0;
	Left_Rear_Inside_Display.Wheel_ID_Time = 0;
	Right_Front_Display.Wheel_ID_Time = 0;
	Right_Rear_Display.Wheel_ID_Time = 0;
	Right_Rear_Inside_Display.Wheel_ID_Time = 0;


	Left_Front_Display.Wheel_ID_OutTime = 0;
	Left_Rear_Display.Wheel_ID_OutTime = 0;
	Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
	Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
	Right_Front_Display.Wheel_ID_OutTime = 0;
	Right_Rear_Display.Wheel_ID_OutTime = 0;
}

void Data_TPMS_Value_Processing(void)
{
	uint8_t BCM_XX_TPMS_Wheel_ID;
	uint8_t BCM_XX_TPMS_SensorLoss_St;
	uint8_t BCM_XX_TPMS_FastLoss_St;
	uint8_t BCM_XX_TPMS_Temp_St;
	uint8_t BCM_XX_TPMS_Press_St;

	INT16U BCM_XX_TyrePressure;
	INT16U BCM_XX_TyreTemp;

	BCM_XX_TPMS_Wheel_ID = Get_CAN_CH0_ID_18FEF433_Sig_TireLocation();
	BCM_XX_TPMS_SensorLoss_St = Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelSensorStatus();
	BCM_XX_TPMS_FastLoss_St = Get_CAN_CH0_ID_18FEF433_Sig_CTITireStatus();
	BCM_XX_TPMS_Temp_St = Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelEndElectricalFault();
	BCM_XX_TPMS_Press_St = Get_CAN_CH0_ID_18FEF433_Sig_TirePressureThresholdDetection();

	BCM_XX_TyrePressure = Get_CAN_CH0_ID_18FEF433_Sig_TirePressure();
	BCM_XX_TyreTemp = Get_CAN_CH0_ID_18FEF433_Sig_TireTemperature();
	
	if (SYS_OPR_STAT_IGN_ON)
	{
		if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_18FEF433 != 1))
		{
			CanReceive.Can_18FEF433 = 0;
			TPMS_Info.TPMS_Valid = 0;
			TPMS_Info.Press_Valid = 0;
			TPMS_Info.Temp_Valid = 0;
			TPMS_Info.Temp_Symbol = Positive;
			TPMS_Info.Wheel_ID = 0xff;
			TPMS_Info.Temp_Value = 0;
			TPMS_Info.Press_Value = 0;

			TPMS_Info.Press_St = BCM_XX_TPMS_Press_St;
			TPMS_Info.Temp_St = BCM_XX_TPMS_Temp_St;
			TPMS_Info.Fast_Press = BCM_XX_TPMS_FastLoss_St;
			TPMS_Info.Sensor_Loss = BCM_XX_TPMS_SensorLoss_St;
		}
		else
		{
			TPMS_Info.TPMS_Valid = 1;

			if (BCM_XX_TyreTemp == 0xFFFF)
			{
				TPMS_Info.Temp_Valid = 0;
			}
			else
			{
				BCM_XX_TyreTemp >>= 5;
				if (BCM_XX_TyreTemp >= 273)
				{
					TPMS_Info.Temp_Value = BCM_XX_TyreTemp - 273;
					TPMS_Info.Temp_Symbol = Positive;
					if (TPMS_Info.Temp_Value >= 126)
					{
						TPMS_Info.Temp_Value = 126;
					}
				}
				else
				{
					TPMS_Info.Temp_Value = 273 - BCM_XX_TyreTemp;
					TPMS_Info.Temp_Symbol = Negative;
					if (TPMS_Info.Temp_Value >= 99)
					{
						TPMS_Info.Temp_Value = 99;
					}
				}

				TPMS_Info.Temp_Valid = 1;
			}

			if (BCM_XX_TyrePressure == 0xFF)
			{
				TPMS_Info.Press_Valid = 0;
			}
			else
			{
				BCM_XX_TyrePressure *= 4;
				TPMS_Info.Press_Valid = 1;
				TPMS_Info.Press_Value = BCM_XX_TyrePressure;
				if (TPMS_Info.Press_Value > 999)
				{
					TPMS_Info.Press_Value = 999;
				}
			}
			TPMS_Info.Wheel_ID = BCM_XX_TPMS_Wheel_ID;
			TPMS_Info.Sensor_Loss = BCM_XX_TPMS_SensorLoss_St;
			TPMS_Info.Fast_Press = BCM_XX_TPMS_FastLoss_St;
			TPMS_Info.Temp_St = BCM_XX_TPMS_Temp_St;
			TPMS_Info.Press_St = BCM_XX_TPMS_Press_St;
		}
	}

	if (SYS_OPR_STAT_IGN_ON)
	{
		if (TPMS_Info.TPMS_Valid == 1)
		{
			if (TPMS_Info.Wheel_ID == 0x00) //Left_Front
			{
				Left_Front_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
				Left_Front_Display.Fast_Press = TPMS_Info.Fast_Press;
				Left_Front_Display.Temp_St = TPMS_Info.Temp_St;
				Left_Front_Display.Press_St = TPMS_Info.Press_St;
				if (TPMS_Info.Press_Valid == 1)
				{
					Left_Front_Display.Press_Valid = 1;
					Left_Front_Display.Press_Value = TPMS_Info.Press_Value;
				}
				else
				{
					Left_Front_Display.Press_Valid = 0;
				}

				if (TPMS_Info.Temp_Valid == 1)
				{
					Left_Front_Display.Temp_Valid = 1;
					Left_Front_Display.Temp_Value = TPMS_Info.Temp_Value;
					Left_Front_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
				}
				else
				{
					Left_Front_Display.Temp_Valid = 0;
					Left_Front_Display.Temp_Symbol = Positive;
				}

				if(TPMS_Info.Sensor_Loss == 0)
				{
					Left_Front_Display.Temp_Valid = 0;
					Left_Front_Display.Press_Valid = 0;
					Left_Front_Display.LED_Blink = 1;
				}
				else
				{
					if((Left_Front_Display.Fast_Press == 1)||(Left_Front_Display.Temp_St == 1)||
					   (Left_Front_Display.Press_St == 0) || (Left_Front_Display.Press_St == 4))
					{
						Left_Front_Display.LED_Blink = 2; 
					}
					else
					{
						Left_Front_Display.LED_Blink = 0;
					}
				}
				/*Left_Front_Display.Wheel_ID_Time++;
				Left_Rear_Display.Wheel_ID_Time = 0;
				Left_Rear_Inside_Display.Wheel_ID_Time = 0;
				Right_Front_Display.Wheel_ID_Time = 0;
				Right_Rear_Display.Wheel_ID_Time = 0;
				Right_Rear_Inside_Display.Wheel_ID_Time = 0;

				Left_Front_Display.Wheel_ID_OutTime = 0;
				if(Left_Front_Display.Wheel_ID_Time >= 50)
				{
					Left_Front_Display.Wheel_ID_Time = 50;
					
					Left_Rear_Display.Wheel_ID_OutTime = 1;
					Right_Front_Display.Wheel_ID_OutTime = 1;
					Right_Rear_Display.Wheel_ID_OutTime = 1;
					
					if(Get_NodeConfig_TPMS() == 1)
					{
						Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
						Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
					}
					else
					{
						if(Get_NodeConfig_TPMS() == 2)
						{
							Right_Rear_Inside_Display.Wheel_ID_OutTime = 1;
							Left_Rear_Inside_Display.Wheel_ID_OutTime = 1;
						}
					}
				}*/
			}
			else
			{
				if (TPMS_Info.Wheel_ID == 0x01) //Right_Front
				{
					Right_Front_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
					Right_Front_Display.Fast_Press = TPMS_Info.Fast_Press;
					Right_Front_Display.Temp_St = TPMS_Info.Temp_St;
					Right_Front_Display.Press_St = TPMS_Info.Press_St;
					if (TPMS_Info.Press_Valid == 1)
					{
						Right_Front_Display.Press_Valid = 1;
						Right_Front_Display.Press_Value = TPMS_Info.Press_Value;
					}
					else
					{
						Right_Front_Display.Press_Valid = 0;
					}

					if (TPMS_Info.Temp_Valid == 1)
					{
						Right_Front_Display.Temp_Valid = 1;
						Right_Front_Display.Temp_Value = TPMS_Info.Temp_Value;
						Right_Front_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
					}
					else
					{
						Right_Front_Display.Temp_Valid = 0;
						Right_Front_Display.Temp_Symbol = Positive;
					}

					if(TPMS_Info.Sensor_Loss == 0)
					{
						Right_Front_Display.Temp_Valid = 0;
						Right_Front_Display.Press_Valid = 0;
						Right_Front_Display.LED_Blink = 1;
					}
					else
					{
						if((Right_Front_Display.Fast_Press == 1)||(Right_Front_Display.Temp_St == 1)||
						   (Right_Front_Display.Press_St == 0) || (Right_Front_Display.Press_St == 4))
						{
							Right_Front_Display.LED_Blink = 2; 
						}
						else
						{
							Right_Front_Display.LED_Blink = 0;
						}
					}

					/*Right_Front_Display.Wheel_ID_Time++;
					Left_Front_Display.Wheel_ID_Time = 0;
					Left_Rear_Display.Wheel_ID_Time = 0;
					Left_Rear_Inside_Display.Wheel_ID_Time = 0;
					Right_Rear_Display.Wheel_ID_Time = 0;
					Right_Rear_Inside_Display.Wheel_ID_Time = 0;

					Right_Front_Display.Wheel_ID_OutTime = 0;
					if(Right_Front_Display.Wheel_ID_Time >= 50)
					{
						Right_Front_Display.Wheel_ID_Time = 50;

						Left_Front_Display.Wheel_ID_OutTime = 1;
						Left_Rear_Display.Wheel_ID_OutTime = 1;
						Right_Rear_Display.Wheel_ID_OutTime = 1;
						
						if(Get_NodeConfig_TPMS() == 1)
						{
							Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
							Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
						}
						else
						{
							if(Get_NodeConfig_TPMS() == 2)
							{
								Right_Rear_Inside_Display.Wheel_ID_OutTime = 1;
								Left_Rear_Inside_Display.Wheel_ID_OutTime = 1;
							}
						}
					}*/
				}
				else
				{
					if (TPMS_Info.Wheel_ID == 0x10) // Left_Rear
					{
						Left_Rear_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
						Left_Rear_Display.Fast_Press = TPMS_Info.Fast_Press;
						Left_Rear_Display.Temp_St = TPMS_Info.Temp_St;
						Left_Rear_Display.Press_St = TPMS_Info.Press_St;
						if (TPMS_Info.Press_Valid == 1)
						{
							Left_Rear_Display.Press_Valid = 1;
							Left_Rear_Display.Press_Value = TPMS_Info.Press_Value;
						}
						else
						{
							Left_Rear_Display.Press_Valid = 0;
						}

						if (TPMS_Info.Temp_Valid == 1)
						{
							Left_Rear_Display.Temp_Valid = 1;
							Left_Rear_Display.Temp_Value = TPMS_Info.Temp_Value;
							Left_Rear_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
						}
						else
						{
							Left_Rear_Display.Temp_Valid = 0;
							Left_Rear_Display.Temp_Symbol = Positive;
						}

						if(TPMS_Info.Sensor_Loss == 0)
						{
							Left_Rear_Display.Temp_Valid = 0;
							Left_Rear_Display.Press_Valid = 0;
							Left_Rear_Display.LED_Blink = 1;
						}
						else
						{
							if((Left_Rear_Display.Fast_Press == 1)||(Left_Rear_Display.Temp_St == 1)||
							   (Left_Rear_Display.Press_St == 0) || (Left_Rear_Display.Press_St == 4))
							{
								Left_Rear_Display.LED_Blink = 2; 
							}
							else
							{
								Left_Rear_Display.LED_Blink = 0;
							}
						}

						/*Left_Rear_Display.Wheel_ID_Time++;
						Left_Front_Display.Wheel_ID_Time = 0;
						Left_Rear_Inside_Display.Wheel_ID_Time = 0;
						Right_Front_Display.Wheel_ID_Time = 0;
						Right_Rear_Display.Wheel_ID_Time = 0;
						Right_Rear_Inside_Display.Wheel_ID_Time = 0;

						Left_Rear_Display.Wheel_ID_OutTime = 0;
						if(Left_Rear_Display.Wheel_ID_Time >= 50)
						{
							Left_Rear_Display.Wheel_ID_Time = 50;

							Left_Front_Display.Wheel_ID_OutTime = 1;
							Right_Front_Display.Wheel_ID_OutTime = 1;
							Right_Rear_Display.Wheel_ID_OutTime = 1;
							if(Get_NodeConfig_TPMS() == 1)
							{
								Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
								Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
							}
							else
							{
								if(Get_NodeConfig_TPMS() == 2)
								{
									Right_Rear_Inside_Display.Wheel_ID_OutTime = 1;
									Left_Rear_Inside_Display.Wheel_ID_OutTime = 1;
								}
							}
						}*/
					}
					else
					{
						if(Get_NodeConfig_TPMS() == 2)
						{
							if (TPMS_Info.Wheel_ID == 0x11) // Left_Rear_Inside
							{
								Left_Rear_Inside_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
								Left_Rear_Inside_Display.Fast_Press = TPMS_Info.Fast_Press;
								Left_Rear_Inside_Display.Temp_St = TPMS_Info.Temp_St;
								Left_Rear_Inside_Display.Press_St = TPMS_Info.Press_St;
								if (TPMS_Info.Press_Valid == 1)
								{
									Left_Rear_Inside_Display.Press_Valid = 1;
									Left_Rear_Inside_Display.Press_Value = TPMS_Info.Press_Value;
								}
								else
								{
									Left_Rear_Inside_Display.Press_Valid = 0;
								}
	
								if (TPMS_Info.Temp_Valid == 1)
								{
									Left_Rear_Inside_Display.Temp_Valid = 1;
									Left_Rear_Inside_Display.Temp_Value = TPMS_Info.Temp_Value;
									Left_Rear_Inside_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
								}
								else
								{
									Left_Rear_Inside_Display.Temp_Valid = 0;
									Left_Rear_Inside_Display.Temp_Symbol = Positive;
								}
	
								if(TPMS_Info.Sensor_Loss == 0)
								{
									Left_Rear_Inside_Display.Temp_Valid = 0;
									Left_Rear_Inside_Display.Press_Valid = 0;
									Left_Rear_Inside_Display.LED_Blink = 1;
								}
								else
								{
									if((Left_Rear_Inside_Display.Fast_Press == 1)||(Left_Rear_Inside_Display.Temp_St == 1)||
									   (Left_Rear_Inside_Display.Press_St == 0) || (Left_Rear_Inside_Display.Press_St == 4))
									{
										Left_Rear_Inside_Display.LED_Blink = 2; 
									}
									else
									{
										Left_Rear_Inside_Display.LED_Blink = 0;
									}
								}
	
								/*Left_Rear_Inside_Display.Wheel_ID_Time++;
								Left_Front_Display.Wheel_ID_Time = 0;
								Left_Rear_Display.Wheel_ID_Time = 0;
								Right_Front_Display.Wheel_ID_Time = 0;
								Right_Rear_Display.Wheel_ID_Time = 0;
								Right_Rear_Inside_Display.Wheel_ID_Time = 0;
	
								Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
								if(Left_Rear_Inside_Display.Wheel_ID_Time >= 50)
								{
									Left_Rear_Inside_Display.Wheel_ID_Time = 50;
	
									Left_Front_Display.Wheel_ID_OutTime = 1;
								    Left_Rear_Display.Wheel_ID_OutTime = 1;
									Right_Front_Display.Wheel_ID_OutTime = 1;
									Right_Rear_Display.Wheel_ID_OutTime = 1;
									Right_Rear_Inside_Display.Wheel_ID_OutTime = 1;
								}*/	
							}
							else
							{
								if (TPMS_Info.Wheel_ID == 0x12) //Right_Rear_Inside
								{
									Right_Rear_Inside_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
									Right_Rear_Inside_Display.Fast_Press = TPMS_Info.Fast_Press;
									Right_Rear_Inside_Display.Temp_St = TPMS_Info.Temp_St;
									Right_Rear_Inside_Display.Press_St = TPMS_Info.Press_St;
									if (TPMS_Info.Press_Valid == 1)
									{
										Right_Rear_Inside_Display.Press_Valid = 1;
										Right_Rear_Inside_Display.Press_Value = TPMS_Info.Press_Value;
									}
									else
									{
										Right_Rear_Inside_Display.Press_Valid = 0;
									}
	
									if (TPMS_Info.Temp_Valid == 1)
									{
										Right_Rear_Inside_Display.Temp_Valid = 1;
										Right_Rear_Inside_Display.Temp_Value = TPMS_Info.Temp_Value;
										Right_Rear_Inside_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
									}
									else
									{
										Right_Rear_Inside_Display.Temp_Valid = 0;
										Right_Rear_Inside_Display.Temp_Symbol = Positive;
									}
	
									if(TPMS_Info.Sensor_Loss == 0)
									{
										Right_Rear_Inside_Display.Temp_Valid = 0;
										Right_Rear_Inside_Display.Press_Valid = 0;
										Right_Rear_Inside_Display.LED_Blink = 1;
									}
									else
									{
										if((Right_Rear_Inside_Display.Fast_Press == 1)||(Right_Rear_Inside_Display.Temp_St == 1)||
										   (Right_Rear_Inside_Display.Press_St == 0) || (Right_Rear_Inside_Display.Press_St == 4))
										{
											Right_Rear_Inside_Display.LED_Blink = 2; 
										}
										else
										{
											Right_Rear_Inside_Display.LED_Blink = 0;
										}
									}
	
									/*Right_Rear_Inside_Display.Wheel_ID_Time++;
									Left_Front_Display.Wheel_ID_Time = 0;
									Left_Rear_Display.Wheel_ID_Time = 0;
									Left_Rear_Inside_Display.Wheel_ID_Time = 0;
									Right_Front_Display.Wheel_ID_Time = 0;
									Right_Rear_Display.Wheel_ID_Time = 0;
					
									Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
									if(Right_Rear_Inside_Display.Wheel_ID_Time >= 50)
									{
										Right_Rear_Inside_Display.Wheel_ID_Time = 50;
	
										Left_Front_Display.Wheel_ID_OutTime = 1;
									    Left_Rear_Display.Wheel_ID_OutTime = 1;
									    Left_Rear_Inside_Display.Wheel_ID_OutTime = 1;
										Right_Front_Display.Wheel_ID_OutTime = 1;
										Right_Rear_Display.Wheel_ID_OutTime = 1;
									}*/
								}
								else
								{
									if (TPMS_Info.Wheel_ID == 0x13) //Right_Rear
									{
										Right_Rear_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
										Right_Rear_Display.Fast_Press = TPMS_Info.Fast_Press;
										Right_Rear_Display.Temp_St = TPMS_Info.Temp_St;
										Right_Rear_Display.Press_St = TPMS_Info.Press_St;
										if (TPMS_Info.Press_Valid == 1)
										{
											Right_Rear_Display.Press_Valid = 1;
											Right_Rear_Display.Press_Value = TPMS_Info.Press_Value;
										}
										else
										{
											Right_Rear_Display.Press_Valid = 0;
										}
	
										if (TPMS_Info.Temp_Valid == 1)
										{
											Right_Rear_Display.Temp_Valid = 1;
											Right_Rear_Display.Temp_Value = TPMS_Info.Temp_Value;
											Right_Rear_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
										}
										else
										{
											Right_Rear_Display.Temp_Valid = 0;
											Right_Rear_Display.Temp_Symbol = Positive;
										}
	
										if(TPMS_Info.Sensor_Loss == 0)
										{
											Right_Rear_Display.Temp_Valid = 0;
											Right_Rear_Display.Press_Valid = 0;
											Right_Rear_Display.LED_Blink = 1;
										}
										else
										{
											if((Right_Rear_Display.Fast_Press == 1)||(Right_Rear_Display.Temp_St == 1)||
											   (Right_Rear_Display.Press_St == 0) || (Right_Rear_Display.Press_St == 4))
											{
												Right_Rear_Display.LED_Blink = 2; 
											}
											else
											{
												Right_Rear_Display.LED_Blink = 0;
											}
										}
	
										/*Right_Rear_Display.Wheel_ID_Time++;									
										Left_Front_Display.Wheel_ID_Time = 0;
										Left_Rear_Display.Wheel_ID_Time = 0;
										Left_Rear_Inside_Display.Wheel_ID_Time = 0;
										Right_Front_Display.Wheel_ID_Time = 0;
										Right_Rear_Inside_Display.Wheel_ID_Time = 0;									
	
										Right_Rear_Display.Wheel_ID_OutTime = 0;
										if(Right_Rear_Display.Wheel_ID_Time >= 50)
										{
											Right_Rear_Display.Wheel_ID_Time = 50;
	
											Left_Front_Display.Wheel_ID_OutTime = 1;
										    Left_Rear_Display.Wheel_ID_OutTime = 1;
										    Left_Rear_Inside_Display.Wheel_ID_OutTime = 1;
											Right_Front_Display.Wheel_ID_OutTime = 1;
											Right_Rear_Inside_Display.Wheel_ID_OutTime = 1;
										}*/
									}
								}
							}		
						}
						else  
						{
							if(Get_NodeConfig_TPMS() == 1)
							{
								if (TPMS_Info.Wheel_ID == 0x11) //Right_Rear
								{
									Right_Rear_Display.Sensor_Loss = TPMS_Info.Sensor_Loss;
									Right_Rear_Display.Fast_Press = TPMS_Info.Fast_Press;
									Right_Rear_Display.Temp_St = TPMS_Info.Temp_St;
									Right_Rear_Display.Press_St = TPMS_Info.Press_St;
									if (TPMS_Info.Press_Valid == 1)
									{
										Right_Rear_Display.Press_Valid = 1;
										Right_Rear_Display.Press_Value = TPMS_Info.Press_Value;
									}
									else
									{
										Right_Rear_Display.Press_Valid = 0;
									}
	
									if (TPMS_Info.Temp_Valid == 1)
									{
										Right_Rear_Display.Temp_Valid = 1;
										Right_Rear_Display.Temp_Value = TPMS_Info.Temp_Value;
										Right_Rear_Display.Temp_Symbol = TPMS_Info.Temp_Symbol;
									}
									else
									{
										Right_Rear_Display.Temp_Valid = 0;
										Right_Rear_Display.Temp_Symbol = Positive;
									}
	
									if(TPMS_Info.Sensor_Loss == 0)
									{
										Right_Rear_Display.Temp_Valid = 0;
										Right_Rear_Display.Press_Valid = 0;
										Right_Rear_Display.LED_Blink = 1;
									}
									else
									{
										if((Right_Rear_Display.Fast_Press == 1)||(Right_Rear_Display.Temp_St == 1)||
										   (Right_Rear_Display.Press_St == 0) || (Right_Rear_Display.Press_St == 4))
										{
											Right_Rear_Display.LED_Blink = 2; 
										}
										else
										{
											Right_Rear_Display.LED_Blink = 0;
										}
									}
	
									/*Right_Rear_Display.Wheel_ID_Time++;
									Left_Front_Display.Wheel_ID_Time = 0;
									Left_Rear_Display.Wheel_ID_Time = 0;
									Left_Rear_Inside_Display.Wheel_ID_Time = 0;
									Right_Front_Display.Wheel_ID_Time = 0;
									Right_Rear_Inside_Display.Wheel_ID_Time = 0;
	
									Right_Rear_Display.Wheel_ID_OutTime = 0;
									if(Right_Rear_Display.Wheel_ID_Time >= 50)
									{
										Right_Rear_Display.Wheel_ID_Time = 50;
	
										Left_Front_Display.Wheel_ID_OutTime = 1;
									    Left_Rear_Display.Wheel_ID_OutTime = 1;
									    Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
										Right_Front_Display.Wheel_ID_OutTime = 1;
										Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
									}*/	
								}
							}
						}
					}
				}
			}

			if(Get_NodeConfig_TPMS() == 1)
			{
				if((TPMS_Info.Wheel_ID == 0xFF)||
				(((BCM_XX_TyrePressure == 0xFF)&&(BCM_XX_TyreTemp == 0xFFFF))&&
				((TPMS_Info.Wheel_ID == 0x00)||
				(TPMS_Info.Wheel_ID == 0x01)||
				(TPMS_Info.Wheel_ID == 0x10)||
				(TPMS_Info.Wheel_ID == 0x11))))
				{
					TPMS_Info.Pop_Check = 1;
				}
				else
				{
					TPMS_Info.Pop_Check = 0;
				}
			}
			else
			{
				if(Get_NodeConfig_TPMS() == 2)
				{
					if((TPMS_Info.Wheel_ID == 0xFF)||
					(((BCM_XX_TyrePressure == 0xFF)&&(BCM_XX_TyreTemp == 0xFFFF))&&
					((TPMS_Info.Wheel_ID == 0x00)||
					(TPMS_Info.Wheel_ID == 0x01)||
					(TPMS_Info.Wheel_ID == 0x10)||
					(TPMS_Info.Wheel_ID == 0x11)||
					(TPMS_Info.Wheel_ID == 0x12)||
					(TPMS_Info.Wheel_ID == 0x13))))
					{
						TPMS_Info.Pop_Check = 1;
					}
					else
					{
						TPMS_Info.Pop_Check = 0;
					}
				}
			}
		}
		else //TPMS_Info.TPMS_Valid = 0
		{
			TPMS_Info.Pop_Check = 0;

			Left_Front_Display.LED_Blink = 0;
			Left_Rear_Display.LED_Blink = 0;
			Left_Rear_Inside_Display.LED_Blink = 0;
			Right_Front_Display.LED_Blink = 0;
			Right_Rear_Display.LED_Blink = 0;
			Right_Rear_Inside_Display.LED_Blink = 0;

			Left_Front_Display.Press_Valid = 0;
			Left_Rear_Display.Press_Valid = 0;
			Left_Rear_Inside_Display.Press_Valid = 0;
			Right_Front_Display.Press_Valid = 0;
			Right_Rear_Display.Press_Valid = 0;
			Right_Rear_Inside_Display.Press_Valid = 0;

			Left_Front_Display.Press_Value = 0;
			Left_Rear_Display.Press_Value = 0;
			Left_Rear_Inside_Display.Press_Value = 0;
			Right_Front_Display.Press_Value = 0;
			Right_Rear_Display.Press_Value = 0;
			Right_Rear_Inside_Display.Press_Value = 0;

			Left_Front_Display.Temp_Valid = 0;
			Left_Rear_Display.Temp_Valid = 0;
			Left_Rear_Inside_Display.Temp_Valid = 0;
			Right_Front_Display.Temp_Valid = 0;
			Right_Rear_Display.Temp_Valid = 0;
			Right_Rear_Inside_Display.Temp_Valid = 0;

			Left_Front_Display.Temp_Symbol = 0;
			Left_Rear_Display.Temp_Symbol = 0;
			Left_Rear_Inside_Display.Temp_Symbol = 0;
			Right_Front_Display.Temp_Symbol = 0;
			Right_Rear_Display.Temp_Symbol = 0;
			Right_Rear_Inside_Display.Temp_Symbol = 0;

			Left_Front_Display.Temp_Value = 0;
			Left_Rear_Display.Temp_Value = 0;
			Left_Rear_Inside_Display.Temp_Value = 0;
			Right_Front_Display.Temp_Value = 0;
			Right_Rear_Display.Temp_Value = 0;
			Right_Rear_Inside_Display.Temp_Value = 0;

			Left_Front_Display.Press_St = 0;
			Left_Front_Display.Temp_St = 0;
			Left_Front_Display.Fast_Press = 0;
			Left_Front_Display.Sensor_Loss = 0;

			Left_Rear_Display.Press_St = 0;
			Left_Rear_Display.Temp_St = 0;
			Left_Rear_Display.Fast_Press = 0;
			Left_Rear_Display.Sensor_Loss = 0;

			Left_Rear_Inside_Display.Press_St = 0;
			Left_Rear_Inside_Display.Temp_St = 0;
			Left_Rear_Inside_Display.Fast_Press = 0;
			Left_Rear_Inside_Display.Sensor_Loss = 0;

			Right_Front_Display.Press_St = 0;
			Right_Front_Display.Temp_St = 0;
			Right_Front_Display.Fast_Press = 0;
			Right_Front_Display.Sensor_Loss = 0;

			Right_Rear_Inside_Display.Press_St = 0;
			Right_Rear_Inside_Display.Temp_St = 0;
			Right_Rear_Inside_Display.Fast_Press = 0;
			Right_Rear_Inside_Display.Sensor_Loss = 0;

			Right_Rear_Display.Press_St = 0;
			Right_Rear_Display.Temp_St = 0;
			Right_Rear_Display.Fast_Press = 0;
			Right_Rear_Display.Sensor_Loss = 0;

			Left_Front_Display.Wheel_ID_Time = 0;
			Left_Rear_Display.Wheel_ID_Time = 0;
			Left_Rear_Inside_Display.Wheel_ID_Time = 0;
			Right_Front_Display.Wheel_ID_Time = 0;
			Right_Rear_Display.Wheel_ID_Time = 0;
			Right_Rear_Inside_Display.Wheel_ID_Time = 0;

			Left_Front_Display.Wheel_ID_OutTime = 0;
			Left_Rear_Display.Wheel_ID_OutTime = 0;
			Right_Front_Display.Wheel_ID_OutTime = 0;
			Right_Rear_Display.Wheel_ID_OutTime = 0;
			Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
			Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
		}
	}
	else // igoff
	{
		TPMS_Info.TPMS_Valid = 0;
		TPMS_Info.Pop_Check = 0;

		Left_Front_Display.LED_Blink = 0;
		Left_Rear_Display.LED_Blink = 0;
		Left_Rear_Inside_Display.LED_Blink = 0;
		Right_Front_Display.LED_Blink = 0;
		Right_Rear_Display.LED_Blink = 0;
		Right_Rear_Inside_Display.LED_Blink = 0;

		Left_Front_Display.Press_Valid = 0;
		Left_Rear_Display.Press_Valid = 0;
		Left_Rear_Inside_Display.Press_Valid = 0;
		Right_Front_Display.Press_Valid = 0;
		Right_Rear_Display.Press_Valid = 0;
		Right_Rear_Inside_Display.Press_Valid = 0;

		Left_Front_Display.Press_Value = 0;
		Left_Rear_Display.Press_Value = 0;
		Left_Rear_Inside_Display.Press_Value = 0;
		Right_Front_Display.Press_Value = 0;
		Right_Rear_Display.Press_Value = 0;
		Right_Rear_Inside_Display.Press_Value = 0;

		Left_Front_Display.Temp_Valid = 0;
		Left_Rear_Display.Temp_Valid = 0;
		Left_Rear_Inside_Display.Temp_Valid = 0;
		Right_Front_Display.Temp_Valid = 0;
		Right_Rear_Display.Temp_Valid = 0;
		Right_Rear_Inside_Display.Temp_Valid = 0;

		Left_Front_Display.Temp_Symbol = 0;
		Left_Rear_Display.Temp_Symbol = 0;
		Left_Rear_Inside_Display.Temp_Symbol = 0;
		Right_Front_Display.Temp_Symbol = 0;
		Right_Rear_Display.Temp_Symbol = 0;
		Right_Rear_Inside_Display.Temp_Symbol = 0;

		Left_Front_Display.Temp_Value = 0;
		Left_Rear_Display.Temp_Value = 0;
		Left_Rear_Inside_Display.Temp_Value = 0;
		Right_Front_Display.Temp_Value = 0;
		Right_Rear_Display.Temp_Value = 0;
		Right_Rear_Inside_Display.Temp_Value = 0;

		Left_Front_Display.Press_St = 0;
		Left_Front_Display.Temp_St = 0;
		Left_Front_Display.Fast_Press = 0;
		Left_Front_Display.Sensor_Loss = 0;

		Left_Rear_Display.Press_St = 0;
		Left_Rear_Display.Temp_St = 0;
		Left_Rear_Display.Fast_Press = 0;
		Left_Rear_Display.Sensor_Loss = 0;

		Left_Rear_Inside_Display.Press_St = 0;
		Left_Rear_Inside_Display.Temp_St = 0;
		Left_Rear_Inside_Display.Fast_Press = 0;
		Left_Rear_Inside_Display.Sensor_Loss = 0;

		Right_Front_Display.Press_St = 0;
		Right_Front_Display.Temp_St = 0;
		Right_Front_Display.Fast_Press = 0;
		Right_Front_Display.Sensor_Loss = 0;

		Right_Rear_Inside_Display.Press_St = 0;
		Right_Rear_Inside_Display.Temp_St = 0;
		Right_Rear_Inside_Display.Fast_Press = 0;
		Right_Rear_Inside_Display.Sensor_Loss = 0;

		Right_Rear_Display.Press_St = 0;
		Right_Rear_Display.Temp_St = 0;
		Right_Rear_Display.Fast_Press = 0;
		Right_Rear_Display.Sensor_Loss = 0;

		Left_Front_Display.Wheel_ID_Time = 0;
		Left_Rear_Display.Wheel_ID_Time = 0;
		Left_Rear_Inside_Display.Wheel_ID_Time = 0;
		Right_Front_Display.Wheel_ID_Time = 0;
		Right_Rear_Display.Wheel_ID_Time = 0;
		Right_Rear_Inside_Display.Wheel_ID_Time = 0;
	

		Left_Front_Display.Wheel_ID_OutTime = 0;
		Left_Rear_Display.Wheel_ID_OutTime = 0;
		Right_Front_Display.Wheel_ID_OutTime = 0;
		Right_Rear_Display.Wheel_ID_OutTime = 0;
		Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
		Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
	}
}

void TPMS_Tyre_Lost(void)
{
	if(Get_NodeConfig_TPMS() == 1)
	{
		Right_Rear_Inside_Display.Wheel_ID_Time_Lost = 0;
		Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
		Left_Rear_Inside_Display.Wheel_ID_Time_Lost = 0;
		Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;

		if(TPMS_Info.Wheel_ID != 0x00)
		{
			if(Left_Front_Display.Wheel_ID_Time_Lost < 100)
			{
				Left_Front_Display.Wheel_ID_Time_Lost++;
			}
		}
		else
		{
			Left_Front_Display.Wheel_ID_Time_Lost = 0;
			Left_Front_Display.Wheel_ID_OutTime = 0;
		}

		if(Left_Front_Display.Wheel_ID_Time_Lost >= 50)
		{
			Left_Front_Display.Wheel_ID_OutTime = 1;
		}

		if(TPMS_Info.Wheel_ID != 0x01)
		{
			if(Right_Front_Display.Wheel_ID_Time_Lost < 100)
			{
				Right_Front_Display.Wheel_ID_Time_Lost++;
			}
		}
		else
		{
			Right_Front_Display.Wheel_ID_Time_Lost = 0;
			Right_Front_Display.Wheel_ID_OutTime = 0;
		}

		if(Right_Front_Display.Wheel_ID_Time_Lost >= 50)
		{
			Right_Front_Display.Wheel_ID_OutTime = 1;
		}

		if(TPMS_Info.Wheel_ID != 0x10)
		{
			if(Left_Rear_Display.Wheel_ID_Time_Lost < 100)
			{
				Left_Rear_Display.Wheel_ID_Time_Lost++;
			}
		}
		else
		{
			Left_Rear_Display.Wheel_ID_Time_Lost = 0;
			Left_Rear_Display.Wheel_ID_OutTime = 0;
		}

		if(Left_Rear_Display.Wheel_ID_Time_Lost >= 50)
		{
			Left_Rear_Display.Wheel_ID_OutTime = 1;
		}

		if(TPMS_Info.Wheel_ID != 0x11)
		{
			if(Right_Rear_Display.Wheel_ID_Time_Lost < 100)
			{
				Right_Rear_Display.Wheel_ID_Time_Lost++;
			}
		}
		else
		{
			Right_Rear_Display.Wheel_ID_Time_Lost = 0;
			Right_Rear_Display.Wheel_ID_OutTime = 0;
		}

		if(Right_Rear_Display.Wheel_ID_Time_Lost >= 50)
		{
			Right_Rear_Display.Wheel_ID_OutTime = 1;
		}
	}
	else
	{
		if(Get_NodeConfig_TPMS() == 2)
		{
			if(TPMS_Info.Wheel_ID != 0x00)
			{
				if(Left_Front_Display.Wheel_ID_Time_Lost < 100)
				{
					Left_Front_Display.Wheel_ID_Time_Lost++;
				}
			}
			else
			{
				Left_Front_Display.Wheel_ID_Time_Lost = 0;
				Left_Front_Display.Wheel_ID_OutTime = 0;
			}

			if(Left_Front_Display.Wheel_ID_Time_Lost >= 50)
			{
				Left_Front_Display.Wheel_ID_OutTime = 1;
			}

			if(TPMS_Info.Wheel_ID != 0x01)
			{
				if(Right_Front_Display.Wheel_ID_Time_Lost < 100)
				{
					Right_Front_Display.Wheel_ID_Time_Lost++;
				}
			}
			else
			{
				Right_Front_Display.Wheel_ID_Time_Lost = 0;
				Right_Front_Display.Wheel_ID_OutTime = 0;
			}

			if(Right_Front_Display.Wheel_ID_Time_Lost >= 50)
			{
				Right_Front_Display.Wheel_ID_OutTime = 1;
			}

			if(TPMS_Info.Wheel_ID != 0x10)
			{
				if(Left_Rear_Display.Wheel_ID_Time_Lost < 100)
				{
					Left_Rear_Display.Wheel_ID_Time_Lost++;
				}
			}
			else
			{
				Left_Rear_Display.Wheel_ID_Time_Lost = 0;
				Left_Rear_Display.Wheel_ID_OutTime = 0;
			}

			if(Left_Rear_Display.Wheel_ID_Time_Lost >= 50)
			{
				Left_Rear_Display.Wheel_ID_OutTime = 1;
			}

			if(TPMS_Info.Wheel_ID != 0x11)
			{
				if(Left_Rear_Inside_Display.Wheel_ID_Time_Lost < 100)
				{
					Left_Rear_Inside_Display.Wheel_ID_Time_Lost++;
				}
			}
			else
			{
				Left_Rear_Inside_Display.Wheel_ID_Time_Lost = 0;
				Left_Rear_Inside_Display.Wheel_ID_OutTime = 0;
			}

			if(Left_Rear_Inside_Display.Wheel_ID_Time_Lost >= 50)
			{
				Left_Rear_Inside_Display.Wheel_ID_OutTime = 1;
			}

			if(TPMS_Info.Wheel_ID != 0x12)
			{
				if(Right_Rear_Inside_Display.Wheel_ID_Time_Lost < 100)
				{
					Right_Rear_Inside_Display.Wheel_ID_Time_Lost++;
				}
			}
			else
			{
				Right_Rear_Inside_Display.Wheel_ID_Time_Lost = 0;
				Right_Rear_Inside_Display.Wheel_ID_OutTime = 0;
			}
	
			if(Right_Rear_Inside_Display.Wheel_ID_Time_Lost >= 50)
			{
				Right_Rear_Inside_Display.Wheel_ID_OutTime = 1;
			}

			if(TPMS_Info.Wheel_ID != 0x13)
			{
				if(Right_Rear_Display.Wheel_ID_Time_Lost < 100)
				{
					Right_Rear_Display.Wheel_ID_Time_Lost++;
				}
			}
			else
			{
				Right_Rear_Display.Wheel_ID_Time_Lost = 0;
				Right_Rear_Display.Wheel_ID_OutTime = 0;
			}
	
			if(Right_Rear_Display.Wheel_ID_Time_Lost >= 50)
			{
				Right_Rear_Display.Wheel_ID_OutTime = 1;
			}
		}
	}
}


void Urea_Init(void)
{
	Urea_st.Value = 0; 
	Urea_st.Valid = 0;
	Urea_st.Icon = 1;
	Urea_st.FastModeCnt = 0u;
    Urea_st.Mode = Fast_Mode;
    Urea_st.DampT = 0u;
    Urea_st.DampTCnt = 0u;
    Urea_st.destPosition = 0u;
    Urea_st.curPosition = 0u;
	Urea_Limited_Torque.Valid = 0;
	Urea_Limited_Torque.Hour = 0;
	Urea_Limited_Torque.Min = 0;	
	Urea_Limited_Vehicle_Speed.Valid = 0;
	Urea_Limited_Vehicle_Speed.Hour= 0;
	Urea_Limited_Vehicle_Speed.Min  = 0;
}

void Data_Urea_Processing_Service(void)
{
	INT16U Urea;
	Urea =  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Tank_Fluid_Level();//10p
	Urea *= 4;
	if (SYS_OPR_STAT_IGN_ON)
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FF4C00_Msg_Count) == CAN_MSG_LOST))
		{
			Urea_st.Value = 0; 
			Urea_st.Valid = 0;
			Urea_st.Icon = g_LED.LedBlink_1HZ;
			Urea_st.destPosition = 0;
			Urea_st.curPosition = 0;
		}
		else
		{
			if(Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Tank_Fluid_Level() > 0xFA)
			{
				Urea_st.Icon = 1;
				Urea_st.destPosition = 0;
				Urea_st.curPosition = 0;
			}
			else
			{
				Urea_st.Value = Urea;
				Urea_st.Valid = 1;
				if(Urea_st.Valid)
				{
					HYS_Physical_Quantity_Input(HYS_UREA, Urea_st.Value);
					Urea_st.destPosition = HYS_Get_Seg(HYS_UREA);
				}
				else
				{
					Urea_st.destPosition = 0;
				}

				if(Urea_st.curPosition < Urea_st.destPosition)
    			{
    			    if(Urea_st.DampTCnt >= Urea_st.DampT)
    			    {
    			        if(Urea_st.curPosition < 100)
    			        {
    			            Urea_st.curPosition++;
    			        }
						Urea_st.DampTCnt = 0;
    			    }
    			    else
    			    {
    			        Urea_st.DampTCnt++;
    			    }
    			}
    			else if(Urea_st.curPosition > Urea_st.destPosition)
    			{
    			    if(Urea_st.DampTCnt >= Urea_st.DampT)
    			    {
    			        if(Urea_st.curPosition)
    			        {
    			            Urea_st.curPosition--;
    			        }
						Urea_st.DampTCnt = 0;
    			    }
    			    else
    			    {
    			        Urea_st.DampTCnt++;
    			    }
    			}
    			else
    			{
    			    Urea_st.DampTCnt = 0;
    			}

				if(Urea_st.curPosition <= 1)
				{
					Urea_st.Icon = g_LED.LedBlink_1HZ;
				}
				else
				{
					Urea_st.Icon = 1;
				}
			}
		}
	}
}

void Damping_Data_Renew_Mode(uint8_t Valid, uint8_t FastModeDurtion, uint16_t *FastModeTimeCnt,  uint8_t *Mode)
{
    if(Valid)
    {
        if(*FastModeTimeCnt >= FastModeDurtion)
        {
            *Mode = Buffered_Mode;
        }
        else
        {
            (*FastModeTimeCnt)++;
            *Mode = Fast_Mode;
        }
    }
    else
    {
        *Mode = Fast_Mode;
        *FastModeTimeCnt = 0;                                 
    }
}

uint8_t Get_Urea_curPosition(void )
{
    return Urea_st.curPosition;
}

uint8_t Get_Urea_Valid(void )
{
    return Urea_st.Valid;
}

void Data_Urea_Limited_Torque(void)
{
	Urea_Limited_Torque.Hour = Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Hours_Before_Limited_Torque();
	Urea_Limited_Torque.Min = Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Minutes_Before_Limited_Torque();
	if (SYS_OPR_STAT_IGN_ON)
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FF4C00_Msg_Count) == CAN_MSG_LOST)||(Urea_Limited_Torque.Hour > 0x3E)||(Urea_Limited_Torque.Min > 0x3B))
		{
			Urea_Limited_Torque.Valid = 0;
		}
		else
		{
			Urea_Limited_Torque.Valid = 1;
		}
	}
}

void Data_Urea_Limited_Vehicle_Speed(void)
{
	Urea_Limited_Vehicle_Speed.Hour = Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Hours_Before_Limited_Vehicle_Speed();
	Urea_Limited_Vehicle_Speed.Min = Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Minutes_Before_Limited_Vehicle_Speed();
	if (SYS_OPR_STAT_IGN_ON)
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FF4C00_Msg_Count) == CAN_MSG_LOST)||(Urea_Limited_Vehicle_Speed.Hour > 0x3E)||(Urea_Limited_Vehicle_Speed.Min > 0x3B))
		{
			Urea_Limited_Vehicle_Speed.Valid = 0;
		}
		else
		{
			Urea_Limited_Vehicle_Speed.Valid = 1;
		}
	}
}

void Gear_Init(void)
{
	Gear.Valid = 0;
	Gear.Blink = 0;
	Gear.Mode = GEAR_Max;
}

void Data_Gear_Processing_Service(void)
{
	if (SYS_OPR_STAT_IGN_ON)
	{
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FE4A03_Msg_Count) == CAN_MSG_LOST)||(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18F00503_Msg_Count) == CAN_MSG_LOST))
		{
			Gear.Valid = 0;
			Gear.Blink = g_LED.LedBlink_1HZ;
		}
		else
		{
			if(Get_CAN_CH0_ID_18FE4A03_Sig_TransmMode1Ind() != 1)
			{
				if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7c)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_R;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7d)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_N;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7e)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_1;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7f)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_2;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x80)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_3;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x81)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_4;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x82)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_5;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x83)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_6;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x84)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_7;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x85)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_8;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0xFB)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_P;
				}
				else
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_Max;
				}
			}
			else
			{
				if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7c)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_R;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7d)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_N;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7e)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x7f)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x80)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x81)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x82)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x83)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x84)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0x85)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_D;
				}
				else if(Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear() == 0xFB)
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_P;
				}
				else
				{
					Gear.Valid = 1;
					Gear.Mode = GEAR_Max;
				}
			}
		}
	}
	else
	{
		Gear.Valid = 0;
	}
}

uint8_t GET_Gear_Mode(void)
{
	return Gear.Mode;
}

uint8_t GET_Gear_Valid(void)
{
	return Gear.Valid;
}

uint8_t GET_Gear_Blink(void)
{
	return Gear.Blink;
}

void Can18FF9CF1_Lost(void)
{
	if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST)||(CanReceive.Can_18FF9CF1 != 1))
	{
		CanReceive.Can_18FF9CF1 = 0;
		MenuData.Lost++;
		if(MenuData.Lost >= 450)
		{
			MenuData.Lost = 450;
		}
	}
	else
	{
		MenuData.Lost = 0;
	}
}
extern uint16_t LocalMinOfs_TBOX;
extern uint16_t LocalHrOfs_TBOX;
void RTC_TIME_Processing_Service(void)
{
	if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9DF1_Msg_Count) == CAN_SIG_LOST)||
	   (CanReceive.Can_18FF9DF1 != 1)||
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX() > 0XEC) || 
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX() > 0X3B) || 
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX() > 0X17) || 
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() > 0x0C)||
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() < 1)|| 
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() > 0x7C)||
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() < 1)|| 
	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX() > 0xFA)||
	   (LocalMinOfs_TBOX > 0xb8)||(LocalMinOfs_TBOX < 0x42)||
	   (LocalHrOfs_TBOX > 0x94)||(LocalHrOfs_TBOX < 0x66))
	{
		if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9DF1_Msg_Count) == CAN_SIG_LOST)
		{
			CanReceive.Can_18FF9DF1 = 0;
		}
		
		//只有掉线才能加5s,在线发错误值不能加5s,错误值时自动计时,但不能加5s
		if(((Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX() > 0XEC) || 
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX() > 0X3B) || 
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX() > 0X17) || 
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() > 0x0C)||
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() < 1)|| 
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() > 0x7C)||
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() < 1)|| 
	    (Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX() > 0xFA)||
	    (LocalMinOfs_TBOX > 0xb8)||(LocalMinOfs_TBOX < 0x42)||
	    (LocalHrOfs_TBOX > 0x94)||(LocalHrOfs_TBOX < 0x66))&&
		((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9DF1_Msg_Count) == CAN_SIG_NORMAL)))
	    {
			Can_Time_Normal = 1;
	    }
	   
		RTC_Get_Time();
		if((Menu_Get_Current_Cursor_Information() != MENU_ITEM_SET_TimeHour)&&(Menu_Get_Current_Cursor_Information() != MENU_ITEM_SET_TimeMin))
		{
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 1);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 1);
			MenuData.Hour = RTC_HOUR;
			MenuData.Minute = RTC_MINUTE;
		}
	}
	else//9DF1 在线
	{	
		//9CF1 掉线				
		if( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST )/*&&(MenuData.Lost >= 450)*/)
		{
			RTC_Get_Time();
			if((Menu_Get_Current_Cursor_Information() != MENU_ITEM_SET_TimeHour)&&(Menu_Get_Current_Cursor_Information() != MENU_ITEM_SET_TimeMin))
			{
				MenuData.Hour = RTC_HOUR;
				MenuData.Minute = RTC_MINUTE;
				Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 1);
				Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 1);
			}
		}
		else //都在线
		{
			if(Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts() == 1)//No
			{	
				Can_Time_Normal = 1;//tbox状态无效,自动累计时间,不加5s,只有掉线加5s
				RTC_Get_Time();
				//MenuData.Year = RTC_YEAR;
				//MenuData.Month = RTC_MONTH;
				//MenuData.Date = RTC_DATE;
				//MenuData.Seconds = RTC_SECOND;
				if((Menu_Get_Current_Cursor_Information() != MENU_ITEM_SET_TimeHour)&&(Menu_Get_Current_Cursor_Information() != MENU_ITEM_SET_TimeMin))
				{
					MenuData.Hour = RTC_HOUR;
					MenuData.Minute = RTC_MINUTE;
					Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 1);
					Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 1);
				}
			}
			else//0 2 3 Yes
			{
				Can_Time_Normal = 0;//都在线,刷新状态
				CAN_Time_Lost_Once = 0;//都在线,刷新状态
				Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 0);
				Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 0);
					
				RTC_YEAR = Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX(); 
				if(RTC_YEAR >= 15)
				{
					RTC_YEAR -= 15;
				}
				else
				{
					RTC_YEAR = 0;
				}
				RTC_MONTH = Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX();
				RTC_DATE = Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() / 4;
				RTC_HOUR = Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX();
				RTC_MINUTE = Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX();
				RTC_SECOND = Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX() / 4;

				MenuData.LeapYear = Determine_Leap_Year(RTC_YEAR+2000);
				if(RTC_MONTH == 2)
				{
					if(MenuData.LeapYear)
					{
						if(RTC_DATE > 29)
						{
							RTC_Get_Time();
							Can_Time_Normal = 1;
							return;
						}
					}
					else
					{
						if(RTC_DATE > 28)
						{
							RTC_Get_Time();
							Can_Time_Normal = 1;
							return;
						}
					}
				}
				else
				{
					if(((RTC_MONTH == 4)||(RTC_MONTH == 6)||(RTC_MONTH == 9)||(RTC_MONTH == 11))&&(RTC_DATE >= 31))
					{
						RTC_Get_Time();
						Can_Time_Normal = 1;
						return;
					}
				}
				
				MenuData.Hour_Local_Offset = Get_CAN_CH0_ID_18FF9DF1_Sig_LocalHrOfs_TBOX();
				MenuData.Minute_Local_Offset = Get_CAN_CH0_ID_18FF9DF1_Sig_LocalMinOfs_TBOX();
				if(MenuData.Hour_Local_Offset >= 125)
				{
					MenuData.Hour_Local_Offset -= 125;
					MenuData.Hour_Local_Offset_Symbol = Positive; 
				}
				else
				{
					MenuData.Hour_Local_Offset = 125 - MenuData.Hour_Local_Offset;
					MenuData.Hour_Local_Offset_Symbol = Negative; 
				}

				if(MenuData.Minute_Local_Offset >= 125)
				{
					MenuData.Minute_Local_Offset -= 125;
					MenuData.Minute_Local_Offset_Symbol = Positive; 
				}
				else
				{
					MenuData.Minute_Local_Offset = 125 - MenuData.Minute_Local_Offset;
					MenuData.Minute_Local_Offset_Symbol = Negative; 
				}

				if(((MenuData.Hour_Local_Offset <= 23)&&((MenuData.Hour_Local_Offset_Symbol == Positive)||(MenuData.Hour_Local_Offset_Symbol == Negative)))&&
	   			   (MenuData.Minute_Local_Offset <= 59)&&((MenuData.Minute_Local_Offset_Symbol == Positive)||(MenuData.Minute_Local_Offset_Symbol == Negative)))
				{
					MenuData_Time_Service();
				}
				RTC_Set_Time((uint8_t*)&g_stRTCInformation);
			}
		}
	}
}

void MenuData_Time_Service(void)
{
    if ((RTC_YEAR+2000) != MenuData.BackupYear) 
    {
      MenuData.LeapYear = Determine_Leap_Year(RTC_YEAR+2000);
      MenuData.BackupYear = RTC_YEAR+2000;
    }

	if(MenuData.Minute_Local_Offset_Symbol == Negative)
	{
		if(RTC_MINUTE >= MenuData.Minute_Local_Offset)
		{
			RTC_MINUTE -= MenuData.Minute_Local_Offset;
		}
		else
		{
			if(RTC_HOUR >= 1)
			{
				RTC_HOUR -= 1;
				RTC_MINUTE += 60;
			}
			else//小时等于0时,借天
			{
				if(RTC_DATE > 1)
				{
					RTC_DATE -= 1;
					RTC_HOUR += 23;
					RTC_MINUTE += 60;
				}
				else//天等于0时,借月
				{
					if((RTC_MONTH == 2)||(RTC_MONTH == 4)||(RTC_MONTH == 6)||(RTC_MONTH == 8)||(RTC_MONTH == 9)||(RTC_MONTH == 11))
					{
						RTC_MONTH -= 1;
						RTC_DATE += 30;
						RTC_HOUR += 23;
						RTC_MINUTE += 60;
					}
					else if((RTC_MONTH == 5)||(RTC_MONTH == 7)||(RTC_MONTH == 10)||(RTC_MONTH == 12))
					{
						RTC_MONTH -= 1;
						RTC_DATE += 29;
						RTC_HOUR += 23;
						RTC_MINUTE += 60;
					}
					else if(RTC_MONTH == 3)
					{
						if(MenuData.LeapYear)
						{
							RTC_MONTH -= 1;
							RTC_DATE += 28;
							RTC_HOUR += 23;
							RTC_MINUTE += 60;
						}
						else
						{
							RTC_MONTH -= 1;
							RTC_DATE += 27;
							RTC_HOUR += 23;
							RTC_MINUTE += 60;
						}
					}
					else//1月
					{
						if(RTC_YEAR >= 1)
						{
							RTC_YEAR -= 1;
							RTC_MONTH += 11;
							RTC_DATE += 30;
							RTC_HOUR += 23;
							RTC_MINUTE += 60;
						}
						else
						{
							;
						}
					}
				}
			}
			
			if(RTC_MINUTE >= MenuData.Minute_Local_Offset)
			{
				RTC_MINUTE -= MenuData.Minute_Local_Offset;
			}
		}
	}
	else
	{
		RTC_MINUTE += MenuData.Minute_Local_Offset;
	}
   
	if (RTC_MINUTE >= 60)
	{
	  RTC_HOUR   += RTC_MINUTE / 60;
	  RTC_MINUTE  = RTC_MINUTE % 60;
	}
	
	if(MenuData.Hour_Local_Offset_Symbol == Negative)
	{
		if(RTC_HOUR >= MenuData.Hour_Local_Offset)
		{
			RTC_HOUR -= MenuData.Hour_Local_Offset;
		}
		else
		{
			if(RTC_DATE > 1)
			{
				RTC_DATE -= 1;
				RTC_HOUR += 24;
			}
			else//天等于0时,借月
			{
				if((RTC_MONTH == 2)||(RTC_MONTH == 4)||(RTC_MONTH == 6)||(RTC_MONTH == 8)||(RTC_MONTH == 9)||(RTC_MONTH == 11))
				{
					RTC_MONTH -= 1;
					RTC_DATE += 30;
					RTC_HOUR += 24;
				}
				else if((RTC_MONTH == 5)||(RTC_MONTH == 7)||(RTC_MONTH == 10)||(RTC_MONTH == 12))
				{
					RTC_MONTH -= 1;
					RTC_DATE += 29;
					RTC_HOUR += 24;
				}
				else if(RTC_MONTH == 3)
				{
					if(MenuData.LeapYear)
					{
						RTC_MONTH -= 1;
						RTC_DATE += 28;
						RTC_HOUR += 24;
					}
					else
					{
						RTC_MONTH -= 1;
						RTC_DATE += 27;
						RTC_HOUR += 24;
					}
				}
				else//1月
				{
					if(RTC_YEAR >= 1)
					{
						RTC_YEAR -= 1;
						RTC_MONTH += 11;
						RTC_DATE += 30;
						RTC_HOUR += 24;
					}
					else
					{
						;
					}
				}
			}
			
			if(RTC_HOUR >= MenuData.Hour_Local_Offset)
			{
				RTC_HOUR -= MenuData.Hour_Local_Offset;
			}
		}
	}
	else
	{
		RTC_HOUR += MenuData.Hour_Local_Offset;
	}
	if (RTC_HOUR >= 24)
	{
	  RTC_DATE += RTC_HOUR / 24;
	  RTC_HOUR  = RTC_HOUR % 24;
	}
	
	switch (RTC_MONTH)
	{
	  case 1  :
	  case 3  : 
	  case 5  :
	  case 7  :
	  case 8  :
	  case 10 :
	  case 12 :
	  			if (RTC_DATE > 31)
	            {
	              RTC_DATE = 1;
	              RTC_MONTH++;
	            }
	            break;
	
	  case 4  :
	  case 6  :
	  case 9  :
	  case 11 : 
	  			if (RTC_DATE > 30)
	            {
	              RTC_DATE = 1;
	              RTC_MONTH++;
	            }
	            break;
	
	  case 2  : if (MenuData.LeapYear)
	            {
	              if (RTC_DATE > 29)
	              {
	                RTC_DATE = 1;
	                RTC_MONTH++;
	              }
	            }
	            else
	            {
	              if (RTC_DATE > 28)
	              {
	                RTC_DATE = 1;
	                RTC_MONTH++;
	              }
	            }
	            break; 
	}

	if (RTC_MONTH > 12)
	{
	  RTC_MONTH = 1;
	  RTC_YEAR++;
	  MenuData.LeapYear = Determine_Leap_Year(RTC_YEAR+2000);
	  MenuData.BackupYear = RTC_YEAR+2000;
	}

}

void Power_Management_Time_Handle(void)			      
{
	if (SYS_OPR_STAT_IGN_OFF)
	{
		if (Power_OFF_Delay_Time <= 300)
		{
			Power_OFF_Delay_Time++;
		}
	}
    else
    {
        Power_OFF_Delay_Time = 0;
    }
}

uint16_t Get_OFF_FUEL_Dely_Time(void)
{
    return Power_OFF_Delay_Time;
}


#if 1
void Data_Clear_Trip(void)
{
	Mileage_Modify_Index_Value(MILE_INDEX_TRAP_A, 0);
	AvgSpeed.Valid   = 0;
} 
void Data_Clear_Odo(void)
{
	if((Mile_Get_Index_Value(MILE_INDEX_ODO) <= 2000)&&(u8MileODORelated[8]==0U))
	{
		u8MileODORelated[8]=1;
		NVM_Data_Update(NVM_INDEX_ODO_CLR);
		Mileage_Modify_Index_Value(MILE_INDEX_TRAP_A, 0);
		Mileage_Modify_Index_Value(MILE_INDEX_ODO, 0);
		AvgSpeed.Valid   = 0;
		Maint_Reset(0);
	}
}
void Data_Clear_Ins_fuel(void)
{
	Data_InsFuel.Value = 0;
	Data_InsFuel.Display_Value = 0;
}
extern AFC_INIT MinAFCInit;
void Data_Clear_Avg_fuel(void)	
{
	//Data_AvgFuel_A_KL30_Init();
	g_aveFuel.ValueA = 130;
	g_aveFuel.ValueA_Dis = 130;
	g_aveFuel.ValidA_Dis = 0;

	MinAFCInit.CalcAFCMaxNum = 100;
    MinAFCInit.AFCMin = 0;  
    MinAFCInit.AFCMax = 199;
    MinAFCInit.AFCPreinstall = 130;//default Avgfuel
    MinAFCInit.CurODO = Mile_Get_Index_Value(MILE_INDEX_ODO)*100;
    MinAFCInit.MaxDRMileage = 200000;
    
    ResetAFC(&MinAFCInit);

}				 
void Data_Clear_Range(void)
{
	FuelMeter.Range = 0;
	FuelMeter.RangeDis = 0;
}


void Data_Clear_TYW(void)
{
	if((Get_DispVechileSpeed() >= 1800)&&(Common_Get_Act_V_Speed_Valid())&&(Get_DispEngineSpeed() >= 5000))
	{
		Mileage_Factory_Reset();
		Data_Clear_Ins_fuel();
		Data_Clear_Avg_fuel();
		//Data_Clear_Range();
		Data_Avg_Speed_Reset();
		NVM_Data_Update(NVM_INDEX_ODO_CLR);
		Mileage_Modify_Index_Value(MILE_INDEX_TRAP_A, 0);
		Mileage_Modify_Index_Value(MILE_INDEX_ODO, 0);
		u8MileODORelated[8]=0U;
		AvgSpeed.Valid   = 0;
		Maint_Reset(0);
		EOL_InitVal_TYW_Clear();
		g_stRTCInformation.u8RTCYear = 2019;
		g_stRTCInformation.u8RTCMonth = 1;
		g_stRTCInformation.u8RTCDayOfMonth = 1;
		g_stRTCInformation.u8RTCHour = 0;
		g_stRTCInformation.u8RTCMinute = 0;
		g_stRTCInformation.u8RTCSecond = 0;
		RTC_Set_Time((uint8_t*)&g_stRTCInformation);
	}
}

/*void Data_Clear_IVECO(void)
{
	if((Get_DispVechileSpeed() >= 1800)&&(Common_Get_Act_V_Speed_Valid())&&(Get_DispEngineSpeed() >= 5000))
	{
		Mileage_Factory_Reset();
		Data_Clear_Ins_fuel();
		Data_Clear_Avg_fuel();
		//Data_Clear_Range();
		Data_Avg_Speed_Reset();
		NVM_Data_Update(NVM_INDEX_ODO_CLR);
		Mileage_Modify_Index_Value(MILE_INDEX_TRAP_A, 0);
		Mileage_Modify_Index_Value(MILE_INDEX_ODO, 0);
		Maint_Reset(0);
		u8MileODORelated[8]=1U;
		AvgSpeed.Valid   = 0;
		g_stRTCInformation.u8RTCYear = 2019;
		g_stRTCInformation.u8RTCMonth = 1;
		g_stRTCInformation.u8RTCDayOfMonth = 1;
		g_stRTCInformation.u8RTCHour = 0;
		g_stRTCInformation.u8RTCMinute = 0;
		g_stRTCInformation.u8RTCSecond = 0;
		RTC_Set_Time((uint8_t*)&g_stRTCInformation);
	}
}*/
#endif


void CAN_Time_Lost(void)
{
	if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST )||(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9DF1_Msg_Count) == CAN_SIG_LOST )||(CanReceive.Can_18FF9CF1 != 1)||(CanReceive.Can_18FF9DF1 != 1))	
	{
		if((CAN_Time_Lost_Once == 0)&&(Can_Time_Normal == 0))
		{
			if(RTC_SECOND == 55)
			{
				RTC_SECOND = 0;
				RTC_MINUTE++;
			}
			else if(RTC_SECOND == 56)
			{
				RTC_SECOND = 1;
				RTC_MINUTE++;
			}
			else if(RTC_SECOND == 57)
			{
				RTC_SECOND = 2;
				RTC_MINUTE++;
			}
			else if(RTC_SECOND == 58)
			{
				RTC_SECOND = 3;
				RTC_MINUTE++;
			}
			else if(RTC_SECOND == 59)
			{
				RTC_SECOND = 4;
				RTC_MINUTE++;
			}
			else
			{
				RTC_SECOND += 5;
			}

			if(RTC_MINUTE > 59 )
			{
				RTC_MINUTE = 0;
				RTC_HOUR++;
			}
			if(RTC_HOUR > 23 )
			{
				RTC_HOUR = 0;
				RTC_DATE++;
			}
			MenuData.LeapYear = Determine_Leap_Year(RTC_YEAR+2000);
			switch (RTC_MONTH)
    		{
    		  case 1  :
    		  case 3  :
    		  case 5  :
    		  case 7  :
    		  case 8  :
    		  case 10 :
    		  case 12 : if (RTC_DATE > 31)
    		            {
    		              RTC_DATE = 1;
    		              RTC_MONTH++;
    		            }
    		            break;
    		  case 4  :
    		  case 6  :
    		  case 9  :
    		  case 11 : if (RTC_DATE > 30)
    		            {
    		              RTC_DATE = 1;
    		              RTC_MONTH++;
    		            }
    		            break;
    		  case 2  : if (MenuData.LeapYear)
    		            {
    		              if (RTC_DATE > 29)
    		              {
    		                RTC_DATE = 1;
    		                RTC_MONTH++;
    		              }
    		            }
    		            else
    		            {
    		              if (RTC_DATE > 28)
    		              {
    		                RTC_DATE = 1;
    		                RTC_MONTH++;
    		              }
    		            }
    		            break; 
    		}

    		if (RTC_MONTH > 12)
    		{
    		  RTC_MONTH = 1;
    		  RTC_YEAR++;
    		}

			RTC_Set_Time((uint8_t*)&g_stRTCInformation);
			RTC_Get_Time();
			CAN_Time_Lost_Once = 1;
		}
	}
}

void Data_GPIO_Sleep_Init(void)
{

    CAN_STB_OUT   = 1U;
    FUEL_CTR=0;
     Buzzer_CT_X1_OUT = 0U;
     Buzzer_CT_X2_OUT = 0U;
     Buzzer_CT_X3_OUT = 0U;
	 Buzzer_PWM = 0;
     SDB_LED_DRIVER = 0U;
     SDA_LED_DRIVER   = 1U;
     SCL_LED_DRIVER   = 1U;
    EEPROM_SCL = 1U;
    EEPROM_SDA = 1U;
	GPIO_OUT_PORT45_PIN05=0;
	PoMa_Delay(5);
}

INT8U Get_NodeConfig_TPMS(void)
{
	return Val_EOL_F010_TPMS();  
}

INT8U Get_NodeConfig_AirBag(void)
{
	return Val_EOL_F010_AirBag_Ctrl();
}

INT8U Get_NodeConfig_ESP(void)
{
	return Val_EOL_F010_ESP_EN();
}

INT8U Get_NodeConfig_GearBoxType(void)
{
	return Val_EOL_F010_GearBoxType(); 
}

INT8U Get_Mcu_Abnormal_Reset(void)
{
	return 0; 
}

INT8U Get_NodeConfig_LWDS(void)
{
	return Val_EOL_F010_LWDS(); 
}