  
#include "Line_In.h"
#include "Line_In_user.h"
#include "PowerManag_User.h"
#include "g_includes.h"

//static Linelib_uint8_t Get_LINE_IN_Get_ABS(void);
static Linelib_uint8_t Get_LINE_IN_Handbrake(void);
static Linelib_uint8_t Get_LINE_IN_Fuel_Warmwind(void);
static Linelib_uint8_t Get_LINE_IN_Block_Diesel_Filter(void);
static Linelib_uint8_t Get_LINE_IN_AIRBAG_POSITIVE(void);
static Linelib_uint8_t Get_LINE_IN_AIRBAG_NEGATIVE(void);
static Linelib_uint8_t Get_LINE_IN_Brake_Fault(void);
static Linelib_uint8_t Get_LINE_IN_Fuel_Alarm(void);
static Linelib_uint8_t Get_LINE_IN_Safety_Belt(void);
static Linelib_uint8_t Get_LINE_IN_Start_Detect(void);

const Line_In_Attribute_st g_stLineInAttribute [ LINE_IN_MAX ] = {
    
    //{
    //    LEVEL_HIGH,
    //    LEVEL_LOW,
    //    LINE_IN_IG_ON,
    //    100U,
    //    20U,
    //    Get_LINE_IN_Get_ABS,
    //},
    
    
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ONOFF,
        500U,
        20U,
        Get_LINE_IN_Handbrake,
    },
   
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_Fuel_Warmwind,
    },


    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_Block_Diesel_Filter,
    },
   
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_AIRBAG_POSITIVE,
    },

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_AIRBAG_NEGATIVE,
    },
   
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_Brake_Fault,
    },
    
    
   
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_Fuel_Alarm,
    },
  
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ONOFF,
        100U,
        20U,
        Get_LINE_IN_Safety_Belt,
    },
    
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        100U,
        20U,
        Get_LINE_IN_Start_Detect,
    },
    };


/*
Linelib_uint8_t Get_LINE_IN_Get_ABS(void)
{
    Linelib_uint8_t ret = 0U;
    if(ABS_EBD_ST_OUT)
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}*/



Linelib_uint8_t Get_LINE_IN_Handbrake(void)
{
    Linelib_uint8_t ret = 0U;
    if (Handbrake_IN)
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Fuel_Warmwind(void)
{
    Linelib_uint8_t ret = 0U;
    if ( Fuel_Warmwind_IN )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Block_Diesel_Filter(void)
{
    Linelib_uint8_t ret = 0U;
    if ( Block_Diesel_Filter_IN )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_AIRBAG_POSITIVE(void)
{
    Linelib_uint8_t ret = 0U;
    if ( AIRBAG_IN_POSITIVE )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_AIRBAG_NEGATIVE(void)
{
    Linelib_uint8_t ret = 0U;
    if ( AIRBAG_IN_NEGATIVE )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Brake_Fault(void)
{
    Linelib_uint8_t ret = 0U;
    if ( Brake_Fault_IN)
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Fuel_Alarm(void)
{
    Linelib_uint8_t ret = 0U;
    if (Fuel_Alarm_IN )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}

Linelib_uint8_t Get_LINE_IN_Safety_Belt(void)
{
    Linelib_uint8_t ret = 0U;
    if ( Safety_Belt_IN )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}
Linelib_uint8_t Get_LINE_IN_Start_Detect(void)
{
    Linelib_uint8_t ret = 0U;
    if ( Start_Detect_IN )
    {
        ret = 1u;
    }
    else
    {
        ret = 0UL;
    }
    return ret;
}




Linelib_uint8_t LINE_IN_Men [ LINE_IN_MAX * LINE_IN_BLOCK_SIZE ];


static Linelib_uint16_t LINE_GET_PWR(void)
{
    Linelib_uint16_t Res;
    Res = PoMa_Get_IG_Status( ) & 0x00FFu;
    return Res;
}

void LINE_IN_Init(void)
{
    Line_In_KL30_WakeUp_Init(LINE_IN_Men, g_stLineInAttribute, LINE_IN_MAX, LINE_GET_PWR);
}