


#include "App_RTC.h"
#include "g_includes.h"


void RTI_Init(void)
{
  RealTimeClock.RollingCounter = 0;
  RealTimeClock.BackupCounter  = 0;
  RealTimeClock.Year           = RTC_DEFAULT_YEAR;
  RealTimeClock.BackupYear     = RTC_DEFAULT_YEAR;
  RealTimeClock.Month          = RTC_DEFAULT_MONTH;
  RealTimeClock.Date           = RTC_DEFAULT_DATE;
  RealTimeClock.Hour           = RTC_DEFAULT_HOUR;
  RealTimeClock.Minute         = RTC_DEFAULT_MINUTE;
  RealTimeClock.Second         = RTC_DEFAULT_SECOND;
  RealTimeClock.LeapYear       = Determine_Leap_Year(RealTimeClock.Year);
}
void RTI_Timing_Service(void)
{
  uint16_t  Counter = 0;
  uint16_t  SecInc = 0;
  
  if (RealTimeClock.Year != RealTimeClock.BackupYear) //�����޸Ĺ���
  {
    RealTimeClock.LeapYear = Determine_Leap_Year(RealTimeClock.Year);
    RealTimeClock.BackupYear = RealTimeClock.Year;
  }
  Counter = RealTimeClock.RollingCounter;
  if(Counter == 0)
  {
    RealTimeClock.BackupCounter = 0;
  }
  if (Counter - RealTimeClock.BackupCounter >= 10)
  {
    SecInc = (Counter - RealTimeClock.BackupCounter) / 10;
    RealTimeClock.BackupCounter += SecInc * 10;
    
    RealTimeClock.Second += (uint8_t)(SecInc % 60);
    RealTimeClock.Minute += (uint8_t)(SecInc / 60);
    
    if (RealTimeClock.Second >= 60)
    {
      RealTimeClock.Minute += RealTimeClock.Second / 60;
      RealTimeClock.Second  = RealTimeClock.Second % 60;
    }
    
    if (RealTimeClock.Minute >= 60)
    {
      RealTimeClock.Hour   += RealTimeClock.Minute / 60;
      RealTimeClock.Minute  = RealTimeClock.Minute % 60;
    }
    
    if (RealTimeClock.Hour >= 24)
    {
      RealTimeClock.Date += RealTimeClock.Hour / 24;
      RealTimeClock.Hour  = RealTimeClock.Hour % 24;
    }
    
    switch (RealTimeClock.Month)
    {
      case 1  :
      case 3  :
      case 5  :
      case 7  :
      case 8  :
      case 10 :
      case 12 : if (RealTimeClock.Date > 31)
                {
                  RealTimeClock.Date = 1;
                  RealTimeClock.Month++;
                }
                break;
                
      case 4  :
      case 6  :
      case 9  :
      case 11 : if (RealTimeClock.Date > 30)
                {
                  RealTimeClock.Date = 1;
                  RealTimeClock.Month++;
                }
                break;
                 
      case 2  : if (RealTimeClock.LeapYear)
                {
                  if (RealTimeClock.Date > 29)
                  {
                    RealTimeClock.Date = 1;
                    RealTimeClock.Month++;
                  }
                }
                else
                {
                  if (RealTimeClock.Date > 28)
                  {
                    RealTimeClock.Date = 1;
                    RealTimeClock.Month++;
                  }
                }
                break; 
    }
    
    if (RealTimeClock.Month > 12)
    {
      RealTimeClock.Month = 1;
      RealTimeClock.Year++;
      RealTimeClock.LeapYear = Determine_Leap_Year(RealTimeClock.Year);
      RealTimeClock.BackupYear = RealTimeClock.Year;
    }
  }
}

INT8U Determine_Leap_Year(INT16U Year)
{
  if (Year % 4 == 0)
  {
    if (Year % 100 != 0)
      return 1;
    else if (Year % 400 == 0)
      return 1;
  }

  return 0;
}