#include "LCDFont.h"
#include "api_tft.h"
#include <string.h>


BFC_BIN_FONT     g_BFC_BIN_FONT;
BFC_BIN_RANGE    g_FONT_RANGE[MAXFONTRANGE];
uint16_t         g_FONT_NUM[MAXFONTRANGE];
uint8_t          FONT_DISP[282];
uint8_t          FONT_Init;

/*-------------------------------------------------------------------------
* Function Name  : Gui_LoadFontInfo
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_LoadFontInfo(void)
{
    uint16_t i = 0u;

    memcpy((uint8_t * )(&(g_BFC_BIN_FONT.FontType)), (uint8_t * )FONT_FLASH_START_ADDR, sizeof(BFC_BIN_FONT));
    for (i = 0; i < g_BFC_BIN_FONT.NumOfCharRanges; i++)
    {
        g_FONT_RANGE[i].FirstChar = *((uint16_t * )((FONT_FLASH_START_ADDR + sizeof(BFC_BIN_FONT)) + (i * sizeof(BFC_BIN_RANGE))));
        g_FONT_RANGE[i].LastChar  = *((uint16_t * )((FONT_FLASH_START_ADDR + sizeof(BFC_BIN_FONT)) + (i * sizeof(BFC_BIN_RANGE)) + (sizeof(BFC_BIN_RANGE) / 2)));
        g_FONT_NUM[i] = g_FONT_RANGE[i].LastChar - g_FONT_RANGE[i].FirstChar + 1;
    }

}

/*-------------------------------------------------------------------------
* Function Name  : Gui_GetFontInfo
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
BFC_BIN_RESULT Gui_GetFontInfo(uint16_t unicodeID)
{
    uint32_t TmpAddr = 0;
    BFC_BIN_RESULT  m_Result;
    BFC_BIN_FORMAT  m_Format;
    uint16_t TotalFontCount  = 0;
    uint16_t mdatasize  = 0;
    uint16_t  i = 0;

    for (i = 0; i < g_BFC_BIN_FONT.NumOfCharRanges; i++)
    {
         if ((unicodeID >= g_FONT_RANGE[i].FirstChar) && (unicodeID <= g_FONT_RANGE[i].LastChar))
         {
             TmpAddr = FONT_FLASH_START_ADDR + sizeof(BFC_BIN_FONT) + g_BFC_BIN_FONT.NumOfCharRanges * sizeof(BFC_BIN_RANGE);
             TmpAddr += ((TotalFontCount + (unicodeID - g_FONT_RANGE[i].FirstChar)) * sizeof(BFC_BIN_FORMAT));
             memcpy((uint8_t *)(&(m_Format.Width)), (uint8_t * )(TmpAddr), sizeof(BFC_BIN_FORMAT));
             mdatasize = (m_Format.Width+1)/2;
             mdatasize *=FONT_HIGH_PIX_COUNT;
             if((m_Format.DataSize == mdatasize) && ((m_Format.DataSize / 4) <= 100) && (m_Format.OffData <= FONT_FLASH_MAX_OFFSET_ADDR))
             {
                 if(m_Format.Width%2 == 1)
                 {
                   m_Result.Width   = m_Format.Width + 1;
                 }
                 else
                 {
                   m_Result.Width   = m_Format.Width;
                 }
                 m_Result.High    = FONT_HIGH_PIX_COUNT;
                 m_Result.Addr    = m_Format.OffData + FONT_FLASH_START_ADDR; 
                 m_Result.Result  = 1;
                 return m_Result;
             }
             
             break;
         }
         TotalFontCount += g_FONT_NUM[i];
    }
    m_Result.Width   = 0;
    m_Result.High    = 0;
    m_Result.Addr    = 0; 
    m_Result.Result  = 0;
    return m_Result; 

}
/*-------------------------------------------------------------------------
* Function Name  : Gui_GetFontDisp
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
short test_x = 60;
short test_y = 20;
uint16_t test_font = 0x5E73;
void Gui_GetFontDisp(void)
{

    BFC_BIN_RESULT  m_Return;    
    m_Return = Gui_GetFontInfo(test_font);//W
    
    if(m_Return.Result == 1)
    {
        FONT_DISP[0] = 0;
        FONT_DISP[1] = 0;
        FONT_DISP[4] = (m_Return.Width & 0xFF);
        FONT_DISP[5] = ((m_Return.Width >> 8)& 0xFF);
        FONT_DISP[2] = (m_Return.High & 0xFF); 
        FONT_DISP[3] = ((m_Return.High >> 8)& 0xFF); 
        memcpy((uint8_t * )(&FONT_DISP[6]), (uint8_t * )(m_Return.Addr), ((m_Return.Width * m_Return.High)/2));
     
        DrawInfo.x_point = test_x;
        DrawInfo.y_point = test_y;
        DrawInfo.IMG = (uint8_t*)(FONT_DISP);
        Draw_SetWindow(1,239,1,319);
        Draw_WindowDirect(&DrawInfo);
    }

}

/*-------------------------------------------------------------------------
* Function Name  : Gui_GetFontUnicodeDisp
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
uint8_t Gui_GetFontUnicodeDisp(uint16_t unicode,int16_t x_point,int16_t y_point, int16_t offset_x, int16_t offset_y)
{
    BFC_BIN_RESULT  m_Return;
    uint16_t Unicode = 0;
    uint16_t mSize  = 0;
   
    m_Return.Result = 0;
    Unicode = unicode;
    m_Return = Gui_GetFontInfo(Unicode);
    if(m_Return.Result == 1)
    {
      
        FONT_DISP[0] = 0;
        FONT_DISP[1] = 0;
        FONT_DISP[2] = (m_Return.High& 0xFF);
        FONT_DISP[3] = ((m_Return.High >> 8)& 0xFF);
        FONT_DISP[4] = (m_Return.Width & 0xFF); 
        FONT_DISP[5] = ((m_Return.Width >> 8)& 0xFF); 
        mSize = ((m_Return.Width+1)/2)*m_Return.High;
        memcpy((uint8_t * )(&FONT_DISP[6]), (uint8_t * )(m_Return.Addr), mSize);
        
        DrawInfo.x_point = x_point;
        DrawInfo.y_point = y_point;
        DrawInfo.IMG = (uint8_t*)(FONT_DISP);
        // Draw_SetWindow(20,220,20,300);
         Draw_SetWindow(1,239,1,319);
        Draw_WindowDirect(&DrawInfo);
    }
    return m_Return.Result;

   
}


