#include "UDS_14Service_Main.h"

/**
  *14服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_14_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC11();                                            /*14服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC7F();                                            /*14服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC33();                                            /*14服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC13_MinLengthCheck();                             /*14服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC31();                                            /*14服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC13_TotalLengthCheck();                           /*14服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_14Service_NRC22();                                            /*14服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_14Service();                                                        /*14服务功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *14服务功能
  */
void UDS_14Service(void)
{
    uint32_t eCanTxBuffStatus;
    uint32_t eCanTxStatus;
    uint8_t enResult = 0u;
    UDS_NRC78_Sand(0x14u);
    enResult = DTC_Clear();
    UDS_Delay(500u);
   /* eCanTxBuffStatus = CANFD_ReadTX_Buf();
    eCanTxStatus = CANFD_ReadTX_Status();
    eCanTxBuffStatus &= (1u << 26u);
    eCanTxStatus &= (1u << 26u);
    
    while((eCanTxBuffStatus ==1u) || (eCanTxStatus ==0u) )
    {
      UDS_Delay(500u);
      eCanTxBuffStatus = CANFD_ReadTX_Buf();
      eCanTxStatus = CANFD_ReadTX_Status();
      eCanTxBuffStatus &= (1u << 26u);
      eCanTxStatus &= (1u << 26u);
    }*/
    if(enResult == 0)
    {
        /*UDS_14_SendRsp(0x14u);*/
        UDS_Service_Response(0x14u, POSITIVE_RSP, DIAG_ID_Tx, 0u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        /*UDS_SendNRCRsp(0x14u,enResult);*/
        UDS_Service_Response(0x14u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

