/*
 * api_TFT.h
 *
 *  Created on: Aug 14, 2014
 *      Author: QTC
 */
#include "TYW_stdint.h"
#ifndef API_TFT_H_
    #define API_TFT_H_

typedef union
{
    uint16_t Msg [ 3 ];
    struct
    {
        uint16_t Lamp_InScreen : 5; /*屏内指示灯序列存放地址*/
        uint16_t Reserve01     : 3; /*指示灯第二页起点标志位*/
        uint16_t Lamp_InCount  : 8; /*屏内指示灯计时*/

        uint16_t AdblueFlag    : 1; /*尿素液位显示标志位*/
        uint16_t Can_SelfCheck : 1; /*仪表自检开始结束标志位*/
        uint16_t Send_ECTFault : 2; /*预留*/
        uint16_t AMTSelf_Send  : 1; /*AMT自学习外发*/
        uint16_t Reserve03     : 3; /*预留*/
        uint16_t Animation     : 8; /*开机动画计时*/

        uint16_t PopUpMasData : 16; /*报警信息参数*/
    } Sig;
} TelltalesSystemSet_t;


typedef struct
{
    short          x_point;
    short          y_point;
    unsigned char *IMG;
    unsigned char  Radius;
    unsigned char  Alpha;
    unsigned char  Luminance;
    unsigned short Origin_x;
    unsigned short Origin_y;
    float          Scale;
} DrawInfomation;

typedef struct
{
    short        x_point;
    short        y_point;
    unsigned int width;
    unsigned int hith;
} Reflection_t;

extern DrawInfomation DrawInfo;
extern Reflection_t   Reflection;

extern void Draw_Graph_main(void);

extern void Draw_ClearVram(unsigned char VramIndex);

extern void Draw_SetWindow(unsigned int Left_side, unsigned int Right_side, unsigned int Top_side, unsigned int Bottom_side);

extern void Draw_SetDummySize(unsigned short w, unsigned short h);

extern unsigned int *Draw_GetVramAddress(unsigned char index);

extern void Draw_GraphCalculateCallBack(unsigned char vramID);

extern unsigned char Draw_CheckCompleteVram(unsigned char index);

extern unsigned char Draw_GetCurrentVram(void);

extern void Draw_ClearVramFlag(unsigned char index);

extern unsigned char Draw_DeleteCenter(DrawInfomation *DrawInfo);
extern unsigned char Draw_CenterSpread(DrawInfomation *DrawInfo);

extern unsigned char Draw_WindowDirect(DrawInfomation *DrawInfo);
extern unsigned char Draw_WindowDirectLumin(DrawInfomation *DrawInfo);

extern unsigned char Draw_WindowMinAlpha(DrawInfomation *DrawInfo);
extern unsigned char Draw_WindowMinAlphaLumin(DrawInfomation *DrawInfo);

extern unsigned char Draw_MaxAlpha(DrawInfomation *DrawInfo);
extern unsigned char Draw_LuminArea(DrawInfomation *DrawInfo);

extern unsigned char Draw_MinAlphaFillInside(DrawInfomation *DrawInfo);

extern unsigned char Draw_MaxValue(DrawInfomation *DrawInfo);
extern unsigned char Draw_MinValue(DrawInfomation *DrawInfo);

extern unsigned char Draw_WindowAlphaChannel(DrawInfomation *DrawInfo);
extern unsigned char Draw_WindowAlphaChannelLumin(DrawInfomation *DrawInfo);

extern unsigned char Draw_LuminMinValue(DrawInfomation *DrawInfo);

extern unsigned char Draw_WindowAlphaBlendMode(DrawInfomation *DrawInfo);

extern unsigned char Draw_WindowMaxAlphaChannel(DrawInfomation *DrawInfo);
extern unsigned char Draw_WindowMaxAlphaChannelLumin(DrawInfomation *DrawInfo);

extern unsigned char Draw_EdgeMinValue(DrawInfomation *DrawInfo);

extern unsigned char Draw_WindowScale(DrawInfomation *DrawInfo);

extern unsigned char Draw_MaskConstAlpha(DrawInfomation *DrawInfo);
extern unsigned char Do_Nothing(DrawInfomation *DrawInfo);

extern unsigned char *DrawTft_getVersion(void);

extern void           Draw_CutCenterWindow(unsigned char *IsCut, unsigned char vramID, unsigned int top, unsigned int Bottom);
extern unsigned char *DrawGetCutViewRam(void);

extern unsigned char Draw_Reflection(Reflection_t *Reflection, unsigned char grey);
extern void          Draw_ClearVramCalFlag(void);

extern void Draw_TopClearVram(unsigned char VramIndex);

extern void Draw_Image_Local(unsigned char PictureNum [], int Pos_X, unsigned int Pos_Y);
extern void Draw_Image_Local_Digit_Draw(uint32_t Digit,   uint8_t *Font[], uint8_t Len, uint8_t Blank, const uint16_t *px, uint16_t y);

#endif /* API_TFT_H_ */
