/************************************************************************
 * \file     Init.c
 * \brief    Initializations during work state switching
 * \details
 * \author   Zhang Xuan
 * \version  V1.0.0
 * \date     18-Jan-2019
 * \par      History:
 *           V1.0.0 Initial release
 * \par      Copyright:
 *           (c) Heilongjiang TYW Electronics co., LTD
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "dr7f701401.dvf.h"
#include "r_typedefs.h"
#include "init.h"
#include <string.h>
#include "rh850_macros.h"
#include "r_dev_api.h"
#include "r_bsp_api.h"
#include "RTE_GPIO.h"
#include "api_tft.h"
#include "LCD_BUS.h"
#include "LCD_MonoTFT.h"
#include "cpu.h"
#include "Sys_Tick.h"
#include "..\Driver\WDT\Watchdog.h"
#include "RTE_CAN.h"
#include "LED_Driver_Interface.h"
#include "TimerB.h"

#include "Analog_Signals.h"
#include "RTE_ADC.h"
#include "COM_CAN.h"
#include "r_typedefs.h"
#include "Internal_Flash.h"
#include "r_fdl_types.h"
#include "g_includes.h"

#include "Telltales_user.h"
#include "Line_In_user.h"
#include "PowerManag_User.h"
#include "sflash.h"
#include "LCDFont.h"
#include "UDS_Common.h"

#pragma ghs section bss = ".NonInitArea"
uint32_t            TestBackupRam1;
#pragma ghs section bss = default

/*__no_init*/ uint8_t  TestBackupRam /*@(0x0e800000)*/;
/*__no_init*/ uint32_t TestBackupRam_Flag /*@(0x0e800004)*/;

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static const r_dev_ClkSelConfig_t loc_ClkSelectionCfgD1L1 [] =
    /*   Cks                   SrcId                Div  StpReqMsk      */
    {
        //  {R_DEV_CKS_RSCANXIN, R_DEV_CKS_SRC_MOSC, 1, 0u},
        //  {R_DEV_CKS_RSCAN   ,R_DEV_CKS_SRC_MOSC,1,0U},

        {R_DEV_CKS_OSTM, R_DEV_CKS_SRC_MOSC, 2, 0u},

        {R_DEV_CKS_RTC, R_DEV_CKS_SRC_MOSC, 2, 0u},
        {R_DEV_CKS_CLKJIT, R_DEV_CKS_SRC_DIV, 4, 0u},
        {R_DEV_CKS_PLLFIX, R_DEV_CKS_SRC_PLL1, 4, 0u},
        {R_DEV_CKS_CLKFIX, R_DEV_CKS_SRC_DIV, 12, 0u},    // 40M
        {R_DEV_CKS_CPU, R_DEV_CKS_SRC_PLL0, 4, 0u},
        {R_DEV_CKS_PLL2IN, R_DEV_CKS_SRC_MOSC, 1, 0u},
        {R_DEV_CKS_SFMA, R_DEV_CKS_SRC_PLL1, 6, 0u},
        {R_DEV_CKS_AWOT, R_DEV_CKS_SRC_MOSC, 1, 0u},
        {R_DEV_CKS_TAUB0, R_DEV_CKS_SRC_CLKFIX, 1, 0u},    // 40M / 8 = 5M
        {R_DEV_CKS_ADCE, R_DEV_CKS_SRC_CLKJIT_4, 2, 0u},
        {R_DEV_CKS_LCBI, R_DEV_CKS_SRC_CLKJIT, 0, 0u},
        {R_DEV_CKS_ISM, R_DEV_CKS_SRC_CLKJIT, 0, 0u},
        {R_DEV_CKS_SSIF, R_DEV_CKS_SRC_PLLFIX, 156, 0u},

        /* delimiter - do not remove */
        {R_DEV_CKS_LAST, R_DEV_CKS_SRC_MOSC, 2, 0u},
};
/* Private function prototypes -----------------------------------------------*/
extern void loc_InitClocks(r_dev_ClkGenConfig_t *Config);

/* Private functions ---------------------------------------------------------*/
#define GPIO_STB_PROTECTED_WRITE(preg, pstatus, reg, value) \
    do                                                      \
    {                                                       \
        (preg) = 0xA5U;                                     \
        (reg)  = (value);                                   \
        (reg)  = ~(value);                                  \
        (reg)  = (value);                                   \
    } while ( (pstatus) == 1U )
/************************************************************************
 * \brief      Initializations during work state switching
 * \attention
 * \retval     None
 ************************************************************************/
void Sys_Startup_Pre_Init(void)
{
    r_dev_ClkGenConfig_t clk_gen_cfg;

    SET_EBASE(0x00040400);    // set Ebase to 0x10000, set RINT to 1
    SET_PSW_EBV( );
    /* Release all Modules (except SDRAM controller) */
    Sys_Peripheral_Reset(SYS_PERI_RESETTABLE & (~SYS_PERI_SDRB0));
    /* Prepare device (clear all internal config, prepare interrupts) */
    /* Prepare device (clear all internal config, prepare interrupts) */
    R_DEV_Prepare( );
    /* Get the config */
    loc_InitClocks(&clk_gen_cfg);
    R_DEV_ClkGenInit(&clk_gen_cfg, loc_ClkSelectionCfgD1L1);

    /* use the config, store settings */
    R_DEV_ClkGenInitStore(&clk_gen_cfg);

    /* Enable interrupts globally */
    __EI( );

    GPIO_STB_PROTECTED_WRITE(SYSPROTCMD0, SYSPROTS0, SYSIOHOLD, 0x00U);

    //   Sys_Enable_Preload_Buffer( );
}
/************************************************************************
 * \brief      Initializations during system power up
 * \attention
 * \retval     None
 ***********************************************************************/
uint32_t u32FDLDataFlag [ 4 ] = {0, 0, 0, 0};

void Sys_Startup_Init(void)
{
    uint32_t  i;
    uint32_t *pRam;
    uint8_t   u8StartupMode = 0;

    __DI( );
    TestBackupRam = Clock_Get_Startup_Mode( );
    if ( TestBackupRam == 1u )
    {
        u8StartupMode = 0x55u;
    }
    else
    {
        if ( TestBackupRam_Flag != 0xAABBCCDDul )
        {
            if ( TestBackupRam1 == 0xaabbccddul )
            {
                u8StartupMode = 0x55u;
            }
            else
            {
                pRam = ( unsigned int * )0x3FCE4000ul;
                for ( i = 0; i < 0x1000; i++ )
                {
                    pRam [ i ] = 0;
                }
                u8StartupMode = 0x00u;
            }
        }
    }
    TestBackupRam1 = 0x11223344UL;
    RTE_GPIO_KL30_Init( );
    RTE_ADC_Init( );
    WDT_Init( );
    PoMa_Init_Example(u8StartupMode);
    ReadAllDFlashData();
    TestBackupRam_Flag = 0;
}

/************************************************************************
 * \brief      Initializations during work state switch to system sleep
 * \attention
 * \retval     None
 ************************************************************************/
void Sys_Sleep_Init(void)
{
}

/************************************************************************
 * \brief      Initializations during work state switch to system run
 * \attention
 * \retval     None
 ***********************************************************************/
void System_Wakeup_Init(void)
{
}
