#include "Task.h"
#include "dr7f701401.dvf.h"
#include "PIC_Comm.h"
#include "api_tft.h"
#include "Analog_Signals.h"
#include "Buzzer_Play_User.h"
#include "Sound_Alarm_User.h"
#include "GPIO.h"
#include "Watchdog.h"
#include "Task_Scheduler.h"
#include "GUI.h"
#include "COM_CAN.h"
// #include "Flash_synchronizer.h"
#include "r_typedefs.h"
#include "RTE_ADC.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Rscan.h"
#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_in.h"
#include "Line_In_user.h"
#include "EEPROM_24Cxx.h"
#include "Simulated_IIC_Master.h"
#include "Non_volatile_Memorys.h"
#include "EEPROM_24Cxx_Remap.h"
#include "PowerManag_User.h"
#include "DataProcess.h"
#include "Key.h"
#include "NM_Config.h"
#include "NMUserControl.h"
#include "LED_Driver.h"
#include "LED_Driver_Interface.h"


#include "Gauges.h"

#include "Popup_Alarm.h"
#include "Popup_Alarm_user.h"

#include "Popup_Alarm_Handle.h"
#include "Sound_Alarm_handle.h"

#include "LCD_BUS.h"
#include "LCD_MonoTFT.h"
#include "UDS_Common.h"
#include "DoCAN_ISO15765.h"

/*******************************************************************************
 *                                                                              *
 *                                                                              *
 *******************************************************************************/
uint8_t        Menu_Update_Flag = 0u;
uint16_t       SeatBeltCount;
extern uint8_t TELTALES_MODE;
uint8_t        CAN_EXIST_Flag = 0u;

/*==============================================================================

------------------------------------------------------------------------------*/

void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    PoMa_Service( );
	DoCAN_Communication_Service( );
    UDS_Server_Application_Service( );
    LED_Driver_Service( );
    EEPROM_RW_Service( );
    Gauges_Zero_Severces( );
    Buzzer_Play_Service( );
    Sound_Alarm_Service( );
	Menu_Hide_Service();
}
/*============================================================================*/

/*==============================================================================
2ms任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group(void)
{
	Analog_Signal_Conv_Service();
	Common_Input_Para();
	Flash_Service();
	Buzzer_Play_Time_Count(2);
	Sound_Alarm_Handle_Time(2);
	//Can_RX_ResetAllTimer_Self_Check();
}

/*==============================================================================
5ms任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks_Group(void)
{
	UDS_10ms_Service();
	Key_Clear_Time();
    COM_RX_Process();
}

/*==============================================================================
10ms任务
------------------------------------------------------------------------------*/
Pop_Alarm_en_t enYZHDTest=0;
Sound_Alarm_en_t  enYZHDTest1=0;

void Sys_Run_Mode_10ms_Tasks_Group(void)
{
	enYZHDTest=Pop_Alarm_Get_Current();
	enYZHDTest1=Sound_Alarm_Current_Read();
	
	NVM_Data_Update_Service();
	EEPROM_Access_Service();
	TurnLeft_Lamp();
	TurnRight_Lamp();
	SendMsg();
	Gui_LightProc();
	FuelAFCTimeCall();
	Key_Service();
	Line_In_Debounce_Service(10u);
	Data_Engine_Speed_Processing_Service();
	Sound_Alarm_Trigger_TURN();

    //Can_BusOff_Fun( );

  
    LCDBUS_Check_RealTime( );

}

/*==============================================================================
20ms任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{



	PoMa_Time_Service(20U);
	Data_Vehicle_Speed_Processing_Service();
	CAN_J1939_Time_Handle(20U);
	CAN_1939_Process();
	

}

/*==============================================================================
50ms任务
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks_Group(void)
{

    Draw_Graph_Engine( );
	Gauges_Management_Service();
	Telltales_Management();
	LED_Driver_Scan_Refresh();



}
/*==============================================================================
100ms任务
------------------------------------------------------------------------------*/

void Sys_Run_Mode_100ms_Tasks_Group(void)
{
	TPMS_Tyre_Lost();
	LED_Driver_Refresh_Example();
	PoMa_Sleep_Delay_Time_Handle();
	Mileage_Source_Service();
	Maint_Service();
	Data_Coolant_Temp_Processing_Service();
	ExecFuel();
	Fuel_RangeDis();
    Data_AvgFuel_Processing_Service();
    Data_AvgFuel_TripA_Display_Service();
    Data_Instantaneous_Fuel_Service();
    Data_Instantaneous_Fuel_Display_Service();
    //Data_Safety_Belt_Processing_Service();
    Data_TPMS_Value_Processing();
    Data_Urea_Processing_Service();
    Data_Urea_Limited_Torque();
    Data_Urea_Limited_Vehicle_Speed();
    Data_Avg_Speed_Processing();
    AvgSpeed_DriTime_Add(1);
	AvgSpeed_Speed_Add(Common_Get_Act_V_Speed());
    Safety_Belt_DriTime_Add(1);
    Data_Fuel_Display();
	// Gui_Display_Service();
	Popups_Alarm_Trigger_Time();
	Popups_Alarm_Trigger_Service();
	Sound_Alarm_Trigger_Service();
	Sound_Alarm_Trigger_Time();
	Data_Gear_Processing_Service();
	//RTI_Timing_Service();
	Power_Management_Time_Handle();
	Can18FF9CF1_Lost();
	RTC_TIME_Processing_Service();
	CAN_Message_Time_Handle();
	CAN_Time_Lost();
}
/*==============================================================================
精准50us任务
------------------------------------------------------------------------------*/
volatile uint8_t Time_2ms_Flag = 0u;
uint8_t          Time_2ms_Cnt  = 0u;
uint16_t         TimerCount    = 0;
uint16_t task_2ms = 0U;
uint16_t task_10ms = 0U;
void             Sys_Exact_50us_Tasks(void)
{
    static uint16_t SEG_TIMER;
    static uint32_t task_1ms = 0u;

	UDS_50us_Service( );
    DoCAN_Timer_Update(50);
    	//bsp_MotorMove_50us_main();
    	bsp_MotorMove_50us_main();


	task_2ms++;
	if (task_2ms >= 40)
	{
		task_2ms = 0U;

		OsekNM_Manage_Main();
	}


    //  GenDelay_Tick( );

#ifndef INNER_PIC_ON
    LCDBUS_Monitor_Time_ISR( );
#endif
}
/*==============================================================================
精准100ms任务
------------------------------------------------------------------------------*/

void Sys_Exact_100ms_Tasks(void)
{
      Mileage_Rolling_Counter_Update_ISR(Common_Get_Act_V_Speed());
}

