#include "Popup_Alarm.h"
#include "Popup_Alarm_user.h"
#include "Sound_Alarm_User.h"
#include "Sound_Alarm_handle.h"

#pragma alignvar(8)
const Popup_Alarm_Group_Attribute_st_t stPopAlarmGroupAttribute [ POP_GROUP_MAX ] = {
    {POPUP_DISPLAY_CYCLY, POP_DELAY_MIN, POP_RECOVER_CYCLE},
};
#pragma alignvar(8)
const Popup_Alarm_Type_Attribute_st_t stPopAlarmTypeAttribute [ POP_TYPE_MAX ] = {
    {POPUP_DISPLAY_CYCLY, POPUP_DISPLAY_FIX, POP_DELAY_MIN, POP_RECOVER_CYCLE, POP_SORTORD_FIRST, 10, 30, 30, 0, POP_ALLOW_HIDE_FIRST_CYCLE},
    {POPUP_DISPLAY_CYCLY, POPUP_DISPLAY_FIX, POP_DELAY_MIN, POP_RECOVER_CYCLE, POP_SORTORD_FIRST, 10, 30, 0, 0, POP_ALLOW_HIDE_FIRST_CYCLE},
};

#pragma alignvar(8)
const Popup_Alarm_Attribute_st_t stPopAlarmAttribute [ POP_ALARM_MAX ] = {
    /*POP_ALARM_DPF = 0U,				  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_DPF, POP_ALARM_DPF + POP_ALARM_MAX, SOUND_ALARM_DPF},
    /*POP_ALARM_DOOR,					  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_DOOR, POP_ALARM_DOOR + POP_ALARM_MAX, 0xFFU},
    /*POP_ALARM_TEMP,					  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_TEMP, POP_ALARM_TEMP + POP_ALARM_MAX, 0xFFU},
    /*POP_ALARM_ENGINE_LUBRICATE,		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_ENGINE_LUBRICATE, POP_ALARM_ENGINE_LUBRICATE + POP_ALARM_MAX, 0xFFU},
    /*POP_ALARM_FUEL_SEN_FAIL,		      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_FUEL_SEN_FAIL, POP_ALARM_FUEL_SEN_FAIL + POP_ALARM_MAX, SOUND_ALARM_FUEL_SEN_FAIL},
    /* POP_ALARM_TBOX_DISMANTLE 		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_TBOX_DISMANTLE, POP_ALARM_TBOX_DISMANTLE + POP_ALARM_MAX, SOUND_ALARM_TBOX},
    /*POP_ALARM_PAR_FULL_MANUAL_RESET,    */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_PAR_FULL_MANUAL_RESET, POP_ALARM_PAR_FULL_MANUAL_RESET + POP_ALARM_MAX, SOUND_ALARM_PAR_FULL_MANUAL_RESET},
    /*POP_ALARM_PAR_FULL_SERVICE_RESET,   */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_PAR_FULL_SERVICE_RESET, POP_ALARM_PAR_FULL_SERVICE_RESET + POP_ALARM_MAX, SOUND_ALARM_PAR_FULL_MANUAL_RESET},
    /*POP_ALARM_UREA_LOW_20,			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_LOW_20, POP_ALARM_UREA_LOW_20 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_FAIL_20,			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_FAIL_20, POP_ALARM_UREA_FAIL_20 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_EMISSION_FAIL_20,		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_EMISSION_FAIL_20, POP_ALARM_EMISSION_FAIL_20 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_LOW_RESET_20,	      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_LOW_RESET_20, POP_ALARM_UREA_LOW_RESET_20 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_FAIL_RESET_20,	      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_FAIL_RESET_20, POP_ALARM_UREA_FAIL_RESET_20 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_EMISSION_FAIL_RESET_20,   */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_EMISSION_FAIL_RESET_20, POP_ALARM_EMISSION_FAIL_RESET_20 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_LOW_TORQUE_LIMIT_75, */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_LOW_TORQUE_LIMIT_75, POP_ALARM_UREA_LOW_TORQUE_LIMIT_75 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_LOW_TORQUE_LIMIT_50, */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_LOW_TORQUE_LIMIT_50, POP_ALARM_UREA_LOW_TORQUE_LIMIT_50 + POP_ALARM_MAX, 0xFFU},
    /*POP_ALARM_LIMIT_75_CHANGE,		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_LIMIT_75_CHANGE, POP_ALARM_LIMIT_75_CHANGE + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_LIMIT_75_SERVICE,		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_LIMIT_75_SERVICE, POP_ALARM_LIMIT_75_SERVICE + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_LOW_LIMIT_75,	  	  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_LOW_LIMIT_75, POP_ALARM_UREA_LOW_LIMIT_75 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_FAIL_LIMIT_75,	  	  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_FAIL_LIMIT_75, POP_ALARM_UREA_FAIL_LIMIT_75 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_EMISSION_FAIL_LIMIT_75,   */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_EMISSION_FAIL_LIMIT_75, POP_ALARM_EMISSION_FAIL_LIMIT_75 + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_LOW_ADD,			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_LOW_ADD, POP_ALARM_UREA_LOW_ADD + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_UREA_FAIL_CHANGE,		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_UREA_FAIL_CHANGE, POP_ALARM_UREA_FAIL_CHANGE + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /*POP_ALARM_EMISSION_FAIL_SERVICE,    */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_EMISSION_FAIL_SERVICE, POP_ALARM_EMISSION_FAIL_SERVICE + POP_ALARM_MAX, SOUND_ALARM_UREA},
    /* POP_ALARM_ESC_FAILURE 			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_ESC_FAILURE, POP_ALARM_ESC_FAILURE + POP_ALARM_MAX, SOUND_ALARM_ESC_FAILURE},
    /* POP_ALARM_ESC_ATCIVE 			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_ESC_ATCIVE, POP_ALARM_ESC_ATCIVE + POP_ALARM_MAX, SOUND_ALARM_ESC_ATCIVE},
    /* POP_ALARM_ESC_CLOSE 				  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_ESC_CLOSE, POP_ALARM_ESC_CLOSE + POP_ALARM_MAX, SOUND_ALARM_ESC_CLOSE},
    /*POP_ALARM_TPMS_CONFIG_ERROR,	      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_TPMS_CONFIG_ERROR, POP_ALARM_TPMS_CONFIG_ERROR + POP_ALARM_MAX, SOUND_ALARM_TPMS_CONFIG_ERROR},
    /*POP_ALARM_TPMS,					  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_TPMS, POP_ALARM_TPMS + POP_ALARM_MAX, SOUND_ALARM_TPMS},
    /*POP_ALARM_TSAFE_BELT,				  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_TSAFE_BELT, POP_ALARM_TSAFE_BELT + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_START_IN_P 			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_START_IN_P, POP_ALARM_START_IN_P + POP_ALARM_MAX, SOUND_ALARM_START_IN_P_ONCE},
    /* POP_ALARM_BRAKE_TO_SHIFT		      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_BRAKE_TO_SHIFT, POP_ALARM_BRAKE_TO_SHIFT + POP_ALARM_MAX, SOUND_ALARM_BRAKE_TO_SHIFT},
    /* POP_ALARM_P_INVALID 				  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_P_INVALID, POP_ALARM_P_INVALID + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_PARK_IN_P 				  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_PARK_IN_P, POP_ALARM_PARK_IN_P + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_GEARBOX_FAILURE 		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_GEARBOX_FAILURE, POP_ALARM_GEARBOX_FAILURE + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_RADAR_FAILURE 			  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_RADAR_FAILURE, POP_ALARM_RADAR_FAILURE + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_GEARBOX_CAUTION 		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_GEARBOX_CAUTION, POP_ALARM_GEARBOX_CAUTION + POP_ALARM_MAX, SOUND_ALARM_GEARBOX_CAUTION},
    /* POP_ALARM_GEARBOX_HIGH_TEMP 		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_GEARBOX_HIGH_TEMP, POP_ALARM_GEARBOX_HIGH_TEMP + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_LDWS_CLOSE 	 		  */ {POP_GROUP_0, POP_TYPE_1, POP_ALARM_LDWS_CLOSE,   POP_ALARM_LDWS_CLOSE + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_LDWS_FAILURE	 		  */ {POP_GROUP_0, POP_TYPE_1, POP_ALARM_LDWS_FAILURE, POP_ALARM_LDWS_FAILURE + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_LDWS_ATCIVE	 		  */ {POP_GROUP_0, POP_TYPE_1, POP_ALARM_LDWS_ATCIVE,  POP_ALARM_LDWS_ATCIVE + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_LDWS_L_R		 		  */ {POP_GROUP_0, POP_TYPE_1, POP_ALARM_LDWS_L_R,     POP_ALARM_LDWS_L_R + POP_ALARM_MAX, SOUND_ALARM_LDWS},
    /* POP_ALARM_HILL_HOLD_MALF 	      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_HILL_HOLD_MALF, POP_ALARM_HILL_HOLD_MALF + POP_ALARM_MAX, SOUND_ALARM_HILL_HOLD_MALF},
    /* POP_ALARM_POSITION_LIGHT 		  */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_POSITION_LIGHT, POP_ALARM_POSITION_LIGHT + POP_ALARM_MAX, 0xFFU},
    /* POP_ALARM_KEY 				      */ {POP_GROUP_0, POP_TYPE_0, POP_ALARM_KEY, POP_ALARM_KEY + POP_ALARM_MAX, 0xFFU},
};
void Pop_Sound_Alarm_Request(Pop_Alarm_en_t enPopAlarm, Pop_Alarm_Trigger_Condition_en_t enAlarmTrigger)
{
    if ( Sound_Get_Diag_Ctrl( ) > 0x0B )
    {
        Sound_Alarm_Request_Mul(enPopAlarm, enAlarmTrigger);
    }
}
void Pop_Sound_Alarm_Delete(Pop_Alarm_en_t enPopAlarm, Pop_Alarm_Trigger_Condition_en_t enAlarmTrigger)
{
    /*删除由声音触发部分执行*/
    // Sound_Alarm_Delete_Mul(enPopAlarm, enAlarmTrigger);
}
void Pop_Sound_Alarm_Enable(Pop_Alarm_en_t enPopAlarm)
{
}
void Pop_Sound_Alarm_Suspend(Pop_Alarm_en_t enPopAlarm)
{
}
const Pop_Init_st_t stPopInit = {
    stPopAlarmAttribute,
    stPopAlarmTypeAttribute,
    stPopAlarmGroupAttribute,
    POP_GROUP_MAX,
    POP_TYPE_MAX,
    POP_ALARM_MAX,
    POP_HIDE_QUEUE_MAX,
    Pop_Sound_Alarm_Request,
    0U,    // Pop_Sound_Alarm_Delete,
    0U,    // Pop_Sound_Alarm_Enable,
    0U,    // Pop_Sound_Alarm_Suspend,
};
#pragma alignvar(8)
Pop_uint8_t u8PopRAM [ POP_RAM_DATA_LEN ];
void        Pop_Alarm_Init_Example(void)
{
    Pop_Alarm_Init(u8PopRAM, &stPopInit);
}
