/*
****************************************************************************
PROJECT : DMA driver
FILE    : $Id: r_dma_isr.c 2218 2014-03-27 16:29:52Z michael.golczewski $
============================================================================
DESCRIPTION
ISR for DMA macro driver
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2012
                                  by
                       Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2011 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/

#include "r_typedefs.h"
#include "r_cdi_api.h"
#include "r_dma_api.h"
#include "r_dev_api.h"

#include "r_dma_sys.h"
#include "r_config_dma.h"
#include "r_dma_main.h"

static void (*IsrCallback [ R_DMA_MACRO_NUM ][ R_DMA_CHANNEL_NUM ])(void);

/***********************************************************
  Function: R_DMA_SetIsrCallback

*/
r_dma_Error_t R_DMA_SetIsrCallback(uint32_t Unit, int32_t Channel, void (*Isr)(void))
{
    if ( Unit >= R_DMA_MACRO_NUM )
    {
        return R_DMA_ERR_INSTANCE;
    }
    IsrCallback [ Unit ][ Channel ] = Isr;
    return R_DMA_ERR_OK;
}

/***********************************************************
  Function: R_DMA_EnableInt


*/
r_dma_Error_t R_DMA_EnableInt(uint32_t Unit, int32_t Channel)
{
    /* Check range */
    if ( Unit >= R_DMA_MACRO_NUM )
    {
        return R_DMA_ERR_INSTANCE;
    }
    R_DMA_SYS_EnableInt(Unit, ( r_dma_Interrupt_t )Channel);

    return R_DMA_ERR_OK;
}

/***********************************************************
  Function: eeDmac_DisableInt

*/
r_dma_Error_t R_DMA_DisableInt(uint32_t Unit, int32_t Channel)
{
    /* Check range */
    if ( Unit >= R_DMA_MACRO_NUM )
    {
        return R_DMA_ERR_INSTANCE;
    }
    R_DMA_SYS_DisableInt(Unit, Channel);

    return R_DMA_ERR_OK;
}

/* Applications interrupt handling */
void R_DMA_Isr(uint32_t Unit, int32_t Channel)
{
    /* check for Null-Pointer  */
    if ( 0 != IsrCallback [ Unit ][ Channel ] )
    {
        IsrCallback [ Unit ][ Channel ]( );
    }
    return;
}
