#include "CAN_CH0_CAN_Communication_Matrix.h"

// 
#include "CAN_APP.h"
//#include "Services_Mileage.h"

#include "Data_AverageSpeed.h"
#include "g_includes.h"


extern uint32_t Data_MileageRolling_Counte;
/*** 平均车速 ***/
#pragma ghs section bss = ".myNonInitArea"
_AvgSpeed_Struct    AvgSpeed;
_DriverTime         DriverTime;
uint32_t            IGOFFDriverTime;
_AvgPower_Struct    AvgPower;
uint32_t AvgSpeed_Buf[7] = {0};
INT8U k = 0;
#pragma ghs section bss = default
uint16_t            AvgSpeedDisTime;
uint8_t EngSpeed_Start_Flag = 0;

void Data_AverageSpeed_KL30_Init(void)
{
    AvgSpeed.Mileage = 0;
    AvgSpeed.DrTime  = 0;
    AvgSpeed.Val     = 0;
    AvgSpeed.Dis     = 0;
    AvgSpeedDisTime  = 100;
    AvgSpeed.Valid   = 0;
    EngSpeed_Start_Flag = 0; 
    AvgSpeed.Speed         = 0;
}

/*void Data_AverageSpeed_KL15_Init(void)
{
    AvgSpeed.Mileage = 0;
    AvgSpeed.DrTime  = 0;
    AvgSpeed.Val     = 0;
    AvgSpeed.Dis     = 0;
    AvgSpeedDisTime  = 100 + 1;
    AvgSpeed.Valid   = 0;
    EngSpeed_Start_Flag = 0; 
}*/

void Data_Avg_Speed_Reset(void)
{
    AvgSpeed.Mileage       = 0;
    AvgSpeed.DrTime        = 0;
    AvgSpeed.Val           = 0;
    AvgSpeed.Dis           = 0;
    AvgSpeedDisTime        = 100;
    AvgSpeed.Speed         = 0;
}

/******************************************************************************
函数名：Data_Avg_Speed_Processing
功  能: 平均车速数据处理
参  数: 无
返回值：无
******************************************************************************/
void Data_Avg_Speed_Processing(void)
{
    INT8U i = 0;
	INT8U j = 0;
    INT8U temp = 0;
    if(SYS_OPR_STAT_IGN_ON)
    {
        if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_NORMAL)&&
       (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() != 1)&&
       (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP( ) <= 0x1FFF)&&(CanReceive.Can_0A18A006 == 1)&& 
       (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_NORMAL)&& 
       (Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() <= 0xFAFF)&&(CanReceive.Can_0CF00400 == 1))
        {
            if ( AvgSpeed.Mileage >= 10 )
            {
                AvgSpeed.Valid = 1;
            }

            if ( AvgSpeedDisTime < 10 )
            {
                AvgSpeedDisTime++;
            }
            else
            {
                AvgSpeedDisTime = 0;
                if ( AvgSpeed.DrTime )
                {
                    AvgSpeed.Val = (AvgSpeed.Speed) / AvgSpeed.DrTime;
                }
                else
                {
                    AvgSpeed.Val = 0;
                }
                if ( (AvgSpeed.Val % 10) >= 5 )
                {
                    AvgSpeed.Val += 5;
                }
                AvgSpeed.Val /= 10;
                if ( AvgSpeed.Val >= 180 )
                {
                    AvgSpeed.Val = 180;
                }
                AvgSpeed.Dis = AvgSpeed.Val;
            }
        }
    }
}

void AvgSpeed_DriTime_Add(uint32_t Inc)
{
    if(SYS_OPR_STAT_IGN_ON)
    {
        if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_NORMAL)&&(CanReceive.Can_0CF00400 == 1)&&
           (Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() <= 0xFAFF)&&(Get_DataESpeedValid() == 1))
        {
            if(Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() >= 0xC81)
            {
                EngSpeed_Start_Flag = 1;
            }
            else
            {
                if(Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() <= 0x960)
                {
                    EngSpeed_Start_Flag = 0;
                }
            }
        }
        else
        {
            EngSpeed_Start_Flag = 0;
        } 
        
        if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_NORMAL)&&(CanReceive.Can_0A18A006 == 1)&&
           (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() != 1)&&(Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP( ) <= 0x1FFF)&&
           (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_NORMAL)&& (CanReceive.Can_0CF00400 == 1)&&
           (Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() <= 0xFAFF)&&(Get_DataESpeedValid() == 1))
        {
            if ( AvgSpeed.DrTime >= 0x7FFFFFFF )
            {
                if (AvgSpeed.DrTime % 2 == 1)
				{
					AvgSpeed.DrTime = (AvgSpeed.DrTime / 2) + 1;
				}
				else
				{
					AvgSpeed.DrTime = AvgSpeed.DrTime / 2;
				}
            }

            if (EngSpeed_Start_Flag == 1)
            {
                AvgSpeed.DrTime += Inc;
            }
        }
    }
}

void Safety_Belt_DriTime_Add(uint32_t Inc)
{
    if(SYS_OPR_STAT_IGN_ON)
    {
        if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_NORMAL)&&
           (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() != 1)&&
           (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP( ) <= 0x1FFF)&&(CanReceive.Can_0A18A006 == 1)&& 
           (Common_Get_Act_V_Speed() != 0))
        {
            if ( AvgSpeed.Safety_Belt_DrTime >= 0x7FFFFFFF )
            {
                AvgSpeed.Safety_Belt_DrTime = 0;
            }
            AvgSpeed.Safety_Belt_DrTime += Inc;
        }
        else
        {
            AvgSpeed.Safety_Belt_DrTime = 0;
        } 
    }
}

void AvgSpeed_Milleage_Add(uint32_t Inc)
{
    if(SYS_OPR_STAT_IGN_ON)
    {
        if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_NORMAL)&&(CanReceive.Can_0A18A006 == 1)&&
           (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() != 1)&&(Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP( ) <= 0x1FFF)&&
           (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_NORMAL)&& (CanReceive.Can_0CF00400 == 1)&&
           (Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() <= 0xFAFF)&&(Get_DataESpeedValid() == 1))
        {
            if(EngSpeed_Start_Flag == 1)
            {
                if ( AvgSpeed.Mileage >= 0x7FFFFFFF )
                {
                    AvgSpeed.Mileage = 0;
                }
                AvgSpeed.Mileage += Inc;
            }
        }
    }
}

void AvgSpeed_Speed_Add(uint32_t Inc)
{
    if(SYS_OPR_STAT_IGN_ON)
    {
        if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_NORMAL)&&(CanReceive.Can_0A18A006 == 1)&&
           (Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() != 1)&&(Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP( ) <= 0x1FFF)&&
           (CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can0CF00400_Msg_Count) == CAN_SIG_NORMAL)&& (CanReceive.Can_0CF00400 == 1)&&
           (Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed() <= 0xFAFF)&&(Get_DataESpeedValid() == 1))
        {
            if(EngSpeed_Start_Flag == 1)
            {
                if ( AvgSpeed.Speed >= 0x7FFFFFFF )
                {
                    if (AvgSpeed.Speed % 2 == 1)
			        {
			        	AvgSpeed.Speed = (AvgSpeed.Speed / 2) + 1;
			        }
			        else
			        {
			        	AvgSpeed.Speed = AvgSpeed.Speed / 2;
			        }
                }
                AvgSpeed.Speed += Inc;
            }
        }
    }
}


uint8_t Get_EngSpeed_Start_Flag(void)
{
    return  EngSpeed_Start_Flag;
}

uint8_t GetAvgSpeed_Valid(void)
{
    return  AvgSpeed.Valid;
}

/* 获取行驶时间
100ms */
uint32_t GetDriverTime(void)
{
    return AvgSpeed.DrTime;
}

/* 获取行驶公里
系数0.1*/
uint32_t GetDriverMilleage(void)
{
    return AvgSpeed.Mileage;
}
/* 获取平均车速
系数：1*/
uint16_t GetAvgSpeed(void)
{
    return AvgSpeed.Dis;
}

