
#ifndef RTE_MEMORY_H
#define RTE_MEMORY_H

#include "TYW_stdint.h"
#include "Internal_EEPROM.h"

#define WriteDTCAddr              INTERNAL_EE_BLOCK_00
#define CalculateBlockSize(n)  ((n + 63) / 64)

/*每个结构占用的块数*/ 
#define WriteProgramValidFlagBlockSize   CalculateBlockSize(sizeof(DiagFlagUnion))
#define WriteSer27BlockSize              CalculateBlockSize(sizeof(Ser27_FlowCtrlCntUnion)) 
#define WriteBootDataBlockSize           CalculateBlockSize(sizeof(BootToDFlashInfoUnion)) 
#define WriteSer2EDataBlockSize          CalculateBlockSize(sizeof(Ser2EToDFlashInfoUnion))
//#define WriteEOLDataBlockSize            CalculateBlockSize(sizeof(EOLToDFlashInfoUnion))

/*实际的存储位置*/
#define WriteProgramValidFlagAddr        0
#define WriteSer27Addr                   WriteProgramValidFlagBlockSize  
#define WriteBootDataAddr                (WriteProgramValidFlagBlockSize + WriteSer27BlockSize)
#define WriteSer2EDataAddr               (WriteProgramValidFlagBlockSize + WriteSer27BlockSize)
//#define WriteEOLDataAddr                 (WriteProgramValidFlagBlockSize + WriteSer27BlockSize + WriteSer2EDataBlockSize)


#define OK 0x00u
#define Err 0x01u
#define MISALIGNED_ADDRESS 0x03u
#define ACCESS_ERROR 0x04u
#define VERIFICATION_FAILED 0x05u
#define LENGTH_OUT_OF_RANGE 0x06u

#define WriteFDL 0xfdu
#define WriteEEL 0xeeu

uint8_t DFlash_ReadData(uint32_t Adrr, uint8_t *Data, uint16_t len, uint32_t mode);
uint8_t DFlash_WriteData(uint32_t Adrr, uint8_t *Data, uint16_t len, uint32_t mode);

#endif
