#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "g_includes.h"

#include "TYW_stdint.h"
/* 2023/04/24 09:33:40 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

//const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
//{
//    0
//};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xCF00400ul,
        (( void * )0),
        (( void * )Can_0CF00400_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEF200ul,
        (( void * )0),
        (( void * )CAN_18FEF200_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEEE00ul,
        (( void * )0),
        (( void * )Can_18FEEE00_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEF100ul,
        (( void * )0),
        (( void * )Can_18FEF100_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF2100ul,
        (( void * )0),
        (( void * )Can_18FF2100_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FD0700ul,
        (( void * )0),
        (( void * )Can_18FD0700_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        20000ul,
        0x18FEFF00ul,
        (( void * )0),
        (( void * )Can_18FEFF00_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEE400ul,
        (( void * )0),
        (( void * )Can_18FEE400_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA00ul,
        (( void * )0),
        (( void * )Can_18FECA00_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FD7C00ul,
        (( void * )0),
        (( void * )Can_18FD7C00_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4C00ul,
        (( void * )0),
        (( void * )Can_18FF4C00_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF1021ul,
        (( void * )0),
        (( void * )Can_10FF1021_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10FF7521ul,
        (( void * )0),
        (( void * )Can_10FF7521_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FEF433ul,
        (( void * )0),
        (( void * )Can_18FEF433_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF9CF1ul,
        (( void * )0),
        (( void * )Can_18FF9CF1_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FECA03ul,
        (( void * )0),
        (( void * )CAN_1939_0X18FECA03_MSG_CKB_ON_RECEIVE),
        (( void * )CAN_1939_0X18FECA03_MSG_CKB_LOST),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0xA18A006ul,
        (( void * )0),
        (( void * )Can_0A18A006_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF4453ul,
        (( void * )0),
        (( void * )Can_18FF4453_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFA8EEul,
        (( void * )0),
        (( void * )Can_18FFA8EE_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FFB078ul,
        (( void * )0),
        (( void * )Can_18FFB078_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE4A03ul,
        (( void * )0),
        (( void * )Can_18FE4A03_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18F00503ul,
        (( void * )0),
        (( void * )Can_18F00503_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FF9DF1ul,
        (( void * )0),
        (( void * )Can_18FF9DF1_Receive),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFF03ul,
        (( void * )0),
        (( void * )CAN_1939_0X18ECFF03_MSG_CKB_ON_RECEIVE),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFF03ul,
        (( void * )0),
        (( void * )CAN_1939_0X18EBFF03_MSG_CKB_ON_RECEIVE),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18EBFF00ul,
        (( void * )0),
        (( void * )CAN_1939_0X18EBFF00_MSG_CKB_ON_RECEIVE),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18ECFF00ul,
        (( void * )0),
        (( void * )CAN_1939_0X18ECFF00_MSG_CKB_ON_RECEIVE),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x18FE5BE8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x10F007E8ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_EngDemandPercentTorque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_EngStarterMode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_SrcAddrssOfCtrllngDvcForEngCtrl(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_ActualEngPercentTorque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_DriversDemandEngPercentTorque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_EngTorqueMode_EDC_EEC1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0CF00400_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_18FEF200_Sig_EngAverageFuelEconomy(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF200_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF200_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEF200_Sig_EngInstantaneousFuelEconomy(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF200_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF200_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEF200_Sig_EngFuelRate(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF200_Msg_Count, 1u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF200_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18FEEE00_Sig_EngineOilTemp1(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEEE00_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEEE00_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_EngFuelTemp1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEEE00_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_EngCoolantTemp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEEE00_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_EngTestModeSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 7u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_Idle_decrement_sw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 7u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_Idle_increment_sw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 7u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 6u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_PTO_Sts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 6u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlSetSpeed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlAccelSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlResSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlCoastSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlSetSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CltSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_BrkSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 3u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlEnableSw(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlActive(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18FEF100_Sig_WheelBasedVehSpeed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF100_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_AirC_stPsCmpr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF2100_Msg_Count, 7u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_FuelFiltHeat(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF2100_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_EngOilPrsLow(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF2100_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_OilLifeMonSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF2100_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_MaxVehSpeedLimSetp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF2100_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_SpeedLimSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF2100_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD0700_Sig_OBD_MIL_LampSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FD0700_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EDC_WaterInFuelInd1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEFF00_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEE400_Sig_EDC_PrtctSysShutdEngine(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEE400_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEE400_Sig_EDC_WaittoStartLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEE400_Msg_Count, 3u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNConversionMethodABS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_OccurrenceCountABS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 5u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FMIABS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 4u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNLastBitABS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 4u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNSecondByteABS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNFirstByteABS(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashMil(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_Mil(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_RedStopLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_AmberWarnLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_ProtLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA00_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampInhibSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FD7C00_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FD7C00_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Minutes_Before_Limited_Vehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 6u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Hours_Before_Limited_Vehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 5u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Minutes_Before_Limited_Torque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 4u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Hours_Before_Limited_Torque(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 3u) >> 0u) & 0x3Fu));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Tank_Fluid_Level(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 1u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 1u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 0u) >> 4u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4C00_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RequestKeyStillInIndication(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 6u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RequestPositionLightStillOnInd(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 6u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHRearFogLightFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 5u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHRearFogLightFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 5u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RightTurnLightFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 4u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LeftTurnLightFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHStopLightFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHStopLightFailSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_HazardLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 3u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHTurnSignalSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 3u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHTurnSignalSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 3u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_FrontFogLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RearFogLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_HeatedMirrorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_ReverseSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 2u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHParkTailLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHParkTailLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_HighBeamSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LowBeamSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_BrakePedalSts_Rev(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_EngineSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_VehicleSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_StopLightSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF1021_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_AirbagFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 4u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_TPMSSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 4u) >> 0u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_KeySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 3u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_wiper(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 3u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_PsngrDoorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_DriverDoorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 2u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_WishWashSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 2u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_BonnetSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_RHatchSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_RHRDoorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_LHRDoorSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_CeilingLightSts_Rev(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10FF7521_Msg_Count, 0u) >> 5u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_TirePressureThresholdDetection(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 7u) >> 5u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_18FEF433_Sig_TireAirLeakageRate(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 6u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelEndElectricalFault(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_CTITireStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 4u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelSensorStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 4u) >> 0u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18FEF433_Sig_TireTemperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_TirePressure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_TireLocation(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FEF433_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_BatterySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 1u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_MemorySts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_VhctypmtchSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 1u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 1u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_CmmnctCANSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_GPSSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 0u) >> 3u) & 0x07u));
}

uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_CmmnctSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9CF1_Msg_Count, 0u) >> 0u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_18FECA03_Sig_Spn02ETC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_SPNConversionMethod01ETC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 5u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_OccurrenceCount01ETC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 5u) >> 0u) & 0x7Fu));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_FMI01ETC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 4u) >> 0u) & 0x1Fu));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_SpnHigh01ETC(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 4u) >> 5u) & 0x07u));
}

uint16_t Get_CAN_CH0_ID_18FECA03_Sig_Spn01ETC(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_AT_RedStopLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_AT_AmberWarnLamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FECA03_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_HhFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_0A18A006_Sig_PulseCntRhr(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 6u) >> 0u) & 0x1Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 4u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_PulseCntFailLhr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_PulseCntFailRhr(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 4u) >> 5u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_0A18A006_Sig_PulseCntLhr(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 4u) >> 0u) & 0x1Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_BsmBtnSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 2u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VdcCtrlSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 2u) >> 6u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 2u) >> 0u) & 0x1Fu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_AbsFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 1u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_EbdFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 1u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_AsrFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 1u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VdcFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 1u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_AsrEldInterv(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 1u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VdcInterv(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_Des_ESP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 0u) >> 3u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_Eol_ESP(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can0A18A006_Msg_Count, 0u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutPedestrSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutRolloverSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutRearSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutDrivSideSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 4u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutPassSideSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutFront2LevSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutFront1LevSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutFrontPtSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_AirbagFail(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 0u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_PassBagSts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF4453_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFA8EE_Sig_SelfCheckingStatus(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFA8EE_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRR_Dis(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRRM_Dis(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRLM_Dis(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRL_Dis(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorR_Configure(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 1u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 0u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorR_Sts(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FFB078_Msg_Count, 0u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmMode5Ind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FE4A03_Msg_Count, 5u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmMode1Ind(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FE4A03_Msg_Count, 2u) >> 6u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmEngCrkEna(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FE4A03_Msg_Count, 1u) >> 4u) & 0x03u));
}

uint16_t Get_CAN_CH0_ID_18F00503_Sig_TransmCurRng(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 7u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18F00503_Sig_TransmReqRng(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 5u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_18F00503_Sig_TransActualGearRatio(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 2u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18F00503_Sig_TransSelectedGear(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18F00503_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_LocalHrOfs_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_LocalMinOfs_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FF9DF1_Msg_Count, 0u) >> 0u) & 0xFFu));
}

//uint8_t  Get_CAN_CH0_ID_18FFA000_Sig_NM(void)
//{
//    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_NM18FFA000_Msg_Count, 0u) >> 0u) & 0x01u));
//}

uint8_t  Get_CAN_CH0_ID_18ECFF03_Sig_test(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18ECFF03_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18EBFF03_Sig_test(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18EBFF03_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18EBFF00_Sig_test(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18EBFF00_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_18ECFF00_Sig_test(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18ECFF00_Msg_Count, 0u) >> 0u) & 0x01u));
}
uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_Lane_Departure_Indication_Enable_Status(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FE5BE8_Msg_Count, 0u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_Lane_Tracking_Status_Left_Side(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FE5BE8_Msg_Count, 0u) >> 2u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_Lane_Tracking_Status_Right_Side(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can18FE5BE8_Msg_Count, 0u) >> 0u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_ADAS_LDWLeftWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10F007E8_Msg_Count, 0u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_ADAS_LDWRightWarning(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_can10F007E8_Msg_Count, 0u) >> 4u) & 0x01u));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_can0CF00400_Msg:
        u8Result = CAN_CH0_ID_can0CF00400_Msg_Count;
        break;
    case CAN_CH0_ID_can18FEF200_Msg:
        u8Result = CAN_CH0_ID_can18FEF200_Msg_Count;
        break;
    case CAN_CH0_ID_can18FEEE00_Msg:
        u8Result = CAN_CH0_ID_can18FEEE00_Msg_Count;
        break;
    case CAN_CH0_ID_can18FEF100_Msg:
        u8Result = CAN_CH0_ID_can18FEF100_Msg_Count;
        break;
    case CAN_CH0_ID_can18FF2100_Msg:
        u8Result = CAN_CH0_ID_can18FF2100_Msg_Count;
        break;
    case CAN_CH0_ID_can18FD0700_Msg:
        u8Result = CAN_CH0_ID_can18FD0700_Msg_Count;
        break;
    case CAN_CH0_ID_can18FEFF00_Msg:
        u8Result = CAN_CH0_ID_can18FEFF00_Msg_Count;
        break;
    case CAN_CH0_ID_can18FEE400_Msg:
        u8Result = CAN_CH0_ID_can18FEE400_Msg_Count;
        break;
    case CAN_CH0_ID_can18FECA00_Msg:
        u8Result = CAN_CH0_ID_can18FECA00_Msg_Count;
        break;
    case CAN_CH0_ID_can18FD7C00_Msg:
        u8Result = CAN_CH0_ID_can18FD7C00_Msg_Count;
        break;
    case CAN_CH0_ID_can18FF4C00_Msg:
        u8Result = CAN_CH0_ID_can18FF4C00_Msg_Count;
        break;
    case CAN_CH0_ID_can10FF1021_Msg:
        u8Result = CAN_CH0_ID_can10FF1021_Msg_Count;
        break;
    case CAN_CH0_ID_can10FF7521_Msg:
        u8Result = CAN_CH0_ID_can10FF7521_Msg_Count;
        break;
    case CAN_CH0_ID_can18FEF433_Msg:
        u8Result = CAN_CH0_ID_can18FEF433_Msg_Count;
        break;
    case CAN_CH0_ID_can18FF9CF1_Msg:
        u8Result = CAN_CH0_ID_can18FF9CF1_Msg_Count;
        break;
    case CAN_CH0_ID_can18FECA03_Msg:
        u8Result = CAN_CH0_ID_can18FECA03_Msg_Count;
        break;
    case CAN_CH0_ID_can0A18A006_Msg:
        u8Result = CAN_CH0_ID_can0A18A006_Msg_Count;
        break;
    case CAN_CH0_ID_can18FF4453_Msg:
        u8Result = CAN_CH0_ID_can18FF4453_Msg_Count;
        break;
    case CAN_CH0_ID_can18FFA8EE_Msg:
        u8Result = CAN_CH0_ID_can18FFA8EE_Msg_Count;
        break;
    case CAN_CH0_ID_can18FFB078_Msg:
        u8Result = CAN_CH0_ID_can18FFB078_Msg_Count;
        break;
    case CAN_CH0_ID_can18FE4A03_Msg:
        u8Result = CAN_CH0_ID_can18FE4A03_Msg_Count;
        break;
    case CAN_CH0_ID_can18F00503_Msg:
        u8Result = CAN_CH0_ID_can18F00503_Msg_Count;
        break;
    case CAN_CH0_ID_can18FF9DF1_Msg:
        u8Result = CAN_CH0_ID_can18FF9DF1_Msg_Count;
        break;
    //case CAN_CH0_ID_NM18FFA000_Msg:
        //u8Result = CAN_CH0_ID_NM18FFA000_Msg_Count;
        break;
    case CAN_CH0_ID_can18ECFF03_Msg:
        u8Result = CAN_CH0_ID_can18ECFF03_Msg_Count;
        break;
    case CAN_CH0_ID_can18EBFF03_Msg:
        u8Result = CAN_CH0_ID_can18EBFF03_Msg_Count;
        break;
    case CAN_CH0_ID_can18EBFF00_Msg:
        u8Result = CAN_CH0_ID_can18EBFF00_Msg_Count;
        break;
    case CAN_CH0_ID_can18ECFF00_Msg:
        u8Result = CAN_CH0_ID_can18ECFF00_Msg_Count;
        break;
    case CAN_CH0_ID_can18FE5BE8_Msg:
        u8Result = CAN_CH0_ID_can18FE5BE8_Msg_Count;
        break;
    case CAN_CH0_ID_can10F007E8_Msg:
        u8Result = CAN_CH0_ID_can10F007E8_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}





