/*
****************************************************************************
PROJECT : VLIB - BSP
FILE    : $Id: r_bsp.c 7262 2016-01-15 13:34:37Z michael.golczewski $
============================================================================
DESCRIPTION
BSP Implementation D1Lx MANGO Board
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2015
                                  by
                    Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2011 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/

/*
  Section: BSP Description

    The "D1Lx-Mango Board" Support Package is intended for the
    following board combination:

    BSP Board Name: "D1Lx-MANGO Board"
        + D1L2 or D1L2H MANGO Adapter board (with D1L1 or D1L2 or D1L2H MCU)
        + D1x MANGO Main board
*/

/*******************************************************************************
  Section: Includes
*/

#include "r_typedefs.h" /* Renesas basic types, e.g. uint32_t */

#include "r_gpio_api.h"
#include "r_dev_api.h"
#include "r_bsp_api.h"

#ifdef USE_BSP_GFX
    #include "r_bsp_gfx_api.h"
#endif /* USE_BSP_GFX */

/*******************************************************************************
  Section: Local Defines
*/

/* make sure we have the information ready */
/* BSP_SHOW_INFO:     Print Clock Config at the end of BSP init */
/* BSP_PROVIDE_INFO:  Pprovide the API function to call the colck config print (later) */

/* Module reset control register */
#define LOC_MRSTC       0xFFF8F400u
#define LOC_PROTSMRST   0xFFF8F484u
#define LOC_PROTCMDMRST 0xFFF8F480u

/* Module reset control register bits */
#define MRSTC_XC0RES   (( uint32_t )(1ul << 13u))
#define MRSTC_SDRB0RES (( uint32_t )(1ul << 12u))
#define MRSTC_MLBB0RES (( uint32_t )(1ul << 11u))
#define MRSTC_LCBI0RES (( uint32_t )(1ul << 10u))
#define MRSTC_SG4RES   (( uint32_t )(1ul << 9u))
#define MRSTC_SG3RES   (( uint32_t )(1ul << 8u))
#define MRSTC_SG2RES   (( uint32_t )(1ul << 7u))
#define MRSTC_SG1RES   (( uint32_t )(1ul << 6u))
#define MRSTC_SG0RES   (( uint32_t )(1ul << 5u))
#define MRSTC_ADCE0RES (( uint32_t )(1ul << 4u))
#define MRSTC_ISM0RES  (( uint32_t )(1ul << 3u))
#define MRSTC_ETNB0RES (( uint32_t )(1ul << 2u))
#define MRSTC_VDCE1RES (( uint32_t )(1ul << 1u))
#define MRSTC_VDCE0RES (( uint32_t )(1ul << 0u))

/*******************************************************************************
  Array loc_ClkSelectionCfgD1L1

  contains the clock selectors configuration for D1L1
  (deviates from D1L2 setting only by slower SFMA clock)
*/
static const r_dev_ClkSelConfig_t loc_ClkSelectionCfgD1L1 [] =
    /*   Cks                   SrcId                Div  StpReqMsk      */
    {
        {R_DEV_CKS_OSTM, R_DEV_CKS_SRC_MOSC, 2, 0u},
        {R_DEV_CKS_CLKJIT, R_DEV_CKS_SRC_DIV, 6, 0u},
        {R_DEV_CKS_PLLFIX, R_DEV_CKS_SRC_PLL1, 4, 0u},
        {R_DEV_CKS_CLKFIX, R_DEV_CKS_SRC_DIV, 12, 0u},
        {R_DEV_CKS_CPU, R_DEV_CKS_SRC_PLL0, 4, 0u},
        {R_DEV_CKS_PLL2IN, R_DEV_CKS_SRC_MOSC, 1, 0u},
        {R_DEV_CKS_SFMA, R_DEV_CKS_SRC_PLL1, 6, 0u},
        /* delimiter - do not remove */
        {R_DEV_CKS_LAST, R_DEV_CKS_SRC_MOSC, 2, 0u}};

/*******************************************************************************
  Function: loc_InitClocks

  This function just contains the starting (global) clock config for the BSP.
  Its purpose is to write the given setting in the structure passed as parameter.

  As the clock config is done in low init, the globally stored data is cleared
  afterwards. So, this function has to be called during and after the low init
  in order to have the right settings afterwards. And becasue we want to keep data
  consistant and do not have two configs, this funbction is used.

  Parameters:
  ClkGenCfg - pointer to the Clock generator configuration,
              see <r_dev_ClkGenConfig_t>

  Returns:
  none

*/
void loc_InitClocks(r_dev_ClkGenConfig_t *Config)
{
    /* Init Device Clocks  */
    Config->MainOsc.FrequencyHz = R_DEV_MOSC_FRQ_HZ;
    Config->MainOsc.StabiTimeNs = 400000;/*起振时间*/
    Config->MainOsc.Gain        = 3;
    Config->MainOsc.Running     = 1;
    Config->MainOsc.StpReqMsk   = 1;
    Config->SubOsc.FrequencyHz  = 32768;
    Config->SubOsc.Running      = 0;
    Config->RoscStpReqMsk       = 0;

    Config->Pll [ 0 ].Mode        = R_DEV_PLL_SSCG;
    Config->Pll [ 0 ].DithMode    = R_DEV_PLL_DITH_CENTER;
    Config->Pll [ 0 ].DithRange   = 3;
    Config->Pll [ 0 ].ModFreq     = 50;
    Config->Pll [ 0 ].FrequencyHz = 480 * 1000 * 1000;
    Config->Pll [ 0 ].StabiTimeNs = 40000;
    Config->Pll [ 0 ].StpReqMsk   = 0;

    Config->Pll [ 1 ].Mode        = R_DEV_PLL_ON;
    Config->Pll [ 1 ].DithMode    = R_DEV_PLL_DITH_FIXED;
    Config->Pll [ 1 ].DithRange   = 0;
    Config->Pll [ 1 ].ModFreq     = 0;
    Config->Pll [ 1 ].FrequencyHz = 480 * 1000 * 1000;
    Config->Pll [ 1 ].StabiTimeNs = 40000;
    Config->Pll [ 1 ].StpReqMsk   = 0;

    Config->Pll [ 2 ].Mode        = R_DEV_PLL_OFF;
    Config->Pll [ 2 ].DithMode    = R_DEV_PLL_DITH_FIXED;
    Config->Pll [ 2 ].DithRange   = 0;
    Config->Pll [ 2 ].ModFreq     = 0;
    Config->Pll [ 2 ].FrequencyHz = 480 * 1000 * 1000;
    Config->Pll [ 2 ].StabiTimeNs = 40000;
    Config->Pll [ 2 ].StpReqMsk   = 0;

    Config->BusEnable [ R_DEV_CLK_XCC ]     = 1;
    Config->BusEnable [ R_DEV_CLK_PLL0 ]    = 1;
    Config->BusEnable [ R_DEV_CLK_PLL1 ]    = 1;
    Config->BusEnable [ R_DEV_CLK_PLL2 ]    = 0;
    Config->BusEnable [ R_DEV_CLK_PLL0PIX ] = 1;
    Config->BusEnable [ R_DEV_CLK_SDRB ]    = 1;
    Config->BusEnable [ R_DEV_CLK_ETNBP ]   = 1;
    Config->BusEnable [ R_DEV_CLK_ETNBXCC ] = 1;
    Config->BusEnable [ R_DEV_CLK_MLBP ]    = 0;
    Config->BusEnable [ R_DEV_CLK_MLBXCC ]  = 0;
    Config->BusEnable [ R_DEV_CLK_RSCANP ]  = 1;
}
/*******************************************************************************
  Section: Global Device/Board dependent Functions

  For comments see: <r_bsp_api.h>
*/

/*******************************************************************************
  Function: R_BSP_LowInit

  see <r_bsp_api.h> for details
*/
void R_BSP_LowInit(void)
{
    uint32_t             val;
    r_dev_ClkGenConfig_t clk_gen_cfg;

    /* Release all Modules by module reset control register */
    val = (0ul | MRSTC_XC0RES | MRSTC_MLBB0RES | MRSTC_LCBI0RES | MRSTC_SG4RES | MRSTC_SG3RES | MRSTC_SG2RES | MRSTC_SG1RES | MRSTC_SG0RES | MRSTC_ADCE0RES | MRSTC_ISM0RES | MRSTC_ETNB0RES | MRSTC_VDCE1RES | MRSTC_VDCE0RES);
    R_DEV_WRITE_PROT_REG(LOC_PROTCMDMRST, LOC_MRSTC, val);
    while ( 0 != R_DEV_READ_REG(32, LOC_PROTSMRST) ) /* Read PROTSMRST */
    {
    }

    /* Prepare device (clear all internal config, prepare interrupts) */
    R_DEV_Prepare( );
    /* Get the config */
    loc_InitClocks(&clk_gen_cfg);
    R_DEV_ClkGenInit(&clk_gen_cfg, loc_ClkSelectionCfgD1L1);
}

/*******************************************************************************
  Function: R_BSP_Init

  see <r_bsp_api.h> for details
*/
r_Error_t R_BSP_Init(void)
{
    r_Error_t            ret_val = R_ERR_OK;
    r_dev_ClkGenConfig_t clk_gen_cfg;

    R_BSP_LowInit( );

    /* Get the config */
    loc_InitClocks(&clk_gen_cfg);

    /* use the config, store settings */
    R_DEV_ClkGenInitStore(&clk_gen_cfg);

    /* Enable interrupts globally */
    __EI( );

    /* init tick driver */
    /*     if ( R_TICK_Init(0) != R_TICK_ERR_OK )
        {
            return R_NG;
        }
     */
    /* R_BSP_GFX_Init( ); */

    return (ret_val);
}

/*******************************************************************************
  Function: R_BSP_DeInit

  see <r_bsp_api.h> for details
*/
r_Error_t R_BSP_DeInit(void)
{
    return R_ERR_OK;
}
