#ifndef GPIO_H__
#define GPIO_H__

typedef enum
{
    GPIO_PORT_GROUP_0   = 0U,
    GPIO_PORT_GROUP_1   = 1U,
    GPIO_PORT_GROUP_3   = 3U,
    GPIO_PORT_GROUP_10  = 10U,
    GPIO_PORT_GROUP_11  = 11U,
    GPIO_PORT_GROUP_16  = 16U,
    GPIO_PORT_GROUP_17  = 17U,
    GPIO_PORT_GROUP_21  = 21U,
    GPIO_PORT_GROUP_22  = 22U,
    GPIO_PORT_GROUP_42  = 42U,
    GPIO_PORT_GROUP_43  = 43U,
    GPIO_PORT_GROUP_44  = 44U,
    GPIO_PORT_GROUP_45  = 45U,
    GPIO_PORT_GROUP_JP0 = 46U,
} GPIO_Port_en_t;
typedef enum
{
    GPIO_PIN_0 = 0X0U,
    GPIO_PIN_1,
    GPIO_PIN_2,
    GPIO_PIN_3,
    GPIO_PIN_4,
    GPIO_PIN_5,
    GPIO_PIN_6,
    GPIO_PIN_7,
    GPIO_PIN_8,
    GPIO_PIN_9,
    GPIO_PIN_10,
    GPIO_PIN_11,
    GPIO_PIN_12,
    GPIO_PIN_13,
    GPIO_PIN_14,
    GPIO_PIN_15,
} GPIO_PIN_en_t;

typedef enum
{
    GPIO_Input_Buf_Close = 0U,
    GPIO_Input_Buf_Open,
} GPIO_Buf_Control_en_t;

typedef enum
{
    GPIO_MODE_PORT = 0U,
    GPIO_MODE_ALTER_SOFTWARE,
    GPIO_MODE_ALTER_DIRECT,
} GPIO_Mode_en_t;

typedef enum
{
    GPIO_ALTER_FUN_1 = 0U,
    GPIO_ALTER_FUN_2,
    GPIO_ALTER_FUN_3,
    GPIO_ALTER_FUN_4,
    GPIO_ALTER_FUN_5,
    GPIO_ALTER_FUN_6,
} GPIO_Alter_Fuction_en_t;

typedef enum
{
    GPIO_DIR_OUT = 0U,
    GPIO_DIR_IN
} GPIO_Direction_en_t;
typedef enum
{
    GPIO_Level_Low = 0U,
    GPIO_Level_High,
} GPIO_Level_en_t;
typedef enum
{
    GPIO_PULL_NONE = 0U,
    GPIO_PULL_UP,
    GPIO_PULL_DOWN,
} GPIO_Pull_en_t;
typedef enum
{
    GPIO_Drive_Slow = 0U,
    GPIO_Drive_Fast,
} GPIO_Strength_en_t;
typedef enum
{
    GPIO_Char_TTL = 0U,
    GPIO_Char_CMOS1,
    GPIO_Char_Schmitt1,
    GPIO_Char_Schmitt4,
} GPIO_Characteristics_en_t;

typedef struct
{
    GPIO_Port_en_t            enGPIOPort;
    GPIO_PIN_en_t             enGPIOPIN;
    GPIO_Strength_en_t        enGPIODrive;
    GPIO_Characteristics_en_t enGPIOCharacter;
    GPIO_Pull_en_t            enGPIOPull;
    GPIO_Level_en_t           enGPIOOutputValue;
    GPIO_Mode_en_t            enGPIOMode;
    GPIO_Direction_en_t       enGPIODir;
    GPIO_Alter_Fuction_en_t   enGPIOAltFun;

} GPIO_Config_st_t;

typedef enum
{
    GPIO_WAKEUP_MODE = 0U,
    GPIO_SLEEP_MODE,

} GPIO_Config_Mode_en_t;

typedef enum
{
    GPIO_WAKEUP_PIN_P0_0 = 0X06U,
    GPIO_WAKEUP_PIN_P0_1 = 0X01U,
    GPIO_WAKEUP_PIN_P0_2 = 0X02U,
    GPIO_WAKEUP_PIN_P0_3 = 0X03U,
    GPIO_WAKEUP_PIN_P0_4 = 0X06U,
    GPIO_WAKEUP_PIN_P0_5 = 0X07U,
    GPIO_WAKEUP_PIN_P0_6 = 0X08U,
    GPIO_WAKEUP_PIN_P0_7 = 0X09U,
    GPIO_WAKEUP_PIN_P0_8 = 0X0AU,
    GPIO_WAKEUP_PIN_P0_9 = 0X0BU,

} GPIO_Wakeup_PIN_en_t;
typedef enum
{
    GPIO_WAKEUP_NONE = 0X0U,
    GPIO_WAKEUP_RISING_EDGE,
    GPIO_WAKEUP_FALLING_EDGE,
    GPIO_WAKEUP_BOTH_EDGE,
    GPIO_WAKEUP_LOW_LEVEL,
    GPIO_WAKEUP_HIGH_LEVEL,

} GPIO_Wakeup_Trigger_Mode_en_t;

/**/
void GPIO_Config(GPIO_Config_st_t *pstGPIOConfig);
extern void GPIO_Init(GPIO_Config_Mode_en_t enGPIOConfigMode);
extern void GPIO_Wakeup_PIN_Set(GPIO_Wakeup_PIN_en_t enGPIOWakeupPIN, GPIO_Wakeup_Trigger_Mode_en_t enGPIOTrigger);
extern void Sys_Enter_Sleep_Mode(void);

#endif
