#ifndef TYW_SFMA0_H
#define TYW_SFMA0_H
#include "r_typedefs.h"
/*------------------------------------------------------------------------------------------------------*/
/* Constant definition                                                                                  */
/*------------------------------------------------------------------------------------------------------*/
/* return value */
#define U1G_SFMA0_RET_OK       (( uint8_t )0) /* OK                                   */
#define U1G_SFMA0_RET_NG_PARAM (( uint8_t )1) /* Parameter Invalid                    */
#define U1G_SFMA0_RET_NG_FAIL  (( uint8_t )2) /* Fail                                 */

/* value number */
#define U1G_SFMA0_NUM_OP_DATA (( uint8_t )4) /* Number of Option Data                */
#define U1G_SFMA0_NUM_DATA    (( uint8_t )2) /* Number of Transfer Data              */

/* value for "Address Enable" */
#define U1G_SFMA0_EN_ADDR_DISABLE (( uint8_t )0x00) /* Output disabled                      */
#define U1G_SFMA0_EN_ADDR_8BIT    (( uint8_t )0x04) /* ADR[23:16]                           */
#define U1G_SFMA0_EN_ADDR_16BIT   (( uint8_t )0x06) /* ADR[23:8]                            */
#define U1G_SFMA0_EN_ADDR_24BIT   (( uint8_t )0x07) /* ADR[23:0]                            */
#define U1G_SFMA0_EN_ADDR_32BIT   (( uint8_t )0x0F) /* ADR[31:0]                            */

/* value for "Option Data Enable" */
#define U1G_SFMA0_EN_OP_DATA_DISABLE   (( uint8_t )0x00) /* Output disabled                      */
#define U1G_SFMA0_EN_OP_DATA_OPD3      (( uint8_t )0x08) /* OPD3                                 */
#define U1G_SFMA0_EN_OP_DATA_OPD3_OPD2 (( uint8_t )0x0C) /* OPD3, OPD2                           */
#define U1G_SFMA0_EN_OP_DATA_OPD3_OPD1 (( uint8_t )0x0E) /* OPD3, OPD2, OPD1                     */
#define U1G_SFMA0_EN_OP_DATA_OPD3_OPD0 (( uint8_t )0x0F) /* OPD3, OPD2, OPD1, OPD0               */

/* value for "Transfer Data Enable" */
#define U1G_SFMA0_EN_DATA_DISABLE (( uint8_t )0x00) /* Not transferred                      */
#define U1G_SFMA0_EN_DATA_16BIT   (( uint8_t )0x08) /* 16 bits transferred                  */
#define U1G_SFMA0_EN_DATA_32BIT   (( uint8_t )0x0C) /* 32 bits transferred                  */
#define U1G_SFMA0_EN_DATA_64BIT   (( uint8_t )0x0F) /* 64 bits transferred                  */

/* value for "Transfer Data Enable" */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_1 (( uint8_t )0x00) /* 1 cycle                              */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_2 (( uint8_t )0x01) /* 2 cycles                             */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_3 (( uint8_t )0x02) /* 3 cycles                             */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_4 (( uint8_t )0x03) /* 4 cycles                             */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_5 (( uint8_t )0x04) /* 5 cycles                             */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_6 (( uint8_t )0x05) /* 6 cycles                             */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_7 (( uint8_t )0x06) /* 7 cycles                             */
#define U1G_SFMA0_NUM_DUMMY_CYCLE_8 (( uint8_t )0x07) /* 8 cycles                             */

/* value for "Command Bit Size", "Optional Command Bit Size", "Address Bit Size", */
/* "Option Data Bit Size" , "Transfer Data Bit Size", "Dummy Cycle Bit Size" */
#define U1G_SFMA0_SIZE_1BIT (( uint8_t )0x00) /* 1 bit                                */
#define U1G_SFMA0_SIZE_2BIT (( uint8_t )0x01) /* 2 bits                               */
#define U1G_SFMA0_SIZE_4BIT (( uint8_t )0x02) /* 4 bits                               */

/*------------------------------------------------------------------------------------------------------*/
/* Type definition                                                                                      */
/*------------------------------------------------------------------------------------------------------*/
/* data transfer */
/*                                                                              */
/* <MEMO>                                                                       */
/* - Setting value for members:                                                 */
/*      - b4_en_addr        : U1G_SFMA0_EN_ADDR_xxx                             */
/*      - b4_en_op_data     : U1G_SFMA0_EN_OP_DATA_xxx                          */
/*      - b4_en_data        : U1G_SFMA0_EN_DATA_xxx                             */
/*      - b1_en_cmd         : ON(enable), OFF(disable)                          */
/*      - b1_en_op_cmd      : ON(enable), OFF(disable)                          */
/*      - b1_en_dmy_cycle   : ON(enable), OFF(disable)                          */
/*      - b1_en_write       : ON(enable), OFF(disable)                          */
/*      - b1_en_read        : ON(enable), OFF(disable)                          */
/*      - b1_ddr_addr       : ON(DDR), OFF(SDR)                                 */
/*      - b1_ddr_op_data    : ON(DDR), OFF(SDR)                                 */
/*      - b1_ddr_data       : ON(DDR), OFF(SDR)                                 */
/*      - b1_keep_ssl       : ON(SPBSSL is maintained at the end of transfer)   */
/*                          : OFF(SPBSSL is negated at the end of transfer)     */
/*      - b3_num_dmy_cycle  : U1G_SFMA0_NUM_DUMMY_CYCLE_xxx                     */
/*      - b2_size_cmd       : U1G_SFMA0_SIZE_xxx                                */
/*      - b2_size_op_cmd    : U1G_SFMA0_SIZE_xxx                                */
/*      - b2_size_addr      : U1G_SFMA0_SIZE_xxx                                */
/*      - b2_size_op_data   : U1G_SFMA0_SIZE_xxx                                */
/*      - b2_size_data      : U1G_SFMA0_SIZE_xxx                                */
/*      - b2_size_dmy_cycle : U1G_SFMA0_SIZE_xxx                                */
/*      - u1_cmd            : any data                                          */
/*      - u1_opcmd          : any data                                          */
/*      - u4_addr           : any data                                          */
/*      - au1_op_data       : any data                                          */
/*      - au4_wdata         : any data                                          */
/*      - au4_rdata         : do not set this member.                           */
typedef struct
{
    uint32_t b4_en_addr       : 4; /* Address Enable                       */
    uint32_t b4_en_op_data    : 4; /* Option Data Enable                   */
    uint32_t b4_en_data       : 4; /* Transfer Data Enable                 */
    uint32_t b1_en_cmd        : 1; /* Command Enable                       */
    uint32_t b1_en_op_cmd     : 1; /* Optional Command Enable              */
    uint32_t b1_en_dmy_cycle  : 1; /* Dummy Cycle Enable                   */
    uint32_t b1_en_write      : 1; /* Data Write Enable                    */
    uint32_t b1_en_read       : 1; /* Data Read Enable                     */
    uint32_t b1_ddr_addr      : 1; /* Address DDR Enable                   */
    uint32_t b1_ddr_op_data   : 1; /* Option Data DDR Enable               */
    uint32_t b1_ddr_data      : 1; /* Transfer Data DDR Enable             */
    uint32_t b1_keep_ssl      : 1; /* SPBSSL Signal Level Keep             */
    uint32_t b3_num_dmy_cycle : 3; /* Number of Dummy Cycles               */
    uint32_t b2_size_cmd      : 2; /* Command Bit Size                     */
    uint32_t b2_size_op_cmd   : 2; /* Optional Command Bit Size            */
    uint32_t b2_size_addr     : 2; /* Address Bit Size                     */
    uint32_t b2_size_op_data  : 2; /* Option Data Bit Size                 */
    /* --alignment-- */
    uint8_t b2_size_data      : 2; /* Transfer Data Bit Size               */
    uint8_t b2_size_dmy_cycle : 2; /* Dummy Cycle Bit Size                 */
    uint8_t                   : 4; /* reserved                             */
    uint8_t u1_cmd;                /* Command                              */
    uint8_t u1_opcmd;              /* Option Command                       */
    uint8_t u1_reserved;           /* reserved                             */
    /* --alignment-- */
    uint32_t u4_addr; /* Address                              */
    /* --alignment-- */
    uint8_t au1_op_data [ U1G_SFMA0_NUM_OP_DATA ]; /* Option Data                          */
    /* --alignment-- */
    uint32_t au4_wdata [ U1G_SFMA0_NUM_DATA ]; /* Write Data                           */
    /* --alignment-- */
    uint32_t au4_rdata [ U1G_SFMA0_NUM_DATA ]; /* Read Data                            */
} st_SFMA0_Transfer;

/*------------------------------------------------------------------------------------------------------*/
/* Prototype declaration                                                                                */
/*------------------------------------------------------------------------------------------------------*/
extern void    TYW_SFMA0_Init(void);                                 /* Initialize SFMA0                     */
extern uint8_t TYW_SFMA0_Transfer(st_SFMA0_Transfer *pstt_transfer); /* Data Transfer                        */

#endif /* SFMA0_H */