#include "UDS_28Service_Main.h"

/**
  *28服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_28_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC11();                                            /*28服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC7F();                                            /*28服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC33();                                            /*28服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC13_MinLengthCheck();                             /*28服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC12();                                        /*28服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC13_TotalLengthCheck();                           /*28服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC31();                                            /*28服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_NRC22();                                            /*28服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_28Service_Sub();                                                    /*28服务子功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *28服务子功能
  */
void UDS_28Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC13_MinLengthCheck();                         /*28服务子功能最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC7E();                                        /*28服务子功能会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC31();                                        /*28服务子功能超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC13_TotalLengthCheck();                       /*28服务子功能总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC24();                                        /*28服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_28Service_Sub_NRC22();                                        /*28服务子功能条件验证*/
    }
    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.S28Detail.SubID)                                 /*子服务判断*/
        {
        case enableRxAndTx:
            UDS_28Service_Sub00();                                              /*28服务00子功能*/
            break;
        case enableRxAndDisableTx:
            UDS_28Service_Sub01();                                              /*28服务00子功能*/
            break;
        case disableRxAndEnableTx:
            UDS_28Service_Sub02();                                              /*28服务00子功能*/
            break;
        case disableRxAndTx:
            UDS_28Service_Sub03();                                              /*28服务00子功能*/
            break;
        default:
            break;
        }
    }
}
 
/**
  *28服务00子功能
  */
void UDS_28Service_Sub00(void)
{
    ControlMessageCommunication(DiagMSG.msgData.S28Detail.ContrlType, enableRxAndTx);
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x28u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}

/**
  *28服务01子功能
  */
void UDS_28Service_Sub01(void)
{
    ControlMessageCommunication(DiagMSG.msgData.S28Detail.ContrlType, enableRxAndDisableTx);
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x28u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}

/**
  *28服务02子功能
  */
void UDS_28Service_Sub02(void)
{
    ControlMessageCommunication(DiagMSG.msgData.S28Detail.ContrlType, disableRxAndEnableTx);
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x28u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}
/**
  *28服务03子功能
  */
void UDS_28Service_Sub03(void)
{
    ControlMessageCommunication(DiagMSG.msgData.S28Detail.ContrlType, disableRxAndTx);
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x28u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}