//#include <math.h>
//#include <string.h>
//#include <stdlib.h>
//#include "Graphics_TripC.h"
//#include "ResistorCalculate.h"
#include "fuelconfig.h"
#include "g_includes.h"
#include <string.h>

#pragma ghs section bss = ".myNonInitArea"

_MinFuel_Data_Struct MinFuelData;
AFC_PARA MinAFCPara;
AFC_INIT MinAFCInit;
_BackFuelData BackFuelData;
FuelStruct FuelInit;
_MinFuelDis MinFuelMeter;
_FuelDis FuelMeter;

#pragma ghs section bss = default

uint8_t FuelLowTX;
uint16_t FuelActive;
uint16_t FuelLowDelay;
uint16_t FuelLowDelay1;
uint8_t FuelLowLedFlag;

_Data_InsFuel_Struct Data_InsFuel;

#pragma ghs section bss = ".myNonInitArea"
#pragma alignvar(8)
 uint16_t DrivingRangeSaveLen  ;
 #pragma alignvar(8)
 uint16_t FuelSaveLen ;
#pragma alignvar(8)
 uint8_t DrivingRangeSaveData[1024] ;
 #pragma alignvar(8)
 uint8_t FuelSaveData[1024];




 #pragma ghs section bss = default

#if 1

void SetFuelInit(void)
{
    FuelInit.LowFuelWarningFuelCapacity = 0;
    FuelInit.LowFuelWarningReleaseResistance = 0;
    FuelInit.LowFuelWarningResistance = 0;
    FuelInit.RefuleDteFuelChangeThreshold = 0;
    
    FuelInit.FuelShortCircuitR = 0;
    FuelInit.FuelOpenCircuitR = 5150;

    FuelInit.FullFuelStopCapacity = 70000-0;  //S/F
    FuelInit.EmptyFuelStopCapacity = 0;     //S/E
    
    FuelInit.DisplayZoneBoundary[0] =   5000; // E
    FuelInit.DisplayZoneBoundary[1] =   2950; // E
    FuelInit.DisplayZoneBoundary[2] =   2550; // 1/8-
    FuelInit.DisplayZoneBoundary[3] =   2160; // 2/8-
    FuelInit.DisplayZoneBoundary[4] =   1860; // 3/8-
    FuelInit.DisplayZoneBoundary[5] =   1440; // 4/8
    FuelInit.DisplayZoneBoundary[6] =   1130; // 5/8
    FuelInit.DisplayZoneBoundary[7] =   800; // 6/8
    FuelInit.DisplayZoneBoundary[8] =   620; // 7/8
    FuelInit.DisplayZoneBoundary[9] =   440; // F
    FuelInit.DisplayZoneBoundary[10] =  0;
    
    FuelInit.FuelCapacityBoundary[0] =  0;//0
    FuelInit.FuelCapacityBoundary[1] =  0;//0
    FuelInit.FuelCapacityBoundary[2] =  70000-4000-51000;
    FuelInit.FuelCapacityBoundary[3] =  70000-4000-49000;
    FuelInit.FuelCapacityBoundary[4] =  70000-4000-43300;
    FuelInit.FuelCapacityBoundary[5] =  70000-4000-31800;
    FuelInit.FuelCapacityBoundary[6] =  70000-4000-23500;
    FuelInit.FuelCapacityBoundary[7] =  70000-4000-15500;
    FuelInit.FuelCapacityBoundary[8] =  70000-4000-8000;
    FuelInit.FuelCapacityBoundary[9] =  70000-4000-6000;
    FuelInit.FuelCapacityBoundary[10] = 70000-4000;
    
    InitFuelParamter(&FuelInit);
    FuelSaveLen = 0;
    DrivingRangeSaveLen = 0;
    memset(FuelSaveData, 0, sizeof (FuelSaveData));
    SetFuelSaveData(FuelSaveData, FuelSaveLen);
    memset(DrivingRangeSaveData, 0, sizeof (DrivingRangeSaveData));
    SetDrivingRangeSaveData(DrivingRangeSaveData, DrivingRangeSaveLen);

    SetFuelSensorRecoverGroupCnt(40);
    SetFuelSensorOpenCircuitGroupCnt(40);
    SetFuelSensorShortCircuitGroupCnt(40);
    
    MinAFCInit.CalcAFCMaxNum = 100;
    MinAFCInit.AFCMin = 0;  
    MinAFCInit.AFCMax = 199;
    MinAFCInit.AFCPreinstall = 130;//default Avgfuel
    MinAFCInit.CurODO = Mile_Get_Index_Value(MILE_INDEX_ODO)*100;
    MinAFCInit.MaxDRMileage = 200000;
    
    InitAFC(&MinAFCInit);
}

void FuelAFCTimeCall(void)
{
    GET_Data_For_YB();
    AFCTimerCall();
}

void GET_Data_For_YB(void)
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        SetPowerSt(1u);
    }
    else
    {
        SetPowerSt(0u);
    }

    if (SYS_OPR_STAT_IGN_ON)
    {
        MinAFCPara.Speed = Common_Get_Act_V_Speed(); 
        MinAFCPara.RPM = Get_DispEngineSpeed();   
        MinAFCPara.CurODO = Mile_Get_Index_Value(MILE_INDEX_ODO)*100;
        if(GET_AvgFuel_ConsOf100msUL_Value()>= 65535)
        {
            MinAFCPara.FuleConsume = 65535;    
        }
        else
        {
            MinAFCPara.FuleConsume = (uint16_t)(GET_AvgFuel_ConsOf100msUL_Value()); 
        }
    }
    else
    {
        MinAFCPara.Speed = 0;
        MinAFCPara.RPM = 0;
    }
    SetAFCPara((AFC_PARA *)&MinAFCPara);
    BackFuelData.FuelMinResistance = ADC_Read_Signal(ADC_CH_FUEL_RES);//样表不判短路,显示满油,柴油车
    if(BackFuelData.FuelMinResistance > 30)
    {
        FuelFSM(BackFuelData.FuelMinResistance);
    }
    else
    {
        FuelFSM(30);
    }
    AvgFuel_ConsOf100msUL_Set(0);
}

void ExecFuel_Init(void)
{
	MinFuelData.Sensor_State = 0;
	MinFuelData.Step_Get_Valid = 0;
	MinFuelData.Step_Get_Value = 0;
	MinFuelData.Res_Pre_Get = 0;
	MinFuelData.Capacity_Val = 0;
}

void ExecFuel(void)
{
    uint32_t Wtemp = 0;
    if (SYS_OPR_STAT_IGN_ON)
    {
        MinFuelData.Sensor_State = GetFuelSensorState();
        if (MinFuelData.Sensor_State == FuelSensorNormal) //
        {
            MinFuelMeter.Icon = 1; 
            MinFuelData.Step_Get_Valid = 1;  
            MinFuelData.Step_Get_Value = GetFuelStep();
            MinFuelData.Res_Pre_Get = GetFuelResistance(); //  zu zhi
            //if (Line_In_Get_Status(LINE_IN_Block_Diesel_Filter) == 1u)
            //{
            //    MinFuelData.Fuel_Sensor_Resistance_High = 1;
            //}
            if ((MinFuelData.Res_Pre_Get > FuelInit.FuelShortCircuitR) && (MinFuelData.Res_Pre_Get < FuelInit.FuelOpenCircuitR))
            {       
                if(GetFuelStep() <= 10)
                {
                    MinFuelData.Capacity_Val = 0;
                }
                else
                {
                    if(GetFuelStep() >= 90)
                    {
                        MinFuelData.Capacity_Val = 100; //remain
                    }
                    else
                    {
                        MinFuelData.Capacity_Val = GetFuelStep() - 10; //remain
                        MinFuelData.Capacity_Val *= 5;
                        MinFuelData.Capacity_Val /= 4;
                    }  
                }
            }
        }
        else if (MinFuelData.Sensor_State == FuelSensorOpenCircuit)
        {
            MinFuelMeter.Icon = g_LED.LedBlink_1HZ;
            MinFuelData.Step_Get_Valid = 0; 
        }
        else
        {
            MinFuelData.Step_Get_Valid = 0; 
            MinFuelMeter.Icon = 1; 
        }
    }
    else
    {
        MinFuelMeter.Icon = 0; 
        MinFuelData.Step_Get_Valid = 0; 
    }
}

void FuelSleep(void)
{
    uint8_t *p;
    p = GetFuelSaveData(&FuelSaveLen);
    if(FuelSaveLen < 1024)
    {
        memcpy(FuelSaveData, p, FuelSaveLen);
    }
    p = GetDrivingRangeSaveData(&DrivingRangeSaveLen);
    if(DrivingRangeSaveLen < 1024)
    {
        memcpy(DrivingRangeSaveData, p, DrivingRangeSaveLen);
    }
}

void FuelWake(void)
{
    SetFuelSaveData(FuelSaveData, FuelSaveLen);
    SetDrivingRangeSaveData(DrivingRangeSaveData, DrivingRangeSaveLen);    
}

void Data_Fuel_Display_Init(void)
{
    MinFuelMeter.Icon = 1;
    MinFuelMeter.FastModeCnt = 0u;
	MinFuelMeter.Mode = Fast_Mode;
	MinFuelMeter.DampT = 0u;
	MinFuelMeter.DampTCnt = 0u;
	MinFuelMeter.destPosition = 0u;
	MinFuelMeter.curPosition = 0u;
}

//100ms
void Data_Fuel_Display(void)
{
    uint16_t val = MinFuelData.Step_Get_Value;
    uint8_t valid = MinFuelData.Step_Get_Valid;

	if(MinFuelData.Step_Get_Valid)
	{
		//HYS_Physical_Quantity_Input(HYS_FUEL, val);
		MinFuelMeter.destPosition = MinFuelData.Step_Get_Value;//HYS_Get_Seg(HYS_FUEL);
	}
	else
	{
		MinFuelMeter.destPosition = 0;
	}
    MinFuelMeter.curPosition = MinFuelMeter.destPosition;
    /*if(MinFuelMeter.curPosition < MinFuelMeter.destPosition)
    {
        if(MinFuelMeter.DampTCnt >= MinFuelMeter.DampT)
        {
            if(MinFuelMeter.curPosition < 100)
            {
                MinFuelMeter.curPosition++;
                if(MinFuelMeter.curPosition >= 90)
				{
					MinFuelMeter.curPosition = 90;
				}
            }

			MinFuelMeter.DampTCnt = 0;
        }
        else
        {
            MinFuelMeter.DampTCnt++;
        }
    }
    else if(MinFuelMeter.curPosition > MinFuelMeter.destPosition)
    {
        if(MinFuelMeter.DampTCnt >= MinFuelMeter.DampT)
        {
            if(MinFuelMeter.curPosition)
            {
                MinFuelMeter.curPosition--;
            }

			MinFuelMeter.DampTCnt = 0;
        }
        else
        {
            MinFuelMeter.DampTCnt++;
        }
    }
    else
    {
        MinFuelMeter.DampTCnt = 0;
    }*/
}

uint8_t Get_Fuel_curPosition(void)
{
    if(MinFuelMeter.curPosition >= 90)
	{
		MinFuelMeter.curPosition = 90;
	}
    return MinFuelMeter.curPosition;
}

uint8_t Get_Fuel_Valid(void)
{
	return MinFuelData.Step_Get_Valid;
}

uint8_t GetFuelCapacity_Val(void)
{
    return MinFuelData.Capacity_Val;
}

uint8_t GET_AvgFuel_TripA_Valid(void)
{
   return g_aveFuel.ValidA;
}

uint8_t GET_AvgFuel_TripA_500_Valid(void)
{
   return g_aveFuel.ValidA_Dis;
}

uint32_t GET_AvgFuel_ConsOf100msUL_Value(void)
{	
	return g_aveFuel.RateSum;	
}

void AvgFuel_ConsOf100msUL_Set(uint16_t FuelCons)
{
	g_aveFuel.RateSum = FuelCons;	
}

uint8_t GET_Fuel_Sensor_Resistance_High(void)
{
   if (GetFuelResistance() > 5150)
   {
        MinFuelData.Fuel_Sensor_Resistance_High = 1;
   }
   else
   {
       MinFuelData.Fuel_Sensor_Resistance_High = 0;
   }


   return MinFuelData.Fuel_Sensor_Resistance_High;
}

uint8_t GET_Fuel_Sensor_Resistance_Low(void)
{
    if(GetFuelResistance() <= 30)
    {
        MinFuelData.Fuel_Sensor_Resistance_Low = 1;
    }
    else
    {
        MinFuelData.Fuel_Sensor_Resistance_Low = 0;
    }
   return MinFuelData.Fuel_Sensor_Resistance_Low;
}

#endif