
#include "CAN_1939.h"
#include "CAN_1939_user.h"

CAN_1939_uint16_t g_u1618ECFF03TimeoutCount = 0U;
CAN_1939_uint16_t g_u1618ECFF00TimeoutCount = 0U;

const CAN1939_Attribute_st_t stCAN1939Attribute [ CAN1939_SA_MAX ] = {
    {0x18ECFF03, 0x18EBFF03, 5000},
    {0x18ECFF00, 0x18EBFF00, 5000},
};
CAN_1939_uint8_t u8CAN1939RamData [ CAN1939_RAM_DATA_LEN ];
void             CAN_J1939_Init_Example(void)
{
    CAN1939_Init_st_t stCAN1939Init;
    stCAN1939Init.u8CAN1939SANUM      = CAN1939_SA_MAX;
    stCAN1939Init.u8CAN1939MessageLen = CAN1939_MESSAGE_LEN;
    CAN_J1939_Init(&u8CAN1939RamData [ 0 ], &stCAN1939Attribute [ 0 ], &stCAN1939Init);
}

CAN_1939_uint8_t CAN_1939_DTC_Check(CAN_1939_uint32_t u32DTC, DTC_1939 *pun1939DTC, CAN_1939_uint8_t u8DtcNum)
{
    CAN_1939_uint8_t u8CheckResult = 0U;
    CAN_1939_uint8_t i;
    CAN_1939_uint8_t u8DTCData [ 4 ];
    u8DTCData [ 0 ] = (( CAN_1939_uint8_t )(u32DTC >> 24U));
    u8DTCData [ 1 ] = (( CAN_1939_uint8_t )(u32DTC >> 16U));
    u8DTCData [ 2 ] = (( CAN_1939_uint8_t )(u32DTC >> 8U));
    // u8DTCData [ 3 ] = (( CAN_1939_uint8_t )(u32DTC));

    for ( i = 0; i < u8DtcNum; i++ )
    {
        if ( (pun1939DTC->data [ 0 ] == u8DTCData [ 0 ]) && (pun1939DTC->data [ 1 ] == u8DTCData [ 1 ]) && (pun1939DTC->data [ 2 ] == u8DTCData [ 2 ]) )
        {
            u8CheckResult = 1U;
            break;
        }
        pun1939DTC++;
    }

    return u8CheckResult;
}

CAN_1939_uint8_t  u8DTC0XCEF0E0xx = 0U;
CAN_1939_uint8_t  u8DTC0XB9F0E0xx = 0U;
CAN_1939_uint8_t  u8DTC0XC1F0E0xx = 0U;
CAN_1939_uint8_t  u8DTC0X66F1E0xx = 0U;
CAN_1939_uint8_t  u8DTC0XB8F0E0xx = 0U;
CAN_1939_uint8_t  u8DTC0XCCF0E0xx = 0U;
CAN_1939_uint8_t  u8DTC0XCD160Bxx = 0U;
CAN_1939_uint8_t  u8RecDataLamp03 [ 2 ];
CAN_1939_uint8_t  u8RecDataLamp00 [ 2 ];
CAN_1939_uint32_t u32RecSA03DTC;
void              CAN_1939_Process(void)
{
    if ( CAN_J1939_Get_Timeout_Flag(CAN1939_SA_03) )
    {
        if ( CAN_J1939_Get_Update_Flag(CAN1939_SA_03) == 2UL )
        {
            if(0xFECA == CAN_J1939_Get_Message_PGN(CAN1939_SA_03))
            {
                CAN_1939_uint8_t  u8DataLenBuf      = CAN_J1939_Get_Message_Len(CAN1939_SA_03);
                CAN_1939_uint8_t *pu8CAN1939DataBuf = CAN_J1939_Get_Message_Content(CAN1939_SA_03);
                if ( u8DataLenBuf > 8 )
                {
                    u8DataLenBuf = (u8DataLenBuf - 2) / 4;

                    u8RecDataLamp03 [ 0 ] = *pu8CAN1939DataBuf;
                    u8RecDataLamp03 [ 1 ] = *(pu8CAN1939DataBuf + 1);
                    pu8CAN1939DataBuf += 2;

                    u8DTC0XCEF0E0xx = CAN_1939_DTC_Check(0xCEF0E000, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                    u8DTC0XB9F0E0xx = CAN_1939_DTC_Check(0XB9F0E000, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                    u8DTC0XC1F0E0xx = CAN_1939_DTC_Check(0XC1F0E000, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                    u8DTC0X66F1E0xx = CAN_1939_DTC_Check(0X66F1E000, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                    u8DTC0XB8F0E0xx = CAN_1939_DTC_Check(0XB8F0E000, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                    u8DTC0XCCF0E0xx = CAN_1939_DTC_Check(0XCCF0E000, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                    u8DTC0XCD160Bxx = CAN_1939_DTC_Check(0XCD160B00, ( DTC_1939 * )(pu8CAN1939DataBuf), u8DataLenBuf);
                }
                else
                {
                    u8DataLenBuf = 0;
                }
                g_u1618ECFF03TimeoutCount = 0;
            }
            else
            {
                CAN_J1939_18ECFF03_Timeout();
            }

            CAN_J1939_Clear_Update_Flag(CAN1939_SA_03);
        }
    }
    else
    {
        u8RecDataLamp03 [ 0 ] = 0U;
        u8RecDataLamp03 [ 1 ] = 0U;
        u8DTC0XCEF0E0xx       = 0U;
        u8DTC0XB9F0E0xx       = 0U;
        u8DTC0XC1F0E0xx       = 0U;
        u8DTC0X66F1E0xx       = 0U;
        u8DTC0XB8F0E0xx       = 0U;
        u8DTC0XCCF0E0xx       = 0U;
        u8DTC0XCD160Bxx       = 0U;
    }

    if ( CAN_J1939_Get_Timeout_Flag(CAN1939_SA_00) )
    {
         if ( CAN_J1939_Get_Update_Flag(CAN1939_SA_00) == 2UL )
        {
            if(0xFECA == CAN_J1939_Get_Message_PGN(CAN1939_SA_00))
            {
                CAN_1939_uint8_t  u8DataLenBuf      = CAN_J1939_Get_Message_Len(CAN1939_SA_00);
                CAN_1939_uint8_t *pu8CAN1939DataBuf = CAN_J1939_Get_Message_Content(CAN1939_SA_00);
                if ( u8DataLenBuf > 8 )
                {
                    u8DataLenBuf = (u8DataLenBuf - 2) / 4;

                    u8RecDataLamp00 [ 0 ] = *pu8CAN1939DataBuf;
                    u8RecDataLamp00 [ 1 ] = *(pu8CAN1939DataBuf + 1);
                    pu8CAN1939DataBuf += 2;
                }
                else
                {
                    u8DataLenBuf = 0;
                }
                
                g_u1618ECFF00TimeoutCount = 0;
            }
            else
            {
                CAN_J1939_18ECFF00_Timeout();
            }
            CAN_J1939_Clear_Update_Flag(CAN1939_SA_00);
        }
    }
    else
    {
        u8RecDataLamp00 [ 0 ] = 0U;
        u8RecDataLamp00 [ 1 ] = 0U;
    }
}

void CAN_1939_0X18ECFF03_MSG_CKB_ON_RECEIVE(unsigned char CopyData [])
{
    CAN_1939_Receive_Data(CAN1939_SA_03, 0x18ECFF03, CopyData);
    CAN_J1939_Multipacket_Service(CAN1939_SA_03);
}
void CAN_1939_0X18EBFF03_MSG_CKB_ON_RECEIVE(unsigned char CopyData [])
{
    CAN_1939_Receive_Data(CAN1939_SA_03, 0x18EBFF03, CopyData);
    CAN_J1939_Multipacket_Service(CAN1939_SA_03);
}
void CAN_1939_0X18FECA03_MSG_CKB_ON_RECEIVE(unsigned char CopyData [])
{
    CAN_1939_uint32_t u32RecSADTCBuf = 0UL;

    u32RecSADTCBuf = (CopyData [ 2 ]);
    u32RecSADTCBuf <<= 8U;
    u32RecSADTCBuf |= (CopyData [ 3 ]);
    u32RecSADTCBuf <<= 8U;
    u32RecSADTCBuf |= (CopyData [ 4 ]);
    u32RecSADTCBuf <<= 8U;
    // u32RecSADTCBuf |= (CopyData [ 5 ]);

    u32RecSA03DTC = u32RecSADTCBuf;
    //  Can_18FECA03_Receive();
}

void CAN_1939_0X18FECA03_MSG_CKB_LOST(unsigned char CopyData [])
{
    u32RecSA03DTC = 0UL;
}

CAN_1939_uint8_t Get_CAN_CH0_ID_18EBFF03_Sig_AT_AmberWarnLamp(void)
{
    return ((u8RecDataLamp03 [ 0 ] >> 2) & 0X03U);
}
CAN_1939_uint8_t Get_CAN_CH0_ID_18EBFF03_Sig_AT_RedStopLamp(void)
{
    return ((u8RecDataLamp03 [ 0 ] >> 4) & 0X03U);
}

void CAN_1939_0X18ECFF00_MSG_CKB_ON_RECEIVE(unsigned char CopyData [])
{
    CAN_1939_Receive_Data(CAN1939_SA_00, 0x18ECFF00, CopyData);
    CAN_J1939_Multipacket_Service(CAN1939_SA_00);
}
void CAN_1939_0X18EBFF00_MSG_CKB_ON_RECEIVE(unsigned char CopyData [])
{
    CAN_1939_Receive_Data(CAN1939_SA_00, 0x18EBFF00, CopyData);
    CAN_J1939_Multipacket_Service(CAN1939_SA_00);
}

CAN_1939_uint8_t Get_CAN_CH0_ID_18EBFF00_Sig_RedStopLamp(void)
{
    return ((u8RecDataLamp00 [ 0 ] >> 4) & 0X03U);
}

CAN_1939_uint8_t Get_CAN_CH0_ID_18EBFF00_Sig_AmberWarnLamp(void)
{
    return ((u8RecDataLamp00 [ 0 ] >> 2) & 0X03U);
}

void CAN_J1939_FECA_Timeout_Count(CAN_1939_uint8_t taskTime)
{
    if (g_u1618ECFF03TimeoutCount <= (0xFFFF - taskTime))
    {
        g_u1618ECFF03TimeoutCount += taskTime;
    }
    
    if (g_u1618ECFF00TimeoutCount <= (0xFFFF - taskTime))
    {
        g_u1618ECFF00TimeoutCount += taskTime;
    }
}


/*返回值：0--报文超时，1--报文在线*/
CAN_1939_uint8_t CAN_J1939_18ECFF03_Timeout(void)
{
    CAN_1939_uint8_t u8Timeout = 1U;
    if (g_u1618ECFF03TimeoutCount >= 5000U)
    {
        u8Timeout = 0U;
        //添加掉线处理
        u8RecDataLamp03[0] = 0UL;
        u8RecDataLamp03[1] = 0UL;
        u8DTC0XCEF0E0xx = 0UL;
        u8DTC0XB9F0E0xx = 0UL;
        u8DTC0XC1F0E0xx = 0UL;
        u8DTC0X66F1E0xx = 0UL;
        u8DTC0XB8F0E0xx = 0UL;
        u8DTC0XCCF0E0xx = 0UL;
        u8DTC0XCD160Bxx = 0UL;
    }

    return u8Timeout;
}

CAN_1939_uint8_t CAN_J1939_18ECFF00_Timeout(void)
{
    CAN_1939_uint8_t u8Timeout = 1U;
    if (g_u1618ECFF00TimeoutCount >= 5000U)
    {
        u8Timeout = 0U;
        //添加掉线处理
        u8RecDataLamp00[0] = 0UL;
        u8RecDataLamp00[1] = 0UL;
    }

    return u8Timeout;
}
