/*
 * @Filename:
 * @Descripttionn:
 * @version:
 * @Author: TianYu
 * @Date: 2023-05-08 10:46:43
 * @LastEditTime: 2023-05-08 11:12:13
 */

#include "CAN_CFG.h"
//#include "NM_protocol.h"
#include "RSCAN.h"
#include "RTE_CAN.h"
#include "NMUserControl.h"
#include "PowerManag_User.h"

uint8_t GetBusOffState(void)
{
    uint8_t rscan_st = RSCAN0_CH0_Get_Busoff_Status( );
    return rscan_st;
}

void AbortAllCanTx(void)
{

    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_0);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_1);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_2);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_3);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_4);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_5);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_6);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_7);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_8);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_9);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_10);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_11);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_12);
    RSCAN0_CH0_Abort(RSCAN_CHANNEL_BUF_13);
}

void CanBusoffRecover(void)
{

    RSCAN0_CH0_Busoff_Recover( );
}
uint8_t CAN_NM_TX_STATUS;
uint8_t CAN_APP_TX_STATUS;
uint8_t CAN_NM_REC_STATUS;
void    NM_CanInit(void)
{
    // MSCAN_30_Init();
    CAN_NM_TX_STATUS  = 0u;
    CAN_APP_TX_STATUS = 0u;
    CAN_NM_REC_STATUS = 0U;
    Can_Init( );
}

void CAN_SET_APP_SEND(uint8_t status)
{
    CAN_APP_TX_STATUS = status;
}
void CAN_SET_NM_SEND(uint8_t status)
{
    CAN_NM_TX_STATUS = status;
}
void CAN_SET_NM_REC(uint8_t status)
{
    CAN_NM_REC_STATUS = status;
}

uint8_t CAN_GET_NM_REC(void)
{
    return CAN_NM_REC_STATUS;
}
uint8_t CAN_GET_APP_SEND(void)
{
    return CAN_APP_TX_STATUS;
}
uint8_t CAN_GET_NM_SEND(void)
{
    return CAN_NM_TX_STATUS;
}
void CanRequestSleep(void)
{
    u32OsekAPPFlag = 0UL;
    // 不要打开
    //	RSCAN0_Sleep_Init();
}

void SetCanSTBLevel(uint8_t n)
{
    // 不要打开
    //  if ( n == NM_LOW )
    //  {
    //      ;
    //  }
    //  else if ( n == NM_HIGH )
    //  {
    //      ;
    //  }
}

void CanTxMsg(uint8_t SendCh, uint8_t *data, uint8_t len, uint32_t id)
{
    uint32_t       i;
    CAN_Frame_st_t m_msg;

    if ( SYS_OPR_STAT_HALT )
    {
        return;
    }
    NmSetLastId(id);

    m_msg.u32CANID      = id;
    m_msg.u8CANLEN      = len;
    m_msg.u8CANFrameIDE = 1;
    for ( i = 0; i < m_msg.u8CANLEN; i++ )
    {
        m_msg.unCANData.u8CANData [ i ] = data [ i ];
    }

    switch ( id )
    {
        case 0x18FFA017:
            if ( CAN_NM_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_2, &m_msg);
            }
            break;
        case 0x10FF4117:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_3, &m_msg);
            }
            break;
        case 0x0A18A000:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_4, &m_msg);
            }
            break;

        case 0x0810A000:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_5, &m_msg);
            }
            break;
        case 0x18FFC321:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_6, &m_msg);
            }
            break;
        case 0x18FEFC17:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_7, &m_msg);
            }
            break;
        case 0x18D00017:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_8, &m_msg);
            }
            break;

        case 0x0CFE6CEE:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_9, &m_msg);
            }
            break;
        case 0x18FF6121:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_10, &m_msg);
            }
            break;
        case 0x18FEC1EE:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_11, &m_msg);
            }
            break;

        case 0x18FEE6EE:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_12, &m_msg);
            }
            break;
        case 0x18A97121:
            if ( CAN_APP_TX_STATUS == 0u )
            {
                RSCAN0_CH0_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_13, &m_msg);
            }
            break;

        default:
            break;
    }
}
