/*
 * MOTOR.h
 *
 *  Created on: Apr 21, 2019
 *      Author: qitiancun
 */

#ifndef MOTORDRIVER_H_
#define MOTORDRIVER_H_

typedef struct
{
	unsigned short curPosition;
	unsigned short destPosition;
} MeterPostion_t;

typedef enum
{
	direction_1 = 0,
	direction_2,
} MoveDirection_t;

typedef enum
{
	Motor_0 = 0,
	Motor_1,
	Motor_2,
	Motor_3,
	Motor_4,
	Motor_5,
	
} MotorIndex_t;

typedef enum
{
	Normal = 0,
	MinReset,
	MaxReset,
	MaxStep,
	MaxStepKeep,
	MinStep
} workMode_t;
typedef enum
{
	Motor_BKA = 0,
	Motor_TYW,
} motorType_t;

extern volatile MeterPostion_t MeterPostion[6]; /* 6 个电机位置数组 */

extern unsigned char *bsp_MotorGetVersion(void); /* 获取版本号 */

extern void bsp_MotorMove_50us_main(void); /* 必须在 VectorNumber_Vmctimovf 中断中调用，初始化电机默认使能中断 */

extern unsigned char bsp_set_meterCfg(motorType_t motorType, unsigned char meterIndex,unsigned char motorIndex, MoveDirection_t motorDir, unsigned short MaxAngle, unsigned short One_Step_Damp, unsigned char (*ZeroPosition)(void));

extern void bsp_SetMotorMode(unsigned char index, workMode_t Mode); /* 设置电机工作模式 */

extern workMode_t bsp_GetMotorState(unsigned char index); /* 获取电机工作模式 */

extern void bsp_SetOneStepDamp(unsigned char motorIndex, unsigned int One_Step_Damp); /* 设置每一步阻尼时间 */

extern void bsp_MotorDriverOff(void);

extern void bsp_SetMaxSpeed(unsigned char motorIndex, unsigned int speed); /* speed 越小越快,默认是1 */

#endif /* MOTORDRIVER_H_ */
