/*
****************************************************************************
Project : d1l1_display_connectivity
FILE    : $Id: hmi.c 5069 2015-05-04 15:40:54Z golczewskim $
============================================================================
DESCRIPTION

D1L1 display connectivity demo
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2016
                                  by
                    Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2016 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/

/***********************************************************
  Title: Main Module

  Implementation of the top level for the D1L1 Graphic application demo.
  This includes initialisation and task processing.

*/

/***********************************************************
  Section: Includes
*/

#include <stdio.h>
#include <stdlib.h>

#include "r_typedefs.h"
#include "init.h"
#include "..\Appliciation\Task_Scheduler.h"
#include "..\Appliciation\Task.h"
#include "..\Driver\Sys_Tick\Sys_Tick.h"
#include "..\Driver\WDT\Watchdog.h"

/***********************************************************
  Section: Local Defines
*/

/***********************************************************
  Section: Global functions
*/

/***********************************************************
  Section: Local variables
*/

/***********************************************************
  Section: Local functions
*/
static void Sys_Task_Init(void);

/***********************************************************
  Function: main (Demo)
*/
void main(void)
{
    /* init BSP */

    /* application init */
    Sys_Task_Init( );
    Sys_Startup_Init( );
    while ( 1 )
    {
        Sys_Scheduling_Service( );
        WDT_Clear( );
    }
}

static void Sys_Task_Init(void)
{
    st_Sys_TaskGroup TaskGroup;

    TaskGroup.Exact_Task50us       = Sys_Exact_50us_Tasks;
    TaskGroup.Exact_Task100ms      = Sys_Exact_100ms_Tasks;
    TaskGroup.Pseudo_Real_TimeTask = Sys_Run_Mode_Pseudo_Real_Time_Tasks;
    TaskGroup.Task2ms              = Sys_Run_Mode_2ms_Tasks_Group;
    TaskGroup.Task5ms              = Sys_Run_Mode_5ms_Tasks_Group;
    TaskGroup.Task10ms             = Sys_Run_Mode_10ms_Tasks_Group;
    TaskGroup.Task20ms             = Sys_Run_Mode_20ms_Tasks_Group0;
    TaskGroup.Task50ms             = Sys_Run_Mode_50ms_Tasks_Group;
    TaskGroup.Task100ms            = Sys_Run_Mode_100ms_Tasks_Group;
    Sys_Init(&TaskGroup);

}
