/*
****************************************************************************
PROJECT : DMA driver
FILE    : $Id: r_dma_main.c 2218 2014-03-27 16:29:52Z michael.golczewski $
============================================================================
DESCRIPTION
Driver for DMA macro
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2012
                                  by
                       Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2011 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/

#include "r_typedefs.h"
#include "r_cdi_api.h"
#include "r_dma_api.h"
#include "r_dma_sys.h"
#include "r_config_dma.h"
#define DMA_MAIN_GLOBALS_
#include "r_dma_main.h"

/*******************************************************************************
  Section: Global API Functions
*/

/*******************************************************************************
  Function: R_DMA_Init

  see: <r_dma_api.h> for details
*/
void R_DMA_Init(uint32_t Unit)
{
    R_DMA_SYS_HardwareInit(Unit);
}

/*******************************************************************************
  Function: R_DMA_LoadChannel

  see: <r_dma_api.h> for details
*/
void R_DMA_LoadChannel(r_dma_ChCfg_t *ChCfg, uint32_t NoOfCh)
{
    R_DMA_SYS_LoadChannel(ChCfg, NoOfCh);
}

/*******************************************************************************
  Function: R_DMA_SwTrigger

  see: <r_dma_api.h> for details
*/
void R_DMA_SwTrigger(uint32_t Unit, uint32_t ChId)
{
    R_DMA_SYS_SwTrigger(Unit, ChId);
}

/*******************************************************************************
  Function: R_DMA_TransEndStat

  see: <r_dma_api.h> for details
*/
r_dma_TransEndStatType_t R_DMA_TransEndStat(uint32_t Unit, uint32_t ChId)
{
    return (R_DMA_SYS_TransEndStat(Unit, ChId));
}

/*******************************************************************************
  Function: R_DMA_TransErrStat

  see: <r_dma_api.h> for details
*/
r_dma_TransErrStatType_t R_DMA_TransErrStat(uint32_t Unit, uint32_t ChId)
{
    return (R_DMA_SYS_TransErrStat(Unit, ChId));
}
