/******************************************************************************
文 件 名：UDS_ISO14229_Server.h
功能描述：ISO 14229 规范规定的诊断服务服务器端函数头文件
作    者：张暄
版    本：V1.0
日    期：2016.11.1
******************************************************************************/

/******************************************************************************
                         诊断服务的OSI模型映射
===============================================================================
  *     NO.     OSI Layer        Diagnostics services
-------------------------------------------------------------------------------
  *      7      Application      ISO 14229-1 ISO 14229-3
         6      Presentation     -
  *      5      Session          ISO 14229-2
         4      Transport        ISO 15765-2
         3      Network          ISO 15765-2
         2      Data Link        ISO 11898
         1      Physical         ISO 11898
===============================================================================
******************************************************************************/
#ifndef _UDS_ISO14229_SERVER_H_
#define _UDS_ISO14229_SERVER_H_

#include "DoCAN_ISO15765.h"
#include "UDS_ISO14229_Server_Config.h"
#include "UDS_Common.h"
#include "UDS_10Service_Main.h"
#include "UDS_11Service_Main.h"
#include "UDS_14Service_Main.h"
#include "UDS_19Service_Main.h"
#include "UDS_22Service_Main.h"
#include "UDS_27Service_Main.h"
#include "UDS_28Service_Main.h"
#include "UDS_2EService_Main.h"
#include "UDS_2FService_Main.h"
#include "UDS_31Service_Main.h"
#include "UDS_3EService_Main.h"
#include "UDS_85Service_Main.h"

/******************************************************************************
结构体声明
******************************************************************************/

/*** 会话层数据发送结果枚举 ***/
typedef enum
{
    S_OK = 0,
    S_NOK,
} S_Result_Enum;

/*---------------------------------------------------------------------------*/

/*** A_PCI解析结构(非负反馈) ***/
typedef struct
{
    uint8_t SI;
} UDS_A_PCI_Struct;

/*** A_PCI解析结构(负反馈) ***/
typedef struct
{
    uint8_t NR_SI;
    uint8_t SI;
} UDS_NEG_A_PCI_Struct;

/*** 应用层接收数据解析结构 ***/
typedef struct
{
    uint32_t                TA_type;
    uint8_t                 A_Data[A_DATA_RX_BUFFER_SIZE];
    uint16_t                Length;   /*有效数据长度(不含A_PCI)*/
    uint8_t                 New;      /*新收到的数据*/
} UDS_RX_App_Data_Struct;

/*** 应用层接收A_PDU解析结构 ***/
typedef struct
{
    uint32_t                TA_type;
    UDS_A_PCI_Struct        A_PCI;
    uint8_t                 Data[A_DATA_RX_BUFFER_SIZE - (uint8_t)1];
    uint16_t                Length;   /*有效数据长度(不含A_PCI)*/
    uint8_t                 New;      /*新收到的数据*/
} UDS_RX_A_PDU_Struct;

/*** 应用层发送数据解析结构 ***/
typedef struct
{
    uint32_t                TA_type;
    uint8_t                 A_Data[A_DATA_TX_BUFFER_SIZE];
    uint16_t                Length;   /*有效数据长度(不含A_PCI)*/
} UDS_TX_App_Data_Struct;

/*** 应用层发送正反馈A_PDU解析结构 ***/
typedef struct
{
    uint32_t                TA_type;
    UDS_A_PCI_Struct        A_PCI;
    uint8_t                 Data[A_DATA_TX_BUFFER_SIZE - (uint8_t)1];
    uint16_t                Length;   /*有效数据长度(不含A_PCI)*/
} UDS_TX_A_PDU_Struct;

/*** 应用层发送负反馈A_PDU解析结构 ***/
typedef struct
{
    uint32_t                TA_type;
    UDS_NEG_A_PCI_Struct    A_PCI;
    uint8_t                 Data[A_DATA_TX_BUFFER_SIZE - (uint8_t)2];
    uint16_t                Length;   /*有效数据长度(不含A_PCI)*/
} UDS_TX_NEG_A_PDU_Struct;

/*** 应用层接收数据解析联合体 ***/
typedef union
{
    UDS_RX_App_Data_Struct  Data;
    UDS_RX_A_PDU_Struct     A_PDU;
} UDS_APP_RX_Union;

/*** 应用层发送正反馈数据解析联合体 ***/
typedef union
{
    UDS_TX_App_Data_Struct  Data;
    UDS_TX_A_PDU_Struct     A_PDU;
} UDS_APP_TX_Union;

/*** 应用层发送负反馈数据解析联合体 ***/
typedef union
{
    UDS_TX_App_Data_Struct  Data;
    UDS_TX_NEG_A_PDU_Struct A_PDU;
} UDS_APP_TX_NEG_Union;

/******************************************************************************
函数声明
******************************************************************************/

/*-- 外部接口函数 -----------------------------------------------------------*/

/*** 后台服务函数 ***/
void UDS_Server_Application_Service ( void );

/*** 传输层/网络层下层接口函数 ***/
void UDS_N_USData_Request ( uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length );
extern void UDS_N_USData_Confirm (uint32_t N_TAtype, N_ResultEnum N_Result);
extern void UDS_N_USData_FF_Indication(uint32_t N_TAtype, uint16_t Length);
extern void UDS_N_USData_Indication(uint32_t N_TAtype, uint8_t *MessageData, uint16_t Length, N_ResultEnum N_Result);

/*-- 内部函数 ---------------------------------------------------------------*/

/*** 会话层数据接口函数 ***/
void UDS_S_Data_Request ( uint32_t S_TAtype, uint8_t *S_Data, uint16_t S_Length );
void UDS_S_Data_Confirm ( uint32_t S_TAtype, S_Result_Enum S_Result );
void UDS_S_Data_Indication ( uint32_t S_TAtype, uint8_t S_Data[], uint16_t S_Length, S_Result_Enum S_Result );

/*** 会话层时序控制函数 ***/

/*** 应用层服务控制函数 ***/
void UDS_Process_Service_Request ( void );
void UDS_Service_Response ( uint8_t si, uint8_t RspType, uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[] );

#endif