#ifndef MILEAGE_H__
#define MILEAGE_H__
 //#define MILEAGE_PLATFORM_16BIT
#ifdef MILEAGE_PLATFORM_16BIT
typedef unsigned char Mile_uint8_t;
typedef unsigned int Mile_uint16_t;
typedef unsigned long Mile_uint32_t;
typedef signed char Mile_int8_t;
typedef signed int Mile_int16_t;
typedef signed long Mile_int32_t;
#else
typedef unsigned char Mile_uint8_t;
typedef unsigned short Mile_uint16_t;
typedef unsigned int Mile_uint32_t;
typedef unsigned long long Mile_uint64_t;
typedef signed char Mile_int8_t;
typedef signed short Mile_int16_t;
typedef signed int Mile_int32_t;
typedef signed long long Mile_int64_t;
#endif
typedef enum
{
	MILE_INDEX_ODO = 0U, 
	MILE_INDEX_TRAP_A,
	MILE_INDEX_TRAP_B,
	MILE_INDEX_MAX,
} Mile_Index_en_t;
typedef enum
{
	MILE_SNAP_0 = 0U,
	MILE_SNAP_1,
	MILE_SNAP_2,
	MILE_SNAP_3,
	MILE_SNAP_4,
	MILE_SNAP_5,
	MILE_SNAP_6,
	MILE_SNAP_7,
	MILE_SNAP_8,
	MILE_SNAP_9,
	MILE_SNAP_10,
	MILE_SNAP_11,
	MILE_SNAP_12,
	MILE_SNAP_13,
	MILE_SNAP_14,
	MILE_SNAP_15,
	MILE_SNAP_16,
	MILE_SNAP_17,
	MILE_SNAP_18,
	MILE_SNAP_19,
	MILE_SNAP_MAX,
} Mile_Snapshot_en_t;
#define MILE_RAM_FIX_LEN 32U
#define MILE_RAM_DATA_LEN ((MILE_INDEX_MAX * 8U) + (MILE_RAM_FIX_LEN))
typedef enum
{
	MILE_SOURCE_VEHICLE = 0U,
	MILE_SOURCE_DIFF,
	MILE_SOURCE_MAX, 
} Mile_Source_en_t;
typedef void (*Mile_Parameter_Save_Snapshot)(Mile_Snapshot_en_t enMileSnapshot, Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen);
typedef void (*Mile_Parameter_Save_Index)(Mile_Index_en_t enMileIndex, Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen);
typedef void (*Mile_Parameter_Save_Source)(Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen);
typedef void (*Mile_Gain)(Mile_uint8_t u8MileData);
typedef struct
{
	Mile_Source_en_t enMileSource;
	Mile_Index_en_t enMileIndexNUM;
	Mile_Snapshot_en_t enMileSnapshotNUM;
	Mile_Parameter_Save_Source pfnMileSaveSourceCallBack;
	Mile_Parameter_Save_Index pfnMileSaveIndexCallBack;
	Mile_Parameter_Save_Snapshot pfnMileSaveSnapshotCallBack;
	Mile_Gain pfnMileGainCallBack;
	Mile_uint16_t u16MileVehicMAX;
	Mile_uint8_t u8MileSaveFre;
} Mile_Init_st_t;
typedef struct
{
	Mile_uint32_t u32MileMaxValue;
	Mile_uint8_t u8MileMAXReset;
	Mile_uint8_t u8MileSaveEn;
} Mile_Attribute_st_t;
void Mile_Parameter_Read_Index(Mile_Index_en_t enMileIndex, Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen);
void Mile_Parameter_Read_Snapshot(Mile_Snapshot_en_t enMileSnapshot, Mile_uint8_t *pu8MileData, Mile_uint8_t u8MileDataLen);
void Mileage_Wakeup_Init(Mile_uint8_t *pu8MileRamData, const Mile_Init_st_t *pstMileInit, const Mile_Attribute_st_t *pstMileAttribute);
void Mileage_KL30_Init(Mile_uint8_t *pu8MileRamData, const Mile_Init_st_t *pstMileInit, const Mile_Attribute_st_t *pstMileAttribute, Mile_uint8_t *pu8MileSourceData, Mile_uint8_t u8MileDataLen);
void Mile_Source_Set(Mile_Source_en_t enMileSource);
void Mileage_IG_ON_Init(void);
void Mileage_IG_OFF_Init(void);
void Mileage_Rolling_Counter_Update_ISR(Mile_uint16_t u16RealSpeed);
void Mileage_Factory_Reset(void);
unsigned int Mileage_Modify_Index_Value(Mile_Index_en_t enMileIndex, Mile_uint32_t u32TargetValue);
void Mileage_Source_Service(void);
unsigned int Mile_Source_Diff_Accumulate(Mile_uint32_t u32DiffValue);
Mile_uint32_t Mile_Get_Index_Value(Mile_Index_en_t enMileIndex);
#endif
