#ifndef TYWTYPES_H
#define TYWTYPES_H

#include "TYW_Config.h"
#include "r_typedefs.h"
/*

   变量长度(byte)      XHY      324     3360      rh850   SAMC21
   unsigned int        2       4       4         4       4
   unsigned short      2       2       2         2       2
   unsigned char       1       1       1         1       1
   unsigned long       4       4       4         4       4
   unsigned long long  4       8       8         8       8
   float               4       4       4         4       4
   double              4       8       8         8       8
*/


typedef char INT8;
typedef short INT16;
typedef unsigned char INT8U;
typedef volatile unsigned char VINT8U;
typedef unsigned int INT16U;
typedef volatile unsigned int VINT16U;
typedef unsigned long INT32U;
typedef volatile unsigned long VINT32U;

#if ( ! defined(__cplusplus) )

    #ifndef false
        #define false (0U)
    #endif

    #ifndef true
        #define true (1U)
    #endif

    #ifndef TRUE
        #define TRUE (1U)
    #endif

    #ifndef FALSE
        #define FALSE (0U)
    #endif

#endif

#define NULL ((void *)0)
#define NOP( ) __asm("NOP")

#if defined(Platform_XHY)

    #ifndef uint8_t
typedef unsigned char uint8_t;
typedef unsigned int  uint16_t;
/*typedef unsigned short      uint16_t;*/
typedef unsigned long uint32_t;
/*typedef unsigned long long  uint32_t;*/

typedef char int8_t;
typedef int  int16_t;
/*typedef short               int16_t;*/
typedef long int32_t;
/*typedef long long           int32_t;*/

typedef float         float32_T;
typedef double        double32_T;
typedef unsigned char boolean_t;
    #endif /* uint8_t */

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_S6J3360)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

typedef float         float32_T;
typedef double        double64;
typedef unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_S6J324)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

typedef float         float32_T;
typedef double        double64;
typedef unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_RH850)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

typedef float         float32_T;
typedef double        double64;
typedef unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_SAMC21)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

typedef float         float32_T;
typedef double        double64;
typedef unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_S32K)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

typedef float         float32_T;
typedef double        double64;
typedef unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_KEA64)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

typedef float         float32_T;
typedef double        double64;
typedef unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

    // #else

    // #error NO_Platform_Found

#endif /* Logical type definitions */

typedef enum
{
    /* Generic error codes */
    STATUS_SUCCESS     = 0x000U, /*!< Generic operation success status */
    STATUS_ERROR       = 0x001U, /*!< Generic operation failure status */
    STATUS_BUSY        = 0x002U, /*!< Generic operation busy status */
    STATUS_TIMEOUT     = 0x003U, /*!< Generic operation timeout status */
    STATUS_UNSUPPORTED = 0x004U, /*!< Generic operation unsupported status */
    STATUS_NEGATIVE    = 0x005U, /* 负数                 */
    STATUS_NONNEGATIVE = 0x006U, /* 非负数               */

    /* CAN specific error codes */
    STATUS_CAN_BUFF_OUT_OF_RANGE       = 0x300U, /*!< The specified MB index is out of the configurable range */
    STATUS_CAN_NO_TRANSFER_IN_PROGRESS = 0x301U, /*!< There is no transmission or reception in progress */

    SBC_COMM_ERROR = 0x802U, /*!< Data transfer was aborted */
    SBC_CMD_ERROR  = 0x804U, /*!< Wrong command. */
    SBC_ERR_NA     = 0x808U, /*!< Feature/device not available */

} status_t;

#define Telltales_SelfCheckOffset (uint32_t)(2ul)
#define StartAnimationStart       (uint32_t)(2ul)
#define StartAnimationEnd         (uint32_t)(3000ul)
#define PopupStart                (uint32_t)(4000ul)
#define BackLightStart            (uint32_t)(2ul)

typedef enum
{
    LINE_IN_LEVEL_LOW = 0U,
    LINE_IN_LEVEL_HIGH,
} LINE_IN_TriggerLevel_en_t; /*物理电平数值*/

/*逻辑电平，硬线是否有效，是否触发*/
//typedef enum
//{
//    LINE_IN_LOGIC_INVALID = 0U, /*逻辑低电平，硬线信号无效，未触发*/
//    LINE_IN_LOGIC_VALID,        /*逻辑高电平，硬线信号有效，已触发*/
//} LineIn_LogicLevel_en_t;

/*硬线相关电源状态*/
//typedef enum
//{
//    LINE_IN_IG_OFF = 0U,
//    LINE_IN_IG_ON,
//    LINE_IN_IG_ONOFF,
//} LINE_IN_WorkSt_en_t;

//typedef enum
//{
//    LEVEL_LOW = 0u,
//    LEVEL_HIGH,
//} _LINE_IN_TriggerLevel_;

/*LineIn Module END*/

/*CAN TX Module*/

typedef enum
{
    CAN_MSG_TX_CYCLE = 0u,
    CAN_MSG_TX_CYCKE_EVENT,
} CAN_TX_Type_t;

typedef enum
{
    MSG_STD = 0u,
    MSG_EXT,
} CAN_MSG_FORMAT_t;

typedef enum
{
    CAN_APP_TX_DISABLE = 0u,
    CAN_APP_TX_ENABLE  = 0X55u,
} CAN_APP_TX_Status_t;

/*CAN TX Module END*/

/*CAN RX Module*/
typedef enum
{
    CAN_BUFF_EMPTY,
    CAN_BUFF_FULL,
} CAN_BUFF_Status_t;

typedef enum
{
    CAN_MSG_UNLOCK,
    CAN_MSG_LOCKING,
} CAN_MSG_Mutex_t;

typedef enum
{
    CAN_SIG_NORMAL = 0u,
    CAN_SIG_LOST   = 0x55U,
} CAN_MSG_Status_t;
/*CAN RX Module END*/

/*COMMON INTERFACE*/

typedef enum
{
    COMMON_POWER_OFF    = 0x00u,
    COMMON_POWER_ON     = 0x01u,
    COMMON_POWER_UNKNOW = 0xFFu,
} COMMON_PowerStatus_t;

typedef enum
{
    COMMON_InValid      = 0X00U,
    COMMON_Valid        = 0X01U,
    COMMON_Valid_UNKNOW = 0XFFU,
} DataValid_t;

/*COMMON INTERFACE END*/

typedef enum
{
    GUI_DISP_MODE_NORMAL = 0, /*正常*/
    GUI_DISP_MODE_BLANK,      /*空白*/
    GUI_DISP_MODE_INVALID,    /*无效*/
    GUI_DISP_MODE_FLASH,      /*闪烁*/

} Dis_Sta_t;
typedef enum {
    /*标题*/
    Title_Charging_connect = 0, /* 充电连接中*/
    Title_Charging,/*充电中*/
    Title_Charging_Stop,/*充电暂停*/
    Title_Charging_end,/*充电结束*/
    Title_Charging_set_OK,/*预约充电等待中......*/

    /*子标题*/
    Charge_Sub_title_08,/*计划用车时间*/
    Charge_Sub_title_07,/*安全电量*/
    Charge_Sub_title_01,/*充电功率*/
    Charge_Sub_title_02,/*预计充满时间*/
    Charge_Sub_title_04,/*正在计算中*/

    Charge_Sub_title_03,/*预计充电开始时间*/
    /*温馨提示*/
    Charge_Hint_01, /*本车有预约充电功能，可在多媒体上设置*/
    Charge_Hint_02, /*当前车辆电量过低，为保护车辆，已开始充电，如需取消充电，请断开充电枪*/
    Charge_Hint_03, /*充电插座接地不良，请使用接地良好的插座*/
    Charge_Hint_04, /*为保证充电效率，请关闭大功率用电设备*/
    Charge_Hint_05, /*因充电环境严酷，限功率充电中*/
    Charge_Hint_06, /*交流枪电子锁未闭锁，限功率充电中*/
    Charge_Hint_07, /*动力电池温度低电量高，充电效率低*/
    Charge_Hint_08, /*动力电池智能温控系统工作中*/
    Charge_Hint_09, /*最近的预约充电计划超过24H，今日不生效*/
    Charge_Hint_10, /*预约成功，保底充电中*/
    Charge_Hint_11, /*电池加热中*/
    Charge_Hint_12, /*为保证动力电池智能温控效果，空调功能受限*/
    Charge_Hint_13, /*温馨提示：充电已暂停，继续充电请稍后*/
    Charge_Hint_14, /*温馨提示：本车已开启预约充电可在多媒体上修改*/
}ChargeStringIndex;
typedef enum
{
    NM_Mode_Sleep,
    NM_Mode_Wakeup,
} NM_Mode_t;
/*语言,缩写参考ISO 639-1*/
#define NVM_LANGUAGE_ZH 0x01 /*中文*/
#define NVM_LANGUAGE_EN 0x03 /*英语*/
/*时间格式*/
#define NVM_TIME_FORMAT_24H 0x01u /*24小时制*/
#define NVM_TIME_FORMAT_12H 0x00u /*12小时制*/
/*距离单位*/
#define NVM_DIST_UNIT_KM   0x00u
#define NVM_DIST_UNIT_MILE 0x01u
typedef struct{
    char * pString;
    uint16_t X;
    uint16_t Y;
    uint8_t Length;
}ImageString;

typedef struct
{
    ImageString CnFont[3];
    ImageString EnFont[3];
} ImageAttribute;



#define Clr_Bit(p, b)    (p) &= (~(1u << (b)))
#define Set_Bit(p, b)    (p) |= (1u << (b))
#define Bit_Is_Set(p, b) ((p) & (1u << (b)))
#define Bit_Is_Clr(p, b) (! ((p) & (1u << (b))))


#endif
