#include "UDS_3EService_Main.h"

/**
  *3E服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_3E_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC11();                                            /*3E服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC7F();                                            /*3E服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC33();                                            /*3E服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC13_MinLengthCheck();                             /*3E服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC31();                                            /*3E服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC13_TotalLengthCheck();                           /*3E服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_NRC22();                                            /*3E服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_3EService_Sub();                                                    /*3E服务子功能*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *10服务子功能
  */
void UDS_3EService_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC13_MinLengthCheck();                         /*3E服务子功能最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC12();                                        /*3E服务子功能是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC7E();                                        /*3E服务子功能会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC31();                                        /*3E服务子功能超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC13_TotalLengthCheck();                       /*3E服务子功能总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC24();                                        /*3E服务子功能请求顺序验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_3EService_Sub_NRC22();                                        /*3E服务子功能条件验证*/
    }
    if(NRC == positiveResponse)
    {
        switch(DiagMSG.msgData.SidDetail.SubID)                                 /*子服务判断*/
        {
        case ZeroSubFunction:
            UDS_3EService_Sub00();                              
            break;
        default:
            break;
        }
    }
}

/**
  *3E服务00子功能
  */
void UDS_3EService_Sub00(void)
{
    S3_ServiceClear();
    if(DiagMSG.msgData.SidDetail.PositiveSuppression == 0u)
    {
        UDS_Service_Response(0x3Eu, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
    }
}
