#ifndef DataProcess_H
#define DataProcess_H

#define VCU_COUNT_MAX 10
#define Voltage_Max   25
#define Veh_Timeover  10

/******************************************************************************
车速
******************************************************************************/
/*** 全局变量 ***/
extern uint16_t DataVSpeedActual;
extern uint16_t DataVSpeedDisp;
//extern uint16_t  DataVSpeedHysteresis;
extern uint8_t  DataVSpeedValid;
extern uint8_t DataOverSpeed;
extern uint32_t VSpeedCal;

extern uint32_t PowerIgnOffTimeLine;

#define  DATA_VEHICLE_SPEED_ACTUAL          DataVSpeedActual
#define  DATA_VEHICLE_SPEED_DISPLAYING      DataVSpeedDisp
#define  DATA_VEHICLE_SPEED_VALID           DataVSpeedValid
//#define  DATA_OVER_SPEED_WARNING            DataOverSpeed

/*** 参数设置 ***/
#define   DATA_VSPEED_DAMPING_FACTOR        4   //阻尼系数
#define   DATA_VSPEED_INC_STEP              3   //速度增加时慢加速速度变化步长
#define   DATA_VSPEED_DEC_STEP              8   //方向改变时急减速速度变化步长
#define   DATA_VSPEED_APPR_SPEED_MIN        2   //最小逼近速度
#define   DATA_VSPEED_HYSTERESIS            10  //回差 
/******************************************************************************
数据逼近方向
******************************************************************************/
#define   DATA_APPR_DIR_INC                 0x00
#define   DATA_APPR_DIR_DEC                 0x01


/*** 控制结构 ***/
typedef struct
{
  uint16_t  Timer;
  uint16_t  Backup;
  uint16_t  Buffer[3];
  uint8_t   Cnt;
  uint8_t   UseBackup;
}DataVSpeedSamplerStruct;             //车速采样结构

typedef struct
{
  uint16_t  Speed;
  uint16_t  Delta;
  uint8_t   Dir;
}DataVSPeedDampingStruct;             //车速阻尼结构

//车速
extern  DataVSpeedSamplerStruct DataVSpeedSampler;
extern  DataVSPeedDampingStruct DataVSPeedDamping;


/******************************************************************************
发动机转速
******************************************************************************/
/*** 控制结构 ***/
typedef struct
{
    uint16_t  Backup;
    uint16_t  Timer;
    uint16_t Buffer [ 5 ];
    uint8_t  Cnt;
} DataESpeedSamplerStruct;

typedef struct
{
    uint16_t  u16Can_Actual;
    uint8_t   u8Can_Valid;
    uint16_t  u16Res_Actual;
    uint8_t   u8Res_Valid;
    uint16_t  u16FreIn_Actual;
    uint8_t   u8FreIn_Valid;
    
}DataESpeedStruct;

typedef struct
{
    uint32_t  Buffer[5];
    uint8_t   Cnt;
}DataFreESpeedSamplerStruct;

typedef struct
{
    uint16_t Speed;
    uint16_t Delta;
    uint8_t  Dir;
} DataESPeedDampingStruct;


extern DataESpeedSamplerStruct DataESpeedSampler;
extern uint16_t  DataESpeedActual;
extern uint16_t  DataESpeedDisp; 
extern uint8_t   DataESpeedValid ;


#define  DATA_ENGINE_SPEED_ACTUAL           DataESpeedActual
#define  DATA_ENGINE_SPEED_DISPLAYING       DataESpeedDisp
#define  DATA_ENGINE_SPEED_VALID            DataESpeedValid

#define DATA_ENGINE_RUNNING_THRESHOLD 400 
#define DATA_ENGINE_STOP_THRESHOLD    300 

#define DATA_ESPEED_DAMPING_FACTOR 4  
#define DATA_ESPEED_INC_STEP       3  
#define DATA_ESPEED_DEC_STEP       8  
#define DATA_ESPEED_APPR_SPEED_MIN 2  
#define DATA_ESPEED_HYSTERESIS     50 

/******************************************************************************
水温
******************************************************************************/


typedef enum
{
    Positive,
    Negative,
}_Symbol;

typedef enum
{
    Fast_Mode = 0,
    Buffered_Mode,
}Data_Renew_Mode_Enum;

typedef struct
{
  INT8U Value;
  INT8U Symbol;
  INT8U Valid;
  INT8U LED;
  uint16_t FastModeCnt;
  Data_Renew_Mode_Enum Mode;
  uint8_t DampT;
  uint8_t DampTCnt;
  uint8_t  destPosition;
  uint8_t  curPosition;
}DataCoolantStruct;

extern DataCoolantStruct Coolant_Temperature_st;


typedef struct
{
  INT16U Value;
  INT8U Icon;
  INT8U Valid;
  INT8U Dis_Value;
  uint16_t FastModeCnt;
  Data_Renew_Mode_Enum Mode;
  uint8_t DampT;
  uint8_t DampTCnt;
  uint8_t destPosition;
  uint8_t curPosition;
}DataUreaStruct;
extern DataUreaStruct Urea_st;


typedef struct
{
  uint8_t Value;
  uint8_t Valid;
  uint8_t Hour;
  uint8_t Min;
}Urea_Limited_Torque_Struct;
typedef struct
{
  uint8_t Value;
  uint8_t Valid;
  uint8_t Hour;
  uint8_t Min;
}Urea_Limited_Vehicle_Speed_Struct;

typedef struct
{
  uint8_t Value;
  uint8_t Symbol;
  uint8_t Valid;
  uint8_t LED;
  uint8_t Sound;
  uint8_t First_Distance;
}DataSafetyBeltStruct;
extern DataSafetyBeltStruct Safety_Belt_st;

typedef struct{
      
    INT32U Value;
    uint8_t Backup_Value;
    uint8_t Display_Value; 
    INT16U TimeCnt ;
    uint8_t   Valid;
    uint8_t Flg;
      
}_InsFuel_Eng;
extern _InsFuel_Eng      InsFuel_Eng;
extern _InsFuel_Eng      AvgFuel_Eng;

typedef struct
{
	uint16_t BoardVal;
	uint16_t CurBoardVal; //
	uint16_t OldBoardVal;
	uint16_t OldPosition;
	uint16_t CurPosition;	 //
	uint16_t DestPosition; //
	uint16_t CalPosition;
	uint16_t Time;
	uint8_t MotorReset; //
	uint8_t ZeroStep;
	uint8_t Dir;
	uint8_t Update;
	uint8_t MakeZero;
	uint8_t bPhase;
	uint8_t CalTime;
	uint8_t DelayTime;
	uint8_t MoveEn;
} _MeterPos;

typedef struct
{
    uint32_t u16SglVal;
    uint16_t u16DispVal;
    uint8_t Sign;
    uint16_t u16Counter;
    uint16_t u16SUM;
    uint16_t u16Flag;
}_Sign_Data_Struct;

extern _Sign_Data_Struct g_InstPower;
extern _Sign_Data_Struct g_SOC;
extern _Sign_Data_Struct g_MAX_Power;
extern _Sign_Data_Struct g_Range; 
extern _Sign_Data_Struct g_Voltage; 
extern _Sign_Data_Struct g_current;
extern _Sign_Data_Struct g_MAX_Voltage; 
extern _Sign_Data_Struct g_MIN_Voltage; 
extern _Sign_Data_Struct g_MAX_Battery; 
extern _Sign_Data_Struct g_MIN_Battery; 
extern _Sign_Data_Struct g_Err_Code; 

extern volatile INT16U g_accVeh;


extern _MeterPos g_revMeter;
extern _MeterPos g_vehMeter;
typedef struct
{
	INT16U CurBoardVal;
	INT16U BoardVal;
	INT16U DispVal;
	INT16U Time;
	uint8_t Time1;
} _LcdVeh;
extern _LcdVeh g_lcdVeh;


typedef struct
{
	uint16_t Duty;
	uint8_t Cycle;
	uint8_t LightStep;
	uint8_t LightCn;
} _Light;

extern _Light g_nightLight;
extern _Light g_Light;

typedef struct 
{
	uint8_t DoorOpenLast;
	uint32_t DoorOpenTimeCount;
	uint8_t DoorOpenDisplay;

}_DOOR;
#define DoorOpenOFFTime  3000

extern _DOOR G_Door;



typedef struct
{
	INT16U LedTime_05HZ;
	INT16U LedTime_1HZ;
	INT16U LedTime_1_5HZ;
	INT16U LedTime_2HZ;
	uint8_t LedBlink_05HZ;
	uint8_t LedBlink_1HZ;
	uint8_t LedBlink_1_5HZ;
	uint8_t LedBlink_2HZ;  

}_LED;

extern _LED g_LED;

typedef struct
{
  uint8_t Sound;
  uint32_t Year;
  uint16_t BackupYear;
  uint8_t LeapYear;
	uint8_t Month;
	uint8_t Date;
	uint8_t Hour;
	uint8_t Minute;
  uint8_t Hour_Local_Offset;
	uint8_t Minute_Local_Offset;
  uint8_t Hour_Local_Offset_Symbol;
	uint8_t Minute_Local_Offset_Symbol;
  uint8_t Hour_Back;
	uint8_t Minute_Back;
  uint8_t Hour_Back_Send;
	uint8_t Minute_Back_Send;
	uint8_t Seconds;
	uint16_t Lost;
  uint8_t Ldws;
}Menu_TimeSetData_Struct;
extern Menu_TimeSetData_Struct MenuData;

typedef struct
{
  uint32_t  RollingCounter;
  uint32_t  BackupCounter;
  uint16_t  Year;
  uint16_t  BackupYear;
  uint8_t   Month;
  uint8_t   Date;
  uint8_t   Hour;
  uint8_t   Minute;
  uint8_t   Second;
  uint8_t   LeapYear;
}RTITimingStruct;
extern RTITimingStruct RealTimeClock;

typedef enum
{
    Page_SelfCheck = 0,
    Page_Alarm,
    Page_Menu,

    Page_Max,
}_PageType_Enum;

typedef struct 
{
    
    uint16_t       Back_Time_Left;
    uint16_t       Back_Time_Right;
    uint8_t       Back_Time_Right_Flag;
    uint8_t       Back_Time_Left_Flag;
    _PageType_Enum PageType;
    
    unsigned int u16SelfCheckTimeCnt;

}_Page_Infor;

typedef enum
{
   GEAR_R = 0,
   GEAR_N,
   GEAR_P,
   GEAR_D, 
   GEAR_1,
   GEAR_2,
   GEAR_3,
   GEAR_4,
   GEAR_5,
   GEAR_6,
   GEAR_7,
   GEAR_8,
   GEAR_Max,
}_Gear_Mode;

typedef struct
{
  uint8_t Valid;
  uint8_t Blink;
  _Gear_Mode Mode;
}_Gear_Struct;
extern  _Gear_Struct Gear;

typedef struct
{
	uint8_t  Wheel_ID;
	uint8_t  TPMS_Blink;
	uint8_t  TPMS_Valid;
	uint8_t  Press_Valid;
	uint8_t  Press_St;
	INT16U Press_Value;
	uint8_t  Temp_Valid;
	uint8_t  Temp_St;
	INT16U Temp_Value;
	INT16U Temp_Symbol;	
	uint8_t  Sensor_Loss;
	uint8_t  Fast_Press;
	uint8_t  Pop_Check;
	uint8_t  LED_Blink;
  uint8_t  Wheel_ID_Time;
  uint8_t  Wheel_ID_OutTime;
  uint8_t  Wheel_ID_Time_Lost;
}_TPMS_Display_Infor;

typedef struct
{
  uint32_t night_mode_time; //夜间模式延时时间
  uint8_t  night_mode_sta;  //夜间模式状态
}DataEnternightmode;  

extern  _TPMS_Display_Infor Left_Front_Display;
extern  _TPMS_Display_Infor Left_Rear_Display;
extern  _TPMS_Display_Infor Left_Rear_Inside_Display;
extern  _TPMS_Display_Infor Right_Front_Display;
extern  _TPMS_Display_Infor Right_Rear_Display;
extern  _TPMS_Display_Infor Right_Rear_Inside_Display;
extern  _TPMS_Display_Infor TPMS_Info;
extern  _TPMS_Display_Infor Left_Front_Display_Backup;
extern  _TPMS_Display_Infor Left_Rear_Display_Backup;
extern  _TPMS_Display_Infor Left_Rear_Inside_Display_Backup;
extern  _TPMS_Display_Infor Right_Front_Display_Backup;
extern  _TPMS_Display_Infor Right_Rear_Display_Backup;
extern  _TPMS_Display_Infor Right_Rear_Inside_Display_Backup;
extern  _TPMS_Display_Infor TPMS_Info_Display_Backup;
typedef struct
{
  uint8_t  Can_0A18A006: 1;
  uint8_t  Can_0CF00400: 1;
  uint8_t  Can_18FF2100: 1;
  uint8_t  Can_18FEEE00: 1;
  
  uint8_t  Can_18FEF100: 1;
  uint8_t  Can_18FD0700: 1;
  uint8_t  Can_18FEFF00: 1;
  uint8_t  Can_18FEE400: 1;

  uint8_t  Can_18FECA00: 1; 
  uint8_t  Can_18FD7C00: 1;
  uint8_t  Can_18FF4C00: 1;
  //uint8_t  Can_10FF4117: 1;
  //uint8_t  Can_18FEFC17: 1;
  //uint8_t  Can_18FEC1EE: 1;
  uint8_t  Can_10FF1021: 1;

  uint8_t  Can_10FF7521: 1;
  uint8_t  Can_18FEF433: 1;
  uint8_t  Can_18FF9CF1: 1;
  uint8_t  Can_18FECA03: 1;

  uint8_t  Can_18FF4453: 1;
  uint8_t  Can_18FFA8EE: 1;
  uint8_t  Can_18FFB078: 1;
  uint8_t  Can_18FE4A03: 1;

  uint8_t  Can_18F00503: 1;
  uint8_t  Can_18FF9DF1: 1;
  uint8_t  Can_18FE5BE8: 1;
  uint8_t  Can_10F007E8: 1;
}_Can_Receive_Struct;
extern _Can_Receive_Struct  CanReceive;

typedef struct
{
    uint16_t ESpeedBackup;
    uint16_t Timer;
    uint8_t  Mode;
} DataESpeedIdleStruct; 

void Vehicle_Speed_Init(void );
void Data_Vehicle_Speed_Processing_Service(void);
void Engine_Speed_Init(void );
void Data_Engine_Speed_Processing_Service(void );
uint16_t Get_DataESpeedValid(void);
void Coolant_Init(void );
void Data_Coolant_Temp_Processing_Service(void);
void Data_Instantaneous_Fuel_Service(void );
void Data_Instantaneous_Fuel_Display_Service(void);
uint16_t GetRangeDisValue(void);
uint8_t GetRangeValid(void);
void Common_Input_Para(void);
uint32_t Common_GetIgnOnTime(void);
uint32_t Common_GetIgnOffTime(void);
uint16_t Common_Get_Act_V_Speed(void);
uint8_t Common_Get_Act_V_Speed_Valid(void);
uint16_t Get_DispVechileSpeed(void);
uint16_t Get_DispEngineSpeed(void);
void GUI_Light_Init(void);
void GUI_nightLightWeakup_Init(void);
void GUI_Sound_Init(void);
void Gui_LightProc(void);
void Data_Clear_Trip(void);
void Data_Clear_Odo(void);
void Data_Clear_Ins_fuel(void);
void Data_Clear_Avg_fuel(void);	
void Data_Clear_Range(void);
void Data_TPMS_Value_Processing(void);
void Data_TPMS_30_15KL_Processing(void);
void Flash_Service(void);
void Data_Urea_Processing_Service(void);
void Data_Urea_Limited_Vehicle_Speed(void);
void Data_Urea_Limited_Torque(void);
void Flash_Init(void);
void Data_30KL_Init(void);
void Data_15KL_Init(void);
void Instantaneous_Fuel_Init(void);
void Fuel_Range_Init(void);
void Urea_Init(void);
void Data_Clear_TYW(void);
void Can_Receive_Init(void);
void Can_0A18A006_Receive(void);
void Can_0CF00400_Receive(void);
void Can_18FF2100_Receive(void);
void Can_18FEEE00_Receive(void);
void Can_18FEF100_Receive(void);
void Can_18FD0700_Receive(void);
void Can_18FEFF00_Receive(void);
void Can_18FEE400_Receive(void);
void Can_18FECA00_Receive(void);
void Can_18FD7C00_Receive(void);
void Can_18FF4C00_Receive(void);
//void Can_10FF4117_Receive(void);
//void Can_18FEFC17_Receive(void);
//void Can_18FEC1EE_Receive(void);
void Can_10FF1021_Receive(void);
void Can_10FF7521_Receive(void);
void Can_18FEF433_Receive(void);
void Can_18FF9CF1_Receive(void);
void Can_18FECA03_Receive(void);
void Can_18FF4453_Receive(void);
void Can_18FFA8EE_Receive(void);
void Can_18FFB078_Receive(void);
void Can_18FE4A03_Receive(void);
void Can_18F00503_Receive(void);
void Can_18FF9DF1_Receive(void);
void Can_18FE5BE8_Receive(void);
void Can_10F007E8_Receive(void);
void Damping_Data_Renew_Mode(uint8_t Valid, uint8_t FastModeDurtion, uint16_t *FastModeTimeCnt,  uint8_t *Mode);
void Data_Coolant_Display(void);
uint16_t Get_InsFuel_Value(void);
uint8_t Get_InsFuel_Valid(void);
uint8_t Get_Coolant_Temp_Value(void );
uint8_t Get_Coolant_Temp_Valid(void );
uint8_t Get_Coolant_Temp_Symbol(void );
uint8_t GET_Gear_Mode(void);
uint8_t GET_Gear_Valid(void);
uint8_t GET_Gear_Blink(void);
void Data_Gear_Processing_Service(void);
void Gear_Init(void);
uint8_t Get_Urea_Valid(void);
uint8_t Get_Coolant_curPosition(void );
uint8_t Get_Urea_curPosition(void );
void RTC_TIME_Processing_Service(void);
INT8U Get_NodeConfig_TPMS(void);
INT8U Get_NodeConfig_AirBag(void);
INT8U Get_NodeConfig_ESP(void);
INT8U Get_NodeConfig_LWDS(void);
INT8U Get_NodeConfig_GearBoxType(void);
void MenuData_Time_Service(void);
void Can18FF9CF1_Lost (void);
void Power_Management_Time_Handle(void);	
uint16_t Get_OFF_FUEL_Dely_Time(void);
//void Data_Clear_IVECO(void);
void Can_RX_ResetAllTimer_Self_Check(void);
void Data_GPIO_Sleep_Init(void);
void TPMS_Tyre_Lost(void);
void CAN_Time_Lost(void);
INT8U Get_Mcu_Abnormal_Reset(void);
uint16_t Get_ActualEngineSpeed(void);
extern void Enter_night_mode(void);
extern uint32_t Get_Enter_night_mode_sta(void);

#endif
