#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_in.h"
#include "LED_Driver.h"
#include "g_includes.h"
#include "UDS_2FService_Main.h"
#include "GUI.h"

#pragma alignvar(8)
Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ];
//#pragma ghs section bss = ".myNonInitArea"
 _LED g_LED;
extern _2FDID3F80 LEDContrl;
 DataCoolantStruct Coolant_Temperature_st;
 DataUreaStruct Urea_st;
 DataSafetyBeltStruct Safety_Belt_st;
uint16_t Line_Fuel_Time_On = 0;
uint16_t Line_Fuel_Time_Off = 0;
uint8_t Line_Fuel_Flag_On = 0;
uint8_t Line_Fuel_Flag_Off = 0;
uint16_t Res_Fuel_Flag = 0;
uint16_t LowFuelWarningSts = 0;
//#pragma ghs section bss = default
const LED_Attr_st_t LED_Attr [] = {
    /*  */ {0, 0, 100},
    /*  */ {0, 1, 100},
    /*  */ {0, 2, 100},
    /*  */ {0, 3, 100},
    /*  */ {0, 4, 100},
    /*  */ {0, 5, 100},
    /*  */ {0, 6, 100},
    /*  */ {0, 7, 100},
    /*  */ {0, 8, 100},
    /*  */ {0, 9, 100},
    /*  */ {0, 10, 100},
    /*  */ {0, 11, 100},
    /*  */ {0, 12, 100},
    /*  */ {0, 13, 100},
    /*  */ {0, 14, 100},
    /*  */ {0, 15, 100},
    /*  */ {0, 16, 100},
    /*  */ {0, 17, 100},
    /*  */ {0, 18, 100},
    /*  */ {0, 19, 100},
    /*  */ {0, 20, 100},
    /*  */ {0, 21, 100},
    /*  */ {0, 22, 100},
    /*  */ {0, 23, 100},
    /*  */ {0, 24, 100},
    /*  */ {0, 25, 100},
    /*  */ {0, 26, 100},
    /*  */ {0, 27, 100},
    /*  */ {0, 28, 100},
    /*  */ {0, 29, 100},
    /*  */ {0, 30, 100},
    /*  */ {0, 31, 100},
    /*  */ {0, 32, 100},
    /*  */ {0, 33, 100},
    /*  */ {0, 34, 100},
    /*  */ {0, 35, 100},
};

  Tellib_uint16_t LED_Fule_Lamp_Judge(void); 
  void            LED_Fule_Lamp_Exec(Tellib_uint16_t led_status); 
  Tellib_uint16_t LED_TurnLeft_Lamp_Judge(void);
  void            LED_TurnLeft_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_TurnRight_Lamp_Judge(void);
  void            LED_TurnRight_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Park_Lamp_Judge(void);
  void            LED_Park_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_High_Lamp_Judge(void);
  void            LED_High_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_DoorOpen_Lamp_Judge(void);
  void            LED_DoorOpen_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Ffog_Lamp_Judge(void);
  void            LED_Ffog_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Rfog_Lamp_Judge(void);
  void            LED_Rfog_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_ABS_Lamp_Judge(void);
  void            LED_ABS_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EBD_Lamp_Judge(void);
  void            LED_EBD_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EngWaitToStart_Lamp_Judge(void);
  void            LED_EngWaitToStart_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EDC_Lamp_Judge(void);
  void            LED_EDC_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EOBD_Lamp_Judge(void);
  void            LED_EOBD_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Water_High_Lamp_Judge(void); 
  void            LED_Water_High_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Cruise_Lamp_Judge(void);
  void            LED_Cruise_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EDC_WaterInFuelInd1_Lamp_Judge(void);
  void            LED_EDC_WaterInFuelInd1_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EDC_EngOilPrsLow_Lamp_Judge(void);
  void            LED_EDC_EngOilPrsLow_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_DPF_Lamp_Judge(void);
  void            LED_DPF_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_EDC_MaxVehSpeedLimSetp_Lamp_Judge(void);
  void            LED_EDC_MaxVehSpeedLimSetp_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_TBOX_Lamp_Judge(void);
  void            LED_TBOX_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Brake_Lamp_Judge(void);
  void            LED_Brake_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_HandBrake_Lamp_Judge(void);
  void            LED_HandBrake_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Safety_Belt_Lamp_Judge(void);
  void            LED_Safety_Belt_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Diesel_Heating_Lamp_Judge(void);
  void            LED_Diesel_Heating_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_AIRBAG_Lamp_Judge(void);
  void            LED_AIRBAG_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Urea_Lamp_Judge(void);
  void            LED_Urea_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_TPMS_Lamp_Judge(void);
  void            LED_TPMS_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_ESP_Lamp_Judge(void);
  void            LED_ESP_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Gearbox_Lamp_Judge(void);
  void            LED_Gearbox_Lamp_Exec(Tellib_uint16_t led_status);
  Tellib_uint16_t LED_Gearbox_Serious_Lamp_Judge(void); 
  void            LED_Gearbox_Serious_Lamp_Exec(Tellib_uint16_t led_status);




const LED_Attribute_st LED_Attribute [ LED_Max ] = {
{m_LED_Fule_Lamp,                    SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Fule_Lamp_Judge,                    LED_Fule_Lamp_Exec,                     },
{m_LED_TPMS_Lamp,                    SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_TPMS_Lamp_Judge,                    LED_TPMS_Lamp_Exec,                     },
{m_LED_Urea_Lamp,                    SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Urea_Lamp_Judge,                    LED_Urea_Lamp_Exec,                     },
{m_LED_EDC_WaterInFuelInd1_Lamp,     SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EDC_WaterInFuelInd1_Lamp_Judge,     LED_EDC_WaterInFuelInd1_Lamp_Exec,      },
{m_LED_AIRBAG_Lamp,                  NoSelfCheck,  ExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_AIRBAG_Lamp_Judge,                  LED_AIRBAG_Lamp_Exec,                   },
{m_LED_HandBrake_Lamp,               SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_HandBrake_Lamp_Judge,               LED_HandBrake_Lamp_Exec,                },
{m_LED_Diesel_Heating_Lamp,          NoSelfCheck,  ExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Diesel_Heating_Lamp_Judge,          LED_Diesel_Heating_Lamp_Exec,           },
{m_LED_TBOX_Lamp,                    SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_TBOX_Lamp_Judge,                    LED_TBOX_Lamp_Exec,                     },
{m_LED_EBD_Lamp,                     SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EBD_Lamp_Judge,                     LED_EBD_Lamp_Exec,                      },
{m_LED_EDC_MaxVehSpeedLimSetp_Lamp,  SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EDC_MaxVehSpeedLimSetp_Lamp_Judge,  LED_EDC_MaxVehSpeedLimSetp_Lamp_Exec,   },
{m_LED_EOBD_Lamp,                    SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EOBD_Lamp_Judge,                    LED_EOBD_Lamp_Exec,                     },
{m_LED_Water_High_Lamp,              SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Water_High_Lamp_Judge,              LED_Water_High_Lamp_Exec,               },
{m_LED_Brake_Lamp,                   SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Brake_Lamp_Judge,                   LED_Brake_Lamp_Exec,                    },
{m_LED_DPF_Lamp,                     SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_DPF_Lamp_Judge,                     LED_DPF_Lamp_Exec,                      },
{m_LED_ESP_Lamp,                     SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_ESP_Lamp_Judge,                     LED_ESP_Lamp_Exec,                      },
{m_LED_EDC_Lamp,                     SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EDC_Lamp_Judge,                     LED_EDC_Lamp_Exec,                      },
{m_LED_Cruise_Lamp,                  SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Cruise_Lamp_Judge,                  LED_Cruise_Lamp_Exec,                   },
{m_LED_ABS_Lamp,                     SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_ABS_Lamp_Judge,                     LED_ABS_Lamp_Exec,                      },
{m_LED_DoorOpen_Lamp,                NoSelfCheck,  ExterNalCheck,    LED_IGN_ON_OFF,  0ul,    3000ul,  LED_DoorOpen_Lamp_Judge,                LED_DoorOpen_Lamp_Exec,                 },
{m_LED_EngWaitToStart_Lamp,          SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EngWaitToStart_Lamp_Judge,          LED_EngWaitToStart_Lamp_Exec,           },
{m_LED_EDC_EngOilPrsLow_Lamp,        SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_EDC_EngOilPrsLow_Lamp_Judge,        LED_EDC_EngOilPrsLow_Lamp_Exec,         },
{m_LED_Ffog_Lamp,                    NoSelfCheck,  ExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Ffog_Lamp_Judge,                    LED_Ffog_Lamp_Exec,                     },
{m_LED_TurnLeft_Lamp,                NoSelfCheck,  ExterNalCheck,  LED_IGN_ON_OFF,  0ul,    3000ul,  LED_TurnLeft_Lamp_Judge,                LED_TurnLeft_Lamp_Exec,                 },
{m_LED_Gearbox_Lamp,                 SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Gearbox_Lamp_Judge,                 LED_Gearbox_Lamp_Exec,                  },
{m_LED_Gearbox_Serious_Lamp,         NoSelfCheck,  ExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Gearbox_Serious_Lamp_Judge,         LED_Gearbox_Serious_Lamp_Exec,          },
{m_LED_High_Lamp,                    NoSelfCheck,  ExterNalCheck,    LED_IGN_ON_OFF,  0ul,    3000ul,  LED_High_Lamp_Judge,                    LED_High_Lamp_Exec,                     },
{m_LED_Park_Lamp,                    NoSelfCheck,  ExterNalCheck,    LED_IGN_ON_OFF,  0ul,    3000ul,  LED_Park_Lamp_Judge,                    LED_Park_Lamp_Exec,                     },
{m_LED_Safety_Belt_Lamp,             SelfCheck,    NoExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Safety_Belt_Lamp_Judge,             LED_Safety_Belt_Lamp_Exec,              },
{m_LED_TurnRight_Lamp,               NoSelfCheck,  ExterNalCheck,  LED_IGN_ON_OFF,  0ul,    3000ul,  LED_TurnRight_Lamp_Judge,               LED_TurnRight_Lamp_Exec,                },
{m_LED_Rfog_Lamp,                    NoSelfCheck,  ExterNalCheck,  LED_IGN_ON,      0ul,    3000ul,  LED_Rfog_Lamp_Judge,                    LED_Rfog_Lamp_Exec,                     },
};



void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength           = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk  = Common_GetIgnOnTime;
    m_ExtPara.LED_PowerCbk          = PoMa_Get_IG_Status;
    Telltales_KL30_Wakeup_Init(( Tellib_uint8_t * )Tel_Mem, LED_Attribute, &m_ExtPara);
}

Tellib_uint16_t Fule_Res = 0u;
Tellib_uint16_t LED_Fule_Lamp_Judge(void)
{
    if(GetFuelResistance() > 2650)
    {
        Res_Fuel_Flag = 1;
    }
    else
    {
        if(GetFuelResistance() <= 2550)
        {
            Res_Fuel_Flag = 0;
        }
    }

    if ( Line_In_Get_Status(LINE_IN_Fuel_Alarm) == 1u )
    {
        Line_Fuel_Time_Off = 0;
        Line_Fuel_Flag_Off = 0;
        Line_Fuel_Time_On++;
        if(Line_Fuel_Time_On >= 200)
        {
            Line_Fuel_Time_On = 200;
            Line_Fuel_Flag_On = 1;  
        } 
        if((Line_Fuel_Flag_On)&&(Res_Fuel_Flag))
        {
            Fule_Res = 1;
        } 
    }
    else
    {
        Line_Fuel_Time_On = 0;
        Line_Fuel_Flag_On = 0;
        Line_Fuel_Time_Off++;
        if(Line_Fuel_Time_Off >= 200)
        {
            Line_Fuel_Time_Off = 200;
            Line_Fuel_Flag_Off = 1;
        }
        if((Line_Fuel_Flag_Off)&&(Res_Fuel_Flag == 0))
        {
            Fule_Res = 0;
        }
    }
    return Fule_Res;
}
void LED_Fule_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.LowFuelAlarm == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Fule_Lamp].chip, LED_Attr[LED_Fule_Lamp].channel, LED_Attr[LED_Fule_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Fule_Lamp].chip, LED_Attr[LED_Fule_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Fule_Lamp].chip, LED_Attr[LED_Fule_Lamp].channel, LED_Attr[LED_Fule_Lamp].brightness);
            LowFuelWarningSts = 1;
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Fule_Lamp].chip, LED_Attr[LED_Fule_Lamp].channel, 0);
            LowFuelWarningSts = 0;
        }
    }
    
}

INT16U Get_LowFuelWarningSts(void)
{
    return LowFuelWarningSts;
}

Tellib_uint16_t LED_TurnLeft_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    return res;
}
void LED_TurnLeft_Lamp_Exec(Tellib_uint16_t led_status) 
{
}

  Tellib_uint16_t LED_TurnRight_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    return res;
}
  void LED_TurnRight_Lamp_Exec(Tellib_uint16_t led_status) 
{
}

  Tellib_uint16_t LED_Park_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) == CAN_SIG_LOST )
    {
        res = 0u;
    }
    else
    {
        if((Get_CAN_CH0_ID_10FF1021_Sig_LHParkTailLightSts() == 1)||(Get_CAN_CH0_ID_10FF1021_Sig_RHParkTailLightSts() == 1))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    return res;
}
  void LED_Park_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.SmallLight == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Park_Lamp].chip, LED_Attr[LED_Park_Lamp].channel, LED_Attr[LED_Park_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Park_Lamp].chip, LED_Attr[LED_Park_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Park_Lamp].chip, LED_Attr[LED_Park_Lamp].channel, LED_Attr[LED_Park_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Park_Lamp].chip, LED_Attr[LED_Park_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_High_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) == CAN_SIG_LOST )
    {
        res = 0u;
    }
    else
    {
        if(Get_CAN_CH0_ID_10FF1021_Sig_HighBeamSts() == 1)
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    return res;
}
  void LED_High_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.HighBeam == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_High_Lamp].chip, LED_Attr[LED_High_Lamp].channel, LED_Attr[LED_High_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_High_Lamp].chip, LED_Attr[LED_High_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_High_Lamp].chip, LED_Attr[LED_High_Lamp].channel, LED_Attr[LED_High_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_High_Lamp].chip, LED_Attr[LED_High_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_DoorOpen_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF7521_Msg_Count) == CAN_SIG_LOST )
    {
        res = 0u;
    }
    else
    {
        if((Get_CAN_CH0_ID_10FF7521_Sig_PsngrDoorSts() == 1)||
           (Get_CAN_CH0_ID_10FF7521_Sig_DriverDoorSts() == 1)||
           (Get_CAN_CH0_ID_10FF7521_Sig_BonnetSts() == 1)||
           (Get_CAN_CH0_ID_10FF7521_Sig_RHatchSts() == 1)||
           (Get_CAN_CH0_ID_10FF7521_Sig_RHRDoorSts() == 1))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    return res;
}
  void LED_DoorOpen_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.DoorOpen == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_Lamp].chip, LED_Attr[LED_DoorOpen_Lamp].channel, LED_Attr[LED_DoorOpen_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_Lamp].chip, LED_Attr[LED_DoorOpen_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_Lamp].chip, LED_Attr[LED_DoorOpen_Lamp].channel, LED_Attr[LED_DoorOpen_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DoorOpen_Lamp].chip, LED_Attr[LED_DoorOpen_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_Ffog_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) == CAN_SIG_LOST )
    {
        res = 0u;
    }
    else
    {
        if(Get_CAN_CH0_ID_10FF1021_Sig_FrontFogLightSts() == 1)
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    return res;
}
  void LED_Ffog_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.FrontForg == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Ffog_Lamp].chip, LED_Attr[LED_Ffog_Lamp].channel, LED_Attr[LED_Ffog_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Ffog_Lamp].chip, LED_Attr[LED_Ffog_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Ffog_Lamp].chip, LED_Attr[LED_Ffog_Lamp].channel, LED_Attr[LED_Ffog_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Ffog_Lamp].chip, LED_Attr[LED_Ffog_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_Rfog_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) == CAN_SIG_LOST )
    {
        res = 0u;
    }
    else
    {
        if(Get_CAN_CH0_ID_10FF1021_Sig_RearFogLightSts() == 1)
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    return res;
}
  void LED_Rfog_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.RearForg == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Rfog_Lamp].chip, LED_Attr[LED_Rfog_Lamp].channel, LED_Attr[LED_Rfog_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Rfog_Lamp].chip, LED_Attr[LED_Rfog_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Rfog_Lamp].chip, LED_Attr[LED_Rfog_Lamp].channel, LED_Attr[LED_Rfog_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Rfog_Lamp].chip, LED_Attr[LED_Rfog_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_ABS_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    return res;
}
  void LED_ABS_Lamp_Exec(Tellib_uint16_t led_status) 
{
}
  Tellib_uint16_t LED_EBD_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    return res;
}
  void LED_EBD_Lamp_Exec(Tellib_uint16_t led_status) 
{
}
  Tellib_uint16_t LED_EngWaitToStart_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    
    {
        if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEE400_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
        {
            res = 2u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FEE400_Sig_EDC_WaittoStartLamp() == 1)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        } 
    }
    
    return res;
}
  void LED_EngWaitToStart_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.PreheatIndicator == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EngWaitToStart_Lamp].chip, LED_Attr[LED_EngWaitToStart_Lamp].channel, LED_Attr[LED_EngWaitToStart_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EngWaitToStart_Lamp].chip, LED_Attr[LED_EngWaitToStart_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EngWaitToStart_Lamp].chip, LED_Attr[LED_EngWaitToStart_Lamp].channel, LED_Attr[LED_EngWaitToStart_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EngWaitToStart_Lamp].chip, LED_Attr[LED_EngWaitToStart_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EngWaitToStart_Lamp].chip, LED_Attr[LED_EngWaitToStart_Lamp].channel, LED_Attr[LED_EngWaitToStart_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EngWaitToStart_Lamp].chip, LED_Attr[LED_EngWaitToStart_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_EDC_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FECA00_Msg_Count) == CAN_SIG_LOST )
    {
        if(Get_CAN_CH0_ID_18EBFF00_Sig_RedStopLamp() == 1)
        {
            res = 2u;
        }
        else 
        {
            if(Get_CAN_CH0_ID_18EBFF00_Sig_AmberWarnLamp() == 1)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        }
    }
    else
    {
        if((Get_CAN_CH0_ID_18FECA00_Sig_RedStopLamp() == 1)||(Get_CAN_CH0_ID_18EBFF00_Sig_RedStopLamp() == 1))
        {
            res = 2u;
        }
        else
        {
            if((Get_CAN_CH0_ID_18FECA00_Sig_AmberWarnLamp() == 1)||(Get_CAN_CH0_ID_18EBFF00_Sig_AmberWarnLamp() == 1))
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        }
    } 
    return res;
}
  void LED_EDC_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.EDC == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_Lamp].chip, LED_Attr[LED_EDC_Lamp].channel, LED_Attr[LED_EDC_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_Lamp].chip, LED_Attr[LED_EDC_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EDC_Lamp].chip, LED_Attr[LED_EDC_Lamp].channel, LED_Attr[LED_EDC_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EDC_Lamp].chip, LED_Attr[LED_EDC_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_Lamp].chip, LED_Attr[LED_EDC_Lamp].channel, LED_Attr[LED_EDC_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_Lamp].chip, LED_Attr[LED_EDC_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_EOBD_Lamp_Judge(void)
{
    Tellib_uint16_t res = 0u;
    
    {
       if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FD0700_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
        {
            res = 2u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FD0700_Sig_OBD_MIL_LampSts() == 1)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        }  
    }
    
    return res;
} 

  void LED_EOBD_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.EOBD == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EOBD_Lamp].chip, LED_Attr[LED_EOBD_Lamp].channel, LED_Attr[LED_EOBD_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EOBD_Lamp].chip, LED_Attr[LED_EOBD_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EOBD_Lamp].chip, LED_Attr[LED_EOBD_Lamp].channel, LED_Attr[LED_EOBD_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EOBD_Lamp].chip, LED_Attr[LED_EOBD_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EOBD_Lamp].chip, LED_Attr[LED_EOBD_Lamp].channel, LED_Attr[LED_EOBD_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EOBD_Lamp].chip, LED_Attr[LED_EOBD_Lamp].channel, 0);
        }
    }
    
}
Tellib_uint16_t Water_High_Res = 0u;
  Tellib_uint16_t LED_Water_High_Lamp_Judge(void) 
{
    
    if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FEEE00_Msg_Count) == CAN_MSG_LOST)||(CanReceive.Can_18FEEE00 != 1))
    {
        if((Common_GetIgnOnTime() >= 8000))
        {
            Water_High_Res = 2;
        }
    }
    else 
    {
        if(Get_Coolant_Temp_Cur_Display_Value() >= 71)
        {
            Water_High_Res = 1;
        }
        else
        {
            if(Get_Coolant_Temp_Cur_Display_Value() <= 60)
            {
                Water_High_Res = 0;
            }
        } 
    }
    return Water_High_Res;
}
  void LED_Water_High_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.CoolantAlarm == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Water_High_Lamp].chip, LED_Attr[LED_Water_High_Lamp].channel, LED_Attr[LED_Water_High_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Water_High_Lamp].chip, LED_Attr[LED_Water_High_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Water_High_Lamp].chip, LED_Attr[LED_Water_High_Lamp].channel, LED_Attr[LED_Water_High_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Water_High_Lamp].chip, LED_Attr[LED_Water_High_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Water_High_Lamp].chip, LED_Attr[LED_Water_High_Lamp].channel, LED_Attr[LED_Water_High_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Water_High_Lamp].chip, LED_Attr[LED_Water_High_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_Cruise_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    
    {
        if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF100_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
        {
            res = 2u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlActive() == 1)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        } 
    }
    return res;
}
  void LED_Cruise_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.CruiseInstructions == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Cruise_Lamp].chip, LED_Attr[LED_Cruise_Lamp].channel, LED_Attr[LED_Cruise_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Cruise_Lamp].chip, LED_Attr[LED_Cruise_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Cruise_Lamp].chip, LED_Attr[LED_Cruise_Lamp].channel, LED_Attr[LED_Cruise_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Cruise_Lamp].chip, LED_Attr[LED_Cruise_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Cruise_Lamp].chip, LED_Attr[LED_Cruise_Lamp].channel, LED_Attr[LED_Cruise_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Cruise_Lamp].chip, LED_Attr[LED_Cruise_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_EDC_WaterInFuelInd1_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    
    {
        if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEFF00_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 23000))
        {
            res = 2u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FEFF00_Sig_EDC_WaterInFuelInd1() == 1)
            {
                res = 3u;
            }
            else
            {
                res = 0u;
            }
        }  
    }
    
    return res;
}
  void LED_EDC_WaterInFuelInd1_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if (led_status == 2u)
    {
        if(g_LED.LedBlink_1_5HZ)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].chip, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].channel, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].chip, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].channel, 0);
        }
    }
    else if (led_status == 3u)
    {
        if(g_LED.LedBlink_1HZ)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].chip, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].channel, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].chip, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].channel, 0);
        }
    }
    else if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].chip, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].channel, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].brightness);
    }
    else 
    {
        LED_Driver_Channel_Set(LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].chip, LED_Attr[LED_EDC_WaterInFuelInd1_Lamp].channel, 0);
    }
}
  Tellib_uint16_t LED_EDC_EngOilPrsLow_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    
    {
        if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF2100_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
        {
            res = 2u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FF2100_Sig_EDC_EngOilPrsLow() == 1)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        } 
    }
    
    return res;
}
  void LED_EDC_EngOilPrsLow_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.LowOilPressure == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_EngOilPrsLow_Lamp].chip, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].channel, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_EngOilPrsLow_Lamp].chip, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EDC_EngOilPrsLow_Lamp].chip, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].channel, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_EDC_EngOilPrsLow_Lamp].chip, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_EngOilPrsLow_Lamp].chip, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].channel, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_EngOilPrsLow_Lamp].chip, LED_Attr[LED_EDC_EngOilPrsLow_Lamp].channel, 0);
        }
    }
}
  Tellib_uint16_t LED_DPF_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    
    {
        if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FD7C00_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
        {
            res = 4u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts() == 1)
            {
                res = 1u;
            }
            else if(Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts() == 2)
            {
                res = 3u;
            }
            else if(Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts() == 4)
            {
                res = 2u;
            }
            else
            {
                res = 0u;
            }
        } 
    }
    
    return res;
}
  void LED_DPF_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.DPF == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, LED_Attr[LED_DPF_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 4u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, LED_Attr[LED_DPF_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, 0);
            }
        }
        else if (led_status == 3u)
        {
            if(g_LED.LedBlink_2HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, LED_Attr[LED_DPF_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, 0);
            }
        }
        else if (led_status == 2u)
        {
            if(g_LED.LedBlink_1HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, LED_Attr[LED_DPF_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, LED_Attr[LED_DPF_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_DPF_Lamp].chip, LED_Attr[LED_DPF_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_EDC_MaxVehSpeedLimSetp_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF2100_Msg_Count) == CAN_SIG_LOST )||(CanReceive.Can_18FF2100 != 1))
    {
        res = 0u;
        CanReceive.Can_18FF2100 = 0;
    }
    else
    {
        if(Get_CAN_CH0_ID_18FF2100_Sig_EDC_MaxVehSpeedLimSetp() <= (Common_Get_Act_V_Speed()/10))
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    } 
    return res;
}
  void LED_EDC_MaxVehSpeedLimSetp_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.OverSpeed == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].chip, LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].channel, LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].chip, LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].chip, LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].channel, LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].chip, LED_Attr[LED_EDC_MaxVehSpeedLimSetp_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_TBOX_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
   
    {
        if( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 53000)&&(MenuData.Lost >= 450))
        {
            res = 1u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts() == 1)
            {
                res = 1u;
            }
            else
            {
                if(Get_CAN_CH0_ID_18FFA8EE_Sig_SelfCheckingStatus() == 1)
                {
                    res = 1u;
                }
                else
                {
                    res = 0u;
                }
            }
        }
    }
   
    return res;
}
  void LED_TBOX_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.TboxAlarm == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TBOX_Lamp].chip, LED_Attr[LED_TBOX_Lamp].channel, LED_Attr[LED_TBOX_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TBOX_Lamp].chip, LED_Attr[LED_TBOX_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TBOX_Lamp].chip, LED_Attr[LED_TBOX_Lamp].channel, LED_Attr[LED_TBOX_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TBOX_Lamp].chip, LED_Attr[LED_TBOX_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_Brake_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if ( Line_In_Get_Status(LINE_IN_Brake_Fault) == 1u )
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }
    return res;
}
  void LED_Brake_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.BrakeFault == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Brake_Lamp].chip, LED_Attr[LED_Brake_Lamp].channel, LED_Attr[LED_Brake_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Brake_Lamp].chip, LED_Attr[LED_Brake_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Brake_Lamp].chip, LED_Attr[LED_Brake_Lamp].channel, LED_Attr[LED_Brake_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Brake_Lamp].chip, LED_Attr[LED_Brake_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_HandBrake_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if ( Line_In_Get_Status(LINE_IN_Handbrake) == 1u )
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }
    return res;
}
  void LED_HandBrake_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.HandBreak == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HandBrake_Lamp].chip, LED_Attr[LED_HandBrake_Lamp].channel, LED_Attr[LED_HandBrake_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HandBrake_Lamp].chip, LED_Attr[LED_HandBrake_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HandBrake_Lamp].chip, LED_Attr[LED_HandBrake_Lamp].channel, LED_Attr[LED_HandBrake_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_HandBrake_Lamp].chip, LED_Attr[LED_HandBrake_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_Safety_Belt_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if(Line_In_Get_Status (LINE_IN_Safety_Belt) == 1) 
    {
        res = 1;
    }
    else
    {
        res = 0;
    }

    return res;
}
  void LED_Safety_Belt_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.DriverSeatBelt == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Safety_Belt_Lamp].chip, LED_Attr[LED_Safety_Belt_Lamp].channel, LED_Attr[LED_Safety_Belt_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Safety_Belt_Lamp].chip, LED_Attr[LED_Safety_Belt_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Safety_Belt_Lamp].chip, LED_Attr[LED_Safety_Belt_Lamp].channel, LED_Attr[LED_Safety_Belt_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Safety_Belt_Lamp].chip, LED_Attr[LED_Safety_Belt_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_Diesel_Heating_Lamp_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if ( Line_In_Get_Status(LINE_IN_Fuel_Warmwind) == 1u )
    {
        res = 1u;
    }
    else
    {
        res = 0u;
    }
    return res;
} 
  void LED_Diesel_Heating_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.Heater == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Diesel_Heating_Lamp].chip, LED_Attr[LED_Diesel_Heating_Lamp].channel, LED_Attr[LED_Diesel_Heating_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Diesel_Heating_Lamp].chip, LED_Attr[LED_Diesel_Heating_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Diesel_Heating_Lamp].chip, LED_Attr[LED_Diesel_Heating_Lamp].channel, LED_Attr[LED_Diesel_Heating_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Diesel_Heating_Lamp].chip, LED_Attr[LED_Diesel_Heating_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_AIRBAG_Lamp_Judge(void)
{
    Tellib_uint16_t res = 0u;
    if (Get_NodeConfig_AirBag() == 0)
    {
        if((Line_In_Get_Status(LINE_IN_AIRBAG_POSITIVE) == 1) && (Line_In_Get_Status(LINE_IN_AIRBAG_NEGATIVE) == 1) ) 
        {
            res = 1u;
        }
        else
        {
            res = 0u;
        }
    }
    else
    {
        if ((Get_NodeConfig_AirBag() == 1)||(Get_NodeConfig_AirBag() == 2)||(Get_NodeConfig_AirBag() == 3))
        {
            if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF4453_Msg_Count) == CAN_SIG_LOST )
            {
                res = 0u;
            }
            else
            {
                if(Get_CAN_CH0_ID_18FF4453_Sig_AirbagFail() == 2)
                {
                    res = 1u;
                }
                else
                {
                    res = 0u;
                }
            }
        }
        else
        {
            res = 0u;
        }
    }
    return res;
} 
  void LED_AIRBAG_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.Airbag == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_AIRBAG_Lamp].chip, LED_Attr[LED_AIRBAG_Lamp].channel, LED_Attr[LED_AIRBAG_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_AIRBAG_Lamp].chip, LED_Attr[LED_AIRBAG_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_AIRBAG_Lamp].chip, LED_Attr[LED_AIRBAG_Lamp].channel, LED_Attr[LED_AIRBAG_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_AIRBAG_Lamp].chip, LED_Attr[LED_AIRBAG_Lamp].channel, 0);
        }
    }
}
  Tellib_uint16_t LED_Urea_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    
    {
        if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF4C00_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
        {
            res = 4u;
        }
        else
        {
            if(Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_lamp() == 3)
            {
                res = 1u;
            }
            else if(Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_lamp() == 2)
            {
                res = 2u;
            }
            else if(Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_lamp() == 1)
            {
                res = 3u;
            }
            else
            {
                if((Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text() == 2)||
                   (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text() == 3)||
                   (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text() == 4)||
                   (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text() == 5)||
                   (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text() == 6)||
                   (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text() == 7))
                {
                    res = 1u;
                }
                else
                {
                    res = 0u;
                }
            }
        }
    }
    return res;
}
  void LED_Urea_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.urea == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, LED_Attr[LED_Urea_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, 0);
        }
    }
    else
    {
        if (led_status == 4u)
        {
            if(g_LED.LedBlink_1_5HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, LED_Attr[LED_Urea_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, 0);
            }
        }
        else if (led_status == 3u)
        {
            if(g_LED.LedBlink_2HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, LED_Attr[LED_Urea_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, 0);
            }
        }
        else if (led_status == 2u)
        {
            if(g_LED.LedBlink_1HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, LED_Attr[LED_Urea_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, LED_Attr[LED_Urea_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_Urea_Lamp].chip, LED_Attr[LED_Urea_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_TPMS_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if((Get_NodeConfig_TPMS() != 1)&&(Get_NodeConfig_TPMS() != 2))
    {
        res = 0u;
    }
    else
    {
        
        {
            if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
            {
                res = 1u;
            }
            else
            {
                if((Left_Front_Display.LED_Blink == 1)||(Right_Front_Display.LED_Blink == 1)||(Left_Rear_Display.LED_Blink == 1)||
                   (Right_Rear_Display.LED_Blink == 1)||(Left_Rear_Inside_Display.LED_Blink == 1)||(Right_Rear_Inside_Display.LED_Blink == 1))
                {
                    res = 1;
                }
                else if((Left_Front_Display.LED_Blink == 2)||(Right_Front_Display.LED_Blink == 2)||(Left_Rear_Display.LED_Blink == 2)||
                        (Right_Rear_Display.LED_Blink == 2)||(Left_Rear_Inside_Display.LED_Blink == 2)||(Right_Rear_Inside_Display.LED_Blink == 2))
                {
                    res = 2;
                }
                else
                {
                    res = 0;
                }
            } 
        }
    }
    return res;
}
  void LED_TPMS_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_DIAG_TelltalesCtrlsts() == 3)
    {
        if(LEDContrl._3F80.TPMSAlarm == 1)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TPMS_Lamp].chip, LED_Attr[LED_TPMS_Lamp].channel, LED_Attr[LED_TPMS_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TPMS_Lamp].chip, LED_Attr[LED_TPMS_Lamp].channel, 0);
        }
    }
    else
    {
        if((Get_NodeConfig_TPMS() != 1)&&(Get_NodeConfig_TPMS() != 2))
        {
            led_status = 0;
        }

        if (led_status == 2u)
        {
            if(g_LED.LedBlink_1HZ)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_TPMS_Lamp].chip, LED_Attr[LED_TPMS_Lamp].channel, LED_Attr[LED_TPMS_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_TPMS_Lamp].chip, LED_Attr[LED_TPMS_Lamp].channel, 0);
            }
        }
        else if (led_status == 1u)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TPMS_Lamp].chip, LED_Attr[LED_TPMS_Lamp].channel, LED_Attr[LED_TPMS_Lamp].brightness);
        }
        else 
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TPMS_Lamp].chip, LED_Attr[LED_TPMS_Lamp].channel, 0);
        }
    }
    
}
  Tellib_uint16_t LED_ESP_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if(Get_NodeConfig_ESP() == 1)
    {
        
        {
            if(( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_LOST )&&(Common_GetIgnOnTime() >= 8000))
            {
                res = 1u;
            }
            else
            {
                if((Get_CAN_CH0_ID_0A18A006_Sig_AsrFail() == 1)||(Get_CAN_CH0_ID_0A18A006_Sig_VdcFail() == 1)||(Get_CAN_CH0_ID_0A18A006_Sig_BsmBtnSts() == 1))
                {
                    res = 1u;
                }
                else
                {
                    if((Get_CAN_CH0_ID_0A18A006_Sig_AsrEldInterv() == 1)||(Get_CAN_CH0_ID_0A18A006_Sig_VdcInterv() == 1))
                    {
                        res = 2u;
                    }
                    else
                    {
                        if(((Get_CAN_CH0_ID_0A18A006_Sig_AsrFail() == 0)&&(Get_CAN_CH0_ID_0A18A006_Sig_VdcFail() == 0))||(Get_CAN_CH0_ID_0A18A006_Sig_BsmBtnSts() == 0))
                        {
                            res = 0u;
                        }
                    }
                }
            }
        }
    }
    else
    {
        res = 0u;
    }
    return res;
}
  void LED_ESP_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_NodeConfig_ESP() != 1)
    {
        led_status = 0;
    }

    if (led_status == 2u)
    {
        if(g_LED.LedBlink_1HZ)
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ESP_Lamp].chip, LED_Attr[LED_ESP_Lamp].channel, LED_Attr[LED_ESP_Lamp].brightness);
        }
        else
        {
            LED_Driver_Channel_Set(LED_Attr[LED_ESP_Lamp].chip, LED_Attr[LED_ESP_Lamp].channel, 0);
        }
    }
    else if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LED_Attr[LED_ESP_Lamp].chip, LED_Attr[LED_ESP_Lamp].channel, LED_Attr[LED_ESP_Lamp].brightness);
    }
    else 
    {
        LED_Driver_Channel_Set(LED_Attr[LED_ESP_Lamp].chip, LED_Attr[LED_ESP_Lamp].channel, 0);
    }
}
//        if ( (u8DTC0XB9F0E0xx) || (u32RecSA03DTC == 0xB9F0E000) || (u8DTC0XC1F0E0xx) || (u32RecSA03DTC == 0xC1F0E000) )
//if ( (u8DTC0XCEF0E0xx) || (u32RecSA03DTC == 0xCEF0E000) )
Tellib_uint16_t LED_Gearbox_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    if(Get_NodeConfig_GearBoxType() == 1)
    {
        if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FECA03_Msg_Count) == CAN_SIG_LOST )
        {
            if((Get_CAN_CH0_ID_18EBFF03_Sig_AT_AmberWarnLamp() == 1)||(Get_CAN_CH0_ID_18EBFF03_Sig_AT_RedStopLamp() == 1)
            /*(u8DTC0XCEF0E0xx) || (u32RecSA03DTC == 0xCEF0E000) || (u8DTC0XB9F0E0xx) || (u32RecSA03DTC == 0xB9F0E000) || (u8DTC0XC1F0E0xx) || (u32RecSA03DTC == 0xC1F0E000)*/)
            {
                res = 1u;
            }
            else
            {
                res = 0u;
            }
        }
        else
        {
            if((Get_CAN_CH0_ID_18FECA03_Sig_AT_AmberWarnLamp() == 1)||(Get_CAN_CH0_ID_18FECA03_Sig_AT_RedStopLamp() == 1)||
               (Get_CAN_CH0_ID_18EBFF03_Sig_AT_AmberWarnLamp() == 1)||(Get_CAN_CH0_ID_18EBFF03_Sig_AT_RedStopLamp() == 1)||
               (u8DTC0XCEF0E0xx) || (u32RecSA03DTC == 0xCEF0E000) || (u8DTC0XB9F0E0xx) || (u32RecSA03DTC == 0xB9F0E000) || (u8DTC0XC1F0E0xx) || (u32RecSA03DTC == 0xC1F0E000))
            {
                res = 1u;
            }
            else
            {
                res = 0;
            }
        }
    }
    else
    {
        res = 0;
    }
    return res;
}
void LED_Gearbox_Lamp_Exec(Tellib_uint16_t led_status) 
{
    if(Get_NodeConfig_GearBoxType() != 1)
    {
        led_status = 0;
    }

    if (led_status == 1u)
    {
        LED_Driver_Channel_Set(LED_Attr[LED_Gearbox_Lamp].chip, LED_Attr[LED_Gearbox_Lamp].channel, LED_Attr[LED_Gearbox_Lamp].brightness);
    }
    else 
    {
        LED_Driver_Channel_Set(LED_Attr[LED_Gearbox_Lamp].chip, LED_Attr[LED_Gearbox_Lamp].channel, 0);
    }
}


Tellib_uint16_t LED_Gearbox_Serious_Lamp_Judge(void) 
{
    Tellib_uint16_t res = 0u;
    return res;
}

void LED_Gearbox_Serious_Lamp_Exec(Tellib_uint16_t led_status) 
{
}


void TurnLeft_Lamp(void) 
{
   if(SYS_OPR_STAT_HALT)
   {
      return;
   }
    if(Get_DIAG_TelltalesCtrlsts() == 3)
   {
       if(LEDContrl._3F80.LeftTurn == 1)
       {
           LED_Driver_Channel_Set(LED_Attr[LED_TurnLeft_Lamp].chip, LED_Attr[LED_TurnLeft_Lamp].channel, LED_Attr[LED_TurnLeft_Lamp].brightness);
       }
       else
       {
           LED_Driver_Channel_Set(LED_Attr[LED_TurnLeft_Lamp].chip, LED_Attr[LED_TurnLeft_Lamp].channel, 0);
       }
   }
   else
   {
         if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) == CAN_SIG_LOST )
        {
            LED_Driver_Channel_Set(LED_Attr[LED_TurnLeft_Lamp].chip, LED_Attr[LED_TurnLeft_Lamp].channel, 0);
        }
        else
        {
            if(Get_CAN_CH0_ID_10FF1021_Sig_LHTurnSignalSts() == 1)
            {
                LED_Driver_Channel_Set(LED_Attr[LED_TurnLeft_Lamp].chip, LED_Attr[LED_TurnLeft_Lamp].channel, LED_Attr[LED_TurnLeft_Lamp].brightness);
            }
            else
            {
                LED_Driver_Channel_Set(LED_Attr[LED_TurnLeft_Lamp].chip, LED_Attr[LED_TurnLeft_Lamp].channel, 0);
            }
        }
   }
   
}

void TurnRight_Lamp(void)
{
   if(SYS_OPR_STAT_HALT)
   {
      return;
   }

   if(Get_DIAG_TelltalesCtrlsts() == 3)
   {
       if(LEDContrl._3F80.RightTurn == 1)
       {
            LED_Driver_Channel_Set(LED_Attr[LED_TurnRight_Lamp].chip, LED_Attr[LED_TurnRight_Lamp].channel, LED_Attr[LED_TurnRight_Lamp].brightness);
       }
       else
       {
            LED_Driver_Channel_Set(LED_Attr[LED_TurnRight_Lamp].chip, LED_Attr[LED_TurnRight_Lamp].channel, 0);
       }
   }
   else
   {
       if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) == CAN_SIG_LOST )
       {
            LED_Driver_Channel_Set(LED_Attr[LED_TurnRight_Lamp].chip, LED_Attr[LED_TurnRight_Lamp].channel, 0);
       }
       else
       {
           if(Get_CAN_CH0_ID_10FF1021_Sig_RHTurnSignalSts() == 1)
           {
               LED_Driver_Channel_Set(LED_Attr[LED_TurnRight_Lamp].chip, LED_Attr[LED_TurnRight_Lamp].channel, LED_Attr[LED_TurnRight_Lamp].brightness);
           }
           else
           {
               LED_Driver_Channel_Set(LED_Attr[LED_TurnRight_Lamp].chip, LED_Attr[LED_TurnRight_Lamp].channel, 0);
           }
       }
   }
}
