#include "PowerManag_User.h"
#include "GPIO.h"
#include "Mileage.h"
#include "Mileage_user.h"
#include "Buzzer_Play_User.h"
#include "Sound_Alarm_User.h"
#include "Key.h"
#include "Key_user.h"
#include "api_tft.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "RTE_PWM.h"
#include "Task.h"
#include "Hysteresis.h"
#include "Hysteresis_user.h"
#include "Watchdog.h"
#include "LCD_BUS.h"
#include "LCD_MonoTFT.h"
#include "LCBI_DMA.h"
#include "RTE_CAN.h"
#include "Rscan.h"
#include "LED_Driver.h"
#include "Simulated_IIC_Master.h"
#include "Non_volatile_Memorys.h"
#include "EEPROM_24Cxx_Remap.h"
#include "Line_In_user.h"
#include "Telltales_user.h"
// #include "imag_Map.h"
#include "PIC_Comm.h"
// #include "Imag_TFT.h"
#include "RTC.h"
#include "Sys_Tick.h"
#include "CAN_1939.h"
#include "CAN_1939_user.h"

#include "NM_Config.h"
#include "CAN_CFG.h"
#include "NMUserControl.h"
#include "Gauges.h"

#include "Analog_Signals.h"

#include "LED_Driver_Interface.h"
#include "GUI.h"


extern void FDL_Init(void);
uint16_t u16PoMaSleepDelay = 0;
void     PoMa_Sleep_Delay_Time_Clean(void)
{
    u16PoMaSleepDelay   = 0UL;
    PowerIgnOffTimeLine = 0;
}
void PoMa_Sleep_Delay_Time_Handle(void)
{
    if ( u16PoMaSleepDelay < 6000 )
    {
        u16PoMaSleepDelay++;
    }
}

void PoMa_KL30_Init(void)
{
    Sys_Tick_Timer_Call_Back_Reg(SYS_TICK_50us_CB, Sys_Process_ISR);
    IIC_Init( );
    NVM_Init( );
    //RTI_Init( );
    FDL_Init( );
    OsekNMInit( );
    SendMsg30Init( );
    COM_CAN_Init( );
    __EI( );
    Sys_Tick_Timer_Start( );
    RTC_Pre_Init( );    // 首次上电
    Draw_ClearVramCalFlag( );
    WDT_Clear( );
    PWM_Init( );

#ifndef INNER_PIC_ON
    BSP_QSPI_Init( );
// Gui_LoadFontInfo();
#endif
    LCD_BUS_Init( );
    LCD_Panel_Start_Up( );
    LED_Driver_Init_Example( );
    Mileage_KL30_Init_Example( );
    Maint_Init( );
    Key_KL30_Init_EXample( );
    Hys_KL30_Init_EXample( );
    Buzzer_Play_Init_Example( );
    Pop_Alarm_Init_Example( );
    Sound_Alarm_Init_Example( );
    CAN_J1939_Init_Example( );
    Gauges_KL30_Init( );
    LINE_IN_Init( );
    Telltales_Init( );
    Vehicle_Speed_Init( );
    Engine_Speed_Init( );
    Coolant_Init( );
    Menu_User_Init(POMA_RESET_KL30);
    GUI_Light_Init( );
    GUI_Sound_Init( );
    Data_AvgFuel_KL30_Init( );
    Can_AvgFuel_KL30_WakeUp_Init( );
    Data_AvgFuel_A_KL30_Init( );
    SetFuelInit( );
    Data_Fuel_Display_Init( );
    ExecFuel_Init( );
    COM_CAN_Init( );
    Flash_Init( );
    Data_30KL_Init( );
    Data_AverageSpeed_KL30_Init( );
    Data_TPMS_30_15KL_Processing( );
    Display_Ctrl_Init( );
    Can_18FFB078_Receive_Init();
}
void PoMa_IG_OFF_Init(void)
{
    NM_SetIgnState(0); /* 网络管理IGN OFF */
    Mileage_IG_OFF_Init( );
    Gauges_KL15OFF_Init( );
    Popups_Alarm_Trigger_OFF_Init( );
    Sound_Alarm_Trigger_OFF_Init( );
    Display_Ctrl_OFF_Init( );
    SetPowerSt(0);
    Line_In_KL15_OFF_Init( );
    //RTI_Timing_Service( );
}
void PoMa_IG_ON_Init(void)
{
    Osek_APP_TX_Init( );
    NM_SetIgnState(1); /* 网络管理IGN ON*/
    Mileage_IG_ON_Init( );
    Gauges_KL15ON_Init( );
    Popups_Alarm_Trigger_ON_Init( );
    Sound_Alarm_Trigger_ON_Init( );
    Display_Ctrl_Init( );
    Vehicle_Speed_Init( );
    Engine_Speed_Init( );
    Line_In_KL15_ON_Init( );
    Telltales_KL15_Init( );
    Data_TPMS_30_15KL_Processing( );
    Flash_Init( );
    Data_15KL_Init( );
    Data_Fuel_Display_Init( );
    Hys_KL30_Init_EXample( );
}
void PoMa_Wakeup_Init(void)
{
    Sys_Tick_Timer_Call_Back_Reg(SYS_TICK_50us_CB, Sys_Process_ISR);
    FDL_Init( );
    OsekNMInit( );
    SendMsg30Init( );
    COM_CAN_Init( );
    Mileage_Wakeup_Init_Example( );
    Gauges_Wake_Up_Init( );
    __EI( );
    Sys_Tick_Timer_Start( );
    Popups_Alarm_Trigger_WakeUp_Init( );
    Draw_ClearVramCalFlag( );
    WDT_Clear( );
    PWM_Init( );
    FuelWake( );
    GUI_nightLightWeakup_Init();
#ifndef INNER_PIC_ON
    BSP_QSPI_Init( );
// Gui_LoadFontInfo();
#endif
    LCD_BUS_Init( );
    LCD_Panel_Start_Up( );
    Maint_Init( );
    LED_Driver_Init_Example( );
    Key_KL30_Init_EXample( );
    PoMa_Sleep_Delay_Time_Clean( );
    LINE_IN_Init( );
    Telltales_Init( );
    Menu_User_Init(POMA_RESET_WAKEUP);
    Hys_Wakeup_Init_EXample( );
    Buzzer_Play_Init_Example( );
    Pop_Alarm_Init_Example( );
    Sound_Alarm_Init_Example( );
    CAN_J1939_Init_Example( );
    Data_TPMS_30_15KL_Processing( );
    Line_In_KL15_ON_Init( );
    COM_CAN_Init( );
    Display_Ctrl_Init( );
    Buzzer_Volume_Set(MenuData.Sound );
    Can_18FFB078_Receive_Init();
}
void PoMa_Sleep_Init(void)
{
    LCD_Panel_Shut_Down( );
    LED_Driver_Shutdown_Pin_Set(0);
    Simulated_IIC_2_Stop( );
    WDT_Clear( );
    AbortAllCanTx( );
    RSCAN0_Sleep_Init( );
    Gauges_Sleep_Init( );
    LED_Driver_Init_Sleep( );
    FuelSleep( );
}
void PoMa_Sleep_Loop(void)
{
    WDT_Clear( );
    Sys_Enter_Sleep_Mode( ); /*休眠函数*/
}
PoMa_uint16_t PoMa_Read_KL30_Voltage_Force(void)
{
    PoMa_uint16_t u16Voltage;
    u16Voltage = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}
PoMa_uint16_t PoMa_Read_KL15_Voltage_Force(void)
{
    PoMa_uint16_t u16Voltage;
    u16Voltage = ADC_Conv_Single_Channel(ADC_CH_KL15_VOLTAGE);
    return u16Voltage;
}
PoMa_uint16_t PoMa_Read_KL30_Voltage(void)
{
    PoMa_uint16_t u16Voltage;
    u16Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}
PoMa_uint16_t PoMa_Read_KL15_Voltage(void)
{
    PoMa_uint16_t u16Voltage;
    u16Voltage = ADC_Read_Signal(ADC_CH_KL15_VOLTAGE);
    return u16Voltage;
}
PoMa_uint16_t PoMa_Read_KL15_Line(void)
{
    PoMa_uint16_t u8PoMaStatus = 0U;
    if ( GPIO_IN_PORT0_PIN0 )
    {
        u8PoMaStatus = 1U;
    }
    return u8PoMaStatus;
}

PoMa_uint16_t PoMa_Check_Sleep(void)
{

    PoMa_uint16_t u8PoMaStatus = 1;

    if ( Pop_Alarm_Get_Current( ) < POP_ALARM_MAX )
    {
        u16PoMaSleepDelay = 0;
        u8PoMaStatus      = 0;
    }
    if ( Sound_Alarm_Current_Read( ) < SOUND_ALARM_MAX )
    {
        u16PoMaSleepDelay = 0;
        u8PoMaStatus      = 0;
    }

    if ( Get_OFF_FUEL_Dely_Time( ) <= 300 )
    {
        u8PoMaStatus      = 0;
        u16PoMaSleepDelay = 0;
    }

    if ( DMA_GetTransferStatus( ) != notOnGoing )
    {
        u8PoMaStatus      = 0;
        u16PoMaSleepDelay = 0;
    }

    if ( GetNmBusSleepSt( ) != 1 )
    {
        u8PoMaStatus      = 0;
        u16PoMaSleepDelay = 0;
    }
    if ( Common_GetIgnOffTime( ) <= 20000 )
    {
        u8PoMaStatus      = 0;
        u16PoMaSleepDelay = 0;
    }
    if ( u16PoMaSleepDelay < 50 )
    {
        u8PoMaStatus = 0;
    }

    return u8PoMaStatus;
}
PoMa_uint16_t PoMa_Check_Wakeup(void)
{
    PoMa_uint16_t u8PoMaStatus = 0;
    return u8PoMaStatus;
}
#define Hard_Delay_1MS_16843 24000UL
void PoMa_Delay(PoMa_uint16_t u16DelayMs)
{

    uint32_t u32DelayCount = 0;
    uint32_t i             = 0;
    WDT_Clear( );
    for ( u32DelayCount = 0; u32DelayCount < u16DelayMs; u32DelayCount++ )
    {
        for ( i = 0; i < Hard_Delay_1MS_16843; i++ )
        {
        }
    }
    WDT_Clear( );
}
void PoMa_Voltage_High_Init(void)
{
    uint8_t i = 0;
    uint8_t j = 0;
    uint8_t k = 0;
    for ( k = 0; k < LED_Max; k++ )
    {
        Telltales_DiagCtrl(k, 0);
    }
    LED_Driver_Channel_Set(0, LED_TurnLeft_Lamp, 0);
    LED_Driver_Channel_Set(0, LED_TurnRight_Lamp, 0);

    for ( j = 0; j < SOUND_ALARM_MAX; j++ )
    {
        Sound_Alarm_Delete_Normal(j);
    }
    for ( j = 0; j < POP_ALARM_MAX; j++ )
    {
        Pop_Alarm_Delete_Normal(j, POP_DELAY_NULL);
    }
    PWM_Channel_Set_Duty(1, 0);    // 表盘
    PWM_Channel_Set_Duty(3, 0);    // 指针
    PWM_Channel_Set_Duty(5, 0);    // 3.5
}
void PoMa_Voltage_Low_Init(void)
{
    uint8_t i = 0;
    uint8_t j = 0;
    uint8_t k = 0;
    for ( k = 0; k < LED_Max; k++ )
    {
        Telltales_DiagCtrl(k, 0);
    }
    LED_Driver_Channel_Set(0, LED_TurnLeft_Lamp, 0);
    LED_Driver_Channel_Set(0, LED_TurnRight_Lamp, 0);

    for ( j = 0; j < SOUND_ALARM_MAX; j++ )
    {
        Sound_Alarm_Delete_Normal(j);
    }

    for ( j = 0; j < POP_ALARM_MAX; j++ )
    {
        Pop_Alarm_Delete_Normal(j, POP_DELAY_NULL);
    }
    PWM_Channel_Set_Duty(1, 0);    // 表盘
    PWM_Channel_Set_Duty(3, 0);    // 指针
    PWM_Channel_Set_Duty(5, 0);    // 3.5
}
void PoMa_Voltage_Normal_Init(void)
{
    uint8_t i = 0;
    for ( i = 0; i < LED_Max; i++ )
    {
        Telltales_DiagRelease(i);
    }
}
const PoMa_Voltage_Attribute_st_t stPoMaVoltageAttribute [ POMA_VOLTAGE_NUM ] = {
    {0UL, 7500UL, 60000UL, PoMa_Voltage_Low_Init, 0},
    {8000UL, 17500UL, 0UL, PoMa_Voltage_Normal_Init, 0},
    {18000UL, 0XFFFFUL, 60000UL, PoMa_Voltage_High_Init, 0},
};
const PoMa_Init_st_t stPoMaInit = {
    PoMa_KL30_Init,
    PoMa_IG_OFF_Init,
    PoMa_IG_ON_Init,
    PoMa_Wakeup_Init,
    PoMa_Sleep_Init,
    PoMa_Sleep_Loop,
    POMA_IG_LINE,
    6500,
    6000,
    120,
    100,
    PoMa_Read_KL15_Line,
    PoMa_Read_KL15_Voltage,
    PoMa_Read_KL30_Voltage,
    PoMa_Read_KL15_Voltage_Force,
    PoMa_Read_KL30_Voltage_Force,
    PoMa_Check_Sleep,
    PoMa_Check_Wakeup,
    PoMa_Delay,
    200U,
    POMA_VOLTAGE_NUM,
};
/************************************************/
#pragma ghs section bss = ".myNonInitArea"
/*放在休眠唤醒后不丢失的区域*/
#pragma alignvar(8)
PoMa_uint8_t        u8PoMaRamData [ POMA_RAM_DATA_LEN ];
#pragma ghs section bss = default
void                PoMa_Init_Example(PoMa_uint8_t u8ResetSource)
{
    PoMa_Init(u8ResetSource, u8PoMaRamData, &stPoMaInit, &stPoMaVoltageAttribute);
}
