#include "Buzzer_Play_User.h"
#include "Sound_Alarm_User.h"
#include "TimerB.h"
#include "RTE_PWM.h"
#include "RTE_GPIO.h"

Buzzer_uint16_t BuzzerVolume    = 0U;
Buzzer_uint16_t BuzzerPosStatus = 0U;

void Buzzer_Volume_Set(Buzzer_uint8_t u8BzVo)
{
   
    if ( BuzzerVolume != u8BzVo )
    {
        BuzzerVolume = u8BzVo;
    }
}
Buzzer_Operate_Type_en_t Buzzer_Positive_Handle_Operate(Buzzer_uint8_t u8BuzzerOnOff)
{
    Buzzer_Operate_Type_en_t enBuzzerOperateResult = BUZZER_OPERATE_SUCCESS;
    BuzzerPosStatus                                = u8BuzzerOnOff;
    if (BuzzerPosStatus)
    {
    	switch (BuzzerVolume)
    	{
    	// default:
    	case 3:
    		Buzzer_CT_X1_OUT = 1U;
    		Buzzer_CT_X2_OUT = 0U;
    		Buzzer_CT_X3_OUT = 0U;
    		break;
    	case 2:
    		Buzzer_CT_X1_OUT = 0U;
    		Buzzer_CT_X2_OUT = 1U;
    		Buzzer_CT_X3_OUT = 0U;
    		break;
    	case 1:
    		Buzzer_CT_X1_OUT = 0U;
    		Buzzer_CT_X2_OUT = 0U;
    		Buzzer_CT_X3_OUT = 1U;
    		break;
        default://非音量等级时切换为默认等级
            Buzzer_CT_X1_OUT = 1U;
    		Buzzer_CT_X2_OUT = 0U;
    		Buzzer_CT_X3_OUT = 0U;
            break;
    	}
    }
    else
    {
    	Buzzer_CT_X1_OUT = 0U;
    	Buzzer_CT_X2_OUT = 0U;
    	Buzzer_CT_X3_OUT = 0U;
    }

    return enBuzzerOperateResult;
}
Buzzer_Operate_Type_en_t Buzzer_Negative_Set_Operate(Buzzer_uint16_t u16BuzzerFre, Buzzer_uint16_t u16BuzzerDuty)
{
    Buzzer_Operate_Type_en_t enBuzzerOperateResult = BUZZER_OPERATE_SUCCESS;

    
     TimerB_PWM_Channel_Fre_Set(29, u16BuzzerFre, u16BuzzerDuty);
    return enBuzzerOperateResult;
}
void Buzzer_Play_Init_Example(void)
{
    Buzzer_Init_st_t stBuzzerInit;
    stBuzzerInit.pfnBuzzerNegativeSet    = Buzzer_Negative_Set_Operate;
    stBuzzerInit.pfnBuzzerPositiveHandle = Buzzer_Positive_Handle_Operate;
    Buzzer_Play_Init(&stBuzzerInit);

    PWM_Channel_Init(1, 0, 0, 0, 0);//表盘
    PWM_Channel_Set_Freq(1, 20000);//20khz

    PWM_Channel_Init(3, 0, 0, 0, 0);//指针
    PWM_Channel_Set_Freq(3, 20000);

    PWM_Channel_Init(5, 0, 0, 0, 0);//3.5
    PWM_Channel_Set_Freq(5, 20000);


    PWM_Channel_Init(29, 0, 0, 0, 0);//蜂鸣器
    PWM_Channel_Set_Freq(29, 1000);


    //PWM_Channel_Set_Duty(1, 1000);//表盘
    //PWM_Channel_Set_Duty(3, 1000);//指针
    //PWM_Channel_Set_Duty(5, 1000);//3.5



}
