#include "UDS_22Service_Main.h"
#include "UDS_Common.h"
/*EcuPartNumber（电控单元零件号）*/
const uint8_t DID_22_F187[12]   = {'5','8','0','3','3','1','2','6','7','1',0x20,0x20};
/*SystemSupplierID（系统供应商标识号）*/
const uint8_t DID_22_F18A[10]    = {'1','7','3','8',0x20,0x20,0x20,0x20,0x20,0x20};
/*Supplier ECU Serial Number（供应商电控单元序列号） */
const uint8_t DID_22_F190[17]   = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
/*ECUHardwareNumberDataIdentifier(硬件号)*/
const uint8_t DID_22_F192[16]   = {'5','8','0','3','3','1','0','8','1','8',0x20,0x20,0x20,0x20,0x20,0x20};
/*ECUHardwareVersionNumberDataIdentifier（硬件版本号）*/
const uint8_t DID_22_F193[8]   = {'V','1','.','1',0x20,0x20,0x20,0x20};
/*ECUHardwareVersionNumberDataIdentifier（软件号）*/
const uint8_t DID_22_F194[16]   = {'5','8','0','3','3','1','0','8','1','7',0x20,0x20,0x20,0x20,0x20,0x20};
/*ECUSoftwareVersionNumberDataIdentifier（软件版本号）*/
const uint8_t DID_22_F195[8]   = {'V','1','.','7',0x20,0x20,0x20,0x20};
/*SystemNameDataIdentifier（ECU名称）*/
const uint8_t DID_22_F197[10]   = {'I','C','-','N','S','2','0','8','-','2'};
/*EOLProgrammingDate*/
const uint8_t DID_22_F1B7[3]   = {0x23,0x07,0x18};
/*EOLProgrammingToolVersion*/
const uint8_t DID_22_F1B8[2]   = {0x01,0x00};
/*PlantTraceabilityInformations*/
const uint8_t DID_22_F1C5[42]   = { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
                                  };
/*TeleservicesTraceabilityInformations*/
const uint8_t DID_22_F1C6[51]   = { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,};
/*BootloaderSoftwareVersionNumberDataIdentifier（Bootloader软件版本号*/
const uint8_t DID_22_F180[8]   = {'V','1','.','0',0x20,0x20,0x20,0x20};
/*EOL DataIdentifier（下线配置）--见4.3.DIDs_Config页*/
const uint8_t DID_22_F010[8]   = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
/*ReadFingerprint DataIdentifier（读指纹）*/
const uint8_t DID_22_F15B[30]   = {0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
                                   0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/*CarCfg3（ABS9.0诊断配置）*/
const uint8_t DID_22_1E01[16]   = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};






/**
  *22服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_22_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC11();                                            /*22服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC7F();                                            /*22服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC33();                                            /*22服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_MinLengthCheck();                             /*22服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC31();                                            /*22服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC13_TotalLengthCheck();                           /*22服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_22Service_NRC22();                                            /*22服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_22Service_DID();                                                    /*22服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}


/**
  *22服务子功能
  */
void UDS_22Service_DID(void)
{

    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*22服务DID判断*/
    {
        case 0xF187:
            UDS_22Service_DID_F187(  );
        break;
        case 0xF18A:
            UDS_22Service_DID_F18A(  );
        break;
        case 0xF18B:
            UDS_22Service_DID_F18B(  );
        break;
        case 0xF18C:
            UDS_22Service_DID_F18C(  );
        break;
        case 0xF190:
            UDS_22Service_DID_F190(  );
        break;
        case 0xF192:
            UDS_22Service_DID_F192(  );
        break;
        case 0xF193:
            UDS_22Service_DID_F193(  );
        break;
        case 0xF194:
            UDS_22Service_DID_F194(  );
        break;
        case 0xF195:
            UDS_22Service_DID_F195(  );
        break;
        case 0xF197:
            UDS_22Service_DID_F197(  );
        break;
        case 0xF1B0:
            UDS_22Service_DID_F1B0(  );
        break;
        case 0xF1B1:
            UDS_22Service_DID_F1B1(  );
        break;
        case 0xF1B7:
            UDS_22Service_DID_F1B7(  );
        break;
        case 0xF1B8:
            UDS_22Service_DID_F1B8(  );
        break;
        case 0xF1BF:
            UDS_22Service_DID_F1BF(  );
        break;
        case 0xF1C5:
            UDS_22Service_DID_F1C5(  );
        break;
        case 0xF1C6:
            UDS_22Service_DID_F1C6(  );
        break;
        case 0xF186:
            UDS_22Service_DID_F186(  );
        break;
        case 0xF180:
            UDS_22Service_DID_F180(  );
        break;
        case 0xF010:
            UDS_22Service_DID_F010(  );
        break;
        case 0xF15B:
            UDS_22Service_DID_F15B(  );
        break;
        case 0xCF00:
            UDS_22Service_DID_CF00(  );
        break;
        case 0xCF01:
            UDS_22Service_DID_CF01(  );
        break;
        case 0xCF02:
            UDS_22Service_DID_CF02(  );
        break;
        case 0xCF03:
            UDS_22Service_DID_CF03(  );
        break;
        case 0xCF04:
            UDS_22Service_DID_CF04(  );
        break;
        case 0x1E00:
            UDS_22Service_DID_1E00(  );
        break;
        case 0x1E01:
            UDS_22Service_DID_1E01(  );
        break;
    default:
        break;
    }
}

/**
  *22服务DIDF187
  *EcuPartNumber（电控单元零件号）
  */
void UDS_22Service_DID_F187(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F187, sizeof(DID_22_F187));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F187), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18A
  *SystemSupplierID（系统供应商标识号）
  */
void UDS_22Service_DID_F18A(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F18A, sizeof(DID_22_F18A));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F18A), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18B
  *ECU Manufacture Date（电控单元制造日期）
  */
void UDS_22Service_DID_F18B(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F18B, sizeof(Ser2EToDFlashInfo.DID_F18B));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F18B), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF18C
  *ECU Manufacture Date（电控单元制造日期）
  */
void UDS_22Service_DID_F18C(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F18C, sizeof(Ser2EToDFlashInfo.DID_F18C));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F18C), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF190
  *VIN（车辆识别代码）
  */
void UDS_22Service_DID_F190(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F190, sizeof(Ser2EToDFlashInfo.DID_F190));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F190), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF192
  *ECUHardwareNumberDataIdentifier（硬件号）
  */
void UDS_22Service_DID_F192(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F192, sizeof(DID_22_F192));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F192), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF193
  *ECUHardwareVersionNumberDataIdentifier（硬件版本号
  */
void UDS_22Service_DID_F193(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F193, sizeof(DID_22_F193));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F193), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF194
  *ECUHardwareVersionNumberDataIdentifier（软件号）
  */
void UDS_22Service_DID_F194(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F194, sizeof(DID_22_F194));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F194), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF195
  *ECUSoftwareVersionNumberDataIdentifier（软件版本号）
  */
void UDS_22Service_DID_F195(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F195, sizeof(DID_22_F195));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F195), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF197
  *SystemNameDataIdentifier（ECU名称）
  */
void UDS_22Service_DID_F197(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F197, sizeof(DID_22_F197));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F197), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1B0
  *VanOrGan
  */
void UDS_22Service_DID_F1B0(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1B0, sizeof(Ser2EToDFlashInfo.DID_F1B0));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1B0), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1B1
  *CustomerCode
  */
void UDS_22Service_DID_F1B1(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1B1, sizeof(Ser2EToDFlashInfo.DID_F1B1));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1B1), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1B7
  *EOLProgrammingDate
  */
void UDS_22Service_DID_F1B7(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1B7, sizeof(Ser2EToDFlashInfo.DID_F1B7));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1B7), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1B8
  *EOLTesterCode
  */
void UDS_22Service_DID_F1B8(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1B8, sizeof(Ser2EToDFlashInfo.DID_F1B8));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1B8), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF1C5
  *PlantTraceabilityInformations
  */
void UDS_22Service_DID_F1BF(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1BF, sizeof(Ser2EToDFlashInfo.DID_F1BF));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1BF), DiagMSG.msgData.Data);
}
/**
  *22服务DIDF1C5
  *PlantTraceabilityInformations
  */
void UDS_22Service_DID_F1C5(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1C5, sizeof(Ser2EToDFlashInfo.DID_F1C5));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1C5), DiagMSG.msgData.Data);
}
/**
  *22服务DIDF1C6
  *TeleservicesTraceabilityInformations
  */
void UDS_22Service_DID_F1C6(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_F1C6, sizeof(Ser2EToDFlashInfo.DID_F1C6));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_F1C6), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF186
  *activeDiagnosticSessionDataIdentifier
（当前诊断会话模式标识符）
  */
void UDS_22Service_DID_F186(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = getSessionType();
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 1, DiagMSG.msgData.Data);
}

/**
  *22服务DIDF180
  *BootloaderSoftwareVersionNumberDataIdentifier
（Bootloader软件版本号））
  */
void UDS_22Service_DID_F180(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, DID_22_F180, sizeof(DID_22_F180));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_22_F180), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF010
  *EOL DataIdentifier
（下线配置）
--见4.3.DIDs_Config页
  */
void UDS_22Service_DID_F010(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, EOLToDFlashInfo.DID_F010, sizeof(EOLToDFlashInfo.DID_F010));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(EOLToDFlashInfo.DID_F010), DiagMSG.msgData.Data);
}

/**
  *22服务DIDF15B
  *ReadFingerprint DataIdentifier
（读指纹）
  */
void UDS_22Service_DID_F15B(void)
{
    //uint8_t MsgLen;
    //if((BootToDFlashInfo.DID_F15B[0] == 0xFF) && (BootToDFlashInfo.DID_F15B[10] == 0xFF) && (BootToDFlashInfo.DID_F15B[20] == 0xFF))
    //{
    //  MsgLen = 0;
    //}
    //else if((BootToDFlashInfo.DID_F15B[10] == 0xFF) && (BootToDFlashInfo.DID_F15B[20] == 0xFF))
    //{
    //  memcpy(DiagMSG.msgData.DidDetail.Data,(uint8_t *)&BootToDFlashInfo.DID_F15B[0],10);
    //  MsgLen = 10;
    //}
    //else if((BootToDFlashInfo.DID_F15B[20] == 0xFF) && (BootToDFlashInfo.DID_F15B[21] == 0xFF))
    //{
    //  memcpy(DiagMSG.msgData.DidDetail.Data,(uint8_t *)&BootToDFlashInfo.DID_F15B[0],20);
    //  MsgLen = 20;
    //}
    //else
    //{
    //  memcpy(DiagMSG.msgData.DidDetail.Data,(uint8_t *)&BootToDFlashInfo.DID_F15B[0],30);
    //  MsgLen = 30;
    //}
    memcpy(DiagMSG.msgData.DidDetail.Data, BootToDFlashInfo.DID_F15B, 10);
    DiagMSG.msgData.DidDetail.Data[0] = 0;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 10, DiagMSG.msgData.Data);
}

/**
  *22服务DIDCF00
  *Battery_Voltage 
（电压）
  */
void UDS_22Service_DID_CF00(void)
{
    DiagMSG.msgData.DidDetail.Data[1] = (getKL30Voltage() / 50) >> 8;
    DiagMSG.msgData.DidDetail.Data[0] = getKL30Voltage() / 50;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2, DiagMSG.msgData.Data);
}

/**
  *22服务DIDCF01
  *Vehicle_Speed
（车速）
  */
void UDS_22Service_DID_CF01(void)
{
    DiagMSG.msgData.DidDetail.Data[1] = (getActVehicleSpeed() * 8 / 5) >> 8;
    DiagMSG.msgData.DidDetail.Data[0] = getActVehicleSpeed() *  8 / 5;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2, DiagMSG.msgData.Data);
}

/**
  *22服务DIDCF02
  *Engine_Speed
（转速）
  */
void UDS_22Service_DID_CF02(void)
{
    DiagMSG.msgData.DidDetail.Data[1] = (Get_DispEngineSpeed() * 8) >> 8;
    DiagMSG.msgData.DidDetail.Data[0] = Get_DispEngineSpeed() * 8;
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 2, DiagMSG.msgData.Data);
}

/**
  *22服务DIDCF03
  *Odometer
（里程）
  */
void UDS_22Service_DID_CF03(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = getTotalOdometer() >> 24;
    DiagMSG.msgData.DidDetail.Data[1] = getTotalOdometer() >> 16;
    DiagMSG.msgData.DidDetail.Data[2] = getTotalOdometer() >> 8;
    DiagMSG.msgData.DidDetail.Data[3] = getTotalOdometer();
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4, DiagMSG.msgData.Data);
}

/**
  *22服务DIDCF04
  *Odometer
（第一次故障里程）
  */
void UDS_22Service_DID_CF04(void)
{
    DiagMSG.msgData.DidDetail.Data[0] = getTotalOdometer() >> 24;
    DiagMSG.msgData.DidDetail.Data[1] = getTotalOdometer() >> 16;
    DiagMSG.msgData.DidDetail.Data[2] = getTotalOdometer() >> 8;
    DiagMSG.msgData.DidDetail.Data[3] = getTotalOdometer();
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 4, DiagMSG.msgData.Data);
}

/**
  *22服务DID1E00
  *Maintenance 
（保养配置）
  */
void UDS_22Service_DID_1E00(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_1E00, sizeof(Ser2EToDFlashInfo.DID_1E00));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + 5, DiagMSG.msgData.Data);
}

/**
  *22服务DID1E01
  *CarCfg3
（ABS9.0诊断配置）
  */
void UDS_22Service_DID_1E01(void)
{
    memcpy(DiagMSG.msgData.DidDetail.Data, Ser2EToDFlashInfo.DID_1E01, sizeof(Ser2EToDFlashInfo.DID_1E01));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(Ser2EToDFlashInfo.DID_1E01), DiagMSG.msgData.Data);
}
