

#ifndef   _EEPROM_24CXX_REMAP_H_
#define   _EEPROM_24CXX_REMAP_H_
#include "r_typedefs.h"
#include "RTE_GPIO.h"
#include "EEPROM_24Cxx.h"


#define   EEPPROM_HIREL_DATA_NUM                  3              
#define   EEPPROM_EXTLIFE_DATA_NUM                0              

#define   EEPPROM_DATA_BUFFER_SIZE                64

#define   EEPPROM_DEVICE_ADDR                     0              

#define   EEPPROM_TOTAL_ROW_NUM                   (EEPROM_TOTAL_PAGE_NUM / 4)


#define   EEPPROM_HIREL_DATA_MAX_LEN              (EEPROM_PAGE_SIZE / 2)


#define   EEPPROM_EXTLIFE_DATA_ROW_OFFSEET        EEPPROM_HIREL_DATA_NUM
#define   EEPPROM_EXTLIFE_DATA_MAX_LEN            (EEPROM_PAGE_SIZE - 4)


#define   EEPPROM_DATA_ROW_OFFSEET                (EEPPROM_HIREL_DATA_NUM + EEPPROM_EXTLIFE_DATA_NUM * 3)
#define   EEPPROM_DATA_TOTAL_PAGE_NUM             ((EEPPROM_TOTAL_ROW_NUM - EEPPROM_DATA_ROW_OFFSEET) * 4)
#define   EEPPROM_DATA_MAX_ADDR                   (EEPROM_PAGE_SIZE * EEPPROM_DATA_TOTAL_PAGE_NUM - 1)



#define   EEPROM_HIREL_DATA_TYPE                  0
#define   EEPROM_EXTLIFE_DATA_TYPE                1
#define   EEPROM_NORMAL_DATA_TYPE                 2

typedef enum
{
  EEPROM_DATA_OK = 0,
  EEPROM_DATA_PARTIAL_LOST,
  EEPROM_DATA_LOST,
  EEPROM_DATA_ADDR_ERR,
  EEPROM_DATA_LEN_ERR,
  EEPROM_DATA_RW_FAIL,
  EEPROM_MEMORY_BUSY,
  EEPROM_MEMORY_ABSENT,
}EEPROMAccessStatusEnum;       


#if (EEPPROM_DATA_BUFFER_SIZE < EEPROM_PAGE_SIZE)
  
  typedef struct
  {                                        
    uint8_t   Type;
    uint8_t   Data[EEPROM_PAGE_SIZE];
    uint16_t  DataLen;
    uint8_t   Row;
    uint8_t   Col;
    uint8_t   Offset;
    uint8_t   Retry;
    uint8_t   WrLen;
    uint16_t  WrCnt;
    uint8_t   Busy;
    EEPROMAccessStatusEnum  Result;
  }EEPROMDataWrCtrlStruct;
  
#else
  
  typedef struct
  {
    uint8_t   Type;
    uint8_t   Data[EEPPROM_DATA_BUFFER_SIZE];
    uint16_t  DataLen;
    uint8_t   Row;
    uint8_t   Col;
    uint8_t   Offset;
    uint8_t   Retry;
    uint8_t   WrLen;
    uint16_t  WrCnt;
    uint8_t   Busy;
    EEPROMAccessStatusEnum  Result;
  }EEPROMDataWrCtrlStruct;

#endif





EEPROMAccessStatusEnum EEPROM_Data_Write(uint8_t Type, uint16_t Addr, uint8_t *pData, uint8_t Len);
EEPROMAccessStatusEnum EEPROM_Get_Data_Write_Status(void);
EEPROMAccessStatusEnum EEPROM_Startup_Data_Read(uint8_t Type, uint16_t Addr, uint8_t *pData, uint8_t Len);
void    EEPROM_Access_Service(void);


EEPROMAccessStatusEnum EEPROM_HiRel_Data_Write(uint16_t Addr, uint8_t *pData, uint8_t Len);
EEPROMAccessStatusEnum EEPROM_Startup_HiRel_Data_Read(uint16_t Addr, uint8_t *pData, uint8_t Len);
EEPROMAccessStatusEnum EEPROM_Startup_HiRel_Page_Read(uint8_t Row, uint8_t Col, uint8_t *pData, uint8_t Len);
uint8_t EEPROM_HiRel_Data_Check(uint8_t *pData, uint8_t Len);
void    EEPROM_HiRel_Data_Write_Service(void);


EEPROMAccessStatusEnum EEPROM_Normal_Data_Write(uint16_t Addr, uint8_t *pData, uint16_t Len);
EEPROMAccessStatusEnum EEPROM_Startup_Normal_Data_Read(uint16_t Addr, uint8_t *pData, uint8_t Len);
void    EEPROM_Normal_Data_Write_Service(void);


void    EEPROM_Copy_Data(uint8_t *pDstData, uint8_t *pSrcData, uint8_t Len);
uint8_t EEPROM_Compare_Data(uint8_t *pDstData, uint8_t *pSrcData, uint8_t Len);




#endif