
#ifndef RSCAN_H__
#define RSCAN_H__


/*-----------------use for RH850_D1M1A_1441 --------------------*/
#include "RSCAN_Table.h"

typedef enum
{
    RSCAN_CHANNEL_BUF_0 = 0U,
    RSCAN_CHANNEL_BUF_1,
    RSCAN_CHANNEL_BUF_2,
    RSCAN_CHANNEL_BUF_3,
    RSCAN_CHANNEL_BUF_4,
    RSCAN_CHANNEL_BUF_5,
    RSCAN_CHANNEL_BUF_6,
    RSCAN_CHANNEL_BUF_7,
    RSCAN_CHANNEL_BUF_8,
    RSCAN_CHANNEL_BUF_9,
    RSCAN_CHANNEL_BUF_10,
    RSCAN_CHANNEL_BUF_11,
    RSCAN_CHANNEL_BUF_12,
    RSCAN_CHANNEL_BUF_13,
   
    RSCAN_CHANNEL_BUF_MAX,

} RSCAN_Channel_Buf_en_t;

typedef enum
{
    RSCAN_BUS_IDLE = 0U,
    RSCAN_BUS_OFF,
    RSCAN_BUS_TX,
    RSCAN_BUS_RX,

} RSCAN_Com_Status_en_t;

typedef enum
{
    RSCAN_Baud_Rate_500K = 0U,
    RSCAN_Baud_Rate_250K,
    RSCAN_Baud_Rate_125K,

} RSCAN_Baud_Rate_en_t;
typedef enum
{
    RSCAN_FRAME_STANDARD = 0U,
    RSCAN_FRAME_EXTEND,

} RSCAN_Frame_en_t;

typedef void (*RSCAN_Confirm)(uint32_t Identifier, uint8_t TransferStatus);
typedef void (*RSCAN_AbortConfirm)(uint32_t Identifier);
typedef void (*RSCAN_Read_Msg)(uint32_t m_id, uint8_t m_dlc, uint8_t m_Msg []);

typedef struct
{
    uint32_t             u32RSCANChEn;       /*通道是否使能*/
    RSCAN_Baud_Rate_en_t enRSCANChBps;       /*通道波特率*/
    uint32_t             u32RSCANChRuleSize; /*通道接收规则条数*/
    RSCAN_Confirm        pfnRSCANConfirmCallBack;
    RSCAN_AbortConfirm   pfnRSCANAbortConfirmCallBack;
    RSCAN_Read_Msg       pfnRSCANReadMsgCallBack;

} RSCAN_Channel_Config_st_t;

typedef struct
{

    RSCAN_Channel_Config_st_t stRSCANCh0;
    RSCAN_Channel_Config_st_t stRSCANCh1;
    RSCAN_Channel_Config_st_t stRSCANCh2;
} RSCAN0_Config_st_t;

typedef enum
{
    RSCAN_SET_COMPLETE = 0,
    RSCAN_SET_ERROR_PARAMETER,
    RSCAN_SET_ERROR_MSGFULL,

} RSCAN_SetState;

typedef union
{
    uint32_t u32CANData [ 2U ];
    uint8_t  u8CANData [ 8U ];
} CAN_Data_un_t;

typedef struct
{
    CAN_Data_un_t unCANData;
    uint32_t      u32CANID;
    uint8_t       u8CANLEN;
    uint8_t       u8CANFrameIDE; /*0: Standard ID . 1: Extended ID */

} CAN_Frame_st_t;

/*
返回值：
0：设置失败
1：设置成功
*/
extern uint8_t RSCAN0_CH_Init(const RSCANFD_Filter_st_t pstRSCANFilter [], RSCAN0_Config_st_t *pstRSCANConfig);

extern void RSCAN0_CH0_Receive(CAN_Frame_st_t *pstCANFrame);
extern void RSCAN0_CH1_Receive(CAN_Frame_st_t *pstCANFrame);
extern void RSCAN0_CH2_Receive(CAN_Frame_st_t *pstCANFrame);


extern RSCAN_SetState RSCAN0_CH0_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame);
extern RSCAN_SetState RSCAN0_CH1_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame);
extern RSCAN_SetState RSCAN0_CH2_Set_FIFO0_Data(CAN_Frame_st_t *pstCANFrame);

extern RSCAN_SetState RSCAN0_CH0_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame);
extern RSCAN_SetState RSCAN0_CH1_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame);
extern RSCAN_SetState RSCAN0_CH2_Set_TXBUF_Data(RSCAN_Channel_Buf_en_t enBufIndex, CAN_Frame_st_t *pstCANFrame);

extern uint8_t RSCAN0_CH0_Get_Rec_Status(void);
extern uint8_t RSCAN0_CH1_Get_Rec_Status(void);
extern uint8_t RSCAN0_CH2_Get_Rec_Status(void);

extern uint8_t RSCAN0_CH0_Get_Busoff_Status(void);
extern uint8_t RSCAN0_CH1_Get_Busoff_Status(void);
extern uint8_t RSCAN0_CH2_Get_Busoff_Status(void);

extern void RSCAN0_CH0_Busoff_Recover(void);
extern void RSCAN0_CH1_Busoff_Recover(void);
extern void RSCAN0_CH2_Busoff_Recover(void);

extern void RSCAN0_CH0_Abort(RSCAN_Channel_Buf_en_t enBufIndex);
extern void RSCAN0_CH1_Abort(RSCAN_Channel_Buf_en_t enBufIndex);
extern void RSCAN0_CH2_Abort(RSCAN_Channel_Buf_en_t enBufIndex);

extern void RSCAN0_CH0_Sleep_Init(void);
extern void RSCAN0_CH1_Sleep_Init(void);
extern void RSCAN0_CH2_Sleep_Init(void);
extern void RSCAN0_Sleep_Init(void);

extern uint8_t RSCAN0_CH0_TX_Error_Count(void);
extern uint8_t RSCAN0_CH1_TX_Error_Count(void);
extern uint8_t RSCAN0_CH2_TX_Error_Count(void);

extern uint8_t RSCAN0_CH0_RX_Error_Count(void);
extern uint8_t RSCAN0_CH1_RX_Error_Count(void);
extern uint8_t RSCAN0_CH2_RX_Error_Count(void);

extern void RSCAN0_CH0_RX_ISR(void);
extern void RSCAN0_CH1_RX_ISR(void);
extern void RSCAN0_CH2_RX_ISR(void);

extern void RSCAN0_CH0_TX_ISR(void);
extern void RSCAN0_CH1_TX_ISR(void);
extern void RSCAN0_CH2_TX_ISR(void);

#endif
