/******************************************************************************/
/* DISCLAIMER                                                                 */
/* This software is supplied by Renesas Electronics Corporation and is only   */
/* intended for use with Renesas products. No other uses are authorized.This  */
/* software is owned by Renesas Electronics Corporation and is protected      */
/* under all applicable laws, including copyright laws.                       */
/* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES          */
/* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING  */
/* BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR */
/* PURPOSE AND NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY           */
/* DISCLAIMED.                                                                */
/* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS     */
/* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE       */
/* LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL      */
/* DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS    */
/* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.           */
/* Renesas reserves the right, without notice, to make changes to this        */
/* software and to discontinue the availability of this software.             */
/* By using this software, you agree to the additional terms and conditions   */
/* found by accessing the following link:                                     */
/* http://www.renesas.com/disclaimer                                          */
/*                                                                            */
/* Device     : RH/RH850G3M/R7F701401                                         */
/* File Name  : dr7f701401.dvf.h                                              */
/* Abstract   : Definition of I/O Register                                    */
/* History    : V1.41  [Device File version]                                  */
/* Options    : -ghs_pragma_io=on -anonymous=off -indent=4 -structure=on -typ */
/*              edef=on -def=on -autosar=on -modulearray=on -const=on -bitfie */
/*              ld=on -bitsfr=on -df=.\dr7f701401.dvf -o=..\output\update\inc */
/*              _ghs\dr7f701401.dvf.h                                         */
/* Date       : 16.10.2017                                                    */
/* Version    : V1.07.00.02  [df2iodef.exe version]                           */
/* This is a typical example.                                                 */
/*                                                                            */
/******************************************************************************/
#ifndef __R7F701401IODEFINE_HEADER__
#define __R7F701401IODEFINE_HEADER__

#ifndef _IODEF_AUTOSAR_TYPEDEF_
    #define _IODEF_AUTOSAR_TYPEDEF_
typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned long  uint32;
#endif

#ifndef _GHS_PRAGMA_IO_TYPEDEF_
    #define _GHS_PRAGMA_IO_TYPEDEF_
    #define PRAGMA(x)    _Pragma(#x)
    #define __READ       volatile const
    #define __WRITE      volatile
    #define __READ_WRITE volatile
    #define __IOREG(reg, addr, attrib, type) \
        PRAGMA(ghs io reg addr)              \
        extern attrib type reg;
    #define __IOREGARRAY(reg, array, addr, attrib, type) \
        PRAGMA(ghs io reg addr)                          \
        extern attrib type reg [ array ];
#endif

typedef struct
{
    uint8 bit00 : 1;
    uint8 bit01 : 1;
    uint8 bit02 : 1;
    uint8 bit03 : 1;
    uint8 bit04 : 1;
    uint8 bit05 : 1;
    uint8 bit06 : 1;
    uint8 bit07 : 1;
} __bitf_T;

#define L  0
#define H  1
#define LL 0
#define LH 1
#define HL 2
#define HH 3

typedef struct
{                      /* Bit Access       */
    uint32 BSZ    : 2; /* BSZ[1:0]         */
    uint32        : 1; /* Reserved Bits    */
    uint32 CPOL   : 1; /* CPOL             */
    uint32 SSLP   : 1; /* SSLP             */
    uint32 CPHAR  : 1; /* CPHAR            */
    uint32 CPHAT  : 1; /* CPHAT            */
    uint32        : 1; /* Reserved Bits    */
    uint32 IO0FV  : 2; /* IO0FV[9:8]       */
    uint32        : 2; /* Reserved Bits    */
    uint32 IO2FV  : 2; /* IO2FV[13:12]     */
    uint32 IO3FV  : 2; /* IO3FV[15:14]     */
    uint32 MOIIO0 : 2; /* MOIIO0[17:16]    */
    uint32 MOIIO1 : 2; /* MOIIO1[19:18]    */
    uint32 MOIIO2 : 2; /* MOIIO2[21:20]    */
    uint32 MOIIO3 : 2; /* MOIIO3[23:22]    */
    uint32 SFDE   : 1; /* SFDE             */
    uint32        : 6; /* Reserved Bits    */
    uint32 MD     : 1; /* MD               */
} __type0;
typedef struct
{                      /* Bit Access       */
    uint32 SCKDL : 3;  /* SCKDL[2:0]       */
    uint32       : 5;  /* Reserved Bits    */
    uint32 SLNDL : 3;  /* SLNDL[10:8]      */
    uint32       : 5;  /* Reserved Bits    */
    uint32 SPNDL : 3;  /* SPNDL[18:16]     */
    uint32       : 13; /* Reserved Bits    */
} __type1;
typedef struct
{                     /* Bit Access       */
    uint32 BRDV : 2;  /* BRDV[1:0]        */
    uint32      : 6;  /* Reserved Bits    */
    uint32 SPBR : 8;  /* SPBR[15:8]       */
    uint32      : 16; /* Reserved Bits    */
} __type2;
typedef struct
{                      /* Bit Access       */
    uint32 SSLE   : 1; /* SSLE             */
    uint32        : 7; /* Reserved Bits    */
    uint32 RBE    : 1; /* RBE              */
    uint32 RCF    : 1; /* RCF              */
    uint32        : 6; /* Reserved Bits    */
    uint32 RBURST : 4; /* RBURST[19:16]    */
    uint32        : 4; /* Reserved Bits    */
    uint32 SSLN   : 1; /* SSLN             */
    uint32        : 4; /* Reserved Bits    */
    uint32 BFM    : 3; /* BFM[31:29]       */
} __type3;
typedef struct
{                    /* Bit Access       */
    uint32 OCMD : 8; /* OCMD[7:0]        */
    uint32      : 8; /* Reserved Bits    */
    uint32 CMD  : 8; /* CMD[23:16]       */
    uint32      : 8; /* Reserved Bits    */
} __type4;
typedef struct
{                    /* Bit Access       */
    uint32 EAC : 3;  /* EAC[2:0]         */
    uint32     : 13; /* Reserved Bits    */
    uint32 EAV : 8;  /* EAV[23:16]       */
    uint32     : 8;  /* Reserved Bits    */
} __type5;
typedef struct
{                    /* Bit Access       */
    uint32 OPD0 : 8; /* OPD0[7:0]        */
    uint32 OPD1 : 8; /* OPD1[15:8]       */
    uint32 OPD2 : 8; /* OPD2[23:16]      */
    uint32 OPD3 : 8; /* OPD3[31:24]      */
} __type6;
typedef struct
{                    /* Bit Access       */
    uint32      : 4; /* Reserved Bits    */
    uint32 OPDE : 4; /* OPDE[7:4]        */
    uint32 ADE  : 4; /* ADE[11:8]        */
    uint32 OCDE : 1; /* OCDE             */
    uint32      : 1; /* Reserved Bits    */
    uint32 CDE  : 1; /* CDE              */
    uint32 DME  : 1; /* DME              */
    uint32 DRDB : 2; /* DRDB[17:16]      */
    uint32      : 2; /* Reserved Bits    */
    uint32 OPDB : 2; /* OPDB[21:20]      */
    uint32      : 2; /* Reserved Bits    */
    uint32 ADB  : 2; /* ADB[25:24]       */
    uint32      : 2; /* Reserved Bits    */
    uint32 OCDB : 2; /* OCDB[29:28]      */
    uint32 CDB  : 2; /* CDB[31:30]       */
} __type7;
typedef struct
{                      /* Bit Access       */
    uint32 SPIE  : 1;  /* SPIE             */
    uint32 SPIWE : 1;  /* SPIWE            */
    uint32 SPIRE : 1;  /* SPIRE            */
    uint32       : 5;  /* Reserved Bits    */
    uint32 SSLKP : 1;  /* SSLKP            */
    uint32       : 23; /* Reserved Bits    */
} __type8;
typedef struct
{                    /* Bit Access       */
    uint32 ADR : 32; /* ADR[31:0]        */
} __type9;
typedef struct
{                     /* Bit Access       */
    uint32 SPIDE : 4; /* SPIDE[3:0]       */
    uint32 OPDE  : 4; /* OPDE[7:4]        */
    uint32 ADE   : 4; /* ADE[11:8]        */
    uint32 OCDE  : 1; /* OCDE             */
    uint32       : 1; /* Reserved Bits    */
    uint32 CDE   : 1; /* CDE              */
    uint32 DME   : 1; /* DME              */
    uint32 SPIDB : 2; /* SPIDB[17:16]     */
    uint32       : 2; /* Reserved Bits    */
    uint32 OPDB  : 2; /* OPDB[21:20]      */
    uint32       : 2; /* Reserved Bits    */
    uint32 ADB   : 2; /* ADB[25:24]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 OCDB  : 2; /* OCDB[29:28]      */
    uint32 CDB   : 2; /* CDB[31:30]       */
} __type10;
typedef struct
{                             /* Bit Access       */
    const uint32 RDATA0 : 32; /* RDATA0[31:0]     */
} __type11;
typedef struct
{                             /* Bit Access       */
    const uint32 RDATA1 : 32; /* RDATA1[31:0]     */
} __type12;
typedef struct
{                       /* Bit Access       */
    uint32 WDATA0 : 32; /* WDATA0[31:0]     */
} __type13;
typedef struct
{                       /* Bit Access       */
    uint32 WDATA1 : 32; /* WDATA1[31:0]     */
} __type14;
typedef struct
{                           /* Bit Access       */
    const uint32 TEND : 1;  /* TEND             */
    const uint32 SSLF : 1;  /* SSLF             */
    uint32            : 30; /* Reserved Bits    */
} __type15;
typedef struct
{                           /* Bit Access       */
    uint32 CKDLYRX    : 3;  /* CKDLYRX[2:0]     */
    uint32            : 13; /* Reserved Bits    */
    uint32 CKDLYOC    : 3;  /* CKDLYOC[18:16]   */
    uint32            : 5;  /* Reserved Bits    */
    uint32 PROT_CKDLY : 8;  /* PROT_CKDLY[31:24] */
} __type16;
typedef struct
{                      /* Bit Access       */
    uint32 DMCYC : 3;  /* DMCYC[2:0]       */
    uint32       : 13; /* Reserved Bits    */
    uint32 DMDB  : 2;  /* DMDB[17:16]      */
    uint32       : 14; /* Reserved Bits    */
} __type17;
typedef struct
{                      /* Bit Access       */
    uint32 DRDRE : 1;  /* DRDRE            */
    uint32       : 3;  /* Reserved Bits    */
    uint32 OPDRE : 1;  /* OPDRE            */
    uint32       : 3;  /* Reserved Bits    */
    uint32 ADDRE : 1;  /* ADDRE            */
    uint32       : 23; /* Reserved Bits    */
} __type18;
typedef struct
{                       /* Bit Access       */
    uint32 SPIDRE : 1;  /* SPIDRE           */
    uint32        : 3;  /* Reserved Bits    */
    uint32 OPDRE  : 1;  /* OPDRE            */
    uint32        : 3;  /* Reserved Bits    */
    uint32 ADDRE  : 1;  /* ADDRE            */
    uint32        : 23; /* Reserved Bits    */
} __type19;
typedef struct
{                            /* Bit Access       */
    uint32 DLYO0       : 1;  /* DLYO0            */
    uint32             : 3;  /* Reserved Bits    */
    uint32 DLYOE0      : 1;  /* DLYOE0           */
    uint32             : 3;  /* Reserved Bits    */
    uint32 DLYO1       : 1;  /* DLYO1            */
    uint32             : 3;  /* Reserved Bits    */
    uint32 DLYOE1      : 1;  /* DLYOE1           */
    uint32             : 11; /* Reserved Bits    */
    uint32 PROT_SPODLY : 8;  /* PROT_SPODLY[31:24] */
} __type20;
typedef struct
{                     /* Bit Access       */
    uint16 P1_0 : 1;  /* P1_0             */
    uint16 P1_1 : 1;  /* P1_1             */
    uint16 P1_2 : 1;  /* P1_2             */
    uint16      : 13; /* Reserved Bits    */
} __type21;
typedef struct
{                        /* Bit Access       */
    uint32 PSR1_0  : 1;  /* PSR1_0           */
    uint32 PSR1_1  : 1;  /* PSR1_1           */
    uint32 PSR1_2  : 1;  /* PSR1_2           */
    uint32         : 13; /* Reserved Bits    */
    uint32 PSR1_16 : 1;  /* PSR1_16          */
    uint32 PSR1_17 : 1;  /* PSR1_17          */
    uint32 PSR1_18 : 1;  /* PSR1_18          */
    uint32         : 13; /* Reserved Bits    */
} __type22;
typedef struct
{                        /* Bit Access       */
    uint16 PNOT1_0 : 1;  /* PNOT1_0          */
    uint16 PNOT1_1 : 1;  /* PNOT1_1          */
    uint16 PNOT1_2 : 1;  /* PNOT1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type23;
typedef struct
{                             /* Bit Access       */
    const uint16 PPR1_0 : 1;  /* PPR1_0           */
    const uint16 PPR1_1 : 1;  /* PPR1_1           */
    const uint16 PPR1_2 : 1;  /* PPR1_2           */
    uint16              : 13; /* Reserved Bits    */
} __type24;
typedef struct
{                      /* Bit Access       */
    uint16 PM1_0 : 1;  /* PM1_0            */
    uint16 PM1_1 : 1;  /* PM1_1            */
    uint16 PM1_2 : 1;  /* PM1_2            */
    uint16       : 13; /* Reserved Bits    */
} __type25;
typedef struct
{                       /* Bit Access       */
    uint16 PMC1_0 : 1;  /* PMC1_0           */
    uint16 PMC1_1 : 1;  /* PMC1_1           */
    uint16 PMC1_2 : 1;  /* PMC1_2           */
    uint16        : 13; /* Reserved Bits    */
} __type26;
typedef struct
{                       /* Bit Access       */
    uint16 PFC1_0 : 1;  /* PFC1_0           */
    uint16 PFC1_1 : 1;  /* PFC1_1           */
    uint16 PFC1_2 : 1;  /* PFC1_2           */
    uint16        : 13; /* Reserved Bits    */
} __type27;
typedef struct
{                        /* Bit Access       */
    uint16 PFCE1_0 : 1;  /* PFCE1_0          */
    uint16 PFCE1_1 : 1;  /* PFCE1_1          */
    uint16 PFCE1_2 : 1;  /* PFCE1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type28;
typedef struct
{                         /* Bit Access       */
    uint32 PMSR1_0  : 1;  /* PMSR1_0          */
    uint32 PMSR1_1  : 1;  /* PMSR1_1          */
    uint32 PMSR1_2  : 1;  /* PMSR1_2          */
    uint32          : 13; /* Reserved Bits    */
    uint32 PMSR1_16 : 1;  /* PMSR1_16         */
    uint32 PMSR1_17 : 1;  /* PMSR1_17         */
    uint32 PMSR1_18 : 1;  /* PMSR1_18         */
    uint32          : 13; /* Reserved Bits    */
} __type29;
typedef struct
{                          /* Bit Access       */
    uint32 PMCSR1_0  : 1;  /* PMCSR1_0         */
    uint32 PMCSR1_1  : 1;  /* PMCSR1_1         */
    uint32 PMCSR1_2  : 1;  /* PMCSR1_2         */
    uint32           : 13; /* Reserved Bits    */
    uint32 PMCSR1_16 : 1;  /* PMCSR1_16        */
    uint32 PMCSR1_17 : 1;  /* PMCSR1_17        */
    uint32 PMCSR1_18 : 1;  /* PMCSR1_18        */
    uint32           : 13; /* Reserved Bits    */
} __type30;
typedef struct
{                        /* Bit Access       */
    uint16 PINV1_0 : 1;  /* PINV1_0          */
    uint16 PINV1_1 : 1;  /* PINV1_1          */
    uint16 PINV1_2 : 1;  /* PINV1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type31;
typedef struct
{                    /* Bit Access       */
    uint16      : 2; /* Reserved Bits    */
    uint16 P3_2 : 1; /* P3_2             */
    uint16 P3_3 : 1; /* P3_3             */
    uint16 P3_4 : 1; /* P3_4             */
    uint16 P3_5 : 1; /* P3_5             */
    uint16 P3_6 : 1; /* P3_6             */
    uint16 P3_7 : 1; /* P3_7             */
    uint16 P3_8 : 1; /* P3_8             */
    uint16 P3_9 : 1; /* P3_9             */
    uint16      : 6; /* Reserved Bits    */
} __type32;
typedef struct
{                       /* Bit Access       */
    uint32         : 2; /* Reserved Bits    */
    uint32 PSR3_2  : 1; /* PSR3_2           */
    uint32 PSR3_3  : 1; /* PSR3_3           */
    uint32 PSR3_4  : 1; /* PSR3_4           */
    uint32 PSR3_5  : 1; /* PSR3_5           */
    uint32 PSR3_6  : 1; /* PSR3_6           */
    uint32 PSR3_7  : 1; /* PSR3_7           */
    uint32 PSR3_8  : 1; /* PSR3_8           */
    uint32 PSR3_9  : 1; /* PSR3_9           */
    uint32         : 8; /* Reserved Bits    */
    uint32 PSR3_18 : 1; /* PSR3_18          */
    uint32 PSR3_19 : 1; /* PSR3_19          */
    uint32 PSR3_20 : 1; /* PSR3_20          */
    uint32 PSR3_21 : 1; /* PSR3_21          */
    uint32 PSR3_22 : 1; /* PSR3_22          */
    uint32 PSR3_23 : 1; /* PSR3_23          */
    uint32 PSR3_24 : 1; /* PSR3_24          */
    uint32 PSR3_25 : 1; /* PSR3_25          */
    uint32         : 6; /* Reserved Bits    */
} __type33;
typedef struct
{                       /* Bit Access       */
    uint16         : 2; /* Reserved Bits    */
    uint16 PNOT3_2 : 1; /* PNOT3_2          */
    uint16 PNOT3_3 : 1; /* PNOT3_3          */
    uint16 PNOT3_4 : 1; /* PNOT3_4          */
    uint16 PNOT3_5 : 1; /* PNOT3_5          */
    uint16 PNOT3_6 : 1; /* PNOT3_6          */
    uint16 PNOT3_7 : 1; /* PNOT3_7          */
    uint16 PNOT3_8 : 1; /* PNOT3_8          */
    uint16 PNOT3_9 : 1; /* PNOT3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type34;
typedef struct
{                            /* Bit Access       */
    uint16              : 2; /* Reserved Bits    */
    const uint16 PPR3_2 : 1; /* PPR3_2           */
    const uint16 PPR3_3 : 1; /* PPR3_3           */
    const uint16 PPR3_4 : 1; /* PPR3_4           */
    const uint16 PPR3_5 : 1; /* PPR3_5           */
    const uint16 PPR3_6 : 1; /* PPR3_6           */
    const uint16 PPR3_7 : 1; /* PPR3_7           */
    const uint16 PPR3_8 : 1; /* PPR3_8           */
    const uint16 PPR3_9 : 1; /* PPR3_9           */
    uint16              : 6; /* Reserved Bits    */
} __type35;
typedef struct
{                     /* Bit Access       */
    uint16       : 2; /* Reserved Bits    */
    uint16 PM3_2 : 1; /* PM3_2            */
    uint16 PM3_3 : 1; /* PM3_3            */
    uint16 PM3_4 : 1; /* PM3_4            */
    uint16 PM3_5 : 1; /* PM3_5            */
    uint16 PM3_6 : 1; /* PM3_6            */
    uint16 PM3_7 : 1; /* PM3_7            */
    uint16 PM3_8 : 1; /* PM3_8            */
    uint16 PM3_9 : 1; /* PM3_9            */
    uint16       : 6; /* Reserved Bits    */
} __type36;
typedef struct
{                      /* Bit Access       */
    uint16        : 2; /* Reserved Bits    */
    uint16 PMC3_2 : 1; /* PMC3_2           */
    uint16 PMC3_3 : 1; /* PMC3_3           */
    uint16 PMC3_4 : 1; /* PMC3_4           */
    uint16 PMC3_5 : 1; /* PMC3_5           */
    uint16 PMC3_6 : 1; /* PMC3_6           */
    uint16 PMC3_7 : 1; /* PMC3_7           */
    uint16 PMC3_8 : 1; /* PMC3_8           */
    uint16 PMC3_9 : 1; /* PMC3_9           */
    uint16        : 6; /* Reserved Bits    */
} __type37;
typedef struct
{                      /* Bit Access       */
    uint16        : 2; /* Reserved Bits    */
    uint16 PFC3_2 : 1; /* PFC3_2           */
    uint16 PFC3_3 : 1; /* PFC3_3           */
    uint16 PFC3_4 : 1; /* PFC3_4           */
    uint16 PFC3_5 : 1; /* PFC3_5           */
    uint16 PFC3_6 : 1; /* PFC3_6           */
    uint16 PFC3_7 : 1; /* PFC3_7           */
    uint16 PFC3_8 : 1; /* PFC3_8           */
    uint16 PFC3_9 : 1; /* PFC3_9           */
    uint16        : 6; /* Reserved Bits    */
} __type38;
typedef struct
{                       /* Bit Access       */
    uint16         : 2; /* Reserved Bits    */
    uint16 PFCE3_2 : 1; /* PFCE3_2          */
    uint16 PFCE3_3 : 1; /* PFCE3_3          */
    uint16 PFCE3_4 : 1; /* PFCE3_4          */
    uint16 PFCE3_5 : 1; /* PFCE3_5          */
    uint16 PFCE3_6 : 1; /* PFCE3_6          */
    uint16 PFCE3_7 : 1; /* PFCE3_7          */
    uint16 PFCE3_8 : 1; /* PFCE3_8          */
    uint16 PFCE3_9 : 1; /* PFCE3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type39;
typedef struct
{                        /* Bit Access       */
    uint32          : 2; /* Reserved Bits    */
    uint32 PMSR3_2  : 1; /* PMSR3_2          */
    uint32 PMSR3_3  : 1; /* PMSR3_3          */
    uint32 PMSR3_4  : 1; /* PMSR3_4          */
    uint32 PMSR3_5  : 1; /* PMSR3_5          */
    uint32 PMSR3_6  : 1; /* PMSR3_6          */
    uint32 PMSR3_7  : 1; /* PMSR3_7          */
    uint32 PMSR3_8  : 1; /* PMSR3_8          */
    uint32 PMSR3_9  : 1; /* PMSR3_9          */
    uint32          : 8; /* Reserved Bits    */
    uint32 PMSR3_18 : 1; /* PMSR3_18         */
    uint32 PMSR3_19 : 1; /* PMSR3_19         */
    uint32 PMSR3_20 : 1; /* PMSR3_20         */
    uint32 PMSR3_21 : 1; /* PMSR3_21         */
    uint32 PMSR3_22 : 1; /* PMSR3_22         */
    uint32 PMSR3_23 : 1; /* PMSR3_23         */
    uint32 PMSR3_24 : 1; /* PMSR3_24         */
    uint32 PMSR3_25 : 1; /* PMSR3_25         */
    uint32          : 6; /* Reserved Bits    */
} __type40;
typedef struct
{                         /* Bit Access       */
    uint32           : 2; /* Reserved Bits    */
    uint32 PMCSR3_2  : 1; /* PMCSR3_2         */
    uint32 PMCSR3_3  : 1; /* PMCSR3_3         */
    uint32 PMCSR3_4  : 1; /* PMCSR3_4         */
    uint32 PMCSR3_5  : 1; /* PMCSR3_5         */
    uint32 PMCSR3_6  : 1; /* PMCSR3_6         */
    uint32 PMCSR3_7  : 1; /* PMCSR3_7         */
    uint32 PMCSR3_8  : 1; /* PMCSR3_8         */
    uint32 PMCSR3_9  : 1; /* PMCSR3_9         */
    uint32           : 8; /* Reserved Bits    */
    uint32 PMCSR3_18 : 1; /* PMCSR3_18        */
    uint32 PMCSR3_19 : 1; /* PMCSR3_19        */
    uint32 PMCSR3_20 : 1; /* PMCSR3_20        */
    uint32 PMCSR3_21 : 1; /* PMCSR3_21        */
    uint32 PMCSR3_22 : 1; /* PMCSR3_22        */
    uint32 PMCSR3_23 : 1; /* PMCSR3_23        */
    uint32 PMCSR3_24 : 1; /* PMCSR3_24        */
    uint32 PMCSR3_25 : 1; /* PMCSR3_25        */
    uint32           : 6; /* Reserved Bits    */
} __type41;
typedef struct
{                       /* Bit Access       */
    uint16         : 2; /* Reserved Bits    */
    uint16 PINV3_2 : 1; /* PINV3_2          */
    uint16 PINV3_3 : 1; /* PINV3_3          */
    uint16 PINV3_4 : 1; /* PINV3_4          */
    uint16 PINV3_5 : 1; /* PINV3_5          */
    uint16 PINV3_6 : 1; /* PINV3_6          */
    uint16 PINV3_7 : 1; /* PINV3_7          */
    uint16 PINV3_8 : 1; /* PINV3_8          */
    uint16 PINV3_9 : 1; /* PINV3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type42;
typedef struct
{                      /* Bit Access       */
    uint16 P10_0  : 1; /* P10_0            */
    uint16 P10_1  : 1; /* P10_1            */
    uint16 P10_2  : 1; /* P10_2            */
    uint16 P10_3  : 1; /* P10_3            */
    uint16 P10_4  : 1; /* P10_4            */
    uint16 P10_5  : 1; /* P10_5            */
    uint16 P10_6  : 1; /* P10_6            */
    uint16 P10_7  : 1; /* P10_7            */
    uint16 P10_8  : 1; /* P10_8            */
    uint16 P10_9  : 1; /* P10_9            */
    uint16 P10_10 : 1; /* P10_10           */
    uint16 P10_11 : 1; /* P10_11           */
    uint16        : 4; /* Reserved Bits    */
} __type43;
typedef struct
{                        /* Bit Access       */
    uint32 PSR10_0  : 1; /* PSR10_0          */
    uint32 PSR10_1  : 1; /* PSR10_1          */
    uint32 PSR10_2  : 1; /* PSR10_2          */
    uint32 PSR10_3  : 1; /* PSR10_3          */
    uint32 PSR10_4  : 1; /* PSR10_4          */
    uint32 PSR10_5  : 1; /* PSR10_5          */
    uint32 PSR10_6  : 1; /* PSR10_6          */
    uint32 PSR10_7  : 1; /* PSR10_7          */
    uint32 PSR10_8  : 1; /* PSR10_8          */
    uint32 PSR10_9  : 1; /* PSR10_9          */
    uint32 PSR10_10 : 1; /* PSR10_10         */
    uint32 PSR10_11 : 1; /* PSR10_11         */
    uint32          : 4; /* Reserved Bits    */
    uint32 PSR10_16 : 1; /* PSR10_16         */
    uint32 PSR10_17 : 1; /* PSR10_17         */
    uint32 PSR10_18 : 1; /* PSR10_18         */
    uint32 PSR10_19 : 1; /* PSR10_19         */
    uint32 PSR10_20 : 1; /* PSR10_20         */
    uint32 PSR10_21 : 1; /* PSR10_21         */
    uint32 PSR10_22 : 1; /* PSR10_22         */
    uint32 PSR10_23 : 1; /* PSR10_23         */
    uint32 PSR10_24 : 1; /* PSR10_24         */
    uint32 PSR10_25 : 1; /* PSR10_25         */
    uint32 PSR10_26 : 1; /* PSR10_26         */
    uint32 PSR10_27 : 1; /* PSR10_27         */
    uint32          : 4; /* Reserved Bits    */
} __type44;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT10_0  : 1; /* PNOT10_0         */
    uint16 PNOT10_1  : 1; /* PNOT10_1         */
    uint16 PNOT10_2  : 1; /* PNOT10_2         */
    uint16 PNOT10_3  : 1; /* PNOT10_3         */
    uint16 PNOT10_4  : 1; /* PNOT10_4         */
    uint16 PNOT10_5  : 1; /* PNOT10_5         */
    uint16 PNOT10_6  : 1; /* PNOT10_6         */
    uint16 PNOT10_7  : 1; /* PNOT10_7         */
    uint16 PNOT10_8  : 1; /* PNOT10_8         */
    uint16 PNOT10_9  : 1; /* PNOT10_9         */
    uint16 PNOT10_10 : 1; /* PNOT10_10        */
    uint16 PNOT10_11 : 1; /* PNOT10_11        */
    uint16           : 4; /* Reserved Bits    */
} __type45;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR10_0  : 1; /* PPR10_0          */
    const uint16 PPR10_1  : 1; /* PPR10_1          */
    const uint16 PPR10_2  : 1; /* PPR10_2          */
    const uint16 PPR10_3  : 1; /* PPR10_3          */
    const uint16 PPR10_4  : 1; /* PPR10_4          */
    const uint16 PPR10_5  : 1; /* PPR10_5          */
    const uint16 PPR10_6  : 1; /* PPR10_6          */
    const uint16 PPR10_7  : 1; /* PPR10_7          */
    const uint16 PPR10_8  : 1; /* PPR10_8          */
    const uint16 PPR10_9  : 1; /* PPR10_9          */
    const uint16 PPR10_10 : 1; /* PPR10_10         */
    const uint16 PPR10_11 : 1; /* PPR10_11         */
    uint16                : 4; /* Reserved Bits    */
} __type46;
typedef struct
{                       /* Bit Access       */
    uint16 PM10_0  : 1; /* PM10_0           */
    uint16 PM10_1  : 1; /* PM10_1           */
    uint16 PM10_2  : 1; /* PM10_2           */
    uint16 PM10_3  : 1; /* PM10_3           */
    uint16 PM10_4  : 1; /* PM10_4           */
    uint16 PM10_5  : 1; /* PM10_5           */
    uint16 PM10_6  : 1; /* PM10_6           */
    uint16 PM10_7  : 1; /* PM10_7           */
    uint16 PM10_8  : 1; /* PM10_8           */
    uint16 PM10_9  : 1; /* PM10_9           */
    uint16 PM10_10 : 1; /* PM10_10          */
    uint16 PM10_11 : 1; /* PM10_11          */
    uint16         : 4; /* Reserved Bits    */
} __type47;
typedef struct
{                        /* Bit Access       */
    uint16 PMC10_0  : 1; /* PMC10_0          */
    uint16 PMC10_1  : 1; /* PMC10_1          */
    uint16 PMC10_2  : 1; /* PMC10_2          */
    uint16 PMC10_3  : 1; /* PMC10_3          */
    uint16 PMC10_4  : 1; /* PMC10_4          */
    uint16 PMC10_5  : 1; /* PMC10_5          */
    uint16 PMC10_6  : 1; /* PMC10_6          */
    uint16 PMC10_7  : 1; /* PMC10_7          */
    uint16 PMC10_8  : 1; /* PMC10_8          */
    uint16 PMC10_9  : 1; /* PMC10_9          */
    uint16 PMC10_10 : 1; /* PMC10_10         */
    uint16 PMC10_11 : 1; /* PMC10_11         */
    uint16          : 4; /* Reserved Bits    */
} __type48;
typedef struct
{                        /* Bit Access       */
    uint16 PFC10_0  : 1; /* PFC10_0          */
    uint16 PFC10_1  : 1; /* PFC10_1          */
    uint16 PFC10_2  : 1; /* PFC10_2          */
    uint16 PFC10_3  : 1; /* PFC10_3          */
    uint16 PFC10_4  : 1; /* PFC10_4          */
    uint16 PFC10_5  : 1; /* PFC10_5          */
    uint16 PFC10_6  : 1; /* PFC10_6          */
    uint16 PFC10_7  : 1; /* PFC10_7          */
    uint16 PFC10_8  : 1; /* PFC10_8          */
    uint16 PFC10_9  : 1; /* PFC10_9          */
    uint16 PFC10_10 : 1; /* PFC10_10         */
    uint16 PFC10_11 : 1; /* PFC10_11         */
    uint16          : 4; /* Reserved Bits    */
} __type49;
typedef struct
{                         /* Bit Access       */
    uint16 PFCE10_0  : 1; /* PFCE10_0         */
    uint16 PFCE10_1  : 1; /* PFCE10_1         */
    uint16 PFCE10_2  : 1; /* PFCE10_2         */
    uint16 PFCE10_3  : 1; /* PFCE10_3         */
    uint16 PFCE10_4  : 1; /* PFCE10_4         */
    uint16 PFCE10_5  : 1; /* PFCE10_5         */
    uint16 PFCE10_6  : 1; /* PFCE10_6         */
    uint16 PFCE10_7  : 1; /* PFCE10_7         */
    uint16 PFCE10_8  : 1; /* PFCE10_8         */
    uint16 PFCE10_9  : 1; /* PFCE10_9         */
    uint16 PFCE10_10 : 1; /* PFCE10_10        */
    uint16 PFCE10_11 : 1; /* PFCE10_11        */
    uint16           : 4; /* Reserved Bits    */
} __type50;
typedef struct
{                         /* Bit Access       */
    uint32 PMSR10_0  : 1; /* PMSR10_0         */
    uint32 PMSR10_1  : 1; /* PMSR10_1         */
    uint32 PMSR10_2  : 1; /* PMSR10_2         */
    uint32 PMSR10_3  : 1; /* PMSR10_3         */
    uint32 PMSR10_4  : 1; /* PMSR10_4         */
    uint32 PMSR10_5  : 1; /* PMSR10_5         */
    uint32 PMSR10_6  : 1; /* PMSR10_6         */
    uint32 PMSR10_7  : 1; /* PMSR10_7         */
    uint32 PMSR10_8  : 1; /* PMSR10_8         */
    uint32 PMSR10_9  : 1; /* PMSR10_9         */
    uint32 PMSR10_10 : 1; /* PMSR10_10        */
    uint32 PMSR10_11 : 1; /* PMSR10_11        */
    uint32           : 4; /* Reserved Bits    */
    uint32 PMSR10_16 : 1; /* PMSR10_16        */
    uint32 PMSR10_17 : 1; /* PMSR10_17        */
    uint32 PMSR10_18 : 1; /* PMSR10_18        */
    uint32 PMSR10_19 : 1; /* PMSR10_19        */
    uint32 PMSR10_20 : 1; /* PMSR10_20        */
    uint32 PMSR10_21 : 1; /* PMSR10_21        */
    uint32 PMSR10_22 : 1; /* PMSR10_22        */
    uint32 PMSR10_23 : 1; /* PMSR10_23        */
    uint32 PMSR10_24 : 1; /* PMSR10_24        */
    uint32 PMSR10_25 : 1; /* PMSR10_25        */
    uint32 PMSR10_26 : 1; /* PMSR10_26        */
    uint32 PMSR10_27 : 1; /* PMSR10_27        */
    uint32           : 4; /* Reserved Bits    */
} __type51;
typedef struct
{                          /* Bit Access       */
    uint32 PMCSR10_0  : 1; /* PMCSR10_0        */
    uint32 PMCSR10_1  : 1; /* PMCSR10_1        */
    uint32 PMCSR10_2  : 1; /* PMCSR10_2        */
    uint32 PMCSR10_3  : 1; /* PMCSR10_3        */
    uint32 PMCSR10_4  : 1; /* PMCSR10_4        */
    uint32 PMCSR10_5  : 1; /* PMCSR10_5        */
    uint32 PMCSR10_6  : 1; /* PMCSR10_6        */
    uint32 PMCSR10_7  : 1; /* PMCSR10_7        */
    uint32 PMCSR10_8  : 1; /* PMCSR10_8        */
    uint32 PMCSR10_9  : 1; /* PMCSR10_9        */
    uint32 PMCSR10_10 : 1; /* PMCSR10_10       */
    uint32 PMCSR10_11 : 1; /* PMCSR10_11       */
    uint32            : 4; /* Reserved Bits    */
    uint32 PMCSR10_16 : 1; /* PMCSR10_16       */
    uint32 PMCSR10_17 : 1; /* PMCSR10_17       */
    uint32 PMCSR10_18 : 1; /* PMCSR10_18       */
    uint32 PMCSR10_19 : 1; /* PMCSR10_19       */
    uint32 PMCSR10_20 : 1; /* PMCSR10_20       */
    uint32 PMCSR10_21 : 1; /* PMCSR10_21       */
    uint32 PMCSR10_22 : 1; /* PMCSR10_22       */
    uint32 PMCSR10_23 : 1; /* PMCSR10_23       */
    uint32 PMCSR10_24 : 1; /* PMCSR10_24       */
    uint32 PMCSR10_25 : 1; /* PMCSR10_25       */
    uint32 PMCSR10_26 : 1; /* PMCSR10_26       */
    uint32 PMCSR10_27 : 1; /* PMCSR10_27       */
    uint32            : 4; /* Reserved Bits    */
} __type52;
typedef struct
{                         /* Bit Access       */
    uint16 PINV10_0  : 1; /* PINV10_0         */
    uint16 PINV10_1  : 1; /* PINV10_1         */
    uint16 PINV10_2  : 1; /* PINV10_2         */
    uint16 PINV10_3  : 1; /* PINV10_3         */
    uint16 PINV10_4  : 1; /* PINV10_4         */
    uint16 PINV10_5  : 1; /* PINV10_5         */
    uint16 PINV10_6  : 1; /* PINV10_6         */
    uint16 PINV10_7  : 1; /* PINV10_7         */
    uint16 PINV10_8  : 1; /* PINV10_8         */
    uint16 PINV10_9  : 1; /* PINV10_9         */
    uint16 PINV10_10 : 1; /* PINV10_10        */
    uint16 PINV10_11 : 1; /* PINV10_11        */
    uint16           : 4; /* Reserved Bits    */
} __type53;
typedef struct
{                      /* Bit Access       */
    uint16 P11_0 : 1;  /* P11_0            */
    uint16 P11_1 : 1;  /* P11_1            */
    uint16 P11_2 : 1;  /* P11_2            */
    uint16 P11_3 : 1;  /* P11_3            */
    uint16       : 12; /* Reserved Bits    */
} __type54;
typedef struct
{                         /* Bit Access       */
    uint32 PSR11_0  : 1;  /* PSR11_0          */
    uint32 PSR11_1  : 1;  /* PSR11_1          */
    uint32 PSR11_2  : 1;  /* PSR11_2          */
    uint32 PSR11_3  : 1;  /* PSR11_3          */
    uint32          : 12; /* Reserved Bits    */
    uint32 PSR11_16 : 1;  /* PSR11_16         */
    uint32 PSR11_17 : 1;  /* PSR11_17         */
    uint32 PSR11_18 : 1;  /* PSR11_18         */
    uint32 PSR11_19 : 1;  /* PSR11_19         */
    uint32          : 12; /* Reserved Bits    */
} __type55;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT11_0 : 1;  /* PNOT11_0         */
    uint16 PNOT11_1 : 1;  /* PNOT11_1         */
    uint16 PNOT11_2 : 1;  /* PNOT11_2         */
    uint16 PNOT11_3 : 1;  /* PNOT11_3         */
    uint16          : 12; /* Reserved Bits    */
} __type56;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR11_0 : 1;  /* PPR11_0          */
    const uint16 PPR11_1 : 1;  /* PPR11_1          */
    const uint16 PPR11_2 : 1;  /* PPR11_2          */
    const uint16 PPR11_3 : 1;  /* PPR11_3          */
    uint16               : 12; /* Reserved Bits    */
} __type57;
typedef struct
{                       /* Bit Access       */
    uint16 PM11_0 : 1;  /* PM11_0           */
    uint16 PM11_1 : 1;  /* PM11_1           */
    uint16 PM11_2 : 1;  /* PM11_2           */
    uint16 PM11_3 : 1;  /* PM11_3           */
    uint16        : 12; /* Reserved Bits    */
} __type58;
typedef struct
{                        /* Bit Access       */
    uint16 PMC11_0 : 1;  /* PMC11_0          */
    uint16 PMC11_1 : 1;  /* PMC11_1          */
    uint16 PMC11_2 : 1;  /* PMC11_2          */
    uint16 PMC11_3 : 1;  /* PMC11_3          */
    uint16         : 12; /* Reserved Bits    */
} __type59;
typedef struct
{                        /* Bit Access       */
    uint16 PFC11_0 : 1;  /* PFC11_0          */
    uint16 PFC11_1 : 1;  /* PFC11_1          */
    uint16 PFC11_2 : 1;  /* PFC11_2          */
    uint16 PFC11_3 : 1;  /* PFC11_3          */
    uint16         : 12; /* Reserved Bits    */
} __type60;
typedef struct
{                          /* Bit Access       */
    uint32 PMSR11_0  : 1;  /* PMSR11_0         */
    uint32 PMSR11_1  : 1;  /* PMSR11_1         */
    uint32 PMSR11_2  : 1;  /* PMSR11_2         */
    uint32 PMSR11_3  : 1;  /* PMSR11_3         */
    uint32           : 12; /* Reserved Bits    */
    uint32 PMSR11_16 : 1;  /* PMSR11_16        */
    uint32 PMSR11_17 : 1;  /* PMSR11_17        */
    uint32 PMSR11_18 : 1;  /* PMSR11_18        */
    uint32 PMSR11_19 : 1;  /* PMSR11_19        */
    uint32           : 12; /* Reserved Bits    */
} __type61;
typedef struct
{                           /* Bit Access       */
    uint32 PMCSR11_0  : 1;  /* PMCSR11_0        */
    uint32 PMCSR11_1  : 1;  /* PMCSR11_1        */
    uint32 PMCSR11_2  : 1;  /* PMCSR11_2        */
    uint32 PMCSR11_3  : 1;  /* PMCSR11_3        */
    uint32            : 12; /* Reserved Bits    */
    uint32 PMCSR11_16 : 1;  /* PMCSR11_16       */
    uint32 PMCSR11_17 : 1;  /* PMCSR11_17       */
    uint32 PMCSR11_18 : 1;  /* PMCSR11_18       */
    uint32 PMCSR11_19 : 1;  /* PMCSR11_19       */
    uint32            : 12; /* Reserved Bits    */
} __type62;
typedef struct
{                         /* Bit Access       */
    uint16 PINV11_0 : 1;  /* PINV11_0         */
    uint16 PINV11_1 : 1;  /* PINV11_1         */
    uint16 PINV11_2 : 1;  /* PINV11_2         */
    uint16 PINV11_3 : 1;  /* PINV11_3         */
    uint16          : 12; /* Reserved Bits    */
} __type63;
typedef struct
{                      /* Bit Access       */
    uint16 P16_0  : 1; /* P16_0            */
    uint16 P16_1  : 1; /* P16_1            */
    uint16 P16_2  : 1; /* P16_2            */
    uint16 P16_3  : 1; /* P16_3            */
    uint16 P16_4  : 1; /* P16_4            */
    uint16 P16_5  : 1; /* P16_5            */
    uint16 P16_6  : 1; /* P16_6            */
    uint16 P16_7  : 1; /* P16_7            */
    uint16 P16_8  : 1; /* P16_8            */
    uint16 P16_9  : 1; /* P16_9            */
    uint16 P16_10 : 1; /* P16_10           */
    uint16 P16_11 : 1; /* P16_11           */
    uint16        : 4; /* Reserved Bits    */
} __type64;
typedef struct
{                        /* Bit Access       */
    uint32 PSR16_0  : 1; /* PSR16_0          */
    uint32 PSR16_1  : 1; /* PSR16_1          */
    uint32 PSR16_2  : 1; /* PSR16_2          */
    uint32 PSR16_3  : 1; /* PSR16_3          */
    uint32 PSR16_4  : 1; /* PSR16_4          */
    uint32 PSR16_5  : 1; /* PSR16_5          */
    uint32 PSR16_6  : 1; /* PSR16_6          */
    uint32 PSR16_7  : 1; /* PSR16_7          */
    uint32 PSR16_8  : 1; /* PSR16_8          */
    uint32 PSR16_9  : 1; /* PSR16_9          */
    uint32 PSR16_10 : 1; /* PSR16_10         */
    uint32 PSR16_11 : 1; /* PSR16_11         */
    uint32          : 4; /* Reserved Bits    */
    uint32 PSR16_16 : 1; /* PSR16_16         */
    uint32 PSR16_17 : 1; /* PSR16_17         */
    uint32 PSR16_18 : 1; /* PSR16_18         */
    uint32 PSR16_19 : 1; /* PSR16_19         */
    uint32 PSR16_20 : 1; /* PSR16_20         */
    uint32 PSR16_21 : 1; /* PSR16_21         */
    uint32 PSR16_22 : 1; /* PSR16_22         */
    uint32 PSR16_23 : 1; /* PSR16_23         */
    uint32 PSR16_24 : 1; /* PSR16_24         */
    uint32 PSR16_25 : 1; /* PSR16_25         */
    uint32 PSR16_26 : 1; /* PSR16_26         */
    uint32 PSR16_27 : 1; /* PSR16_27         */
    uint32          : 4; /* Reserved Bits    */
} __type65;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT16_0  : 1; /* PNOT16_0         */
    uint16 PNOT16_1  : 1; /* PNOT16_1         */
    uint16 PNOT16_2  : 1; /* PNOT16_2         */
    uint16 PNOT16_3  : 1; /* PNOT16_3         */
    uint16 PNOT16_4  : 1; /* PNOT16_4         */
    uint16 PNOT16_5  : 1; /* PNOT16_5         */
    uint16 PNOT16_6  : 1; /* PNOT16_6         */
    uint16 PNOT16_7  : 1; /* PNOT16_7         */
    uint16 PNOT16_8  : 1; /* PNOT16_8         */
    uint16 PNOT16_9  : 1; /* PNOT16_9         */
    uint16 PNOT16_10 : 1; /* PNOT16_10        */
    uint16 PNOT16_11 : 1; /* PNOT16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type66;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR16_0  : 1; /* PPR16_0          */
    const uint16 PPR16_1  : 1; /* PPR16_1          */
    const uint16 PPR16_2  : 1; /* PPR16_2          */
    const uint16 PPR16_3  : 1; /* PPR16_3          */
    const uint16 PPR16_4  : 1; /* PPR16_4          */
    const uint16 PPR16_5  : 1; /* PPR16_5          */
    const uint16 PPR16_6  : 1; /* PPR16_6          */
    const uint16 PPR16_7  : 1; /* PPR16_7          */
    const uint16 PPR16_8  : 1; /* PPR16_8          */
    const uint16 PPR16_9  : 1; /* PPR16_9          */
    const uint16 PPR16_10 : 1; /* PPR16_10         */
    const uint16 PPR16_11 : 1; /* PPR16_11         */
    uint16                : 4; /* Reserved Bits    */
} __type67;
typedef struct
{                       /* Bit Access       */
    uint16 PM16_0  : 1; /* PM16_0           */
    uint16 PM16_1  : 1; /* PM16_1           */
    uint16 PM16_2  : 1; /* PM16_2           */
    uint16 PM16_3  : 1; /* PM16_3           */
    uint16 PM16_4  : 1; /* PM16_4           */
    uint16 PM16_5  : 1; /* PM16_5           */
    uint16 PM16_6  : 1; /* PM16_6           */
    uint16 PM16_7  : 1; /* PM16_7           */
    uint16 PM16_8  : 1; /* PM16_8           */
    uint16 PM16_9  : 1; /* PM16_9           */
    uint16 PM16_10 : 1; /* PM16_10          */
    uint16 PM16_11 : 1; /* PM16_11          */
    uint16         : 4; /* Reserved Bits    */
} __type68;
typedef struct
{                        /* Bit Access       */
    uint16 PMC16_0  : 1; /* PMC16_0          */
    uint16 PMC16_1  : 1; /* PMC16_1          */
    uint16 PMC16_2  : 1; /* PMC16_2          */
    uint16 PMC16_3  : 1; /* PMC16_3          */
    uint16 PMC16_4  : 1; /* PMC16_4          */
    uint16 PMC16_5  : 1; /* PMC16_5          */
    uint16 PMC16_6  : 1; /* PMC16_6          */
    uint16 PMC16_7  : 1; /* PMC16_7          */
    uint16 PMC16_8  : 1; /* PMC16_8          */
    uint16 PMC16_9  : 1; /* PMC16_9          */
    uint16 PMC16_10 : 1; /* PMC16_10         */
    uint16 PMC16_11 : 1; /* PMC16_11         */
    uint16          : 4; /* Reserved Bits    */
} __type69;
typedef struct
{                        /* Bit Access       */
    uint16 PFC16_0  : 1; /* PFC16_0          */
    uint16 PFC16_1  : 1; /* PFC16_1          */
    uint16 PFC16_2  : 1; /* PFC16_2          */
    uint16 PFC16_3  : 1; /* PFC16_3          */
    uint16 PFC16_4  : 1; /* PFC16_4          */
    uint16 PFC16_5  : 1; /* PFC16_5          */
    uint16 PFC16_6  : 1; /* PFC16_6          */
    uint16 PFC16_7  : 1; /* PFC16_7          */
    uint16 PFC16_8  : 1; /* PFC16_8          */
    uint16 PFC16_9  : 1; /* PFC16_9          */
    uint16 PFC16_10 : 1; /* PFC16_10         */
    uint16 PFC16_11 : 1; /* PFC16_11         */
    uint16          : 4; /* Reserved Bits    */
} __type70;
typedef struct
{                         /* Bit Access       */
    uint16 PFCE16_0  : 1; /* PFCE16_0         */
    uint16 PFCE16_1  : 1; /* PFCE16_1         */
    uint16 PFCE16_2  : 1; /* PFCE16_2         */
    uint16 PFCE16_3  : 1; /* PFCE16_3         */
    uint16 PFCE16_4  : 1; /* PFCE16_4         */
    uint16 PFCE16_5  : 1; /* PFCE16_5         */
    uint16 PFCE16_6  : 1; /* PFCE16_6         */
    uint16 PFCE16_7  : 1; /* PFCE16_7         */
    uint16 PFCE16_8  : 1; /* PFCE16_8         */
    uint16 PFCE16_9  : 1; /* PFCE16_9         */
    uint16 PFCE16_10 : 1; /* PFCE16_10        */
    uint16 PFCE16_11 : 1; /* PFCE16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type71;
typedef struct
{                         /* Bit Access       */
    uint32 PMSR16_0  : 1; /* PMSR16_0         */
    uint32 PMSR16_1  : 1; /* PMSR16_1         */
    uint32 PMSR16_2  : 1; /* PMSR16_2         */
    uint32 PMSR16_3  : 1; /* PMSR16_3         */
    uint32 PMSR16_4  : 1; /* PMSR16_4         */
    uint32 PMSR16_5  : 1; /* PMSR16_5         */
    uint32 PMSR16_6  : 1; /* PMSR16_6         */
    uint32 PMSR16_7  : 1; /* PMSR16_7         */
    uint32 PMSR16_8  : 1; /* PMSR16_8         */
    uint32 PMSR16_9  : 1; /* PMSR16_9         */
    uint32 PMSR16_10 : 1; /* PMSR16_10        */
    uint32 PMSR16_11 : 1; /* PMSR16_11        */
    uint32           : 4; /* Reserved Bits    */
    uint32 PMSR16_16 : 1; /* PMSR16_16        */
    uint32 PMSR16_17 : 1; /* PMSR16_17        */
    uint32 PMSR16_18 : 1; /* PMSR16_18        */
    uint32 PMSR16_19 : 1; /* PMSR16_19        */
    uint32 PMSR16_20 : 1; /* PMSR16_20        */
    uint32 PMSR16_21 : 1; /* PMSR16_21        */
    uint32 PMSR16_22 : 1; /* PMSR16_22        */
    uint32 PMSR16_23 : 1; /* PMSR16_23        */
    uint32 PMSR16_24 : 1; /* PMSR16_24        */
    uint32 PMSR16_25 : 1; /* PMSR16_25        */
    uint32 PMSR16_26 : 1; /* PMSR16_26        */
    uint32 PMSR16_27 : 1; /* PMSR16_27        */
    uint32           : 4; /* Reserved Bits    */
} __type72;
typedef struct
{                          /* Bit Access       */
    uint32 PMCSR16_0  : 1; /* PMCSR16_0        */
    uint32 PMCSR16_1  : 1; /* PMCSR16_1        */
    uint32 PMCSR16_2  : 1; /* PMCSR16_2        */
    uint32 PMCSR16_3  : 1; /* PMCSR16_3        */
    uint32 PMCSR16_4  : 1; /* PMCSR16_4        */
    uint32 PMCSR16_5  : 1; /* PMCSR16_5        */
    uint32 PMCSR16_6  : 1; /* PMCSR16_6        */
    uint32 PMCSR16_7  : 1; /* PMCSR16_7        */
    uint32 PMCSR16_8  : 1; /* PMCSR16_8        */
    uint32 PMCSR16_9  : 1; /* PMCSR16_9        */
    uint32 PMCSR16_10 : 1; /* PMCSR16_10       */
    uint32 PMCSR16_11 : 1; /* PMCSR16_11       */
    uint32            : 4; /* Reserved Bits    */
    uint32 PMCSR16_16 : 1; /* PMCSR16_16       */
    uint32 PMCSR16_17 : 1; /* PMCSR16_17       */
    uint32 PMCSR16_18 : 1; /* PMCSR16_18       */
    uint32 PMCSR16_19 : 1; /* PMCSR16_19       */
    uint32 PMCSR16_20 : 1; /* PMCSR16_20       */
    uint32 PMCSR16_21 : 1; /* PMCSR16_21       */
    uint32 PMCSR16_22 : 1; /* PMCSR16_22       */
    uint32 PMCSR16_23 : 1; /* PMCSR16_23       */
    uint32 PMCSR16_24 : 1; /* PMCSR16_24       */
    uint32 PMCSR16_25 : 1; /* PMCSR16_25       */
    uint32 PMCSR16_26 : 1; /* PMCSR16_26       */
    uint32 PMCSR16_27 : 1; /* PMCSR16_27       */
    uint32            : 4; /* Reserved Bits    */
} __type73;
typedef struct
{                         /* Bit Access       */
    uint16 PINV16_0  : 1; /* PINV16_0         */
    uint16 PINV16_1  : 1; /* PINV16_1         */
    uint16 PINV16_2  : 1; /* PINV16_2         */
    uint16 PINV16_3  : 1; /* PINV16_3         */
    uint16 PINV16_4  : 1; /* PINV16_4         */
    uint16 PINV16_5  : 1; /* PINV16_5         */
    uint16 PINV16_6  : 1; /* PINV16_6         */
    uint16 PINV16_7  : 1; /* PINV16_7         */
    uint16 PINV16_8  : 1; /* PINV16_8         */
    uint16 PINV16_9  : 1; /* PINV16_9         */
    uint16 PINV16_10 : 1; /* PINV16_10        */
    uint16 PINV16_11 : 1; /* PINV16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type74;
typedef struct
{                      /* Bit Access       */
    uint16 P17_0  : 1; /* P17_0            */
    uint16 P17_1  : 1; /* P17_1            */
    uint16 P17_2  : 1; /* P17_2            */
    uint16 P17_3  : 1; /* P17_3            */
    uint16 P17_4  : 1; /* P17_4            */
    uint16 P17_5  : 1; /* P17_5            */
    uint16 P17_6  : 1; /* P17_6            */
    uint16 P17_7  : 1; /* P17_7            */
    uint16 P17_8  : 1; /* P17_8            */
    uint16 P17_9  : 1; /* P17_9            */
    uint16 P17_10 : 1; /* P17_10           */
    uint16 P17_11 : 1; /* P17_11           */
    uint16        : 4; /* Reserved Bits    */
} __type75;
typedef struct
{                        /* Bit Access       */
    uint32 PSR17_0  : 1; /* PSR17_0          */
    uint32 PSR17_1  : 1; /* PSR17_1          */
    uint32 PSR17_2  : 1; /* PSR17_2          */
    uint32 PSR17_3  : 1; /* PSR17_3          */
    uint32 PSR17_4  : 1; /* PSR17_4          */
    uint32 PSR17_5  : 1; /* PSR17_5          */
    uint32 PSR17_6  : 1; /* PSR17_6          */
    uint32 PSR17_7  : 1; /* PSR17_7          */
    uint32 PSR17_8  : 1; /* PSR17_8          */
    uint32 PSR17_9  : 1; /* PSR17_9          */
    uint32 PSR17_10 : 1; /* PSR17_10         */
    uint32 PSR17_11 : 1; /* PSR17_11         */
    uint32          : 4; /* Reserved Bits    */
    uint32 PSR17_16 : 1; /* PSR17_16         */
    uint32 PSR17_17 : 1; /* PSR17_17         */
    uint32 PSR17_18 : 1; /* PSR17_18         */
    uint32 PSR17_19 : 1; /* PSR17_19         */
    uint32 PSR17_20 : 1; /* PSR17_20         */
    uint32 PSR17_21 : 1; /* PSR17_21         */
    uint32 PSR17_22 : 1; /* PSR17_22         */
    uint32 PSR17_23 : 1; /* PSR17_23         */
    uint32 PSR17_24 : 1; /* PSR17_24         */
    uint32 PSR17_25 : 1; /* PSR17_25         */
    uint32 PSR17_26 : 1; /* PSR17_26         */
    uint32 PSR17_27 : 1; /* PSR17_27         */
    uint32          : 4; /* Reserved Bits    */
} __type76;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT17_0  : 1; /* PNOT17_0         */
    uint16 PNOT17_1  : 1; /* PNOT17_1         */
    uint16 PNOT17_2  : 1; /* PNOT17_2         */
    uint16 PNOT17_3  : 1; /* PNOT17_3         */
    uint16 PNOT17_4  : 1; /* PNOT17_4         */
    uint16 PNOT17_5  : 1; /* PNOT17_5         */
    uint16 PNOT17_6  : 1; /* PNOT17_6         */
    uint16 PNOT17_7  : 1; /* PNOT17_7         */
    uint16 PNOT17_8  : 1; /* PNOT17_8         */
    uint16 PNOT17_9  : 1; /* PNOT17_9         */
    uint16 PNOT17_10 : 1; /* PNOT17_10        */
    uint16 PNOT17_11 : 1; /* PNOT17_11        */
    uint16           : 4; /* Reserved Bits    */
} __type77;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR17_0  : 1; /* PPR17_0          */
    const uint16 PPR17_1  : 1; /* PPR17_1          */
    const uint16 PPR17_2  : 1; /* PPR17_2          */
    const uint16 PPR17_3  : 1; /* PPR17_3          */
    const uint16 PPR17_4  : 1; /* PPR17_4          */
    const uint16 PPR17_5  : 1; /* PPR17_5          */
    const uint16 PPR17_6  : 1; /* PPR17_6          */
    const uint16 PPR17_7  : 1; /* PPR17_7          */
    const uint16 PPR17_8  : 1; /* PPR17_8          */
    const uint16 PPR17_9  : 1; /* PPR17_9          */
    const uint16 PPR17_10 : 1; /* PPR17_10         */
    const uint16 PPR17_11 : 1; /* PPR17_11         */
    uint16                : 4; /* Reserved Bits    */
} __type78;
typedef struct
{                       /* Bit Access       */
    uint16 PM17_0  : 1; /* PM17_0           */
    uint16 PM17_1  : 1; /* PM17_1           */
    uint16 PM17_2  : 1; /* PM17_2           */
    uint16 PM17_3  : 1; /* PM17_3           */
    uint16 PM17_4  : 1; /* PM17_4           */
    uint16 PM17_5  : 1; /* PM17_5           */
    uint16 PM17_6  : 1; /* PM17_6           */
    uint16 PM17_7  : 1; /* PM17_7           */
    uint16 PM17_8  : 1; /* PM17_8           */
    uint16 PM17_9  : 1; /* PM17_9           */
    uint16 PM17_10 : 1; /* PM17_10          */
    uint16 PM17_11 : 1; /* PM17_11          */
    uint16         : 4; /* Reserved Bits    */
} __type79;
typedef struct
{                        /* Bit Access       */
    uint16 PMC17_0  : 1; /* PMC17_0          */
    uint16 PMC17_1  : 1; /* PMC17_1          */
    uint16 PMC17_2  : 1; /* PMC17_2          */
    uint16 PMC17_3  : 1; /* PMC17_3          */
    uint16 PMC17_4  : 1; /* PMC17_4          */
    uint16 PMC17_5  : 1; /* PMC17_5          */
    uint16 PMC17_6  : 1; /* PMC17_6          */
    uint16 PMC17_7  : 1; /* PMC17_7          */
    uint16 PMC17_8  : 1; /* PMC17_8          */
    uint16 PMC17_9  : 1; /* PMC17_9          */
    uint16 PMC17_10 : 1; /* PMC17_10         */
    uint16 PMC17_11 : 1; /* PMC17_11         */
    uint16          : 4; /* Reserved Bits    */
} __type80;
typedef struct
{                        /* Bit Access       */
    uint16 PFC17_0  : 1; /* PFC17_0          */
    uint16 PFC17_1  : 1; /* PFC17_1          */
    uint16 PFC17_2  : 1; /* PFC17_2          */
    uint16 PFC17_3  : 1; /* PFC17_3          */
    uint16 PFC17_4  : 1; /* PFC17_4          */
    uint16 PFC17_5  : 1; /* PFC17_5          */
    uint16 PFC17_6  : 1; /* PFC17_6          */
    uint16 PFC17_7  : 1; /* PFC17_7          */
    uint16 PFC17_8  : 1; /* PFC17_8          */
    uint16 PFC17_9  : 1; /* PFC17_9          */
    uint16 PFC17_10 : 1; /* PFC17_10         */
    uint16 PFC17_11 : 1; /* PFC17_11         */
    uint16          : 4; /* Reserved Bits    */
} __type81;
typedef struct
{                         /* Bit Access       */
    uint16 PFCE17_0 : 1;  /* PFCE17_0         */
    uint16 PFCE17_1 : 1;  /* PFCE17_1         */
    uint16 PFCE17_2 : 1;  /* PFCE17_2         */
    uint16 PFCE17_3 : 1;  /* PFCE17_3         */
    uint16          : 12; /* Reserved Bits    */
} __type82;
typedef struct
{                         /* Bit Access       */
    uint32 PMSR17_0  : 1; /* PMSR17_0         */
    uint32 PMSR17_1  : 1; /* PMSR17_1         */
    uint32 PMSR17_2  : 1; /* PMSR17_2         */
    uint32 PMSR17_3  : 1; /* PMSR17_3         */
    uint32 PMSR17_4  : 1; /* PMSR17_4         */
    uint32 PMSR17_5  : 1; /* PMSR17_5         */
    uint32 PMSR17_6  : 1; /* PMSR17_6         */
    uint32 PMSR17_7  : 1; /* PMSR17_7         */
    uint32 PMSR17_8  : 1; /* PMSR17_8         */
    uint32 PMSR17_9  : 1; /* PMSR17_9         */
    uint32 PMSR17_10 : 1; /* PMSR17_10        */
    uint32 PMSR17_11 : 1; /* PMSR17_11        */
    uint32           : 4; /* Reserved Bits    */
    uint32 PMSR17_16 : 1; /* PMSR17_16        */
    uint32 PMSR17_17 : 1; /* PMSR17_17        */
    uint32 PMSR17_18 : 1; /* PMSR17_18        */
    uint32 PMSR17_19 : 1; /* PMSR17_19        */
    uint32 PMSR17_20 : 1; /* PMSR17_20        */
    uint32 PMSR17_21 : 1; /* PMSR17_21        */
    uint32 PMSR17_22 : 1; /* PMSR17_22        */
    uint32 PMSR17_23 : 1; /* PMSR17_23        */
    uint32 PMSR17_24 : 1; /* PMSR17_24        */
    uint32 PMSR17_25 : 1; /* PMSR17_25        */
    uint32 PMSR17_26 : 1; /* PMSR17_26        */
    uint32 PMSR17_27 : 1; /* PMSR17_27        */
    uint32           : 4; /* Reserved Bits    */
} __type83;
typedef struct
{                          /* Bit Access       */
    uint32 PMCSR17_0  : 1; /* PMCSR17_0        */
    uint32 PMCSR17_1  : 1; /* PMCSR17_1        */
    uint32 PMCSR17_2  : 1; /* PMCSR17_2        */
    uint32 PMCSR17_3  : 1; /* PMCSR17_3        */
    uint32 PMCSR17_4  : 1; /* PMCSR17_4        */
    uint32 PMCSR17_5  : 1; /* PMCSR17_5        */
    uint32 PMCSR17_6  : 1; /* PMCSR17_6        */
    uint32 PMCSR17_7  : 1; /* PMCSR17_7        */
    uint32 PMCSR17_8  : 1; /* PMCSR17_8        */
    uint32 PMCSR17_9  : 1; /* PMCSR17_9        */
    uint32 PMCSR17_10 : 1; /* PMCSR17_10       */
    uint32 PMCSR17_11 : 1; /* PMCSR17_11       */
    uint32            : 4; /* Reserved Bits    */
    uint32 PMCSR17_16 : 1; /* PMCSR17_16       */
    uint32 PMCSR17_17 : 1; /* PMCSR17_17       */
    uint32 PMCSR17_18 : 1; /* PMCSR17_18       */
    uint32 PMCSR17_19 : 1; /* PMCSR17_19       */
    uint32 PMCSR17_20 : 1; /* PMCSR17_20       */
    uint32 PMCSR17_21 : 1; /* PMCSR17_21       */
    uint32 PMCSR17_22 : 1; /* PMCSR17_22       */
    uint32 PMCSR17_23 : 1; /* PMCSR17_23       */
    uint32 PMCSR17_24 : 1; /* PMCSR17_24       */
    uint32 PMCSR17_25 : 1; /* PMCSR17_25       */
    uint32 PMCSR17_26 : 1; /* PMCSR17_26       */
    uint32 PMCSR17_27 : 1; /* PMCSR17_27       */
    uint32            : 4; /* Reserved Bits    */
} __type84;
typedef struct
{                         /* Bit Access       */
    uint16 PINV17_0  : 1; /* PINV17_0         */
    uint16 PINV17_1  : 1; /* PINV17_1         */
    uint16 PINV17_2  : 1; /* PINV17_2         */
    uint16 PINV17_3  : 1; /* PINV17_3         */
    uint16 PINV17_4  : 1; /* PINV17_4         */
    uint16 PINV17_5  : 1; /* PINV17_5         */
    uint16 PINV17_6  : 1; /* PINV17_6         */
    uint16 PINV17_7  : 1; /* PINV17_7         */
    uint16 PINV17_8  : 1; /* PINV17_8         */
    uint16 PINV17_9  : 1; /* PINV17_9         */
    uint16 PINV17_10 : 1; /* PINV17_10        */
    uint16 PINV17_11 : 1; /* PINV17_11        */
    uint16           : 4; /* Reserved Bits    */
} __type85;
typedef struct
{                      /* Bit Access       */
    uint16 P21_0 : 1;  /* P21_0            */
    uint16 P21_1 : 1;  /* P21_1            */
    uint16 P21_2 : 1;  /* P21_2            */
    uint16 P21_3 : 1;  /* P21_3            */
    uint16 P21_4 : 1;  /* P21_4            */
    uint16 P21_5 : 1;  /* P21_5            */
    uint16       : 10; /* Reserved Bits    */
} __type86;
typedef struct
{                         /* Bit Access       */
    uint32 PSR21_0  : 1;  /* PSR21_0          */
    uint32 PSR21_1  : 1;  /* PSR21_1          */
    uint32 PSR21_2  : 1;  /* PSR21_2          */
    uint32 PSR21_3  : 1;  /* PSR21_3          */
    uint32 PSR21_4  : 1;  /* PSR21_4          */
    uint32 PSR21_5  : 1;  /* PSR21_5          */
    uint32          : 10; /* Reserved Bits    */
    uint32 PSR21_16 : 1;  /* PSR21_16         */
    uint32 PSR21_17 : 1;  /* PSR21_17         */
    uint32 PSR21_18 : 1;  /* PSR21_18         */
    uint32 PSR21_19 : 1;  /* PSR21_19         */
    uint32 PSR21_20 : 1;  /* PSR21_20         */
    uint32 PSR21_21 : 1;  /* PSR21_21         */
    uint32          : 10; /* Reserved Bits    */
} __type87;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT21_0 : 1;  /* PNOT21_0         */
    uint16 PNOT21_1 : 1;  /* PNOT21_1         */
    uint16 PNOT21_2 : 1;  /* PNOT21_2         */
    uint16 PNOT21_3 : 1;  /* PNOT21_3         */
    uint16 PNOT21_4 : 1;  /* PNOT21_4         */
    uint16 PNOT21_5 : 1;  /* PNOT21_5         */
    uint16          : 10; /* Reserved Bits    */
} __type88;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR21_0 : 1;  /* PPR21_0          */
    const uint16 PPR21_1 : 1;  /* PPR21_1          */
    const uint16 PPR21_2 : 1;  /* PPR21_2          */
    const uint16 PPR21_3 : 1;  /* PPR21_3          */
    const uint16 PPR21_4 : 1;  /* PPR21_4          */
    const uint16 PPR21_5 : 1;  /* PPR21_5          */
    uint16               : 10; /* Reserved Bits    */
} __type89;
typedef struct
{                       /* Bit Access       */
    uint16 PM21_0 : 1;  /* PM21_0           */
    uint16 PM21_1 : 1;  /* PM21_1           */
    uint16 PM21_2 : 1;  /* PM21_2           */
    uint16 PM21_3 : 1;  /* PM21_3           */
    uint16 PM21_4 : 1;  /* PM21_4           */
    uint16 PM21_5 : 1;  /* PM21_5           */
    uint16        : 10; /* Reserved Bits    */
} __type90;
typedef struct
{                        /* Bit Access       */
    uint16 PMC21_0 : 1;  /* PMC21_0          */
    uint16 PMC21_1 : 1;  /* PMC21_1          */
    uint16 PMC21_2 : 1;  /* PMC21_2          */
    uint16 PMC21_3 : 1;  /* PMC21_3          */
    uint16 PMC21_4 : 1;  /* PMC21_4          */
    uint16 PMC21_5 : 1;  /* PMC21_5          */
    uint16         : 10; /* Reserved Bits    */
} __type91;
typedef struct
{                        /* Bit Access       */
    uint16 PFC21_0 : 1;  /* PFC21_0          */
    uint16 PFC21_1 : 1;  /* PFC21_1          */
    uint16 PFC21_2 : 1;  /* PFC21_2          */
    uint16 PFC21_3 : 1;  /* PFC21_3          */
    uint16 PFC21_4 : 1;  /* PFC21_4          */
    uint16 PFC21_5 : 1;  /* PFC21_5          */
    uint16         : 10; /* Reserved Bits    */
} __type92;
typedef struct
{                          /* Bit Access       */
    uint32 PMSR21_0  : 1;  /* PMSR21_0         */
    uint32 PMSR21_1  : 1;  /* PMSR21_1         */
    uint32 PMSR21_2  : 1;  /* PMSR21_2         */
    uint32 PMSR21_3  : 1;  /* PMSR21_3         */
    uint32 PMSR21_4  : 1;  /* PMSR21_4         */
    uint32 PMSR21_5  : 1;  /* PMSR21_5         */
    uint32           : 10; /* Reserved Bits    */
    uint32 PMSR21_16 : 1;  /* PMSR21_16        */
    uint32 PMSR21_17 : 1;  /* PMSR21_17        */
    uint32 PMSR21_18 : 1;  /* PMSR21_18        */
    uint32 PMSR21_19 : 1;  /* PMSR21_19        */
    uint32 PMSR21_20 : 1;  /* PMSR21_20        */
    uint32 PMSR21_21 : 1;  /* PMSR21_21        */
    uint32           : 10; /* Reserved Bits    */
} __type93;
typedef struct
{                           /* Bit Access       */
    uint32 PMCSR21_0  : 1;  /* PMCSR21_0        */
    uint32 PMCSR21_1  : 1;  /* PMCSR21_1        */
    uint32 PMCSR21_2  : 1;  /* PMCSR21_2        */
    uint32 PMCSR21_3  : 1;  /* PMCSR21_3        */
    uint32 PMCSR21_4  : 1;  /* PMCSR21_4        */
    uint32 PMCSR21_5  : 1;  /* PMCSR21_5        */
    uint32            : 10; /* Reserved Bits    */
    uint32 PMCSR21_16 : 1;  /* PMCSR21_16       */
    uint32 PMCSR21_17 : 1;  /* PMCSR21_17       */
    uint32 PMCSR21_18 : 1;  /* PMCSR21_18       */
    uint32 PMCSR21_19 : 1;  /* PMCSR21_19       */
    uint32 PMCSR21_20 : 1;  /* PMCSR21_20       */
    uint32 PMCSR21_21 : 1;  /* PMCSR21_21       */
    uint32            : 10; /* Reserved Bits    */
} __type94;
typedef struct
{                         /* Bit Access       */
    uint16 PINV21_0 : 1;  /* PINV21_0         */
    uint16 PINV21_1 : 1;  /* PINV21_1         */
    uint16 PINV21_2 : 1;  /* PINV21_2         */
    uint16 PINV21_3 : 1;  /* PINV21_3         */
    uint16 PINV21_4 : 1;  /* PINV21_4         */
    uint16 PINV21_5 : 1;  /* PINV21_5         */
    uint16          : 10; /* Reserved Bits    */
} __type95;
typedef struct
{                      /* Bit Access       */
    uint16        : 7; /* Reserved Bits    */
    uint16 P42_7  : 1; /* P42_7            */
    uint16 P42_8  : 1; /* P42_8            */
    uint16 P42_9  : 1; /* P42_9            */
    uint16 P42_10 : 1; /* P42_10           */
    uint16        : 5; /* Reserved Bits    */
} __type96;
typedef struct
{                         /* Bit Access       */
    uint32          : 7;  /* Reserved Bits    */
    uint32 PSR42_7  : 1;  /* PSR42_7          */
    uint32 PSR42_8  : 1;  /* PSR42_8          */
    uint32 PSR42_9  : 1;  /* PSR42_9          */
    uint32 PSR42_10 : 1;  /* PSR42_10         */
    uint32          : 12; /* Reserved Bits    */
    uint32 PSR42_23 : 1;  /* PSR42_23         */
    uint32 PSR42_24 : 1;  /* PSR42_24         */
    uint32 PSR42_25 : 1;  /* PSR42_25         */
    uint32 PSR42_26 : 1;  /* PSR42_26         */
    uint32          : 5;  /* Reserved Bits    */
} __type97;
typedef struct
{                         /* Bit Access       */
    uint16           : 7; /* Reserved Bits    */
    uint16 PNOT42_7  : 1; /* PNOT42_7         */
    uint16 PNOT42_8  : 1; /* PNOT42_8         */
    uint16 PNOT42_9  : 1; /* PNOT42_9         */
    uint16 PNOT42_10 : 1; /* PNOT42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type98;
typedef struct
{                              /* Bit Access       */
    uint16                : 7; /* Reserved Bits    */
    const uint16 PPR42_7  : 1; /* PPR42_7          */
    const uint16 PPR42_8  : 1; /* PPR42_8          */
    const uint16 PPR42_9  : 1; /* PPR42_9          */
    const uint16 PPR42_10 : 1; /* PPR42_10         */
    uint16                : 5; /* Reserved Bits    */
} __type99;
typedef struct
{                       /* Bit Access       */
    uint16         : 7; /* Reserved Bits    */
    uint16 PM42_7  : 1; /* PM42_7           */
    uint16 PM42_8  : 1; /* PM42_8           */
    uint16 PM42_9  : 1; /* PM42_9           */
    uint16 PM42_10 : 1; /* PM42_10          */
    uint16         : 5; /* Reserved Bits    */
} __type100;
typedef struct
{                        /* Bit Access       */
    uint16          : 7; /* Reserved Bits    */
    uint16 PMC42_7  : 1; /* PMC42_7          */
    uint16 PMC42_8  : 1; /* PMC42_8          */
    uint16 PMC42_9  : 1; /* PMC42_9          */
    uint16 PMC42_10 : 1; /* PMC42_10         */
    uint16          : 5; /* Reserved Bits    */
} __type101;
typedef struct
{                        /* Bit Access       */
    uint16          : 7; /* Reserved Bits    */
    uint16 PFC42_7  : 1; /* PFC42_7          */
    uint16 PFC42_8  : 1; /* PFC42_8          */
    uint16 PFC42_9  : 1; /* PFC42_9          */
    uint16 PFC42_10 : 1; /* PFC42_10         */
    uint16          : 5; /* Reserved Bits    */
} __type102;
typedef struct
{                         /* Bit Access       */
    uint16           : 7; /* Reserved Bits    */
    uint16 PFCE42_7  : 1; /* PFCE42_7         */
    uint16 PFCE42_8  : 1; /* PFCE42_8         */
    uint16 PFCE42_9  : 1; /* PFCE42_9         */
    uint16 PFCE42_10 : 1; /* PFCE42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type103;
typedef struct
{                          /* Bit Access       */
    uint32           : 7;  /* Reserved Bits    */
    uint32 PMSR42_7  : 1;  /* PMSR42_7         */
    uint32 PMSR42_8  : 1;  /* PMSR42_8         */
    uint32 PMSR42_9  : 1;  /* PMSR42_9         */
    uint32 PMSR42_10 : 1;  /* PMSR42_10        */
    uint32           : 12; /* Reserved Bits    */
    uint32 PMSR42_23 : 1;  /* PMSR42_23        */
    uint32 PMSR42_24 : 1;  /* PMSR42_24        */
    uint32 PMSR42_25 : 1;  /* PMSR42_25        */
    uint32 PMSR42_26 : 1;  /* PMSR42_26        */
    uint32           : 5;  /* Reserved Bits    */
} __type104;
typedef struct
{                           /* Bit Access       */
    uint32            : 7;  /* Reserved Bits    */
    uint32 PMCSR42_7  : 1;  /* PMCSR42_7        */
    uint32 PMCSR42_8  : 1;  /* PMCSR42_8        */
    uint32 PMCSR42_9  : 1;  /* PMCSR42_9        */
    uint32 PMCSR42_10 : 1;  /* PMCSR42_10       */
    uint32            : 12; /* Reserved Bits    */
    uint32 PMCSR42_23 : 1;  /* PMCSR42_23       */
    uint32 PMCSR42_24 : 1;  /* PMCSR42_24       */
    uint32 PMCSR42_25 : 1;  /* PMCSR42_25       */
    uint32 PMCSR42_26 : 1;  /* PMCSR42_26       */
    uint32            : 5;  /* Reserved Bits    */
} __type105;
typedef struct
{                         /* Bit Access       */
    uint16           : 7; /* Reserved Bits    */
    uint16 PINV42_7  : 1; /* PINV42_7         */
    uint16 PINV42_8  : 1; /* PINV42_8         */
    uint16 PINV42_9  : 1; /* PINV42_9         */
    uint16 PINV42_10 : 1; /* PINV42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type106;
typedef struct
{                      /* Bit Access       */
    uint16 P43_0 : 1;  /* P43_0            */
    uint16 P43_1 : 1;  /* P43_1            */
    uint16       : 14; /* Reserved Bits    */
} __type107;
typedef struct
{                         /* Bit Access       */
    uint32 PSR43_0  : 1;  /* PSR43_0          */
    uint32 PSR43_1  : 1;  /* PSR43_1          */
    uint32          : 14; /* Reserved Bits    */
    uint32 PSR43_16 : 1;  /* PSR43_16         */
    uint32 PSR43_17 : 1;  /* PSR43_17         */
    uint32          : 14; /* Reserved Bits    */
} __type108;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT43_0 : 1;  /* PNOT43_0         */
    uint16 PNOT43_1 : 1;  /* PNOT43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type109;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR43_0 : 1;  /* PPR43_0          */
    const uint16 PPR43_1 : 1;  /* PPR43_1          */
    uint16               : 14; /* Reserved Bits    */
} __type110;
typedef struct
{                       /* Bit Access       */
    uint16 PM43_0 : 1;  /* PM43_0           */
    uint16 PM43_1 : 1;  /* PM43_1           */
    uint16        : 14; /* Reserved Bits    */
} __type111;
typedef struct
{                        /* Bit Access       */
    uint16 PMC43_0 : 1;  /* PMC43_0          */
    uint16 PMC43_1 : 1;  /* PMC43_1          */
    uint16         : 14; /* Reserved Bits    */
} __type112;
typedef struct
{                        /* Bit Access       */
    uint16 PFC43_0 : 1;  /* PFC43_0          */
    uint16 PFC43_1 : 1;  /* PFC43_1          */
    uint16         : 14; /* Reserved Bits    */
} __type113;
typedef struct
{                         /* Bit Access       */
    uint16 PFCE43_0 : 1;  /* PFCE43_0         */
    uint16 PFCE43_1 : 1;  /* PFCE43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type114;
typedef struct
{                          /* Bit Access       */
    uint32 PMSR43_0  : 1;  /* PMSR43_0         */
    uint32 PMSR43_1  : 1;  /* PMSR43_1         */
    uint32           : 14; /* Reserved Bits    */
    uint32 PMSR43_16 : 1;  /* PMSR43_16        */
    uint32 PMSR43_17 : 1;  /* PMSR43_17        */
    uint32           : 14; /* Reserved Bits    */
} __type115;
typedef struct
{                           /* Bit Access       */
    uint32 PMCSR43_0  : 1;  /* PMCSR43_0        */
    uint32 PMCSR43_1  : 1;  /* PMCSR43_1        */
    uint32            : 14; /* Reserved Bits    */
    uint32 PMCSR43_16 : 1;  /* PMCSR43_16       */
    uint32 PMCSR43_17 : 1;  /* PMCSR43_17       */
    uint32            : 14; /* Reserved Bits    */
} __type116;
typedef struct
{                         /* Bit Access       */
    uint16 PINV43_0 : 1;  /* PINV43_0         */
    uint16 PINV43_1 : 1;  /* PINV43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type117;
typedef struct
{                      /* Bit Access       */
    uint16        : 1; /* Reserved Bits    */
    uint16 P44_1  : 1; /* P44_1            */
    uint16 P44_2  : 1; /* P44_2            */
    uint16 P44_3  : 1; /* P44_3            */
    uint16 P44_4  : 1; /* P44_4            */
    uint16        : 1; /* Reserved Bits    */
    uint16 P44_6  : 1; /* P44_6            */
    uint16 P44_7  : 1; /* P44_7            */
    uint16 P44_8  : 1; /* P44_8            */
    uint16 P44_9  : 1; /* P44_9            */
    uint16 P44_10 : 1; /* P44_10           */
    uint16 P44_11 : 1; /* P44_11           */
    uint16        : 4; /* Reserved Bits    */
} __type118;
typedef struct
{                        /* Bit Access       */
    uint32          : 1; /* Reserved Bits    */
    uint32 PSR44_1  : 1; /* PSR44_1          */
    uint32 PSR44_2  : 1; /* PSR44_2          */
    uint32 PSR44_3  : 1; /* PSR44_3          */
    uint32 PSR44_4  : 1; /* PSR44_4          */
    uint32          : 1; /* Reserved Bits    */
    uint32 PSR44_6  : 1; /* PSR44_6          */
    uint32 PSR44_7  : 1; /* PSR44_7          */
    uint32 PSR44_8  : 1; /* PSR44_8          */
    uint32 PSR44_9  : 1; /* PSR44_9          */
    uint32 PSR44_10 : 1; /* PSR44_10         */
    uint32 PSR44_11 : 1; /* PSR44_11         */
    uint32          : 5; /* Reserved Bits    */
    uint32 PSR44_17 : 1; /* PSR44_17         */
    uint32 PSR44_18 : 1; /* PSR44_18         */
    uint32 PSR44_19 : 1; /* PSR44_19         */
    uint32 PSR44_20 : 1; /* PSR44_20         */
    uint32          : 1; /* Reserved Bits    */
    uint32 PSR44_22 : 1; /* PSR44_22         */
    uint32 PSR44_23 : 1; /* PSR44_23         */
    uint32 PSR44_24 : 1; /* PSR44_24         */
    uint32 PSR44_25 : 1; /* PSR44_25         */
    uint32 PSR44_26 : 1; /* PSR44_26         */
    uint32 PSR44_27 : 1; /* PSR44_27         */
    uint32          : 4; /* Reserved Bits    */
} __type119;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PNOT44_1  : 1; /* PNOT44_1         */
    uint16 PNOT44_2  : 1; /* PNOT44_2         */
    uint16 PNOT44_3  : 1; /* PNOT44_3         */
    uint16 PNOT44_4  : 1; /* PNOT44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PNOT44_6  : 1; /* PNOT44_6         */
    uint16 PNOT44_7  : 1; /* PNOT44_7         */
    uint16 PNOT44_8  : 1; /* PNOT44_8         */
    uint16 PNOT44_9  : 1; /* PNOT44_9         */
    uint16 PNOT44_10 : 1; /* PNOT44_10        */
    uint16 PNOT44_11 : 1; /* PNOT44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type120;
typedef struct
{                              /* Bit Access       */
    uint16                : 1; /* Reserved Bits    */
    const uint16 PPR44_1  : 1; /* PPR44_1          */
    const uint16 PPR44_2  : 1; /* PPR44_2          */
    const uint16 PPR44_3  : 1; /* PPR44_3          */
    const uint16 PPR44_4  : 1; /* PPR44_4          */
    uint16                : 1; /* Reserved Bits    */
    const uint16 PPR44_6  : 1; /* PPR44_6          */
    const uint16 PPR44_7  : 1; /* PPR44_7          */
    const uint16 PPR44_8  : 1; /* PPR44_8          */
    const uint16 PPR44_9  : 1; /* PPR44_9          */
    const uint16 PPR44_10 : 1; /* PPR44_10         */
    const uint16 PPR44_11 : 1; /* PPR44_11         */
    uint16                : 4; /* Reserved Bits    */
} __type121;
typedef struct
{                       /* Bit Access       */
    uint16         : 1; /* Reserved Bits    */
    uint16 PM44_1  : 1; /* PM44_1           */
    uint16 PM44_2  : 1; /* PM44_2           */
    uint16 PM44_3  : 1; /* PM44_3           */
    uint16 PM44_4  : 1; /* PM44_4           */
    uint16         : 1; /* Reserved Bits    */
    uint16 PM44_6  : 1; /* PM44_6           */
    uint16 PM44_7  : 1; /* PM44_7           */
    uint16 PM44_8  : 1; /* PM44_8           */
    uint16 PM44_9  : 1; /* PM44_9           */
    uint16 PM44_10 : 1; /* PM44_10          */
    uint16 PM44_11 : 1; /* PM44_11          */
    uint16         : 4; /* Reserved Bits    */
} __type122;
typedef struct
{                        /* Bit Access       */
    uint16          : 1; /* Reserved Bits    */
    uint16 PMC44_1  : 1; /* PMC44_1          */
    uint16 PMC44_2  : 1; /* PMC44_2          */
    uint16 PMC44_3  : 1; /* PMC44_3          */
    uint16 PMC44_4  : 1; /* PMC44_4          */
    uint16          : 1; /* Reserved Bits    */
    uint16 PMC44_6  : 1; /* PMC44_6          */
    uint16 PMC44_7  : 1; /* PMC44_7          */
    uint16 PMC44_8  : 1; /* PMC44_8          */
    uint16 PMC44_9  : 1; /* PMC44_9          */
    uint16 PMC44_10 : 1; /* PMC44_10         */
    uint16 PMC44_11 : 1; /* PMC44_11         */
    uint16          : 4; /* Reserved Bits    */
} __type123;
typedef struct
{                        /* Bit Access       */
    uint16          : 1; /* Reserved Bits    */
    uint16 PFC44_1  : 1; /* PFC44_1          */
    uint16 PFC44_2  : 1; /* PFC44_2          */
    uint16 PFC44_3  : 1; /* PFC44_3          */
    uint16 PFC44_4  : 1; /* PFC44_4          */
    uint16          : 1; /* Reserved Bits    */
    uint16 PFC44_6  : 1; /* PFC44_6          */
    uint16 PFC44_7  : 1; /* PFC44_7          */
    uint16 PFC44_8  : 1; /* PFC44_8          */
    uint16 PFC44_9  : 1; /* PFC44_9          */
    uint16 PFC44_10 : 1; /* PFC44_10         */
    uint16 PFC44_11 : 1; /* PFC44_11         */
    uint16          : 4; /* Reserved Bits    */
} __type124;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PFCE44_1  : 1; /* PFCE44_1         */
    uint16 PFCE44_2  : 1; /* PFCE44_2         */
    uint16 PFCE44_3  : 1; /* PFCE44_3         */
    uint16 PFCE44_4  : 1; /* PFCE44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PFCE44_6  : 1; /* PFCE44_6         */
    uint16 PFCE44_7  : 1; /* PFCE44_7         */
    uint16 PFCE44_8  : 1; /* PFCE44_8         */
    uint16 PFCE44_9  : 1; /* PFCE44_9         */
    uint16 PFCE44_10 : 1; /* PFCE44_10        */
    uint16 PFCE44_11 : 1; /* PFCE44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type125;
typedef struct
{                         /* Bit Access       */
    uint32           : 1; /* Reserved Bits    */
    uint32 PMSR44_1  : 1; /* PMSR44_1         */
    uint32 PMSR44_2  : 1; /* PMSR44_2         */
    uint32 PMSR44_3  : 1; /* PMSR44_3         */
    uint32 PMSR44_4  : 1; /* PMSR44_4         */
    uint32           : 1; /* Reserved Bits    */
    uint32 PMSR44_6  : 1; /* PMSR44_6         */
    uint32 PMSR44_7  : 1; /* PMSR44_7         */
    uint32 PMSR44_8  : 1; /* PMSR44_8         */
    uint32 PMSR44_9  : 1; /* PMSR44_9         */
    uint32 PMSR44_10 : 1; /* PMSR44_10        */
    uint32 PMSR44_11 : 1; /* PMSR44_11        */
    uint32           : 5; /* Reserved Bits    */
    uint32 PMSR44_17 : 1; /* PMSR44_17        */
    uint32 PMSR44_18 : 1; /* PMSR44_18        */
    uint32 PMSR44_19 : 1; /* PMSR44_19        */
    uint32 PMSR44_20 : 1; /* PMSR44_20        */
    uint32           : 1; /* Reserved Bits    */
    uint32 PMSR44_22 : 1; /* PMSR44_22        */
    uint32 PMSR44_23 : 1; /* PMSR44_23        */
    uint32 PMSR44_24 : 1; /* PMSR44_24        */
    uint32 PMSR44_25 : 1; /* PMSR44_25        */
    uint32 PMSR44_26 : 1; /* PMSR44_26        */
    uint32 PMSR44_27 : 1; /* PMSR44_27        */
    uint32           : 4; /* Reserved Bits    */
} __type126;
typedef struct
{                          /* Bit Access       */
    uint32            : 1; /* Reserved Bits    */
    uint32 PMCSR44_1  : 1; /* PMCSR44_1        */
    uint32 PMCSR44_2  : 1; /* PMCSR44_2        */
    uint32 PMCSR44_3  : 1; /* PMCSR44_3        */
    uint32 PMCSR44_4  : 1; /* PMCSR44_4        */
    uint32            : 1; /* Reserved Bits    */
    uint32 PMCSR44_6  : 1; /* PMCSR44_6        */
    uint32 PMCSR44_7  : 1; /* PMCSR44_7        */
    uint32 PMCSR44_8  : 1; /* PMCSR44_8        */
    uint32 PMCSR44_9  : 1; /* PMCSR44_9        */
    uint32 PMCSR44_10 : 1; /* PMCSR44_10       */
    uint32 PMCSR44_11 : 1; /* PMCSR44_11       */
    uint32            : 5; /* Reserved Bits    */
    uint32 PMCSR44_17 : 1; /* PMCSR44_17       */
    uint32 PMCSR44_18 : 1; /* PMCSR44_18       */
    uint32 PMCSR44_19 : 1; /* PMCSR44_19       */
    uint32 PMCSR44_20 : 1; /* PMCSR44_20       */
    uint32            : 1; /* Reserved Bits    */
    uint32 PMCSR44_22 : 1; /* PMCSR44_22       */
    uint32 PMCSR44_23 : 1; /* PMCSR44_23       */
    uint32 PMCSR44_24 : 1; /* PMCSR44_24       */
    uint32 PMCSR44_25 : 1; /* PMCSR44_25       */
    uint32 PMCSR44_26 : 1; /* PMCSR44_26       */
    uint32 PMCSR44_27 : 1; /* PMCSR44_27       */
    uint32            : 4; /* Reserved Bits    */
} __type127;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PINV44_1  : 1; /* PINV44_1         */
    uint16 PINV44_2  : 1; /* PINV44_2         */
    uint16 PINV44_3  : 1; /* PINV44_3         */
    uint16 PINV44_4  : 1; /* PINV44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PINV44_6  : 1; /* PINV44_6         */
    uint16 PINV44_7  : 1; /* PINV44_7         */
    uint16 PINV44_8  : 1; /* PINV44_8         */
    uint16 PINV44_9  : 1; /* PINV44_9         */
    uint16 PINV44_10 : 1; /* PINV44_10        */
    uint16 PINV44_11 : 1; /* PINV44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type128;
typedef struct
{                      /* Bit Access       */
    uint16 P45_0  : 1; /* P45_0            */
    uint16 P45_1  : 1; /* P45_1            */
    uint16 P45_2  : 1; /* P45_2            */
    uint16 P45_3  : 1; /* P45_3            */
    uint16 P45_4  : 1; /* P45_4            */
    uint16 P45_5  : 1; /* P45_5            */
    uint16 P45_6  : 1; /* P45_6            */
    uint16 P45_7  : 1; /* P45_7            */
    uint16 P45_8  : 1; /* P45_8            */
    uint16 P45_9  : 1; /* P45_9            */
    uint16 P45_10 : 1; /* P45_10           */
    uint16 P45_11 : 1; /* P45_11           */
    uint16 P45_12 : 1; /* P45_12           */
    uint16 P45_13 : 1; /* P45_13           */
    uint16        : 2; /* Reserved Bits    */
} __type129;
typedef struct
{                        /* Bit Access       */
    uint32 PSR45_0  : 1; /* PSR45_0          */
    uint32 PSR45_1  : 1; /* PSR45_1          */
    uint32 PSR45_2  : 1; /* PSR45_2          */
    uint32 PSR45_3  : 1; /* PSR45_3          */
    uint32 PSR45_4  : 1; /* PSR45_4          */
    uint32 PSR45_5  : 1; /* PSR45_5          */
    uint32 PSR45_6  : 1; /* PSR45_6          */
    uint32 PSR45_7  : 1; /* PSR45_7          */
    uint32 PSR45_8  : 1; /* PSR45_8          */
    uint32 PSR45_9  : 1; /* PSR45_9          */
    uint32 PSR45_10 : 1; /* PSR45_10         */
    uint32 PSR45_11 : 1; /* PSR45_11         */
    uint32 PSR45_12 : 1; /* PSR45_12         */
    uint32 PSR45_13 : 1; /* PSR45_13         */
    uint32          : 2; /* Reserved Bits    */
    uint32 PSR45_16 : 1; /* PSR45_16         */
    uint32 PSR45_17 : 1; /* PSR45_17         */
    uint32 PSR45_18 : 1; /* PSR45_18         */
    uint32 PSR45_19 : 1; /* PSR45_19         */
    uint32 PSR45_20 : 1; /* PSR45_20         */
    uint32 PSR45_21 : 1; /* PSR45_21         */
    uint32 PSR45_22 : 1; /* PSR45_22         */
    uint32 PSR45_23 : 1; /* PSR45_23         */
    uint32 PSR45_24 : 1; /* PSR45_24         */
    uint32 PSR45_25 : 1; /* PSR45_25         */
    uint32 PSR45_26 : 1; /* PSR45_26         */
    uint32 PSR45_27 : 1; /* PSR45_27         */
    uint32 PSR45_28 : 1; /* PSR45_28         */
    uint32 PSR45_29 : 1; /* PSR45_29         */
    uint32          : 2; /* Reserved Bits    */
} __type130;
typedef struct
{                         /* Bit Access       */
    uint16 PNOT45_0  : 1; /* PNOT45_0         */
    uint16 PNOT45_1  : 1; /* PNOT45_1         */
    uint16 PNOT45_2  : 1; /* PNOT45_2         */
    uint16 PNOT45_3  : 1; /* PNOT45_3         */
    uint16 PNOT45_4  : 1; /* PNOT45_4         */
    uint16 PNOT45_5  : 1; /* PNOT45_5         */
    uint16 PNOT45_6  : 1; /* PNOT45_6         */
    uint16 PNOT45_7  : 1; /* PNOT45_7         */
    uint16 PNOT45_8  : 1; /* PNOT45_8         */
    uint16 PNOT45_9  : 1; /* PNOT45_9         */
    uint16 PNOT45_10 : 1; /* PNOT45_10        */
    uint16 PNOT45_11 : 1; /* PNOT45_11        */
    uint16 PNOT45_12 : 1; /* PNOT45_12        */
    uint16 PNOT45_13 : 1; /* PNOT45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type131;
typedef struct
{                              /* Bit Access       */
    const uint16 PPR45_0  : 1; /* PPR45_0          */
    const uint16 PPR45_1  : 1; /* PPR45_1          */
    const uint16 PPR45_2  : 1; /* PPR45_2          */
    const uint16 PPR45_3  : 1; /* PPR45_3          */
    const uint16 PPR45_4  : 1; /* PPR45_4          */
    const uint16 PPR45_5  : 1; /* PPR45_5          */
    const uint16 PPR45_6  : 1; /* PPR45_6          */
    const uint16 PPR45_7  : 1; /* PPR45_7          */
    const uint16 PPR45_8  : 1; /* PPR45_8          */
    const uint16 PPR45_9  : 1; /* PPR45_9          */
    const uint16 PPR45_10 : 1; /* PPR45_10         */
    const uint16 PPR45_11 : 1; /* PPR45_11         */
    const uint16 PPR45_12 : 1; /* PPR45_12         */
    const uint16 PPR45_13 : 1; /* PPR45_13         */
    uint16                : 2; /* Reserved Bits    */
} __type132;
typedef struct
{                       /* Bit Access       */
    uint16 PM45_0  : 1; /* PM45_0           */
    uint16 PM45_1  : 1; /* PM45_1           */
    uint16 PM45_2  : 1; /* PM45_2           */
    uint16 PM45_3  : 1; /* PM45_3           */
    uint16 PM45_4  : 1; /* PM45_4           */
    uint16 PM45_5  : 1; /* PM45_5           */
    uint16 PM45_6  : 1; /* PM45_6           */
    uint16 PM45_7  : 1; /* PM45_7           */
    uint16 PM45_8  : 1; /* PM45_8           */
    uint16 PM45_9  : 1; /* PM45_9           */
    uint16 PM45_10 : 1; /* PM45_10          */
    uint16 PM45_11 : 1; /* PM45_11          */
    uint16 PM45_12 : 1; /* PM45_12          */
    uint16 PM45_13 : 1; /* PM45_13          */
    uint16         : 2; /* Reserved Bits    */
} __type133;
typedef struct
{                        /* Bit Access       */
    uint16 PMC45_0  : 1; /* PMC45_0          */
    uint16 PMC45_1  : 1; /* PMC45_1          */
    uint16 PMC45_2  : 1; /* PMC45_2          */
    uint16 PMC45_3  : 1; /* PMC45_3          */
    uint16 PMC45_4  : 1; /* PMC45_4          */
    uint16 PMC45_5  : 1; /* PMC45_5          */
    uint16 PMC45_6  : 1; /* PMC45_6          */
    uint16 PMC45_7  : 1; /* PMC45_7          */
    uint16 PMC45_8  : 1; /* PMC45_8          */
    uint16 PMC45_9  : 1; /* PMC45_9          */
    uint16 PMC45_10 : 1; /* PMC45_10         */
    uint16 PMC45_11 : 1; /* PMC45_11         */
    uint16 PMC45_12 : 1; /* PMC45_12         */
    uint16 PMC45_13 : 1; /* PMC45_13         */
    uint16          : 2; /* Reserved Bits    */
} __type134;
typedef struct
{                        /* Bit Access       */
    uint16 PFC45_0  : 1; /* PFC45_0          */
    uint16 PFC45_1  : 1; /* PFC45_1          */
    uint16 PFC45_2  : 1; /* PFC45_2          */
    uint16 PFC45_3  : 1; /* PFC45_3          */
    uint16 PFC45_4  : 1; /* PFC45_4          */
    uint16 PFC45_5  : 1; /* PFC45_5          */
    uint16 PFC45_6  : 1; /* PFC45_6          */
    uint16 PFC45_7  : 1; /* PFC45_7          */
    uint16 PFC45_8  : 1; /* PFC45_8          */
    uint16 PFC45_9  : 1; /* PFC45_9          */
    uint16 PFC45_10 : 1; /* PFC45_10         */
    uint16 PFC45_11 : 1; /* PFC45_11         */
    uint16 PFC45_12 : 1; /* PFC45_12         */
    uint16 PFC45_13 : 1; /* PFC45_13         */
    uint16          : 2; /* Reserved Bits    */
} __type135;
typedef struct
{                         /* Bit Access       */
    uint16 PFCE45_0  : 1; /* PFCE45_0         */
    uint16 PFCE45_1  : 1; /* PFCE45_1         */
    uint16 PFCE45_2  : 1; /* PFCE45_2         */
    uint16 PFCE45_3  : 1; /* PFCE45_3         */
    uint16 PFCE45_4  : 1; /* PFCE45_4         */
    uint16 PFCE45_5  : 1; /* PFCE45_5         */
    uint16 PFCE45_6  : 1; /* PFCE45_6         */
    uint16 PFCE45_7  : 1; /* PFCE45_7         */
    uint16 PFCE45_8  : 1; /* PFCE45_8         */
    uint16 PFCE45_9  : 1; /* PFCE45_9         */
    uint16 PFCE45_10 : 1; /* PFCE45_10        */
    uint16 PFCE45_11 : 1; /* PFCE45_11        */
    uint16 PFCE45_12 : 1; /* PFCE45_12        */
    uint16 PFCE45_13 : 1; /* PFCE45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type136;
typedef struct
{                         /* Bit Access       */
    uint32 PMSR45_0  : 1; /* PMSR45_0         */
    uint32 PMSR45_1  : 1; /* PMSR45_1         */
    uint32 PMSR45_2  : 1; /* PMSR45_2         */
    uint32 PMSR45_3  : 1; /* PMSR45_3         */
    uint32 PMSR45_4  : 1; /* PMSR45_4         */
    uint32 PMSR45_5  : 1; /* PMSR45_5         */
    uint32 PMSR45_6  : 1; /* PMSR45_6         */
    uint32 PMSR45_7  : 1; /* PMSR45_7         */
    uint32 PMSR45_8  : 1; /* PMSR45_8         */
    uint32 PMSR45_9  : 1; /* PMSR45_9         */
    uint32 PMSR45_10 : 1; /* PMSR45_10        */
    uint32 PMSR45_11 : 1; /* PMSR45_11        */
    uint32 PMSR45_12 : 1; /* PMSR45_12        */
    uint32 PMSR45_13 : 1; /* PMSR45_13        */
    uint32           : 2; /* Reserved Bits    */
    uint32 PMSR45_16 : 1; /* PMSR45_16        */
    uint32 PMSR45_17 : 1; /* PMSR45_17        */
    uint32 PMSR45_18 : 1; /* PMSR45_18        */
    uint32 PMSR45_19 : 1; /* PMSR45_19        */
    uint32 PMSR45_20 : 1; /* PMSR45_20        */
    uint32 PMSR45_21 : 1; /* PMSR45_21        */
    uint32 PMSR45_22 : 1; /* PMSR45_22        */
    uint32 PMSR45_23 : 1; /* PMSR45_23        */
    uint32 PMSR45_24 : 1; /* PMSR45_24        */
    uint32 PMSR45_25 : 1; /* PMSR45_25        */
    uint32 PMSR45_26 : 1; /* PMSR45_26        */
    uint32 PMSR45_27 : 1; /* PMSR45_27        */
    uint32 PMSR45_28 : 1; /* PMSR45_28        */
    uint32 PMSR45_29 : 1; /* PMSR45_29        */
    uint32           : 2; /* Reserved Bits    */
} __type137;
typedef struct
{                          /* Bit Access       */
    uint32 PMCSR45_0  : 1; /* PMCSR45_0        */
    uint32 PMCSR45_1  : 1; /* PMCSR45_1        */
    uint32 PMCSR45_2  : 1; /* PMCSR45_2        */
    uint32 PMCSR45_3  : 1; /* PMCSR45_3        */
    uint32 PMCSR45_4  : 1; /* PMCSR45_4        */
    uint32 PMCSR45_5  : 1; /* PMCSR45_5        */
    uint32 PMCSR45_6  : 1; /* PMCSR45_6        */
    uint32 PMCSR45_7  : 1; /* PMCSR45_7        */
    uint32 PMCSR45_8  : 1; /* PMCSR45_8        */
    uint32 PMCSR45_9  : 1; /* PMCSR45_9        */
    uint32 PMCSR45_10 : 1; /* PMCSR45_10       */
    uint32 PMCSR45_11 : 1; /* PMCSR45_11       */
    uint32 PMCSR45_12 : 1; /* PMCSR45_12       */
    uint32 PMCSR45_13 : 1; /* PMCSR45_13       */
    uint32            : 2; /* Reserved Bits    */
    uint32 PMCSR45_16 : 1; /* PMCSR45_16       */
    uint32 PMCSR45_17 : 1; /* PMCSR45_17       */
    uint32 PMCSR45_18 : 1; /* PMCSR45_18       */
    uint32 PMCSR45_19 : 1; /* PMCSR45_19       */
    uint32 PMCSR45_20 : 1; /* PMCSR45_20       */
    uint32 PMCSR45_21 : 1; /* PMCSR45_21       */
    uint32 PMCSR45_22 : 1; /* PMCSR45_22       */
    uint32 PMCSR45_23 : 1; /* PMCSR45_23       */
    uint32 PMCSR45_24 : 1; /* PMCSR45_24       */
    uint32 PMCSR45_25 : 1; /* PMCSR45_25       */
    uint32 PMCSR45_26 : 1; /* PMCSR45_26       */
    uint32 PMCSR45_27 : 1; /* PMCSR45_27       */
    uint32 PMCSR45_28 : 1; /* PMCSR45_28       */
    uint32 PMCSR45_29 : 1; /* PMCSR45_29       */
    uint32            : 2; /* Reserved Bits    */
} __type138;
typedef struct
{                         /* Bit Access       */
    uint16 PINV45_0  : 1; /* PINV45_0         */
    uint16 PINV45_1  : 1; /* PINV45_1         */
    uint16 PINV45_2  : 1; /* PINV45_2         */
    uint16 PINV45_3  : 1; /* PINV45_3         */
    uint16 PINV45_4  : 1; /* PINV45_4         */
    uint16 PINV45_5  : 1; /* PINV45_5         */
    uint16 PINV45_6  : 1; /* PINV45_6         */
    uint16 PINV45_7  : 1; /* PINV45_7         */
    uint16 PINV45_8  : 1; /* PINV45_8         */
    uint16 PINV45_9  : 1; /* PINV45_9         */
    uint16 PINV45_10 : 1; /* PINV45_10        */
    uint16 PINV45_11 : 1; /* PINV45_11        */
    uint16 PINV45_12 : 1; /* PINV45_12        */
    uint16 PINV45_13 : 1; /* PINV45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type139;
typedef struct
{                         /* Bit Access       */
    uint32 PFC       : 1; /* PFC              */
    uint32 PFCE      : 1; /* PFCE             */
    uint32           : 2; /* Reserved Bits    */
    uint32 PM        : 1; /* PM               */
    uint32 PIPC      : 1; /* PIPC             */
    uint32 PMC       : 1; /* PMC              */
    uint32           : 1; /* Reserved Bits    */
    const uint32 PPR : 1; /* PPR              */
    uint32           : 3; /* Reserved Bits    */
    uint32 P         : 1; /* P                */
    uint32           : 3; /* Reserved Bits    */
    uint32 PIBC      : 1; /* PIBC             */
    uint32 PBDC      : 1; /* PBDC             */
    uint32 PD        : 1; /* PD               */
    uint32 PU        : 1; /* PU               */
    uint32 PIS       : 1; /* PIS              */
    uint32           : 1; /* Reserved Bits    */
    uint32 PISA      : 1; /* PISA             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PDSC      : 1; /* PDSC             */
    uint32           : 3; /* Reserved Bits    */
    uint32 PODC      : 1; /* PODC             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PINV      : 1; /* PINV             */
    uint32           : 1; /* Reserved Bits    */
} __type140;
typedef struct
{                         /* Bit Access       */
    uint32 PFC       : 1; /* PFC              */
    uint32 PFCE      : 1; /* PFCE             */
    uint32           : 2; /* Reserved Bits    */
    uint32 PM        : 1; /* PM               */
    uint32           : 1; /* Reserved Bits    */
    uint32 PMC       : 1; /* PMC              */
    uint32           : 1; /* Reserved Bits    */
    const uint32 PPR : 1; /* PPR              */
    uint32           : 3; /* Reserved Bits    */
    uint32 P         : 1; /* P                */
    uint32           : 3; /* Reserved Bits    */
    uint32 PIBC      : 1; /* PIBC             */
    uint32 PBDC      : 1; /* PBDC             */
    uint32 PD        : 1; /* PD               */
    uint32 PU        : 1; /* PU               */
    uint32 PIS       : 1; /* PIS              */
    uint32           : 1; /* Reserved Bits    */
    uint32 PISA      : 1; /* PISA             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PDSC      : 1; /* PDSC             */
    uint32           : 3; /* Reserved Bits    */
    uint32 PODC      : 1; /* PODC             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PINV      : 1; /* PINV             */
    uint32           : 1; /* Reserved Bits    */
} __type141;
typedef struct
{                          /* Bit Access       */
    uint32 PFC       : 1;  /* PFC              */
    uint32 PFCE      : 1;  /* PFCE             */
    uint32           : 2;  /* Reserved Bits    */
    uint32 PM        : 1;  /* PM               */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PMC       : 1;  /* PMC              */
    uint32           : 1;  /* Reserved Bits    */
    const uint32 PPR : 1;  /* PPR              */
    uint32           : 3;  /* Reserved Bits    */
    uint32 P         : 1;  /* P                */
    uint32           : 3;  /* Reserved Bits    */
    uint32 PIBC      : 1;  /* PIBC             */
    uint32 PBDC      : 1;  /* PBDC             */
    uint32           : 10; /* Reserved Bits    */
    uint32 PODC      : 1;  /* PODC             */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PINV      : 1;  /* PINV             */
    uint32           : 1;  /* Reserved Bits    */
} __type142;
typedef struct
{                          /* Bit Access       */
    uint32 PFC       : 1;  /* PFC              */
    uint32           : 3;  /* Reserved Bits    */
    uint32 PM        : 1;  /* PM               */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PMC       : 1;  /* PMC              */
    uint32           : 1;  /* Reserved Bits    */
    const uint32 PPR : 1;  /* PPR              */
    uint32           : 3;  /* Reserved Bits    */
    uint32 P         : 1;  /* P                */
    uint32           : 3;  /* Reserved Bits    */
    uint32 PIBC      : 1;  /* PIBC             */
    uint32 PBDC      : 1;  /* PBDC             */
    uint32           : 10; /* Reserved Bits    */
    uint32 PODC      : 1;  /* PODC             */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PINV      : 1;  /* PINV             */
    uint32           : 1;  /* Reserved Bits    */
} __type143;
typedef struct
{                         /* Bit Access       */
    uint32 PFC       : 1; /* PFC              */
    uint32 PFCE      : 1; /* PFCE             */
    uint32           : 2; /* Reserved Bits    */
    uint32 PM        : 1; /* PM               */
    uint32 PIPC      : 1; /* PIPC             */
    uint32 PMC       : 1; /* PMC              */
    uint32           : 1; /* Reserved Bits    */
    const uint32 PPR : 1; /* PPR              */
    uint32           : 3; /* Reserved Bits    */
    uint32 P         : 1; /* P                */
    uint32           : 3; /* Reserved Bits    */
    uint32 PIBC      : 1; /* PIBC             */
    uint32 PBDC      : 1; /* PBDC             */
    uint32           : 2; /* Reserved Bits    */
    uint32 PIS       : 1; /* PIS              */
    uint32           : 1; /* Reserved Bits    */
    uint32 PISA      : 1; /* PISA             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PDSC      : 1; /* PDSC             */
    uint32           : 3; /* Reserved Bits    */
    uint32 PODC      : 1; /* PODC             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PINV      : 1; /* PINV             */
    uint32           : 1; /* Reserved Bits    */
} __type144;
typedef struct
{                         /* Bit Access       */
    uint32 PFC       : 1; /* PFC              */
    uint32           : 3; /* Reserved Bits    */
    uint32 PM        : 1; /* PM               */
    uint32 PIPC      : 1; /* PIPC             */
    uint32 PMC       : 1; /* PMC              */
    uint32           : 1; /* Reserved Bits    */
    const uint32 PPR : 1; /* PPR              */
    uint32           : 3; /* Reserved Bits    */
    uint32 P         : 1; /* P                */
    uint32           : 3; /* Reserved Bits    */
    uint32 PIBC      : 1; /* PIBC             */
    uint32 PBDC      : 1; /* PBDC             */
    uint32           : 2; /* Reserved Bits    */
    uint32 PIS       : 1; /* PIS              */
    uint32           : 1; /* Reserved Bits    */
    uint32 PISA      : 1; /* PISA             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PDSC      : 1; /* PDSC             */
    uint32           : 3; /* Reserved Bits    */
    uint32 PODC      : 1; /* PODC             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PINV      : 1; /* PINV             */
    uint32           : 1; /* Reserved Bits    */
} __type145;
typedef struct
{                         /* Bit Access       */
    uint32 PFC       : 1; /* PFC              */
    uint32           : 3; /* Reserved Bits    */
    uint32 PM        : 1; /* PM               */
    uint32           : 1; /* Reserved Bits    */
    uint32 PMC       : 1; /* PMC              */
    uint32           : 1; /* Reserved Bits    */
    const uint32 PPR : 1; /* PPR              */
    uint32           : 3; /* Reserved Bits    */
    uint32 P         : 1; /* P                */
    uint32           : 3; /* Reserved Bits    */
    uint32 PIBC      : 1; /* PIBC             */
    uint32 PBDC      : 1; /* PBDC             */
    uint32 PD        : 1; /* PD               */
    uint32 PU        : 1; /* PU               */
    uint32           : 8; /* Reserved Bits    */
    uint32 PODC      : 1; /* PODC             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PINV      : 1; /* PINV             */
    uint32           : 1; /* Reserved Bits    */
} __type146;
typedef struct
{                         /* Bit Access       */
    uint32 PFC       : 1; /* PFC              */
    uint32           : 3; /* Reserved Bits    */
    uint32 PM        : 1; /* PM               */
    uint32 PIPC      : 1; /* PIPC             */
    uint32 PMC       : 1; /* PMC              */
    uint32           : 1; /* Reserved Bits    */
    const uint32 PPR : 1; /* PPR              */
    uint32           : 3; /* Reserved Bits    */
    uint32 P         : 1; /* P                */
    uint32           : 3; /* Reserved Bits    */
    uint32 PIBC      : 1; /* PIBC             */
    uint32 PBDC      : 1; /* PBDC             */
    uint32 PD        : 1; /* PD               */
    uint32 PU        : 1; /* PU               */
    uint32           : 8; /* Reserved Bits    */
    uint32 PODC      : 1; /* PODC             */
    uint32           : 1; /* Reserved Bits    */
    uint32 PINV      : 1; /* PINV             */
    uint32           : 1; /* Reserved Bits    */
} __type147;
typedef struct
{                        /* Bit Access       */
    uint16 PIBC1_0 : 1;  /* PIBC1_0          */
    uint16 PIBC1_1 : 1;  /* PIBC1_1          */
    uint16 PIBC1_2 : 1;  /* PIBC1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type148;
typedef struct
{                        /* Bit Access       */
    uint16 PBDC1_0 : 1;  /* PBDC1_0          */
    uint16 PBDC1_1 : 1;  /* PBDC1_1          */
    uint16 PBDC1_2 : 1;  /* PBDC1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type149;
typedef struct
{                        /* Bit Access       */
    uint16 PIPC1_0 : 1;  /* PIPC1_0          */
    uint16         : 1;  /* Reserved Bits    */
    uint16 PIPC1_2 : 1;  /* PIPC1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type150;
typedef struct
{                      /* Bit Access       */
    uint16 PU1_0 : 1;  /* PU1_0            */
    uint16 PU1_1 : 1;  /* PU1_1            */
    uint16 PU1_2 : 1;  /* PU1_2            */
    uint16       : 13; /* Reserved Bits    */
} __type151;
typedef struct
{                      /* Bit Access       */
    uint16 PD1_0 : 1;  /* PD1_0            */
    uint16 PD1_1 : 1;  /* PD1_1            */
    uint16 PD1_2 : 1;  /* PD1_2            */
    uint16       : 13; /* Reserved Bits    */
} __type152;
typedef struct
{                        /* Bit Access       */
    uint32 PODC1_0 : 1;  /* PODC1_0          */
    uint32 PODC1_1 : 1;  /* PODC1_1          */
    uint32 PODC1_2 : 1;  /* PODC1_2          */
    uint32         : 29; /* Reserved Bits    */
} __type153;
typedef struct
{                        /* Bit Access       */
    uint32 PDSC1_0 : 1;  /* PDSC1_0          */
    uint32 PDSC1_1 : 1;  /* PDSC1_1          */
    uint32 PDSC1_2 : 1;  /* PDSC1_2          */
    uint32         : 29; /* Reserved Bits    */
} __type154;
typedef struct
{                       /* Bit Access       */
    uint16 PIS1_0 : 1;  /* PIS1_0           */
    uint16 PIS1_1 : 1;  /* PIS1_1           */
    uint16 PIS1_2 : 1;  /* PIS1_2           */
    uint16        : 13; /* Reserved Bits    */
} __type155;
typedef struct
{                        /* Bit Access       */
    uint16 PISA1_0 : 1;  /* PISA1_0          */
    uint16 PISA1_1 : 1;  /* PISA1_1          */
    uint16 PISA1_2 : 1;  /* PISA1_2          */
    uint16         : 13; /* Reserved Bits    */
} __type156;
typedef struct
{                       /* Bit Access       */
    uint32 PPCMD1 : 8;  /* PPCMD1[7:0]      */
    uint32        : 24; /* Reserved Bits    */
} __type157;
typedef struct
{                                   /* Bit Access       */
    const uint32 PPROTS1PRERR : 1;  /* PPROTS1PRERR     */
    uint32                    : 31; /* Reserved Bits    */
} __type158;
typedef struct
{                       /* Bit Access       */
    uint16         : 2; /* Reserved Bits    */
    uint16 PIBC3_2 : 1; /* PIBC3_2          */
    uint16 PIBC3_3 : 1; /* PIBC3_3          */
    uint16 PIBC3_4 : 1; /* PIBC3_4          */
    uint16 PIBC3_5 : 1; /* PIBC3_5          */
    uint16 PIBC3_6 : 1; /* PIBC3_6          */
    uint16 PIBC3_7 : 1; /* PIBC3_7          */
    uint16 PIBC3_8 : 1; /* PIBC3_8          */
    uint16 PIBC3_9 : 1; /* PIBC3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type159;
typedef struct
{                       /* Bit Access       */
    uint16         : 2; /* Reserved Bits    */
    uint16 PBDC3_2 : 1; /* PBDC3_2          */
    uint16 PBDC3_3 : 1; /* PBDC3_3          */
    uint16 PBDC3_4 : 1; /* PBDC3_4          */
    uint16 PBDC3_5 : 1; /* PBDC3_5          */
    uint16 PBDC3_6 : 1; /* PBDC3_6          */
    uint16 PBDC3_7 : 1; /* PBDC3_7          */
    uint16 PBDC3_8 : 1; /* PBDC3_8          */
    uint16 PBDC3_9 : 1; /* PBDC3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type160;
typedef struct
{                       /* Bit Access       */
    uint16         : 3; /* Reserved Bits    */
    uint16 PIPC3_3 : 1; /* PIPC3_3          */
    uint16 PIPC3_4 : 1; /* PIPC3_4          */
    uint16 PIPC3_5 : 1; /* PIPC3_5          */
    uint16 PIPC3_6 : 1; /* PIPC3_6          */
    uint16 PIPC3_7 : 1; /* PIPC3_7          */
    uint16 PIPC3_8 : 1; /* PIPC3_8          */
    uint16 PIPC3_9 : 1; /* PIPC3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type161;
typedef struct
{                     /* Bit Access       */
    uint16       : 2; /* Reserved Bits    */
    uint16 PU3_2 : 1; /* PU3_2            */
    uint16 PU3_3 : 1; /* PU3_3            */
    uint16 PU3_4 : 1; /* PU3_4            */
    uint16 PU3_5 : 1; /* PU3_5            */
    uint16 PU3_6 : 1; /* PU3_6            */
    uint16 PU3_7 : 1; /* PU3_7            */
    uint16 PU3_8 : 1; /* PU3_8            */
    uint16 PU3_9 : 1; /* PU3_9            */
    uint16       : 6; /* Reserved Bits    */
} __type162;
typedef struct
{                     /* Bit Access       */
    uint16       : 2; /* Reserved Bits    */
    uint16 PD3_2 : 1; /* PD3_2            */
    uint16 PD3_3 : 1; /* PD3_3            */
    uint16 PD3_4 : 1; /* PD3_4            */
    uint16 PD3_5 : 1; /* PD3_5            */
    uint16 PD3_6 : 1; /* PD3_6            */
    uint16 PD3_7 : 1; /* PD3_7            */
    uint16 PD3_8 : 1; /* PD3_8            */
    uint16 PD3_9 : 1; /* PD3_9            */
    uint16       : 6; /* Reserved Bits    */
} __type163;
typedef struct
{                        /* Bit Access       */
    uint32         : 2;  /* Reserved Bits    */
    uint32 PODC3_2 : 1;  /* PODC3_2          */
    uint32 PODC3_3 : 1;  /* PODC3_3          */
    uint32 PODC3_4 : 1;  /* PODC3_4          */
    uint32 PODC3_5 : 1;  /* PODC3_5          */
    uint32 PODC3_6 : 1;  /* PODC3_6          */
    uint32 PODC3_7 : 1;  /* PODC3_7          */
    uint32 PODC3_8 : 1;  /* PODC3_8          */
    uint32 PODC3_9 : 1;  /* PODC3_9          */
    uint32         : 22; /* Reserved Bits    */
} __type164;
typedef struct
{                        /* Bit Access       */
    uint32         : 2;  /* Reserved Bits    */
    uint32 PDSC3_2 : 1;  /* PDSC3_2          */
    uint32 PDSC3_3 : 1;  /* PDSC3_3          */
    uint32 PDSC3_4 : 1;  /* PDSC3_4          */
    uint32 PDSC3_5 : 1;  /* PDSC3_5          */
    uint32 PDSC3_6 : 1;  /* PDSC3_6          */
    uint32 PDSC3_7 : 1;  /* PDSC3_7          */
    uint32 PDSC3_8 : 1;  /* PDSC3_8          */
    uint32 PDSC3_9 : 1;  /* PDSC3_9          */
    uint32         : 22; /* Reserved Bits    */
} __type165;
typedef struct
{                      /* Bit Access       */
    uint16        : 2; /* Reserved Bits    */
    uint16 PIS3_2 : 1; /* PIS3_2           */
    uint16 PIS3_3 : 1; /* PIS3_3           */
    uint16 PIS3_4 : 1; /* PIS3_4           */
    uint16 PIS3_5 : 1; /* PIS3_5           */
    uint16 PIS3_6 : 1; /* PIS3_6           */
    uint16 PIS3_7 : 1; /* PIS3_7           */
    uint16 PIS3_8 : 1; /* PIS3_8           */
    uint16 PIS3_9 : 1; /* PIS3_9           */
    uint16        : 6; /* Reserved Bits    */
} __type166;
typedef struct
{                       /* Bit Access       */
    uint16         : 2; /* Reserved Bits    */
    uint16 PISA3_2 : 1; /* PISA3_2          */
    uint16 PISA3_3 : 1; /* PISA3_3          */
    uint16 PISA3_4 : 1; /* PISA3_4          */
    uint16 PISA3_5 : 1; /* PISA3_5          */
    uint16 PISA3_6 : 1; /* PISA3_6          */
    uint16 PISA3_7 : 1; /* PISA3_7          */
    uint16 PISA3_8 : 1; /* PISA3_8          */
    uint16 PISA3_9 : 1; /* PISA3_9          */
    uint16         : 6; /* Reserved Bits    */
} __type167;
typedef struct
{                       /* Bit Access       */
    uint32 PPCMD3 : 8;  /* PPCMD3[7:0]      */
    uint32        : 24; /* Reserved Bits    */
} __type168;
typedef struct
{                                   /* Bit Access       */
    const uint32 PPROTS3PRERR : 1;  /* PPROTS3PRERR     */
    uint32                    : 31; /* Reserved Bits    */
} __type169;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC10_0  : 1; /* PIBC10_0         */
    uint16 PIBC10_1  : 1; /* PIBC10_1         */
    uint16 PIBC10_2  : 1; /* PIBC10_2         */
    uint16 PIBC10_3  : 1; /* PIBC10_3         */
    uint16 PIBC10_4  : 1; /* PIBC10_4         */
    uint16 PIBC10_5  : 1; /* PIBC10_5         */
    uint16 PIBC10_6  : 1; /* PIBC10_6         */
    uint16 PIBC10_7  : 1; /* PIBC10_7         */
    uint16 PIBC10_8  : 1; /* PIBC10_8         */
    uint16 PIBC10_9  : 1; /* PIBC10_9         */
    uint16 PIBC10_10 : 1; /* PIBC10_10        */
    uint16 PIBC10_11 : 1; /* PIBC10_11        */
    uint16           : 4; /* Reserved Bits    */
} __type170;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC10_0  : 1; /* PBDC10_0         */
    uint16 PBDC10_1  : 1; /* PBDC10_1         */
    uint16 PBDC10_2  : 1; /* PBDC10_2         */
    uint16 PBDC10_3  : 1; /* PBDC10_3         */
    uint16 PBDC10_4  : 1; /* PBDC10_4         */
    uint16 PBDC10_5  : 1; /* PBDC10_5         */
    uint16 PBDC10_6  : 1; /* PBDC10_6         */
    uint16 PBDC10_7  : 1; /* PBDC10_7         */
    uint16 PBDC10_8  : 1; /* PBDC10_8         */
    uint16 PBDC10_9  : 1; /* PBDC10_9         */
    uint16 PBDC10_10 : 1; /* PBDC10_10        */
    uint16 PBDC10_11 : 1; /* PBDC10_11        */
    uint16           : 4; /* Reserved Bits    */
} __type171;
typedef struct
{                          /* Bit Access       */
    uint32 PODC10_0  : 1;  /* PODC10_0         */
    uint32 PODC10_1  : 1;  /* PODC10_1         */
    uint32 PODC10_2  : 1;  /* PODC10_2         */
    uint32 PODC10_3  : 1;  /* PODC10_3         */
    uint32 PODC10_4  : 1;  /* PODC10_4         */
    uint32 PODC10_5  : 1;  /* PODC10_5         */
    uint32 PODC10_6  : 1;  /* PODC10_6         */
    uint32 PODC10_7  : 1;  /* PODC10_7         */
    uint32 PODC10_8  : 1;  /* PODC10_8         */
    uint32 PODC10_9  : 1;  /* PODC10_9         */
    uint32 PODC10_10 : 1;  /* PODC10_10        */
    uint32 PODC10_11 : 1;  /* PODC10_11        */
    uint32           : 20; /* Reserved Bits    */
} __type172;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD10 : 8;  /* PPCMD10[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type173;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS10PRERR : 1;  /* PPROTS10PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type174;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC11_0 : 1;  /* PIBC11_0         */
    uint16 PIBC11_1 : 1;  /* PIBC11_1         */
    uint16 PIBC11_2 : 1;  /* PIBC11_2         */
    uint16 PIBC11_3 : 1;  /* PIBC11_3         */
    uint16          : 12; /* Reserved Bits    */
} __type175;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC11_0 : 1;  /* PBDC11_0         */
    uint16 PBDC11_1 : 1;  /* PBDC11_1         */
    uint16 PBDC11_2 : 1;  /* PBDC11_2         */
    uint16 PBDC11_3 : 1;  /* PBDC11_3         */
    uint16          : 12; /* Reserved Bits    */
} __type176;
typedef struct
{                         /* Bit Access       */
    uint32 PODC11_0 : 1;  /* PODC11_0         */
    uint32 PODC11_1 : 1;  /* PODC11_1         */
    uint32 PODC11_2 : 1;  /* PODC11_2         */
    uint32 PODC11_3 : 1;  /* PODC11_3         */
    uint32          : 28; /* Reserved Bits    */
} __type177;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD11 : 8;  /* PPCMD11[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type178;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS11PRERR : 1;  /* PPROTS11PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type179;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC16_0  : 1; /* PIBC16_0         */
    uint16 PIBC16_1  : 1; /* PIBC16_1         */
    uint16 PIBC16_2  : 1; /* PIBC16_2         */
    uint16 PIBC16_3  : 1; /* PIBC16_3         */
    uint16 PIBC16_4  : 1; /* PIBC16_4         */
    uint16 PIBC16_5  : 1; /* PIBC16_5         */
    uint16 PIBC16_6  : 1; /* PIBC16_6         */
    uint16 PIBC16_7  : 1; /* PIBC16_7         */
    uint16 PIBC16_8  : 1; /* PIBC16_8         */
    uint16 PIBC16_9  : 1; /* PIBC16_9         */
    uint16 PIBC16_10 : 1; /* PIBC16_10        */
    uint16 PIBC16_11 : 1; /* PIBC16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type180;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC16_0  : 1; /* PBDC16_0         */
    uint16 PBDC16_1  : 1; /* PBDC16_1         */
    uint16 PBDC16_2  : 1; /* PBDC16_2         */
    uint16 PBDC16_3  : 1; /* PBDC16_3         */
    uint16 PBDC16_4  : 1; /* PBDC16_4         */
    uint16 PBDC16_5  : 1; /* PBDC16_5         */
    uint16 PBDC16_6  : 1; /* PBDC16_6         */
    uint16 PBDC16_7  : 1; /* PBDC16_7         */
    uint16 PBDC16_8  : 1; /* PBDC16_8         */
    uint16 PBDC16_9  : 1; /* PBDC16_9         */
    uint16 PBDC16_10 : 1; /* PBDC16_10        */
    uint16 PBDC16_11 : 1; /* PBDC16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type181;
typedef struct
{                         /* Bit Access       */
    uint16 PIPC16_0  : 1; /* PIPC16_0         */
    uint16 PIPC16_1  : 1; /* PIPC16_1         */
    uint16 PIPC16_2  : 1; /* PIPC16_2         */
    uint16 PIPC16_3  : 1; /* PIPC16_3         */
    uint16 PIPC16_4  : 1; /* PIPC16_4         */
    uint16 PIPC16_5  : 1; /* PIPC16_5         */
    uint16 PIPC16_6  : 1; /* PIPC16_6         */
    uint16 PIPC16_7  : 1; /* PIPC16_7         */
    uint16 PIPC16_8  : 1; /* PIPC16_8         */
    uint16 PIPC16_9  : 1; /* PIPC16_9         */
    uint16 PIPC16_10 : 1; /* PIPC16_10        */
    uint16 PIPC16_11 : 1; /* PIPC16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type182;
typedef struct
{                          /* Bit Access       */
    uint32 PODC16_0  : 1;  /* PODC16_0         */
    uint32 PODC16_1  : 1;  /* PODC16_1         */
    uint32 PODC16_2  : 1;  /* PODC16_2         */
    uint32 PODC16_3  : 1;  /* PODC16_3         */
    uint32 PODC16_4  : 1;  /* PODC16_4         */
    uint32 PODC16_5  : 1;  /* PODC16_5         */
    uint32 PODC16_6  : 1;  /* PODC16_6         */
    uint32 PODC16_7  : 1;  /* PODC16_7         */
    uint32 PODC16_8  : 1;  /* PODC16_8         */
    uint32 PODC16_9  : 1;  /* PODC16_9         */
    uint32 PODC16_10 : 1;  /* PODC16_10        */
    uint32 PODC16_11 : 1;  /* PODC16_11        */
    uint32           : 20; /* Reserved Bits    */
} __type183;
typedef struct
{                          /* Bit Access       */
    uint32 PDSC16_0  : 1;  /* PDSC16_0         */
    uint32 PDSC16_1  : 1;  /* PDSC16_1         */
    uint32 PDSC16_2  : 1;  /* PDSC16_2         */
    uint32 PDSC16_3  : 1;  /* PDSC16_3         */
    uint32 PDSC16_4  : 1;  /* PDSC16_4         */
    uint32 PDSC16_5  : 1;  /* PDSC16_5         */
    uint32 PDSC16_6  : 1;  /* PDSC16_6         */
    uint32 PDSC16_7  : 1;  /* PDSC16_7         */
    uint32 PDSC16_8  : 1;  /* PDSC16_8         */
    uint32 PDSC16_9  : 1;  /* PDSC16_9         */
    uint32 PDSC16_10 : 1;  /* PDSC16_10        */
    uint32 PDSC16_11 : 1;  /* PDSC16_11        */
    uint32           : 20; /* Reserved Bits    */
} __type184;
typedef struct
{                        /* Bit Access       */
    uint16 PIS16_0  : 1; /* PIS16_0          */
    uint16 PIS16_1  : 1; /* PIS16_1          */
    uint16 PIS16_2  : 1; /* PIS16_2          */
    uint16 PIS16_3  : 1; /* PIS16_3          */
    uint16 PIS16_4  : 1; /* PIS16_4          */
    uint16 PIS16_5  : 1; /* PIS16_5          */
    uint16 PIS16_6  : 1; /* PIS16_6          */
    uint16 PIS16_7  : 1; /* PIS16_7          */
    uint16 PIS16_8  : 1; /* PIS16_8          */
    uint16 PIS16_9  : 1; /* PIS16_9          */
    uint16 PIS16_10 : 1; /* PIS16_10         */
    uint16 PIS16_11 : 1; /* PIS16_11         */
    uint16          : 4; /* Reserved Bits    */
} __type185;
typedef struct
{                         /* Bit Access       */
    uint16 PISA16_0  : 1; /* PISA16_0         */
    uint16 PISA16_1  : 1; /* PISA16_1         */
    uint16 PISA16_2  : 1; /* PISA16_2         */
    uint16 PISA16_3  : 1; /* PISA16_3         */
    uint16 PISA16_4  : 1; /* PISA16_4         */
    uint16 PISA16_5  : 1; /* PISA16_5         */
    uint16 PISA16_6  : 1; /* PISA16_6         */
    uint16 PISA16_7  : 1; /* PISA16_7         */
    uint16 PISA16_8  : 1; /* PISA16_8         */
    uint16 PISA16_9  : 1; /* PISA16_9         */
    uint16 PISA16_10 : 1; /* PISA16_10        */
    uint16 PISA16_11 : 1; /* PISA16_11        */
    uint16           : 4; /* Reserved Bits    */
} __type186;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD16 : 8;  /* PPCMD16[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type187;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS16PRERR : 1;  /* PPROTS16PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type188;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC17_0  : 1; /* PIBC17_0         */
    uint16 PIBC17_1  : 1; /* PIBC17_1         */
    uint16 PIBC17_2  : 1; /* PIBC17_2         */
    uint16 PIBC17_3  : 1; /* PIBC17_3         */
    uint16 PIBC17_4  : 1; /* PIBC17_4         */
    uint16 PIBC17_5  : 1; /* PIBC17_5         */
    uint16 PIBC17_6  : 1; /* PIBC17_6         */
    uint16 PIBC17_7  : 1; /* PIBC17_7         */
    uint16 PIBC17_8  : 1; /* PIBC17_8         */
    uint16 PIBC17_9  : 1; /* PIBC17_9         */
    uint16 PIBC17_10 : 1; /* PIBC17_10        */
    uint16 PIBC17_11 : 1; /* PIBC17_11        */
    uint16           : 4; /* Reserved Bits    */
} __type189;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC17_0  : 1; /* PBDC17_0         */
    uint16 PBDC17_1  : 1; /* PBDC17_1         */
    uint16 PBDC17_2  : 1; /* PBDC17_2         */
    uint16 PBDC17_3  : 1; /* PBDC17_3         */
    uint16 PBDC17_4  : 1; /* PBDC17_4         */
    uint16 PBDC17_5  : 1; /* PBDC17_5         */
    uint16 PBDC17_6  : 1; /* PBDC17_6         */
    uint16 PBDC17_7  : 1; /* PBDC17_7         */
    uint16 PBDC17_8  : 1; /* PBDC17_8         */
    uint16 PBDC17_9  : 1; /* PBDC17_9         */
    uint16 PBDC17_10 : 1; /* PBDC17_10        */
    uint16 PBDC17_11 : 1; /* PBDC17_11        */
    uint16           : 4; /* Reserved Bits    */
} __type190;
typedef struct
{                         /* Bit Access       */
    uint16 PIPC17_0  : 1; /* PIPC17_0         */
    uint16 PIPC17_1  : 1; /* PIPC17_1         */
    uint16 PIPC17_2  : 1; /* PIPC17_2         */
    uint16 PIPC17_3  : 1; /* PIPC17_3         */
    uint16 PIPC17_4  : 1; /* PIPC17_4         */
    uint16 PIPC17_5  : 1; /* PIPC17_5         */
    uint16 PIPC17_6  : 1; /* PIPC17_6         */
    uint16 PIPC17_7  : 1; /* PIPC17_7         */
    uint16 PIPC17_8  : 1; /* PIPC17_8         */
    uint16 PIPC17_9  : 1; /* PIPC17_9         */
    uint16 PIPC17_10 : 1; /* PIPC17_10        */
    uint16 PIPC17_11 : 1; /* PIPC17_11        */
    uint16           : 4; /* Reserved Bits    */
} __type191;
typedef struct
{                          /* Bit Access       */
    uint32 PODC17_0  : 1;  /* PODC17_0         */
    uint32 PODC17_1  : 1;  /* PODC17_1         */
    uint32 PODC17_2  : 1;  /* PODC17_2         */
    uint32 PODC17_3  : 1;  /* PODC17_3         */
    uint32 PODC17_4  : 1;  /* PODC17_4         */
    uint32 PODC17_5  : 1;  /* PODC17_5         */
    uint32 PODC17_6  : 1;  /* PODC17_6         */
    uint32 PODC17_7  : 1;  /* PODC17_7         */
    uint32 PODC17_8  : 1;  /* PODC17_8         */
    uint32 PODC17_9  : 1;  /* PODC17_9         */
    uint32 PODC17_10 : 1;  /* PODC17_10        */
    uint32 PODC17_11 : 1;  /* PODC17_11        */
    uint32           : 20; /* Reserved Bits    */
} __type192;
typedef struct
{                          /* Bit Access       */
    uint32 PDSC17_0  : 1;  /* PDSC17_0         */
    uint32 PDSC17_1  : 1;  /* PDSC17_1         */
    uint32 PDSC17_2  : 1;  /* PDSC17_2         */
    uint32 PDSC17_3  : 1;  /* PDSC17_3         */
    uint32 PDSC17_4  : 1;  /* PDSC17_4         */
    uint32 PDSC17_5  : 1;  /* PDSC17_5         */
    uint32 PDSC17_6  : 1;  /* PDSC17_6         */
    uint32 PDSC17_7  : 1;  /* PDSC17_7         */
    uint32 PDSC17_8  : 1;  /* PDSC17_8         */
    uint32 PDSC17_9  : 1;  /* PDSC17_9         */
    uint32 PDSC17_10 : 1;  /* PDSC17_10        */
    uint32 PDSC17_11 : 1;  /* PDSC17_11        */
    uint32           : 20; /* Reserved Bits    */
} __type193;
typedef struct
{                        /* Bit Access       */
    uint16 PIS17_0  : 1; /* PIS17_0          */
    uint16 PIS17_1  : 1; /* PIS17_1          */
    uint16 PIS17_2  : 1; /* PIS17_2          */
    uint16 PIS17_3  : 1; /* PIS17_3          */
    uint16 PIS17_4  : 1; /* PIS17_4          */
    uint16 PIS17_5  : 1; /* PIS17_5          */
    uint16 PIS17_6  : 1; /* PIS17_6          */
    uint16 PIS17_7  : 1; /* PIS17_7          */
    uint16 PIS17_8  : 1; /* PIS17_8          */
    uint16 PIS17_9  : 1; /* PIS17_9          */
    uint16 PIS17_10 : 1; /* PIS17_10         */
    uint16 PIS17_11 : 1; /* PIS17_11         */
    uint16          : 4; /* Reserved Bits    */
} __type194;
typedef struct
{                         /* Bit Access       */
    uint16 PISA17_0  : 1; /* PISA17_0         */
    uint16 PISA17_1  : 1; /* PISA17_1         */
    uint16 PISA17_2  : 1; /* PISA17_2         */
    uint16 PISA17_3  : 1; /* PISA17_3         */
    uint16 PISA17_4  : 1; /* PISA17_4         */
    uint16 PISA17_5  : 1; /* PISA17_5         */
    uint16 PISA17_6  : 1; /* PISA17_6         */
    uint16 PISA17_7  : 1; /* PISA17_7         */
    uint16 PISA17_8  : 1; /* PISA17_8         */
    uint16 PISA17_9  : 1; /* PISA17_9         */
    uint16 PISA17_10 : 1; /* PISA17_10        */
    uint16 PISA17_11 : 1; /* PISA17_11        */
    uint16           : 4; /* Reserved Bits    */
} __type195;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD17 : 8;  /* PPCMD17[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type196;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS17PRERR : 1;  /* PPROTS17PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type197;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC21_0 : 1;  /* PIBC21_0         */
    uint16 PIBC21_1 : 1;  /* PIBC21_1         */
    uint16 PIBC21_2 : 1;  /* PIBC21_2         */
    uint16 PIBC21_3 : 1;  /* PIBC21_3         */
    uint16 PIBC21_4 : 1;  /* PIBC21_4         */
    uint16 PIBC21_5 : 1;  /* PIBC21_5         */
    uint16          : 10; /* Reserved Bits    */
} __type198;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC21_0 : 1;  /* PBDC21_0         */
    uint16 PBDC21_1 : 1;  /* PBDC21_1         */
    uint16 PBDC21_2 : 1;  /* PBDC21_2         */
    uint16 PBDC21_3 : 1;  /* PBDC21_3         */
    uint16 PBDC21_4 : 1;  /* PBDC21_4         */
    uint16 PBDC21_5 : 1;  /* PBDC21_5         */
    uint16          : 10; /* Reserved Bits    */
} __type199;
typedef struct
{                         /* Bit Access       */
    uint16          : 2;  /* Reserved Bits    */
    uint16 PIPC21_2 : 1;  /* PIPC21_2         */
    uint16 PIPC21_3 : 1;  /* PIPC21_3         */
    uint16 PIPC21_4 : 1;  /* PIPC21_4         */
    uint16 PIPC21_5 : 1;  /* PIPC21_5         */
    uint16          : 10; /* Reserved Bits    */
} __type200;
typedef struct
{                       /* Bit Access       */
    uint16 PU21_0 : 1;  /* PU21_0           */
    uint16 PU21_1 : 1;  /* PU21_1           */
    uint16 PU21_2 : 1;  /* PU21_2           */
    uint16 PU21_3 : 1;  /* PU21_3           */
    uint16 PU21_4 : 1;  /* PU21_4           */
    uint16 PU21_5 : 1;  /* PU21_5           */
    uint16        : 10; /* Reserved Bits    */
} __type201;
typedef struct
{                       /* Bit Access       */
    uint16 PD21_0 : 1;  /* PD21_0           */
    uint16 PD21_1 : 1;  /* PD21_1           */
    uint16 PD21_2 : 1;  /* PD21_2           */
    uint16 PD21_3 : 1;  /* PD21_3           */
    uint16 PD21_4 : 1;  /* PD21_4           */
    uint16 PD21_5 : 1;  /* PD21_5           */
    uint16        : 10; /* Reserved Bits    */
} __type202;
typedef struct
{                         /* Bit Access       */
    uint32 PODC21_0 : 1;  /* PODC21_0         */
    uint32 PODC21_1 : 1;  /* PODC21_1         */
    uint32 PODC21_2 : 1;  /* PODC21_2         */
    uint32 PODC21_3 : 1;  /* PODC21_3         */
    uint32 PODC21_4 : 1;  /* PODC21_4         */
    uint32 PODC21_5 : 1;  /* PODC21_5         */
    uint32          : 26; /* Reserved Bits    */
} __type203;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD21 : 8;  /* PPCMD21[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type204;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS21PRERR : 1;  /* PPROTS21PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type205;
typedef struct
{                         /* Bit Access       */
    uint16           : 7; /* Reserved Bits    */
    uint16 PIBC42_7  : 1; /* PIBC42_7         */
    uint16 PIBC42_8  : 1; /* PIBC42_8         */
    uint16 PIBC42_9  : 1; /* PIBC42_9         */
    uint16 PIBC42_10 : 1; /* PIBC42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type206;
typedef struct
{                         /* Bit Access       */
    uint16           : 7; /* Reserved Bits    */
    uint16 PBDC42_7  : 1; /* PBDC42_7         */
    uint16 PBDC42_8  : 1; /* PBDC42_8         */
    uint16 PBDC42_9  : 1; /* PBDC42_9         */
    uint16 PBDC42_10 : 1; /* PBDC42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type207;
typedef struct
{                         /* Bit Access       */
    uint16           : 8; /* Reserved Bits    */
    uint16 PIPC42_8  : 1; /* PIPC42_8         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PIPC42_10 : 1; /* PIPC42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type208;
typedef struct
{                       /* Bit Access       */
    uint16         : 7; /* Reserved Bits    */
    uint16 PU42_7  : 1; /* PU42_7           */
    uint16 PU42_8  : 1; /* PU42_8           */
    uint16 PU42_9  : 1; /* PU42_9           */
    uint16 PU42_10 : 1; /* PU42_10          */
    uint16         : 5; /* Reserved Bits    */
} __type209;
typedef struct
{                       /* Bit Access       */
    uint16         : 7; /* Reserved Bits    */
    uint16 PD42_7  : 1; /* PD42_7           */
    uint16 PD42_8  : 1; /* PD42_8           */
    uint16 PD42_9  : 1; /* PD42_9           */
    uint16 PD42_10 : 1; /* PD42_10          */
    uint16         : 5; /* Reserved Bits    */
} __type210;
typedef struct
{                          /* Bit Access       */
    uint32           : 7;  /* Reserved Bits    */
    uint32 PODC42_7  : 1;  /* PODC42_7         */
    uint32 PODC42_8  : 1;  /* PODC42_8         */
    uint32 PODC42_9  : 1;  /* PODC42_9         */
    uint32 PODC42_10 : 1;  /* PODC42_10        */
    uint32           : 21; /* Reserved Bits    */
} __type211;
typedef struct
{                          /* Bit Access       */
    uint32           : 7;  /* Reserved Bits    */
    uint32 PDSC42_7  : 1;  /* PDSC42_7         */
    uint32 PDSC42_8  : 1;  /* PDSC42_8         */
    uint32 PDSC42_9  : 1;  /* PDSC42_9         */
    uint32 PDSC42_10 : 1;  /* PDSC42_10        */
    uint32           : 21; /* Reserved Bits    */
} __type212;
typedef struct
{                        /* Bit Access       */
    uint16          : 7; /* Reserved Bits    */
    uint16 PIS42_7  : 1; /* PIS42_7          */
    uint16 PIS42_8  : 1; /* PIS42_8          */
    uint16 PIS42_9  : 1; /* PIS42_9          */
    uint16 PIS42_10 : 1; /* PIS42_10         */
    uint16          : 5; /* Reserved Bits    */
} __type213;
typedef struct
{                         /* Bit Access       */
    uint16           : 7; /* Reserved Bits    */
    uint16 PISA42_7  : 1; /* PISA42_7         */
    uint16 PISA42_8  : 1; /* PISA42_8         */
    uint16 PISA42_9  : 1; /* PISA42_9         */
    uint16 PISA42_10 : 1; /* PISA42_10        */
    uint16           : 5; /* Reserved Bits    */
} __type214;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD42 : 8;  /* PPCMD42[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type215;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS42PRERR : 1;  /* PPROTS42PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type216;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC43_0 : 1;  /* PIBC43_0         */
    uint16 PIBC43_1 : 1;  /* PIBC43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type217;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC43_0 : 1;  /* PBDC43_0         */
    uint16 PBDC43_1 : 1;  /* PBDC43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type218;
typedef struct
{                         /* Bit Access       */
    uint16 PIPC43_0 : 1;  /* PIPC43_0         */
    uint16 PIPC43_1 : 1;  /* PIPC43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type219;
typedef struct
{                       /* Bit Access       */
    uint16 PU43_0 : 1;  /* PU43_0           */
    uint16 PU43_1 : 1;  /* PU43_1           */
    uint16        : 14; /* Reserved Bits    */
} __type220;
typedef struct
{                       /* Bit Access       */
    uint16 PD43_0 : 1;  /* PD43_0           */
    uint16 PD43_1 : 1;  /* PD43_1           */
    uint16        : 14; /* Reserved Bits    */
} __type221;
typedef struct
{                         /* Bit Access       */
    uint32 PODC43_0 : 1;  /* PODC43_0         */
    uint32 PODC43_1 : 1;  /* PODC43_1         */
    uint32          : 30; /* Reserved Bits    */
} __type222;
typedef struct
{                         /* Bit Access       */
    uint32 PDSC43_0 : 1;  /* PDSC43_0         */
    uint32 PDSC43_1 : 1;  /* PDSC43_1         */
    uint32          : 30; /* Reserved Bits    */
} __type223;
typedef struct
{                        /* Bit Access       */
    uint16 PIS43_0 : 1;  /* PIS43_0          */
    uint16 PIS43_1 : 1;  /* PIS43_1          */
    uint16         : 14; /* Reserved Bits    */
} __type224;
typedef struct
{                         /* Bit Access       */
    uint16 PISA43_0 : 1;  /* PISA43_0         */
    uint16 PISA43_1 : 1;  /* PISA43_1         */
    uint16          : 14; /* Reserved Bits    */
} __type225;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD43 : 8;  /* PPCMD43[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type226;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS43PRERR : 1;  /* PPROTS43PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type227;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PIBC44_1  : 1; /* PIBC44_1         */
    uint16 PIBC44_2  : 1; /* PIBC44_2         */
    uint16 PIBC44_3  : 1; /* PIBC44_3         */
    uint16 PIBC44_4  : 1; /* PIBC44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PIBC44_6  : 1; /* PIBC44_6         */
    uint16 PIBC44_7  : 1; /* PIBC44_7         */
    uint16 PIBC44_8  : 1; /* PIBC44_8         */
    uint16 PIBC44_9  : 1; /* PIBC44_9         */
    uint16 PIBC44_10 : 1; /* PIBC44_10        */
    uint16 PIBC44_11 : 1; /* PIBC44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type228;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PBDC44_1  : 1; /* PBDC44_1         */
    uint16 PBDC44_2  : 1; /* PBDC44_2         */
    uint16 PBDC44_3  : 1; /* PBDC44_3         */
    uint16 PBDC44_4  : 1; /* PBDC44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PBDC44_6  : 1; /* PBDC44_6         */
    uint16 PBDC44_7  : 1; /* PBDC44_7         */
    uint16 PBDC44_8  : 1; /* PBDC44_8         */
    uint16 PBDC44_9  : 1; /* PBDC44_9         */
    uint16 PBDC44_10 : 1; /* PBDC44_10        */
    uint16 PBDC44_11 : 1; /* PBDC44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type229;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PIPC44_1  : 1; /* PIPC44_1         */
    uint16 PIPC44_2  : 1; /* PIPC44_2         */
    uint16 PIPC44_3  : 1; /* PIPC44_3         */
    uint16 PIPC44_4  : 1; /* PIPC44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PIPC44_6  : 1; /* PIPC44_6         */
    uint16 PIPC44_7  : 1; /* PIPC44_7         */
    uint16 PIPC44_8  : 1; /* PIPC44_8         */
    uint16 PIPC44_9  : 1; /* PIPC44_9         */
    uint16 PIPC44_10 : 1; /* PIPC44_10        */
    uint16 PIPC44_11 : 1; /* PIPC44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type230;
typedef struct
{                       /* Bit Access       */
    uint16         : 1; /* Reserved Bits    */
    uint16 PU44_1  : 1; /* PU44_1           */
    uint16 PU44_2  : 1; /* PU44_2           */
    uint16 PU44_3  : 1; /* PU44_3           */
    uint16 PU44_4  : 1; /* PU44_4           */
    uint16         : 1; /* Reserved Bits    */
    uint16 PU44_6  : 1; /* PU44_6           */
    uint16 PU44_7  : 1; /* PU44_7           */
    uint16 PU44_8  : 1; /* PU44_8           */
    uint16 PU44_9  : 1; /* PU44_9           */
    uint16 PU44_10 : 1; /* PU44_10          */
    uint16 PU44_11 : 1; /* PU44_11          */
    uint16         : 4; /* Reserved Bits    */
} __type231;
typedef struct
{                       /* Bit Access       */
    uint16         : 1; /* Reserved Bits    */
    uint16 PD44_1  : 1; /* PD44_1           */
    uint16 PD44_2  : 1; /* PD44_2           */
    uint16 PD44_3  : 1; /* PD44_3           */
    uint16 PD44_4  : 1; /* PD44_4           */
    uint16         : 1; /* Reserved Bits    */
    uint16 PD44_6  : 1; /* PD44_6           */
    uint16 PD44_7  : 1; /* PD44_7           */
    uint16 PD44_8  : 1; /* PD44_8           */
    uint16 PD44_9  : 1; /* PD44_9           */
    uint16 PD44_10 : 1; /* PD44_10          */
    uint16 PD44_11 : 1; /* PD44_11          */
    uint16         : 4; /* Reserved Bits    */
} __type232;
typedef struct
{                          /* Bit Access       */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PODC44_1  : 1;  /* PODC44_1         */
    uint32 PODC44_2  : 1;  /* PODC44_2         */
    uint32 PODC44_3  : 1;  /* PODC44_3         */
    uint32 PODC44_4  : 1;  /* PODC44_4         */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PODC44_6  : 1;  /* PODC44_6         */
    uint32 PODC44_7  : 1;  /* PODC44_7         */
    uint32 PODC44_8  : 1;  /* PODC44_8         */
    uint32 PODC44_9  : 1;  /* PODC44_9         */
    uint32 PODC44_10 : 1;  /* PODC44_10        */
    uint32 PODC44_11 : 1;  /* PODC44_11        */
    uint32           : 20; /* Reserved Bits    */
} __type233;
typedef struct
{                          /* Bit Access       */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PDSC44_1  : 1;  /* PDSC44_1         */
    uint32 PDSC44_2  : 1;  /* PDSC44_2         */
    uint32 PDSC44_3  : 1;  /* PDSC44_3         */
    uint32 PDSC44_4  : 1;  /* PDSC44_4         */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PDSC44_6  : 1;  /* PDSC44_6         */
    uint32 PDSC44_7  : 1;  /* PDSC44_7         */
    uint32 PDSC44_8  : 1;  /* PDSC44_8         */
    uint32 PDSC44_9  : 1;  /* PDSC44_9         */
    uint32 PDSC44_10 : 1;  /* PDSC44_10        */
    uint32 PDSC44_11 : 1;  /* PDSC44_11        */
    uint32           : 20; /* Reserved Bits    */
} __type234;
typedef struct
{                        /* Bit Access       */
    uint16          : 1; /* Reserved Bits    */
    uint16 PIS44_1  : 1; /* PIS44_1          */
    uint16 PIS44_2  : 1; /* PIS44_2          */
    uint16 PIS44_3  : 1; /* PIS44_3          */
    uint16 PIS44_4  : 1; /* PIS44_4          */
    uint16          : 1; /* Reserved Bits    */
    uint16 PIS44_6  : 1; /* PIS44_6          */
    uint16 PIS44_7  : 1; /* PIS44_7          */
    uint16 PIS44_8  : 1; /* PIS44_8          */
    uint16 PIS44_9  : 1; /* PIS44_9          */
    uint16 PIS44_10 : 1; /* PIS44_10         */
    uint16 PIS44_11 : 1; /* PIS44_11         */
    uint16          : 4; /* Reserved Bits    */
} __type235;
typedef struct
{                         /* Bit Access       */
    uint16           : 1; /* Reserved Bits    */
    uint16 PISA44_1  : 1; /* PISA44_1         */
    uint16 PISA44_2  : 1; /* PISA44_2         */
    uint16 PISA44_3  : 1; /* PISA44_3         */
    uint16 PISA44_4  : 1; /* PISA44_4         */
    uint16           : 1; /* Reserved Bits    */
    uint16 PISA44_6  : 1; /* PISA44_6         */
    uint16 PISA44_7  : 1; /* PISA44_7         */
    uint16 PISA44_8  : 1; /* PISA44_8         */
    uint16 PISA44_9  : 1; /* PISA44_9         */
    uint16 PISA44_10 : 1; /* PISA44_10        */
    uint16 PISA44_11 : 1; /* PISA44_11        */
    uint16           : 4; /* Reserved Bits    */
} __type236;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD44 : 8;  /* PPCMD44[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type237;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS44PRERR : 1;  /* PPROTS44PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type238;
typedef struct
{                         /* Bit Access       */
    uint16 PIBC45_0  : 1; /* PIBC45_0         */
    uint16 PIBC45_1  : 1; /* PIBC45_1         */
    uint16 PIBC45_2  : 1; /* PIBC45_2         */
    uint16 PIBC45_3  : 1; /* PIBC45_3         */
    uint16 PIBC45_4  : 1; /* PIBC45_4         */
    uint16 PIBC45_5  : 1; /* PIBC45_5         */
    uint16 PIBC45_6  : 1; /* PIBC45_6         */
    uint16 PIBC45_7  : 1; /* PIBC45_7         */
    uint16 PIBC45_8  : 1; /* PIBC45_8         */
    uint16 PIBC45_9  : 1; /* PIBC45_9         */
    uint16 PIBC45_10 : 1; /* PIBC45_10        */
    uint16 PIBC45_11 : 1; /* PIBC45_11        */
    uint16 PIBC45_12 : 1; /* PIBC45_12        */
    uint16 PIBC45_13 : 1; /* PIBC45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type239;
typedef struct
{                         /* Bit Access       */
    uint16 PBDC45_0  : 1; /* PBDC45_0         */
    uint16 PBDC45_1  : 1; /* PBDC45_1         */
    uint16 PBDC45_2  : 1; /* PBDC45_2         */
    uint16 PBDC45_3  : 1; /* PBDC45_3         */
    uint16 PBDC45_4  : 1; /* PBDC45_4         */
    uint16 PBDC45_5  : 1; /* PBDC45_5         */
    uint16 PBDC45_6  : 1; /* PBDC45_6         */
    uint16 PBDC45_7  : 1; /* PBDC45_7         */
    uint16 PBDC45_8  : 1; /* PBDC45_8         */
    uint16 PBDC45_9  : 1; /* PBDC45_9         */
    uint16 PBDC45_10 : 1; /* PBDC45_10        */
    uint16 PBDC45_11 : 1; /* PBDC45_11        */
    uint16 PBDC45_12 : 1; /* PBDC45_12        */
    uint16 PBDC45_13 : 1; /* PBDC45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type240;
typedef struct
{                         /* Bit Access       */
    uint16 PIPC45_0  : 1; /* PIPC45_0         */
    uint16 PIPC45_1  : 1; /* PIPC45_1         */
    uint16 PIPC45_2  : 1; /* PIPC45_2         */
    uint16 PIPC45_3  : 1; /* PIPC45_3         */
    uint16 PIPC45_4  : 1; /* PIPC45_4         */
    uint16 PIPC45_5  : 1; /* PIPC45_5         */
    uint16 PIPC45_6  : 1; /* PIPC45_6         */
    uint16 PIPC45_7  : 1; /* PIPC45_7         */
    uint16 PIPC45_8  : 1; /* PIPC45_8         */
    uint16 PIPC45_9  : 1; /* PIPC45_9         */
    uint16 PIPC45_10 : 1; /* PIPC45_10        */
    uint16 PIPC45_11 : 1; /* PIPC45_11        */
    uint16 PIPC45_12 : 1; /* PIPC45_12        */
    uint16 PIPC45_13 : 1; /* PIPC45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type241;
typedef struct
{                       /* Bit Access       */
    uint16 PU45_0  : 1; /* PU45_0           */
    uint16 PU45_1  : 1; /* PU45_1           */
    uint16 PU45_2  : 1; /* PU45_2           */
    uint16 PU45_3  : 1; /* PU45_3           */
    uint16 PU45_4  : 1; /* PU45_4           */
    uint16 PU45_5  : 1; /* PU45_5           */
    uint16 PU45_6  : 1; /* PU45_6           */
    uint16 PU45_7  : 1; /* PU45_7           */
    uint16 PU45_8  : 1; /* PU45_8           */
    uint16 PU45_9  : 1; /* PU45_9           */
    uint16 PU45_10 : 1; /* PU45_10          */
    uint16 PU45_11 : 1; /* PU45_11          */
    uint16 PU45_12 : 1; /* PU45_12          */
    uint16 PU45_13 : 1; /* PU45_13          */
    uint16         : 2; /* Reserved Bits    */
} __type242;
typedef struct
{                       /* Bit Access       */
    uint16 PD45_0  : 1; /* PD45_0           */
    uint16 PD45_1  : 1; /* PD45_1           */
    uint16 PD45_2  : 1; /* PD45_2           */
    uint16 PD45_3  : 1; /* PD45_3           */
    uint16 PD45_4  : 1; /* PD45_4           */
    uint16 PD45_5  : 1; /* PD45_5           */
    uint16 PD45_6  : 1; /* PD45_6           */
    uint16 PD45_7  : 1; /* PD45_7           */
    uint16 PD45_8  : 1; /* PD45_8           */
    uint16 PD45_9  : 1; /* PD45_9           */
    uint16 PD45_10 : 1; /* PD45_10          */
    uint16 PD45_11 : 1; /* PD45_11          */
    uint16 PD45_12 : 1; /* PD45_12          */
    uint16 PD45_13 : 1; /* PD45_13          */
    uint16         : 2; /* Reserved Bits    */
} __type243;
typedef struct
{                          /* Bit Access       */
    uint32 PODC45_0  : 1;  /* PODC45_0         */
    uint32 PODC45_1  : 1;  /* PODC45_1         */
    uint32 PODC45_2  : 1;  /* PODC45_2         */
    uint32 PODC45_3  : 1;  /* PODC45_3         */
    uint32 PODC45_4  : 1;  /* PODC45_4         */
    uint32 PODC45_5  : 1;  /* PODC45_5         */
    uint32 PODC45_6  : 1;  /* PODC45_6         */
    uint32 PODC45_7  : 1;  /* PODC45_7         */
    uint32 PODC45_8  : 1;  /* PODC45_8         */
    uint32 PODC45_9  : 1;  /* PODC45_9         */
    uint32 PODC45_10 : 1;  /* PODC45_10        */
    uint32 PODC45_11 : 1;  /* PODC45_11        */
    uint32 PODC45_12 : 1;  /* PODC45_12        */
    uint32 PODC45_13 : 1;  /* PODC45_13        */
    uint32           : 18; /* Reserved Bits    */
} __type244;
typedef struct
{                          /* Bit Access       */
    uint32 PDSC45_0  : 1;  /* PDSC45_0         */
    uint32 PDSC45_1  : 1;  /* PDSC45_1         */
    uint32 PDSC45_2  : 1;  /* PDSC45_2         */
    uint32 PDSC45_3  : 1;  /* PDSC45_3         */
    uint32 PDSC45_4  : 1;  /* PDSC45_4         */
    uint32 PDSC45_5  : 1;  /* PDSC45_5         */
    uint32 PDSC45_6  : 1;  /* PDSC45_6         */
    uint32 PDSC45_7  : 1;  /* PDSC45_7         */
    uint32 PDSC45_8  : 1;  /* PDSC45_8         */
    uint32 PDSC45_9  : 1;  /* PDSC45_9         */
    uint32 PDSC45_10 : 1;  /* PDSC45_10        */
    uint32 PDSC45_11 : 1;  /* PDSC45_11        */
    uint32 PDSC45_12 : 1;  /* PDSC45_12        */
    uint32 PDSC45_13 : 1;  /* PDSC45_13        */
    uint32           : 18; /* Reserved Bits    */
} __type245;
typedef struct
{                        /* Bit Access       */
    uint16 PIS45_0  : 1; /* PIS45_0          */
    uint16 PIS45_1  : 1; /* PIS45_1          */
    uint16 PIS45_2  : 1; /* PIS45_2          */
    uint16 PIS45_3  : 1; /* PIS45_3          */
    uint16 PIS45_4  : 1; /* PIS45_4          */
    uint16 PIS45_5  : 1; /* PIS45_5          */
    uint16 PIS45_6  : 1; /* PIS45_6          */
    uint16 PIS45_7  : 1; /* PIS45_7          */
    uint16 PIS45_8  : 1; /* PIS45_8          */
    uint16 PIS45_9  : 1; /* PIS45_9          */
    uint16 PIS45_10 : 1; /* PIS45_10         */
    uint16 PIS45_11 : 1; /* PIS45_11         */
    uint16 PIS45_12 : 1; /* PIS45_12         */
    uint16 PIS45_13 : 1; /* PIS45_13         */
    uint16          : 2; /* Reserved Bits    */
} __type246;
typedef struct
{                         /* Bit Access       */
    uint16 PISA45_0  : 1; /* PISA45_0         */
    uint16 PISA45_1  : 1; /* PISA45_1         */
    uint16 PISA45_2  : 1; /* PISA45_2         */
    uint16 PISA45_3  : 1; /* PISA45_3         */
    uint16 PISA45_4  : 1; /* PISA45_4         */
    uint16 PISA45_5  : 1; /* PISA45_5         */
    uint16 PISA45_6  : 1; /* PISA45_6         */
    uint16 PISA45_7  : 1; /* PISA45_7         */
    uint16 PISA45_8  : 1; /* PISA45_8         */
    uint16 PISA45_9  : 1; /* PISA45_9         */
    uint16 PISA45_10 : 1; /* PISA45_10        */
    uint16 PISA45_11 : 1; /* PISA45_11        */
    uint16 PISA45_12 : 1; /* PISA45_12        */
    uint16 PISA45_13 : 1; /* PISA45_13        */
    uint16           : 2; /* Reserved Bits    */
} __type247;
typedef struct
{                        /* Bit Access       */
    uint32 PPCMD45 : 8;  /* PPCMD45[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type248;
typedef struct
{                                    /* Bit Access       */
    const uint32 PPROTS45PRERR : 1;  /* PPROTS45PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type249;
typedef struct
{                    /* Bit Access       */
    uint16 P0_0 : 1; /* P0_0             */
    uint16 P0_1 : 1; /* P0_1             */
    uint16 P0_2 : 1; /* P0_2             */
    uint16 P0_3 : 1; /* P0_3             */
    uint16 P0_4 : 1; /* P0_4             */
    uint16 P0_5 : 1; /* P0_5             */
    uint16 P0_6 : 1; /* P0_6             */
    uint16 P0_7 : 1; /* P0_7             */
    uint16 P0_8 : 1; /* P0_8             */
    uint16 P0_9 : 1; /* P0_9             */
    uint16      : 6; /* Reserved Bits    */
} __type250;
typedef struct
{                       /* Bit Access       */
    uint32 PSR0_0  : 1; /* PSR0_0           */
    uint32 PSR0_1  : 1; /* PSR0_1           */
    uint32 PSR0_2  : 1; /* PSR0_2           */
    uint32 PSR0_3  : 1; /* PSR0_3           */
    uint32 PSR0_4  : 1; /* PSR0_4           */
    uint32 PSR0_5  : 1; /* PSR0_5           */
    uint32 PSR0_6  : 1; /* PSR0_6           */
    uint32 PSR0_7  : 1; /* PSR0_7           */
    uint32 PSR0_8  : 1; /* PSR0_8           */
    uint32 PSR0_9  : 1; /* PSR0_9           */
    uint32         : 6; /* Reserved Bits    */
    uint32 PSR0_16 : 1; /* PSR0_16          */
    uint32 PSR0_17 : 1; /* PSR0_17          */
    uint32 PSR0_18 : 1; /* PSR0_18          */
    uint32 PSR0_19 : 1; /* PSR0_19          */
    uint32 PSR0_20 : 1; /* PSR0_20          */
    uint32 PSR0_21 : 1; /* PSR0_21          */
    uint32 PSR0_22 : 1; /* PSR0_22          */
    uint32 PSR0_23 : 1; /* PSR0_23          */
    uint32 PSR0_24 : 1; /* PSR0_24          */
    uint32 PSR0_25 : 1; /* PSR0_25          */
    uint32         : 6; /* Reserved Bits    */
} __type251;
typedef struct
{                       /* Bit Access       */
    uint16 PNOT0_0 : 1; /* PNOT0_0          */
    uint16 PNOT0_1 : 1; /* PNOT0_1          */
    uint16 PNOT0_2 : 1; /* PNOT0_2          */
    uint16 PNOT0_3 : 1; /* PNOT0_3          */
    uint16 PNOT0_4 : 1; /* PNOT0_4          */
    uint16 PNOT0_5 : 1; /* PNOT0_5          */
    uint16 PNOT0_6 : 1; /* PNOT0_6          */
    uint16 PNOT0_7 : 1; /* PNOT0_7          */
    uint16 PNOT0_8 : 1; /* PNOT0_8          */
    uint16 PNOT0_9 : 1; /* PNOT0_9          */
    uint16         : 6; /* Reserved Bits    */
} __type252;
typedef struct
{                            /* Bit Access       */
    const uint16 PPR0_0 : 1; /* PPR0_0           */
    const uint16 PPR0_1 : 1; /* PPR0_1           */
    const uint16 PPR0_2 : 1; /* PPR0_2           */
    const uint16 PPR0_3 : 1; /* PPR0_3           */
    const uint16 PPR0_4 : 1; /* PPR0_4           */
    const uint16 PPR0_5 : 1; /* PPR0_5           */
    const uint16 PPR0_6 : 1; /* PPR0_6           */
    const uint16 PPR0_7 : 1; /* PPR0_7           */
    const uint16 PPR0_8 : 1; /* PPR0_8           */
    const uint16 PPR0_9 : 1; /* PPR0_9           */
    uint16              : 6; /* Reserved Bits    */
} __type253;
typedef struct
{                     /* Bit Access       */
    uint16 PM0_0 : 1; /* PM0_0            */
    uint16 PM0_1 : 1; /* PM0_1            */
    uint16 PM0_2 : 1; /* PM0_2            */
    uint16 PM0_3 : 1; /* PM0_3            */
    uint16 PM0_4 : 1; /* PM0_4            */
    uint16 PM0_5 : 1; /* PM0_5            */
    uint16 PM0_6 : 1; /* PM0_6            */
    uint16 PM0_7 : 1; /* PM0_7            */
    uint16 PM0_8 : 1; /* PM0_8            */
    uint16 PM0_9 : 1; /* PM0_9            */
    uint16       : 6; /* Reserved Bits    */
} __type254;
typedef struct
{                      /* Bit Access       */
    uint16 PMC0_0 : 1; /* PMC0_0           */
    uint16 PMC0_1 : 1; /* PMC0_1           */
    uint16 PMC0_2 : 1; /* PMC0_2           */
    uint16 PMC0_3 : 1; /* PMC0_3           */
    uint16 PMC0_4 : 1; /* PMC0_4           */
    uint16 PMC0_5 : 1; /* PMC0_5           */
    uint16 PMC0_6 : 1; /* PMC0_6           */
    uint16 PMC0_7 : 1; /* PMC0_7           */
    uint16 PMC0_8 : 1; /* PMC0_8           */
    uint16 PMC0_9 : 1; /* PMC0_9           */
    uint16        : 6; /* Reserved Bits    */
} __type255;
typedef struct
{                      /* Bit Access       */
    uint16 PFC0_0 : 1; /* PFC0_0           */
    uint16 PFC0_1 : 1; /* PFC0_1           */
    uint16 PFC0_2 : 1; /* PFC0_2           */
    uint16 PFC0_3 : 1; /* PFC0_3           */
    uint16 PFC0_4 : 1; /* PFC0_4           */
    uint16 PFC0_5 : 1; /* PFC0_5           */
    uint16 PFC0_6 : 1; /* PFC0_6           */
    uint16 PFC0_7 : 1; /* PFC0_7           */
    uint16 PFC0_8 : 1; /* PFC0_8           */
    uint16 PFC0_9 : 1; /* PFC0_9           */
    uint16        : 6; /* Reserved Bits    */
} __type256;
typedef struct
{                       /* Bit Access       */
    uint16 PFCE0_0 : 1; /* PFCE0_0          */
    uint16 PFCE0_1 : 1; /* PFCE0_1          */
    uint16 PFCE0_2 : 1; /* PFCE0_2          */
    uint16 PFCE0_3 : 1; /* PFCE0_3          */
    uint16 PFCE0_4 : 1; /* PFCE0_4          */
    uint16 PFCE0_5 : 1; /* PFCE0_5          */
    uint16 PFCE0_6 : 1; /* PFCE0_6          */
    uint16 PFCE0_7 : 1; /* PFCE0_7          */
    uint16 PFCE0_8 : 1; /* PFCE0_8          */
    uint16 PFCE0_9 : 1; /* PFCE0_9          */
    uint16         : 6; /* Reserved Bits    */
} __type257;
typedef struct
{                        /* Bit Access       */
    uint32 PMSR0_0  : 1; /* PMSR0_0          */
    uint32 PMSR0_1  : 1; /* PMSR0_1          */
    uint32 PMSR0_2  : 1; /* PMSR0_2          */
    uint32 PMSR0_3  : 1; /* PMSR0_3          */
    uint32 PMSR0_4  : 1; /* PMSR0_4          */
    uint32 PMSR0_5  : 1; /* PMSR0_5          */
    uint32 PMSR0_6  : 1; /* PMSR0_6          */
    uint32 PMSR0_7  : 1; /* PMSR0_7          */
    uint32 PMSR0_8  : 1; /* PMSR0_8          */
    uint32 PMSR0_9  : 1; /* PMSR0_9          */
    uint32          : 6; /* Reserved Bits    */
    uint32 PMSR0_16 : 1; /* PMSR0_16         */
    uint32 PMSR0_17 : 1; /* PMSR0_17         */
    uint32 PMSR0_18 : 1; /* PMSR0_18         */
    uint32 PMSR0_19 : 1; /* PMSR0_19         */
    uint32 PMSR0_20 : 1; /* PMSR0_20         */
    uint32 PMSR0_21 : 1; /* PMSR0_21         */
    uint32 PMSR0_22 : 1; /* PMSR0_22         */
    uint32 PMSR0_23 : 1; /* PMSR0_23         */
    uint32 PMSR0_24 : 1; /* PMSR0_24         */
    uint32 PMSR0_25 : 1; /* PMSR0_25         */
    uint32          : 6; /* Reserved Bits    */
} __type258;
typedef struct
{                         /* Bit Access       */
    uint32 PMCSR0_0  : 1; /* PMCSR0_0         */
    uint32 PMCSR0_1  : 1; /* PMCSR0_1         */
    uint32 PMCSR0_2  : 1; /* PMCSR0_2         */
    uint32 PMCSR0_3  : 1; /* PMCSR0_3         */
    uint32 PMCSR0_4  : 1; /* PMCSR0_4         */
    uint32 PMCSR0_5  : 1; /* PMCSR0_5         */
    uint32 PMCSR0_6  : 1; /* PMCSR0_6         */
    uint32 PMCSR0_7  : 1; /* PMCSR0_7         */
    uint32 PMCSR0_8  : 1; /* PMCSR0_8         */
    uint32 PMCSR0_9  : 1; /* PMCSR0_9         */
    uint32           : 6; /* Reserved Bits    */
    uint32 PMCSR0_16 : 1; /* PMCSR0_16        */
    uint32 PMCSR0_17 : 1; /* PMCSR0_17        */
    uint32 PMCSR0_18 : 1; /* PMCSR0_18        */
    uint32 PMCSR0_19 : 1; /* PMCSR0_19        */
    uint32 PMCSR0_20 : 1; /* PMCSR0_20        */
    uint32 PMCSR0_21 : 1; /* PMCSR0_21        */
    uint32 PMCSR0_22 : 1; /* PMCSR0_22        */
    uint32 PMCSR0_23 : 1; /* PMCSR0_23        */
    uint32 PMCSR0_24 : 1; /* PMCSR0_24        */
    uint32 PMCSR0_25 : 1; /* PMCSR0_25        */
    uint32           : 6; /* Reserved Bits    */
} __type259;
typedef struct
{                       /* Bit Access       */
    uint16 PINV0_0 : 1; /* PINV0_0          */
    uint16 PINV0_1 : 1; /* PINV0_1          */
    uint16 PINV0_2 : 1; /* PINV0_2          */
    uint16 PINV0_3 : 1; /* PINV0_3          */
    uint16 PINV0_4 : 1; /* PINV0_4          */
    uint16 PINV0_5 : 1; /* PINV0_5          */
    uint16 PINV0_6 : 1; /* PINV0_6          */
    uint16 PINV0_7 : 1; /* PINV0_7          */
    uint16 PINV0_8 : 1; /* PINV0_8          */
    uint16 PINV0_9 : 1; /* PINV0_9          */
    uint16         : 6; /* Reserved Bits    */
} __type260;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_0       : 1; /* PCR_PFC0_0       */
    uint32 PCR_PFCE0_0      : 1; /* PCR_PFCE0_0      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_0        : 1; /* PCR_PM0_0        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_0       : 1; /* PCR_PMC0_0       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_0 : 1; /* PCR_PPR0_0       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_0         : 1; /* PCR_P0_0         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_0      : 1; /* PCR_PIBC0_0      */
    uint32 PCR_PBDC0_0      : 1; /* PCR_PBDC0_0      */
    uint32 PCR_PD0_0        : 1; /* PCR_PD0_0        */
    uint32 PCR_PU0_0        : 1; /* PCR_PU0_0        */
    uint32 PCR_PIS0_0       : 1; /* PCR_PIS0_0       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_0      : 1; /* PCR_PISA0_0      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_0      : 1; /* PCR_PDSC0_0      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_0      : 1; /* PCR_PODC0_0      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_0      : 1; /* PCR_PINV0_0      */
    uint32                  : 1; /* Reserved Bits    */
} __type261;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_1       : 1; /* PCR_PFC0_1       */
    uint32 PCR_PFCE0_1      : 1; /* PCR_PFCE0_1      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_1        : 1; /* PCR_PM0_1        */
    uint32 PCR_PIPC0_1      : 1; /* PCR_PIPC0_1      */
    uint32 PCR_PMC0_1       : 1; /* PCR_PMC0_1       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_1 : 1; /* PCR_PPR0_1       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_1         : 1; /* PCR_P0_1         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_1      : 1; /* PCR_PIBC0_1      */
    uint32 PCR_PBDC0_1      : 1; /* PCR_PBDC0_1      */
    uint32 PCR_PD0_1        : 1; /* PCR_PD0_1        */
    uint32 PCR_PU0_1        : 1; /* PCR_PU0_1        */
    uint32 PCR_PIS0_1       : 1; /* PCR_PIS0_1       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_1      : 1; /* PCR_PISA0_1      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_1      : 1; /* PCR_PDSC0_1      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_1      : 1; /* PCR_PODC0_1      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_1      : 1; /* PCR_PINV0_1      */
    uint32                  : 1; /* Reserved Bits    */
} __type262;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_2       : 1; /* PCR_PFC0_2       */
    uint32 PCR_PFCE0_2      : 1; /* PCR_PFCE0_2      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_2        : 1; /* PCR_PM0_2        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_2       : 1; /* PCR_PMC0_2       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_2 : 1; /* PCR_PPR0_2       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_2         : 1; /* PCR_P0_2         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_2      : 1; /* PCR_PIBC0_2      */
    uint32 PCR_PBDC0_2      : 1; /* PCR_PBDC0_2      */
    uint32 PCR_PD0_2        : 1; /* PCR_PD0_2        */
    uint32 PCR_PU0_2        : 1; /* PCR_PU0_2        */
    uint32 PCR_PIS0_2       : 1; /* PCR_PIS0_2       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_2      : 1; /* PCR_PISA0_2      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_2      : 1; /* PCR_PDSC0_2      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_2      : 1; /* PCR_PODC0_2      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_2      : 1; /* PCR_PINV0_2      */
    uint32                  : 1; /* Reserved Bits    */
} __type263;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_3       : 1; /* PCR_PFC0_3       */
    uint32 PCR_PFCE0_3      : 1; /* PCR_PFCE0_3      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_3        : 1; /* PCR_PM0_3        */
    uint32 PCR_PIPC0_3      : 1; /* PCR_PIPC0_3      */
    uint32 PCR_PMC0_3       : 1; /* PCR_PMC0_3       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_3 : 1; /* PCR_PPR0_3       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_3         : 1; /* PCR_P0_3         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_3      : 1; /* PCR_PIBC0_3      */
    uint32 PCR_PBDC0_3      : 1; /* PCR_PBDC0_3      */
    uint32 PCR_PD0_3        : 1; /* PCR_PD0_3        */
    uint32 PCR_PU0_3        : 1; /* PCR_PU0_3        */
    uint32 PCR_PIS0_3       : 1; /* PCR_PIS0_3       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_3      : 1; /* PCR_PISA0_3      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_3      : 1; /* PCR_PDSC0_3      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_3      : 1; /* PCR_PODC0_3      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_3      : 1; /* PCR_PINV0_3      */
    uint32                  : 1; /* Reserved Bits    */
} __type264;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_4       : 1; /* PCR_PFC0_4       */
    uint32 PCR_PFCE0_4      : 1; /* PCR_PFCE0_4      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_4        : 1; /* PCR_PM0_4        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_4       : 1; /* PCR_PMC0_4       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_4 : 1; /* PCR_PPR0_4       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_4         : 1; /* PCR_P0_4         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_4      : 1; /* PCR_PIBC0_4      */
    uint32 PCR_PBDC0_4      : 1; /* PCR_PBDC0_4      */
    uint32 PCR_PD0_4        : 1; /* PCR_PD0_4        */
    uint32 PCR_PU0_4        : 1; /* PCR_PU0_4        */
    uint32 PCR_PIS0_4       : 1; /* PCR_PIS0_4       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_4      : 1; /* PCR_PISA0_4      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_4      : 1; /* PCR_PDSC0_4      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_4      : 1; /* PCR_PODC0_4      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_4      : 1; /* PCR_PINV0_4      */
    uint32                  : 1; /* Reserved Bits    */
} __type265;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_5       : 1; /* PCR_PFC0_5       */
    uint32 PCR_PFCE0_5      : 1; /* PCR_PFCE0_5      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_5        : 1; /* PCR_PM0_5        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_5       : 1; /* PCR_PMC0_5       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_5 : 1; /* PCR_PPR0_5       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_5         : 1; /* PCR_P0_5         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_5      : 1; /* PCR_PIBC0_5      */
    uint32 PCR_PBDC0_5      : 1; /* PCR_PBDC0_5      */
    uint32 PCR_PD0_5        : 1; /* PCR_PD0_5        */
    uint32 PCR_PU0_5        : 1; /* PCR_PU0_5        */
    uint32 PCR_PIS0_5       : 1; /* PCR_PIS0_5       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_5      : 1; /* PCR_PISA0_5      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_5      : 1; /* PCR_PDSC0_5      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_5      : 1; /* PCR_PODC0_5      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_5      : 1; /* PCR_PINV0_5      */
    uint32                  : 1; /* Reserved Bits    */
} __type266;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_6       : 1; /* PCR_PFC0_6       */
    uint32 PCR_PFCE0_6      : 1; /* PCR_PFCE0_6      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_6        : 1; /* PCR_PM0_6        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_6       : 1; /* PCR_PMC0_6       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_6 : 1; /* PCR_PPR0_6       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_6         : 1; /* PCR_P0_6         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_6      : 1; /* PCR_PIBC0_6      */
    uint32 PCR_PBDC0_6      : 1; /* PCR_PBDC0_6      */
    uint32 PCR_PD0_6        : 1; /* PCR_PD0_6        */
    uint32 PCR_PU0_6        : 1; /* PCR_PU0_6        */
    uint32 PCR_PIS0_6       : 1; /* PCR_PIS0_6       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_6      : 1; /* PCR_PISA0_6      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_6      : 1; /* PCR_PDSC0_6      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_6      : 1; /* PCR_PODC0_6      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_6      : 1; /* PCR_PINV0_6      */
    uint32                  : 1; /* Reserved Bits    */
} __type267;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_7       : 1; /* PCR_PFC0_7       */
    uint32 PCR_PFCE0_7      : 1; /* PCR_PFCE0_7      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_7        : 1; /* PCR_PM0_7        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_7       : 1; /* PCR_PMC0_7       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_7 : 1; /* PCR_PPR0_7       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_7         : 1; /* PCR_P0_7         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_7      : 1; /* PCR_PIBC0_7      */
    uint32 PCR_PBDC0_7      : 1; /* PCR_PBDC0_7      */
    uint32 PCR_PD0_7        : 1; /* PCR_PD0_7        */
    uint32 PCR_PU0_7        : 1; /* PCR_PU0_7        */
    uint32 PCR_PIS0_7       : 1; /* PCR_PIS0_7       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_7      : 1; /* PCR_PISA0_7      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_7      : 1; /* PCR_PDSC0_7      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_7      : 1; /* PCR_PODC0_7      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_7      : 1; /* PCR_PINV0_7      */
    uint32                  : 1; /* Reserved Bits    */
} __type268;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_8       : 1; /* PCR_PFC0_8       */
    uint32 PCR_PFCE0_8      : 1; /* PCR_PFCE0_8      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_8        : 1; /* PCR_PM0_8        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_8       : 1; /* PCR_PMC0_8       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_8 : 1; /* PCR_PPR0_8       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_8         : 1; /* PCR_P0_8         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_8      : 1; /* PCR_PIBC0_8      */
    uint32 PCR_PBDC0_8      : 1; /* PCR_PBDC0_8      */
    uint32 PCR_PD0_8        : 1; /* PCR_PD0_8        */
    uint32 PCR_PU0_8        : 1; /* PCR_PU0_8        */
    uint32 PCR_PIS0_8       : 1; /* PCR_PIS0_8       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_8      : 1; /* PCR_PISA0_8      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_8      : 1; /* PCR_PDSC0_8      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_8      : 1; /* PCR_PODC0_8      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_8      : 1; /* PCR_PINV0_8      */
    uint32                  : 1; /* Reserved Bits    */
} __type269;
typedef struct
{                                /* Bit Access       */
    uint32 PCR_PFC0_9       : 1; /* PCR_PFC0_9       */
    uint32 PCR_PFCE0_9      : 1; /* PCR_PFCE0_9      */
    uint32                  : 2; /* Reserved Bits    */
    uint32 PCR_PM0_9        : 1; /* PCR_PM0_9        */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PMC0_9       : 1; /* PCR_PMC0_9       */
    uint32                  : 1; /* Reserved Bits    */
    const uint32 PCR_PPR0_9 : 1; /* PCR_PPR0_9       */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_P0_9         : 1; /* PCR_P0_9         */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PIBC0_9      : 1; /* PCR_PIBC0_9      */
    uint32 PCR_PBDC0_9      : 1; /* PCR_PBDC0_9      */
    uint32 PCR_PD0_9        : 1; /* PCR_PD0_9        */
    uint32 PCR_PU0_9        : 1; /* PCR_PU0_9        */
    uint32 PCR_PIS0_9       : 1; /* PCR_PIS0_9       */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PISA0_9      : 1; /* PCR_PISA0_9      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PDSC0_9      : 1; /* PCR_PDSC0_9      */
    uint32                  : 3; /* Reserved Bits    */
    uint32 PCR_PODC0_9      : 1; /* PCR_PODC0_9      */
    uint32                  : 1; /* Reserved Bits    */
    uint32 PCR_PINV0_9      : 1; /* PCR_PINV0_9      */
    uint32                  : 1; /* Reserved Bits    */
} __type270;
typedef struct
{                       /* Bit Access       */
    uint16 PIBC0_0 : 1; /* PIBC0_0          */
    uint16 PIBC0_1 : 1; /* PIBC0_1          */
    uint16 PIBC0_2 : 1; /* PIBC0_2          */
    uint16 PIBC0_3 : 1; /* PIBC0_3          */
    uint16 PIBC0_4 : 1; /* PIBC0_4          */
    uint16 PIBC0_5 : 1; /* PIBC0_5          */
    uint16 PIBC0_6 : 1; /* PIBC0_6          */
    uint16 PIBC0_7 : 1; /* PIBC0_7          */
    uint16 PIBC0_8 : 1; /* PIBC0_8          */
    uint16 PIBC0_9 : 1; /* PIBC0_9          */
    uint16         : 6; /* Reserved Bits    */
} __type271;
typedef struct
{                       /* Bit Access       */
    uint16 PBDC0_0 : 1; /* PBDC0_0          */
    uint16 PBDC0_1 : 1; /* PBDC0_1          */
    uint16 PBDC0_2 : 1; /* PBDC0_2          */
    uint16 PBDC0_3 : 1; /* PBDC0_3          */
    uint16 PBDC0_4 : 1; /* PBDC0_4          */
    uint16 PBDC0_5 : 1; /* PBDC0_5          */
    uint16 PBDC0_6 : 1; /* PBDC0_6          */
    uint16 PBDC0_7 : 1; /* PBDC0_7          */
    uint16 PBDC0_8 : 1; /* PBDC0_8          */
    uint16 PBDC0_9 : 1; /* PBDC0_9          */
    uint16         : 6; /* Reserved Bits    */
} __type272;
typedef struct
{                        /* Bit Access       */
    uint16         : 1;  /* Reserved Bits    */
    uint16 PIPC0_1 : 1;  /* PIPC0_1          */
    uint16         : 1;  /* Reserved Bits    */
    uint16 PIPC0_3 : 1;  /* PIPC0_3          */
    uint16         : 12; /* Reserved Bits    */
} __type273;
typedef struct
{                     /* Bit Access       */
    uint16 PU0_0 : 1; /* PU0_0            */
    uint16 PU0_1 : 1; /* PU0_1            */
    uint16 PU0_2 : 1; /* PU0_2            */
    uint16 PU0_3 : 1; /* PU0_3            */
    uint16 PU0_4 : 1; /* PU0_4            */
    uint16 PU0_5 : 1; /* PU0_5            */
    uint16 PU0_6 : 1; /* PU0_6            */
    uint16 PU0_7 : 1; /* PU0_7            */
    uint16 PU0_8 : 1; /* PU0_8            */
    uint16 PU0_9 : 1; /* PU0_9            */
    uint16       : 6; /* Reserved Bits    */
} __type274;
typedef struct
{                     /* Bit Access       */
    uint16 PD0_0 : 1; /* PD0_0            */
    uint16 PD0_1 : 1; /* PD0_1            */
    uint16 PD0_2 : 1; /* PD0_2            */
    uint16 PD0_3 : 1; /* PD0_3            */
    uint16 PD0_4 : 1; /* PD0_4            */
    uint16 PD0_5 : 1; /* PD0_5            */
    uint16 PD0_6 : 1; /* PD0_6            */
    uint16 PD0_7 : 1; /* PD0_7            */
    uint16 PD0_8 : 1; /* PD0_8            */
    uint16 PD0_9 : 1; /* PD0_9            */
    uint16       : 6; /* Reserved Bits    */
} __type275;
typedef struct
{                        /* Bit Access       */
    uint32 PODC0_0 : 1;  /* PODC0_0          */
    uint32 PODC0_1 : 1;  /* PODC0_1          */
    uint32 PODC0_2 : 1;  /* PODC0_2          */
    uint32 PODC0_3 : 1;  /* PODC0_3          */
    uint32 PODC0_4 : 1;  /* PODC0_4          */
    uint32 PODC0_5 : 1;  /* PODC0_5          */
    uint32 PODC0_6 : 1;  /* PODC0_6          */
    uint32 PODC0_7 : 1;  /* PODC0_7          */
    uint32 PODC0_8 : 1;  /* PODC0_8          */
    uint32 PODC0_9 : 1;  /* PODC0_9          */
    uint32         : 22; /* Reserved Bits    */
} __type276;
typedef struct
{                        /* Bit Access       */
    uint32 PDSC0_0 : 1;  /* PDSC0_0          */
    uint32 PDSC0_1 : 1;  /* PDSC0_1          */
    uint32 PDSC0_2 : 1;  /* PDSC0_2          */
    uint32 PDSC0_3 : 1;  /* PDSC0_3          */
    uint32 PDSC0_4 : 1;  /* PDSC0_4          */
    uint32 PDSC0_5 : 1;  /* PDSC0_5          */
    uint32 PDSC0_6 : 1;  /* PDSC0_6          */
    uint32 PDSC0_7 : 1;  /* PDSC0_7          */
    uint32 PDSC0_8 : 1;  /* PDSC0_8          */
    uint32 PDSC0_9 : 1;  /* PDSC0_9          */
    uint32         : 22; /* Reserved Bits    */
} __type277;
typedef struct
{                      /* Bit Access       */
    uint16 PIS0_0 : 1; /* PIS0_0           */
    uint16 PIS0_1 : 1; /* PIS0_1           */
    uint16 PIS0_2 : 1; /* PIS0_2           */
    uint16 PIS0_3 : 1; /* PIS0_3           */
    uint16 PIS0_4 : 1; /* PIS0_4           */
    uint16 PIS0_5 : 1; /* PIS0_5           */
    uint16 PIS0_6 : 1; /* PIS0_6           */
    uint16 PIS0_7 : 1; /* PIS0_7           */
    uint16 PIS0_8 : 1; /* PIS0_8           */
    uint16 PIS0_9 : 1; /* PIS0_9           */
    uint16        : 6; /* Reserved Bits    */
} __type278;
typedef struct
{                       /* Bit Access       */
    uint16 PISA0_0 : 1; /* PISA0_0          */
    uint16 PISA0_1 : 1; /* PISA0_1          */
    uint16 PISA0_2 : 1; /* PISA0_2          */
    uint16 PISA0_3 : 1; /* PISA0_3          */
    uint16 PISA0_4 : 1; /* PISA0_4          */
    uint16 PISA0_5 : 1; /* PISA0_5          */
    uint16 PISA0_6 : 1; /* PISA0_6          */
    uint16 PISA0_7 : 1; /* PISA0_7          */
    uint16 PISA0_8 : 1; /* PISA0_8          */
    uint16 PISA0_9 : 1; /* PISA0_9          */
    uint16         : 6; /* Reserved Bits    */
} __type279;
typedef struct
{                       /* Bit Access       */
    uint32 PPCMD0 : 8;  /* PPCMD0[7:0]      */
    uint32        : 24; /* Reserved Bits    */
} __type280;
typedef struct
{                                   /* Bit Access       */
    const uint32 PPROTS0PRERR : 1;  /* PPROTS0PRERR     */
    uint32                    : 31; /* Reserved Bits    */
} __type281;
typedef struct
{                    /* Bit Access       */
    uint8 JP0_0 : 1; /* JP0_0            */
    uint8 JP0_1 : 1; /* JP0_1            */
    uint8 JP0_2 : 1; /* JP0_2            */
    uint8 JP0_3 : 1; /* JP0_3            */
    uint8 JP0_4 : 1; /* JP0_4            */
    uint8 JP0_5 : 1; /* JP0_5            */
    uint8       : 2; /* Reserved Bits    */
} __type282;
typedef struct
{                         /* Bit Access       */
    uint32 JPSR0_0  : 1;  /* JPSR0_0          */
    uint32 JPSR0_1  : 1;  /* JPSR0_1          */
    uint32 JPSR0_2  : 1;  /* JPSR0_2          */
    uint32 JPSR0_3  : 1;  /* JPSR0_3          */
    uint32 JPSR0_4  : 1;  /* JPSR0_4          */
    uint32 JPSR0_5  : 1;  /* JPSR0_5          */
    uint32          : 10; /* Reserved Bits    */
    uint32 JPSR0_16 : 1;  /* JPSR0_16         */
    uint32 JPSR0_17 : 1;  /* JPSR0_17         */
    uint32 JPSR0_18 : 1;  /* JPSR0_18         */
    uint32 JPSR0_19 : 1;  /* JPSR0_19         */
    uint32 JPSR0_20 : 1;  /* JPSR0_20         */
    uint32 JPSR0_21 : 1;  /* JPSR0_21         */
    uint32          : 10; /* Reserved Bits    */
} __type283;
typedef struct
{                       /* Bit Access       */
    uint8 JPNOT0_0 : 1; /* JPNOT0_0         */
    uint8 JPNOT0_1 : 1; /* JPNOT0_1         */
    uint8 JPNOT0_2 : 1; /* JPNOT0_2         */
    uint8 JPNOT0_3 : 1; /* JPNOT0_3         */
    uint8 JPNOT0_4 : 1; /* JPNOT0_4         */
    uint8 JPNOT0_5 : 1; /* JPNOT0_5         */
    uint8          : 2; /* Reserved Bits    */
} __type284;
typedef struct
{                            /* Bit Access       */
    const uint8 JPPR0_0 : 1; /* JPPR0_0          */
    const uint8 JPPR0_1 : 1; /* JPPR0_1          */
    const uint8 JPPR0_2 : 1; /* JPPR0_2          */
    const uint8 JPPR0_3 : 1; /* JPPR0_3          */
    const uint8 JPPR0_4 : 1; /* JPPR0_4          */
    const uint8 JPPR0_5 : 1; /* JPPR0_5          */
    uint8               : 2; /* Reserved Bits    */
} __type285;
typedef struct
{                     /* Bit Access       */
    uint8 JPM0_0 : 1; /* JPM0_0           */
    uint8 JPM0_1 : 1; /* JPM0_1           */
    uint8 JPM0_2 : 1; /* JPM0_2           */
    uint8 JPM0_3 : 1; /* JPM0_3           */
    uint8 JPM0_4 : 1; /* JPM0_4           */
    uint8 JPM0_5 : 1; /* JPM0_5           */
    uint8        : 2; /* Reserved Bits    */
} __type286;
typedef struct
{                      /* Bit Access       */
    uint8 JPMC0_0 : 1; /* JPMC0_0          */
    uint8 JPMC0_1 : 1; /* JPMC0_1          */
    uint8 JPMC0_2 : 1; /* JPMC0_2          */
    uint8 JPMC0_3 : 1; /* JPMC0_3          */
    uint8 JPMC0_4 : 1; /* JPMC0_4          */
    uint8 JPMC0_5 : 1; /* JPMC0_5          */
    uint8         : 2; /* Reserved Bits    */
} __type287;
typedef struct
{                      /* Bit Access       */
    uint8 JPFC0_0 : 1; /* JPFC0_0          */
    uint8 JPFC0_1 : 1; /* JPFC0_1          */
    uint8 JPFC0_2 : 1; /* JPFC0_2          */
    uint8 JPFC0_3 : 1; /* JPFC0_3          */
    uint8         : 1; /* Reserved Bits    */
    uint8 JPFC0_5 : 1; /* JPFC0_5          */
    uint8         : 2; /* Reserved Bits    */
} __type288;
typedef struct
{                       /* Bit Access       */
    uint8 JPFCE0_0 : 1; /* JPFCE0_0         */
    uint8 JPFCE0_1 : 1; /* JPFCE0_1         */
    uint8 JPFCE0_2 : 1; /* JPFCE0_2         */
    uint8 JPFCE0_3 : 1; /* JPFCE0_3         */
    uint8          : 1; /* Reserved Bits    */
    uint8 JPFCE0_5 : 1; /* JPFCE0_5         */
    uint8          : 2; /* Reserved Bits    */
} __type289;
typedef struct
{                          /* Bit Access       */
    uint32 JPMSR0_0  : 1;  /* JPMSR0_0         */
    uint32 JPMSR0_1  : 1;  /* JPMSR0_1         */
    uint32 JPMSR0_2  : 1;  /* JPMSR0_2         */
    uint32 JPMSR0_3  : 1;  /* JPMSR0_3         */
    uint32 JPMSR0_4  : 1;  /* JPMSR0_4         */
    uint32 JPMSR0_5  : 1;  /* JPMSR0_5         */
    uint32           : 10; /* Reserved Bits    */
    uint32 JPMSR0_16 : 1;  /* JPMSR0_16        */
    uint32 JPMSR0_17 : 1;  /* JPMSR0_17        */
    uint32 JPMSR0_18 : 1;  /* JPMSR0_18        */
    uint32 JPMSR0_19 : 1;  /* JPMSR0_19        */
    uint32 JPMSR0_20 : 1;  /* JPMSR0_20        */
    uint32 JPMSR0_21 : 1;  /* JPMSR0_21        */
    uint32           : 10; /* Reserved Bits    */
} __type290;
typedef struct
{                           /* Bit Access       */
    uint32 JPMCSR0_0  : 1;  /* JPMCSR0_0        */
    uint32 JPMCSR0_1  : 1;  /* JPMCSR0_1        */
    uint32 JPMCSR0_2  : 1;  /* JPMCSR0_2        */
    uint32 JPMCSR0_3  : 1;  /* JPMCSR0_3        */
    uint32 JPMCSR0_4  : 1;  /* JPMCSR0_4        */
    uint32 JPMCSR0_5  : 1;  /* JPMCSR0_5        */
    uint32            : 10; /* Reserved Bits    */
    uint32 JPMCSR0_16 : 1;  /* JPMCSR0_16       */
    uint32 JPMCSR0_17 : 1;  /* JPMCSR0_17       */
    uint32 JPMCSR0_18 : 1;  /* JPMCSR0_18       */
    uint32 JPMCSR0_19 : 1;  /* JPMCSR0_19       */
    uint32 JPMCSR0_20 : 1;  /* JPMCSR0_20       */
    uint32 JPMCSR0_21 : 1;  /* JPMCSR0_21       */
    uint32            : 10; /* Reserved Bits    */
} __type291;
typedef struct
{                       /* Bit Access       */
    uint8 JPINV0_0 : 1; /* JPINV0_0         */
    uint8 JPINV0_1 : 1; /* JPINV0_1         */
    uint8 JPINV0_2 : 1; /* JPINV0_2         */
    uint8 JPINV0_3 : 1; /* JPINV0_3         */
    uint8 JPINV0_4 : 1; /* JPINV0_4         */
    uint8 JPINV0_5 : 1; /* JPINV0_5         */
    uint8          : 2; /* Reserved Bits    */
} __type292;
typedef struct
{                                 /* Bit Access       */
    uint32 PCR_JPFC0_0       : 1; /* PCR_JPFC0_0      */
    uint32 PCR_JPFCE0_0      : 1; /* PCR_JPFCE0_0     */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPM0_0        : 1; /* PCR_JPM0_0       */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPMC0_0       : 1; /* PCR_JPMC0_0      */
    uint32                   : 1; /* Reserved Bits    */
    const uint32 PCR_JPPR0_0 : 1; /* PCR_JPPR0_0      */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JP0_0         : 1; /* PCR_JP0_0        */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPIBC0_0      : 1; /* PCR_JPIBC0_0     */
    uint32 PCR_JPBDC0_0      : 1; /* PCR_JPBDC0_0     */
    uint32 PCR_JPD0_0        : 1; /* PCR_JPD0_0       */
    uint32 PCR_JPU0_0        : 1; /* PCR_JPU0_0       */
    uint32 PCR_JPIS0_0       : 1; /* PCR_JPIS0_0      */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPISA0_0      : 1; /* PCR_JPISA0_0     */
    uint32                   : 5; /* Reserved Bits    */
    uint32 PCR_JPODC0_0      : 1; /* PCR_JPODC0_0     */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPINV0_0      : 1; /* PCR_JPINV0_0     */
    uint32                   : 1; /* Reserved Bits    */
} __type293;
typedef struct
{                                 /* Bit Access       */
    uint32 PCR_JPFC0_1       : 1; /* PCR_JPFC0_1      */
    uint32 PCR_JPFCE0_1      : 1; /* PCR_JPFCE0_1     */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPM0_1        : 1; /* PCR_JPM0_1       */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPMC0_1       : 1; /* PCR_JPMC0_1      */
    uint32                   : 1; /* Reserved Bits    */
    const uint32 PCR_JPPR0_1 : 1; /* PCR_JPPR0_1      */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JP0_1         : 1; /* PCR_JP0_1        */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPIBC0_1      : 1; /* PCR_JPIBC0_1     */
    uint32 PCR_JPBDC0_1      : 1; /* PCR_JPBDC0_1     */
    uint32 PCR_JPD0_1        : 1; /* PCR_JPD0_1       */
    uint32 PCR_JPU0_1        : 1; /* PCR_JPU0_1       */
    uint32                   : 4; /* Reserved Bits    */
    uint32 PCR_JPDSC0_1      : 1; /* PCR_JPDSC0_1     */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPODC0_1      : 1; /* PCR_JPODC0_1     */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPINV0_1      : 1; /* PCR_JPINV0_1     */
    uint32                   : 1; /* Reserved Bits    */
} __type294;
typedef struct
{                                 /* Bit Access       */
    uint32 PCR_JPFC0_2       : 1; /* PCR_JPFC0_2      */
    uint32 PCR_JPFCE0_2      : 1; /* PCR_JPFCE0_2     */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPM0_2        : 1; /* PCR_JPM0_2       */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPMC0_2       : 1; /* PCR_JPMC0_2      */
    uint32                   : 1; /* Reserved Bits    */
    const uint32 PCR_JPPR0_2 : 1; /* PCR_JPPR0_2      */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JP0_2         : 1; /* PCR_JP0_2        */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPIBC0_2      : 1; /* PCR_JPIBC0_2     */
    uint32 PCR_JPBDC0_2      : 1; /* PCR_JPBDC0_2     */
    uint32 PCR_JPD0_2        : 1; /* PCR_JPD0_2       */
    uint32 PCR_JPU0_2        : 1; /* PCR_JPU0_2       */
    uint32 PCR_JPIS0_2       : 1; /* PCR_JPIS0_2      */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPISA0_2      : 1; /* PCR_JPISA0_2     */
    uint32                   : 5; /* Reserved Bits    */
    uint32 PCR_JPODC0_2      : 1; /* PCR_JPODC0_2     */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPINV0_2      : 1; /* PCR_JPINV0_2     */
    uint32                   : 1; /* Reserved Bits    */
} __type295;
typedef struct
{                                 /* Bit Access       */
    uint32 PCR_JPFC0_3       : 1; /* PCR_JPFC0_3      */
    uint32 PCR_JPFCE0_3      : 1; /* PCR_JPFCE0_3     */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPM0_3        : 1; /* PCR_JPM0_3       */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPMC0_3       : 1; /* PCR_JPMC0_3      */
    uint32                   : 1; /* Reserved Bits    */
    const uint32 PCR_JPPR0_3 : 1; /* PCR_JPPR0_3      */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JP0_3         : 1; /* PCR_JP0_3        */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPIBC0_3      : 1; /* PCR_JPIBC0_3     */
    uint32 PCR_JPBDC0_3      : 1; /* PCR_JPBDC0_3     */
    uint32 PCR_JPD0_3        : 1; /* PCR_JPD0_3       */
    uint32 PCR_JPU0_3        : 1; /* PCR_JPU0_3       */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPISA0_3      : 1; /* PCR_JPISA0_3     */
    uint32                   : 5; /* Reserved Bits    */
    uint32 PCR_JPODC0_3      : 1; /* PCR_JPODC0_3     */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPINV0_3      : 1; /* PCR_JPINV0_3     */
    uint32                   : 1; /* Reserved Bits    */
} __type296;
typedef struct
{                                 /* Bit Access       */
    uint32                   : 4; /* Reserved Bits    */
    uint32 PCR_JPM0_4        : 1; /* PCR_JPM0_4       */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPMC0_4       : 1; /* PCR_JPMC0_4      */
    uint32                   : 1; /* Reserved Bits    */
    const uint32 PCR_JPPR0_4 : 1; /* PCR_JPPR0_4      */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JP0_4         : 1; /* PCR_JP0_4        */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPIBC0_4      : 1; /* PCR_JPIBC0_4     */
    uint32 PCR_JPBDC0_4      : 1; /* PCR_JPBDC0_4     */
    uint32 PCR_JPD0_4        : 1; /* PCR_JPD0_4       */
    uint32 PCR_JPU0_4        : 1; /* PCR_JPU0_4       */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPISA0_4      : 1; /* PCR_JPISA0_4     */
    uint32                   : 5; /* Reserved Bits    */
    uint32 PCR_JPODC0_4      : 1; /* PCR_JPODC0_4     */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPINV0_4      : 1; /* PCR_JPINV0_4     */
    uint32                   : 1; /* Reserved Bits    */
} __type297;
typedef struct
{                                 /* Bit Access       */
    uint32 PCR_JPFC0_5       : 1; /* PCR_JPFC0_5      */
    uint32 PCR_JPFCE0_5      : 1; /* PCR_JPFCE0_5     */
    uint32                   : 2; /* Reserved Bits    */
    uint32 PCR_JPM0_5        : 1; /* PCR_JPM0_5       */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPMC0_5       : 1; /* PCR_JPMC0_5      */
    uint32                   : 1; /* Reserved Bits    */
    const uint32 PCR_JPPR0_5 : 1; /* PCR_JPPR0_5      */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JP0_5         : 1; /* PCR_JP0_5        */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPIBC0_5      : 1; /* PCR_JPIBC0_5     */
    uint32 PCR_JPBDC0_5      : 1; /* PCR_JPBDC0_5     */
    uint32 PCR_JPD0_5        : 1; /* PCR_JPD0_5       */
    uint32 PCR_JPU0_5        : 1; /* PCR_JPU0_5       */
    uint32                   : 4; /* Reserved Bits    */
    uint32 PCR_JPDSC0_5      : 1; /* PCR_JPDSC0_5     */
    uint32                   : 3; /* Reserved Bits    */
    uint32 PCR_JPODC0_5      : 1; /* PCR_JPODC0_5     */
    uint32                   : 1; /* Reserved Bits    */
    uint32 PCR_JPINV0_5      : 1; /* PCR_JPINV0_5     */
    uint32                   : 1; /* Reserved Bits    */
} __type298;
typedef struct
{                       /* Bit Access       */
    uint8 JPIBC0_0 : 1; /* JPIBC0_0         */
    uint8 JPIBC0_1 : 1; /* JPIBC0_1         */
    uint8 JPIBC0_2 : 1; /* JPIBC0_2         */
    uint8 JPIBC0_3 : 1; /* JPIBC0_3         */
    uint8 JPIBC0_4 : 1; /* JPIBC0_4         */
    uint8 JPIBC0_5 : 1; /* JPIBC0_5         */
    uint8          : 2; /* Reserved Bits    */
} __type299;
typedef struct
{                       /* Bit Access       */
    uint8 JPBDC0_0 : 1; /* JPBDC0_0         */
    uint8 JPBDC0_1 : 1; /* JPBDC0_1         */
    uint8 JPBDC0_2 : 1; /* JPBDC0_2         */
    uint8 JPBDC0_3 : 1; /* JPBDC0_3         */
    uint8 JPBDC0_4 : 1; /* JPBDC0_4         */
    uint8 JPBDC0_5 : 1; /* JPBDC0_5         */
    uint8          : 2; /* Reserved Bits    */
} __type300;
typedef struct
{                     /* Bit Access       */
    uint8 JPU0_0 : 1; /* JPU0_0           */
    uint8 JPU0_1 : 1; /* JPU0_1           */
    uint8 JPU0_2 : 1; /* JPU0_2           */
    uint8 JPU0_3 : 1; /* JPU0_3           */
    uint8 JPU0_4 : 1; /* JPU0_4           */
    uint8 JPU0_5 : 1; /* JPU0_5           */
    uint8        : 2; /* Reserved Bits    */
} __type301;
typedef struct
{                     /* Bit Access       */
    uint8 JPD0_0 : 1; /* JPD0_0           */
    uint8 JPD0_1 : 1; /* JPD0_1           */
    uint8 JPD0_2 : 1; /* JPD0_2           */
    uint8 JPD0_3 : 1; /* JPD0_3           */
    uint8 JPD0_4 : 1; /* JPD0_4           */
    uint8 JPD0_5 : 1; /* JPD0_5           */
    uint8        : 2; /* Reserved Bits    */
} __type302;
typedef struct
{                         /* Bit Access       */
    uint32 JPODC0_0 : 1;  /* JPODC0_0         */
    uint32 JPODC0_1 : 1;  /* JPODC0_1         */
    uint32 JPODC0_2 : 1;  /* JPODC0_2         */
    uint32 JPODC0_3 : 1;  /* JPODC0_3         */
    uint32 JPODC0_4 : 1;  /* JPODC0_4         */
    uint32 JPODC0_5 : 1;  /* JPODC0_5         */
    uint32          : 26; /* Reserved Bits    */
} __type303;
typedef struct
{                         /* Bit Access       */
    uint32          : 1;  /* Reserved Bits    */
    uint32 JPDSC0_1 : 1;  /* JPDSC0_1         */
    uint32          : 3;  /* Reserved Bits    */
    uint32 JPDSC0_5 : 1;  /* JPDSC0_5         */
    uint32          : 26; /* Reserved Bits    */
} __type304;
typedef struct
{                      /* Bit Access       */
    uint8 JPIS0_0 : 1; /* JPIS0_0          */
    uint8         : 1; /* Reserved Bits    */
    uint8 JPIS0_2 : 1; /* JPIS0_2          */
    uint8         : 5; /* Reserved Bits    */
} __type305;
typedef struct
{                       /* Bit Access       */
    uint8 JPISA0_0 : 1; /* JPISA0_0         */
    uint8          : 1; /* Reserved Bits    */
    uint8 JPISA0_2 : 1; /* JPISA0_2         */
    uint8 JPISA0_3 : 1; /* JPISA0_3         */
    uint8 JPISA0_4 : 1; /* JPISA0_4         */
    uint8          : 3; /* Reserved Bits    */
} __type306;
typedef struct
{                        /* Bit Access       */
    uint32 JPPCMD0 : 8;  /* JPPCMD0[7:0]     */
    uint32         : 24; /* Reserved Bits    */
} __type307;
typedef struct
{                                    /* Bit Access       */
    const uint32 JPPROTS0PRERR : 1;  /* JPPROTS0PRERR    */
    uint32                     : 31; /* Reserved Bits    */
} __type308;
typedef struct
{                    /* Bit Access       */
    uint32 PUP : 1;  /* PUP              */
    uint32     : 31; /* Reserved Bits    */
} __type309;
typedef struct
{                   /* Bit Access       */
    uint32 PC : 8;  /* PC[7:0]          */
    uint32    : 24; /* Reserved Bits    */
} __type310;
typedef struct
{                            /* Bit Access       */
    const uint32 PRERR : 1;  /* PRERR            */
    uint32             : 31; /* Reserved Bits    */
} __type311;
typedef struct
{                         /* Bit Access       */
    const uint8 IDST : 1; /* IDST             */
    uint8            : 7; /* Reserved Bits    */
    uint8            : 8; /* Reserved Bits    */
    uint8            : 8; /* Reserved Bits    */
    uint8            : 8; /* Reserved Bits    */
} __type312;
typedef struct
{                        /* Bit Access       */
    uint8           : 7; /* Reserved Bits    */
    const uint8 FWE : 1; /* FWE              */
} __type313;
typedef struct
{                          /* Bit Access       */
    const uint8 ECRCT : 1; /* ECRCT            */
    uint8             : 2; /* Reserved Bits    */
    uint8       DFAE  : 1; /* DFAE             */
    const uint8 CMDLK : 1; /* CMDLK            */
    uint8             : 2; /* Reserved Bits    */
    uint8 CFAE        : 1; /* CFAE             */
} __type314;
typedef struct
{                      /* Bit Access       */
    uint8 ECRCTIE : 1; /* ECRCTIE          */
    uint8         : 2; /* Reserved Bits    */
    uint8 DFAEIE  : 1; /* DFAEIE           */
    uint8 CMDLKIE : 1; /* CMDLKIE          */
    uint8         : 2; /* Reserved Bits    */
    uint8 CFAEIE  : 1; /* CFAEIE           */
} __type315;
typedef struct
{                    /* Bit Access       */
    uint16      : 1; /* Reserved Bits    */
    uint16 CFAS : 1; /* CFAS             */
    uint16      : 6; /* Reserved Bits    */
    uint16 KEY  : 8; /* KEY[15:8]        */
} __type316;
typedef struct
{                        /* Bit Access       */
    uint16 FCRME    : 1; /* FCRME            */
    uint16 FRAMTRAN : 1; /* FRAMTRAN         */
    uint16          : 6; /* Reserved Bits    */
    uint16 KEY      : 8; /* KEY[15:8]        */
} __type317;
typedef struct
{                            /* Bit Access       */
    const uint8 FRCRCT  : 1; /* FRCRCT           */
    const uint8 FRDTCT  : 1; /* FRDTCT           */
    const uint8 TBLCRCT : 1; /* TBLCRCT          */
    const uint8 TBLDTCT : 1; /* TBLDTCT          */
    const uint8 CFGCRCT : 1; /* CFGCRCT          */
    const uint8 CFGDTCT : 1; /* CFGDTCT          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 PRGSPD  : 1; /* PRGSPD           */
    const uint8 ERSSPD  : 1; /* ERSSPD           */
    const uint8 DBFULL  : 1; /* DBFULL           */
    const uint8 SUSRDY  : 1; /* SUSRDY           */
    const uint8 PRGERR  : 1; /* PRGERR           */
    const uint8 ERSERR  : 1; /* ERSERR           */
    const uint8 ILGLERR : 1; /* ILGLERR          */
    const uint8 FRDY    : 1; /* FRDY             */
    const uint8 OTPCRCT : 1; /* OTPCRCT          */
    const uint8 OTPDTCT : 1; /* OTPDTCT          */
    const uint8 EBFULL  : 1; /* EBFULL           */
    uint8               : 5; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
} __type318;
typedef struct
{                       /* Bit Access       */
    uint16 FENTRYC : 1; /* FENTRYC          */
    uint16         : 6; /* Reserved Bits    */
    uint16 FENTRYD : 1; /* FENTRYD          */
    uint16 KEY     : 8; /* KEY[15:8]        */
} __type319;
typedef struct
{                       /* Bit Access       */
    uint16 FPROTCN : 1; /* FPROTCN          */
    uint16         : 7; /* Reserved Bits    */
    uint16 KEY     : 8; /* KEY[15:8]        */
} __type320;
typedef struct
{                      /* Bit Access       */
    uint16 SUINIT : 1; /* SUINIT           */
    uint16        : 7; /* Reserved Bits    */
    uint16 KEY    : 8; /* KEY[15:8]        */
} __type321;
typedef struct
{                            /* Bit Access       */
    const uint8 FLOCKST : 1; /* FLOCKST          */
    uint8               : 7; /* Reserved Bits    */
} __type322;
typedef struct
{                                /* Bit Access       */
    const uint32 FRFSTEADR : 12; /* FRFSTEADR[11:0]  */
    uint32                 : 20; /* Reserved Bits    */
} __type323;
typedef struct
{                            /* Bit Access       */
    const uint8 RTECRCT : 1; /* RTECRCT          */
    const uint8 RTEDTCT : 1; /* RTEDTCT          */
    uint8               : 6; /* Reserved Bits    */
} __type324;
typedef struct
{                     /* Bit Access       */
    uint8 RTECIE : 1; /* RTECIE           */
    uint8 RTEDIE : 1; /* RTEDIE           */
    uint8        : 6; /* Reserved Bits    */
} __type325;
typedef struct
{                           /* Bit Access       */
    const uint16 PCMDR : 8; /* PCMDR[7:0]       */
    const uint16 CMDR  : 8; /* CMDR[15:8]       */
} __type326;
typedef struct
{                         /* Bit Access       */
    uint16           : 4; /* Reserved Bits    */
    uint16 FRECCSEL  : 1; /* FRECCSEL         */
    uint16 FRECCDISE : 1; /* FRECCDISE        */
    uint16           : 2; /* Reserved Bits    */
    uint16 KEY       : 8; /* KEY[15:8]        */
} __type327;
typedef struct
{                             /* Bit Access       */
    const uint16 PEERRST : 8; /* PEERRST[7:0]     */
    uint16               : 8; /* Reserved Bits    */
} __type328;
typedef struct
{                    /* Bit Access       */
    uint8 BCDIR : 1; /* BCDIR            */
    uint8       : 7; /* Reserved Bits    */
} __type329;
typedef struct
{                         /* Bit Access       */
    const uint8 BCST : 1; /* BCST             */
    uint8            : 7; /* Reserved Bits    */
} __type330;
typedef struct
{                            /* Bit Access       */
    const uint32 PSADR : 19; /* PSADR[18:0]      */
    uint32             : 13; /* Reserved Bits    */
} __type331;
typedef struct
{                        /* Bit Access       */
    uint16 ESUSPMD : 1;  /* ESUSPMD          */
    uint16         : 15; /* Reserved Bits    */
} __type332;
typedef struct
{                    /* Bit Access       */
    uint16 PCKA : 8; /* PCKA[7:0]        */
    uint16 KEY  : 8; /* KEY[15:8]        */
} __type333;
typedef struct
{                     /* Bit Access       */
    uint8 EMSQMD : 4; /* EMSQMD[3:0]      */
    uint8        : 2; /* Reserved Bits    */
    uint8 ERREMU : 1; /* ERREMU           */
    uint8 EMMODE : 1; /* EMMODE           */
} __type334;
typedef struct
{                      /* Bit Access       */
    uint32 FLAPE : 32; /* FLAPE[31:0]      */
} __type335;
typedef struct
{                           /* Bit Access       */
    const uint16 FECCM : 9; /* FECCM[8:0]       */
    uint16             : 7; /* Reserved Bits    */
} __type336;
typedef struct
{                       /* Bit Access       */
    uint16 ECCDISE : 1; /* ECCDISE          */
    uint16         : 3; /* Reserved Bits    */
    uint16 DECCVE  : 1; /* DECCVE           */
    uint16 CECCVE  : 1; /* CECCVE           */
    uint16         : 2; /* Reserved Bits    */
    uint16 KEY     : 8; /* KEY[15:8]        */
} __type337;
typedef struct
{                      /* Bit Access       */
    uint16 DMYECC : 9; /* DMYECC[8:0]      */
    uint16        : 7; /* Reserved Bits    */
} __type338;
typedef struct
{                        /* Bit Access       */
    uint32 XDBE01  : 1;  /* XDBE01           */
    uint32 XDBE03  : 1;  /* XDBE03           */
    uint32 XDBE05  : 1;  /* XDBE05           */
    uint32 XDBE07  : 1;  /* XDBE07           */
    uint32 XDBE09  : 1;  /* XDBE09           */
    uint32 XDBE011 : 1;  /* XDBE011          */
    uint32 XDBE013 : 1;  /* XDBE013          */
    uint32         : 1;  /* Reserved Bits    */
    uint32 XDBE11  : 1;  /* XDBE11           */
    uint32 XDBE13  : 1;  /* XDBE13           */
    uint32 XDBE15  : 1;  /* XDBE15           */
    uint32 XDBE17  : 1;  /* XDBE17           */
    uint32 XDBE19  : 1;  /* XDBE19           */
    uint32         : 19; /* Reserved Bits    */
} __type339;
typedef struct
{                      /* Bit Access       */
    uint32 XDPE0 : 1;  /* XDPE0            */
    uint32 XDPE1 : 1;  /* XDPE1            */
    uint32 XDPE2 : 1;  /* XDPE2            */
    uint32 XDPE3 : 1;  /* XDPE3            */
    uint32 XDPE4 : 1;  /* XDPE4            */
    uint32 XDPE5 : 1;  /* XDPE5            */
    uint32 XDPE6 : 1;  /* XDPE6            */
    uint32 XDPE7 : 1;  /* XDPE7            */
    uint32       : 24; /* Reserved Bits    */
} __type340;
typedef struct
{                      /* Bit Access       */
    uint32 XDPE0 : 1;  /* XDPE0            */
    uint32 XDPE1 : 1;  /* XDPE1            */
    uint32 XDPE2 : 1;  /* XDPE2            */
    uint32       : 29; /* Reserved Bits    */
} __type341;
typedef struct
{                   /* Bit Access       */
    uint8 TMSL : 1; /* TMSL             */
    uint8      : 7; /* Reserved Bits    */
} __type342;
typedef struct
{                  /* Bit Access       */
    uint8 SL0 : 1; /* SL0              */
    uint8     : 7; /* Reserved Bits    */
} __type343;
typedef struct
{                      /* Bit Access       */
    uint32 MIE000 : 1; /* MIE000           */
    uint32 MIE001 : 1; /* MIE001           */
    uint32 MIE002 : 1; /* MIE002           */
    uint32 MIE003 : 1; /* MIE003           */
    uint32 MIE004 : 1; /* MIE004           */
    uint32 MIE005 : 1; /* MIE005           */
    uint32 MIE006 : 1; /* MIE006           */
    uint32 MIE007 : 1; /* MIE007           */
    uint32 MIE008 : 1; /* MIE008           */
    uint32 MIE009 : 1; /* MIE009           */
    uint32 MIE010 : 1; /* MIE010           */
    uint32 MIE011 : 1; /* MIE011           */
    uint32 MIE012 : 1; /* MIE012           */
    uint32 MIE013 : 1; /* MIE013           */
    uint32 MIE014 : 1; /* MIE014           */
    uint32 MIE015 : 1; /* MIE015           */
    uint32 MIE016 : 1; /* MIE016           */
    uint32 MIE017 : 1; /* MIE017           */
    uint32 MIE018 : 1; /* MIE018           */
    uint32 MIE019 : 1; /* MIE019           */
    uint32 MIE020 : 1; /* MIE020           */
    uint32 MIE021 : 1; /* MIE021           */
    uint32 MIE022 : 1; /* MIE022           */
    uint32 MIE023 : 1; /* MIE023           */
    uint32 MIE024 : 1; /* MIE024           */
    uint32 MIE025 : 1; /* MIE025           */
    uint32 MIE026 : 1; /* MIE026           */
    uint32 MIE027 : 1; /* MIE027           */
    uint32 MIE028 : 1; /* MIE028           */
    uint32 MIE029 : 1; /* MIE029           */
    uint32 MIE030 : 1; /* MIE030           */
    uint32 MIE031 : 1; /* MIE031           */
} __type344;
typedef struct
{                       /* Bit Access       */
    uint32 MIE100 : 1;  /* MIE100           */
    uint32 MIE101 : 1;  /* MIE101           */
    uint32 MIE102 : 1;  /* MIE102           */
    uint32 MIE103 : 1;  /* MIE103           */
    uint32 MIE104 : 1;  /* MIE104           */
    uint32 MIE105 : 1;  /* MIE105           */
    uint32 MIE106 : 1;  /* MIE106           */
    uint32 MIE107 : 1;  /* MIE107           */
    uint32 MIE108 : 1;  /* MIE108           */
    uint32 MIE109 : 1;  /* MIE109           */
    uint32 MIE110 : 1;  /* MIE110           */
    uint32 MIE111 : 1;  /* MIE111           */
    uint32 MIE112 : 1;  /* MIE112           */
    uint32 MIE113 : 1;  /* MIE113           */
    uint32 MIE114 : 1;  /* MIE114           */
    uint32 MIE115 : 1;  /* MIE115           */
    uint32        : 16; /* Reserved Bits    */
} __type345;
typedef struct
{                       /* Bit Access       */
    uint32 NMIE000 : 1; /* NMIE000          */
    uint32 NMIE001 : 1; /* NMIE001          */
    uint32 NMIE002 : 1; /* NMIE002          */
    uint32 NMIE003 : 1; /* NMIE003          */
    uint32 NMIE004 : 1; /* NMIE004          */
    uint32 NMIE005 : 1; /* NMIE005          */
    uint32 NMIE006 : 1; /* NMIE006          */
    uint32 NMIE007 : 1; /* NMIE007          */
    uint32 NMIE008 : 1; /* NMIE008          */
    uint32 NMIE009 : 1; /* NMIE009          */
    uint32 NMIE010 : 1; /* NMIE010          */
    uint32 NMIE011 : 1; /* NMIE011          */
    uint32 NMIE012 : 1; /* NMIE012          */
    uint32 NMIE013 : 1; /* NMIE013          */
    uint32 NMIE014 : 1; /* NMIE014          */
    uint32 NMIE015 : 1; /* NMIE015          */
    uint32 NMIE016 : 1; /* NMIE016          */
    uint32 NMIE017 : 1; /* NMIE017          */
    uint32 NMIE018 : 1; /* NMIE018          */
    uint32 NMIE019 : 1; /* NMIE019          */
    uint32 NMIE020 : 1; /* NMIE020          */
    uint32 NMIE021 : 1; /* NMIE021          */
    uint32 NMIE022 : 1; /* NMIE022          */
    uint32 NMIE023 : 1; /* NMIE023          */
    uint32 NMIE024 : 1; /* NMIE024          */
    uint32 NMIE025 : 1; /* NMIE025          */
    uint32 NMIE026 : 1; /* NMIE026          */
    uint32 NMIE027 : 1; /* NMIE027          */
    uint32 NMIE028 : 1; /* NMIE028          */
    uint32 NMIE029 : 1; /* NMIE029          */
    uint32 NMIE030 : 1; /* NMIE030          */
    uint32 NMIE031 : 1; /* NMIE031          */
} __type346;
typedef struct
{                        /* Bit Access       */
    uint32 NMIE100 : 1;  /* NMIE100          */
    uint32 NMIE101 : 1;  /* NMIE101          */
    uint32 NMIE102 : 1;  /* NMIE102          */
    uint32 NMIE103 : 1;  /* NMIE103          */
    uint32 NMIE104 : 1;  /* NMIE104          */
    uint32 NMIE105 : 1;  /* NMIE105          */
    uint32 NMIE106 : 1;  /* NMIE106          */
    uint32 NMIE107 : 1;  /* NMIE107          */
    uint32 NMIE108 : 1;  /* NMIE108          */
    uint32 NMIE109 : 1;  /* NMIE109          */
    uint32 NMIE110 : 1;  /* NMIE110          */
    uint32 NMIE111 : 1;  /* NMIE111          */
    uint32 NMIE112 : 1;  /* NMIE112          */
    uint32 NMIE113 : 1;  /* NMIE113          */
    uint32 NMIE114 : 1;  /* NMIE114          */
    uint32 NMIE115 : 1;  /* NMIE115          */
    uint32         : 16; /* Reserved Bits    */
} __type347;
typedef struct
{                      /* Bit Access       */
    uint32 IRE000 : 1; /* IRE000           */
    uint32 IRE001 : 1; /* IRE001           */
    uint32 IRE002 : 1; /* IRE002           */
    uint32 IRE003 : 1; /* IRE003           */
    uint32 IRE004 : 1; /* IRE004           */
    uint32 IRE005 : 1; /* IRE005           */
    uint32 IRE006 : 1; /* IRE006           */
    uint32 IRE007 : 1; /* IRE007           */
    uint32 IRE008 : 1; /* IRE008           */
    uint32 IRE009 : 1; /* IRE009           */
    uint32 IRE010 : 1; /* IRE010           */
    uint32 IRE011 : 1; /* IRE011           */
    uint32 IRE012 : 1; /* IRE012           */
    uint32 IRE013 : 1; /* IRE013           */
    uint32 IRE014 : 1; /* IRE014           */
    uint32 IRE015 : 1; /* IRE015           */
    uint32 IRE016 : 1; /* IRE016           */
    uint32 IRE017 : 1; /* IRE017           */
    uint32 IRE018 : 1; /* IRE018           */
    uint32 IRE019 : 1; /* IRE019           */
    uint32 IRE020 : 1; /* IRE020           */
    uint32 IRE021 : 1; /* IRE021           */
    uint32 IRE022 : 1; /* IRE022           */
    uint32 IRE023 : 1; /* IRE023           */
    uint32 IRE024 : 1; /* IRE024           */
    uint32 IRE025 : 1; /* IRE025           */
    uint32 IRE026 : 1; /* IRE026           */
    uint32 IRE027 : 1; /* IRE027           */
    uint32 IRE028 : 1; /* IRE028           */
    uint32 IRE029 : 1; /* IRE029           */
    uint32 IRE030 : 1; /* IRE030           */
    uint32 IRE031 : 1; /* IRE031           */
} __type348;
typedef struct
{                       /* Bit Access       */
    uint32 IRE100 : 1;  /* IRE100           */
    uint32 IRE101 : 1;  /* IRE101           */
    uint32 IRE102 : 1;  /* IRE102           */
    uint32 IRE103 : 1;  /* IRE103           */
    uint32 IRE104 : 1;  /* IRE104           */
    uint32 IRE105 : 1;  /* IRE105           */
    uint32 IRE106 : 1;  /* IRE106           */
    uint32 IRE107 : 1;  /* IRE107           */
    uint32 IRE108 : 1;  /* IRE108           */
    uint32 IRE109 : 1;  /* IRE109           */
    uint32 IRE110 : 1;  /* IRE110           */
    uint32 IRE111 : 1;  /* IRE111           */
    uint32 IRE112 : 1;  /* IRE112           */
    uint32 IRE113 : 1;  /* IRE113           */
    uint32 IRE114 : 1;  /* IRE114           */
    uint32 IRE115 : 1;  /* IRE115           */
    uint32        : 13; /* Reserved Bits    */
    uint32 IRE129 : 1;  /* IRE129           */
    uint32        : 2;  /* Reserved Bits    */
} __type349;
typedef struct
{                      /* Bit Access       */
    uint16 EMK000 : 1; /* EMK000           */
    uint16 EMK001 : 1; /* EMK001           */
    uint16 EMK002 : 1; /* EMK002           */
    uint16 EMK003 : 1; /* EMK003           */
    uint16 EMK004 : 1; /* EMK004           */
    uint16 EMK005 : 1; /* EMK005           */
    uint16 EMK006 : 1; /* EMK006           */
    uint16 EMK007 : 1; /* EMK007           */
    uint16 EMK008 : 1; /* EMK008           */
    uint16 EMK009 : 1; /* EMK009           */
    uint16 EMK010 : 1; /* EMK010           */
    uint16 EMK011 : 1; /* EMK011           */
    uint16 EMK012 : 1; /* EMK012           */
    uint16 EMK013 : 1; /* EMK013           */
    uint16 EMK014 : 1; /* EMK014           */
    uint16 EMK015 : 1; /* EMK015           */
    uint16 EMK016 : 1; /* EMK016           */
    uint16 EMK017 : 1; /* EMK017           */
    uint16 EMK018 : 1; /* EMK018           */
    uint16 EMK019 : 1; /* EMK019           */
    uint16 EMK020 : 1; /* EMK020           */
    uint16 EMK021 : 1; /* EMK021           */
    uint16 EMK022 : 1; /* EMK022           */
    uint16 EMK023 : 1; /* EMK023           */
    uint16 EMK024 : 1; /* EMK024           */
    uint16 EMK025 : 1; /* EMK025           */
    uint16 EMK026 : 1; /* EMK026           */
    uint16 EMK027 : 1; /* EMK027           */
    uint16 EMK028 : 1; /* EMK028           */
    uint16 EMK029 : 1; /* EMK029           */
    uint16 EMK030 : 1; /* EMK030           */
    uint16 EMK031 : 1; /* EMK031           */
} __type350;
typedef struct
{                       /* Bit Access       */
    uint32 EMK100 : 1;  /* EMK100           */
    uint32 EMK101 : 1;  /* EMK101           */
    uint32 EMK102 : 1;  /* EMK102           */
    uint32 EMK103 : 1;  /* EMK103           */
    uint32 EMK104 : 1;  /* EMK104           */
    uint32 EMK105 : 1;  /* EMK105           */
    uint32 EMK106 : 1;  /* EMK106           */
    uint32 EMK107 : 1;  /* EMK107           */
    uint32 EMK108 : 1;  /* EMK108           */
    uint32 EMK109 : 1;  /* EMK109           */
    uint32 EMK110 : 1;  /* EMK110           */
    uint32 EMK111 : 1;  /* EMK111           */
    uint32 EMK112 : 1;  /* EMK112           */
    uint32 EMK113 : 1;  /* EMK113           */
    uint32 EMK114 : 1;  /* EMK114           */
    uint32 EMK115 : 1;  /* EMK115           */
    uint32        : 13; /* Reserved Bits    */
    uint32 EMK129 : 1;  /* EMK129           */
    uint32        : 2;  /* Reserved Bits    */
} __type351;
typedef struct
{                        /* Bit Access       */
    uint32 CLSSE000 : 1; /* CLSSE000         */
    uint32 CLSSE001 : 1; /* CLSSE001         */
    uint32 CLSSE002 : 1; /* CLSSE002         */
    uint32 CLSSE003 : 1; /* CLSSE003         */
    uint32 CLSSE004 : 1; /* CLSSE004         */
    uint32 CLSSE005 : 1; /* CLSSE005         */
    uint32 CLSSE006 : 1; /* CLSSE006         */
    uint32 CLSSE007 : 1; /* CLSSE007         */
    uint32 CLSSE008 : 1; /* CLSSE008         */
    uint32 CLSSE009 : 1; /* CLSSE009         */
    uint32 CLSSE010 : 1; /* CLSSE010         */
    uint32 CLSSE011 : 1; /* CLSSE011         */
    uint32 CLSSE012 : 1; /* CLSSE012         */
    uint32 CLSSE013 : 1; /* CLSSE013         */
    uint32 CLSSE014 : 1; /* CLSSE014         */
    uint32 CLSSE015 : 1; /* CLSSE015         */
    uint32 CLSSE016 : 1; /* CLSSE016         */
    uint32 CLSSE017 : 1; /* CLSSE017         */
    uint32 CLSSE018 : 1; /* CLSSE018         */
    uint32 CLSSE019 : 1; /* CLSSE019         */
    uint32 CLSSE020 : 1; /* CLSSE020         */
    uint32 CLSSE021 : 1; /* CLSSE021         */
    uint32 CLSSE022 : 1; /* CLSSE022         */
    uint32 CLSSE023 : 1; /* CLSSE023         */
    uint32 CLSSE024 : 1; /* CLSSE024         */
    uint32 CLSSE025 : 1; /* CLSSE025         */
    uint32 CLSSE026 : 1; /* CLSSE026         */
    uint32 CLSSE027 : 1; /* CLSSE027         */
    uint32 CLSSE028 : 1; /* CLSSE028         */
    uint32 CLSSE029 : 1; /* CLSSE029         */
    uint32 CLSSE030 : 1; /* CLSSE030         */
    uint32 CLSSE031 : 1; /* CLSSE031         */
} __type352;
typedef struct
{                         /* Bit Access       */
    uint32 CLSSE100 : 1;  /* CLSSE100         */
    uint32 CLSSE101 : 1;  /* CLSSE101         */
    uint32 CLSSE102 : 1;  /* CLSSE102         */
    uint32 CLSSE103 : 1;  /* CLSSE103         */
    uint32 CLSSE104 : 1;  /* CLSSE104         */
    uint32 CLSSE105 : 1;  /* CLSSE105         */
    uint32 CLSSE106 : 1;  /* CLSSE106         */
    uint32 CLSSE107 : 1;  /* CLSSE107         */
    uint32 CLSSE108 : 1;  /* CLSSE108         */
    uint32 CLSSE109 : 1;  /* CLSSE109         */
    uint32 CLSSE110 : 1;  /* CLSSE110         */
    uint32 CLSSE111 : 1;  /* CLSSE111         */
    uint32 CLSSE112 : 1;  /* CLSSE112         */
    uint32 CLSSE113 : 1;  /* CLSSE113         */
    uint32 CLSSE114 : 1;  /* CLSSE114         */
    uint32 CLSSE115 : 1;  /* CLSSE115         */
    uint32          : 13; /* Reserved Bits    */
    uint32 CLSSE129 : 1;  /* CLSSE129         */
    uint32 CLSSE130 : 1;  /* CLSSE130         */
    uint32          : 1;  /* Reserved Bits    */
} __type353;
typedef struct
{                     /* Bit Access       */
    uint32 REG1 : 8;  /* REG1[7:0]        */
    uint32      : 24; /* Reserved Bits    */
} __type354;
typedef struct
{                          /* Bit Access       */
    const uint8 PRERR : 1; /* PRERR            */
    uint8             : 7; /* Reserved Bits    */
} __type355;
typedef struct
{                    /* Bit Access       */
    uint8 PE000 : 1; /* PE000            */
    uint8 PE001 : 1; /* PE001            */
    uint8 PE002 : 1; /* PE002            */
    uint8 PE003 : 1; /* PE003            */
    uint8 PE004 : 1; /* PE004            */
    uint8 PE005 : 1; /* PE005            */
    uint8 PE006 : 1; /* PE006            */
    uint8 PE007 : 1; /* PE007            */
    uint8 PE008 : 1; /* PE008            */
    uint8 PE009 : 1; /* PE009            */
    uint8 PE010 : 1; /* PE010            */
    uint8 PE011 : 1; /* PE011            */
    uint8 PE012 : 1; /* PE012            */
    uint8 PE013 : 1; /* PE013            */
    uint8 PE014 : 1; /* PE014            */
    uint8 PE015 : 1; /* PE015            */
    uint8 PE016 : 1; /* PE016            */
    uint8 PE017 : 1; /* PE017            */
    uint8 PE018 : 1; /* PE018            */
    uint8 PE019 : 1; /* PE019            */
    uint8 PE020 : 1; /* PE020            */
    uint8 PE021 : 1; /* PE021            */
    uint8 PE022 : 1; /* PE022            */
    uint8 PE023 : 1; /* PE023            */
    uint8 PE024 : 1; /* PE024            */
    uint8 PE025 : 1; /* PE025            */
    uint8 PE026 : 1; /* PE026            */
    uint8 PE027 : 1; /* PE027            */
    uint8 PE028 : 1; /* PE028            */
    uint8 PE029 : 1; /* PE029            */
    uint8 PE030 : 1; /* PE030            */
    uint8 PE031 : 1; /* PE031            */
} __type356;
typedef struct
{                    /* Bit Access       */
    uint8 PE100 : 1; /* PE100            */
    uint8 PE101 : 1; /* PE101            */
    uint8 PE102 : 1; /* PE102            */
    uint8 PE103 : 1; /* PE103            */
    uint8 PE104 : 1; /* PE104            */
    uint8 PE105 : 1; /* PE105            */
    uint8 PE106 : 1; /* PE106            */
    uint8 PE107 : 1; /* PE107            */
    uint8 PE108 : 1; /* PE108            */
    uint8 PE109 : 1; /* PE109            */
    uint8 PE110 : 1; /* PE110            */
    uint8 PE111 : 1; /* PE111            */
    uint8 PE112 : 1; /* PE112            */
    uint8 PE113 : 1; /* PE113            */
    uint8 PE114 : 1; /* PE114            */
    uint8 PE115 : 1; /* PE115            */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 5; /* Reserved Bits    */
    uint8 PE129 : 1; /* PE129            */
    uint8       : 2; /* Reserved Bits    */
} __type357;
typedef struct
{                  /* Bit Access       */
    uint8 STA : 1; /* STA              */
    uint8 STP : 1; /* STP              */
    uint8     : 6; /* Reserved Bits    */
} __type358;
typedef struct
{                     /* Bit Access       */
    uint32 TE000 : 1; /* TE000            */
    uint32 TE001 : 1; /* TE001            */
    uint32 TE002 : 1; /* TE002            */
    uint32 TE003 : 1; /* TE003            */
    uint32 TE004 : 1; /* TE004            */
    uint32 TE005 : 1; /* TE005            */
    uint32 TE006 : 1; /* TE006            */
    uint32 TE007 : 1; /* TE007            */
    uint32 TE008 : 1; /* TE008            */
    uint32 TE009 : 1; /* TE009            */
    uint32 TE010 : 1; /* TE010            */
    uint32 TE011 : 1; /* TE011            */
    uint32 TE012 : 1; /* TE012            */
    uint32 TE013 : 1; /* TE013            */
    uint32 TE014 : 1; /* TE014            */
    uint32 TE015 : 1; /* TE015            */
    uint32 TE016 : 1; /* TE016            */
    uint32 TE017 : 1; /* TE017            */
    uint32 TE018 : 1; /* TE018            */
    uint32 TE019 : 1; /* TE019            */
    uint32 TE020 : 1; /* TE020            */
    uint32 TE021 : 1; /* TE021            */
    uint32 TE022 : 1; /* TE022            */
    uint32 TE023 : 1; /* TE023            */
    uint32 TE024 : 1; /* TE024            */
    uint32 TE025 : 1; /* TE025            */
    uint32 TE026 : 1; /* TE026            */
    uint32 TE027 : 1; /* TE027            */
    uint32 TE028 : 1; /* TE028            */
    uint32 TE029 : 1; /* TE029            */
    uint32 TE030 : 1; /* TE030            */
    uint32 TE031 : 1; /* TE031            */
} __type359;
typedef struct
{                      /* Bit Access       */
    uint32 TE100 : 1;  /* TE100            */
    uint32 TE101 : 1;  /* TE101            */
    uint32 TE102 : 1;  /* TE102            */
    uint32 TE103 : 1;  /* TE103            */
    uint32 TE104 : 1;  /* TE104            */
    uint32 TE105 : 1;  /* TE105            */
    uint32 TE106 : 1;  /* TE106            */
    uint32 TE107 : 1;  /* TE107            */
    uint32 TE108 : 1;  /* TE108            */
    uint32 TE109 : 1;  /* TE109            */
    uint32 TE110 : 1;  /* TE110            */
    uint32 TE111 : 1;  /* TE111            */
    uint32 TE112 : 1;  /* TE112            */
    uint32 TE113 : 1;  /* TE113            */
    uint32 TE114 : 1;  /* TE114            */
    uint32 TE115 : 1;  /* TE115            */
    uint32       : 16; /* Reserved Bits    */
} __type360;
typedef struct
{                     /* Bit Access       */
    uint32 TE200 : 1; /* TE200            */
    uint32 TE201 : 1; /* TE201            */
    uint32 TE202 : 1; /* TE202            */
    uint32 TE203 : 1; /* TE203            */
    uint32 TE204 : 1; /* TE204            */
    uint32 TE205 : 1; /* TE205            */
    uint32 TE206 : 1; /* TE206            */
    uint32 TE207 : 1; /* TE207            */
    uint32 TE208 : 1; /* TE208            */
    uint32 TE209 : 1; /* TE209            */
    uint32 TE210 : 1; /* TE210            */
    uint32 TE211 : 1; /* TE211            */
    uint32 TE212 : 1; /* TE212            */
    uint32 TE213 : 1; /* TE213            */
    uint32 TE214 : 1; /* TE214            */
    uint32 TE215 : 1; /* TE215            */
    uint32 TE216 : 1; /* TE216            */
    uint32 TE217 : 1; /* TE217            */
    uint32 TE218 : 1; /* TE218            */
    uint32 TE219 : 1; /* TE219            */
    uint32 TE220 : 1; /* TE220            */
    uint32 TE221 : 1; /* TE221            */
    uint32 TE222 : 1; /* TE222            */
    uint32 TE223 : 1; /* TE223            */
    uint32 TE224 : 1; /* TE224            */
    uint32 TE225 : 1; /* TE225            */
    uint32 TE226 : 1; /* TE226            */
    uint32 TE227 : 1; /* TE227            */
    uint32 TE228 : 1; /* TE228            */
    uint32 TE229 : 1; /* TE229            */
    uint32 TE230 : 1; /* TE230            */
    uint32 TE231 : 1; /* TE231            */
} __type361;
typedef struct
{                      /* Bit Access       */
    uint32 TE300 : 1;  /* TE300            */
    uint32 TE301 : 1;  /* TE301            */
    uint32 TE302 : 1;  /* TE302            */
    uint32 TE303 : 1;  /* TE303            */
    uint32 TE304 : 1;  /* TE304            */
    uint32 TE305 : 1;  /* TE305            */
    uint32 TE306 : 1;  /* TE306            */
    uint32 TE307 : 1;  /* TE307            */
    uint32 TE308 : 1;  /* TE308            */
    uint32 TE309 : 1;  /* TE309            */
    uint32 TE310 : 1;  /* TE310            */
    uint32 TE311 : 1;  /* TE311            */
    uint32 TE312 : 1;  /* TE312            */
    uint32 TE313 : 1;  /* TE313            */
    uint32 TE314 : 1;  /* TE314            */
    uint32 TE315 : 1;  /* TE315            */
    uint32       : 16; /* Reserved Bits    */
} __type362;
typedef struct
{                          /* Bit Access       */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PRMR01SSW : 1;  /* PRMR01SSW        */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PRMR02SSW : 1;  /* PRMR02SSW        */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PRMR03SSW : 1;  /* PRMR03SSW        */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PRMR04SSW : 1;  /* PRMR04SSW        */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PRMR05SSW : 1;  /* PRMR05SSW        */
    uint32           : 1;  /* Reserved Bits    */
    uint32 PRMR06SSW : 1;  /* PRMR06SSW        */
    uint32           : 20; /* Reserved Bits    */
} __type363;
typedef struct
{                          /* Bit Access       */
    uint32 PRMR0ISMS : 1;  /* PRMR0ISMS        */
    uint32 PRMR0ISMA : 1;  /* PRMR0ISMA        */
    uint32 PRMR0ISSA : 1;  /* PRMR0ISSA        */
    uint32           : 29; /* Reserved Bits    */
} __type364;
typedef struct
{                       /* Bit Access       */
    uint32 IDDATA : 1;  /* IDDATA           */
    uint32 IDEN   : 1;  /* IDEN             */
    uint32        : 30; /* Reserved Bits    */
} __type365;
typedef struct
{                      /* Bit Access       */
    uint32 TSNEN : 1;  /* TSNEN            */
    uint32       : 31; /* Reserved Bits    */
} __type366;
typedef struct
{                             /* Bit Access       */
    const uint32 TSNRDY : 1;  /* TSNRDY           */
    uint32              : 31; /* Reserved Bits    */
} __type367;
typedef struct
{                          /* Bit Access       */
    uint32 INTP0ESEL : 2;  /* INTP0ESEL[1:0]   */
    uint32 INTP1ESEL : 2;  /* INTP1ESEL[3:2]   */
    uint32 INTP2ESEL : 2;  /* INTP2ESEL[5:4]   */
    uint32           : 26; /* Reserved Bits    */
} __type368;
typedef struct
{                       /* Bit Access       */
    uint32 SLPWGA : 24; /* SLPWGA[23:0]     */
    uint32        : 8;  /* Reserved Bits    */
} __type369;
typedef struct
{                             /* Bit Access       */
    const uint32 SSF000 : 1;  /* SSF000           */
    const uint32 SSF001 : 1;  /* SSF001           */
    const uint32 SSF002 : 1;  /* SSF002           */
    const uint32 SSF003 : 1;  /* SSF003           */
    const uint32 SSF004 : 1;  /* SSF004           */
    const uint32 SSF005 : 1;  /* SSF005           */
    const uint32 SSF006 : 1;  /* SSF006           */
    const uint32 SSF007 : 1;  /* SSF007           */
    const uint32 SSF008 : 1;  /* SSF008           */
    uint32              : 23; /* Reserved Bits    */
} __type370;
typedef struct
{                             /* Bit Access       */
    uint32              : 16; /* Reserved Bits    */
    const uint32 SSF116 : 1;  /* SSF116           */
    uint32              : 15; /* Reserved Bits    */
} __type371;
typedef struct
{                      /* Bit Access       */
    uint32 CL000 : 1;  /* CL000            */
    uint32 CL001 : 1;  /* CL001            */
    uint32 CL002 : 1;  /* CL002            */
    uint32 CL003 : 1;  /* CL003            */
    uint32 CL004 : 1;  /* CL004            */
    uint32 CL005 : 1;  /* CL005            */
    uint32 CL006 : 1;  /* CL006            */
    uint32 CL007 : 1;  /* CL007            */
    uint32 CL008 : 1;  /* CL008            */
    uint32       : 23; /* Reserved Bits    */
} __type372;
typedef struct
{                      /* Bit Access       */
    uint32       : 16; /* Reserved Bits    */
    uint32 CL116 : 1;  /* CL116            */
    uint32       : 15; /* Reserved Bits    */
} __type373;
typedef struct
{                    /* Bit Access       */
    uint8 PRS   : 3; /* PRS[2:0]         */
    uint8       : 2; /* Reserved Bits    */
    uint8 NFSTS : 2; /* NFSTS[6:5]       */
    uint8       : 1; /* Reserved Bits    */
} __type374;
typedef struct
{                      /* Bit Access       */
    uint16 NFEN0  : 1; /* NFEN0            */
    uint16 NFEN1  : 1; /* NFEN1            */
    uint16 NFEN2  : 1; /* NFEN2            */
    uint16 NFEN3  : 1; /* NFEN3            */
    uint16 NFEN4  : 1; /* NFEN4            */
    uint16 NFEN5  : 1; /* NFEN5            */
    uint16 NFEN6  : 1; /* NFEN6            */
    uint16 NFEN7  : 1; /* NFEN7            */
    uint16 NFEN8  : 1; /* NFEN8            */
    uint16 NFEN9  : 1; /* NFEN9            */
    uint16 NFEN10 : 1; /* NFEN10           */
    uint16 NFEN11 : 1; /* NFEN11           */
    uint16 NFEN12 : 1; /* NFEN12           */
    uint16 NFEN13 : 1; /* NFEN13           */
    uint16 NFEN14 : 1; /* NFEN14           */
    uint16 NFEN15 : 1; /* NFEN15           */
} __type375;
typedef struct
{                      /* Bit Access       */
    uint16 NFEN0  : 1; /* NFEN0            */
    uint16 NFEN1  : 1; /* NFEN1            */
    uint16 NFEN2  : 1; /* NFEN2            */
    uint16 NFEN3  : 1; /* NFEN3            */
    uint16 NFEN4  : 1; /* NFEN4            */
    uint16 NFEN5  : 1; /* NFEN5            */
    uint16 NFEN6  : 1; /* NFEN6            */
    uint16 NFEN7  : 1; /* NFEN7            */
    uint16 NFEN8  : 1; /* NFEN8            */
    uint16        : 1; /* Reserved Bits    */
    uint16 NFEN10 : 1; /* NFEN10           */
    uint16 NFEN11 : 1; /* NFEN11           */
    uint16 NFEN12 : 1; /* NFEN12           */
    uint16 NFEN13 : 1; /* NFEN13           */
    uint16 NFEN14 : 1; /* NFEN14           */
    uint16 NFEN15 : 1; /* NFEN15           */
} __type376;
typedef struct
{                      /* Bit Access       */
    uint16 NFEN0  : 1; /* NFEN0            */
    uint16 NFEN1  : 1; /* NFEN1            */
    uint16 NFEN2  : 1; /* NFEN2            */
    uint16        : 1; /* Reserved Bits    */
    uint16 NFEN4  : 1; /* NFEN4            */
    uint16 NFEN5  : 1; /* NFEN5            */
    uint16 NFEN6  : 1; /* NFEN6            */
    uint16        : 1; /* Reserved Bits    */
    uint16 NFEN8  : 1; /* NFEN8            */
    uint16 NFEN9  : 1; /* NFEN9            */
    uint16 NFEN10 : 1; /* NFEN10           */
    uint16 NFEN11 : 1; /* NFEN11           */
    uint16 NFEN12 : 1; /* NFEN12           */
    uint16 NFEN13 : 1; /* NFEN13           */
    uint16 NFEN14 : 1; /* NFEN14           */
    uint16        : 1; /* Reserved Bits    */
} __type377;
typedef struct
{                      /* Bit Access       */
    uint16 NFEN0  : 1; /* NFEN0            */
    uint16 NFEN1  : 1; /* NFEN1            */
    uint16 NFEN2  : 1; /* NFEN2            */
    uint16 NFEN3  : 1; /* NFEN3            */
    uint16 NFEN4  : 1; /* NFEN4            */
    uint16 NFEN5  : 1; /* NFEN5            */
    uint16        : 2; /* Reserved Bits    */
    uint16 NFEN8  : 1; /* NFEN8            */
    uint16 NFEN9  : 1; /* NFEN9            */
    uint16 NFEN10 : 1; /* NFEN10           */
    uint16 NFEN11 : 1; /* NFEN11           */
    uint16 NFEN12 : 1; /* NFEN12           */
    uint16 NFEN13 : 1; /* NFEN13           */
    uint16 NFEN14 : 1; /* NFEN14           */
    uint16 NFEN15 : 1; /* NFEN15           */
} __type378;
typedef struct
{                     /* Bit Access       */
    uint16 NFEN0 : 1; /* NFEN0            */
    uint16 NFEN1 : 1; /* NFEN1            */
    uint16 NFEN2 : 1; /* NFEN2            */
    uint16 NFEN3 : 1; /* NFEN3            */
    uint16 NFEN4 : 1; /* NFEN4            */
    uint16 NFEN5 : 1; /* NFEN5            */
    uint16 NFEN6 : 1; /* NFEN6            */
    uint16 NFEN7 : 1; /* NFEN7            */
    uint16 NFEN8 : 1; /* NFEN8            */
    uint16       : 7; /* Reserved Bits    */
} __type379;
typedef struct
{                    /* Bit Access       */
    uint8 INTR0 : 1; /* INTR0            */
    uint8 INTF0 : 1; /* INTF0            */
    uint8 INTL0 : 1; /* INTL0            */
    uint8       : 5; /* Reserved Bits    */
} __type380;
typedef struct
{                    /* Bit Access       */
    uint8 INTR1 : 1; /* INTR1            */
    uint8 INTF1 : 1; /* INTF1            */
    uint8 INTL1 : 1; /* INTL1            */
    uint8       : 5; /* Reserved Bits    */
} __type381;
typedef struct
{                    /* Bit Access       */
    uint8 INTR2 : 1; /* INTR2            */
    uint8 INTF2 : 1; /* INTF2            */
    uint8 INTL2 : 1; /* INTL2            */
    uint8       : 5; /* Reserved Bits    */
} __type382;
typedef struct
{                    /* Bit Access       */
    uint8 INTR3 : 1; /* INTR3            */
    uint8 INTF3 : 1; /* INTF3            */
    uint8 INTL3 : 1; /* INTL3            */
    uint8       : 5; /* Reserved Bits    */
} __type383;
typedef struct
{                    /* Bit Access       */
    uint8 INTR4 : 1; /* INTR4            */
    uint8 INTF4 : 1; /* INTF4            */
    uint8 INTL4 : 1; /* INTL4            */
    uint8       : 5; /* Reserved Bits    */
} __type384;
typedef struct
{                    /* Bit Access       */
    uint8 INTR5 : 1; /* INTR5            */
    uint8 INTF5 : 1; /* INTF5            */
    uint8 INTL5 : 1; /* INTL5            */
    uint8       : 5; /* Reserved Bits    */
} __type385;
typedef struct
{                    /* Bit Access       */
    uint8 INTR6 : 1; /* INTR6            */
    uint8 INTF6 : 1; /* INTF6            */
    uint8 INTL6 : 1; /* INTL6            */
    uint8       : 5; /* Reserved Bits    */
} __type386;
typedef struct
{                    /* Bit Access       */
    uint8 INTR7 : 1; /* INTR7            */
    uint8 INTF7 : 1; /* INTF7            */
    uint8 INTL7 : 1; /* INTL7            */
    uint8       : 5; /* Reserved Bits    */
} __type387;
typedef struct
{                          /* Bit Access       */
    uint8  PROTWR     : 1; /* PROTWR           */
    uint8  PROTRD     : 1; /* PROTRD           */
    uint8  PROTWRPDEF : 1; /* PROTWRPDEF       */
    uint8  PROTRDPDEF : 1; /* PROTRDPDEF       */
    uint8  PROTDEB    : 1; /* PROTDEB          */
    uint16 PROTSPID   : 4; /* PROTSPID[8:5]    */
    uint32 VCID       : 8; /* VCID[16:9]       */
    uint16 PROTPEID   : 8; /* PROTPEID[24:17]  */
    uint8  PROTUM     : 1; /* PROTUM           */
    uint8  PROTVM     : 1; /* PROTVM           */
    uint8             : 5; /* Reserved Bits    */
} __type388;
typedef struct
{                   /* Bit Access       */
    uint8 CLRE : 1; /* CLRE             */
    uint8 CLRO : 1; /* CLRO             */
    uint8      : 6; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type389;
typedef struct
{                        /* Bit Access       */
    const uint8 ERR : 1; /* ERR              */
    const uint8 OVF : 1; /* OVF              */
    uint8           : 6; /* Reserved Bits    */
    uint8           : 8; /* Reserved Bits    */
    uint8           : 8; /* Reserved Bits    */
    uint8           : 8; /* Reserved Bits    */
} __type390;
typedef struct
{                           /* Bit Access       */
    const uint32 ADDR : 32; /* ADDR[31:0]       */
} __type391;
typedef struct
{                          /* Bit Access       */
    const uint8 WRITE : 1; /* WRITE            */
    const uint8 STRB  : 4; /* STRB[4:1]        */
    uint8             : 1; /* Reserved Bits    */
    const uint8 UM    : 1; /* UM               */
    const uint8 VM    : 1; /* VM               */
    const uint8 SPID  : 2; /* SPID[9:8]        */
    const uint8 VCID  : 3; /* VCID[12:10]      */
    const uint8 PEID  : 3; /* PEID[15:13]      */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type392;
typedef struct
{                          /* Bit Access       */
    uint8  PROTWR     : 1; /* PROTWR           */
    uint8  PROTRD     : 1; /* PROTRD           */
    uint8  PROTWRPDEF : 1; /* PROTWRPDEF       */
    uint8  PROTRDPDEF : 1; /* PROTRDPDEF       */
    uint8  PROTDEB    : 1; /* PROTDEB          */
    uint16 PROTSPID   : 4; /* PROTSPID[8:5]    */
    uint32 VCID       : 8; /* VCID[16:9]       */
    uint16 PROTPEID   : 8; /* PROTPEID[24:17]  */
    uint8  PROTUM     : 1; /* PROTUM           */
    uint8  PROTVM     : 1; /* PROTVM           */
    uint8             : 4; /* Reserved Bits    */
    uint8 PROTLOCK    : 1; /* PROTLOCK         */
} __type393;
typedef struct
{                           /* Bit Access       */
    const uint32 ADDR : 32; /* ADDR[31:0]       */
} __type394;
typedef struct
{                          /* Bit Access       */
    const uint8 WRITE : 1; /* WRITE            */
    const uint8 STRB  : 4; /* STRB[4:1]        */
    uint8             : 1; /* Reserved Bits    */
    const uint8 UM    : 1; /* UM               */
    const uint8 VM    : 1; /* VM               */
    uint8             : 2; /* Reserved Bits    */
    const uint8 VCID  : 3; /* VCID[12:10]      */
    const uint8 PEID  : 3; /* PEID[15:13]      */
    const uint8 SPID  : 5; /* SPID[20:16]      */
    uint8             : 3; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type395;
typedef struct
{                     /* Bit Access       */
    uint8        : 6; /* Reserved Bits    */
    uint8 SVSTOP : 1; /* SVSTOP           */
    uint8        : 1; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type396;
typedef struct
{                      /* Bit Access       */
    uint8 FCUFSEL : 1; /* FCUFSEL          */
    uint8         : 7; /* Reserved Bits    */
} __type397;
typedef struct
{                       /* Bit Access       */
    uint8 FRDCYCLD : 4; /* FRDCYCLD[3:0]    */
    uint8          : 4; /* Reserved Bits    */
} __type398;
typedef struct
{                       /* Bit Access       */
    uint16 ECCDIS : 1;  /* ECCDIS           */
    uint16        : 13; /* Reserved Bits    */
    uint16 PROT   : 2;  /* PROT[15:14]      */
    uint16        : 16; /* Reserved Bits    */
} __type399;
typedef struct
{                    /* Bit Access       */
    uint8 SEDIE : 1; /* SEDIE            */
    uint8 DEDIE : 1; /* DEDIE            */
    uint8       : 6; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type400;
typedef struct
{                      /* Bit Access       */
    uint8 SSTCLR0 : 1; /* SSTCLR0          */
    uint8 SSTCLR1 : 1; /* SSTCLR1          */
    uint8         : 6; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
} __type401;
typedef struct
{                            /* Bit Access       */
    const uint8 ERROVF0 : 1; /* ERROVF0          */
    const uint8 ERROVF1 : 1; /* ERROVF1          */
    uint8               : 6; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
} __type402;
typedef struct
{                          /* Bit Access       */
    const uint8 SEDF0 : 1; /* SEDF0            */
    const uint8 DEDF0 : 1; /* DEDF0            */
    uint8             : 6; /* Reserved Bits    */
    const uint8 SEDF1 : 1; /* SEDF1            */
    const uint8 DEDF1 : 1; /* DEDF1            */
    uint8             : 6; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type403;
typedef struct
{                           /* Bit Access       */
    const uint16 EADR0 : 9; /* EADR0[8:0]       */
    uint8              : 7; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type404;
typedef struct
{                           /* Bit Access       */
    const uint16 EADR1 : 9; /* EADR1[8:0]       */
    uint8              : 7; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type405;
typedef struct
{                     /* Bit Access       */
    uint8 STCLR0 : 1; /* STCLR0           */
    uint8        : 7; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type406;
typedef struct
{                            /* Bit Access       */
    const uint8 ERROVF0 : 1; /* ERROVF0          */
    uint8               : 7; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
} __type407;
typedef struct
{                          /* Bit Access       */
    const uint8 SEDF0 : 1; /* SEDF0            */
    const uint8 DEDF0 : 1; /* DEDF0            */
    uint8             : 6; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type408;
typedef struct
{                          /* Bit Access       */
    const uint16 EADR : 9; /* EADR[8:0]        */
    uint8             : 7; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type409;
typedef struct
{                       /* Bit Access       */
    uint32 ECCDIS : 1;  /* ECCDIS           */
    uint32 SECDIS : 1;  /* SECDIS           */
    uint32        : 12; /* Reserved Bits    */
    uint32 PROT   : 2;  /* PROT[15:14]      */
    uint32        : 16; /* Reserved Bits    */
} __type410;
typedef struct
{                      /* Bit Access       */
    uint32 SEDIE : 1;  /* SEDIE            */
    uint32 DEDIE : 1;  /* DEDIE            */
    uint32       : 30; /* Reserved Bits    */
} __type411;
typedef struct
{                       /* Bit Access       */
    uint32 STCLR0 : 1;  /* STCLR0           */
    uint32        : 31; /* Reserved Bits    */
} __type412;
typedef struct
{                              /* Bit Access       */
    const uint32 ERROVF0 : 1;  /* ERROVF0          */
    uint32               : 31; /* Reserved Bits    */
} __type413;
typedef struct
{                            /* Bit Access       */
    const uint32 SEDF0 : 1;  /* SEDF0            */
    const uint32 DEDF0 : 1;  /* DEDF0            */
    uint32             : 30; /* Reserved Bits    */
} __type414;
typedef struct
{                           /* Bit Access       */
    uint32            : 4;  /* Reserved Bits    */
    const uint32 EADR : 21; /* EADR[24:4]       */
    uint32            : 7;  /* Reserved Bits    */
} __type415;
typedef struct
{                       /* Bit Access       */
    uint32 ECCTST : 1;  /* ECCTST           */
    uint32        : 13; /* Reserved Bits    */
    uint32 PROT   : 2;  /* PROT[15:14]      */
    uint32        : 16; /* Reserved Bits    */
} __type416;
typedef struct
{                           /* Bit Access       */
    const uint32 SEDF : 1;  /* SEDF             */
    const uint32 DEDF : 1;  /* DEDF             */
    uint32            : 30; /* Reserved Bits    */
} __type417;
typedef struct
{                       /* Bit Access       */
    uint32 ERRCLR : 1;  /* ERRCLR           */
    uint32        : 31; /* Reserved Bits    */
} __type418;
typedef struct
{                       /* Bit Access       */
    uint16 DATSEL : 1;  /* DATSEL           */
    uint16 ECCTST : 1;  /* ECCTST           */
    uint16        : 12; /* Reserved Bits    */
    uint16 PROT   : 2;  /* PROT[15:14]      */
    uint16        : 16; /* Reserved Bits    */
} __type419;
typedef struct
{                              /* Bit Access       */
    const uint32 LRDATBF0 : 9; /* LRDATBF0[8:0]    */
    uint32                : 7; /* Reserved Bits    */
    const uint32 LRDATBF1 : 9; /* LRDATBF1[24:16]  */
    uint32                : 7; /* Reserved Bits    */
} __type420;
typedef struct
{                              /* Bit Access       */
    const uint32 LRDATBF2 : 9; /* LRDATBF2[8:0]    */
    uint32                : 7; /* Reserved Bits    */
    const uint32 LRDATBF3 : 9; /* LRDATBF3[24:16]  */
    uint32                : 7; /* Reserved Bits    */
} __type421;
typedef struct
{                       /* Bit Access       */
    uint16 ECCDIS : 1;  /* ECCDIS           */
    uint16 SECDIS : 1;  /* SECDIS           */
    uint16        : 12; /* Reserved Bits    */
    uint16 PROT   : 2;  /* PROT[15:14]      */
    uint16        : 16; /* Reserved Bits    */
} __type422;
typedef struct
{                     /* Bit Access       */
    uint8 STCLR0 : 1; /* STCLR0           */
    uint8 STCLR1 : 1; /* STCLR1           */
    uint8 STCLR2 : 1; /* STCLR2           */
    uint8 STCLR3 : 1; /* STCLR3           */
    uint8        : 4; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type423;
typedef struct
{                            /* Bit Access       */
    const uint8 ERROVF0 : 1; /* ERROVF0          */
    const uint8 ERROVF1 : 1; /* ERROVF1          */
    const uint8 ERROVF2 : 1; /* ERROVF2          */
    const uint8 ERROVF3 : 1; /* ERROVF3          */
    uint8               : 4; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
} __type424;
typedef struct
{                          /* Bit Access       */
    const uint8 SEDF0 : 1; /* SEDF0            */
    const uint8 DEDF0 : 1; /* DEDF0            */
    uint8             : 6; /* Reserved Bits    */
    const uint8 SEDF1 : 1; /* SEDF1            */
    const uint8 DEDF1 : 1; /* DEDF1            */
    uint8             : 6; /* Reserved Bits    */
    const uint8 SEDF2 : 1; /* SEDF2            */
    const uint8 DEDF2 : 1; /* DEDF2            */
    uint8             : 6; /* Reserved Bits    */
    const uint8 SEDF3 : 1; /* SEDF3            */
    const uint8 DEDF3 : 1; /* DEDF3            */
    uint8             : 6; /* Reserved Bits    */
} __type425;
typedef struct
{                           /* Bit Access       */
    const uint16 EADR : 15; /* EADR[14:0]       */
    uint8             : 1;  /* Reserved Bits    */
    uint8             : 8;  /* Reserved Bits    */
    uint8             : 8;  /* Reserved Bits    */
} __type426;
typedef struct
{                             /* Bit Access       */
    const uint16 ECEMF   : 1; /* ECEMF            */
    const uint16 ECER1F  : 1; /* ECER1F           */
    const uint16 ECER2F  : 1; /* ECER2F           */
    uint16       EC1EDIC : 1; /* EC1EDIC          */
    uint16       EC2EDIC : 1; /* EC2EDIC          */
    uint16       EC1ECP  : 1; /* EC1ECP           */
    uint16       ECERVF  : 1; /* ECERVF           */
    uint16       ECTHM   : 1; /* ECTHM            */
    uint16               : 1; /* Reserved Bits    */
    uint16 ECER1C        : 1; /* ECER1C           */
    uint16 ECER2C        : 1; /* ECER2C           */
    uint16               : 3; /* Reserved Bits    */
    uint16 EMCA0         : 1; /* EMCA0            */
    uint16 EMCA1         : 1; /* EMCA1            */
} __type427;
typedef struct
{                      /* Bit Access       */
    uint16 ECREIS : 1; /* ECREIS           */
    uint16 ECDCS  : 1; /* ECDCS            */
    uint16 ECENS  : 1; /* ECENS            */
    uint16 ECREOS : 1; /* ECREOS           */
    uint16 ECTRRS : 1; /* ECTRRS           */
    uint16        : 2; /* Reserved Bits    */
    uint16 ECTMCE : 1; /* ECTMCE           */
    uint16        : 6; /* Reserved Bits    */
    uint16 ETMA0  : 1; /* ETMA0            */
    uint16 ETMA1  : 1; /* ETMA1            */
} __type428;
typedef struct
{                         /* Bit Access       */
    uint8 ERDB       : 7; /* ERDB[6:0]        */
    uint8            : 1; /* Reserved Bits    */
    const uint8 ECRD : 7; /* ECRD[14:8]       */
    uint8            : 1; /* Reserved Bits    */
    const uint8 HORD : 7; /* HORD[22:16]      */
    uint8            : 1; /* Reserved Bits    */
    const uint8 SYND : 7; /* SYND[30:24]      */
    uint8            : 1; /* Reserved Bits    */
} __type429;
typedef struct
{                      /* Bit Access       */
    uint32 ECEDB : 32; /* ECEDB[31:0]      */
} __type430;
typedef struct
{                            /* Bit Access       */
    const uint32 ECEAD : 32; /* ECEAD[31:0]      */
} __type431;
typedef struct
{                             /* Bit Access       */
    const uint32 ECEMF   : 1; /* ECEMF            */
    const uint32 ECER1F  : 1; /* ECER1F           */
    const uint32 ECER2F  : 1; /* ECER2F           */
    uint32       EC1EDIC : 1; /* EC1EDIC          */
    uint32       EC2EDIC : 1; /* EC2EDIC          */
    uint32       EC1ECP  : 1; /* EC1ECP           */
    uint32       ECERVF  : 1; /* ECERVF           */
    uint32       ECTHM   : 1; /* ECTHM            */
    uint32               : 1; /* Reserved Bits    */
    uint32       ECER1C  : 1; /* ECER1C           */
    uint32       ECER2C  : 1; /* ECER2C           */
    const uint32 ECOVFF  : 1; /* ECOVFF           */
    uint32               : 2; /* Reserved Bits    */
    uint32       EMCA0   : 1; /* EMCA0            */
    uint32       EMCA1   : 1; /* EMCA1            */
    const uint32 ECSEDF0 : 1; /* ECSEDF0          */
    const uint32 ECDEDF0 : 1; /* ECDEDF0          */
    const uint32 ECSEDF1 : 1; /* ECSEDF1          */
    const uint32 ECDEDF1 : 1; /* ECDEDF1          */
    const uint32 ECSEDF2 : 1; /* ECSEDF2          */
    const uint32 ECDEDF2 : 1; /* ECDEDF2          */
    const uint32 ECSEDF3 : 1; /* ECSEDF3          */
    const uint32 ECDEDF3 : 1; /* ECDEDF3          */
    const uint32 ECSEDF4 : 1; /* ECSEDF4          */
    const uint32 ECDEDF4 : 1; /* ECDEDF4          */
    const uint32 ECSEDF5 : 1; /* ECSEDF5          */
    const uint32 ECDEDF5 : 1; /* ECDEDF5          */
    const uint32 ECSEDF6 : 1; /* ECSEDF6          */
    const uint32 ECDEDF6 : 1; /* ECDEDF6          */
    const uint32 ECSEDF7 : 1; /* ECSEDF7          */
    const uint32 ECDEDF7 : 1; /* ECDEDF7          */
} __type432;
typedef struct
{                      /* Bit Access       */
    uint16 ECREIS : 1; /* ECREIS           */
    uint16 ECDCS  : 1; /* ECDCS            */
    uint16 ECENS  : 1; /* ECENS            */
    uint16 ECREOS : 1; /* ECREOS           */
    uint16 ECTRRS : 1; /* ECTRRS           */
    uint16        : 2; /* Reserved Bits    */
    uint16 ECTMCE : 1; /* ECTMCE           */
    uint16        : 6; /* Reserved Bits    */
    uint16 ETMA   : 2; /* ETMA[15:14]      */
} __type433;
typedef struct
{                  /* Bit Access       */
    uint8 EST : 1; /* EST              */
    uint8     : 7; /* Reserved Bits    */
} __type434;
typedef struct
{                  /* Bit Access       */
    uint8 ECT : 1; /* ECT              */
    uint8     : 7; /* Reserved Bits    */
} __type435;
typedef struct
{                            /* Bit Access       */
    const uint32 SSE000 : 1; /* SSE000           */
    const uint32 SSE001 : 1; /* SSE001           */
    const uint32 SSE002 : 1; /* SSE002           */
    const uint32 SSE003 : 1; /* SSE003           */
    const uint32 SSE004 : 1; /* SSE004           */
    const uint32 SSE005 : 1; /* SSE005           */
    const uint32 SSE006 : 1; /* SSE006           */
    const uint32 SSE007 : 1; /* SSE007           */
    const uint32 SSE008 : 1; /* SSE008           */
    const uint32 SSE009 : 1; /* SSE009           */
    const uint32 SSE010 : 1; /* SSE010           */
    const uint32 SSE011 : 1; /* SSE011           */
    const uint32 SSE012 : 1; /* SSE012           */
    const uint32 SSE013 : 1; /* SSE013           */
    const uint32 SSE014 : 1; /* SSE014           */
    const uint32 SSE015 : 1; /* SSE015           */
    const uint32 SSE016 : 1; /* SSE016           */
    const uint32 SSE017 : 1; /* SSE017           */
    const uint32 SSE018 : 1; /* SSE018           */
    const uint32 SSE019 : 1; /* SSE019           */
    const uint32 SSE020 : 1; /* SSE020           */
    const uint32 SSE021 : 1; /* SSE021           */
    const uint32 SSE022 : 1; /* SSE022           */
    const uint32 SSE023 : 1; /* SSE023           */
    const uint32 SSE024 : 1; /* SSE024           */
    const uint32 SSE025 : 1; /* SSE025           */
    const uint32 SSE026 : 1; /* SSE026           */
    const uint32 SSE027 : 1; /* SSE027           */
    const uint32 SSE028 : 1; /* SSE028           */
    const uint32 SSE029 : 1; /* SSE029           */
    const uint32 SSE030 : 1; /* SSE030           */
    const uint32 SSE031 : 1; /* SSE031           */
} __type436;
typedef struct
{                             /* Bit Access       */
    const uint32 SSE100 : 1;  /* SSE100           */
    const uint32 SSE101 : 1;  /* SSE101           */
    const uint32 SSE102 : 1;  /* SSE102           */
    const uint32 SSE103 : 1;  /* SSE103           */
    const uint32 SSE104 : 1;  /* SSE104           */
    const uint32 SSE105 : 1;  /* SSE105           */
    const uint32 SSE106 : 1;  /* SSE106           */
    const uint32 SSE107 : 1;  /* SSE107           */
    const uint32 SSE108 : 1;  /* SSE108           */
    const uint32 SSE109 : 1;  /* SSE109           */
    const uint32 SSE110 : 1;  /* SSE110           */
    const uint32 SSE111 : 1;  /* SSE111           */
    const uint32 SSE112 : 1;  /* SSE112           */
    const uint32 SSE113 : 1;  /* SSE113           */
    const uint32 SSE114 : 1;  /* SSE114           */
    const uint32 SSE115 : 1;  /* SSE115           */
    uint32              : 13; /* Reserved Bits    */
    const uint32 SSE129 : 1;  /* SSE129           */
    const uint32 SSE130 : 1;  /* SSE130           */
    const uint32 SSE131 : 1;  /* SSE131           */
} __type437;
typedef struct
{                     /* Bit Access       */
    uint32 REG0 : 8;  /* REG0[7:0]        */
    uint32      : 24; /* Reserved Bits    */
} __type438;
typedef struct
{                                  /* Bit Access       */
    const uint32 WDT0OPWDOVF : 3;  /* WDT0OPWDOVF[2:0] */
    const uint32 WDT0OPWDEN  : 1;  /* WDT0OPWDEN       */
    const uint32 WDT0OPWDRUN : 1;  /* WDT0OPWDRUN      */
    const uint32 WDT0OPWDTPR : 1;  /* WDT0OPWDTPR      */
    const uint32 WDT0OPWDVAC : 1;  /* WDT0OPWDVAC      */
    uint32                   : 1;  /* Reserved Bits    */
    const uint32 WDT1OPWDOVF : 3;  /* WDT1OPWDOVF[10:8] */
    const uint32 WDT1OPWDEN  : 1;  /* WDT1OPWDEN       */
    const uint32 WDT1OPWDRUN : 1;  /* WDT1OPWDRUN      */
    const uint32 WDT1OPWDTPR : 1;  /* WDT1OPWDTPR      */
    const uint32 WDT1OPWDVAC : 1;  /* WDT1OPWDVAC      */
    uint32                   : 1;  /* Reserved Bits    */
    const uint32 OPJTAG      : 2;  /* OPJTAG[17:16]    */
    uint32                   : 14; /* Reserved Bits    */
} __type439;
typedef struct
{                               /* Bit Access       */
    uint32                : 8;  /* Reserved Bits    */
    const uint32 TSNREFDL : 12; /* TSNREFDL[19:8]   */
    const uint32 TSNREFDH : 12; /* TSNREFDH[31:20]  */
} __type440;
typedef struct
{                    /* Bit Access       */
    uint8 LWBR0 : 1; /* LWBR0            */
    uint8 LPRS  : 3; /* LPRS[3:1]        */
    uint8 NSPB  : 4; /* NSPB[7:4]        */
} __type441;
typedef struct
{                    /* Bit Access       */
    uint8 LBRP0 : 8; /* LBRP0[7:0]       */
    uint8 LBRP1 : 8; /* LBRP1[15:8]      */
} __type442;
typedef struct
{                   /* Bit Access       */
    uint8 LSTM : 1; /* LSTM             */
    uint8      : 7; /* Reserved Bits    */
} __type443;
typedef struct
{                     /* Bit Access       */
    uint8 LMD    : 2; /* LMD[1:0]         */
    uint8 LCKS   : 2; /* LCKS[3:2]        */
    uint8 LIOS   : 1; /* LIOS             */
    uint8 LRDNFS : 1; /* LRDNFS           */
    uint8        : 2; /* Reserved Bits    */
} __type444;
typedef struct
{                  /* Bit Access       */
    uint8 BLT : 4; /* BLT[3:0]         */
    uint8 BDT : 2; /* BDT[5:4]         */
    uint8     : 2; /* Reserved Bits    */
} __type445;
typedef struct
{                   /* Bit Access       */
    uint8 IBHS : 3; /* IBHS[2:0]        */
    uint8      : 1; /* Reserved Bits    */
    uint8 IBS  : 2; /* IBS[5:4]         */
    uint8      : 2; /* Reserved Bits    */
} __type446;
typedef struct
{                   /* Bit Access       */
    uint8      : 4; /* Reserved Bits    */
    uint8 WUTL : 4; /* WUTL[7:4]        */
} __type447;
typedef struct
{                    /* Bit Access       */
    uint8 FTCIE : 1; /* FTCIE            */
    uint8 FRCIE : 1; /* FRCIE            */
    uint8 ERRIE : 1; /* ERRIE            */
    uint8 SHIE  : 1; /* SHIE             */
    uint8       : 4; /* Reserved Bits    */
} __type448;
typedef struct
{                    /* Bit Access       */
    uint8 BERE  : 1; /* BERE             */
    uint8 PBERE : 1; /* PBERE            */
    uint8 FTERE : 1; /* FTERE            */
    uint8 FERE  : 1; /* FERE             */
    uint8       : 3; /* Reserved Bits    */
    uint8 LTES  : 1; /* LTES             */
} __type449;
typedef struct
{                  /* Bit Access       */
    uint8 OM0 : 1; /* OM0              */
    uint8 OM1 : 1; /* OM1              */
    uint8     : 6; /* Reserved Bits    */
} __type450;
typedef struct
{                  /* Bit Access       */
    uint8 FTS : 1; /* FTS              */
    uint8 RTS : 1; /* RTS              */
    uint8     : 6; /* Reserved Bits    */
} __type451;
typedef struct
{                         /* Bit Access       */
    const uint8 OMM0 : 1; /* OMM0             */
    const uint8 OMM1 : 1; /* OMM1             */
    uint8            : 6; /* Reserved Bits    */
} __type452;
typedef struct
{                        /* Bit Access       */
    uint8 FTC       : 1; /* FTC              */
    uint8 FRC       : 1; /* FRC              */
    uint8           : 1; /* Reserved Bits    */
    const uint8 ERR : 1; /* ERR              */
    uint8           : 2; /* Reserved Bits    */
    uint8 D1RC      : 1; /* D1RC             */
    uint8 HTRC      : 1; /* HTRC             */
} __type453;
typedef struct
{                   /* Bit Access       */
    uint8 BER  : 1; /* BER              */
    uint8 PBER : 1; /* PBER             */
    uint8 FTER : 1; /* FTER             */
    uint8 FER  : 1; /* FER              */
    uint8      : 1; /* Reserved Bits    */
    uint8 CSER : 1; /* CSER             */
    uint8      : 1; /* Reserved Bits    */
    uint8 RPER : 1; /* RPER             */
} __type454;
typedef struct
{                   /* Bit Access       */
    uint8 RFDL : 4; /* RFDL[3:0]        */
    uint8 RFT  : 1; /* RFT              */
    uint8 CSM  : 1; /* CSM              */
    uint8 FSM  : 1; /* FSM              */
    uint8 LSS  : 1; /* LSS              */
} __type455;
typedef struct
{                   /* Bit Access       */
    uint8 ID   : 6; /* ID[5:0]          */
    uint8 IDP0 : 1; /* IDP0             */
    uint8 IDP1 : 1; /* IDP1             */
} __type456;
typedef struct
{                   /* Bit Access       */
    uint8 CKSM : 8; /* CKSM[7:0]        */
} __type457;
typedef struct
{                  /* Bit Access       */
    uint8 UDB : 8; /* UDB[7:0]         */
} __type458;
typedef struct
{                  /* Bit Access       */
    uint8 LDB : 8; /* LDB[7:0]         */
} __type459;
typedef struct
{                   /* Bit Access       */
    uint8 UTOE : 1; /* UTOE             */
    uint8 UROE : 1; /* UROE             */
    uint8      : 6; /* Reserved Bits    */
} __type460;
typedef struct
{                     /* Bit Access       */
    uint8 UEBE   : 1; /* UEBE             */
    uint8 UEBDL  : 1; /* UEBDL            */
    uint8 UEBDCE : 1; /* UEBDCE           */
    uint8 UTIGTS : 1; /* UTIGTS           */
    uint8 UECD   : 1; /* UECD             */
    uint8        : 3; /* Reserved Bits    */
} __type461;
typedef struct
{                   /* Bit Access       */
    uint16 UTD : 9; /* UTD[8:0]         */
    uint8      : 7; /* Reserved Bits    */
} __type462;
typedef struct
{                         /* Bit Access       */
    const uint16 URD : 9; /* URD[8:0]         */
    uint8            : 7; /* Reserved Bits    */
} __type463;
typedef struct
{                    /* Bit Access       */
    uint16 UWTD : 9; /* UWTD[8:0]        */
    uint8       : 7; /* Reserved Bits    */
} __type464;
typedef struct
{                     /* Bit Access       */
    uint16 BRP  : 10; /* BRP[9:0]         */
    uint8       : 6;  /* Reserved Bits    */
    uint8 TSEG1 : 4;  /* TSEG1[19:16]     */
    uint8 TSEG2 : 3;  /* TSEG2[22:20]     */
    uint8       : 1;  /* Reserved Bits    */
    uint8 SJW   : 2;  /* SJW[25:24]       */
    uint8       : 6;  /* Reserved Bits    */
} __type465;
typedef struct
{                    /* Bit Access       */
    uint8 CHMDC : 2; /* CHMDC[1:0]       */
    uint8 CSLPR : 1; /* CSLPR            */
    uint8 RTBO  : 1; /* RTBO             */
    uint8       : 4; /* Reserved Bits    */
    uint8 BEIE  : 1; /* BEIE             */
    uint8 EWIE  : 1; /* EWIE             */
    uint8 EPIE  : 1; /* EPIE             */
    uint8 BOEIE : 1; /* BOEIE            */
    uint8 BORIE : 1; /* BORIE            */
    uint8 OLIE  : 1; /* OLIE             */
    uint8 BLIE  : 1; /* BLIE             */
    uint8 ALIE  : 1; /* ALIE             */
    uint8 TAIE  : 1; /* TAIE             */
    uint8       : 4; /* Reserved Bits    */
    uint8 BOM   : 2; /* BOM[22:21]       */
    uint8 ERRD  : 1; /* ERRD             */
    uint8 CTME  : 1; /* CTME             */
    uint8 CTMS  : 2; /* CTMS[26:25]      */
    uint8       : 5; /* Reserved Bits    */
} __type466;
typedef struct
{                            /* Bit Access       */
    const uint8 CRSTSTS : 1; /* CRSTSTS          */
    const uint8 CHLTSTS : 1; /* CHLTSTS          */
    const uint8 CSLPSTS : 1; /* CSLPSTS          */
    const uint8 EPSTS   : 1; /* EPSTS            */
    const uint8 BOSTS   : 1; /* BOSTS            */
    const uint8 TRMSTS  : 1; /* TRMSTS           */
    const uint8 RECSTS  : 1; /* RECSTS           */
    const uint8 COMSTS  : 1; /* COMSTS           */
    uint8               : 8; /* Reserved Bits    */
    const uint8 REC     : 8; /* REC[23:16]       */
    const uint8 TEC     : 8; /* TEC[31:24]       */
} __type467;
typedef struct
{                             /* Bit Access       */
    uint8 BEF           : 1;  /* BEF              */
    uint8 EWF           : 1;  /* EWF              */
    uint8 EPF           : 1;  /* EPF              */
    uint8 BOEF          : 1;  /* BOEF             */
    uint8 BORF          : 1;  /* BORF             */
    uint8 OVLF          : 1;  /* OVLF             */
    uint8 BLF           : 1;  /* BLF              */
    uint8 ALF           : 1;  /* ALF              */
    uint8 SERR          : 1;  /* SERR             */
    uint8 FERR          : 1;  /* FERR             */
    uint8 AERR          : 1;  /* AERR             */
    uint8 CERR          : 1;  /* CERR             */
    uint8 B1ERR         : 1;  /* B1ERR            */
    uint8 B0ERR         : 1;  /* B0ERR            */
    uint8 ADERR         : 1;  /* ADERR            */
    uint8               : 1;  /* Reserved Bits    */
    const uint16 CRCREG : 15; /* CRCREG[30:16]    */
    uint8               : 1;  /* Reserved Bits    */
} __type468;
typedef struct
{                       /* Bit Access       */
    uint8 TPRI    : 1;  /* TPRI             */
    uint8 DCE     : 1;  /* DCE              */
    uint8 DRE     : 1;  /* DRE              */
    uint8 MME     : 1;  /* MME              */
    uint8 DCS     : 1;  /* DCS              */
    uint8         : 3;  /* Reserved Bits    */
    uint8  TSP    : 4;  /* TSP[11:8]        */
    uint8  TSSS   : 1;  /* TSSS             */
    uint8  TSBTCS : 3;  /* TSBTCS[15:13]    */
    uint16 ITRCP  : 16; /* ITRCP[31:16]     */
} __type469;
typedef struct
{                     /* Bit Access       */
    uint8 GMDC   : 2; /* GMDC[1:0]        */
    uint8 GSLPR  : 1; /* GSLPR            */
    uint8        : 5; /* Reserved Bits    */
    uint8 DEIE   : 1; /* DEIE             */
    uint8 MEIE   : 1; /* MEIE             */
    uint8 THLEIE : 1; /* THLEIE           */
    uint8        : 5; /* Reserved Bits    */
    uint8 TSRST  : 1; /* TSRST            */
    uint8        : 7; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type470;
typedef struct
{                             /* Bit Access       */
    const uint8 GRSTSTS  : 1; /* GRSTSTS          */
    const uint8 GHLTSTS  : 1; /* GHLTSTS          */
    const uint8 GSLPSTS  : 1; /* GSLPSTS          */
    const uint8 GRAMINIT : 1; /* GRAMINIT         */
    uint8                : 4; /* Reserved Bits    */
    uint8                : 8; /* Reserved Bits    */
    uint8                : 8; /* Reserved Bits    */
    uint8                : 8; /* Reserved Bits    */
} __type471;
typedef struct
{                          /* Bit Access       */
    uint8       DEF   : 1; /* DEF              */
    const uint8 MES   : 1; /* MES              */
    const uint8 THLES : 1; /* THLES            */
    uint8             : 5; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type472;
typedef struct
{                         /* Bit Access       */
    const uint16 TS : 16; /* TS[15:0]         */
    uint16          : 16; /* Reserved Bits    */
} __type473;
typedef struct
{                     /* Bit Access       */
    uint8 AFLPN  : 5; /* AFLPN[4:0]       */
    uint8        : 3; /* Reserved Bits    */
    uint8 AFLDAE : 1; /* AFLDAE           */
    uint8        : 7; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type474;
typedef struct
{                   /* Bit Access       */
    uint8      : 8; /* Reserved Bits    */
    uint8 RNC2 : 8; /* RNC2[15:8]       */
    uint8 RNC1 : 8; /* RNC1[23:16]      */
    uint8 RNC0 : 8; /* RNC0[31:24]      */
} __type475;
typedef struct
{                    /* Bit Access       */
    uint8 NRXMB : 8; /* NRXMB[7:0]       */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type476;
typedef struct
{                     /* Bit Access       */
    uint8 RMNS0  : 1; /* RMNS0            */
    uint8 RMNS1  : 1; /* RMNS1            */
    uint8 RMNS2  : 1; /* RMNS2            */
    uint8 RMNS3  : 1; /* RMNS3            */
    uint8 RMNS4  : 1; /* RMNS4            */
    uint8 RMNS5  : 1; /* RMNS5            */
    uint8 RMNS6  : 1; /* RMNS6            */
    uint8 RMNS7  : 1; /* RMNS7            */
    uint8 RMNS8  : 1; /* RMNS8            */
    uint8 RMNS9  : 1; /* RMNS9            */
    uint8 RMNS10 : 1; /* RMNS10           */
    uint8 RMNS11 : 1; /* RMNS11           */
    uint8 RMNS12 : 1; /* RMNS12           */
    uint8 RMNS13 : 1; /* RMNS13           */
    uint8 RMNS14 : 1; /* RMNS14           */
    uint8 RMNS15 : 1; /* RMNS15           */
    uint8 RMNS16 : 1; /* RMNS16           */
    uint8 RMNS17 : 1; /* RMNS17           */
    uint8 RMNS18 : 1; /* RMNS18           */
    uint8 RMNS19 : 1; /* RMNS19           */
    uint8 RMNS20 : 1; /* RMNS20           */
    uint8 RMNS21 : 1; /* RMNS21           */
    uint8 RMNS22 : 1; /* RMNS22           */
    uint8 RMNS23 : 1; /* RMNS23           */
    uint8 RMNS24 : 1; /* RMNS24           */
    uint8 RMNS25 : 1; /* RMNS25           */
    uint8 RMNS26 : 1; /* RMNS26           */
    uint8 RMNS27 : 1; /* RMNS27           */
    uint8 RMNS28 : 1; /* RMNS28           */
    uint8 RMNS29 : 1; /* RMNS29           */
    uint8 RMNS30 : 1; /* RMNS30           */
    uint8 RMNS31 : 1; /* RMNS31           */
} __type477;
typedef struct
{                     /* Bit Access       */
    uint8 RMNS32 : 1; /* RMNS32           */
    uint8 RMNS33 : 1; /* RMNS33           */
    uint8 RMNS34 : 1; /* RMNS34           */
    uint8 RMNS35 : 1; /* RMNS35           */
    uint8 RMNS36 : 1; /* RMNS36           */
    uint8 RMNS37 : 1; /* RMNS37           */
    uint8 RMNS38 : 1; /* RMNS38           */
    uint8 RMNS39 : 1; /* RMNS39           */
    uint8 RMNS40 : 1; /* RMNS40           */
    uint8 RMNS41 : 1; /* RMNS41           */
    uint8 RMNS42 : 1; /* RMNS42           */
    uint8 RMNS43 : 1; /* RMNS43           */
    uint8 RMNS44 : 1; /* RMNS44           */
    uint8 RMNS45 : 1; /* RMNS45           */
    uint8 RMNS46 : 1; /* RMNS46           */
    uint8 RMNS47 : 1; /* RMNS47           */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type478;
typedef struct
{                     /* Bit Access       */
    uint8 RFE    : 1; /* RFE              */
    uint8 RFIE   : 1; /* RFIE             */
    uint8        : 6; /* Reserved Bits    */
    uint8 RFDC   : 3; /* RFDC[10:8]       */
    uint8        : 1; /* Reserved Bits    */
    uint8 RFIM   : 1; /* RFIM             */
    uint8 RFIGCV : 3; /* RFIGCV[15:13]    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type479;
typedef struct
{                          /* Bit Access       */
    const uint8 RFEMP : 1; /* RFEMP            */
    const uint8 RFFLL : 1; /* RFFLL            */
    uint8       RFMLT : 1; /* RFMLT            */
    uint8       RFIF  : 1; /* RFIF             */
    uint8             : 4; /* Reserved Bits    */
    const uint8 RFMC  : 8; /* RFMC[15:8]       */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type480;
typedef struct
{                   /* Bit Access       */
    uint8 RFPC : 8; /* RFPC[7:0]        */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type481;
typedef struct
{                     /* Bit Access       */
    uint8 CFE    : 1; /* CFE              */
    uint8 CFRXIE : 1; /* CFRXIE           */
    uint8 CFTXIE : 1; /* CFTXIE           */
    uint8        : 5; /* Reserved Bits    */
    uint8 CFDC   : 3; /* CFDC[10:8]       */
    uint8        : 1; /* Reserved Bits    */
    uint8 CFIM   : 1; /* CFIM             */
    uint8 CFIGCV : 3; /* CFIGCV[15:13]    */
    uint8 CFM    : 2; /* CFM[17:16]       */
    uint8 CFITSS : 1; /* CFITSS           */
    uint8 CFITR  : 1; /* CFITR            */
    uint8 CFTML  : 4; /* CFTML[23:20]     */
    uint8 CFITT  : 8; /* CFITT[31:24]     */
} __type482;
typedef struct
{                           /* Bit Access       */
    const uint8 CFEMP  : 1; /* CFEMP            */
    const uint8 CFFLL  : 1; /* CFFLL            */
    uint8       CFMLT  : 1; /* CFMLT            */
    uint8       CFRXIF : 1; /* CFRXIF           */
    uint8       CFTXIF : 1; /* CFTXIF           */
    uint8              : 3; /* Reserved Bits    */
    const uint8 CFMC   : 8; /* CFMC[15:8]       */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type483;
typedef struct
{                   /* Bit Access       */
    uint8 CFPC : 8; /* CFPC[7:0]        */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type484;
typedef struct
{                           /* Bit Access       */
    const uint8 RF0EMP : 1; /* RF0EMP           */
    const uint8 RF1EMP : 1; /* RF1EMP           */
    const uint8 RF2EMP : 1; /* RF2EMP           */
    const uint8 RF3EMP : 1; /* RF3EMP           */
    const uint8 RF4EMP : 1; /* RF4EMP           */
    const uint8 RF5EMP : 1; /* RF5EMP           */
    const uint8 RF6EMP : 1; /* RF6EMP           */
    const uint8 RF7EMP : 1; /* RF7EMP           */
    const uint8 CF0EMP : 1; /* CF0EMP           */
    const uint8 CF1EMP : 1; /* CF1EMP           */
    const uint8 CF2EMP : 1; /* CF2EMP           */
    const uint8 CF3EMP : 1; /* CF3EMP           */
    const uint8 CF4EMP : 1; /* CF4EMP           */
    const uint8 CF5EMP : 1; /* CF5EMP           */
    const uint8 CF6EMP : 1; /* CF6EMP           */
    const uint8 CF7EMP : 1; /* CF7EMP           */
    const uint8 CF8EMP : 1; /* CF8EMP           */
    uint8              : 7; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type485;
typedef struct
{                           /* Bit Access       */
    const uint8 RF0FLL : 1; /* RF0FLL           */
    const uint8 RF1FLL : 1; /* RF1FLL           */
    const uint8 RF2FLL : 1; /* RF2FLL           */
    const uint8 RF3FLL : 1; /* RF3FLL           */
    const uint8 RF4FLL : 1; /* RF4FLL           */
    const uint8 RF5FLL : 1; /* RF5FLL           */
    const uint8 RF6FLL : 1; /* RF6FLL           */
    const uint8 RF7FLL : 1; /* RF7FLL           */
    const uint8 CF0FLL : 1; /* CF0FLL           */
    const uint8 CF1FLL : 1; /* CF1FLL           */
    const uint8 CF2FLL : 1; /* CF2FLL           */
    const uint8 CF3FLL : 1; /* CF3FLL           */
    const uint8 CF4FLL : 1; /* CF4FLL           */
    const uint8 CF5FLL : 1; /* CF5FLL           */
    const uint8 CF6FLL : 1; /* CF6FLL           */
    const uint8 CF7FLL : 1; /* CF7FLL           */
    const uint8 CF8FLL : 1; /* CF8FLL           */
    uint8              : 7; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type486;
typedef struct
{                           /* Bit Access       */
    const uint8 RF0MLT : 1; /* RF0MLT           */
    const uint8 RF1MLT : 1; /* RF1MLT           */
    const uint8 RF2MLT : 1; /* RF2MLT           */
    const uint8 RF3MLT : 1; /* RF3MLT           */
    const uint8 RF4MLT : 1; /* RF4MLT           */
    const uint8 RF5MLT : 1; /* RF5MLT           */
    const uint8 RF6MLT : 1; /* RF6MLT           */
    const uint8 RF7MLT : 1; /* RF7MLT           */
    const uint8 CF0MLT : 1; /* CF0MLT           */
    const uint8 CF1MLT : 1; /* CF1MLT           */
    const uint8 CF2MLT : 1; /* CF2MLT           */
    const uint8 CF3MLT : 1; /* CF3MLT           */
    const uint8 CF4MLT : 1; /* CF4MLT           */
    const uint8 CF5MLT : 1; /* CF5MLT           */
    const uint8 CF6MLT : 1; /* CF6MLT           */
    const uint8 CF7MLT : 1; /* CF7MLT           */
    const uint8 CF8MLT : 1; /* CF8MLT           */
    uint8              : 7; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type487;
typedef struct
{                          /* Bit Access       */
    const uint8 RF0IF : 1; /* RF0IF            */
    const uint8 RF1IF : 1; /* RF1IF            */
    const uint8 RF2IF : 1; /* RF2IF            */
    const uint8 RF3IF : 1; /* RF3IF            */
    const uint8 RF4IF : 1; /* RF4IF            */
    const uint8 RF5IF : 1; /* RF5IF            */
    const uint8 RF6IF : 1; /* RF6IF            */
    const uint8 RF7IF : 1; /* RF7IF            */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type488;
typedef struct
{                            /* Bit Access       */
    const uint8 CF0RXIF : 1; /* CF0RXIF          */
    const uint8 CF1RXIF : 1; /* CF1RXIF          */
    const uint8 CF2RXIF : 1; /* CF2RXIF          */
    const uint8 CF3RXIF : 1; /* CF3RXIF          */
    const uint8 CF4RXIF : 1; /* CF4RXIF          */
    const uint8 CF5RXIF : 1; /* CF5RXIF          */
    const uint8 CF6RXIF : 1; /* CF6RXIF          */
    const uint8 CF7RXIF : 1; /* CF7RXIF          */
    const uint8 CF8RXIF : 1; /* CF8RXIF          */
    uint8               : 7; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
} __type489;
typedef struct
{                            /* Bit Access       */
    const uint8 CF0TXIF : 1; /* CF0TXIF          */
    const uint8 CF1TXIF : 1; /* CF1TXIF          */
    const uint8 CF2TXIF : 1; /* CF2TXIF          */
    const uint8 CF3TXIF : 1; /* CF3TXIF          */
    const uint8 CF4TXIF : 1; /* CF4TXIF          */
    const uint8 CF5TXIF : 1; /* CF5TXIF          */
    const uint8 CF6TXIF : 1; /* CF6TXIF          */
    const uint8 CF7TXIF : 1; /* CF7TXIF          */
    const uint8 CF8TXIF : 1; /* CF8TXIF          */
    uint8               : 7; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
    uint8               : 8; /* Reserved Bits    */
} __type490;
typedef struct
{                    /* Bit Access       */
    uint8 TMTR  : 1; /* TMTR             */
    uint8 TMTAR : 1; /* TMTAR            */
    uint8 TMOM  : 1; /* TMOM             */
    uint8       : 5; /* Reserved Bits    */
} __type491;
typedef struct
{                           /* Bit Access       */
    const uint8 TMTSTS : 1; /* TMTSTS           */
    uint8       TMTRF  : 2; /* TMTRF[2:1]       */
    const uint8 TMTRM  : 1; /* TMTRM            */
    const uint8 TMTARM : 1; /* TMTARM           */
    uint8              : 3; /* Reserved Bits    */
} __type492;
typedef struct
{                              /* Bit Access       */
    const uint8 TMTRSTS0  : 1; /* TMTRSTS0         */
    const uint8 TMTRSTS1  : 1; /* TMTRSTS1         */
    const uint8 TMTRSTS2  : 1; /* TMTRSTS2         */
    const uint8 TMTRSTS3  : 1; /* TMTRSTS3         */
    const uint8 TMTRSTS4  : 1; /* TMTRSTS4         */
    const uint8 TMTRSTS5  : 1; /* TMTRSTS5         */
    const uint8 TMTRSTS6  : 1; /* TMTRSTS6         */
    const uint8 TMTRSTS7  : 1; /* TMTRSTS7         */
    const uint8 TMTRSTS8  : 1; /* TMTRSTS8         */
    const uint8 TMTRSTS9  : 1; /* TMTRSTS9         */
    const uint8 TMTRSTS10 : 1; /* TMTRSTS10        */
    const uint8 TMTRSTS11 : 1; /* TMTRSTS11        */
    const uint8 TMTRSTS12 : 1; /* TMTRSTS12        */
    const uint8 TMTRSTS13 : 1; /* TMTRSTS13        */
    const uint8 TMTRSTS14 : 1; /* TMTRSTS14        */
    const uint8 TMTRSTS15 : 1; /* TMTRSTS15        */
    const uint8 TMTRSTS16 : 1; /* TMTRSTS16        */
    const uint8 TMTRSTS17 : 1; /* TMTRSTS17        */
    const uint8 TMTRSTS18 : 1; /* TMTRSTS18        */
    const uint8 TMTRSTS19 : 1; /* TMTRSTS19        */
    const uint8 TMTRSTS20 : 1; /* TMTRSTS20        */
    const uint8 TMTRSTS21 : 1; /* TMTRSTS21        */
    const uint8 TMTRSTS22 : 1; /* TMTRSTS22        */
    const uint8 TMTRSTS23 : 1; /* TMTRSTS23        */
    const uint8 TMTRSTS24 : 1; /* TMTRSTS24        */
    const uint8 TMTRSTS25 : 1; /* TMTRSTS25        */
    const uint8 TMTRSTS26 : 1; /* TMTRSTS26        */
    const uint8 TMTRSTS27 : 1; /* TMTRSTS27        */
    const uint8 TMTRSTS28 : 1; /* TMTRSTS28        */
    const uint8 TMTRSTS29 : 1; /* TMTRSTS29        */
    const uint8 TMTRSTS30 : 1; /* TMTRSTS30        */
    const uint8 TMTRSTS31 : 1; /* TMTRSTS31        */
} __type493;
typedef struct
{                              /* Bit Access       */
    const uint8 TMTRSTS32 : 1; /* TMTRSTS32        */
    const uint8 TMTRSTS33 : 1; /* TMTRSTS33        */
    const uint8 TMTRSTS34 : 1; /* TMTRSTS34        */
    const uint8 TMTRSTS35 : 1; /* TMTRSTS35        */
    const uint8 TMTRSTS36 : 1; /* TMTRSTS36        */
    const uint8 TMTRSTS37 : 1; /* TMTRSTS37        */
    const uint8 TMTRSTS38 : 1; /* TMTRSTS38        */
    const uint8 TMTRSTS39 : 1; /* TMTRSTS39        */
    const uint8 TMTRSTS40 : 1; /* TMTRSTS40        */
    const uint8 TMTRSTS41 : 1; /* TMTRSTS41        */
    const uint8 TMTRSTS42 : 1; /* TMTRSTS42        */
    const uint8 TMTRSTS43 : 1; /* TMTRSTS43        */
    const uint8 TMTRSTS44 : 1; /* TMTRSTS44        */
    const uint8 TMTRSTS45 : 1; /* TMTRSTS45        */
    const uint8 TMTRSTS46 : 1; /* TMTRSTS46        */
    const uint8 TMTRSTS47 : 1; /* TMTRSTS47        */
    uint8                 : 8; /* Reserved Bits    */
    uint8                 : 8; /* Reserved Bits    */
} __type494;
typedef struct
{                               /* Bit Access       */
    const uint8 TMTARSTS0  : 1; /* TMTARSTS0        */
    const uint8 TMTARSTS1  : 1; /* TMTARSTS1        */
    const uint8 TMTARSTS2  : 1; /* TMTARSTS2        */
    const uint8 TMTARSTS3  : 1; /* TMTARSTS3        */
    const uint8 TMTARSTS4  : 1; /* TMTARSTS4        */
    const uint8 TMTARSTS5  : 1; /* TMTARSTS5        */
    const uint8 TMTARSTS6  : 1; /* TMTARSTS6        */
    const uint8 TMTARSTS7  : 1; /* TMTARSTS7        */
    const uint8 TMTARSTS8  : 1; /* TMTARSTS8        */
    const uint8 TMTARSTS9  : 1; /* TMTARSTS9        */
    const uint8 TMTARSTS10 : 1; /* TMTARSTS10       */
    const uint8 TMTARSTS11 : 1; /* TMTARSTS11       */
    const uint8 TMTARSTS12 : 1; /* TMTARSTS12       */
    const uint8 TMTARSTS13 : 1; /* TMTARSTS13       */
    const uint8 TMTARSTS14 : 1; /* TMTARSTS14       */
    const uint8 TMTARSTS15 : 1; /* TMTARSTS15       */
    const uint8 TMTARSTS16 : 1; /* TMTARSTS16       */
    const uint8 TMTARSTS17 : 1; /* TMTARSTS17       */
    const uint8 TMTARSTS18 : 1; /* TMTARSTS18       */
    const uint8 TMTARSTS19 : 1; /* TMTARSTS19       */
    const uint8 TMTARSTS20 : 1; /* TMTARSTS20       */
    const uint8 TMTARSTS21 : 1; /* TMTARSTS21       */
    const uint8 TMTARSTS22 : 1; /* TMTARSTS22       */
    const uint8 TMTARSTS23 : 1; /* TMTARSTS23       */
    const uint8 TMTARSTS24 : 1; /* TMTARSTS24       */
    const uint8 TMTARSTS25 : 1; /* TMTARSTS25       */
    const uint8 TMTARSTS26 : 1; /* TMTARSTS26       */
    const uint8 TMTARSTS27 : 1; /* TMTARSTS27       */
    const uint8 TMTARSTS28 : 1; /* TMTARSTS28       */
    const uint8 TMTARSTS29 : 1; /* TMTARSTS29       */
    const uint8 TMTARSTS30 : 1; /* TMTARSTS30       */
    const uint8 TMTARSTS31 : 1; /* TMTARSTS31       */
} __type495;
typedef struct
{                               /* Bit Access       */
    const uint8 TMTARSTS32 : 1; /* TMTARSTS32       */
    const uint8 TMTARSTS33 : 1; /* TMTARSTS33       */
    const uint8 TMTARSTS34 : 1; /* TMTARSTS34       */
    const uint8 TMTARSTS35 : 1; /* TMTARSTS35       */
    const uint8 TMTARSTS36 : 1; /* TMTARSTS36       */
    const uint8 TMTARSTS37 : 1; /* TMTARSTS37       */
    const uint8 TMTARSTS38 : 1; /* TMTARSTS38       */
    const uint8 TMTARSTS39 : 1; /* TMTARSTS39       */
    const uint8 TMTARSTS40 : 1; /* TMTARSTS40       */
    const uint8 TMTARSTS41 : 1; /* TMTARSTS41       */
    const uint8 TMTARSTS42 : 1; /* TMTARSTS42       */
    const uint8 TMTARSTS43 : 1; /* TMTARSTS43       */
    const uint8 TMTARSTS44 : 1; /* TMTARSTS44       */
    const uint8 TMTARSTS45 : 1; /* TMTARSTS45       */
    const uint8 TMTARSTS46 : 1; /* TMTARSTS46       */
    const uint8 TMTARSTS47 : 1; /* TMTARSTS47       */
    uint8                  : 8; /* Reserved Bits    */
    uint8                  : 8; /* Reserved Bits    */
} __type496;
typedef struct
{                              /* Bit Access       */
    const uint8 TMTCSTS0  : 1; /* TMTCSTS0         */
    const uint8 TMTCSTS1  : 1; /* TMTCSTS1         */
    const uint8 TMTCSTS2  : 1; /* TMTCSTS2         */
    const uint8 TMTCSTS3  : 1; /* TMTCSTS3         */
    const uint8 TMTCSTS4  : 1; /* TMTCSTS4         */
    const uint8 TMTCSTS5  : 1; /* TMTCSTS5         */
    const uint8 TMTCSTS6  : 1; /* TMTCSTS6         */
    const uint8 TMTCSTS7  : 1; /* TMTCSTS7         */
    const uint8 TMTCSTS8  : 1; /* TMTCSTS8         */
    const uint8 TMTCSTS9  : 1; /* TMTCSTS9         */
    const uint8 TMTCSTS10 : 1; /* TMTCSTS10        */
    const uint8 TMTCSTS11 : 1; /* TMTCSTS11        */
    const uint8 TMTCSTS12 : 1; /* TMTCSTS12        */
    const uint8 TMTCSTS13 : 1; /* TMTCSTS13        */
    const uint8 TMTCSTS14 : 1; /* TMTCSTS14        */
    const uint8 TMTCSTS15 : 1; /* TMTCSTS15        */
    const uint8 TMTCSTS16 : 1; /* TMTCSTS16        */
    const uint8 TMTCSTS17 : 1; /* TMTCSTS17        */
    const uint8 TMTCSTS18 : 1; /* TMTCSTS18        */
    const uint8 TMTCSTS19 : 1; /* TMTCSTS19        */
    const uint8 TMTCSTS20 : 1; /* TMTCSTS20        */
    const uint8 TMTCSTS21 : 1; /* TMTCSTS21        */
    const uint8 TMTCSTS22 : 1; /* TMTCSTS22        */
    const uint8 TMTCSTS23 : 1; /* TMTCSTS23        */
    const uint8 TMTCSTS24 : 1; /* TMTCSTS24        */
    const uint8 TMTCSTS25 : 1; /* TMTCSTS25        */
    const uint8 TMTCSTS26 : 1; /* TMTCSTS26        */
    const uint8 TMTCSTS27 : 1; /* TMTCSTS27        */
    const uint8 TMTCSTS28 : 1; /* TMTCSTS28        */
    const uint8 TMTCSTS29 : 1; /* TMTCSTS29        */
    const uint8 TMTCSTS30 : 1; /* TMTCSTS30        */
    const uint8 TMTCSTS31 : 1; /* TMTCSTS31        */
} __type497;
typedef struct
{                              /* Bit Access       */
    const uint8 TMTCSTS32 : 1; /* TMTCSTS32        */
    const uint8 TMTCSTS33 : 1; /* TMTCSTS33        */
    const uint8 TMTCSTS34 : 1; /* TMTCSTS34        */
    const uint8 TMTCSTS35 : 1; /* TMTCSTS35        */
    const uint8 TMTCSTS36 : 1; /* TMTCSTS36        */
    const uint8 TMTCSTS37 : 1; /* TMTCSTS37        */
    const uint8 TMTCSTS38 : 1; /* TMTCSTS38        */
    const uint8 TMTCSTS39 : 1; /* TMTCSTS39        */
    const uint8 TMTCSTS40 : 1; /* TMTCSTS40        */
    const uint8 TMTCSTS41 : 1; /* TMTCSTS41        */
    const uint8 TMTCSTS42 : 1; /* TMTCSTS42        */
    const uint8 TMTCSTS43 : 1; /* TMTCSTS43        */
    const uint8 TMTCSTS44 : 1; /* TMTCSTS44        */
    const uint8 TMTCSTS45 : 1; /* TMTCSTS45        */
    const uint8 TMTCSTS46 : 1; /* TMTCSTS46        */
    const uint8 TMTCSTS47 : 1; /* TMTCSTS47        */
    uint8                 : 8; /* Reserved Bits    */
    uint8                 : 8; /* Reserved Bits    */
} __type498;
typedef struct
{                              /* Bit Access       */
    const uint8 TMTASTS0  : 1; /* TMTASTS0         */
    const uint8 TMTASTS1  : 1; /* TMTASTS1         */
    const uint8 TMTASTS2  : 1; /* TMTASTS2         */
    const uint8 TMTASTS3  : 1; /* TMTASTS3         */
    const uint8 TMTASTS4  : 1; /* TMTASTS4         */
    const uint8 TMTASTS5  : 1; /* TMTASTS5         */
    const uint8 TMTASTS6  : 1; /* TMTASTS6         */
    const uint8 TMTASTS7  : 1; /* TMTASTS7         */
    const uint8 TMTASTS8  : 1; /* TMTASTS8         */
    const uint8 TMTASTS9  : 1; /* TMTASTS9         */
    const uint8 TMTASTS10 : 1; /* TMTASTS10        */
    const uint8 TMTASTS11 : 1; /* TMTASTS11        */
    const uint8 TMTASTS12 : 1; /* TMTASTS12        */
    const uint8 TMTASTS13 : 1; /* TMTASTS13        */
    const uint8 TMTASTS14 : 1; /* TMTASTS14        */
    const uint8 TMTASTS15 : 1; /* TMTASTS15        */
    const uint8 TMTASTS16 : 1; /* TMTASTS16        */
    const uint8 TMTASTS17 : 1; /* TMTASTS17        */
    const uint8 TMTASTS18 : 1; /* TMTASTS18        */
    const uint8 TMTASTS19 : 1; /* TMTASTS19        */
    const uint8 TMTASTS20 : 1; /* TMTASTS20        */
    const uint8 TMTASTS21 : 1; /* TMTASTS21        */
    const uint8 TMTASTS22 : 1; /* TMTASTS22        */
    const uint8 TMTASTS23 : 1; /* TMTASTS23        */
    const uint8 TMTASTS24 : 1; /* TMTASTS24        */
    const uint8 TMTASTS25 : 1; /* TMTASTS25        */
    const uint8 TMTASTS26 : 1; /* TMTASTS26        */
    const uint8 TMTASTS27 : 1; /* TMTASTS27        */
    const uint8 TMTASTS28 : 1; /* TMTASTS28        */
    const uint8 TMTASTS29 : 1; /* TMTASTS29        */
    const uint8 TMTASTS30 : 1; /* TMTASTS30        */
    const uint8 TMTASTS31 : 1; /* TMTASTS31        */
} __type499;
typedef struct
{                              /* Bit Access       */
    const uint8 TMTASTS32 : 1; /* TMTASTS32        */
    const uint8 TMTASTS33 : 1; /* TMTASTS33        */
    const uint8 TMTASTS34 : 1; /* TMTASTS34        */
    const uint8 TMTASTS35 : 1; /* TMTASTS35        */
    const uint8 TMTASTS36 : 1; /* TMTASTS36        */
    const uint8 TMTASTS37 : 1; /* TMTASTS37        */
    const uint8 TMTASTS38 : 1; /* TMTASTS38        */
    const uint8 TMTASTS39 : 1; /* TMTASTS39        */
    const uint8 TMTASTS40 : 1; /* TMTASTS40        */
    const uint8 TMTASTS41 : 1; /* TMTASTS41        */
    const uint8 TMTASTS42 : 1; /* TMTASTS42        */
    const uint8 TMTASTS43 : 1; /* TMTASTS43        */
    const uint8 TMTASTS44 : 1; /* TMTASTS44        */
    const uint8 TMTASTS45 : 1; /* TMTASTS45        */
    const uint8 TMTASTS46 : 1; /* TMTASTS46        */
    const uint8 TMTASTS47 : 1; /* TMTASTS47        */
    uint8                 : 8; /* Reserved Bits    */
    uint8                 : 8; /* Reserved Bits    */
} __type500;
typedef struct
{                     /* Bit Access       */
    uint8 TMIE0  : 1; /* TMIE0            */
    uint8 TMIE1  : 1; /* TMIE1            */
    uint8 TMIE2  : 1; /* TMIE2            */
    uint8 TMIE3  : 1; /* TMIE3            */
    uint8 TMIE4  : 1; /* TMIE4            */
    uint8 TMIE5  : 1; /* TMIE5            */
    uint8 TMIE6  : 1; /* TMIE6            */
    uint8 TMIE7  : 1; /* TMIE7            */
    uint8 TMIE8  : 1; /* TMIE8            */
    uint8 TMIE9  : 1; /* TMIE9            */
    uint8 TMIE10 : 1; /* TMIE10           */
    uint8 TMIE11 : 1; /* TMIE11           */
    uint8 TMIE12 : 1; /* TMIE12           */
    uint8 TMIE13 : 1; /* TMIE13           */
    uint8 TMIE14 : 1; /* TMIE14           */
    uint8 TMIE15 : 1; /* TMIE15           */
    uint8 TMIE16 : 1; /* TMIE16           */
    uint8 TMIE17 : 1; /* TMIE17           */
    uint8 TMIE18 : 1; /* TMIE18           */
    uint8 TMIE19 : 1; /* TMIE19           */
    uint8 TMIE20 : 1; /* TMIE20           */
    uint8 TMIE21 : 1; /* TMIE21           */
    uint8 TMIE22 : 1; /* TMIE22           */
    uint8 TMIE23 : 1; /* TMIE23           */
    uint8 TMIE24 : 1; /* TMIE24           */
    uint8 TMIE25 : 1; /* TMIE25           */
    uint8 TMIE26 : 1; /* TMIE26           */
    uint8 TMIE27 : 1; /* TMIE27           */
    uint8 TMIE28 : 1; /* TMIE28           */
    uint8 TMIE29 : 1; /* TMIE29           */
    uint8 TMIE30 : 1; /* TMIE30           */
    uint8 TMIE31 : 1; /* TMIE31           */
} __type501;
typedef struct
{                     /* Bit Access       */
    uint8 TMIE32 : 1; /* TMIE32           */
    uint8 TMIE33 : 1; /* TMIE33           */
    uint8 TMIE34 : 1; /* TMIE34           */
    uint8 TMIE35 : 1; /* TMIE35           */
    uint8 TMIE36 : 1; /* TMIE36           */
    uint8 TMIE37 : 1; /* TMIE37           */
    uint8 TMIE38 : 1; /* TMIE38           */
    uint8 TMIE39 : 1; /* TMIE39           */
    uint8 TMIE40 : 1; /* TMIE40           */
    uint8 TMIE41 : 1; /* TMIE41           */
    uint8 TMIE42 : 1; /* TMIE42           */
    uint8 TMIE43 : 1; /* TMIE43           */
    uint8 TMIE44 : 1; /* TMIE44           */
    uint8 TMIE45 : 1; /* TMIE45           */
    uint8 TMIE46 : 1; /* TMIE46           */
    uint8 TMIE47 : 1; /* TMIE47           */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type502;
typedef struct
{                    /* Bit Access       */
    uint8 TXQE  : 1; /* TXQE             */
    uint8       : 7; /* Reserved Bits    */
    uint8 TXQDC : 4; /* TXQDC[11:8]      */
    uint8 TXQIE : 1; /* TXQIE            */
    uint8 TXQIM : 1; /* TXQIM            */
    uint8       : 2; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type503;
typedef struct
{                           /* Bit Access       */
    const uint8 TXQEMP : 1; /* TXQEMP           */
    const uint8 TXQFLL : 1; /* TXQFLL           */
    uint8       TXQIF  : 1; /* TXQIF            */
    uint8              : 5; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type504;
typedef struct
{                    /* Bit Access       */
    uint8 TXQPC : 8; /* TXQPC[7:0]       */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type505;
typedef struct
{                     /* Bit Access       */
    uint8 THLE   : 1; /* THLE             */
    uint8        : 7; /* Reserved Bits    */
    uint8 THLIE  : 1; /* THLIE            */
    uint8 THLIM  : 1; /* THLIM            */
    uint8 THLDTE : 1; /* THLDTE           */
    uint8        : 5; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type506;
typedef struct
{                           /* Bit Access       */
    const uint8 THLEMP : 1; /* THLEMP           */
    const uint8 THLFLL : 1; /* THLFLL           */
    uint8       THLELT : 1; /* THLELT           */
    uint8       THLIF  : 1; /* THLIF            */
    uint8              : 4; /* Reserved Bits    */
    const uint8 THLMC  : 5; /* THLMC[12:8]      */
    uint8              : 3; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type507;
typedef struct
{                    /* Bit Access       */
    uint8 THLPC : 8; /* THLPC[7:0]       */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type508;
typedef struct
{                           /* Bit Access       */
    const uint8 TSIF0  : 1; /* TSIF0            */
    const uint8 TAIF0  : 1; /* TAIF0            */
    const uint8 TQIF0  : 1; /* TQIF0            */
    const uint8 CFTIF0 : 1; /* CFTIF0           */
    const uint8 THIF0  : 1; /* THIF0            */
    uint8              : 3; /* Reserved Bits    */
    const uint8 TSIF1  : 1; /* TSIF1            */
    const uint8 TAIF1  : 1; /* TAIF1            */
    const uint8 TQIF1  : 1; /* TQIF1            */
    const uint8 CFTIF1 : 1; /* CFTIF1           */
    const uint8 THIF1  : 1; /* THIF1            */
    uint8              : 3; /* Reserved Bits    */
    const uint8 TSIF2  : 1; /* TSIF2            */
    const uint8 TAIF2  : 1; /* TAIF2            */
    const uint8 TQIF2  : 1; /* TQIF2            */
    const uint8 CFTIF2 : 1; /* CFTIF2           */
    const uint8 THIF2  : 1; /* THIF2            */
    uint8              : 3; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type509;
typedef struct
{                      /* Bit Access       */
    uint8 C0ICBCE : 1; /* C0ICBCE          */
    uint8 C1ICBCE : 1; /* C1ICBCE          */
    uint8 C2ICBCE : 1; /* C2ICBCE          */
    uint8         : 5; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8 RTMPS   : 7; /* RTMPS[22:16]     */
    uint8         : 1; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
} __type510;
typedef struct
{                      /* Bit Access       */
    uint8 ICBCTME : 1; /* ICBCTME          */
    uint8         : 1; /* Reserved Bits    */
    uint8 RTME    : 1; /* RTME             */
    uint8         : 5; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
} __type511;
typedef struct
{                     /* Bit Access       */
    uint16 LOCK : 16; /* LOCK[15:0]       */
    uint16      : 16; /* Reserved Bits    */
} __type512;
typedef struct
{                        /* Bit Access       */
    uint32 GAFLID  : 29; /* GAFLID[28:0]     */
    uint8  GAFLLB  : 1;  /* GAFLLB           */
    uint8  GAFLRTR : 1;  /* GAFLRTR          */
    uint8  GAFLIDE : 1;  /* GAFLIDE          */
} __type513;
typedef struct
{                        /* Bit Access       */
    uint32 GAFLIDM : 29; /* GAFLIDM[28:0]    */
    uint8          : 1;  /* Reserved Bits    */
    uint8 GAFLRTRM : 1;  /* GAFLRTRM         */
    uint8 GAFLIDEM : 1;  /* GAFLIDEM         */
} __type514;
typedef struct
{                         /* Bit Access       */
    uint8           : 8;  /* Reserved Bits    */
    uint8  GAFLRMDP : 7;  /* GAFLRMDP[14:8]   */
    uint8  GAFLRMV  : 1;  /* GAFLRMV          */
    uint16 GAFLPTR  : 12; /* GAFLPTR[27:16]   */
    uint8  GAFLDLC  : 4;  /* GAFLDLC[31:28]   */
} __type515;
typedef struct
{                        /* Bit Access       */
    uint32 GAFLFDP : 26; /* GAFLFDP[25:0]    */
    uint8          : 6;  /* Reserved Bits    */
} __type516;
typedef struct
{                           /* Bit Access       */
    const uint32 RMID : 29; /* RMID[28:0]       */
    uint8             : 1;  /* Reserved Bits    */
    const uint8 RMRTR : 1;  /* RMRTR            */
    const uint8 RMIDE : 1;  /* RMIDE            */
} __type517;
typedef struct
{                            /* Bit Access       */
    const uint16 RMTS  : 16; /* RMTS[15:0]       */
    const uint16 RMPTR : 12; /* RMPTR[27:16]     */
    const uint8  RMDLC : 4;  /* RMDLC[31:28]     */
} __type518;
typedef struct
{                          /* Bit Access       */
    const uint8 RMDB0 : 8; /* RMDB0[7:0]       */
    const uint8 RMDB1 : 8; /* RMDB1[15:8]      */
    const uint8 RMDB2 : 8; /* RMDB2[23:16]     */
    const uint8 RMDB3 : 8; /* RMDB3[31:24]     */
} __type519;
typedef struct
{                          /* Bit Access       */
    const uint8 RMDB4 : 8; /* RMDB4[7:0]       */
    const uint8 RMDB5 : 8; /* RMDB5[15:8]      */
    const uint8 RMDB6 : 8; /* RMDB6[23:16]     */
    const uint8 RMDB7 : 8; /* RMDB7[31:24]     */
} __type520;
typedef struct
{                           /* Bit Access       */
    const uint32 RFID : 29; /* RFID[28:0]       */
    uint8             : 1;  /* Reserved Bits    */
    const uint8 RFRTR : 1;  /* RFRTR            */
    const uint8 RFIDE : 1;  /* RFIDE            */
} __type521;
typedef struct
{                            /* Bit Access       */
    const uint16 RFTS  : 16; /* RFTS[15:0]       */
    const uint16 RFPTR : 12; /* RFPTR[27:16]     */
    const uint8  RFDLC : 4;  /* RFDLC[31:28]     */
} __type522;
typedef struct
{                          /* Bit Access       */
    const uint8 RFDB0 : 8; /* RFDB0[7:0]       */
    const uint8 RFDB1 : 8; /* RFDB1[15:8]      */
    const uint8 RFDB2 : 8; /* RFDB2[23:16]     */
    const uint8 RFDB3 : 8; /* RFDB3[31:24]     */
} __type523;
typedef struct
{                          /* Bit Access       */
    const uint8 RFDB4 : 8; /* RFDB4[7:0]       */
    const uint8 RFDB5 : 8; /* RFDB5[15:8]      */
    const uint8 RFDB6 : 8; /* RFDB6[23:16]     */
    const uint8 RFDB7 : 8; /* RFDB7[31:24]     */
} __type524;
typedef struct
{                      /* Bit Access       */
    uint32 CFID  : 29; /* CFID[28:0]       */
    uint8  THLEN : 1;  /* THLEN            */
    uint8  CFRTR : 1;  /* CFRTR            */
    uint8  CFIDE : 1;  /* CFIDE            */
} __type525;
typedef struct
{                      /* Bit Access       */
    uint16 CFTS  : 16; /* CFTS[15:0]       */
    uint16 CFPTR : 12; /* CFPTR[27:16]     */
    uint8  CFDLC : 4;  /* CFDLC[31:28]     */
} __type526;
typedef struct
{                    /* Bit Access       */
    uint8 CFDB0 : 8; /* CFDB0[7:0]       */
    uint8 CFDB1 : 8; /* CFDB1[15:8]      */
    uint8 CFDB2 : 8; /* CFDB2[23:16]     */
    uint8 CFDB3 : 8; /* CFDB3[31:24]     */
} __type527;
typedef struct
{                    /* Bit Access       */
    uint8 CFDB4 : 8; /* CFDB4[7:0]       */
    uint8 CFDB5 : 8; /* CFDB5[15:8]      */
    uint8 CFDB6 : 8; /* CFDB6[23:16]     */
    uint8 CFDB7 : 8; /* CFDB7[31:24]     */
} __type528;
typedef struct
{                      /* Bit Access       */
    uint32 TMID  : 29; /* TMID[28:0]       */
    uint8  THLEN : 1;  /* THLEN            */
    uint8  TMRTR : 1;  /* TMRTR            */
    uint8  TMIDE : 1;  /* TMIDE            */
} __type529;
typedef struct
{                    /* Bit Access       */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8 TMPTR : 8; /* TMPTR[23:16]     */
    uint8       : 4; /* Reserved Bits    */
    uint8 TMDLC : 4; /* TMDLC[31:28]     */
} __type530;
typedef struct
{                    /* Bit Access       */
    uint8 TMDB0 : 8; /* TMDB0[7:0]       */
    uint8 TMDB1 : 8; /* TMDB1[15:8]      */
    uint8 TMDB2 : 8; /* TMDB2[23:16]     */
    uint8 TMDB3 : 8; /* TMDB3[31:24]     */
} __type531;
typedef struct
{                    /* Bit Access       */
    uint8 TMDB4 : 8; /* TMDB4[7:0]       */
    uint8 TMDB5 : 8; /* TMDB5[15:8]      */
    uint8 TMDB6 : 8; /* TMDB6[23:16]     */
    uint8 TMDB7 : 8; /* TMDB7[31:24]     */
} __type532;
typedef struct
{                        /* Bit Access       */
    const uint8 BT  : 3; /* BT[2:0]          */
    const uint8 BN  : 4; /* BN[6:3]          */
    uint8           : 1; /* Reserved Bits    */
    const uint8 TID : 8; /* TID[15:8]        */
    uint8           : 8; /* Reserved Bits    */
    uint8           : 8; /* Reserved Bits    */
} __type533;
typedef struct
{                     /* Bit Access       */
    uint32 RDTA : 32; /* RDTA[31:0]       */
} __type534;
typedef struct
{                  /* Bit Access       */
    uint8     : 5; /* Reserved Bits    */
    uint8 RXE : 1; /* RXE              */
    uint8 TXE : 1; /* TXE              */
    uint8 PWR : 1; /* PWR              */
} __type535;
typedef struct
{                          /* Bit Access       */
    const uint32 OVE : 1;  /* OVE              */
    const uint32 PE  : 1;  /* PE               */
    uint32           : 1;  /* Reserved Bits    */
    const uint32 DCE : 1;  /* DCE              */
    uint32           : 3;  /* Reserved Bits    */
    const uint32 TSF : 1;  /* TSF              */
    uint32           : 24; /* Reserved Bits    */
} __type536;
typedef struct
{                     /* Bit Access       */
    uint16 OVEC : 1;  /* OVEC             */
    uint16 PEC  : 1;  /* PEC              */
    uint16      : 1;  /* Reserved Bits    */
    uint16 DCEC : 1;  /* DCEC             */
    uint16      : 12; /* Reserved Bits    */
} __type537;
typedef struct
{                     /* Bit Access       */
    uint32 SSE  : 1;  /* SSE              */
    uint32      : 1;  /* Reserved Bits    */
    uint32 SIT  : 1;  /* SIT              */
    uint32 LBM  : 1;  /* LBM              */
    uint32      : 1;  /* Reserved Bits    */
    uint32 DCS  : 1;  /* DCS              */
    uint32      : 1;  /* Reserved Bits    */
    uint32 EDLE : 1;  /* EDLE             */
    uint32      : 8;  /* Reserved Bits    */
    uint32 SLIT : 1;  /* SLIT             */
    uint32 CKR  : 1;  /* CKR              */
    uint32      : 14; /* Reserved Bits    */
} __type538;
typedef struct
{                    /* Bit Access       */
    uint16 BRS : 12; /* BRS[11:0]        */
    uint16     : 1;  /* Reserved Bits    */
    uint16 PRS : 3;  /* PRS[15:13]       */
} __type539;
typedef struct
{                     /* Bit Access       */
    uint8        : 7; /* Reserved Bits    */
    uint8 SVSDIS : 1; /* SVSDIS           */
} __type540;
typedef struct
{                  /* Bit Access       */
    uint8 SCE : 1; /* SCE              */
    uint8     : 7; /* Reserved Bits    */
} __type541;
typedef struct
{                    /* Bit Access       */
    uint32 TX  : 16; /* TX[15:0]         */
    uint32     : 13; /* Reserved Bits    */
    uint32 EDL : 1;  /* EDL              */
    uint32     : 2;  /* Reserved Bits    */
} __type542;
typedef struct
{                   /* Bit Access       */
    uint16 TX : 16; /* TX[15:0]         */
} __type543;
typedef struct
{                         /* Bit Access       */
    const uint16 RX : 16; /* RX[15:0]         */
} __type544;
typedef struct
{                    /* Bit Access       */
    uint32     : 16; /* Reserved Bits    */
    uint32 DAP : 1;  /* DAP              */
    uint32     : 1;  /* Reserved Bits    */
    uint32 DIR : 1;  /* DIR              */
    uint32     : 5;  /* Reserved Bits    */
    uint32 DLS : 4;  /* DLS[27:24]       */
    uint32 PS  : 2;  /* PS[29:28]        */
    uint32     : 2;  /* Reserved Bits    */
} __type545;
typedef struct
{                     /* Bit Access       */
    uint32 SSE  : 1;  /* SSE              */
    uint32 HSE  : 1;  /* HSE              */
    uint32 SIT  : 1;  /* SIT              */
    uint32 LBM  : 1;  /* LBM              */
    uint32      : 1;  /* Reserved Bits    */
    uint32 DCS  : 1;  /* DCS              */
    uint32      : 1;  /* Reserved Bits    */
    uint32 EDLE : 1;  /* EDLE             */
    uint32      : 8;  /* Reserved Bits    */
    uint32 SLIT : 1;  /* SLIT             */
    uint32 CKR  : 1;  /* CKR              */
    uint32      : 14; /* Reserved Bits    */
} __type546;
typedef struct
{                   /* Bit Access       */
    uint8 MBS  : 1; /* MBS              */
    uint8 JOBE : 1; /* JOBE             */
    uint8      : 3; /* Reserved Bits    */
    uint8 RXE  : 1; /* RXE              */
    uint8 TXE  : 1; /* TXE              */
    uint8 PWR  : 1; /* PWR              */
} __type547;
typedef struct
{                          /* Bit Access       */
    const uint32 OVE  : 1; /* OVE              */
    const uint32 PE   : 1; /* PE               */
    uint32            : 1; /* Reserved Bits    */
    const uint32 DCE  : 1; /* DCE              */
    const uint32 EMF  : 1; /* EMF              */
    const uint32 FLF  : 1; /* FLF              */
    uint32            : 1; /* Reserved Bits    */
    const uint32 TSF  : 1; /* TSF              */
    const uint32 HPST : 1; /* HPST             */
    uint32            : 5; /* Reserved Bits    */
    const uint32 OFE  : 1; /* OFE              */
    const uint32 TMOE : 1; /* TMOE             */
    const uint32 SPF  : 8; /* SPF[23:16]       */
    const uint32 SRP  : 8; /* SRP[31:24]       */
} __type548;
typedef struct
{                     /* Bit Access       */
    uint16 OVEC  : 1; /* OVEC             */
    uint16 PEC   : 1; /* PEC              */
    uint16       : 1; /* Reserved Bits    */
    uint16 DCEC  : 1; /* DCEC             */
    uint16       : 4; /* Reserved Bits    */
    uint16 PCT   : 1; /* PCT              */
    uint16       : 5; /* Reserved Bits    */
    uint16 OFEC  : 1; /* OFEC             */
    uint16 TMOEC : 1; /* TMOEC            */
} __type549;
typedef struct
{                    /* Bit Access       */
    uint32 SSE  : 1; /* SSE              */
    uint32 HSE  : 1; /* HSE              */
    uint32 SIT  : 1; /* SIT              */
    uint32 LBM  : 1; /* LBM              */
    uint32 CSRI : 1; /* CSRI             */
    uint32 DCS  : 1; /* DCS              */
    uint32 JE   : 1; /* JE               */
    uint32 EDLE : 1; /* EDLE             */
    uint32 CSL0 : 1; /* CSL0             */
    uint32 CSL1 : 1; /* CSL1             */
    uint32 CSL2 : 1; /* CSL2             */
    uint32 CSL3 : 1; /* CSL3             */
    uint32 CSL4 : 1; /* CSL4             */
    uint32 CSL5 : 1; /* CSL5             */
    uint32 CSL6 : 1; /* CSL6             */
    uint32 CSL7 : 1; /* CSL7             */
    uint32 SLIT : 1; /* SLIT             */
    uint32 CKR  : 1; /* CKR              */
    uint32 PHE  : 1; /* PHE              */
    uint32      : 5; /* Reserved Bits    */
    uint32 SLRS : 1; /* SLRS             */
    uint32      : 7; /* Reserved Bits    */
} __type550;
typedef struct
{                    /* Bit Access       */
    uint16     : 13; /* Reserved Bits    */
    uint16 PRS : 3;  /* PRS[15:13]       */
} __type551;
typedef struct
{                   /* Bit Access       */
    uint32 FFS : 7; /* FFS[6:0]         */
    uint32     : 9; /* Reserved Bits    */
    uint32 FES : 7; /* FES[22:16]       */
    uint32     : 9; /* Reserved Bits    */
} __type552;
typedef struct
{                    /* Bit Access       */
    uint32 SOP  : 7; /* SOP[6:0]         */
    uint32      : 9; /* Reserved Bits    */
    uint32 ND   : 8; /* ND[23:16]        */
    uint32      : 7; /* Reserved Bits    */
    uint32 BTST : 1; /* BTST             */
} __type553;
typedef struct
{                     /* Bit Access       */
    uint32 TX   : 16; /* TX[15:0]         */
    uint32 CS0  : 1;  /* CS0              */
    uint32 CS1  : 1;  /* CS1              */
    uint32 CS2  : 1;  /* CS2              */
    uint32 CS3  : 1;  /* CS3              */
    uint32 CS4  : 1;  /* CS4              */
    uint32 CS5  : 1;  /* CS5              */
    uint32 CS6  : 1;  /* CS6              */
    uint32 CS7  : 1;  /* CS7              */
    uint32      : 5;  /* Reserved Bits    */
    uint32 EDL  : 1;  /* EDL              */
    uint32 EOJ  : 1;  /* EOJ              */
    uint32 CIRE : 1;  /* CIRE             */
} __type554;
typedef struct
{                           /* Bit Access       */
    const uint32 RX   : 16; /* RX[15:0]         */
    const uint32 CS0  : 1;  /* CS0              */
    uint32            : 7;  /* Reserved Bits    */
    const uint32 TDCE : 1;  /* TDCE             */
    const uint32 RPE  : 1;  /* RPE              */
    uint32            : 6;  /* Reserved Bits    */
} __type555;
typedef struct
{                    /* Bit Access       */
    uint32 TRWA : 7; /* TRWA[6:0]        */
    uint32      : 9; /* Reserved Bits    */
    uint32 RRA  : 7; /* RRA[22:16]       */
    uint32      : 9; /* Reserved Bits    */
} __type556;
typedef struct
{                   /* Bit Access       */
    uint16 TO  : 5; /* TO[4:0]          */
    uint16     : 3; /* Reserved Bits    */
    uint16 MMS : 2; /* MMS[9:8]         */
    uint16     : 6; /* Reserved Bits    */
} __type557;
typedef struct
{                     /* Bit Access       */
    uint32 SP0   : 4; /* SP0[3:0]         */
    uint32 IN0   : 4; /* IN0[7:4]         */
    uint32 HD0   : 4; /* HD0[11:8]        */
    uint32 ID0   : 3; /* ID0[14:12]       */
    uint32 IDL0  : 1; /* IDL0             */
    uint32 DAP0  : 1; /* DAP0             */
    uint32 CKP0  : 1; /* CKP0             */
    uint32 DIR0  : 1; /* DIR0             */
    uint32 RCB0  : 1; /* RCB0             */
    uint32       : 4; /* Reserved Bits    */
    uint32 DLS0  : 4; /* DLS0[27:24]      */
    uint32 PS0   : 2; /* PS0[29:28]       */
    uint32 BRSS0 : 2; /* BRSS0[31:30]     */
} __type558;
typedef struct
{                    /* Bit Access       */
    uint16 BRS : 12; /* BRS[11:0]        */
    uint16     : 4;  /* Reserved Bits    */
} __type559;
typedef struct
{                          /* Bit Access       */
    const uint32 OVE  : 1; /* OVE              */
    const uint32 PE   : 1; /* PE               */
    uint32            : 1; /* Reserved Bits    */
    const uint32 DCE  : 1; /* DCE              */
    const uint32 EMF  : 1; /* EMF              */
    const uint32 FLF  : 1; /* FLF              */
    uint32            : 1; /* Reserved Bits    */
    const uint32 TSF  : 1; /* TSF              */
    uint32            : 6; /* Reserved Bits    */
    const uint32 OFE  : 1; /* OFE              */
    const uint32 TMOE : 1; /* TMOE             */
    const uint32 SPF  : 8; /* SPF[23:16]       */
    const uint32 SRP  : 8; /* SRP[31:24]       */
} __type560;
typedef struct
{                     /* Bit Access       */
    uint32      : 2;  /* Reserved Bits    */
    uint32 SIT  : 1;  /* SIT              */
    uint32 LBM  : 1;  /* LBM              */
    uint32 CSRI : 1;  /* CSRI             */
    uint32 DCS  : 1;  /* DCS              */
    uint32 JE   : 1;  /* JE               */
    uint32 EDLE : 1;  /* EDLE             */
    uint32 CSL0 : 1;  /* CSL0             */
    uint32 CSL1 : 1;  /* CSL1             */
    uint32 CSL2 : 1;  /* CSL2             */
    uint32 CSL3 : 1;  /* CSL3             */
    uint32 CSL4 : 1;  /* CSL4             */
    uint32 CSL5 : 1;  /* CSL5             */
    uint32 CSL6 : 1;  /* CSL6             */
    uint32 CSL7 : 1;  /* CSL7             */
    uint32 SLIT : 1;  /* SLIT             */
    uint32 CKR  : 1;  /* CKR              */
    uint32      : 14; /* Reserved Bits    */
} __type561;
typedef struct
{                     /* Bit Access       */
    uint32 SP0   : 4; /* SP0[3:0]         */
    uint32 IN0   : 4; /* IN0[7:4]         */
    uint32 HD0   : 4; /* HD0[11:8]        */
    uint32 ID0   : 3; /* ID0[14:12]       */
    uint32 IDL0  : 1; /* IDL0             */
    uint32 DAP0  : 1; /* DAP0             */
    uint32 CKP0  : 1; /* CKP0             */
    uint32 DIR0  : 1; /* DIR0             */
    uint32 RCB0  : 1; /* RCB0             */
    uint32       : 4; /* Reserved Bits    */
    uint32 DLS0  : 4; /* DLS0[27:24]      */
    uint32 PS0   : 2; /* PS0[29:28]       */
    uint32 PSCL0 : 2; /* PSCL0[31:30]     */
} __type562;
typedef struct
{                           /* Bit Access       */
    const uint8 SDAI   : 1; /* SDAI             */
    const uint8 SCLI   : 1; /* SCLI             */
    uint8       SDAO   : 1; /* SDAO             */
    uint8       SCLO   : 1; /* SCLO             */
    uint8       SOWP   : 1; /* SOWP             */
    uint8       CLO    : 1; /* CLO              */
    uint8       IICRST : 1; /* IICRST           */
    uint8       ICE    : 1; /* ICE              */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type563;
typedef struct
{                         /* Bit Access       */
    uint8            : 1; /* Reserved Bits    */
    uint8 ST         : 1; /* ST               */
    uint8 RS         : 1; /* RS               */
    uint8 SP         : 1; /* SP               */
    uint8            : 1; /* Reserved Bits    */
    uint8       TRS  : 1; /* TRS              */
    uint8       MST  : 1; /* MST              */
    const uint8 BBSY : 1; /* BBSY             */
    uint8            : 8; /* Reserved Bits    */
    uint8            : 8; /* Reserved Bits    */
    uint8            : 8; /* Reserved Bits    */
} __type564;
typedef struct
{                   /* Bit Access       */
    uint8 BC   : 3; /* BC[2:0]          */
    uint8 BCWP : 1; /* BCWP             */
    uint8 CKS  : 3; /* CKS[6:4]         */
    uint8 MTWP : 1; /* MTWP             */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type565;
typedef struct
{                   /* Bit Access       */
    uint8 TMOS : 1; /* TMOS             */
    uint8 TMOL : 1; /* TMOL             */
    uint8 TMOH : 1; /* TMOH             */
    uint8      : 1; /* Reserved Bits    */
    uint8 SDDL : 3; /* SDDL[6:4]        */
    uint8 DLCS : 1; /* DLCS             */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type566;
typedef struct
{                          /* Bit Access       */
    uint8       NF    : 2; /* NF[1:0]          */
    const uint8 ACKBR : 1; /* ACKBR            */
    uint8       ACKBT : 1; /* ACKBT            */
    uint8       ACKWP : 1; /* ACKWP            */
    uint8       RDRFS : 1; /* RDRFS            */
    uint8       WAIT  : 1; /* WAIT             */
    uint8             : 1; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type567;
typedef struct
{                    /* Bit Access       */
    uint8 TMOE  : 1; /* TMOE             */
    uint8 MALE  : 1; /* MALE             */
    uint8 NALE  : 1; /* NALE             */
    uint8 SALE  : 1; /* SALE             */
    uint8 NACKE : 1; /* NACKE            */
    uint8 NFE   : 1; /* NFE              */
    uint8 SCLE  : 1; /* SCLE             */
    uint8       : 1; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type568;
typedef struct
{                   /* Bit Access       */
    uint8 SAR0 : 1; /* SAR0             */
    uint8 SAR1 : 1; /* SAR1             */
    uint8 SAR2 : 1; /* SAR2             */
    uint8 GCE  : 1; /* GCE              */
    uint8      : 1; /* Reserved Bits    */
    uint8 DIDE : 1; /* DIDE             */
    uint8      : 2; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type569;
typedef struct
{                    /* Bit Access       */
    uint8 TMOIE : 1; /* TMOIE            */
    uint8 ALIE  : 1; /* ALIE             */
    uint8 STIE  : 1; /* STIE             */
    uint8 SPIE  : 1; /* SPIE             */
    uint8 NAKIE : 1; /* NAKIE            */
    uint8 RIE   : 1; /* RIE              */
    uint8 TEIE  : 1; /* TEIE             */
    uint8 TIE   : 1; /* TIE              */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type570;
typedef struct
{                   /* Bit Access       */
    uint8 AAS0 : 1; /* AAS0             */
    uint8 AAS1 : 1; /* AAS1             */
    uint8 AAS2 : 1; /* AAS2             */
    uint8 GCA  : 1; /* GCA              */
    uint8      : 1; /* Reserved Bits    */
    uint8 DID  : 1; /* DID              */
    uint8      : 2; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type571;
typedef struct
{                          /* Bit Access       */
    uint8       TMOF  : 1; /* TMOF             */
    uint8       AL    : 1; /* AL               */
    uint8       START : 1; /* START            */
    uint8       STOP  : 1; /* STOP             */
    uint8       NACKF : 1; /* NACKF            */
    uint8       RDRF  : 1; /* RDRF             */
    uint8       TEND  : 1; /* TEND             */
    const uint8 TDRE  : 1; /* TDRE             */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type572;
typedef struct
{                    /* Bit Access       */
    uint8  SVA0 : 1; /* SVA0             */
    uint16 SVA  : 9; /* SVA[9:1]         */
    uint8       : 5; /* Reserved Bits    */
    uint8 FS0   : 1; /* FS0              */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type573;
typedef struct
{                    /* Bit Access       */
    uint8  SVA0 : 1; /* SVA0             */
    uint16 SVA  : 9; /* SVA[9:1]         */
    uint8       : 5; /* Reserved Bits    */
    uint8 FS1   : 1; /* FS1              */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type574;
typedef struct
{                    /* Bit Access       */
    uint8  SVA0 : 1; /* SVA0             */
    uint16 SVA  : 9; /* SVA[9:1]         */
    uint8       : 5; /* Reserved Bits    */
    uint8 FS2   : 1; /* FS2              */
    uint8       : 8; /* Reserved Bits    */
    uint8       : 8; /* Reserved Bits    */
} __type575;
typedef struct
{                  /* Bit Access       */
    uint8 BRL : 5; /* BRL[4:0]         */
    uint8     : 3; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
} __type576;
typedef struct
{                  /* Bit Access       */
    uint8 BRH : 5; /* BRH[4:0]         */
    uint8     : 3; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
} __type577;
typedef struct
{                  /* Bit Access       */
    uint8 DRT : 8; /* DRT[7:0]         */
    uint8     : 8; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
    uint8     : 8; /* Reserved Bits    */
} __type578;
typedef struct
{                        /* Bit Access       */
    const uint8 DRR : 8; /* DRR[7:0]         */
    uint8           : 8; /* Reserved Bits    */
    uint8           : 8; /* Reserved Bits    */
    uint8           : 8; /* Reserved Bits    */
} __type579;
typedef struct
{                     /* Bit Access       */
    uint16 TOL00 : 1; /* TOL00            */
    uint16 TOL01 : 1; /* TOL01            */
    uint16 TOL02 : 1; /* TOL02            */
    uint16 TOL03 : 1; /* TOL03            */
    uint16 TOL04 : 1; /* TOL04            */
    uint16 TOL05 : 1; /* TOL05            */
    uint16 TOL06 : 1; /* TOL06            */
    uint16 TOL07 : 1; /* TOL07            */
    uint16 TOL08 : 1; /* TOL08            */
    uint16 TOL09 : 1; /* TOL09            */
    uint16 TOL10 : 1; /* TOL10            */
    uint16 TOL11 : 1; /* TOL11            */
    uint16 TOL12 : 1; /* TOL12            */
    uint16 TOL13 : 1; /* TOL13            */
    uint16 TOL14 : 1; /* TOL14            */
    uint16 TOL15 : 1; /* TOL15            */
} __type580;
typedef struct
{                     /* Bit Access       */
    uint16 RDT00 : 1; /* RDT00            */
    uint16 RDT01 : 1; /* RDT01            */
    uint16 RDT02 : 1; /* RDT02            */
    uint16 RDT03 : 1; /* RDT03            */
    uint16 RDT04 : 1; /* RDT04            */
    uint16 RDT05 : 1; /* RDT05            */
    uint16 RDT06 : 1; /* RDT06            */
    uint16 RDT07 : 1; /* RDT07            */
    uint16 RDT08 : 1; /* RDT08            */
    uint16 RDT09 : 1; /* RDT09            */
    uint16 RDT10 : 1; /* RDT10            */
    uint16 RDT11 : 1; /* RDT11            */
    uint16 RDT12 : 1; /* RDT12            */
    uint16 RDT13 : 1; /* RDT13            */
    uint16 RDT14 : 1; /* RDT14            */
    uint16 RDT15 : 1; /* RDT15            */
} __type581;
typedef struct
{                           /* Bit Access       */
    const uint16 RSF00 : 1; /* RSF00            */
    const uint16 RSF01 : 1; /* RSF01            */
    const uint16 RSF02 : 1; /* RSF02            */
    const uint16 RSF03 : 1; /* RSF03            */
    const uint16 RSF04 : 1; /* RSF04            */
    const uint16 RSF05 : 1; /* RSF05            */
    const uint16 RSF06 : 1; /* RSF06            */
    const uint16 RSF07 : 1; /* RSF07            */
    const uint16 RSF08 : 1; /* RSF08            */
    const uint16 RSF09 : 1; /* RSF09            */
    const uint16 RSF10 : 1; /* RSF10            */
    const uint16 RSF11 : 1; /* RSF11            */
    const uint16 RSF12 : 1; /* RSF12            */
    const uint16 RSF13 : 1; /* RSF13            */
    const uint16 RSF14 : 1; /* RSF14            */
    const uint16 RSF15 : 1; /* RSF15            */
} __type582;
typedef struct
{                     /* Bit Access       */
    uint16 TDL00 : 1; /* TDL00            */
    uint16 TDL01 : 1; /* TDL01            */
    uint16 TDL02 : 1; /* TDL02            */
    uint16 TDL03 : 1; /* TDL03            */
    uint16 TDL04 : 1; /* TDL04            */
    uint16 TDL05 : 1; /* TDL05            */
    uint16 TDL06 : 1; /* TDL06            */
    uint16 TDL07 : 1; /* TDL07            */
    uint16 TDL08 : 1; /* TDL08            */
    uint16 TDL09 : 1; /* TDL09            */
    uint16 TDL10 : 1; /* TDL10            */
    uint16 TDL11 : 1; /* TDL11            */
    uint16 TDL12 : 1; /* TDL12            */
    uint16 TDL13 : 1; /* TDL13            */
    uint16 TDL14 : 1; /* TDL14            */
    uint16 TDL15 : 1; /* TDL15            */
} __type583;
typedef struct
{                    /* Bit Access       */
    uint16 TO00 : 1; /* TO00             */
    uint16 TO01 : 1; /* TO01             */
    uint16 TO02 : 1; /* TO02             */
    uint16 TO03 : 1; /* TO03             */
    uint16 TO04 : 1; /* TO04             */
    uint16 TO05 : 1; /* TO05             */
    uint16 TO06 : 1; /* TO06             */
    uint16 TO07 : 1; /* TO07             */
    uint16 TO08 : 1; /* TO08             */
    uint16 TO09 : 1; /* TO09             */
    uint16 TO10 : 1; /* TO10             */
    uint16 TO11 : 1; /* TO11             */
    uint16 TO12 : 1; /* TO12             */
    uint16 TO13 : 1; /* TO13             */
    uint16 TO14 : 1; /* TO14             */
    uint16 TO15 : 1; /* TO15             */
} __type584;
typedef struct
{                     /* Bit Access       */
    uint16 TOE00 : 1; /* TOE00            */
    uint16 TOE01 : 1; /* TOE01            */
    uint16 TOE02 : 1; /* TOE02            */
    uint16 TOE03 : 1; /* TOE03            */
    uint16 TOE04 : 1; /* TOE04            */
    uint16 TOE05 : 1; /* TOE05            */
    uint16 TOE06 : 1; /* TOE06            */
    uint16 TOE07 : 1; /* TOE07            */
    uint16 TOE08 : 1; /* TOE08            */
    uint16 TOE09 : 1; /* TOE09            */
    uint16 TOE10 : 1; /* TOE10            */
    uint16 TOE11 : 1; /* TOE11            */
    uint16 TOE12 : 1; /* TOE12            */
    uint16 TOE13 : 1; /* TOE13            */
    uint16 TOE14 : 1; /* TOE14            */
    uint16 TOE15 : 1; /* TOE15            */
} __type585;
typedef struct
{                  /* Bit Access       */
    uint8 TIS : 2; /* TIS[1:0]         */
    uint8     : 6; /* Reserved Bits    */
} __type586;
typedef struct
{                        /* Bit Access       */
    const uint8 OVF : 1; /* OVF              */
    const uint8 CSF : 1; /* CSF              */
    uint8           : 6; /* Reserved Bits    */
} __type587;
typedef struct
{                   /* Bit Access       */
    uint8 CLOV : 1; /* CLOV             */
    uint8      : 7; /* Reserved Bits    */
} __type588;
typedef struct
{                          /* Bit Access       */
    const uint16 TE00 : 1; /* TE00             */
    const uint16 TE01 : 1; /* TE01             */
    const uint16 TE02 : 1; /* TE02             */
    const uint16 TE03 : 1; /* TE03             */
    const uint16 TE04 : 1; /* TE04             */
    const uint16 TE05 : 1; /* TE05             */
    const uint16 TE06 : 1; /* TE06             */
    const uint16 TE07 : 1; /* TE07             */
    const uint16 TE08 : 1; /* TE08             */
    const uint16 TE09 : 1; /* TE09             */
    const uint16 TE10 : 1; /* TE10             */
    const uint16 TE11 : 1; /* TE11             */
    const uint16 TE12 : 1; /* TE12             */
    const uint16 TE13 : 1; /* TE13             */
    const uint16 TE14 : 1; /* TE14             */
    const uint16 TE15 : 1; /* TE15             */
} __type589;
typedef struct
{                    /* Bit Access       */
    uint16 TS00 : 1; /* TS00             */
    uint16 TS01 : 1; /* TS01             */
    uint16 TS02 : 1; /* TS02             */
    uint16 TS03 : 1; /* TS03             */
    uint16 TS04 : 1; /* TS04             */
    uint16 TS05 : 1; /* TS05             */
    uint16 TS06 : 1; /* TS06             */
    uint16 TS07 : 1; /* TS07             */
    uint16 TS08 : 1; /* TS08             */
    uint16 TS09 : 1; /* TS09             */
    uint16 TS10 : 1; /* TS10             */
    uint16 TS11 : 1; /* TS11             */
    uint16 TS12 : 1; /* TS12             */
    uint16 TS13 : 1; /* TS13             */
    uint16 TS14 : 1; /* TS14             */
    uint16 TS15 : 1; /* TS15             */
} __type590;
typedef struct
{                    /* Bit Access       */
    uint16 TT00 : 1; /* TT00             */
    uint16 TT01 : 1; /* TT01             */
    uint16 TT02 : 1; /* TT02             */
    uint16 TT03 : 1; /* TT03             */
    uint16 TT04 : 1; /* TT04             */
    uint16 TT05 : 1; /* TT05             */
    uint16 TT06 : 1; /* TT06             */
    uint16 TT07 : 1; /* TT07             */
    uint16 TT08 : 1; /* TT08             */
    uint16 TT09 : 1; /* TT09             */
    uint16 TT10 : 1; /* TT10             */
    uint16 TT11 : 1; /* TT11             */
    uint16 TT12 : 1; /* TT12             */
    uint16 TT13 : 1; /* TT13             */
    uint16 TT14 : 1; /* TT14             */
    uint16 TT15 : 1; /* TT15             */
} __type591;
typedef struct
{                    /* Bit Access       */
    uint16 MD   : 5; /* MD[4:0]          */
    uint16      : 1; /* Reserved Bits    */
    uint16 COS  : 2; /* COS[7:6]         */
    uint16 STS  : 3; /* STS[10:8]        */
    uint16 MAS  : 1; /* MAS              */
    uint16 CCS0 : 1; /* CCS0             */
    uint16      : 1; /* Reserved Bits    */
    uint16 CKS  : 2; /* CKS[15:14]       */
} __type592;
typedef struct
{                    /* Bit Access       */
    uint16 PRS0 : 4; /* PRS0[3:0]        */
    uint16 PRS1 : 4; /* PRS1[7:4]        */
    uint16 PRS2 : 4; /* PRS2[11:8]       */
    uint16 PRS3 : 4; /* PRS3[15:12]      */
} __type593;
typedef struct
{                     /* Bit Access       */
    uint16 TOM00 : 1; /* TOM00            */
    uint16 TOM01 : 1; /* TOM01            */
    uint16 TOM02 : 1; /* TOM02            */
    uint16 TOM03 : 1; /* TOM03            */
    uint16 TOM04 : 1; /* TOM04            */
    uint16 TOM05 : 1; /* TOM05            */
    uint16 TOM06 : 1; /* TOM06            */
    uint16 TOM07 : 1; /* TOM07            */
    uint16 TOM08 : 1; /* TOM08            */
    uint16 TOM09 : 1; /* TOM09            */
    uint16 TOM10 : 1; /* TOM10            */
    uint16 TOM11 : 1; /* TOM11            */
    uint16 TOM12 : 1; /* TOM12            */
    uint16 TOM13 : 1; /* TOM13            */
    uint16 TOM14 : 1; /* TOM14            */
    uint16 TOM15 : 1; /* TOM15            */
} __type594;
typedef struct
{                     /* Bit Access       */
    uint16 TOC00 : 1; /* TOC00            */
    uint16 TOC01 : 1; /* TOC01            */
    uint16 TOC02 : 1; /* TOC02            */
    uint16 TOC03 : 1; /* TOC03            */
    uint16 TOC04 : 1; /* TOC04            */
    uint16 TOC05 : 1; /* TOC05            */
    uint16 TOC06 : 1; /* TOC06            */
    uint16 TOC07 : 1; /* TOC07            */
    uint16 TOC08 : 1; /* TOC08            */
    uint16 TOC09 : 1; /* TOC09            */
    uint16 TOC10 : 1; /* TOC10            */
    uint16 TOC11 : 1; /* TOC11            */
    uint16 TOC12 : 1; /* TOC12            */
    uint16 TOC13 : 1; /* TOC13            */
    uint16 TOC14 : 1; /* TOC14            */
    uint16 TOC15 : 1; /* TOC15            */
} __type595;
typedef struct
{                     /* Bit Access       */
    uint16 TDE00 : 1; /* TDE00            */
    uint16 TDE01 : 1; /* TDE01            */
    uint16 TDE02 : 1; /* TDE02            */
    uint16 TDE03 : 1; /* TDE03            */
    uint16 TDE04 : 1; /* TDE04            */
    uint16 TDE05 : 1; /* TDE05            */
    uint16 TDE06 : 1; /* TDE06            */
    uint16 TDE07 : 1; /* TDE07            */
    uint16 TDE08 : 1; /* TDE08            */
    uint16 TDE09 : 1; /* TDE09            */
    uint16 TDE10 : 1; /* TDE10            */
    uint16 TDE11 : 1; /* TDE11            */
    uint16 TDE12 : 1; /* TDE12            */
    uint16 TDE13 : 1; /* TDE13            */
    uint16 TDE14 : 1; /* TDE14            */
    uint16 TDE15 : 1; /* TDE15            */
} __type596;
typedef struct
{                     /* Bit Access       */
    uint16 RDE00 : 1; /* RDE00            */
    uint16 RDE01 : 1; /* RDE01            */
    uint16 RDE02 : 1; /* RDE02            */
    uint16 RDE03 : 1; /* RDE03            */
    uint16 RDE04 : 1; /* RDE04            */
    uint16 RDE05 : 1; /* RDE05            */
    uint16 RDE06 : 1; /* RDE06            */
    uint16 RDE07 : 1; /* RDE07            */
    uint16 RDE08 : 1; /* RDE08            */
    uint16 RDE09 : 1; /* RDE09            */
    uint16 RDE10 : 1; /* RDE10            */
    uint16 RDE11 : 1; /* RDE11            */
    uint16 RDE12 : 1; /* RDE12            */
    uint16 RDE13 : 1; /* RDE13            */
    uint16 RDE14 : 1; /* RDE14            */
    uint16 RDE15 : 1; /* RDE15            */
} __type597;
typedef struct
{                     /* Bit Access       */
    uint16 RDM00 : 1; /* RDM00            */
    uint16 RDM01 : 1; /* RDM01            */
    uint16 RDM02 : 1; /* RDM02            */
    uint16 RDM03 : 1; /* RDM03            */
    uint16 RDM04 : 1; /* RDM04            */
    uint16 RDM05 : 1; /* RDM05            */
    uint16 RDM06 : 1; /* RDM06            */
    uint16 RDM07 : 1; /* RDM07            */
    uint16 RDM08 : 1; /* RDM08            */
    uint16 RDM09 : 1; /* RDM09            */
    uint16 RDM10 : 1; /* RDM10            */
    uint16 RDM11 : 1; /* RDM11            */
    uint16 RDM12 : 1; /* RDM12            */
    uint16 RDM13 : 1; /* RDM13            */
    uint16 RDM14 : 1; /* RDM14            */
    uint16 RDM15 : 1; /* RDM15            */
} __type598;
typedef struct
{                     /* Bit Access       */
    uint16 RDS00 : 1; /* RDS00            */
    uint16 RDS01 : 1; /* RDS01            */
    uint16 RDS02 : 1; /* RDS02            */
    uint16 RDS03 : 1; /* RDS03            */
    uint16 RDS04 : 1; /* RDS04            */
    uint16 RDS05 : 1; /* RDS05            */
    uint16 RDS06 : 1; /* RDS06            */
    uint16 RDS07 : 1; /* RDS07            */
    uint16 RDS08 : 1; /* RDS08            */
    uint16 RDS09 : 1; /* RDS09            */
    uint16 RDS10 : 1; /* RDS10            */
    uint16 RDS11 : 1; /* RDS11            */
    uint16 RDS12 : 1; /* RDS12            */
    uint16 RDS13 : 1; /* RDS13            */
    uint16 RDS14 : 1; /* RDS14            */
    uint16 RDS15 : 1; /* RDS15            */
} __type599;
typedef struct
{                     /* Bit Access       */
    uint16 RDC00 : 1; /* RDC00            */
    uint16 RDC01 : 1; /* RDC01            */
    uint16 RDC02 : 1; /* RDC02            */
    uint16 RDC03 : 1; /* RDC03            */
    uint16 RDC04 : 1; /* RDC04            */
    uint16 RDC05 : 1; /* RDC05            */
    uint16 RDC06 : 1; /* RDC06            */
    uint16 RDC07 : 1; /* RDC07            */
    uint16 RDC08 : 1; /* RDC08            */
    uint16 RDC09 : 1; /* RDC09            */
    uint16 RDC10 : 1; /* RDC10            */
    uint16 RDC11 : 1; /* RDC11            */
    uint16 RDC12 : 1; /* RDC12            */
    uint16 RDC13 : 1; /* RDC13            */
    uint16 RDC14 : 1; /* RDC14            */
    uint16 RDC15 : 1; /* RDC15            */
} __type600;
typedef struct
{                   /* Bit Access       */
    uint16 MD  : 5; /* MD[4:0]          */
    uint16     : 1; /* Reserved Bits    */
    uint16 COS : 2; /* COS[7:6]         */
    uint16 STS : 3; /* STS[10:8]        */
    uint16 MAS : 1; /* MAS              */
    uint16     : 2; /* Reserved Bits    */
    uint16 CKS : 2; /* CKS[15:14]       */
} __type601;
typedef struct
{                        /* Bit Access       */
    const uint8 OVF : 1; /* OVF              */
    uint8           : 6; /* Reserved Bits    */
    const uint8 RPF : 1; /* RPF              */
} __type602;
typedef struct
{                   /* Bit Access       */
    uint8      : 7; /* Reserved Bits    */
    uint8 CLRP : 1; /* CLRP             */
} __type603;
typedef struct
{                  /* Bit Access       */
    uint8 MD  : 2; /* MD[1:0]          */
    uint8     : 1; /* Reserved Bits    */
    uint8 TIS : 1; /* TIS              */
    uint8     : 3; /* Reserved Bits    */
    uint8 TE  : 1; /* TE               */
} __type604;
typedef struct
{                  /* Bit Access       */
    uint8 TOE : 1; /* TOE              */
    uint8     : 7; /* Reserved Bits    */
} __type605;
typedef struct
{                         /* Bit Access       */
    uint8            : 4; /* Reserved Bits    */
    uint8       SLSB : 1; /* SLSB             */
    uint8       AMPM : 1; /* AMPM             */
    const uint8 CEST : 1; /* CEST             */
    uint8       CE   : 1; /* CE               */
} __type606;
typedef struct
{                    /* Bit Access       */
    uint8 CT    : 3; /* CT[2:0]          */
    uint8 EN1S  : 1; /* EN1S             */
    uint8 ENALM : 1; /* ENALM            */
    uint8 EN1HZ : 1; /* EN1HZ            */
    uint8       : 2; /* Reserved Bits    */
} __type607;
typedef struct
{                         /* Bit Access       */
    uint8       WAIT : 1; /* WAIT             */
    const uint8 WST  : 1; /* WST              */
    uint8       RSUB : 1; /* RSUB             */
    const uint8 RSST : 1; /* RSST             */
    const uint8 WSST : 1; /* WSST             */
    const uint8 WUST : 1; /* WUST             */
    uint8            : 2; /* Reserved Bits    */
} __type608;
typedef struct
{                           /* Bit Access       */
    const uint32 SUBC : 22; /* SUBC[21:0]       */
    uint32            : 10; /* Reserved Bits    */
} __type609;
typedef struct
{                           /* Bit Access       */
    const uint32 SRBU : 22; /* SRBU[21:0]       */
    uint32            : 10; /* Reserved Bits    */
} __type610;
typedef struct
{                  /* Bit Access       */
    uint8 SEC : 7; /* SEC[6:0]         */
    uint8     : 1; /* Reserved Bits    */
} __type611;
typedef struct
{                  /* Bit Access       */
    uint8 MIN : 7; /* MIN[6:0]         */
    uint8     : 1; /* Reserved Bits    */
} __type612;
typedef struct
{                   /* Bit Access       */
    uint8 HOUR : 6; /* HOUR[5:0]        */
    uint8      : 2; /* Reserved Bits    */
} __type613;
typedef struct
{                   /* Bit Access       */
    uint8 WEEK : 3; /* WEEK[2:0]        */
    uint8      : 5; /* Reserved Bits    */
} __type614;
typedef struct
{                  /* Bit Access       */
    uint8 DAY : 6; /* DAY[5:0]         */
    uint8     : 2; /* Reserved Bits    */
} __type615;
typedef struct
{                    /* Bit Access       */
    uint8 MONTH : 5; /* MONTH[4:0]       */
    uint8       : 3; /* Reserved Bits    */
} __type616;
typedef struct
{                     /* Bit Access       */
    uint32 SEC  : 7;  /* SEC[6:0]         */
    uint32      : 1;  /* Reserved Bits    */
    uint32 MIN  : 7;  /* MIN[14:8]        */
    uint32      : 1;  /* Reserved Bits    */
    uint32 HOUR : 6;  /* HOUR[21:16]      */
    uint32      : 10; /* Reserved Bits    */
} __type617;
typedef struct
{                     /* Bit Access       */
    uint32 WEEK  : 3; /* WEEK[2:0]        */
    uint32       : 5; /* Reserved Bits    */
    uint32 DAY   : 6; /* DAY[13:8]        */
    uint32       : 2; /* Reserved Bits    */
    uint32 MONTH : 5; /* MONTH[20:16]     */
    uint32       : 3; /* Reserved Bits    */
    uint32 YEAR  : 8; /* YEAR[31:24]      */
} __type618;
typedef struct
{                  /* Bit Access       */
    uint8 F   : 6; /* F[5:0]           */
    uint8 F6  : 1; /* F6               */
    uint8 DEV : 1; /* DEV              */
} __type619;
typedef struct
{                     /* Bit Access       */
    uint32 SCMP : 22; /* SCMP[21:0]       */
    uint32      : 10; /* Reserved Bits    */
} __type620;
typedef struct
{                  /* Bit Access       */
    uint8 ALM : 7; /* ALM[6:0]         */
    uint8     : 1; /* Reserved Bits    */
} __type621;
typedef struct
{                  /* Bit Access       */
    uint8 ALH : 6; /* ALH[5:0]         */
    uint8     : 2; /* Reserved Bits    */
} __type622;
typedef struct
{                  /* Bit Access       */
    uint8 ALW : 7; /* ALW[6:0]         */
    uint8     : 1; /* Reserved Bits    */
} __type623;
typedef struct
{                         /* Bit Access       */
    const uint8 SECC : 7; /* SECC[6:0]        */
    uint8            : 1; /* Reserved Bits    */
} __type624;
typedef struct
{                         /* Bit Access       */
    const uint8 MINC : 7; /* MINC[6:0]        */
    uint8            : 1; /* Reserved Bits    */
} __type625;
typedef struct
{                          /* Bit Access       */
    const uint8 HOURC : 6; /* HOURC[5:0]       */
    uint8             : 2; /* Reserved Bits    */
} __type626;
typedef struct
{                          /* Bit Access       */
    const uint8 WEEKC : 3; /* WEEKC[2:0]       */
    uint8             : 5; /* Reserved Bits    */
} __type627;
typedef struct
{                         /* Bit Access       */
    const uint8 DAYC : 6; /* DAYC[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type628;
typedef struct
{                         /* Bit Access       */
    const uint8 MONC : 5; /* MONC[4:0]        */
    uint8            : 3; /* Reserved Bits    */
} __type629;
typedef struct
{                            /* Bit Access       */
    const uint32 SECC  : 7;  /* SECC[6:0]        */
    uint32             : 1;  /* Reserved Bits    */
    const uint32 MINC  : 7;  /* MINC[14:8]       */
    uint32             : 1;  /* Reserved Bits    */
    const uint32 HOURC : 6;  /* HOURC[21:16]     */
    uint32             : 10; /* Reserved Bits    */
} __type630;
typedef struct
{                           /* Bit Access       */
    const uint32 WEEKC : 3; /* WEEKC[2:0]       */
    uint32             : 5; /* Reserved Bits    */
    const uint32 DAYC  : 6; /* DAYC[13:8]       */
    uint32             : 2; /* Reserved Bits    */
    const uint32 MONC  : 5; /* MONC[20:16]      */
    uint32             : 3; /* Reserved Bits    */
    const uint32 YEARC : 8; /* YEARC[31:24]     */
} __type631;
typedef struct
{                     /* Bit Access       */
    uint16 CSDR : 12; /* CSDR[11:0]       */
    uint16      : 4;  /* Reserved Bits    */
} __type632;
typedef struct
{                     /* Bit Access       */
    uint16 CRDR : 13; /* CRDR[12:0]       */
    uint16      : 3;  /* Reserved Bits    */
} __type633;
typedef struct
{                     /* Bit Access       */
    uint16 CTDR : 12; /* CTDR[11:0]       */
    uint16      : 4;  /* Reserved Bits    */
} __type634;
typedef struct
{                  /* Bit Access       */
    uint8 RDT : 1; /* RDT              */
    uint8     : 7; /* Reserved Bits    */
} __type635;
typedef struct
{                        /* Bit Access       */
    const uint8 RSF : 1; /* RSF              */
    uint8           : 7; /* Reserved Bits    */
} __type636;
typedef struct
{                          /* Bit Access       */
    const uint16 CNT : 12; /* CNT[11:0]        */
    uint16           : 4;  /* Reserved Bits    */
} __type637;
typedef struct
{                  /* Bit Access       */
    uint8 CKS : 2; /* CKS[1:0]         */
    uint8     : 6; /* Reserved Bits    */
} __type638;
typedef struct
{                           /* Bit Access       */
    const uint16 CSBR : 12; /* CSBR[11:0]       */
    uint16            : 4;  /* Reserved Bits    */
} __type639;
typedef struct
{                           /* Bit Access       */
    const uint16 CRBR : 13; /* CRBR[12:0]       */
    uint16            : 3;  /* Reserved Bits    */
} __type640;
typedef struct
{                           /* Bit Access       */
    const uint16 CTBR : 12; /* CTBR[11:0]       */
    uint16            : 4;  /* Reserved Bits    */
} __type641;
typedef struct
{                     /* Bit Access       */
    uint16 BRS0 : 11; /* BRS0[10:0]       */
    uint16      : 5;  /* Reserved Bits    */
} __type642;
typedef struct
{                     /* Bit Access       */
    uint16 BRS1 : 11; /* BRS1[10:0]       */
    uint16      : 5;  /* Reserved Bits    */
} __type643;
typedef struct
{                     /* Bit Access       */
    uint16 BRS2 : 11; /* BRS2[10:0]       */
    uint16      : 5;  /* Reserved Bits    */
} __type644;
typedef struct
{                     /* Bit Access       */
    uint16 BRS3 : 11; /* BRS3[10:0]       */
    uint16      : 5;  /* Reserved Bits    */
} __type645;
typedef struct
{                        /* Bit Access       */
    const uint8 TE0 : 1; /* TE0              */
    const uint8 TE1 : 1; /* TE1              */
    const uint8 TE2 : 1; /* TE2              */
    const uint8 TE3 : 1; /* TE3              */
    uint8           : 4; /* Reserved Bits    */
} __type646;
typedef struct
{                  /* Bit Access       */
    uint8 TS0 : 1; /* TS0              */
    uint8 TS1 : 1; /* TS1              */
    uint8 TS2 : 1; /* TS2              */
    uint8 TS3 : 1; /* TS3              */
    uint8     : 4; /* Reserved Bits    */
} __type647;
typedef struct
{                  /* Bit Access       */
    uint8 TT0 : 1; /* TT0              */
    uint8 TT1 : 1; /* TT1              */
    uint8 TT2 : 1; /* TT2              */
    uint8 TT3 : 1; /* TT3              */
    uint8     : 4; /* Reserved Bits    */
} __type648;
typedef struct
{                   /* Bit Access       */
    uint8 ENBL : 1; /* ENBL             */
    uint8      : 7; /* Reserved Bits    */
} __type649;
typedef struct
{                        /* Bit Access       */
    const uint8 QNE : 1; /* QNE              */
    const uint8 QFL : 1; /* QFL              */
    uint8           : 6; /* Reserved Bits    */
} __type650;
typedef struct
{                   /* Bit Access       */
    uint8 CLNE : 1; /* CLNE             */
    uint8 CLFL : 1; /* CLFL             */
    uint8      : 6; /* Reserved Bits    */
} __type651;
typedef struct
{                     /* Bit Access       */
    uint8 SVSDIS : 1; /* SVSDIS           */
    uint8        : 7; /* Reserved Bits    */
} __type652;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE0 : 6; /* QUE0[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type653;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE1 : 6; /* QUE1[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type654;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE2 : 6; /* QUE2[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type655;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE3 : 6; /* QUE3[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type656;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE4 : 6; /* QUE4[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type657;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE5 : 6; /* QUE5[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type658;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE6 : 6; /* QUE6[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type659;
typedef struct
{                         /* Bit Access       */
    const uint8 QUE7 : 6; /* QUE7[5:0]        */
    uint8            : 2; /* Reserved Bits    */
} __type660;
typedef struct
{                      /* Bit Access       */
    uint32 VRDT00 : 8; /* VRDT00[7:0]      */
    uint32        : 8; /* Reserved Bits    */
    uint32 VRDT01 : 8; /* VRDT01[23:16]    */
    uint32        : 8; /* Reserved Bits    */
} __type661;
typedef struct
{                      /* Bit Access       */
    uint32 VRDT02 : 8; /* VRDT02[7:0]      */
    uint32        : 8; /* Reserved Bits    */
    uint32 VRDT03 : 8; /* VRDT03[23:16]    */
    uint32        : 8; /* Reserved Bits    */
} __type662;
typedef struct
{                      /* Bit Access       */
    uint32 VRDT04 : 8; /* VRDT04[7:0]      */
    uint32        : 8; /* Reserved Bits    */
    uint32 VRDT05 : 8; /* VRDT05[23:16]    */
    uint32        : 8; /* Reserved Bits    */
} __type663;
typedef struct
{                      /* Bit Access       */
    uint32 VRDT06 : 8; /* VRDT06[7:0]      */
    uint32        : 8; /* Reserved Bits    */
    uint32 VRDT07 : 8; /* VRDT07[23:16]    */
    uint32        : 8; /* Reserved Bits    */
} __type664;
typedef struct
{                      /* Bit Access       */
    uint32 VRDT08 : 8; /* VRDT08[7:0]      */
    uint32        : 8; /* Reserved Bits    */
    uint32 VRDT09 : 8; /* VRDT09[23:16]    */
    uint32        : 8; /* Reserved Bits    */
} __type665;
typedef struct
{                      /* Bit Access       */
    uint32 VRDT10 : 8; /* VRDT10[7:0]      */
    uint32        : 8; /* Reserved Bits    */
    uint32 VRDT11 : 8; /* VRDT11[23:16]    */
    uint32        : 8; /* Reserved Bits    */
} __type666;
typedef struct
{                        /* Bit Access       */
    const uint8 OVF : 1; /* OVF              */
    uint8           : 7; /* Reserved Bits    */
} __type667;
typedef struct
{                         /* Bit Access       */
    const uint8 TE00 : 1; /* TE00             */
    const uint8 TE01 : 1; /* TE01             */
    const uint8 TE02 : 1; /* TE02             */
    const uint8 TE03 : 1; /* TE03             */
    uint8            : 4; /* Reserved Bits    */
} __type668;
typedef struct
{                   /* Bit Access       */
    uint8 TS00 : 1; /* TS00             */
    uint8 TS01 : 1; /* TS01             */
    uint8 TS02 : 1; /* TS02             */
    uint8 TS03 : 1; /* TS03             */
    uint8      : 4; /* Reserved Bits    */
} __type669;
typedef struct
{                   /* Bit Access       */
    uint8 TT00 : 1; /* TT00             */
    uint8 TT01 : 1; /* TT01             */
    uint8 TT02 : 1; /* TT02             */
    uint8 TT03 : 1; /* TT03             */
    uint8      : 4; /* Reserved Bits    */
} __type670;
typedef struct
{                   /* Bit Access       */
    uint8 TO00 : 1; /* TO00             */
    uint8 TO01 : 1; /* TO01             */
    uint8 TO02 : 1; /* TO02             */
    uint8 TO03 : 1; /* TO03             */
    uint8      : 4; /* Reserved Bits    */
} __type671;
typedef struct
{                    /* Bit Access       */
    uint8 TOE00 : 1; /* TOE00            */
    uint8 TOE01 : 1; /* TOE01            */
    uint8 TOE02 : 1; /* TOE02            */
    uint8 TOE03 : 1; /* TOE03            */
    uint8       : 4; /* Reserved Bits    */
} __type672;
typedef struct
{                    /* Bit Access       */
    uint8 TOL00 : 1; /* TOL00            */
    uint8 TOL01 : 1; /* TOL01            */
    uint8 TOL02 : 1; /* TOL02            */
    uint8 TOL03 : 1; /* TOL03            */
    uint8       : 4; /* Reserved Bits    */
} __type673;
typedef struct
{                    /* Bit Access       */
    uint8 RDT00 : 1; /* RDT00            */
    uint8 RDT01 : 1; /* RDT01            */
    uint8 RDT02 : 1; /* RDT02            */
    uint8 RDT03 : 1; /* RDT03            */
    uint8       : 4; /* Reserved Bits    */
} __type674;
typedef struct
{                          /* Bit Access       */
    const uint8 RSF00 : 1; /* RSF00            */
    const uint8 RSF01 : 1; /* RSF01            */
    const uint8 RSF02 : 1; /* RSF02            */
    const uint8 RSF03 : 1; /* RSF03            */
    uint8             : 4; /* Reserved Bits    */
} __type675;
typedef struct
{                   /* Bit Access       */
    uint16 MD  : 5; /* MD[4:0]          */
    uint16     : 1; /* Reserved Bits    */
    uint16 COS : 2; /* COS[7:6]         */
    uint16 STS : 3; /* STS[10:8]        */
    uint16 MAS : 1; /* MAS              */
    uint16 CCS : 2; /* CCS[13:12]       */
    uint16 CKS : 2; /* CKS[15:14]       */
} __type676;
typedef struct
{                    /* Bit Access       */
    uint8 TOM00 : 1; /* TOM00            */
    uint8 TOM01 : 1; /* TOM01            */
    uint8 TOM02 : 1; /* TOM02            */
    uint8 TOM03 : 1; /* TOM03            */
    uint8       : 4; /* Reserved Bits    */
} __type677;
typedef struct
{                    /* Bit Access       */
    uint8 TOC00 : 1; /* TOC00            */
    uint8 TOC01 : 1; /* TOC01            */
    uint8 TOC02 : 1; /* TOC02            */
    uint8 TOC03 : 1; /* TOC03            */
    uint8       : 4; /* Reserved Bits    */
} __type678;
typedef struct
{                    /* Bit Access       */
    uint8 RDE00 : 1; /* RDE00            */
    uint8 RDE01 : 1; /* RDE01            */
    uint8 RDE02 : 1; /* RDE02            */
    uint8 RDE03 : 1; /* RDE03            */
    uint8       : 4; /* Reserved Bits    */
} __type679;
typedef struct
{                    /* Bit Access       */
    uint8 RDM00 : 1; /* RDM00            */
    uint8 RDM01 : 1; /* RDM01            */
    uint8 RDM02 : 1; /* RDM02            */
    uint8 RDM03 : 1; /* RDM03            */
    uint8       : 4; /* Reserved Bits    */
} __type680;
typedef struct
{                 /* Bit Access       */
    uint8 TO : 1; /* TO               */
    uint8    : 7; /* Reserved Bits    */
} __type681;
typedef struct
{                       /* Bit Access       */
    const uint8 TE : 1; /* TE               */
    uint8          : 7; /* Reserved Bits    */
} __type682;
typedef struct
{                 /* Bit Access       */
    uint8 TS : 1; /* TS               */
    uint8    : 7; /* Reserved Bits    */
} __type683;
typedef struct
{                 /* Bit Access       */
    uint8 TT : 1; /* TT               */
    uint8    : 7; /* Reserved Bits    */
} __type684;
typedef struct
{                  /* Bit Access       */
    uint8 MD0 : 1; /* MD0              */
    uint8 MD1 : 1; /* MD1              */
    uint8     : 6; /* Reserved Bits    */
} __type685;
typedef struct
{                  /* Bit Access       */
    uint8 RUN : 8; /* RUN[7:0]         */
} __type686;
typedef struct
{                  /* Bit Access       */
    uint8 WS  : 2; /* WS[1:0]          */
    uint8 ERM : 1; /* ERM              */
    uint8 WIE : 1; /* WIE              */
    uint8 OVF : 3; /* OVF[6:4]         */
    uint8     : 1; /* Reserved Bits    */
} __type687;
typedef struct
{                     /* Bit Access       */
    uint32 ZPDU  : 1; /* ZPDU             */
    uint32       : 7; /* Reserved Bits    */
    uint32 GGCE  : 1; /* GGCE             */
    uint32       : 7; /* Reserved Bits    */
    uint32 GGEN  : 1; /* GGEN             */
    uint32       : 7; /* Reserved Bits    */
    uint32 GIERE : 6; /* GIERE[29:24]     */
    uint32 GIEDO : 1; /* GIEDO            */
    uint32 GIEAD : 1; /* GIEAD            */
} __type688;
typedef struct
{                           /* Bit Access       */
    uint32 CCEN       : 6;  /* CCEN[5:0]        */
    uint32            : 1;  /* Reserved Bits    */
    const uint32 GGCB : 1;  /* GGCB             */
    uint32            : 24; /* Reserved Bits    */
} __type689;
typedef struct
{                     /* Bit Access       */
    uint32 GGUD : 8;  /* GGUD[7:0]        */
    uint32      : 8;  /* Reserved Bits    */
    uint32 GGTB : 4;  /* GGTB[19:16]      */
    uint32      : 12; /* Reserved Bits    */
} __type690;
typedef struct
{                           /* Bit Access       */
    const uint32 GGTR : 10; /* GGTR[9:0]        */
    uint32            : 22; /* Reserved Bits    */
} __type691;
typedef struct
{                     /* Bit Access       */
    uint32 GGCS  : 3; /* GGCS[2:0]        */
    uint32 GGZF  : 4; /* GGZF[6:3]        */
    uint32       : 1; /* Reserved Bits    */
    uint32 GGRV1 : 4; /* GGRV1[11:8]      */
    uint32 GGRV2 : 4; /* GGRV2[15:12]     */
    uint32 GGFD  : 4; /* GGFD[19:16]      */
    uint32 GGFL  : 4; /* GGFL[23:20]      */
    uint32       : 6; /* Reserved Bits    */
    uint32 GGZP  : 1; /* GGZP             */
    uint32 GGZE  : 1; /* GGZE             */
} __type692;
typedef struct
{                              /* Bit Access       */
    const uint32 GIPSSRE : 6;  /* GIPSSRE[5:0]     */
    const uint32 GIPSSDO : 1;  /* GIPSSDO          */
    const uint32 GIPSSAD : 1;  /* GIPSSAD          */
    uint32               : 24; /* Reserved Bits    */
} __type693;
typedef struct
{                        /* Bit Access       */
    uint32 GIPCLRE : 6;  /* GIPCLRE[5:0]     */
    uint32 GIPCLDO : 1;  /* GIPCLDO          */
    uint32 GIPCLAD : 1;  /* GIPCLAD          */
    uint32         : 24; /* Reserved Bits    */
} __type694;
typedef struct
{                     /* Bit Access       */
    uint32 CCCT0 : 3; /* CCCT0[2:0]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CCCP0 : 1; /* CCCP0            */
    uint32 CCZP0 : 1; /* CCZP0            */
    uint32       : 1; /* Reserved Bits    */
    uint32 CCDH0 : 4; /* CCDH0[11:8]      */
    uint32 CCDV0 : 4; /* CCDV0[15:12]     */
    uint32 CCTL0 : 7; /* CCTL0[22:16]     */
    uint32       : 9; /* Reserved Bits    */
} __type695;
typedef struct
{                     /* Bit Access       */
    uint32 CCCT1 : 3; /* CCCT1[2:0]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CCCP1 : 1; /* CCCP1            */
    uint32 CCZP1 : 1; /* CCZP1            */
    uint32       : 1; /* Reserved Bits    */
    uint32 CCDH1 : 4; /* CCDH1[11:8]      */
    uint32 CCDV1 : 4; /* CCDV1[15:12]     */
    uint32 CCTL1 : 7; /* CCTL1[22:16]     */
    uint32       : 9; /* Reserved Bits    */
} __type696;
typedef struct
{                     /* Bit Access       */
    uint32 CCCT2 : 3; /* CCCT2[2:0]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CCCP2 : 1; /* CCCP2            */
    uint32 CCZP2 : 1; /* CCZP2            */
    uint32       : 1; /* Reserved Bits    */
    uint32 CCDH2 : 4; /* CCDH2[11:8]      */
    uint32 CCDV2 : 4; /* CCDV2[15:12]     */
    uint32 CCTL2 : 7; /* CCTL2[22:16]     */
    uint32       : 9; /* Reserved Bits    */
} __type697;
typedef struct
{                     /* Bit Access       */
    uint32 CCCT3 : 3; /* CCCT3[2:0]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CCCP3 : 1; /* CCCP3            */
    uint32 CCZP3 : 1; /* CCZP3            */
    uint32       : 1; /* Reserved Bits    */
    uint32 CCDH3 : 4; /* CCDH3[11:8]      */
    uint32 CCDV3 : 4; /* CCDV3[15:12]     */
    uint32 CCTL3 : 7; /* CCTL3[22:16]     */
    uint32       : 9; /* Reserved Bits    */
} __type698;
typedef struct
{                     /* Bit Access       */
    uint32 CCCT4 : 3; /* CCCT4[2:0]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CCCP4 : 1; /* CCCP4            */
    uint32 CCZP4 : 1; /* CCZP4            */
    uint32       : 1; /* Reserved Bits    */
    uint32 CCDH4 : 4; /* CCDH4[11:8]      */
    uint32 CCDV4 : 4; /* CCDV4[15:12]     */
    uint32 CCTL4 : 7; /* CCTL4[22:16]     */
    uint32       : 9; /* Reserved Bits    */
} __type699;
typedef struct
{                     /* Bit Access       */
    uint32 CCCT5 : 3; /* CCCT5[2:0]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CCCP5 : 1; /* CCCP5            */
    uint32 CCZP5 : 1; /* CCZP5            */
    uint32       : 1; /* Reserved Bits    */
    uint32 CCDH5 : 4; /* CCDH5[11:8]      */
    uint32 CCDV5 : 4; /* CCDV5[15:12]     */
    uint32 CCTL5 : 7; /* CCTL5[22:16]     */
    uint32       : 9; /* Reserved Bits    */
} __type700;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZC0 : 7;  /* CCZC0[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type701;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZC1 : 7;  /* CCZC1[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type702;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZC2 : 7;  /* CCZC2[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type703;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZC3 : 7;  /* CCZC3[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type704;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZC4 : 7;  /* CCZC4[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type705;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZC5 : 7;  /* CCZC5[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type706;
typedef struct
{                      /* Bit Access       */
    uint32 CCVP0 : 10; /* CCVP0[9:0]       */
    uint32 CCHP0 : 10; /* CCHP0[19:10]     */
    uint32 CCQI0 : 2;  /* CCQI0[21:20]     */
    uint32       : 10; /* Reserved Bits    */
} __type707;
typedef struct
{                      /* Bit Access       */
    uint32 CCVP1 : 10; /* CCVP1[9:0]       */
    uint32 CCHP1 : 10; /* CCHP1[19:10]     */
    uint32 CCQI1 : 2;  /* CCQI1[21:20]     */
    uint32       : 10; /* Reserved Bits    */
} __type708;
typedef struct
{                      /* Bit Access       */
    uint32 CCVP2 : 10; /* CCVP2[9:0]       */
    uint32 CCHP2 : 10; /* CCHP2[19:10]     */
    uint32 CCQI2 : 2;  /* CCQI2[21:20]     */
    uint32       : 10; /* Reserved Bits    */
} __type709;
typedef struct
{                      /* Bit Access       */
    uint32 CCVP3 : 10; /* CCVP3[9:0]       */
    uint32 CCHP3 : 10; /* CCHP3[19:10]     */
    uint32 CCQI3 : 2;  /* CCQI3[21:20]     */
    uint32       : 10; /* Reserved Bits    */
} __type710;
typedef struct
{                      /* Bit Access       */
    uint32 CCVP4 : 10; /* CCVP4[9:0]       */
    uint32 CCHP4 : 10; /* CCHP4[19:10]     */
    uint32 CCQI4 : 2;  /* CCQI4[21:20]     */
    uint32       : 10; /* Reserved Bits    */
} __type711;
typedef struct
{                      /* Bit Access       */
    uint32 CCVP5 : 10; /* CCVP5[9:0]       */
    uint32 CCHP5 : 10; /* CCHP5[19:10]     */
    uint32 CCQI5 : 2;  /* CCQI5[21:20]     */
    uint32       : 10; /* Reserved Bits    */
} __type712;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZD0 : 5;  /* CCZD0[4:0]       */
    uint32             : 27; /* Reserved Bits    */
} __type713;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZD1 : 5;  /* CCZD1[4:0]       */
    uint32             : 27; /* Reserved Bits    */
} __type714;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZD2 : 5;  /* CCZD2[4:0]       */
    uint32             : 27; /* Reserved Bits    */
} __type715;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZD3 : 5;  /* CCZD3[4:0]       */
    uint32             : 27; /* Reserved Bits    */
} __type716;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZD4 : 5;  /* CCZD4[4:0]       */
    uint32             : 27; /* Reserved Bits    */
} __type717;
typedef struct
{                            /* Bit Access       */
    const uint32 CCZD5 : 5;  /* CCZD5[4:0]       */
    uint32             : 27; /* Reserved Bits    */
} __type718;
typedef struct
{                     /* Bit Access       */
    uint32 CIVD0 : 4; /* CIVD0[3:0]       */
    uint32       : 6; /* Reserved Bits    */
    uint32 CIHD0 : 4; /* CIHD0[13:10]     */
    uint32       : 8; /* Reserved Bits    */
    uint32 CIVR0 : 1; /* CIVR0            */
    uint32 CIHR0 : 1; /* CIHR0            */
    uint32 CIVE0 : 1; /* CIVE0            */
    uint32 CIHE0 : 1; /* CIHE0            */
    uint32       : 6; /* Reserved Bits    */
} __type719;
typedef struct
{                     /* Bit Access       */
    uint32 CIVD1 : 4; /* CIVD1[3:0]       */
    uint32       : 6; /* Reserved Bits    */
    uint32 CIHD1 : 4; /* CIHD1[13:10]     */
    uint32       : 8; /* Reserved Bits    */
    uint32 CIVR1 : 1; /* CIVR1            */
    uint32 CIHR1 : 1; /* CIHR1            */
    uint32 CIVE1 : 1; /* CIVE1            */
    uint32 CIHE1 : 1; /* CIHE1            */
    uint32       : 6; /* Reserved Bits    */
} __type720;
typedef struct
{                     /* Bit Access       */
    uint32 CIVD2 : 4; /* CIVD2[3:0]       */
    uint32       : 6; /* Reserved Bits    */
    uint32 CIHD2 : 4; /* CIHD2[13:10]     */
    uint32       : 8; /* Reserved Bits    */
    uint32 CIVR2 : 1; /* CIVR2            */
    uint32 CIHR2 : 1; /* CIHR2            */
    uint32 CIVE2 : 1; /* CIVE2            */
    uint32 CIHE2 : 1; /* CIHE2            */
    uint32       : 6; /* Reserved Bits    */
} __type721;
typedef struct
{                     /* Bit Access       */
    uint32 CIVD3 : 4; /* CIVD3[3:0]       */
    uint32       : 6; /* Reserved Bits    */
    uint32 CIHD3 : 4; /* CIHD3[13:10]     */
    uint32       : 8; /* Reserved Bits    */
    uint32 CIVR3 : 1; /* CIVR3            */
    uint32 CIHR3 : 1; /* CIHR3            */
    uint32 CIVE3 : 1; /* CIVE3            */
    uint32 CIHE3 : 1; /* CIHE3            */
    uint32       : 6; /* Reserved Bits    */
} __type722;
typedef struct
{                     /* Bit Access       */
    uint32 CIVD4 : 4; /* CIVD4[3:0]       */
    uint32       : 6; /* Reserved Bits    */
    uint32 CIHD4 : 4; /* CIHD4[13:10]     */
    uint32       : 8; /* Reserved Bits    */
    uint32 CIVR4 : 1; /* CIVR4            */
    uint32 CIHR4 : 1; /* CIHR4            */
    uint32 CIVE4 : 1; /* CIVE4            */
    uint32 CIHE4 : 1; /* CIHE4            */
    uint32       : 6; /* Reserved Bits    */
} __type723;
typedef struct
{                     /* Bit Access       */
    uint32 CIVD5 : 4; /* CIVD5[3:0]       */
    uint32       : 6; /* Reserved Bits    */
    uint32 CIHD5 : 4; /* CIHD5[13:10]     */
    uint32       : 8; /* Reserved Bits    */
    uint32 CIVR5 : 1; /* CIVR5            */
    uint32 CIHR5 : 1; /* CIHR5            */
    uint32 CIVE5 : 1; /* CIVE5            */
    uint32 CIHE5 : 1; /* CIHE5            */
    uint32       : 6; /* Reserved Bits    */
} __type724;
typedef struct
{                     /* Bit Access       */
    uint32 CIRS : 6;  /* CIRS[5:0]        */
    uint32      : 26; /* Reserved Bits    */
} __type725;
typedef struct
{                     /* Bit Access       */
    uint32 CZMT  : 6; /* CZMT[5:0]        */
    uint32       : 2; /* Reserved Bits    */
    uint32 CZIS0 : 2; /* CZIS0[9:8]       */
    uint32       : 2; /* Reserved Bits    */
    uint32 CZIS1 : 2; /* CZIS1[13:12]     */
    uint32       : 2; /* Reserved Bits    */
    uint32 CZIS2 : 2; /* CZIS2[17:16]     */
    uint32       : 2; /* Reserved Bits    */
    uint32 CZIS3 : 2; /* CZIS3[21:20]     */
    uint32       : 2; /* Reserved Bits    */
    uint32 CZIS4 : 2; /* CZIS4[25:24]     */
    uint32       : 2; /* Reserved Bits    */
    uint32 CZIS5 : 2; /* CZIS5[29:28]     */
    uint32       : 2; /* Reserved Bits    */
} __type726;
typedef struct
{                     /* Bit Access       */
    uint32 CZRS : 6;  /* CZRS[5:0]        */
    uint32      : 26; /* Reserved Bits    */
} __type727;
typedef struct
{                           /* Bit Access       */
    const uint32 CZDR : 6;  /* CZDR[5:0]        */
    uint32            : 26; /* Reserved Bits    */
} __type728;
typedef struct
{                           /* Bit Access       */
    const uint32 CZIP : 6;  /* CZIP[5:0]        */
    uint32            : 26; /* Reserved Bits    */
} __type729;
typedef struct
{                      /* Bit Access       */
    uint32 CCLZP : 6;  /* CCLZP[5:0]       */
    uint32       : 26; /* Reserved Bits    */
} __type730;
typedef struct
{                      /* Bit Access       */
    uint32 CZBT0 : 16; /* CZBT0[15:0]      */
    uint32       : 15; /* Reserved Bits    */
    uint32 CZSS0 : 1;  /* CZSS0            */
} __type731;
typedef struct
{                      /* Bit Access       */
    uint32 CZBT1 : 16; /* CZBT1[15:0]      */
    uint32       : 15; /* Reserved Bits    */
    uint32 CZSS1 : 1;  /* CZSS1            */
} __type732;
typedef struct
{                      /* Bit Access       */
    uint32 CZBT2 : 16; /* CZBT2[15:0]      */
    uint32       : 15; /* Reserved Bits    */
    uint32 CZSS2 : 1;  /* CZSS2            */
} __type733;
typedef struct
{                      /* Bit Access       */
    uint32 CZBT3 : 16; /* CZBT3[15:0]      */
    uint32       : 15; /* Reserved Bits    */
    uint32 CZSS3 : 1;  /* CZSS3            */
} __type734;
typedef struct
{                      /* Bit Access       */
    uint32 CZBT4 : 16; /* CZBT4[15:0]      */
    uint32       : 15; /* Reserved Bits    */
    uint32 CZSS4 : 1;  /* CZSS4            */
} __type735;
typedef struct
{                      /* Bit Access       */
    uint32 CZBT5 : 16; /* CZBT5[15:0]      */
    uint32       : 15; /* Reserved Bits    */
    uint32 CZSS5 : 1;  /* CZSS5            */
} __type736;
typedef struct
{                            /* Bit Access       */
    const uint32 CZAF0 : 1;  /* CZAF0            */
    const uint32 CZAF1 : 1;  /* CZAF1            */
    const uint32 CZAF2 : 1;  /* CZAF2            */
    const uint32 CZAF3 : 1;  /* CZAF3            */
    const uint32 CZAF4 : 1;  /* CZAF4            */
    const uint32 CZAF5 : 1;  /* CZAF5            */
    uint32             : 26; /* Reserved Bits    */
} __type737;
typedef struct
{                      /* Bit Access       */
    uint32 FPMP0 : 8;  /* FPMP0[7:0]       */
    uint32 IPMP0 : 16; /* IPMP0[23:8]      */
    uint32 SPMP0 : 1;  /* SPMP0            */
    uint32       : 7;  /* Reserved Bits    */
} __type738;
typedef struct
{                      /* Bit Access       */
    uint32 FPDF0 : 3;  /* FPDF0[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type739;
typedef struct
{                      /* Bit Access       */
    uint32 FPAL0 : 8;  /* FPAL0[7:0]       */
    uint32 IPAL0 : 16; /* IPAL0[23:8]      */
    uint32 SPAL0 : 1;  /* SPAL0            */
    uint32       : 7;  /* Reserved Bits    */
} __type740;
typedef struct
{                      /* Bit Access       */
    uint32 FPDL0 : 8;  /* FPDL0[7:0]       */
    uint32 IPDL0 : 16; /* IPDL0[23:8]      */
    uint32 SPDL0 : 1;  /* SPDL0            */
    uint32       : 7;  /* Reserved Bits    */
} __type741;
typedef struct
{                      /* Bit Access       */
    uint32 FPMS0 : 8;  /* FPMS0[7:0]       */
    uint32 IPMS0 : 16; /* IPMS0[23:8]      */
    uint32 SPMS0 : 1;  /* SPMS0            */
    uint32       : 7;  /* Reserved Bits    */
} __type742;
typedef struct
{                      /* Bit Access       */
    uint32 FPHC0 : 8;  /* FPHC0[7:0]       */
    uint32 IPHC0 : 16; /* IPHC0[23:8]      */
    uint32 SPHC0 : 1;  /* SPHC0            */
    uint32       : 7;  /* Reserved Bits    */
} __type743;
typedef struct
{                      /* Bit Access       */
    uint32 FPS10 : 8;  /* FPS10[7:0]       */
    uint32 IPS10 : 16; /* IPS10[23:8]      */
    uint32 SPS10 : 1;  /* SPS10            */
    uint32       : 7;  /* Reserved Bits    */
} __type744;
typedef struct
{                      /* Bit Access       */
    uint32 FPS20 : 8;  /* FPS20[7:0]       */
    uint32 IPS20 : 16; /* IPS20[23:8]      */
    uint32 SPS20 : 1;  /* SPS20            */
    uint32       : 7;  /* Reserved Bits    */
} __type745;
typedef struct
{                      /* Bit Access       */
    uint32 FPS30 : 8;  /* FPS30[7:0]       */
    uint32 IPS30 : 16; /* IPS30[23:8]      */
    uint32 SPS30 : 1;  /* SPS30            */
    uint32       : 7;  /* Reserved Bits    */
} __type746;
typedef struct
{                      /* Bit Access       */
    uint32 FPS40 : 8;  /* FPS40[7:0]       */
    uint32 IPS40 : 16; /* IPS40[23:8]      */
    uint32 SPS40 : 1;  /* SPS40            */
    uint32       : 7;  /* Reserved Bits    */
} __type747;
typedef struct
{                      /* Bit Access       */
    uint32 FPMP1 : 8;  /* FPMP1[7:0]       */
    uint32 IPMP1 : 16; /* IPMP1[23:8]      */
    uint32 SPMP1 : 1;  /* SPMP1            */
    uint32       : 7;  /* Reserved Bits    */
} __type748;
typedef struct
{                      /* Bit Access       */
    uint32 FPDF1 : 3;  /* FPDF1[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type749;
typedef struct
{                      /* Bit Access       */
    uint32 FPAL1 : 8;  /* FPAL1[7:0]       */
    uint32 IPAL1 : 16; /* IPAL1[23:8]      */
    uint32 SPAL1 : 1;  /* SPAL1            */
    uint32       : 7;  /* Reserved Bits    */
} __type750;
typedef struct
{                      /* Bit Access       */
    uint32 FPDL1 : 8;  /* FPDL1[7:0]       */
    uint32 IPDL1 : 16; /* IPDL1[23:8]      */
    uint32 SPDL1 : 1;  /* SPDL1            */
    uint32       : 7;  /* Reserved Bits    */
} __type751;
typedef struct
{                      /* Bit Access       */
    uint32 FPMS1 : 8;  /* FPMS1[7:0]       */
    uint32 IPMS1 : 16; /* IPMS1[23:8]      */
    uint32 SPMS1 : 1;  /* SPMS1            */
    uint32       : 7;  /* Reserved Bits    */
} __type752;
typedef struct
{                      /* Bit Access       */
    uint32 FPHC1 : 8;  /* FPHC1[7:0]       */
    uint32 IPHC1 : 16; /* IPHC1[23:8]      */
    uint32 SPHC1 : 1;  /* SPHC1            */
    uint32       : 7;  /* Reserved Bits    */
} __type753;
typedef struct
{                      /* Bit Access       */
    uint32 FPS11 : 8;  /* FPS11[7:0]       */
    uint32 IPS11 : 16; /* IPS11[23:8]      */
    uint32 SPS11 : 1;  /* SPS11            */
    uint32       : 7;  /* Reserved Bits    */
} __type754;
typedef struct
{                      /* Bit Access       */
    uint32 FPS21 : 8;  /* FPS21[7:0]       */
    uint32 IPS21 : 16; /* IPS21[23:8]      */
    uint32 SPS21 : 1;  /* SPS21            */
    uint32       : 7;  /* Reserved Bits    */
} __type755;
typedef struct
{                      /* Bit Access       */
    uint32 FPS31 : 8;  /* FPS31[7:0]       */
    uint32 IPS31 : 16; /* IPS31[23:8]      */
    uint32 SPS31 : 1;  /* SPS31            */
    uint32       : 7;  /* Reserved Bits    */
} __type756;
typedef struct
{                      /* Bit Access       */
    uint32 FPS41 : 8;  /* FPS41[7:0]       */
    uint32 IPS41 : 16; /* IPS41[23:8]      */
    uint32 SPS41 : 1;  /* SPS41            */
    uint32       : 7;  /* Reserved Bits    */
} __type757;
typedef struct
{                      /* Bit Access       */
    uint32 FPMP2 : 8;  /* FPMP2[7:0]       */
    uint32 IPMP2 : 16; /* IPMP2[23:8]      */
    uint32 SPMP2 : 1;  /* SPMP2            */
    uint32       : 7;  /* Reserved Bits    */
} __type758;
typedef struct
{                      /* Bit Access       */
    uint32 FPDF2 : 3;  /* FPDF2[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type759;
typedef struct
{                      /* Bit Access       */
    uint32 FPAL2 : 8;  /* FPAL2[7:0]       */
    uint32 IPAL2 : 16; /* IPAL2[23:8]      */
    uint32 SPAL2 : 1;  /* SPAL2            */
    uint32       : 7;  /* Reserved Bits    */
} __type760;
typedef struct
{                      /* Bit Access       */
    uint32 FPDL2 : 8;  /* FPDL2[7:0]       */
    uint32 IPDL2 : 16; /* IPDL2[23:8]      */
    uint32 SPDL2 : 1;  /* SPDL2            */
    uint32       : 7;  /* Reserved Bits    */
} __type761;
typedef struct
{                      /* Bit Access       */
    uint32 FPMS2 : 8;  /* FPMS2[7:0]       */
    uint32 IPMS2 : 16; /* IPMS2[23:8]      */
    uint32 SPMS2 : 1;  /* SPMS2            */
    uint32       : 7;  /* Reserved Bits    */
} __type762;
typedef struct
{                      /* Bit Access       */
    uint32 FPHC2 : 8;  /* FPHC2[7:0]       */
    uint32 IPHC2 : 16; /* IPHC2[23:8]      */
    uint32 SPHC2 : 1;  /* SPHC2            */
    uint32       : 7;  /* Reserved Bits    */
} __type763;
typedef struct
{                      /* Bit Access       */
    uint32 FPS12 : 8;  /* FPS12[7:0]       */
    uint32 IPS12 : 16; /* IPS12[23:8]      */
    uint32 SPS12 : 1;  /* SPS12            */
    uint32       : 7;  /* Reserved Bits    */
} __type764;
typedef struct
{                      /* Bit Access       */
    uint32 FPS22 : 8;  /* FPS22[7:0]       */
    uint32 IPS22 : 16; /* IPS22[23:8]      */
    uint32 SPS22 : 1;  /* SPS22            */
    uint32       : 7;  /* Reserved Bits    */
} __type765;
typedef struct
{                      /* Bit Access       */
    uint32 FPS32 : 8;  /* FPS32[7:0]       */
    uint32 IPS32 : 16; /* IPS32[23:8]      */
    uint32 SPS32 : 1;  /* SPS32            */
    uint32       : 7;  /* Reserved Bits    */
} __type766;
typedef struct
{                      /* Bit Access       */
    uint32 FPS42 : 8;  /* FPS42[7:0]       */
    uint32 IPS42 : 16; /* IPS42[23:8]      */
    uint32 SPS42 : 1;  /* SPS42            */
    uint32       : 7;  /* Reserved Bits    */
} __type767;
typedef struct
{                      /* Bit Access       */
    uint32 FPMP3 : 8;  /* FPMP3[7:0]       */
    uint32 IPMP3 : 16; /* IPMP3[23:8]      */
    uint32 SPMP3 : 1;  /* SPMP3            */
    uint32       : 7;  /* Reserved Bits    */
} __type768;
typedef struct
{                      /* Bit Access       */
    uint32 FPDF3 : 3;  /* FPDF3[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type769;
typedef struct
{                      /* Bit Access       */
    uint32 FPAL3 : 8;  /* FPAL3[7:0]       */
    uint32 IPAL3 : 16; /* IPAL3[23:8]      */
    uint32 SPAL3 : 1;  /* SPAL3            */
    uint32       : 7;  /* Reserved Bits    */
} __type770;
typedef struct
{                      /* Bit Access       */
    uint32 FPDL3 : 8;  /* FPDL3[7:0]       */
    uint32 IPDL3 : 16; /* IPDL3[23:8]      */
    uint32 SPDL3 : 1;  /* SPDL3            */
    uint32       : 7;  /* Reserved Bits    */
} __type771;
typedef struct
{                      /* Bit Access       */
    uint32 FPMS3 : 8;  /* FPMS3[7:0]       */
    uint32 IPMS3 : 16; /* IPMS3[23:8]      */
    uint32 SPMS3 : 1;  /* SPMS3            */
    uint32       : 7;  /* Reserved Bits    */
} __type772;
typedef struct
{                      /* Bit Access       */
    uint32 FPHC3 : 8;  /* FPHC3[7:0]       */
    uint32 IPHC3 : 16; /* IPHC3[23:8]      */
    uint32 SPHC3 : 1;  /* SPHC3            */
    uint32       : 7;  /* Reserved Bits    */
} __type773;
typedef struct
{                      /* Bit Access       */
    uint32 FPS13 : 8;  /* FPS13[7:0]       */
    uint32 IPS13 : 16; /* IPS13[23:8]      */
    uint32 SPS13 : 1;  /* SPS13            */
    uint32       : 7;  /* Reserved Bits    */
} __type774;
typedef struct
{                      /* Bit Access       */
    uint32 FPS23 : 8;  /* FPS23[7:0]       */
    uint32 IPS23 : 16; /* IPS23[23:8]      */
    uint32 SPS23 : 1;  /* SPS23            */
    uint32       : 7;  /* Reserved Bits    */
} __type775;
typedef struct
{                      /* Bit Access       */
    uint32 FPS33 : 8;  /* FPS33[7:0]       */
    uint32 IPS33 : 16; /* IPS33[23:8]      */
    uint32 SPS33 : 1;  /* SPS33            */
    uint32       : 7;  /* Reserved Bits    */
} __type776;
typedef struct
{                      /* Bit Access       */
    uint32 FPS43 : 8;  /* FPS43[7:0]       */
    uint32 IPS43 : 16; /* IPS43[23:8]      */
    uint32 SPS43 : 1;  /* SPS43            */
    uint32       : 7;  /* Reserved Bits    */
} __type777;
typedef struct
{                      /* Bit Access       */
    uint32 FPMP4 : 8;  /* FPMP4[7:0]       */
    uint32 IPMP4 : 16; /* IPMP4[23:8]      */
    uint32 SPMP4 : 1;  /* SPMP4            */
    uint32       : 7;  /* Reserved Bits    */
} __type778;
typedef struct
{                      /* Bit Access       */
    uint32 FPDF4 : 3;  /* FPDF4[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type779;
typedef struct
{                      /* Bit Access       */
    uint32 FPAL4 : 8;  /* FPAL4[7:0]       */
    uint32 IPAL4 : 16; /* IPAL4[23:8]      */
    uint32 SPAL4 : 1;  /* SPAL4            */
    uint32       : 7;  /* Reserved Bits    */
} __type780;
typedef struct
{                      /* Bit Access       */
    uint32 FPDL4 : 8;  /* FPDL4[7:0]       */
    uint32 IPDL4 : 16; /* IPDL4[23:8]      */
    uint32 SPDL4 : 1;  /* SPDL4            */
    uint32       : 7;  /* Reserved Bits    */
} __type781;
typedef struct
{                      /* Bit Access       */
    uint32 FPMS4 : 8;  /* FPMS4[7:0]       */
    uint32 IPMS4 : 16; /* IPMS4[23:8]      */
    uint32 SPMS4 : 1;  /* SPMS4            */
    uint32       : 7;  /* Reserved Bits    */
} __type782;
typedef struct
{                      /* Bit Access       */
    uint32 FPHC4 : 8;  /* FPHC4[7:0]       */
    uint32 IPHC4 : 16; /* IPHC4[23:8]      */
    uint32 SPHC4 : 1;  /* SPHC4            */
    uint32       : 7;  /* Reserved Bits    */
} __type783;
typedef struct
{                      /* Bit Access       */
    uint32 FPS14 : 8;  /* FPS14[7:0]       */
    uint32 IPS14 : 16; /* IPS14[23:8]      */
    uint32 SPS14 : 1;  /* SPS14            */
    uint32       : 7;  /* Reserved Bits    */
} __type784;
typedef struct
{                      /* Bit Access       */
    uint32 FPS24 : 8;  /* FPS24[7:0]       */
    uint32 IPS24 : 16; /* IPS24[23:8]      */
    uint32 SPS24 : 1;  /* SPS24            */
    uint32       : 7;  /* Reserved Bits    */
} __type785;
typedef struct
{                      /* Bit Access       */
    uint32 FPS34 : 8;  /* FPS34[7:0]       */
    uint32 IPS34 : 16; /* IPS34[23:8]      */
    uint32 SPS34 : 1;  /* SPS34            */
    uint32       : 7;  /* Reserved Bits    */
} __type786;
typedef struct
{                      /* Bit Access       */
    uint32 FPS44 : 8;  /* FPS44[7:0]       */
    uint32 IPS44 : 16; /* IPS44[23:8]      */
    uint32 SPS44 : 1;  /* SPS44            */
    uint32       : 7;  /* Reserved Bits    */
} __type787;
typedef struct
{                      /* Bit Access       */
    uint32 FPMP5 : 8;  /* FPMP5[7:0]       */
    uint32 IPMP5 : 16; /* IPMP5[23:8]      */
    uint32 SPMP5 : 1;  /* SPMP5            */
    uint32       : 7;  /* Reserved Bits    */
} __type788;
typedef struct
{                      /* Bit Access       */
    uint32 FPDF5 : 3;  /* FPDF5[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type789;
typedef struct
{                      /* Bit Access       */
    uint32 FPAL5 : 8;  /* FPAL5[7:0]       */
    uint32 IPAL5 : 16; /* IPAL5[23:8]      */
    uint32 SPAL5 : 1;  /* SPAL5            */
    uint32       : 7;  /* Reserved Bits    */
} __type790;
typedef struct
{                      /* Bit Access       */
    uint32 FPDL5 : 8;  /* FPDL5[7:0]       */
    uint32 IPDL5 : 16; /* IPDL5[23:8]      */
    uint32 SPDL5 : 1;  /* SPDL5            */
    uint32       : 7;  /* Reserved Bits    */
} __type791;
typedef struct
{                      /* Bit Access       */
    uint32 FPMS5 : 8;  /* FPMS5[7:0]       */
    uint32 IPMS5 : 16; /* IPMS5[23:8]      */
    uint32 SPMS5 : 1;  /* SPMS5            */
    uint32       : 7;  /* Reserved Bits    */
} __type792;
typedef struct
{                      /* Bit Access       */
    uint32 FPHC5 : 8;  /* FPHC5[7:0]       */
    uint32 IPHC5 : 16; /* IPHC5[23:8]      */
    uint32 SPHC5 : 1;  /* SPHC5            */
    uint32       : 7;  /* Reserved Bits    */
} __type793;
typedef struct
{                      /* Bit Access       */
    uint32 FPS15 : 8;  /* FPS15[7:0]       */
    uint32 IPS15 : 16; /* IPS15[23:8]      */
    uint32 SPS15 : 1;  /* SPS15            */
    uint32       : 7;  /* Reserved Bits    */
} __type794;
typedef struct
{                      /* Bit Access       */
    uint32 FPS25 : 8;  /* FPS25[7:0]       */
    uint32 IPS25 : 16; /* IPS25[23:8]      */
    uint32 SPS25 : 1;  /* SPS25            */
    uint32       : 7;  /* Reserved Bits    */
} __type795;
typedef struct
{                      /* Bit Access       */
    uint32 FPS35 : 8;  /* FPS35[7:0]       */
    uint32 IPS35 : 16; /* IPS35[23:8]      */
    uint32 SPS35 : 1;  /* SPS35            */
    uint32       : 7;  /* Reserved Bits    */
} __type796;
typedef struct
{                      /* Bit Access       */
    uint32 FPS45 : 8;  /* FPS45[7:0]       */
    uint32 IPS45 : 16; /* IPS45[23:8]      */
    uint32 SPS45 : 1;  /* SPS45            */
    uint32       : 7;  /* Reserved Bits    */
} __type797;
typedef struct
{                      /* Bit Access       */
    uint32 FVAX0 : 8;  /* FVAX0[7:0]       */
    uint32 IVAX0 : 16; /* IVAX0[23:8]      */
    uint32 SVAX0 : 1;  /* SVAX0            */
    uint32       : 7;  /* Reserved Bits    */
} __type798;
typedef struct
{                      /* Bit Access       */
    uint32 FVAS0 : 8;  /* FVAS0[7:0]       */
    uint32 IVAS0 : 16; /* IVAS0[23:8]      */
    uint32 SVAS0 : 1;  /* SVAS0            */
    uint32       : 7;  /* Reserved Bits    */
} __type799;
typedef struct
{                      /* Bit Access       */
    uint32 FVPS0 : 8;  /* FVPS0[7:0]       */
    uint32 IVPS0 : 16; /* IVPS0[23:8]      */
    uint32 SVPS0 : 1;  /* SVPS0            */
    uint32       : 7;  /* Reserved Bits    */
} __type800;
typedef struct
{                      /* Bit Access       */
    uint32 FVPT0 : 8;  /* FVPT0[7:0]       */
    uint32 IVPT0 : 16; /* IVPT0[23:8]      */
    uint32 SVPT0 : 1;  /* SVPT0            */
    uint32       : 7;  /* Reserved Bits    */
} __type801;
typedef struct
{                      /* Bit Access       */
    uint32 FVAP0 : 8;  /* FVAP0[7:0]       */
    uint32 IVAP0 : 16; /* IVAP0[23:8]      */
    uint32 SVAP0 : 1;  /* SVAP0            */
    uint32       : 7;  /* Reserved Bits    */
} __type802;
typedef struct
{                      /* Bit Access       */
    uint32 FVVP0 : 8;  /* FVVP0[7:0]       */
    uint32 IVVP0 : 16; /* IVVP0[23:8]      */
    uint32 SVVP0 : 1;  /* SVVP0            */
    uint32       : 7;  /* Reserved Bits    */
} __type803;
typedef struct
{                      /* Bit Access       */
    uint32 VVSP0 : 1;  /* VVSP0            */
    uint32 VVDR0 : 1;  /* VVDR0            */
    uint32       : 30; /* Reserved Bits    */
} __type804;
typedef struct
{                      /* Bit Access       */
    uint32 FVAX1 : 8;  /* FVAX1[7:0]       */
    uint32 IVAX1 : 16; /* IVAX1[23:8]      */
    uint32 SVAX1 : 1;  /* SVAX1            */
    uint32       : 7;  /* Reserved Bits    */
} __type805;
typedef struct
{                      /* Bit Access       */
    uint32 FVAS1 : 8;  /* FVAS1[7:0]       */
    uint32 IVAS1 : 16; /* IVAS1[23:8]      */
    uint32 SVAS1 : 1;  /* SVAS1            */
    uint32       : 7;  /* Reserved Bits    */
} __type806;
typedef struct
{                      /* Bit Access       */
    uint32 FVPS1 : 8;  /* FVPS1[7:0]       */
    uint32 IVPS1 : 16; /* IVPS1[23:8]      */
    uint32 SVPS1 : 1;  /* SVPS1            */
    uint32       : 7;  /* Reserved Bits    */
} __type807;
typedef struct
{                      /* Bit Access       */
    uint32 FVPT1 : 8;  /* FVPT1[7:0]       */
    uint32 IVPT1 : 16; /* IVPT1[23:8]      */
    uint32 SVPT1 : 1;  /* SVPT1            */
    uint32       : 7;  /* Reserved Bits    */
} __type808;
typedef struct
{                      /* Bit Access       */
    uint32 FVAP1 : 8;  /* FVAP1[7:0]       */
    uint32 IVAP1 : 16; /* IVAP1[23:8]      */
    uint32 SVAP1 : 1;  /* SVAP1            */
    uint32       : 7;  /* Reserved Bits    */
} __type809;
typedef struct
{                      /* Bit Access       */
    uint32 FVVP1 : 8;  /* FVVP1[7:0]       */
    uint32 IVVP1 : 16; /* IVVP1[23:8]      */
    uint32 SVVP1 : 1;  /* SVVP1            */
    uint32       : 7;  /* Reserved Bits    */
} __type810;
typedef struct
{                      /* Bit Access       */
    uint32 VVSP1 : 1;  /* VVSP1            */
    uint32 VVDR1 : 1;  /* VVDR1            */
    uint32       : 30; /* Reserved Bits    */
} __type811;
typedef struct
{                      /* Bit Access       */
    uint32 FVAX2 : 8;  /* FVAX2[7:0]       */
    uint32 IVAX2 : 16; /* IVAX2[23:8]      */
    uint32 SVAX2 : 1;  /* SVAX2            */
    uint32       : 7;  /* Reserved Bits    */
} __type812;
typedef struct
{                      /* Bit Access       */
    uint32 FVAS2 : 8;  /* FVAS2[7:0]       */
    uint32 IVAS2 : 16; /* IVAS2[23:8]      */
    uint32 SVAS2 : 1;  /* SVAS2            */
    uint32       : 7;  /* Reserved Bits    */
} __type813;
typedef struct
{                      /* Bit Access       */
    uint32 FVPS2 : 8;  /* FVPS2[7:0]       */
    uint32 IVPS2 : 16; /* IVPS2[23:8]      */
    uint32 SVPS2 : 1;  /* SVPS2            */
    uint32       : 7;  /* Reserved Bits    */
} __type814;
typedef struct
{                      /* Bit Access       */
    uint32 FVPT2 : 8;  /* FVPT2[7:0]       */
    uint32 IVPT2 : 16; /* IVPT2[23:8]      */
    uint32 SVPT2 : 1;  /* SVPT2            */
    uint32       : 7;  /* Reserved Bits    */
} __type815;
typedef struct
{                      /* Bit Access       */
    uint32 FVAP2 : 8;  /* FVAP2[7:0]       */
    uint32 IVAP2 : 16; /* IVAP2[23:8]      */
    uint32 SVAP2 : 1;  /* SVAP2            */
    uint32       : 7;  /* Reserved Bits    */
} __type816;
typedef struct
{                      /* Bit Access       */
    uint32 FVVP2 : 8;  /* FVVP2[7:0]       */
    uint32 IVVP2 : 16; /* IVVP2[23:8]      */
    uint32 SVVP2 : 1;  /* SVVP2            */
    uint32       : 7;  /* Reserved Bits    */
} __type817;
typedef struct
{                      /* Bit Access       */
    uint32 VVSP2 : 1;  /* VVSP2            */
    uint32 VVDR2 : 1;  /* VVDR2            */
    uint32       : 30; /* Reserved Bits    */
} __type818;
typedef struct
{                      /* Bit Access       */
    uint32 FVAX3 : 8;  /* FVAX3[7:0]       */
    uint32 IVAX3 : 16; /* IVAX3[23:8]      */
    uint32 SVAX3 : 1;  /* SVAX3            */
    uint32       : 7;  /* Reserved Bits    */
} __type819;
typedef struct
{                      /* Bit Access       */
    uint32 FVAS3 : 8;  /* FVAS3[7:0]       */
    uint32 IVAS3 : 16; /* IVAS3[23:8]      */
    uint32 SVAS3 : 1;  /* SVAS3            */
    uint32       : 7;  /* Reserved Bits    */
} __type820;
typedef struct
{                      /* Bit Access       */
    uint32 FVPS3 : 8;  /* FVPS3[7:0]       */
    uint32 IVPS3 : 16; /* IVPS3[23:8]      */
    uint32 SVPS3 : 1;  /* SVPS3            */
    uint32       : 7;  /* Reserved Bits    */
} __type821;
typedef struct
{                      /* Bit Access       */
    uint32 FVPT3 : 8;  /* FVPT3[7:0]       */
    uint32 IVPT3 : 16; /* IVPT3[23:8]      */
    uint32 SVPT3 : 1;  /* SVPT3            */
    uint32       : 7;  /* Reserved Bits    */
} __type822;
typedef struct
{                      /* Bit Access       */
    uint32 FVAP3 : 8;  /* FVAP3[7:0]       */
    uint32 IVAP3 : 16; /* IVAP3[23:8]      */
    uint32 SVAP3 : 1;  /* SVAP3            */
    uint32       : 7;  /* Reserved Bits    */
} __type823;
typedef struct
{                      /* Bit Access       */
    uint32 FVVP3 : 8;  /* FVVP3[7:0]       */
    uint32 IVVP3 : 16; /* IVVP3[23:8]      */
    uint32 SVVP3 : 1;  /* SVVP3            */
    uint32       : 7;  /* Reserved Bits    */
} __type824;
typedef struct
{                      /* Bit Access       */
    uint32 VVSP3 : 1;  /* VVSP3            */
    uint32 VVDR3 : 1;  /* VVDR3            */
    uint32       : 30; /* Reserved Bits    */
} __type825;
typedef struct
{                      /* Bit Access       */
    uint32 FVAX4 : 8;  /* FVAX4[7:0]       */
    uint32 IVAX4 : 16; /* IVAX4[23:8]      */
    uint32 SVAX4 : 1;  /* SVAX4            */
    uint32       : 7;  /* Reserved Bits    */
} __type826;
typedef struct
{                      /* Bit Access       */
    uint32 FVAS4 : 8;  /* FVAS4[7:0]       */
    uint32 IVAS4 : 16; /* IVAS4[23:8]      */
    uint32 SVAS4 : 1;  /* SVAS4            */
    uint32       : 7;  /* Reserved Bits    */
} __type827;
typedef struct
{                      /* Bit Access       */
    uint32 FVPS4 : 8;  /* FVPS4[7:0]       */
    uint32 IVPS4 : 16; /* IVPS4[23:8]      */
    uint32 SVPS4 : 1;  /* SVPS4            */
    uint32       : 7;  /* Reserved Bits    */
} __type828;
typedef struct
{                      /* Bit Access       */
    uint32 FVPT4 : 8;  /* FVPT4[7:0]       */
    uint32 IVPT4 : 16; /* IVPT4[23:8]      */
    uint32 SVPT4 : 1;  /* SVPT4            */
    uint32       : 7;  /* Reserved Bits    */
} __type829;
typedef struct
{                      /* Bit Access       */
    uint32 FVAP4 : 8;  /* FVAP4[7:0]       */
    uint32 IVAP4 : 16; /* IVAP4[23:8]      */
    uint32 SVAP4 : 1;  /* SVAP4            */
    uint32       : 7;  /* Reserved Bits    */
} __type830;
typedef struct
{                      /* Bit Access       */
    uint32 FVVP4 : 8;  /* FVVP4[7:0]       */
    uint32 IVVP4 : 16; /* IVVP4[23:8]      */
    uint32 SVVP4 : 1;  /* SVVP4            */
    uint32       : 7;  /* Reserved Bits    */
} __type831;
typedef struct
{                      /* Bit Access       */
    uint32 VVSP4 : 1;  /* VVSP4            */
    uint32 VVDR4 : 1;  /* VVDR4            */
    uint32       : 30; /* Reserved Bits    */
} __type832;
typedef struct
{                      /* Bit Access       */
    uint32 FVAX5 : 8;  /* FVAX5[7:0]       */
    uint32 IVAX5 : 16; /* IVAX5[23:8]      */
    uint32 SVAX5 : 1;  /* SVAX5            */
    uint32       : 7;  /* Reserved Bits    */
} __type833;
typedef struct
{                      /* Bit Access       */
    uint32 FVAS5 : 8;  /* FVAS5[7:0]       */
    uint32 IVAS5 : 16; /* IVAS5[23:8]      */
    uint32 SVAS5 : 1;  /* SVAS5            */
    uint32       : 7;  /* Reserved Bits    */
} __type834;
typedef struct
{                      /* Bit Access       */
    uint32 FVPS5 : 8;  /* FVPS5[7:0]       */
    uint32 IVPS5 : 16; /* IVPS5[23:8]      */
    uint32 SVPS5 : 1;  /* SVPS5            */
    uint32       : 7;  /* Reserved Bits    */
} __type835;
typedef struct
{                      /* Bit Access       */
    uint32 FVPT5 : 8;  /* FVPT5[7:0]       */
    uint32 IVPT5 : 16; /* IVPT5[23:8]      */
    uint32 SVPT5 : 1;  /* SVPT5            */
    uint32       : 7;  /* Reserved Bits    */
} __type836;
typedef struct
{                      /* Bit Access       */
    uint32 FVAP5 : 8;  /* FVAP5[7:0]       */
    uint32 IVAP5 : 16; /* IVAP5[23:8]      */
    uint32 SVAP5 : 1;  /* SVAP5            */
    uint32       : 7;  /* Reserved Bits    */
} __type837;
typedef struct
{                      /* Bit Access       */
    uint32 FVVP5 : 8;  /* FVVP5[7:0]       */
    uint32 IVVP5 : 16; /* IVVP5[23:8]      */
    uint32 SVVP5 : 1;  /* SVVP5            */
    uint32       : 7;  /* Reserved Bits    */
} __type838;
typedef struct
{                      /* Bit Access       */
    uint32 VVSP5 : 1;  /* VVSP5            */
    uint32 VVDR5 : 1;  /* VVDR5            */
    uint32       : 30; /* Reserved Bits    */
} __type839;
typedef struct
{                      /* Bit Access       */
    uint32       : 7;  /* Reserved Bits    */
    uint32 SVDIS : 1;  /* SVDIS            */
    uint32       : 24; /* Reserved Bits    */
} __type840;
typedef struct
{                       /* Bit Access       */
    uint32 ENAB   : 1;  /* ENAB             */
    uint32 MODE   : 1;  /* MODE             */
    uint32 STEREO : 1;  /* STEREO           */
    uint32 DOM    : 1;  /* DOM              */
    uint32        : 28; /* Reserved Bits    */
} __type841;
typedef struct
{                     /* Bit Access       */
    uint32 TPWM : 16; /* TPWM[15:0]       */
    uint32      : 16; /* Reserved Bits    */
} __type842;
typedef struct
{                       /* Bit Access       */
    uint32 INVAP0 : 1;  /* INVAP0           */
    uint32 INVAN0 : 1;  /* INVAN0           */
    uint32 INVBP0 : 1;  /* INVBP0           */
    uint32 INVBN0 : 1;  /* INVBN0           */
    uint32        : 4;  /* Reserved Bits    */
    uint32 INVAP1 : 1;  /* INVAP1           */
    uint32 INVAN1 : 1;  /* INVAN1           */
    uint32 INVBP1 : 1;  /* INVBP1           */
    uint32 INVBN1 : 1;  /* INVBN1           */
    uint32        : 20; /* Reserved Bits    */
} __type843;
typedef struct
{                        /* Bit Access       */
    uint32 STLVAP0 : 1;  /* STLVAP0          */
    uint32 STLVAN0 : 1;  /* STLVAN0          */
    uint32 STLVBP0 : 1;  /* STLVBP0          */
    uint32 STLVBN0 : 1;  /* STLVBN0          */
    uint32         : 4;  /* Reserved Bits    */
    uint32 STLVAP1 : 1;  /* STLVAP1          */
    uint32 STLVAN1 : 1;  /* STLVAN1          */
    uint32 STLVBP1 : 1;  /* STLVBP1          */
    uint32 STLVBN1 : 1;  /* STLVBN1          */
    uint32         : 20; /* Reserved Bits    */
} __type844;
typedef struct
{                        /* Bit Access       */
    uint32 STENAP0 : 1;  /* STENAP0          */
    uint32 STENAN0 : 1;  /* STENAN0          */
    uint32 STENBP0 : 1;  /* STENBP0          */
    uint32 STENBN0 : 1;  /* STENBN0          */
    uint32         : 4;  /* Reserved Bits    */
    uint32 STENAP1 : 1;  /* STENAP1          */
    uint32 STENAN1 : 1;  /* STENAN1          */
    uint32 STENBP1 : 1;  /* STENBP1          */
    uint32 STENBN1 : 1;  /* STENBN1          */
    uint32         : 20; /* Reserved Bits    */
} __type845;
typedef struct
{                     /* Bit Access       */
    uint32 OFFS : 16; /* OFFS[15:0]       */
    uint32      : 16; /* Reserved Bits    */
} __type846;
typedef struct
{                     /* Bit Access       */
    uint32 AUSR : 16; /* AUSR[15:0]       */
    uint32 AUSL : 16; /* AUSL[31:16]      */
} __type847;
typedef struct
{                           /* Bit Access       */
    const uint32 UR   : 1;  /* UR               */
    const uint32 OV   : 1;  /* OV               */
    uint32            : 12; /* Reserved Bits    */
    const uint32 FIFO : 2;  /* FIFO[15:14]      */
    uint32            : 16; /* Reserved Bits    */
} __type848;
typedef struct
{                    /* Bit Access       */
    uint32 URC : 1;  /* URC              */
    uint32 OVC : 1;  /* OVC              */
    uint32     : 30; /* Reserved Bits    */
} __type849;
typedef struct
{                      /* Bit Access       */
    uint32 CKSEL : 3;  /* CKSEL[2:0]       */
    uint32       : 29; /* Reserved Bits    */
} __type850;
typedef struct
{                       /* Bit Access       */
    uint32        : 7;  /* Reserved Bits    */
    uint32 SVSDIS : 1;  /* SVSDIS           */
    uint32        : 24; /* Reserved Bits    */
} __type851;
typedef struct
{                       /* Bit Access       */
    uint32 EN     : 1;  /* EN               */
    uint32 CLKDIV : 3;  /* CLKDIV[3:1]      */
    uint32        : 28; /* Reserved Bits    */
} __type852;
typedef struct
{                          /* Bit Access       */
    const uint32 RUN : 1;  /* RUN              */
    uint32           : 31; /* Reserved Bits    */
} __type853;
typedef struct
{                     /* Bit Access       */
    uint32 MODE : 2;  /* MODE[1:0]        */
    uint32 OS   : 1;  /* OS               */
    uint32 BE   : 1;  /* BE               */
    uint32 OSI  : 1;  /* OSI              */
    uint32      : 27; /* Reserved Bits    */
} __type854;
typedef struct
{                   /* Bit Access       */
    uint32 DF : 8;  /* DF[7:0]          */
    uint32    : 24; /* Reserved Bits    */
} __type855;
typedef struct
{                     /* Bit Access       */
    uint32 ADIL : 9;  /* ADIL[8:0]        */
    uint32      : 23; /* Reserved Bits    */
} __type856;
typedef struct
{                    /* Bit Access       */
    uint32 ITH : 9;  /* ITH[8:0]         */
    uint32     : 23; /* Reserved Bits    */
} __type857;
typedef struct
{                   /* Bit Access       */
    uint32 FL : 9;  /* FL[8:0]          */
    uint32    : 23; /* Reserved Bits    */
} __type858;
typedef struct
{                   /* Bit Access       */
    uint32 FH : 9;  /* FH[8:0]          */
    uint32    : 23; /* Reserved Bits    */
} __type859;
typedef struct
{                    /* Bit Access       */
    uint32 PWM : 9;  /* PWM[8:0]         */
    uint32     : 23; /* Reserved Bits    */
} __type860;
typedef struct
{                     /* Bit Access       */
    uint32 REN   : 1; /* REN              */
    uint32 TEN   : 1; /* TEN              */
    uint32       : 1; /* Reserved Bits    */
    uint32 MUEN  : 1; /* MUEN             */
    uint32 CKDV  : 4; /* CKDV[7:4]        */
    uint32 DEL   : 1; /* DEL              */
    uint32 PDTA  : 1; /* PDTA             */
    uint32 SDTA  : 1; /* SDTA             */
    uint32 SPDP  : 1; /* SPDP             */
    uint32 SWSP  : 1; /* SWSP             */
    uint32 SCKP  : 1; /* SCKP             */
    uint32 SWSD  : 1; /* SWSD             */
    uint32 SCKD  : 1; /* SCKD             */
    uint32 SWL   : 3; /* SWL[18:16]       */
    uint32 DWL   : 3; /* DWL[21:19]       */
    uint32 CHNL  : 2; /* CHNL[23:22]      */
    uint32       : 1; /* Reserved Bits    */
    uint32 IIEN  : 1; /* IIEN             */
    uint32 ROIEN : 1; /* ROIEN            */
    uint32 RUIEN : 1; /* RUIEN            */
    uint32 TOIEN : 1; /* TOIEN            */
    uint32 TUIEN : 1; /* TUIEN            */
    uint32       : 2; /* Reserved Bits    */
} __type861;
typedef struct
{                            /* Bit Access       */
    const uint32 IDST  : 1;  /* IDST             */
    const uint32 RSWNO : 1;  /* RSWNO            */
    const uint32 RCHNO : 2;  /* RCHNO[3:2]       */
    const uint32 TSWNO : 1;  /* TSWNO            */
    const uint32 TCHNO : 2;  /* TCHNO[6:5]       */
    uint32             : 18; /* Reserved Bits    */
    const uint32 IIRQ  : 1;  /* IIRQ             */
    uint32       ROIRQ : 1;  /* ROIRQ            */
    uint32       RUIRQ : 1;  /* RUIRQ            */
    uint32       TOIRQ : 1;  /* TOIRQ            */
    uint32       TUIRQ : 1;  /* TUIRQ            */
    uint32             : 2;  /* Reserved Bits    */
} __type862;
typedef struct
{                      /* Bit Access       */
    uint32 RFRST : 1;  /* RFRST            */
    uint32 TFRST : 1;  /* TFRST            */
    uint32 RIE   : 1;  /* RIE              */
    uint32 TIE   : 1;  /* TIE              */
    uint32 RTRG  : 2;  /* RTRG[5:4]        */
    uint32 TTRG  : 2;  /* TTRG[7:6]        */
    uint32       : 24; /* Reserved Bits    */
} __type863;
typedef struct
{                         /* Bit Access       */
    uint32 RDF       : 1; /* RDF              */
    uint32           : 7; /* Reserved Bits    */
    const uint32 RDC : 4; /* RDC[11:8]        */
    uint32           : 4; /* Reserved Bits    */
    uint32 TDE       : 1; /* TDE              */
    uint32           : 7; /* Reserved Bits    */
    const uint32 TDC : 4; /* TDC[27:24]       */
    uint32           : 4; /* Reserved Bits    */
} __type864;
typedef struct
{                     /* Bit Access       */
    uint32 TDM  : 1;  /* TDM              */
    uint32      : 7;  /* Reserved Bits    */
    uint32 CONT : 1;  /* CONT             */
    uint32      : 23; /* Reserved Bits    */
} __type865;
typedef struct
{                      /* Bit Access       */
    uint16 GCTRL : 6;  /* GCTRL[5:0]       */
    uint16 ULS   : 2;  /* ULS[7:6]         */
    uint16 ADIE  : 1;  /* ADIE             */
    uint16       : 7;  /* Reserved Bits    */
    uint16       : 16; /* Reserved Bits    */
} __type866;
typedef struct
{                       /* Bit Access       */
    uint8 TSNGCTRL : 6; /* TSNGCTRL[5:0]    */
    uint8 TSNULS   : 2; /* TSNULS[7:6]      */
    uint8          : 8; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
} __type867;
typedef struct
{                          /* Bit Access       */
    const uint8 GCTRL : 6; /* GCTRL[5:0]       */
    const uint8 ULS   : 2; /* ULS[7:6]         */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type868;
typedef struct
{                           /* Bit Access       */
    const uint16 DR00 : 16; /* DR00[15:0]       */
    const uint16 DR01 : 16; /* DR01[31:16]      */
} __type869;
typedef struct
{                           /* Bit Access       */
    const uint16 DR02 : 16; /* DR02[15:0]       */
    const uint16 DR03 : 16; /* DR03[31:16]      */
} __type870;
typedef struct
{                           /* Bit Access       */
    const uint16 DR04 : 16; /* DR04[15:0]       */
    const uint16 DR05 : 16; /* DR05[31:16]      */
} __type871;
typedef struct
{                           /* Bit Access       */
    const uint16 DR06 : 16; /* DR06[15:0]       */
    const uint16 DR07 : 16; /* DR07[31:16]      */
} __type872;
typedef struct
{                           /* Bit Access       */
    const uint16 DR08 : 16; /* DR08[15:0]       */
    const uint16 DR09 : 16; /* DR09[31:16]      */
} __type873;
typedef struct
{                           /* Bit Access       */
    const uint16 DR10 : 16; /* DR10[15:0]       */
    const uint16 DR11 : 16; /* DR11[31:16]      */
} __type874;
typedef struct
{                           /* Bit Access       */
    const uint16 DR12 : 16; /* DR12[15:0]       */
    const uint16 DR13 : 16; /* DR13[31:16]      */
} __type875;
typedef struct
{                           /* Bit Access       */
    const uint16 DR14 : 16; /* DR14[15:0]       */
    const uint16 DR15 : 16; /* DR15[31:16]      */
} __type876;
typedef struct
{                           /* Bit Access       */
    const uint16 DR16 : 16; /* DR16[15:0]       */
    const uint16 DR17 : 16; /* DR17[31:16]      */
} __type877;
typedef struct
{                           /* Bit Access       */
    const uint16 DR18 : 16; /* DR18[15:0]       */
    const uint16 DR19 : 16; /* DR19[31:16]      */
} __type878;
typedef struct
{                           /* Bit Access       */
    const uint16 DR20 : 16; /* DR20[15:0]       */
    const uint16 DR21 : 16; /* DR21[31:16]      */
} __type879;
typedef struct
{                            /* Bit Access       */
    const uint16 TSNDR : 16; /* TSNDR[15:0]      */
    const uint16 PWDDR : 16; /* PWDDR[31:16]     */
} __type880;
typedef struct
{                           /* Bit Access       */
    const uint32 DR   : 16; /* DR[15:0]         */
    const uint32 ID   : 6;  /* ID[21:16]        */
    uint32            : 3;  /* Reserved Bits    */
    const uint32 WFLG : 1;  /* WFLG             */
    uint32            : 6;  /* Reserved Bits    */
} __type881;
typedef struct
{                            /* Bit Access       */
    const uint32 TSNDR : 16; /* TSNDR[15:0]      */
    const uint32 ID    : 6;  /* ID[21:16]        */
    uint32             : 3;  /* Reserved Bits    */
    const uint32 WFLG  : 1;  /* WFLG             */
    uint32             : 6;  /* Reserved Bits    */
} __type882;
typedef struct
{                            /* Bit Access       */
    const uint32 PWDDR : 16; /* PWDDR[15:0]      */
    const uint32 ID    : 6;  /* ID[21:16]        */
    uint32             : 3;  /* Reserved Bits    */
    const uint32 WFLG  : 1;  /* WFLG             */
    uint32             : 6;  /* Reserved Bits    */
} __type883;
typedef struct
{                   /* Bit Access       */
    uint8 HALT : 1; /* HALT             */
    uint8      : 7; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type884;
typedef struct
{                          /* Bit Access       */
    uint8 SUSMTD      : 2; /* SUSMTD[1:0]      */
    uint8             : 2; /* Reserved Bits    */
    uint8 CTYP        : 1; /* CTYP             */
    uint8 CRAC        : 1; /* CRAC             */
    uint8 TSNSELFDIAG : 1; /* TSNSELFDIAG      */
    uint8 DGON        : 1; /* DGON             */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
    uint8             : 8; /* Reserved Bits    */
} __type885;
typedef struct
{                            /* Bit Access       */
    const uint16 SEF   : 5;  /* SEF[4:0]         */
    uint16             : 3;  /* Reserved Bits    */
    const uint16 SGACT : 6;  /* SGACT[13:8]      */
    uint16             : 2;  /* Reserved Bits    */
    uint16             : 16; /* Reserved Bits    */
} __type886;
typedef struct
{                     /* Bit Access       */
    uint8        : 2; /* Reserved Bits    */
    uint8 OWEIE  : 1; /* OWEIE            */
    uint8 ULEIE  : 1; /* ULEIE            */
    uint8 RDCLRE : 1; /* RDCLRE           */
    uint8        : 3; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type887;
typedef struct
{                      /* Bit Access       */
    uint32       : 4;  /* Reserved Bits    */
    uint32 LLMTB : 12; /* LLMTB[15:4]      */
    uint32       : 4;  /* Reserved Bits    */
    uint32 ULMTB : 12; /* ULMTB[31:20]     */
} __type888;
typedef struct
{                   /* Bit Access       */
    uint8      : 2; /* Reserved Bits    */
    uint8 OWEC : 1; /* OWEC             */
    uint8 ULEC : 1; /* ULEC             */
    uint8      : 4; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type889;
typedef struct
{                             /* Bit Access       */
    const uint16 ULECAP : 6;  /* ULECAP[5:0]      */
    uint16              : 6;  /* Reserved Bits    */
    const uint16 ULSG   : 2;  /* ULSG[13:12]      */
    const uint16 LE     : 1;  /* LE               */
    const uint16 UE     : 1;  /* UE               */
    uint16              : 16; /* Reserved Bits    */
} __type890;
typedef struct
{                           /* Bit Access       */
    const uint8 OWECAP : 6; /* OWECAP[5:0]      */
    uint8              : 1; /* Reserved Bits    */
    const uint8 OWE    : 1; /* OWE              */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
    uint8              : 8; /* Reserved Bits    */
} __type891;
typedef struct
{                   /* Bit Access       */
    uint8 PSEL : 3; /* PSEL[2:0]        */
    uint8      : 5; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type892;
typedef struct
{                    /* Bit Access       */
    uint16 CDG : 16; /* CDG[15:0]        */
    uint16     : 16; /* Reserved Bits    */
} __type893;
typedef struct
{                     /* Bit Access       */
    uint32 PDNB : 20; /* PDNB[19:0]       */
    uint8       : 4;  /* Reserved Bits    */
    uint8       : 8;  /* Reserved Bits    */
} __type894;
typedef struct
{                   /* Bit Access       */
    uint8 SMPT : 8; /* SMPT[7:0]        */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type895;
typedef struct
{                      /* Bit Access       */
    uint8 TSNSMPT : 8; /* TSNSMPT[7:0]     */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
} __type896;
typedef struct
{                     /* Bit Access       */
    uint32 SGPR : 19; /* SGPR[18:0]       */
    uint32      : 13; /* Reserved Bits    */
} __type897;
typedef struct
{                       /* Bit Access       */
    uint8 TSNTRGMD : 1; /* TSNTRGMD         */
    uint8          : 7; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
} __type898;
typedef struct
{                      /* Bit Access       */
    uint8 TSNSEFC : 1; /* TSNSEFC          */
    uint8         : 7; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
} __type899;
typedef struct
{                        /* Bit Access       */
    uint16 TTSNSEL : 16; /* TTSNSEL[15:0]    */
    uint16         : 16; /* Reserved Bits    */
} __type900;
typedef struct
{                   /* Bit Access       */
    uint8 SGST : 1; /* SGST             */
    uint8      : 7; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type901;
typedef struct
{                     /* Bit Access       */
    uint8 TRGMD  : 1; /* TRGMD            */
    uint8        : 1; /* Reserved Bits    */
    uint8 SCT    : 2; /* SCT[3:2]         */
    uint8 ADIE   : 1; /* ADIE             */
    uint8 SCANMD : 1; /* SCANMD           */
    uint8        : 2; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
    uint8        : 8; /* Reserved Bits    */
} __type902;
typedef struct
{                   /* Bit Access       */
    uint8 VCSP : 6; /* VCSP[5:0]        */
    uint8      : 2; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type903;
typedef struct
{                   /* Bit Access       */
    uint8 VCEP : 6; /* VCEP[5:0]        */
    uint8      : 2; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type904;
typedef struct
{                   /* Bit Access       */
    uint8 MCYC : 2; /* MCYC[1:0]        */
    uint8      : 6; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type905;
typedef struct
{                   /* Bit Access       */
    uint8 SEFC : 1; /* SEFC             */
    uint8      : 7; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type906;
typedef struct
{                      /* Bit Access       */
    uint16 T1SEL : 16; /* T1SEL[15:0]      */
    uint16       : 16; /* Reserved Bits    */
} __type907;
typedef struct
{                      /* Bit Access       */
    uint16 T2SEL : 16; /* T2SEL[15:0]      */
    uint16       : 16; /* Reserved Bits    */
} __type908;
typedef struct
{                      /* Bit Access       */
    uint16 T3SEL : 16; /* T3SEL[15:0]      */
    uint16       : 16; /* Reserved Bits    */
} __type909;
typedef struct
{                       /* Bit Access       */
    uint8 PWDTRGMD : 1; /* PWDTRGMD         */
    uint8          : 7; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
    uint8          : 8; /* Reserved Bits    */
} __type910;
typedef struct
{                      /* Bit Access       */
    uint8 PWDSEFC : 1; /* PWDSEFC          */
    uint8         : 7; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
    uint8         : 8; /* Reserved Bits    */
} __type911;
typedef struct
{                  /* Bit Access       */
    uint8 POL : 1; /* POL              */
    uint8 ISZ : 2; /* ISZ[2:1]         */
    uint8     : 5; /* Reserved Bits    */
} __type912;
typedef struct
{                      /* Bit Access       */
    uint32 PCMD0 : 8;  /* PCMD0[7:0]       */
    uint32       : 24; /* Reserved Bits    */
} __type913;
typedef struct
{                              /* Bit Access       */
    const uint32 PROTERR : 1;  /* PROTERR          */
    uint32               : 31; /* Reserved Bits    */
} __type914;
typedef struct
{                            /* Bit Access       */
    uint32             : 1;  /* Reserved Bits    */
    uint32 STBC0DISTRG : 1;  /* STBC0DISTRG      */
    uint32             : 30; /* Reserved Bits    */
} __type915;
typedef struct
{                            /* Bit Access       */
    const uint32 WUF00 : 1;  /* WUF00            */
    const uint32 WUF01 : 1;  /* WUF01            */
    const uint32 WUF02 : 1;  /* WUF02            */
    const uint32 WUF03 : 1;  /* WUF03            */
    const uint32 WUF04 : 1;  /* WUF04            */
    const uint32 WUF05 : 1;  /* WUF05            */
    const uint32 WUF06 : 1;  /* WUF06            */
    const uint32 WUF07 : 1;  /* WUF07            */
    const uint32 WUF08 : 1;  /* WUF08            */
    const uint32 WUF09 : 1;  /* WUF09            */
    const uint32 WUF10 : 1;  /* WUF10            */
    const uint32 WUF11 : 1;  /* WUF11            */
    const uint32 WUF12 : 1;  /* WUF12            */
    const uint32 WUF13 : 1;  /* WUF13            */
    const uint32 WUF14 : 1;  /* WUF14            */
    const uint32 WUF15 : 1;  /* WUF15            */
    const uint32 WUF16 : 1;  /* WUF16            */
    const uint32 WUF17 : 1;  /* WUF17            */
    const uint32 WUF18 : 1;  /* WUF18            */
    uint32             : 13; /* Reserved Bits    */
} __type916;
typedef struct
{                         /* Bit Access       */
    uint32 WUFMSK00 : 1;  /* WUFMSK00         */
    uint32 WUFMSK01 : 1;  /* WUFMSK01         */
    uint32 WUFMSK02 : 1;  /* WUFMSK02         */
    uint32 WUFMSK03 : 1;  /* WUFMSK03         */
    uint32 WUFMSK04 : 1;  /* WUFMSK04         */
    uint32 WUFMSK05 : 1;  /* WUFMSK05         */
    uint32 WUFMSK06 : 1;  /* WUFMSK06         */
    uint32 WUFMSK07 : 1;  /* WUFMSK07         */
    uint32 WUFMSK08 : 1;  /* WUFMSK08         */
    uint32 WUFMSK09 : 1;  /* WUFMSK09         */
    uint32 WUFMSK10 : 1;  /* WUFMSK10         */
    uint32 WUFMSK11 : 1;  /* WUFMSK11         */
    uint32 WUFMSK12 : 1;  /* WUFMSK12         */
    uint32 WUFMSK13 : 1;  /* WUFMSK13         */
    uint32 WUFMSK14 : 1;  /* WUFMSK14         */
    uint32 WUFMSK15 : 1;  /* WUFMSK15         */
    uint32 WUFMSK16 : 1;  /* WUFMSK16         */
    uint32 WUFMSK17 : 1;  /* WUFMSK17         */
    uint32 WUFMSK18 : 1;  /* WUFMSK18         */
    uint32          : 13; /* Reserved Bits    */
} __type917;
typedef struct
{                       /* Bit Access       */
    uint32 WUFC00 : 1;  /* WUFC00           */
    uint32 WUFC01 : 1;  /* WUFC01           */
    uint32 WUFC02 : 1;  /* WUFC02           */
    uint32 WUFC03 : 1;  /* WUFC03           */
    uint32 WUFC04 : 1;  /* WUFC04           */
    uint32 WUFC05 : 1;  /* WUFC05           */
    uint32 WUFC06 : 1;  /* WUFC06           */
    uint32 WUFC07 : 1;  /* WUFC07           */
    uint32 WUFC08 : 1;  /* WUFC08           */
    uint32 WUFC09 : 1;  /* WUFC09           */
    uint32 WUFC10 : 1;  /* WUFC10           */
    uint32 WUFC11 : 1;  /* WUFC11           */
    uint32 WUFC12 : 1;  /* WUFC12           */
    uint32 WUFC13 : 1;  /* WUFC13           */
    uint32 WUFC14 : 1;  /* WUFC14           */
    uint32 WUFC15 : 1;  /* WUFC15           */
    uint32 WUFC16 : 1;  /* WUFC16           */
    uint32 WUFC17 : 1;  /* WUFC17           */
    uint32 WUFC18 : 1;  /* WUFC18           */
    uint32        : 13; /* Reserved Bits    */
} __type918;
typedef struct
{                             /* Bit Access       */
    const uint32 RESF0  : 1;  /* RESF0            */
    const uint32 RESF1  : 1;  /* RESF1            */
    const uint32 RESF2  : 1;  /* RESF2            */
    const uint32 RESF3  : 1;  /* RESF3            */
    uint32              : 4;  /* Reserved Bits    */
    const uint32 RESF8  : 1;  /* RESF8            */
    const uint32 RESF9  : 1;  /* RESF9            */
    const uint32 RESF10 : 1;  /* RESF10           */
    uint32              : 3;  /* Reserved Bits    */
    const uint32 RESF14 : 1;  /* RESF14           */
    const uint32 RESF15 : 1;  /* RESF15           */
    uint32              : 16; /* Reserved Bits    */
} __type919;
typedef struct
{                        /* Bit Access       */
    uint32 RESFC0  : 1;  /* RESFC0           */
    uint32 RESFC1  : 1;  /* RESFC1           */
    uint32 RESFC2  : 1;  /* RESFC2           */
    uint32 RESFC3  : 1;  /* RESFC3           */
    uint32         : 4;  /* Reserved Bits    */
    uint32 RESFC8  : 1;  /* RESFC8           */
    uint32 RESFC9  : 1;  /* RESFC9           */
    uint32 RESFC10 : 1;  /* RESFC10          */
    uint32         : 3;  /* Reserved Bits    */
    uint32 RESFC14 : 1;  /* RESFC14          */
    uint32 RESFC15 : 1;  /* RESFC15          */
    uint32         : 16; /* Reserved Bits    */
} __type920;
typedef struct
{                              /* Bit Access       */
    const uint32 RESFR0  : 1;  /* RESFR0           */
    const uint32 RESFR1  : 1;  /* RESFR1           */
    const uint32 RESFR2  : 1;  /* RESFR2           */
    const uint32 RESFR3  : 1;  /* RESFR3           */
    uint32               : 4;  /* Reserved Bits    */
    const uint32 RESFR8  : 1;  /* RESFR8           */
    const uint32 RESFR9  : 1;  /* RESFR9           */
    const uint32 RESFR10 : 1;  /* RESFR10          */
    uint32               : 3;  /* Reserved Bits    */
    const uint32 RESFR14 : 1;  /* RESFR14          */
    const uint32 RESFR15 : 1;  /* RESFR15          */
    uint32               : 16; /* Reserved Bits    */
} __type921;
typedef struct
{                         /* Bit Access       */
    uint32 RESFCR0  : 1;  /* RESFCR0          */
    uint32 RESFCR1  : 1;  /* RESFCR1          */
    uint32 RESFCR2  : 1;  /* RESFCR2          */
    uint32 RESFCR3  : 1;  /* RESFCR3          */
    uint32          : 4;  /* Reserved Bits    */
    uint32 RESFCR8  : 1;  /* RESFCR8          */
    uint32 RESFCR9  : 1;  /* RESFCR9          */
    uint32 RESFCR10 : 1;  /* RESFCR10         */
    uint32          : 3;  /* Reserved Bits    */
    uint32 RESFCR14 : 1;  /* RESFCR14         */
    uint32 RESFCR15 : 1;  /* RESFCR15         */
    uint32          : 16; /* Reserved Bits    */
} __type922;
typedef struct
{                       /* Bit Access       */
    uint32 SWRESA : 1;  /* SWRESA           */
    uint32        : 31; /* Reserved Bits    */
} __type923;
typedef struct
{                        /* Bit Access       */
    uint32 IOHOLD0 : 1;  /* IOHOLD0          */
    uint32 IOHOLD1 : 1;  /* IOHOLD1          */
    uint32 IOHOLD2 : 1;  /* IOHOLD2          */
    uint32 IOHOLD3 : 1;  /* IOHOLD3          */
    uint32         : 1;  /* Reserved Bits    */
    uint32 IOHOLD5 : 1;  /* IOHOLD5          */
    uint32 IOHOLD6 : 1;  /* IOHOLD6          */
    uint32         : 25; /* Reserved Bits    */
} __type924;
typedef struct
{                           /* Bit Access       */
    uint32            : 1;  /* Reserved Bits    */
    uint32 ROSCDISTRG : 1;  /* ROSCDISTRG       */
    uint32            : 30; /* Reserved Bits    */
} __type925;
typedef struct
{                                 /* Bit Access       */
    uint32                  : 2;  /* Reserved Bits    */
    const uint32 ROSCCLKACT : 1;  /* ROSCCLKACT       */
    uint32                  : 29; /* Reserved Bits    */
} __type926;
typedef struct
{                           /* Bit Access       */
    uint32 ROSCSTPMSK : 1;  /* ROSCSTPMSK       */
    uint32            : 31; /* Reserved Bits    */
} __type927;
typedef struct
{                           /* Bit Access       */
    uint32 MOSCENTRG  : 1;  /* MOSCENTRG        */
    uint32 MOSCDISTRG : 1;  /* MOSCDISTRG       */
    uint32            : 30; /* Reserved Bits    */
} __type928;
typedef struct
{                                 /* Bit Access       */
    uint32                  : 2;  /* Reserved Bits    */
    const uint32 MOSCCLKACT : 1;  /* MOSCCLKACT       */
    uint32                  : 29; /* Reserved Bits    */
} __type929;
typedef struct
{                           /* Bit Access       */
    uint32 MOSCAMPSEL : 2;  /* MOSCAMPSEL[1:0]  */
    uint32            : 30; /* Reserved Bits    */
} __type930;
typedef struct
{                          /* Bit Access       */
    uint32 MOSCCLKST : 17; /* MOSCCLKST[16:0]  */
    uint32           : 15; /* Reserved Bits    */
} __type931;
typedef struct
{                           /* Bit Access       */
    uint32 MOSCSTPMSK : 1;  /* MOSCSTPMSK       */
    uint32            : 31; /* Reserved Bits    */
} __type932;
typedef struct
{                           /* Bit Access       */
    uint32 SOSCENTRG  : 1;  /* SOSCENTRG        */
    uint32 SOSCDISTRG : 1;  /* SOSCDISTRG       */
    uint32            : 30; /* Reserved Bits    */
} __type933;
typedef struct
{                                 /* Bit Access       */
    uint32                  : 2;  /* Reserved Bits    */
    const uint32 SOSCCLKACT : 1;  /* SOSCCLKACT       */
    uint32                  : 29; /* Reserved Bits    */
} __type934;
typedef struct
{                          /* Bit Access       */
    uint32 SOSCCLKST : 30; /* SOSCCLKST[29:0]  */
    uint32           : 2;  /* Reserved Bits    */
} __type935;
typedef struct
{                           /* Bit Access       */
    uint32 WDTA0DCSID : 3;  /* WDTA0DCSID[2:0]  */
    uint32            : 29; /* Reserved Bits    */
} __type936;
typedef struct
{                                /* Bit Access       */
    const uint32 WDTA0DACT : 3;  /* WDTA0DACT[2:0]   */
    uint32                 : 29; /* Reserved Bits    */
} __type937;
typedef struct
{                          /* Bit Access       */
    uint32 AWOTSCSID : 3;  /* AWOTSCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type938;
typedef struct
{                               /* Bit Access       */
    const uint32 AWOTSACT : 3;  /* AWOTSACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type939;
typedef struct
{                          /* Bit Access       */
    uint32 AWOTDCSID : 3;  /* AWOTDCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type940;
typedef struct
{                               /* Bit Access       */
    const uint32 AWOTDACT : 3;  /* AWOTDACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type941;
typedef struct
{                            /* Bit Access       */
    uint32 AWOTDSTPMSK : 1;  /* AWOTDSTPMSK      */
    uint32             : 31; /* Reserved Bits    */
} __type942;
typedef struct
{                          /* Bit Access       */
    uint32 RTCASCSID : 3;  /* RTCASCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type943;
typedef struct
{                               /* Bit Access       */
    const uint32 RTCASACT : 3;  /* RTCASACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type944;
typedef struct
{                          /* Bit Access       */
    uint32 RTCADCSID : 3;  /* RTCADCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type945;
typedef struct
{                               /* Bit Access       */
    const uint32 RTCADACT : 3;  /* RTCADACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type946;
typedef struct
{                            /* Bit Access       */
    uint32 RTCADSTPMSK : 1;  /* RTCADSTPMSK      */
    uint32             : 31; /* Reserved Bits    */
} __type947;
typedef struct
{                          /* Bit Access       */
    uint32 FOUTSCSID : 3;  /* FOUTSCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type948;
typedef struct
{                               /* Bit Access       */
    const uint32 FOUTSACT : 3;  /* FOUTSACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type949;
typedef struct
{                            /* Bit Access       */
    uint32 FOUTSSTPMSK : 1;  /* FOUTSSTPMSK      */
    uint32             : 31; /* Reserved Bits    */
} __type950;
typedef struct
{                        /* Bit Access       */
    uint32 FOUTDIV : 10; /* FOUTDIV[9:0]     */
    uint32         : 22; /* Reserved Bits    */
} __type951;
typedef struct
{                                 /* Bit Access       */
    const uint32 FOUTSYNC   : 1;  /* FOUTSYNC         */
    const uint32 FOUTCLKACT : 1;  /* FOUTCLKACT       */
    uint32                  : 30; /* Reserved Bits    */
} __type952;
typedef struct
{                            /* Bit Access       */
    uint32 PLLFIXSCSID : 2;  /* PLLFIXSCSID[1:0] */
    uint32             : 30; /* Reserved Bits    */
} __type953;
typedef struct
{                                 /* Bit Access       */
    const uint32 PLLFIXSACT : 2;  /* PLLFIXSACT[1:0]  */
    uint32                  : 30; /* Reserved Bits    */
} __type954;
typedef struct
{                          /* Bit Access       */
    uint32 XCCLKSSTP : 1;  /* XCCLKSSTP        */
    uint32           : 31; /* Reserved Bits    */
} __type955;
typedef struct
{                                /* Bit Access       */
    const uint32 XCCLKSACT : 1;  /* XCCLKSACT        */
    uint32                 : 31; /* Reserved Bits    */
} __type956;
typedef struct
{                            /* Bit Access       */
    uint32 PCRSCANSSTP : 1;  /* PCRSCANSSTP      */
    uint32             : 31; /* Reserved Bits    */
} __type957;
typedef struct
{                                  /* Bit Access       */
    const uint32 PCRSCANSACT : 1;  /* PCRSCANSACT      */
    uint32                   : 31; /* Reserved Bits    */
} __type958;
typedef struct
{                            /* Bit Access       */
    uint32 IPCETNBSSTP : 1;  /* IPCETNBSSTP      */
    uint32             : 31; /* Reserved Bits    */
} __type959;
typedef struct
{                                 /* Bit Access       */
    const uint32 PCETNBSACT : 1;  /* PCETNBSACT       */
    uint32                  : 31; /* Reserved Bits    */
} __type960;
typedef struct
{                          /* Bit Access       */
    uint32 SFMASCSID : 2;  /* SFMASCSID[1:0]   */
    uint32           : 30; /* Reserved Bits    */
} __type961;
typedef struct
{                               /* Bit Access       */
    const uint32 SFMASACT : 2;  /* SFMASACT[1:0]    */
    uint32                : 30; /* Reserved Bits    */
} __type962;
typedef struct
{                          /* Bit Access       */
    uint32 SFMADCSID : 3;  /* SFMADCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type963;
typedef struct
{                               /* Bit Access       */
    const uint32 SFMADACT : 3;  /* SFMADACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type964;
typedef struct
{                          /* Bit Access       */
    uint32 CLKJITDIV : 4;  /* CLKJITDIV[3:0]   */
    uint32           : 28; /* Reserved Bits    */
} __type965;
typedef struct
{                                 /* Bit Access       */
    const uint32 CLKJITSYNC : 1;  /* CLKJITSYNC       */
    const uint32 CLKJITACT  : 1;  /* CLKJITACT        */
    uint32                  : 30; /* Reserved Bits    */
} __type966;
typedef struct
{                            /* Bit Access       */
    uint32 CLKJITSCSID : 2;  /* CLKJITSCSID[1:0] */
    uint32             : 30; /* Reserved Bits    */
} __type967;
typedef struct
{                                 /* Bit Access       */
    const uint32 CLKJITSACT : 2;  /* CLKJITSACT[1:0]  */
    uint32                  : 30; /* Reserved Bits    */
} __type968;
typedef struct
{                          /* Bit Access       */
    uint32 ISMSCSID0 : 1;  /* ISMSCSID0        */
    uint32           : 31; /* Reserved Bits    */
} __type969;
typedef struct
{                               /* Bit Access       */
    const uint32 ISMSACT0 : 1;  /* ISMSACT0         */
    uint32                : 31; /* Reserved Bits    */
} __type970;
typedef struct
{                          /* Bit Access       */
    uint32 ADCEDCSID : 2;  /* ADCEDCSID[1:0]   */
    uint32           : 30; /* Reserved Bits    */
} __type971;
typedef struct
{                               /* Bit Access       */
    const uint32 ADCEDACT : 2;  /* ADCEDACT[1:0]    */
    uint32                : 30; /* Reserved Bits    */
} __type972;
typedef struct
{                           /* Bit Access       */
    uint32 LCBISCSID0 : 1;  /* LCBISCSID0       */
    uint32            : 31; /* Reserved Bits    */
} __type973;
typedef struct
{                                /* Bit Access       */
    const uint32 LCBISACT0 : 1;  /* LCBISACT0        */
    uint32                 : 31; /* Reserved Bits    */
} __type974;
typedef struct
{                          /* Bit Access       */
    uint32 RLINSCSID : 2;  /* RLINSCSID[1:0]   */
    uint32           : 30; /* Reserved Bits    */
} __type975;
typedef struct
{                               /* Bit Access       */
    const uint32 RLINSACT : 2;  /* RLINSACT[1:0]    */
    uint32                : 30; /* Reserved Bits    */
} __type976;
typedef struct
{                            /* Bit Access       */
    uint32 TAUB01SCSID : 3;  /* TAUB01SCSID[2:0] */
    uint32             : 29; /* Reserved Bits    */
} __type977;
typedef struct
{                                 /* Bit Access       */
    const uint32 TAUB01SACT : 3;  /* TAUB01SACT[2:0]  */
    uint32                  : 29; /* Reserved Bits    */
} __type978;
typedef struct
{                           /* Bit Access       */
    uint32 TAUB2SCSID : 3;  /* TAUB2SCSID[2:0]  */
    uint32            : 29; /* Reserved Bits    */
} __type979;
typedef struct
{                                /* Bit Access       */
    const uint32 TAUB2SACT : 3;  /* TAUB2SACT[2:0]   */
    uint32                 : 29; /* Reserved Bits    */
} __type980;
typedef struct
{                          /* Bit Access       */
    uint32 TAUJSCSID : 3;  /* TAUJSCSID[2:0]   */
    uint32           : 29; /* Reserved Bits    */
} __type981;
typedef struct
{                               /* Bit Access       */
    const uint32 TAUJSACT : 3;  /* TAUJSACT[2:0]    */
    uint32                : 29; /* Reserved Bits    */
} __type982;
typedef struct
{                          /* Bit Access       */
    uint32 OSTMSCSID : 2;  /* OSTMSCSID[1:0]   */
    uint32           : 30; /* Reserved Bits    */
} __type983;
typedef struct
{                               /* Bit Access       */
    const uint32 OSTMSACT : 2;  /* OSTMSACT[1:0]    */
    uint32                : 30; /* Reserved Bits    */
} __type984;
typedef struct
{                          /* Bit Access       */
    uint32 CLKFIXDIV : 4;  /* CLKFIXDIV[3:0]   */
    uint32           : 28; /* Reserved Bits    */
} __type985;
typedef struct
{                                 /* Bit Access       */
    const uint32 CLKFIXSYNC : 1;  /* CLKFIXSYNC       */
    const uint32 CLKFIXACT  : 1;  /* CLKFIXACT        */
    uint32                  : 30; /* Reserved Bits    */
} __type986;
typedef struct
{                            /* Bit Access       */
    uint32 CLKFIXSCSID : 2;  /* CLKFIXSCSID[1:0] */
    uint32             : 30; /* Reserved Bits    */
} __type987;
typedef struct
{                                 /* Bit Access       */
    const uint32 CLKFIXSACT : 2;  /* CLKFIXSACT[1:0]  */
    uint32                  : 30; /* Reserved Bits    */
} __type988;
typedef struct
{                           /* Bit Access       */
    uint32 RSCANDCSID : 3;  /* RSCANDCSID[2:0]  */
    uint32            : 29; /* Reserved Bits    */
} __type989;
typedef struct
{                                /* Bit Access       */
    const uint32 RSCANDACT : 3;  /* RSCANDACT[2:0]   */
    uint32                 : 29; /* Reserved Bits    */
} __type990;
typedef struct
{                          /* Bit Access       */
    uint32 SSIFDCSID : 8;  /* SSIFDCSID[7:0]   */
    uint32           : 24; /* Reserved Bits    */
} __type991;
typedef struct
{                               /* Bit Access       */
    const uint32 SSIFSYNC : 1;  /* SSIFSYNC         */
    const uint32 SSIFACT  : 1;  /* SSIFACT          */
    uint32                : 30; /* Reserved Bits    */
} __type992;
typedef struct
{                               /* Bit Access       */
    uint32 RSCANXINSCSID0 : 1;  /* RSCANXINSCSID0   */
    uint32                : 31; /* Reserved Bits    */
} __type993;
typedef struct
{                                     /* Bit Access       */
    const uint32 IRSCANXINSACT0 : 1;  /* IRSCANXINSACT0   */
    uint32                      : 31; /* Reserved Bits    */
} __type994;
typedef struct
{                       /* Bit Access       */
    uint32 PCMDD1 : 8;  /* PCMDD1[7:0]      */
    uint32        : 24; /* Reserved Bits    */
} __type995;
typedef struct
{                               /* Bit Access       */
    const uint32 PROTDERR : 1;  /* PROTDERR         */
    uint32                : 31; /* Reserved Bits    */
} __type996;
typedef struct
{                      /* Bit Access       */
    uint32 PCMD1 : 8;  /* PCMD1[7:0]       */
    uint32       : 24; /* Reserved Bits    */
} __type997;
typedef struct
{                           /* Bit Access       */
    uint32 PLL0ENTRG  : 1;  /* PLL0ENTRG        */
    uint32 PLL0DISTRG : 1;  /* PLL0DISTRG       */
    uint32            : 30; /* Reserved Bits    */
} __type998;
typedef struct
{                                 /* Bit Access       */
    uint32                  : 2;  /* Reserved Bits    */
    const uint32 PLL0CLKACT : 1;  /* PLL0CLKACT       */
    uint32                  : 29; /* Reserved Bits    */
} __type999;
typedef struct
{                           /* Bit Access       */
    uint32 NI          : 7; /* NI[6:0]          */
    uint32             : 1; /* Reserved Bits    */
    uint32 P           : 3; /* P[10:8]          */
    uint32 M           : 2; /* M[12:11]         */
    uint32 SSMODE      : 2; /* SSMODE[14:13]    */
    uint32             : 5; /* Reserved Bits    */
    uint32 SELMPERCENT : 3; /* SELMPERCENT[22:20] */
    uint32             : 1; /* Reserved Bits    */
    uint32 SELMFREQ    : 5; /* SELMFREQ[28:24]  */
    uint32 FVV         : 3; /* FVV[31:29]       */
} __type1000;
typedef struct
{                           /* Bit Access       */
    uint32 PLL1ENTRG  : 1;  /* PLL1ENTRG        */
    uint32 PLL1DISTRG : 1;  /* PLL1DISTRG       */
    uint32            : 30; /* Reserved Bits    */
} __type1001;
typedef struct
{                                 /* Bit Access       */
    uint32                  : 2;  /* Reserved Bits    */
    const uint32 PLL1CLKACT : 1;  /* PLL1CLKACT       */
    uint32                  : 29; /* Reserved Bits    */
} __type1002;
typedef struct
{                   /* Bit Access       */
    uint32 NI : 6;  /* NI[5:0]          */
    uint32    : 2;  /* Reserved Bits    */
    uint32 P  : 3;  /* P[10:8]          */
    uint32 M  : 2;  /* M[12:11]         */
    uint32    : 19; /* Reserved Bits    */
} __type1003;
typedef struct
{                         /* Bit Access       */
    uint32 PLL0SSTP : 1;  /* PLL0SSTP         */
    uint32          : 31; /* Reserved Bits    */
} __type1004;
typedef struct
{                               /* Bit Access       */
    const uint32 PLL0SACT : 1;  /* PLL0SACT         */
    uint32                : 31; /* Reserved Bits    */
} __type1005;
typedef struct
{                         /* Bit Access       */
    uint32 PLL1SSTP : 1;  /* PLL1SSTP         */
    uint32          : 31; /* Reserved Bits    */
} __type1006;
typedef struct
{                               /* Bit Access       */
    const uint32 PLL1SACT : 1;  /* PLL1SACT         */
    uint32                : 31; /* Reserved Bits    */
} __type1007;
typedef struct
{                            /* Bit Access       */
    uint32 CPUCLKSCSID : 3;  /* CPUCLKSCSID[2:0] */
    uint32             : 29; /* Reserved Bits    */
} __type1008;
typedef struct
{                                 /* Bit Access       */
    const uint32 CPUCLKSACT : 3;  /* CPUCLKSACT[2:0]  */
    uint32                  : 29; /* Reserved Bits    */
} __type1009;
typedef struct
{                            /* Bit Access       */
    uint32 CPUCLKDCSID : 3;  /* CPUCLKDCSID[2:0] */
    uint32             : 29; /* Reserved Bits    */
} __type1010;
typedef struct
{                                 /* Bit Access       */
    const uint32 CPUCLKDACT : 3;  /* CPUCLKDACT[2:0]  */
    uint32                  : 29; /* Reserved Bits    */
} __type1011;
typedef struct
{                         /* Bit Access       */
    uint32          : 2;  /* Reserved Bits    */
    uint32 ETNB0RES : 1;  /* ETNB0RES         */
    uint32 ISM0RES  : 1;  /* ISM0RES          */
    uint32 ADCE0RES : 1;  /* ADCE0RES         */
    uint32 SG0RES   : 1;  /* SG0RES           */
    uint32 SG1RES   : 1;  /* SG1RES           */
    uint32 SG2RES   : 1;  /* SG2RES           */
    uint32 SG3RES   : 1;  /* SG3RES           */
    uint32 SG4RES   : 1;  /* SG4RES           */
    uint32 LCBI0RES : 1;  /* LCBI0RES         */
    uint32          : 2;  /* Reserved Bits    */
    uint32 XC0RES   : 1;  /* XC0RES           */
    uint32          : 18; /* Reserved Bits    */
} __type1012;
typedef struct
{                          /* Bit Access       */
    uint32 MRSTCPREG : 8;  /* MRSTCPREG[7:0]   */
    uint32           : 24; /* Reserved Bits    */
} __type1013;
typedef struct
{                                /* Bit Access       */
    const uint32 MRSTCPERR : 1;  /* MRSTCPERR        */
    uint32                 : 31; /* Reserved Bits    */
} __type1014;
typedef struct
{                   /* Bit Access       */
    uint8 CLME : 1; /* CLME             */
    uint8      : 7; /* Reserved Bits    */
} __type1015;
typedef struct
{                     /* Bit Access       */
    uint16 CMPL : 12; /* CMPL[11:0]       */
    uint16      : 4;  /* Reserved Bits    */
} __type1016;
typedef struct
{                     /* Bit Access       */
    uint16 CMPH : 12; /* CMPH[11:0]       */
    uint16      : 4;  /* Reserved Bits    */
} __type1017;
typedef struct
{                  /* Bit Access       */
    uint8 REG : 8; /* REG[7:0]         */
} __type1018;
typedef struct
{                    /* Bit Access       */
    uint8 SLSLW : 1; /* SLSLW            */
    uint8 SLFST : 1; /* SLFST            */
    uint8       : 6; /* Reserved Bits    */
} __type1019;
typedef struct
{                           /* Bit Access       */
    uint32 RESCLM     : 1;  /* RESCLM           */
    uint32 MONCLKMSK  : 1;  /* MONCLKMSK        */
    uint32 ERRMSK     : 1;  /* ERRMSK           */
    uint32 CLMA0TESEN : 1;  /* CLMA0TESEN       */
    uint32            : 28; /* Reserved Bits    */
} __type1020;
typedef struct
{                                /* Bit Access       */
    const uint32 CLMA0ERRS : 1;  /* CLMA0ERRS        */
    uint32                 : 31; /* Reserved Bits    */
} __type1021;
typedef struct
{                         /* Bit Access       */
    uint32 CLMATREG : 8;  /* CLMATREG[7:0]    */
    uint32          : 24; /* Reserved Bits    */
} __type1022;
typedef struct
{                                 /* Bit Access       */
    const uint32 CLMATPRERR : 1;  /* CLMATPRERR       */
    uint32                  : 31; /* Reserved Bits    */
} __type1023;
typedef struct
{                       /* Bit Access       */
    uint8 CLMA3CNT : 4; /* CLMA3CNT[3:0]    */
    uint8          : 4; /* Reserved Bits    */
} __type1024;
typedef struct
{                           /* Bit Access       */
    uint32 RESCLM     : 1;  /* RESCLM           */
    uint32 MONCLKMSK  : 1;  /* MONCLKMSK        */
    uint32            : 2;  /* Reserved Bits    */
    uint32 CLMA3TESEN : 1;  /* CLMA3TESEN       */
    uint32 CLMA4TESEN : 1;  /* CLMA4TESEN       */
    uint32            : 26; /* Reserved Bits    */
} __type1025;
typedef struct
{                                /* Bit Access       */
    const uint32 CLMA3ERRS : 1;  /* CLMA3ERRS        */
    const uint32 CLMA4ERRS : 1;  /* CLMA4ERRS        */
    uint32                 : 30; /* Reserved Bits    */
} __type1026;
typedef struct
{                          /* Bit Access       */
    uint32 CLMATREG3 : 8;  /* CLMATREG3[7:0]   */
    uint32           : 24; /* Reserved Bits    */
} __type1027;
typedef struct
{                                  /* Bit Access       */
    const uint32 CLMATPRERR3 : 1;  /* CLMATPRERR3      */
    uint32                   : 31; /* Reserved Bits    */
} __type1028;
typedef struct
{                           /* Bit Access       */
    uint32 RESCLM     : 1;  /* RESCLM           */
    uint32 MONCLKMSK  : 1;  /* MONCLKMSK        */
    uint32            : 2;  /* Reserved Bits    */
    uint32 CLMA1TESEN : 1;  /* CLMA1TESEN       */
    uint32 CLMA2TESEN : 1;  /* CLMA2TESEN       */
    uint32            : 26; /* Reserved Bits    */
} __type1029;
typedef struct
{                                /* Bit Access       */
    const uint32 CLMA1ERRS : 1;  /* CLMA1ERRS        */
    const uint32 CLMA2ERRS : 1;  /* CLMA2ERRS        */
    uint32                 : 30; /* Reserved Bits    */
} __type1030;
typedef struct
{                          /* Bit Access       */
    uint32 CLMATREG2 : 8;  /* CLMATREG2[7:0]   */
    uint32           : 24; /* Reserved Bits    */
} __type1031;
typedef struct
{                                  /* Bit Access       */
    const uint32 CLMATPRERR2 : 1;  /* CLMATPRERR2      */
    uint32                   : 31; /* Reserved Bits    */
} __type1032;
typedef struct
{                      /* Bit Access       */
    uint32 D_CNT : 12; /* D_CNT[11:0]      */
    uint32       : 20; /* Reserved Bits    */
} __type1033;
typedef struct
{                       /* Bit Access       */
    uint32 DPRREG : 8;  /* DPRREG[7:0]      */
    uint32        : 24; /* Reserved Bits    */
} __type1034;
typedef struct
{                             /* Bit Access       */
    const uint32 DPRERR : 1;  /* DPRERR           */
    uint32              : 31; /* Reserved Bits    */
} __type1035;
typedef struct
{                           /* Bit Access       */
    uint32 IDMODIPREG : 8;  /* IDMODIPREG[7:0]  */
    uint32            : 24; /* Reserved Bits    */
} __type1036;
typedef struct
{                                 /* Bit Access       */
    const uint32 IDMODIPERR : 1;  /* IDMODIPERR       */
    uint32                  : 31; /* Reserved Bits    */
} __type1037;
typedef struct
{                   /* Bit Access       */
    uint32 CD : 18; /* CD[17:0]         */
    uint32    : 14; /* Reserved Bits    */
} __type1038;
typedef struct
{                    /* Bit Access       */
    uint32 CKS : 3;  /* CKS[2:0]         */
    uint32     : 29; /* Reserved Bits    */
} __type1039;
typedef struct
{                       /* Bit Access       */
    uint32 SVSDIS : 1;  /* SVSDIS           */
    uint32        : 31; /* Reserved Bits    */
} __type1040;
typedef struct
{                     /* Bit Access       */
    uint32 SRST : 1;  /* SRST             */
    uint32      : 31; /* Reserved Bits    */
} __type1041;
typedef struct
{                        /* Bit Access       */
    uint32 OPMODE  : 2;  /* OPMODE[1:0]      */
    uint32         : 2;  /* Reserved Bits    */
    uint32 OPMFAST : 1;  /* OPMFAST          */
    uint32         : 27; /* Reserved Bits    */
} __type1042;
typedef struct
{                        /* Bit Access       */
    uint32         : 4;  /* Reserved Bits    */
    uint32 CLTOFFS : 4;  /* CLTOFFS[7:4]     */
    uint32         : 24; /* Reserved Bits    */
} __type1043;
typedef struct
{                     /* Bit Access       */
    uint32 DTCC : 1;  /* DTCC             */
    uint32 DTCP : 1;  /* DTCP             */
    uint32      : 2;  /* Reserved Bits    */
    uint32 DTCM : 2;  /* DTCM[5:4]        */
    uint32 DTCS : 2;  /* DTCS[7:6]        */
    uint32      : 24; /* Reserved Bits    */
} __type1044;
typedef struct
{                        /* Bit Access       */
    uint32 BCYTYPE : 1;  /* BCYTYPE          */
    uint32         : 31; /* Reserved Bits    */
} __type1045;
typedef struct
{                    /* Bit Access       */
    uint32 TIAD : 4; /* TIAD[3:0]        */
    uint32 TIDZ : 4; /* TIDZ[7:4]        */
    uint32 TIDW : 4; /* TIDW[11:8]       */
    uint32      : 4; /* Reserved Bits    */
    uint32 TIWR : 8; /* TIWR[23:16]      */
    uint32 TIRD : 8; /* TIRD[31:24]      */
} __type1046;
typedef struct
{                         /* Bit Access       */
    uint32 TFTPCPRS : 16; /* TFTPCPRS[15:0]   */
    uint32          : 16; /* Reserved Bits    */
} __type1047;
typedef struct
{                     /* Bit Access       */
    uint32 TFDHV : 8; /* TFDHV[7:0]       */
    uint32 TFDCH : 8; /* TFDCH[15:8]      */
    uint32 TFDCD : 7; /* TFDCD[22:16]     */
    uint32       : 1; /* Reserved Bits    */
    uint32 TFDCW : 8; /* TFDCW[31:24]     */
} __type1048;
typedef struct
{                       /* Bit Access       */
    uint32 TFNHVS : 8;  /* TFNHVS[7:0]      */
    uint32 TFNVB  : 8;  /* TFNVB[15:8]      */
    uint32 TFNVC  : 10; /* TFNVC[25:16]     */
    uint32 TFNVE  : 6;  /* TFNVE[31:26]     */
} __type1049;
typedef struct
{                       /* Bit Access       */
    uint32 TFNCHS : 8;  /* TFNCHS[7:0]      */
    uint32 TFNHB  : 8;  /* TFNHB[15:8]      */
    uint32 TFNHC  : 10; /* TFNHC[25:16]     */
    uint32 TFNHE  : 6;  /* TFNHE[31:26]     */
} __type1050;
typedef struct
{                      /* Bit Access       */
    uint32 TLA0  : 1;  /* TLA0             */
    uint32 TLCS  : 1;  /* TLCS             */
    uint32 TLWR  : 1;  /* TLWR             */
    uint32 TLRDE : 1;  /* TLRDE            */
    uint32       : 4;  /* Reserved Bits    */
    uint32 TLHS  : 1;  /* TLHS             */
    uint32 TLVS  : 1;  /* TLVS             */
    uint32 TLDE  : 1;  /* TLDE             */
    uint32       : 21; /* Reserved Bits    */
} __type1051;
typedef struct
{                             /* Bit Access       */
    const uint32 TCIDLE : 1;  /* TCIDLE           */
    const uint32 TCLOCK : 1;  /* TCLOCK           */
    const uint32 TCRPG  : 1;  /* TCRPG            */
    uint32              : 29; /* Reserved Bits    */
} __type1052;
typedef struct
{                             /* Bit Access       */
    const uint32 TCIRQ  : 1;  /* TCIRQ            */
    const uint32 RWIRQE : 1;  /* RWIRQE           */
    const uint32 RWIRQH : 1;  /* RWIRQH           */
    const uint32 RWIRQF : 1;  /* RWIRQF           */
    const uint32 RWIRQQ : 1;  /* RWIRQQ           */
    const uint32 RWIRQT : 1;  /* RWIRQT           */
    uint32              : 2;  /* Reserved Bits    */
    const uint32 RWOVF  : 1;  /* RWOVF            */
    const uint32 RWUNR  : 1;  /* RWUNR            */
    uint32              : 22; /* Reserved Bits    */
} __type1053;
typedef struct
{                        /* Bit Access       */
    uint32 TCIRQC  : 1;  /* TCIRQC           */
    uint32 RWIRQEC : 1;  /* RWIRQEC          */
    uint32 RWIRQHC : 1;  /* RWIRQHC          */
    uint32 RWIRQFC : 1;  /* RWIRQFC          */
    uint32 RWIRQQC : 1;  /* RWIRQQC          */
    uint32 RWIRQTC : 1;  /* RWIRQTC          */
    uint32         : 2;  /* Reserved Bits    */
    uint32 RWOVFC  : 1;  /* RWOVFC           */
    uint32 RWUNRC  : 1;  /* RWUNRC           */
    uint32         : 22; /* Reserved Bits    */
} __type1054;
typedef struct
{                      /* Bit Access       */
    uint32 WINEN : 1;  /* WINEN            */
    uint32 CMP   : 31; /* CMP[31:1]        */
} __type1055;
typedef struct
{                    /* Bit Access       */
    uint32     : 1;  /* Reserved Bits    */
    uint32 VLD : 31; /* VLD[31:1]        */
} __type1056;
typedef struct
{                   /* Bit Access       */
    uint32    : 30; /* Reserved Bits    */
    uint32 EN : 1;  /* EN               */
    uint32 UM : 1;  /* UM               */
} __type1057;
typedef struct
{                         /* Bit Access       */
    uint32 RMSK     : 1;  /* RMSK             */
    uint32 WMSK     : 1;  /* WMSK             */
    uint32          : 14; /* Reserved Bits    */
    uint32 MSTIDSEL : 12; /* MSTIDSEL[27:16]  */
    uint32          : 4;  /* Reserved Bits    */
} __type1058;
typedef struct
{                         /* Bit Access       */
    uint32 RINTSTAT : 1;  /* RINTSTAT         */
    uint32 RINTEN   : 1;  /* RINTEN           */
    uint32 WINTSTAT : 1;  /* WINTSTAT         */
    uint32 WINTEN   : 1;  /* WINTEN           */
    uint32          : 28; /* Reserved Bits    */
} __type1059;
typedef struct
{                     /* Bit Access       */
    uint32 ROVF : 1;  /* ROVF             */
    uint32 WOVF : 1;  /* WOVF             */
    uint32      : 30; /* Reserved Bits    */
} __type1060;
typedef struct
{                              /* Bit Access       */
    const uint32 ERRRMST : 8;  /* ERRRMST[7:0]     */
    const uint32 ERRRUM  : 1;  /* ERRRUM           */
    uint32               : 23; /* Reserved Bits    */
} __type1061;
typedef struct
{                              /* Bit Access       */
    const uint32 ERRWMST : 8;  /* ERRWMST[7:0]     */
    const uint32 ERRWUM  : 1;  /* ERRWUM           */
    uint32               : 23; /* Reserved Bits    */
} __type1062;
typedef struct
{                       /* Bit Access       */
    uint32 S3EN0  : 1;  /* S3EN0            */
    uint32 S3EN1  : 1;  /* S3EN1            */
    uint32 S3EN2  : 1;  /* S3EN2            */
    uint32 S3EN3  : 1;  /* S3EN3            */
    uint32 S3EN4  : 1;  /* S3EN4            */
    uint32 S3EN5  : 1;  /* S3EN5            */
    uint32 S3EN6  : 1;  /* S3EN6            */
    uint32 S3EN7  : 1;  /* S3EN7            */
    uint32 S3EN8  : 1;  /* S3EN8            */
    uint32 S3EN9  : 1;  /* S3EN9            */
    uint32 S3EN10 : 1;  /* S3EN10           */
    uint32 S3EN11 : 1;  /* S3EN11           */
    uint32 S3EN12 : 1;  /* S3EN12           */
    uint32 S3EN13 : 1;  /* S3EN13           */
    uint32 S3EN14 : 1;  /* S3EN14           */
    uint32 S3EN15 : 1;  /* S3EN15           */
    uint32        : 16; /* Reserved Bits    */
} __type1063;
typedef struct
{                       /* Bit Access       */
    uint32 S3DS0  : 1;  /* S3DS0            */
    uint32 S3DS1  : 1;  /* S3DS1            */
    uint32 S3DS2  : 1;  /* S3DS2            */
    uint32 S3DS3  : 1;  /* S3DS3            */
    uint32 S3DS4  : 1;  /* S3DS4            */
    uint32 S3DS5  : 1;  /* S3DS5            */
    uint32 S3DS6  : 1;  /* S3DS6            */
    uint32 S3DS7  : 1;  /* S3DS7            */
    uint32 S3DS8  : 1;  /* S3DS8            */
    uint32 S3DS9  : 1;  /* S3DS9            */
    uint32 S3DS10 : 1;  /* S3DS10           */
    uint32 S3DS11 : 1;  /* S3DS11           */
    uint32 S3DS12 : 1;  /* S3DS12           */
    uint32 S3DS13 : 1;  /* S3DS13           */
    uint32 S3DS14 : 1;  /* S3DS14           */
    uint32 S3DS15 : 1;  /* S3DS15           */
    uint32        : 16; /* Reserved Bits    */
} __type1064;
typedef struct
{                      /* Bit Access       */
    uint32 S3UP0 : 1;  /* S3UP0            */
    uint32 S3UP1 : 1;  /* S3UP1            */
    uint32       : 30; /* Reserved Bits    */
} __type1065;
typedef struct
{                        /* Bit Access       */
    uint32 S3BYP   : 1;  /* S3BYP            */
    uint32         : 15; /* Reserved Bits    */
    uint32 S3BPROT : 16; /* S3BPROT[31:16]   */
} __type1066;
typedef struct
{                  /* Bit Access       */
    uint16 VD : 1; /* VD               */
    uint16 RD : 1; /* RD               */
    uint16 WR : 1; /* WR               */
    uint16 EX : 1; /* EX               */
    uint16 DS : 4; /* DS[7:4]          */
    uint16    : 8; /* Reserved Bits    */
} __type1067;
typedef struct
{                     /* Bit Access       */
    uint32 EADR : 32; /* EADR[31:0]       */
} __type1068;
typedef struct
{                  /* Bit Access       */
    uint8 E   : 1; /* E                */
    uint8 IRE : 1; /* IRE              */
    uint8     : 6; /* Reserved Bits    */
} __type1069;
typedef struct
{                 /* Bit Access       */
    uint8    : 4; /* Reserved Bits    */
    uint8 R1 : 1; /* R1               */
    uint8 W1 : 1; /* W1               */
    uint8 X1 : 1; /* X1               */
    uint8    : 1; /* Reserved Bits    */
} __type1070;
typedef struct
{                 /* Bit Access       */
    uint8 R0 : 1; /* R0               */
    uint8 W0 : 1; /* W0               */
    uint8 X0 : 1; /* X0               */
    uint8    : 5; /* Reserved Bits    */
} __type1071;
typedef struct
{                 /* Bit Access       */
    uint8 R0 : 1; /* R0               */
    uint8 W0 : 1; /* W0               */
    uint8    : 2; /* Reserved Bits    */
    uint8 R1 : 1; /* R1               */
    uint8 W1 : 1; /* W1               */
    uint8 X1 : 1; /* X1               */
    uint8    : 1; /* Reserved Bits    */
} __type1072;
typedef struct
{                   /* Bit Access       */
    uint8 SPEN : 1; /* SPEN             */
    uint8      : 7; /* Reserved Bits    */
    uint8      : 8; /* Reserved Bits    */
} __type1073;
typedef struct
{                       /* Bit Access       */
    uint8         : 8;  /* Reserved Bits    */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G0MASK : 20; /* G0MASK[31:12]    */
} __type1074;
typedef struct
{                       /* Bit Access       */
    uint8 G0EN    : 1;  /* G0EN             */
    uint8 G0RD    : 1;  /* G0RD             */
    uint8 G0WR    : 1;  /* G0WR             */
    uint8         : 1;  /* Reserved Bits    */
    uint8 G0SP0   : 1;  /* G0SP0            */
    uint8 G0SP1   : 1;  /* G0SP1            */
    uint8 G0SP2   : 1;  /* G0SP2            */
    uint8 G0SP3   : 1;  /* G0SP3            */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G0BASE : 20; /* G0BASE[31:12]    */
} __type1075;
typedef struct
{                       /* Bit Access       */
    uint8         : 8;  /* Reserved Bits    */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G1MASK : 20; /* G1MASK[31:12]    */
} __type1076;
typedef struct
{                       /* Bit Access       */
    uint8 G1EN    : 1;  /* G1EN             */
    uint8 G1RD    : 1;  /* G1RD             */
    uint8 G1WR    : 1;  /* G1WR             */
    uint8         : 1;  /* Reserved Bits    */
    uint8 G1SP0   : 1;  /* G1SP0            */
    uint8 G1SP1   : 1;  /* G1SP1            */
    uint8 G1SP2   : 1;  /* G1SP2            */
    uint8 G1SP3   : 1;  /* G1SP3            */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G1BASE : 20; /* G1BASE[31:12]    */
} __type1077;
typedef struct
{                       /* Bit Access       */
    uint8         : 8;  /* Reserved Bits    */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G2MASK : 20; /* G2MASK[31:12]    */
} __type1078;
typedef struct
{                       /* Bit Access       */
    uint8 G2EN    : 1;  /* G2EN             */
    uint8 G2RD    : 1;  /* G2RD             */
    uint8 G2WR    : 1;  /* G2WR             */
    uint8         : 1;  /* Reserved Bits    */
    uint8 G2SP0   : 1;  /* G2SP0            */
    uint8 G2SP1   : 1;  /* G2SP1            */
    uint8 G2SP2   : 1;  /* G2SP2            */
    uint8 G2SP3   : 1;  /* G2SP3            */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G2BASE : 20; /* G2BASE[31:12]    */
} __type1079;
typedef struct
{                       /* Bit Access       */
    uint8         : 8;  /* Reserved Bits    */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G3MASK : 20; /* G3MASK[31:12]    */
} __type1080;
typedef struct
{                       /* Bit Access       */
    uint8 G3EN    : 1;  /* G3EN             */
    uint8 G3RD    : 1;  /* G3RD             */
    uint8 G3WR    : 1;  /* G3WR             */
    uint8         : 1;  /* Reserved Bits    */
    uint8 G3SP0   : 1;  /* G3SP0            */
    uint8 G3SP1   : 1;  /* G3SP1            */
    uint8 G3SP2   : 1;  /* G3SP2            */
    uint8 G3SP3   : 1;  /* G3SP3            */
    uint8         : 4;  /* Reserved Bits    */
    uint32 G3BASE : 20; /* G3BASE[31:12]    */
} __type1081;
typedef struct
{                    /* Bit Access       */
    uint16      : 2; /* Reserved Bits    */
    uint16 ICCE : 1; /* ICCE             */
    uint16      : 1; /* Reserved Bits    */
    uint16 VCIE : 1; /* VCIE             */
    uint16 ROME : 1; /* ROME             */
    uint16 TCME : 1; /* TCME             */
    uint16      : 1; /* Reserved Bits    */
    uint16 VCRE : 1; /* VCRE             */
    uint16 VPGE : 1; /* VPGE             */
    uint16      : 6; /* Reserved Bits    */
} __type1082;
typedef struct
{                    /* Bit Access       */
    uint16      : 2; /* Reserved Bits    */
    uint16 ICCF : 1; /* ICCF             */
    uint16      : 1; /* Reserved Bits    */
    uint16 VCIF : 1; /* VCIF             */
    uint16 ROMF : 1; /* ROMF             */
    uint16 TCMF : 1; /* TCMF             */
    uint16      : 1; /* Reserved Bits    */
    uint16 VCRF : 1; /* VCRF             */
    uint16 VPGF : 1; /* VPGF             */
    uint16      : 6; /* Reserved Bits    */
} __type1083;
typedef struct
{                        /* Bit Access       */
    uint32 ADDRESS : 32; /* ADDRESS[31:0]    */
} __type1084;
typedef struct
{                          /* Bit Access       */
    uint8 EIP0        : 4; /* EIP0[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB0       : 1; /* EITB0            */
    uint8 EIMK0       : 1; /* EIMK0            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF0       : 1; /* EIRF0            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT0 : 1; /* EICT0            */
} __type1085;
typedef struct
{                          /* Bit Access       */
    uint8 EIP1        : 4; /* EIP1[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB1       : 1; /* EITB1            */
    uint8 EIMK1       : 1; /* EIMK1            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF1       : 1; /* EIRF1            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT1 : 1; /* EICT1            */
} __type1086;
typedef struct
{                          /* Bit Access       */
    uint8 EIP2        : 4; /* EIP2[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB2       : 1; /* EITB2            */
    uint8 EIMK2       : 1; /* EIMK2            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF2       : 1; /* EIRF2            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT2 : 1; /* EICT2            */
} __type1087;
typedef struct
{                          /* Bit Access       */
    uint8 EIP3        : 4; /* EIP3[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB3       : 1; /* EITB3            */
    uint8 EIMK3       : 1; /* EIMK3            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF3       : 1; /* EIRF3            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT3 : 1; /* EICT3            */
} __type1088;
typedef struct
{                          /* Bit Access       */
    uint8 EIP4        : 4; /* EIP4[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB4       : 1; /* EITB4            */
    uint8 EIMK4       : 1; /* EIMK4            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF4       : 1; /* EIRF4            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT4 : 1; /* EICT4            */
} __type1089;
typedef struct
{                          /* Bit Access       */
    uint8 EIP5        : 4; /* EIP5[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB5       : 1; /* EITB5            */
    uint8 EIMK5       : 1; /* EIMK5            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF5       : 1; /* EIRF5            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT5 : 1; /* EICT5            */
} __type1090;
typedef struct
{                          /* Bit Access       */
    uint8 EIP6        : 4; /* EIP6[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB6       : 1; /* EITB6            */
    uint8 EIMK6       : 1; /* EIMK6            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF6       : 1; /* EIRF6            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT6 : 1; /* EICT6            */
} __type1091;
typedef struct
{                          /* Bit Access       */
    uint8 EIP7        : 4; /* EIP7[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB7       : 1; /* EITB7            */
    uint8 EIMK7       : 1; /* EIMK7            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF7       : 1; /* EIRF7            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT7 : 1; /* EICT7            */
} __type1092;
typedef struct
{                          /* Bit Access       */
    uint8 EIP8        : 4; /* EIP8[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB8       : 1; /* EITB8            */
    uint8 EIMK8       : 1; /* EIMK8            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF8       : 1; /* EIRF8            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT8 : 1; /* EICT8            */
} __type1093;
typedef struct
{                          /* Bit Access       */
    uint8 EIP9        : 4; /* EIP9[3:0]        */
    uint8             : 2; /* Reserved Bits    */
    uint8 EITB9       : 1; /* EITB9            */
    uint8 EIMK9       : 1; /* EIMK9            */
    uint8             : 4; /* Reserved Bits    */
    uint8 EIRF9       : 1; /* EIRF9            */
    uint8             : 2; /* Reserved Bits    */
    const uint8 EICT9 : 1; /* EICT9            */
} __type1094;
typedef struct
{                           /* Bit Access       */
    uint8 EIP10        : 4; /* EIP10[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB10       : 1; /* EITB10           */
    uint8 EIMK10       : 1; /* EIMK10           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF10       : 1; /* EIRF10           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT10 : 1; /* EICT10           */
} __type1095;
typedef struct
{                           /* Bit Access       */
    uint8 EIP11        : 4; /* EIP11[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB11       : 1; /* EITB11           */
    uint8 EIMK11       : 1; /* EIMK11           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF11       : 1; /* EIRF11           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT11 : 1; /* EICT11           */
} __type1096;
typedef struct
{                           /* Bit Access       */
    uint8 EIP12        : 4; /* EIP12[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB12       : 1; /* EITB12           */
    uint8 EIMK12       : 1; /* EIMK12           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF12       : 1; /* EIRF12           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT12 : 1; /* EICT12           */
} __type1097;
typedef struct
{                           /* Bit Access       */
    uint8 EIP13        : 4; /* EIP13[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB13       : 1; /* EITB13           */
    uint8 EIMK13       : 1; /* EIMK13           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF13       : 1; /* EIRF13           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT13 : 1; /* EICT13           */
} __type1098;
typedef struct
{                           /* Bit Access       */
    uint8 EIP14        : 4; /* EIP14[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB14       : 1; /* EITB14           */
    uint8 EIMK14       : 1; /* EIMK14           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF14       : 1; /* EIRF14           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT14 : 1; /* EICT14           */
} __type1099;
typedef struct
{                           /* Bit Access       */
    uint8 EIP15        : 4; /* EIP15[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB15       : 1; /* EITB15           */
    uint8 EIMK15       : 1; /* EIMK15           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF15       : 1; /* EIRF15           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT15 : 1; /* EICT15           */
} __type1100;
typedef struct
{                           /* Bit Access       */
    uint8 EIP16        : 4; /* EIP16[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB16       : 1; /* EITB16           */
    uint8 EIMK16       : 1; /* EIMK16           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF16       : 1; /* EIRF16           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT16 : 1; /* EICT16           */
} __type1101;
typedef struct
{                           /* Bit Access       */
    uint8 EIP17        : 4; /* EIP17[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB17       : 1; /* EITB17           */
    uint8 EIMK17       : 1; /* EIMK17           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF17       : 1; /* EIRF17           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT17 : 1; /* EICT17           */
} __type1102;
typedef struct
{                           /* Bit Access       */
    uint8 EIP18        : 4; /* EIP18[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB18       : 1; /* EITB18           */
    uint8 EIMK18       : 1; /* EIMK18           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF18       : 1; /* EIRF18           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT18 : 1; /* EICT18           */
} __type1103;
typedef struct
{                           /* Bit Access       */
    uint8 EIP19        : 4; /* EIP19[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB19       : 1; /* EITB19           */
    uint8 EIMK19       : 1; /* EIMK19           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF19       : 1; /* EIRF19           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT19 : 1; /* EICT19           */
} __type1104;
typedef struct
{                           /* Bit Access       */
    uint8 EIP20        : 4; /* EIP20[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB20       : 1; /* EITB20           */
    uint8 EIMK20       : 1; /* EIMK20           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF20       : 1; /* EIRF20           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT20 : 1; /* EICT20           */
} __type1105;
typedef struct
{                           /* Bit Access       */
    uint8 EIP21        : 4; /* EIP21[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB21       : 1; /* EITB21           */
    uint8 EIMK21       : 1; /* EIMK21           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF21       : 1; /* EIRF21           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT21 : 1; /* EICT21           */
} __type1106;
typedef struct
{                           /* Bit Access       */
    uint8 EIP22        : 4; /* EIP22[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB22       : 1; /* EITB22           */
    uint8 EIMK22       : 1; /* EIMK22           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF22       : 1; /* EIRF22           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT22 : 1; /* EICT22           */
} __type1107;
typedef struct
{                           /* Bit Access       */
    uint8 EIP23        : 4; /* EIP23[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB23       : 1; /* EITB23           */
    uint8 EIMK23       : 1; /* EIMK23           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF23       : 1; /* EIRF23           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT23 : 1; /* EICT23           */
} __type1108;
typedef struct
{                           /* Bit Access       */
    uint8 EIP24        : 4; /* EIP24[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB24       : 1; /* EITB24           */
    uint8 EIMK24       : 1; /* EIMK24           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF24       : 1; /* EIRF24           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT24 : 1; /* EICT24           */
} __type1109;
typedef struct
{                           /* Bit Access       */
    uint8 EIP25        : 4; /* EIP25[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB25       : 1; /* EITB25           */
    uint8 EIMK25       : 1; /* EIMK25           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF25       : 1; /* EIRF25           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT25 : 1; /* EICT25           */
} __type1110;
typedef struct
{                           /* Bit Access       */
    uint8 EIP26        : 4; /* EIP26[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB26       : 1; /* EITB26           */
    uint8 EIMK26       : 1; /* EIMK26           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF26       : 1; /* EIRF26           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT26 : 1; /* EICT26           */
} __type1111;
typedef struct
{                           /* Bit Access       */
    uint8 EIP27        : 4; /* EIP27[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB27       : 1; /* EITB27           */
    uint8 EIMK27       : 1; /* EIMK27           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF27       : 1; /* EIRF27           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT27 : 1; /* EICT27           */
} __type1112;
typedef struct
{                           /* Bit Access       */
    uint8 EIP28        : 4; /* EIP28[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB28       : 1; /* EITB28           */
    uint8 EIMK28       : 1; /* EIMK28           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF28       : 1; /* EIRF28           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT28 : 1; /* EICT28           */
} __type1113;
typedef struct
{                           /* Bit Access       */
    uint8 EIP29        : 4; /* EIP29[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB29       : 1; /* EITB29           */
    uint8 EIMK29       : 1; /* EIMK29           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF29       : 1; /* EIRF29           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT29 : 1; /* EICT29           */
} __type1114;
typedef struct
{                           /* Bit Access       */
    uint8 EIP30        : 4; /* EIP30[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB30       : 1; /* EITB30           */
    uint8 EIMK30       : 1; /* EIMK30           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF30       : 1; /* EIRF30           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT30 : 1; /* EICT30           */
} __type1115;
typedef struct
{                           /* Bit Access       */
    uint8 EIP31        : 4; /* EIP31[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB31       : 1; /* EITB31           */
    uint8 EIMK31       : 1; /* EIMK31           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF31       : 1; /* EIRF31           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT31 : 1; /* EICT31           */
} __type1116;
typedef struct
{                         /* Bit Access       */
    uint8            : 8; /* Reserved Bits    */
    uint8            : 4; /* Reserved Bits    */
    const uint8 FNRF : 1; /* FNRF             */
    uint8            : 3; /* Reserved Bits    */
} __type1117;
typedef struct
{                         /* Bit Access       */
    uint8            : 8; /* Reserved Bits    */
    uint8            : 4; /* Reserved Bits    */
    const uint8 FIRF : 1; /* FIRF             */
    uint8            : 3; /* Reserved Bits    */
} __type1118;
typedef struct
{                     /* Bit Access       */
    uint8 EIMK0  : 1; /* EIMK0            */
    uint8 EIMK1  : 1; /* EIMK1            */
    uint8 EIMK2  : 1; /* EIMK2            */
    uint8 EIMK3  : 1; /* EIMK3            */
    uint8 EIMK4  : 1; /* EIMK4            */
    uint8 EIMK5  : 1; /* EIMK5            */
    uint8 EIMK6  : 1; /* EIMK6            */
    uint8 EIMK7  : 1; /* EIMK7            */
    uint8 EIMK8  : 1; /* EIMK8            */
    uint8 EIMK9  : 1; /* EIMK9            */
    uint8 EIMK10 : 1; /* EIMK10           */
    uint8 EIMK11 : 1; /* EIMK11           */
    uint8 EIMK12 : 1; /* EIMK12           */
    uint8 EIMK13 : 1; /* EIMK13           */
    uint8 EIMK14 : 1; /* EIMK14           */
    uint8 EIMK15 : 1; /* EIMK15           */
    uint8 EIMK16 : 1; /* EIMK16           */
    uint8 EIMK17 : 1; /* EIMK17           */
    uint8 EIMK18 : 1; /* EIMK18           */
    uint8 EIMK19 : 1; /* EIMK19           */
    uint8 EIMK20 : 1; /* EIMK20           */
    uint8 EIMK21 : 1; /* EIMK21           */
    uint8 EIMK22 : 1; /* EIMK22           */
    uint8 EIMK23 : 1; /* EIMK23           */
    uint8 EIMK24 : 1; /* EIMK24           */
    uint8 EIMK25 : 1; /* EIMK25           */
    uint8 EIMK26 : 1; /* EIMK26           */
    uint8 EIMK27 : 1; /* EIMK27           */
    uint8 EIMK28 : 1; /* EIMK28           */
    uint8 EIMK29 : 1; /* EIMK29           */
    uint8 EIMK30 : 1; /* EIMK30           */
    uint8 EIMK31 : 1; /* EIMK31           */
} __type1119;
typedef struct
{                    /* Bit Access       */
    uint32 KEY : 8;  /* KEY[7:0]         */
    uint32     : 24; /* Reserved Bits    */
} __type1120;
typedef struct
{                       /* Bit Access       */
    uint32        : 11; /* Reserved Bits    */
    uint32 MASK11 : 1;  /* MASK11           */
    uint32 MASK12 : 1;  /* MASK12           */
    uint32        : 19; /* Reserved Bits    */
} __type1121;
typedef struct
{                      /* Bit Access       */
    uint32       : 11; /* Reserved Bits    */
    uint32 FLG11 : 1;  /* FLG11            */
    uint32 FLG12 : 1;  /* FLG12            */
    uint32       : 19; /* Reserved Bits    */
} __type1122;
typedef struct
{                      /* Bit Access       */
    uint32       : 11; /* Reserved Bits    */
    uint32 CLR11 : 1;  /* CLR11            */
    uint32 CLR12 : 1;  /* CLR12            */
    uint32       : 19; /* Reserved Bits    */
} __type1123;
typedef struct
{                            /* Bit Access       */
    const uint32 ECODE : 7;  /* ECODE[6:0]       */
    uint32             : 25; /* Reserved Bits    */
} __type1124;
typedef struct
{                     /* Bit Access       */
    uint32 VCID : 7;  /* VCID[6:0]        */
    uint32      : 25; /* Reserved Bits    */
} __type1125;
typedef struct
{                       /* Bit Access       */
    uint32 DMASPD : 1;  /* DMASPD           */
    uint32        : 31; /* Reserved Bits    */
} __type1126;
typedef struct
{                            /* Bit Access       */
    const uint32 DM0ER : 8;  /* DM0ER[7:0]       */
    const uint32 DM1ER : 8;  /* DM1ER[15:8]      */
    uint32             : 16; /* Reserved Bits    */
} __type1127;
typedef struct
{                           /* Bit Access       */
    const uint32 VF   : 1;  /* VF               */
    uint32            : 3;  /* Reserved Bits    */
    const uint32 VCH  : 3;  /* VCH[6:4]         */
    uint32            : 10; /* Reserved Bits    */
    const uint32 MINF : 6;  /* MINF[22:17]      */
    uint32            : 9;  /* Reserved Bits    */
} __type1128;
typedef struct
{                      /* Bit Access       */
    uint32 DM0VC : 1;  /* DM0VC            */
    uint32 DM1VC : 1;  /* DM1VC            */
    uint32       : 30; /* Reserved Bits    */
} __type1129;
typedef struct
{                     /* Bit Access       */
    uint32 VM   : 1;  /* VM               */
    uint32 UM   : 1;  /* UM               */
    uint32 SPID : 2;  /* SPID[3:2]        */
    uint32 PEID : 3;  /* PEID[6:4]        */
    uint32      : 25; /* Reserved Bits    */
} __type1130;
typedef struct
{                   /* Bit Access       */
    uint32 SA : 32; /* SA[31:0]         */
} __type1131;
typedef struct
{                   /* Bit Access       */
    uint32 DA : 32; /* DA[31:0]         */
} __type1132;
typedef struct
{                    /* Bit Access       */
    uint32 TRC : 16; /* TRC[15:0]        */
    uint32 ARC : 16; /* ARC[31:16]       */
} __type1133;
typedef struct
{                      /* Bit Access       */
    uint32 TRM    : 2; /* TRM[1:0]         */
    uint32 DS     : 3; /* DS[4:2]          */
    uint32 SACM   : 2; /* SACM[6:5]        */
    uint32 DACM   : 2; /* DACM[8:7]        */
    uint32 RLD1M  : 2; /* RLD1M[10:9]      */
    uint32 RLD2M  : 2; /* RLD2M[12:11]     */
    uint32 MLE    : 1; /* MLE              */
    uint32 TCE    : 1; /* TCE              */
    uint32 CCE    : 1; /* CCE              */
    uint32 CHNE   : 2; /* CHNE[17:16]      */
    uint32 CHNSEL : 3; /* CHNSEL[20:18]    */
    uint32        : 5; /* Reserved Bits    */
    uint32 DRS    : 1; /* DRS              */
    uint32 ESE    : 1; /* ESE              */
    uint32        : 4; /* Reserved Bits    */
} __type1134;
typedef struct
{                    /* Bit Access       */
    uint32 RSA : 32; /* RSA[31:0]        */
} __type1135;
typedef struct
{                    /* Bit Access       */
    uint32 RDA : 32; /* RDA[31:0]        */
} __type1136;
typedef struct
{                     /* Bit Access       */
    uint32 RTRC : 16; /* RTRC[15:0]       */
    uint32 RARC : 16; /* RARC[31:16]      */
} __type1137;
typedef struct
{                    /* Bit Access       */
    uint32 CMC : 16; /* CMC[15:0]        */
    uint32     : 16; /* Reserved Bits    */
} __type1138;
typedef struct
{                    /* Bit Access       */
    uint32 DTE : 1;  /* DTE              */
    uint32     : 31; /* Reserved Bits    */
} __type1139;
typedef struct
{                           /* Bit Access       */
    const uint32 SR   : 1;  /* SR               */
    const uint32 DR   : 1;  /* DR               */
    uint32            : 2;  /* Reserved Bits    */
    const uint32 TC   : 1;  /* TC               */
    const uint32 CC   : 1;  /* CC               */
    uint32            : 1;  /* Reserved Bits    */
    const uint32 ER   : 1;  /* ER               */
    const uint32 CY   : 1;  /* CY               */
    uint32            : 2;  /* Reserved Bits    */
    const uint32 ERWR : 1;  /* ERWR             */
    uint32            : 20; /* Reserved Bits    */
} __type1140;
typedef struct
{                    /* Bit Access       */
    uint32 SRS : 1;  /* SRS              */
    uint32     : 31; /* Reserved Bits    */
} __type1141;
typedef struct
{                    /* Bit Access       */
    uint32 SRC : 1;  /* SRC              */
    uint32     : 3;  /* Reserved Bits    */
    uint32 TCC : 1;  /* TCC              */
    uint32 CCC : 1;  /* CCC              */
    uint32     : 1;  /* Reserved Bits    */
    uint32 ERC : 1;  /* ERC              */
    uint32     : 24; /* Reserved Bits    */
} __type1142;
typedef struct
{                       /* Bit Access       */
    uint32 REQEN  : 1;  /* REQEN            */
    uint32 REQSEL : 7;  /* REQSEL[7:1]      */
    uint32        : 24; /* Reserved Bits    */
} __type1143;
typedef struct
{                          /* Bit Access       */
    const uint32 DRQ : 1;  /* DRQ              */
    uint32           : 31; /* Reserved Bits    */
} __type1144;
typedef struct
{                     /* Bit Access       */
    uint32 DRQC : 1;  /* DRQC             */
    uint32      : 31; /* Reserved Bits    */
} __type1145;
typedef struct
{                           /* Bit Access       */
    uint8 EIP32        : 4; /* EIP32[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB32       : 1; /* EITB32           */
    uint8 EIMK32       : 1; /* EIMK32           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF32       : 1; /* EIRF32           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT32 : 1; /* EICT32           */
} __type1146;
typedef struct
{                           /* Bit Access       */
    uint8 EIP33        : 4; /* EIP33[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB33       : 1; /* EITB33           */
    uint8 EIMK33       : 1; /* EIMK33           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF33       : 1; /* EIRF33           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT33 : 1; /* EICT33           */
} __type1147;
typedef struct
{                           /* Bit Access       */
    uint8 EIP34        : 4; /* EIP34[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB34       : 1; /* EITB34           */
    uint8 EIMK34       : 1; /* EIMK34           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF34       : 1; /* EIRF34           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT34 : 1; /* EICT34           */
} __type1148;
typedef struct
{                           /* Bit Access       */
    uint8 EIP35        : 4; /* EIP35[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB35       : 1; /* EITB35           */
    uint8 EIMK35       : 1; /* EIMK35           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF35       : 1; /* EIRF35           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT35 : 1; /* EICT35           */
} __type1149;
typedef struct
{                           /* Bit Access       */
    uint8 EIP36        : 4; /* EIP36[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB36       : 1; /* EITB36           */
    uint8 EIMK36       : 1; /* EIMK36           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF36       : 1; /* EIRF36           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT36 : 1; /* EICT36           */
} __type1150;
typedef struct
{                           /* Bit Access       */
    uint8 EIP37        : 4; /* EIP37[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB37       : 1; /* EITB37           */
    uint8 EIMK37       : 1; /* EIMK37           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF37       : 1; /* EIRF37           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT37 : 1; /* EICT37           */
} __type1151;
typedef struct
{                           /* Bit Access       */
    uint8 EIP38        : 4; /* EIP38[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB38       : 1; /* EITB38           */
    uint8 EIMK38       : 1; /* EIMK38           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF38       : 1; /* EIRF38           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT38 : 1; /* EICT38           */
} __type1152;
typedef struct
{                           /* Bit Access       */
    uint8 EIP39        : 4; /* EIP39[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB39       : 1; /* EITB39           */
    uint8 EIMK39       : 1; /* EIMK39           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF39       : 1; /* EIRF39           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT39 : 1; /* EICT39           */
} __type1153;
typedef struct
{                           /* Bit Access       */
    uint8 EIP40        : 4; /* EIP40[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB40       : 1; /* EITB40           */
    uint8 EIMK40       : 1; /* EIMK40           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF40       : 1; /* EIRF40           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT40 : 1; /* EICT40           */
} __type1154;
typedef struct
{                           /* Bit Access       */
    uint8 EIP41        : 4; /* EIP41[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB41       : 1; /* EITB41           */
    uint8 EIMK41       : 1; /* EIMK41           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF41       : 1; /* EIRF41           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT41 : 1; /* EICT41           */
} __type1155;
typedef struct
{                           /* Bit Access       */
    uint8 EIP42        : 4; /* EIP42[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB42       : 1; /* EITB42           */
    uint8 EIMK42       : 1; /* EIMK42           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF42       : 1; /* EIRF42           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT42 : 1; /* EICT42           */
} __type1156;
typedef struct
{                           /* Bit Access       */
    uint8 EIP43        : 4; /* EIP43[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB43       : 1; /* EITB43           */
    uint8 EIMK43       : 1; /* EIMK43           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF43       : 1; /* EIRF43           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT43 : 1; /* EICT43           */
} __type1157;
typedef struct
{                           /* Bit Access       */
    uint8 EIP44        : 4; /* EIP44[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB44       : 1; /* EITB44           */
    uint8 EIMK44       : 1; /* EIMK44           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF44       : 1; /* EIRF44           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT44 : 1; /* EICT44           */
} __type1158;
typedef struct
{                           /* Bit Access       */
    uint8 EIP45        : 4; /* EIP45[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB45       : 1; /* EITB45           */
    uint8 EIMK45       : 1; /* EIMK45           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF45       : 1; /* EIRF45           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT45 : 1; /* EICT45           */
} __type1159;
typedef struct
{                           /* Bit Access       */
    uint8 EIP46        : 4; /* EIP46[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB46       : 1; /* EITB46           */
    uint8 EIMK46       : 1; /* EIMK46           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF46       : 1; /* EIRF46           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT46 : 1; /* EICT46           */
} __type1160;
typedef struct
{                           /* Bit Access       */
    uint8 EIP47        : 4; /* EIP47[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB47       : 1; /* EITB47           */
    uint8 EIMK47       : 1; /* EIMK47           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF47       : 1; /* EIRF47           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT47 : 1; /* EICT47           */
} __type1161;
typedef struct
{                           /* Bit Access       */
    uint8 EIP48        : 4; /* EIP48[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB48       : 1; /* EITB48           */
    uint8 EIMK48       : 1; /* EIMK48           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF48       : 1; /* EIRF48           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT48 : 1; /* EICT48           */
} __type1162;
typedef struct
{                           /* Bit Access       */
    uint8 EIP49        : 4; /* EIP49[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB49       : 1; /* EITB49           */
    uint8 EIMK49       : 1; /* EIMK49           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF49       : 1; /* EIRF49           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT49 : 1; /* EICT49           */
} __type1163;
typedef struct
{                           /* Bit Access       */
    uint8 EIP50        : 4; /* EIP50[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB50       : 1; /* EITB50           */
    uint8 EIMK50       : 1; /* EIMK50           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF50       : 1; /* EIRF50           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT50 : 1; /* EICT50           */
} __type1164;
typedef struct
{                           /* Bit Access       */
    uint8 EIP51        : 4; /* EIP51[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB51       : 1; /* EITB51           */
    uint8 EIMK51       : 1; /* EIMK51           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF51       : 1; /* EIRF51           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT51 : 1; /* EICT51           */
} __type1165;
typedef struct
{                           /* Bit Access       */
    uint8 EIP52        : 4; /* EIP52[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB52       : 1; /* EITB52           */
    uint8 EIMK52       : 1; /* EIMK52           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF52       : 1; /* EIRF52           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT52 : 1; /* EICT52           */
} __type1166;
typedef struct
{                           /* Bit Access       */
    uint8 EIP53        : 4; /* EIP53[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB53       : 1; /* EITB53           */
    uint8 EIMK53       : 1; /* EIMK53           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF53       : 1; /* EIRF53           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT53 : 1; /* EICT53           */
} __type1167;
typedef struct
{                           /* Bit Access       */
    uint8 EIP54        : 4; /* EIP54[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB54       : 1; /* EITB54           */
    uint8 EIMK54       : 1; /* EIMK54           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF54       : 1; /* EIRF54           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT54 : 1; /* EICT54           */
} __type1168;
typedef struct
{                           /* Bit Access       */
    uint8 EIP55        : 4; /* EIP55[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB55       : 1; /* EITB55           */
    uint8 EIMK55       : 1; /* EIMK55           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF55       : 1; /* EIRF55           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT55 : 1; /* EICT55           */
} __type1169;
typedef struct
{                           /* Bit Access       */
    uint8 EIP56        : 4; /* EIP56[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB56       : 1; /* EITB56           */
    uint8 EIMK56       : 1; /* EIMK56           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF56       : 1; /* EIRF56           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT56 : 1; /* EICT56           */
} __type1170;
typedef struct
{                           /* Bit Access       */
    uint8 EIP57        : 4; /* EIP57[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB57       : 1; /* EITB57           */
    uint8 EIMK57       : 1; /* EIMK57           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF57       : 1; /* EIRF57           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT57 : 1; /* EICT57           */
} __type1171;
typedef struct
{                           /* Bit Access       */
    uint8 EIP58        : 4; /* EIP58[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB58       : 1; /* EITB58           */
    uint8 EIMK58       : 1; /* EIMK58           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF58       : 1; /* EIRF58           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT58 : 1; /* EICT58           */
} __type1172;
typedef struct
{                           /* Bit Access       */
    uint8 EIP59        : 4; /* EIP59[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB59       : 1; /* EITB59           */
    uint8 EIMK59       : 1; /* EIMK59           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF59       : 1; /* EIRF59           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT59 : 1; /* EICT59           */
} __type1173;
typedef struct
{                           /* Bit Access       */
    uint8 EIP60        : 4; /* EIP60[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB60       : 1; /* EITB60           */
    uint8 EIMK60       : 1; /* EIMK60           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF60       : 1; /* EIRF60           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT60 : 1; /* EICT60           */
} __type1174;
typedef struct
{                           /* Bit Access       */
    uint8 EIP61        : 4; /* EIP61[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB61       : 1; /* EITB61           */
    uint8 EIMK61       : 1; /* EIMK61           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF61       : 1; /* EIRF61           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT61 : 1; /* EICT61           */
} __type1175;
typedef struct
{                           /* Bit Access       */
    uint8 EIP62        : 4; /* EIP62[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB62       : 1; /* EITB62           */
    uint8 EIMK62       : 1; /* EIMK62           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF62       : 1; /* EIRF62           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT62 : 1; /* EICT62           */
} __type1176;
typedef struct
{                           /* Bit Access       */
    uint8 EIP63        : 4; /* EIP63[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB63       : 1; /* EITB63           */
    uint8 EIMK63       : 1; /* EIMK63           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF63       : 1; /* EIRF63           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT63 : 1; /* EICT63           */
} __type1177;
typedef struct
{                           /* Bit Access       */
    uint8 EIP64        : 4; /* EIP64[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB64       : 1; /* EITB64           */
    uint8 EIMK64       : 1; /* EIMK64           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF64       : 1; /* EIRF64           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT64 : 1; /* EICT64           */
} __type1178;
typedef struct
{                           /* Bit Access       */
    uint8 EIP65        : 4; /* EIP65[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB65       : 1; /* EITB65           */
    uint8 EIMK65       : 1; /* EIMK65           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF65       : 1; /* EIRF65           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT65 : 1; /* EICT65           */
} __type1179;
typedef struct
{                           /* Bit Access       */
    uint8 EIP66        : 4; /* EIP66[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB66       : 1; /* EITB66           */
    uint8 EIMK66       : 1; /* EIMK66           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF66       : 1; /* EIRF66           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT66 : 1; /* EICT66           */
} __type1180;
typedef struct
{                           /* Bit Access       */
    uint8 EIP67        : 4; /* EIP67[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB67       : 1; /* EITB67           */
    uint8 EIMK67       : 1; /* EIMK67           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF67       : 1; /* EIRF67           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT67 : 1; /* EICT67           */
} __type1181;
typedef struct
{                           /* Bit Access       */
    uint8 EIP68        : 4; /* EIP68[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB68       : 1; /* EITB68           */
    uint8 EIMK68       : 1; /* EIMK68           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF68       : 1; /* EIRF68           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT68 : 1; /* EICT68           */
} __type1182;
typedef struct
{                           /* Bit Access       */
    uint8 EIP69        : 4; /* EIP69[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB69       : 1; /* EITB69           */
    uint8 EIMK69       : 1; /* EIMK69           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF69       : 1; /* EIRF69           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT69 : 1; /* EICT69           */
} __type1183;
typedef struct
{                           /* Bit Access       */
    uint8 EIP70        : 4; /* EIP70[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB70       : 1; /* EITB70           */
    uint8 EIMK70       : 1; /* EIMK70           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF70       : 1; /* EIRF70           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT70 : 1; /* EICT70           */
} __type1184;
typedef struct
{                           /* Bit Access       */
    uint8 EIP71        : 4; /* EIP71[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB71       : 1; /* EITB71           */
    uint8 EIMK71       : 1; /* EIMK71           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF71       : 1; /* EIRF71           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT71 : 1; /* EICT71           */
} __type1185;
typedef struct
{                           /* Bit Access       */
    uint8 EIP72        : 4; /* EIP72[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB72       : 1; /* EITB72           */
    uint8 EIMK72       : 1; /* EIMK72           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF72       : 1; /* EIRF72           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT72 : 1; /* EICT72           */
} __type1186;
typedef struct
{                           /* Bit Access       */
    uint8 EIP73        : 4; /* EIP73[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB73       : 1; /* EITB73           */
    uint8 EIMK73       : 1; /* EIMK73           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF73       : 1; /* EIRF73           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT73 : 1; /* EICT73           */
} __type1187;
typedef struct
{                           /* Bit Access       */
    uint8 EIP74        : 4; /* EIP74[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB74       : 1; /* EITB74           */
    uint8 EIMK74       : 1; /* EIMK74           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF74       : 1; /* EIRF74           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT74 : 1; /* EICT74           */
} __type1188;
typedef struct
{                           /* Bit Access       */
    uint8 EIP75        : 4; /* EIP75[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB75       : 1; /* EITB75           */
    uint8 EIMK75       : 1; /* EIMK75           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF75       : 1; /* EIRF75           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT75 : 1; /* EICT75           */
} __type1189;
typedef struct
{                           /* Bit Access       */
    uint8 EIP76        : 4; /* EIP76[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB76       : 1; /* EITB76           */
    uint8 EIMK76       : 1; /* EIMK76           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF76       : 1; /* EIRF76           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT76 : 1; /* EICT76           */
} __type1190;
typedef struct
{                           /* Bit Access       */
    uint8 EIP77        : 4; /* EIP77[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB77       : 1; /* EITB77           */
    uint8 EIMK77       : 1; /* EIMK77           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF77       : 1; /* EIRF77           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT77 : 1; /* EICT77           */
} __type1191;
typedef struct
{                           /* Bit Access       */
    uint8 EIP78        : 4; /* EIP78[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB78       : 1; /* EITB78           */
    uint8 EIMK78       : 1; /* EIMK78           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF78       : 1; /* EIRF78           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT78 : 1; /* EICT78           */
} __type1192;
typedef struct
{                           /* Bit Access       */
    uint8 EIP79        : 4; /* EIP79[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB79       : 1; /* EITB79           */
    uint8 EIMK79       : 1; /* EIMK79           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF79       : 1; /* EIRF79           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT79 : 1; /* EICT79           */
} __type1193;
typedef struct
{                           /* Bit Access       */
    uint8 EIP80        : 4; /* EIP80[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB80       : 1; /* EITB80           */
    uint8 EIMK80       : 1; /* EIMK80           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF80       : 1; /* EIRF80           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT80 : 1; /* EICT80           */
} __type1194;
typedef struct
{                           /* Bit Access       */
    uint8 EIP81        : 4; /* EIP81[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB81       : 1; /* EITB81           */
    uint8 EIMK81       : 1; /* EIMK81           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF81       : 1; /* EIRF81           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT81 : 1; /* EICT81           */
} __type1195;
typedef struct
{                           /* Bit Access       */
    uint8 EIP82        : 4; /* EIP82[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB82       : 1; /* EITB82           */
    uint8 EIMK82       : 1; /* EIMK82           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF82       : 1; /* EIRF82           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT82 : 1; /* EICT82           */
} __type1196;
typedef struct
{                           /* Bit Access       */
    uint8 EIP83        : 4; /* EIP83[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB83       : 1; /* EITB83           */
    uint8 EIMK83       : 1; /* EIMK83           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF83       : 1; /* EIRF83           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT83 : 1; /* EICT83           */
} __type1197;
typedef struct
{                           /* Bit Access       */
    uint8 EIP84        : 4; /* EIP84[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB84       : 1; /* EITB84           */
    uint8 EIMK84       : 1; /* EIMK84           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF84       : 1; /* EIRF84           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT84 : 1; /* EICT84           */
} __type1198;
typedef struct
{                           /* Bit Access       */
    uint8 EIP85        : 4; /* EIP85[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB85       : 1; /* EITB85           */
    uint8 EIMK85       : 1; /* EIMK85           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF85       : 1; /* EIRF85           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT85 : 1; /* EICT85           */
} __type1199;
typedef struct
{                           /* Bit Access       */
    uint8 EIP86        : 4; /* EIP86[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB86       : 1; /* EITB86           */
    uint8 EIMK86       : 1; /* EIMK86           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF86       : 1; /* EIRF86           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT86 : 1; /* EICT86           */
} __type1200;
typedef struct
{                           /* Bit Access       */
    uint8 EIP87        : 4; /* EIP87[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB87       : 1; /* EITB87           */
    uint8 EIMK87       : 1; /* EIMK87           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF87       : 1; /* EIRF87           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT87 : 1; /* EICT87           */
} __type1201;
typedef struct
{                           /* Bit Access       */
    uint8 EIP88        : 4; /* EIP88[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB88       : 1; /* EITB88           */
    uint8 EIMK88       : 1; /* EIMK88           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF88       : 1; /* EIRF88           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT88 : 1; /* EICT88           */
} __type1202;
typedef struct
{                           /* Bit Access       */
    uint8 EIP89        : 4; /* EIP89[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB89       : 1; /* EITB89           */
    uint8 EIMK89       : 1; /* EIMK89           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF89       : 1; /* EIRF89           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT89 : 1; /* EICT89           */
} __type1203;
typedef struct
{                           /* Bit Access       */
    uint8 EIP90        : 4; /* EIP90[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB90       : 1; /* EITB90           */
    uint8 EIMK90       : 1; /* EIMK90           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF90       : 1; /* EIRF90           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT90 : 1; /* EICT90           */
} __type1204;
typedef struct
{                           /* Bit Access       */
    uint8 EIP91        : 4; /* EIP91[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB91       : 1; /* EITB91           */
    uint8 EIMK91       : 1; /* EIMK91           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF91       : 1; /* EIRF91           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT91 : 1; /* EICT91           */
} __type1205;
typedef struct
{                           /* Bit Access       */
    uint8 EIP92        : 4; /* EIP92[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB92       : 1; /* EITB92           */
    uint8 EIMK92       : 1; /* EIMK92           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF92       : 1; /* EIRF92           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT92 : 1; /* EICT92           */
} __type1206;
typedef struct
{                           /* Bit Access       */
    uint8 EIP93        : 4; /* EIP93[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB93       : 1; /* EITB93           */
    uint8 EIMK93       : 1; /* EIMK93           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF93       : 1; /* EIRF93           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT93 : 1; /* EICT93           */
} __type1207;
typedef struct
{                           /* Bit Access       */
    uint8 EIP94        : 4; /* EIP94[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB94       : 1; /* EITB94           */
    uint8 EIMK94       : 1; /* EIMK94           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF94       : 1; /* EIRF94           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT94 : 1; /* EICT94           */
} __type1208;
typedef struct
{                           /* Bit Access       */
    uint8 EIP95        : 4; /* EIP95[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB95       : 1; /* EITB95           */
    uint8 EIMK95       : 1; /* EIMK95           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF95       : 1; /* EIRF95           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT95 : 1; /* EICT95           */
} __type1209;
typedef struct
{                           /* Bit Access       */
    uint8 EIP96        : 4; /* EIP96[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB96       : 1; /* EITB96           */
    uint8 EIMK96       : 1; /* EIMK96           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF96       : 1; /* EIRF96           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT96 : 1; /* EICT96           */
} __type1210;
typedef struct
{                           /* Bit Access       */
    uint8 EIP97        : 4; /* EIP97[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB97       : 1; /* EITB97           */
    uint8 EIMK97       : 1; /* EIMK97           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF97       : 1; /* EIRF97           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT97 : 1; /* EICT97           */
} __type1211;
typedef struct
{                           /* Bit Access       */
    uint8 EIP98        : 4; /* EIP98[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB98       : 1; /* EITB98           */
    uint8 EIMK98       : 1; /* EIMK98           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF98       : 1; /* EIRF98           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT98 : 1; /* EICT98           */
} __type1212;
typedef struct
{                           /* Bit Access       */
    uint8 EIP99        : 4; /* EIP99[3:0]       */
    uint8              : 2; /* Reserved Bits    */
    uint8 EITB99       : 1; /* EITB99           */
    uint8 EIMK99       : 1; /* EIMK99           */
    uint8              : 4; /* Reserved Bits    */
    uint8 EIRF99       : 1; /* EIRF99           */
    uint8              : 2; /* Reserved Bits    */
    const uint8 EICT99 : 1; /* EICT99           */
} __type1213;
typedef struct
{                            /* Bit Access       */
    uint8 EIP100        : 4; /* EIP100[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB100       : 1; /* EITB100          */
    uint8 EIMK100       : 1; /* EIMK100          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF100       : 1; /* EIRF100          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT100 : 1; /* EICT100          */
} __type1214;
typedef struct
{                            /* Bit Access       */
    uint8 EIP101        : 4; /* EIP101[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB101       : 1; /* EITB101          */
    uint8 EIMK101       : 1; /* EIMK101          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF101       : 1; /* EIRF101          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT101 : 1; /* EICT101          */
} __type1215;
typedef struct
{                            /* Bit Access       */
    uint8 EIP102        : 4; /* EIP102[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB102       : 1; /* EITB102          */
    uint8 EIMK102       : 1; /* EIMK102          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF102       : 1; /* EIRF102          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT102 : 1; /* EICT102          */
} __type1216;
typedef struct
{                            /* Bit Access       */
    uint8 EIP103        : 4; /* EIP103[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB103       : 1; /* EITB103          */
    uint8 EIMK103       : 1; /* EIMK103          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF103       : 1; /* EIRF103          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT103 : 1; /* EICT103          */
} __type1217;
typedef struct
{                            /* Bit Access       */
    uint8 EIP104        : 4; /* EIP104[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB104       : 1; /* EITB104          */
    uint8 EIMK104       : 1; /* EIMK104          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF104       : 1; /* EIRF104          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT104 : 1; /* EICT104          */
} __type1218;
typedef struct
{                            /* Bit Access       */
    uint8 EIP105        : 4; /* EIP105[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB105       : 1; /* EITB105          */
    uint8 EIMK105       : 1; /* EIMK105          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF105       : 1; /* EIRF105          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT105 : 1; /* EICT105          */
} __type1219;
typedef struct
{                            /* Bit Access       */
    uint8 EIP106        : 4; /* EIP106[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB106       : 1; /* EITB106          */
    uint8 EIMK106       : 1; /* EIMK106          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF106       : 1; /* EIRF106          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT106 : 1; /* EICT106          */
} __type1220;
typedef struct
{                            /* Bit Access       */
    uint8 EIP107        : 4; /* EIP107[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB107       : 1; /* EITB107          */
    uint8 EIMK107       : 1; /* EIMK107          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF107       : 1; /* EIRF107          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT107 : 1; /* EICT107          */
} __type1221;
typedef struct
{                            /* Bit Access       */
    uint8 EIP108        : 4; /* EIP108[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB108       : 1; /* EITB108          */
    uint8 EIMK108       : 1; /* EIMK108          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF108       : 1; /* EIRF108          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT108 : 1; /* EICT108          */
} __type1222;
typedef struct
{                            /* Bit Access       */
    uint8 EIP109        : 4; /* EIP109[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB109       : 1; /* EITB109          */
    uint8 EIMK109       : 1; /* EIMK109          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF109       : 1; /* EIRF109          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT109 : 1; /* EICT109          */
} __type1223;
typedef struct
{                            /* Bit Access       */
    uint8 EIP110        : 4; /* EIP110[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB110       : 1; /* EITB110          */
    uint8 EIMK110       : 1; /* EIMK110          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF110       : 1; /* EIRF110          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT110 : 1; /* EICT110          */
} __type1224;
typedef struct
{                            /* Bit Access       */
    uint8 EIP111        : 4; /* EIP111[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB111       : 1; /* EITB111          */
    uint8 EIMK111       : 1; /* EIMK111          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF111       : 1; /* EIRF111          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT111 : 1; /* EICT111          */
} __type1225;
typedef struct
{                            /* Bit Access       */
    uint8 EIP112        : 4; /* EIP112[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB112       : 1; /* EITB112          */
    uint8 EIMK112       : 1; /* EIMK112          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF112       : 1; /* EIRF112          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT112 : 1; /* EICT112          */
} __type1226;
typedef struct
{                            /* Bit Access       */
    uint8 EIP113        : 4; /* EIP113[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB113       : 1; /* EITB113          */
    uint8 EIMK113       : 1; /* EIMK113          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF113       : 1; /* EIRF113          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT113 : 1; /* EICT113          */
} __type1227;
typedef struct
{                            /* Bit Access       */
    uint8 EIP114        : 4; /* EIP114[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB114       : 1; /* EITB114          */
    uint8 EIMK114       : 1; /* EIMK114          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF114       : 1; /* EIRF114          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT114 : 1; /* EICT114          */
} __type1228;
typedef struct
{                            /* Bit Access       */
    uint8 EIP115        : 4; /* EIP115[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB115       : 1; /* EITB115          */
    uint8 EIMK115       : 1; /* EIMK115          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF115       : 1; /* EIRF115          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT115 : 1; /* EICT115          */
} __type1229;
typedef struct
{                            /* Bit Access       */
    uint8 EIP116        : 4; /* EIP116[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB116       : 1; /* EITB116          */
    uint8 EIMK116       : 1; /* EIMK116          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF116       : 1; /* EIRF116          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT116 : 1; /* EICT116          */
} __type1230;
typedef struct
{                            /* Bit Access       */
    uint8 EIP117        : 4; /* EIP117[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB117       : 1; /* EITB117          */
    uint8 EIMK117       : 1; /* EIMK117          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF117       : 1; /* EIRF117          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT117 : 1; /* EICT117          */
} __type1231;
typedef struct
{                            /* Bit Access       */
    uint8 EIP118        : 4; /* EIP118[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB118       : 1; /* EITB118          */
    uint8 EIMK118       : 1; /* EIMK118          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF118       : 1; /* EIRF118          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT118 : 1; /* EICT118          */
} __type1232;
typedef struct
{                            /* Bit Access       */
    uint8 EIP119        : 4; /* EIP119[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB119       : 1; /* EITB119          */
    uint8 EIMK119       : 1; /* EIMK119          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF119       : 1; /* EIRF119          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT119 : 1; /* EICT119          */
} __type1233;
typedef struct
{                            /* Bit Access       */
    uint8 EIP120        : 4; /* EIP120[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB120       : 1; /* EITB120          */
    uint8 EIMK120       : 1; /* EIMK120          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF120       : 1; /* EIRF120          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT120 : 1; /* EICT120          */
} __type1234;
typedef struct
{                            /* Bit Access       */
    uint8 EIP121        : 4; /* EIP121[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB121       : 1; /* EITB121          */
    uint8 EIMK121       : 1; /* EIMK121          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF121       : 1; /* EIRF121          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT121 : 1; /* EICT121          */
} __type1235;
typedef struct
{                            /* Bit Access       */
    uint8 EIP122        : 4; /* EIP122[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB122       : 1; /* EITB122          */
    uint8 EIMK122       : 1; /* EIMK122          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF122       : 1; /* EIRF122          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT122 : 1; /* EICT122          */
} __type1236;
typedef struct
{                            /* Bit Access       */
    uint8 EIP123        : 4; /* EIP123[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB123       : 1; /* EITB123          */
    uint8 EIMK123       : 1; /* EIMK123          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF123       : 1; /* EIRF123          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT123 : 1; /* EICT123          */
} __type1237;
typedef struct
{                            /* Bit Access       */
    uint8 EIP124        : 4; /* EIP124[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB124       : 1; /* EITB124          */
    uint8 EIMK124       : 1; /* EIMK124          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF124       : 1; /* EIRF124          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT124 : 1; /* EICT124          */
} __type1238;
typedef struct
{                            /* Bit Access       */
    uint8 EIP125        : 4; /* EIP125[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB125       : 1; /* EITB125          */
    uint8 EIMK125       : 1; /* EIMK125          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF125       : 1; /* EIRF125          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT125 : 1; /* EICT125          */
} __type1239;
typedef struct
{                            /* Bit Access       */
    uint8 EIP126        : 4; /* EIP126[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB126       : 1; /* EITB126          */
    uint8 EIMK126       : 1; /* EIMK126          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF126       : 1; /* EIRF126          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT126 : 1; /* EICT126          */
} __type1240;
typedef struct
{                            /* Bit Access       */
    uint8 EIP127        : 4; /* EIP127[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB127       : 1; /* EITB127          */
    uint8 EIMK127       : 1; /* EIMK127          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF127       : 1; /* EIRF127          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT127 : 1; /* EICT127          */
} __type1241;
typedef struct
{                            /* Bit Access       */
    uint8 EIP128        : 4; /* EIP128[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB128       : 1; /* EITB128          */
    uint8 EIMK128       : 1; /* EIMK128          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF128       : 1; /* EIRF128          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT128 : 1; /* EICT128          */
} __type1242;
typedef struct
{                            /* Bit Access       */
    uint8 EIP129        : 4; /* EIP129[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB129       : 1; /* EITB129          */
    uint8 EIMK129       : 1; /* EIMK129          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF129       : 1; /* EIRF129          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT129 : 1; /* EICT129          */
} __type1243;
typedef struct
{                            /* Bit Access       */
    uint8 EIP130        : 4; /* EIP130[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB130       : 1; /* EITB130          */
    uint8 EIMK130       : 1; /* EIMK130          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF130       : 1; /* EIRF130          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT130 : 1; /* EICT130          */
} __type1244;
typedef struct
{                            /* Bit Access       */
    uint8 EIP131        : 4; /* EIP131[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB131       : 1; /* EITB131          */
    uint8 EIMK131       : 1; /* EIMK131          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF131       : 1; /* EIRF131          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT131 : 1; /* EICT131          */
} __type1245;
typedef struct
{                            /* Bit Access       */
    uint8 EIP132        : 4; /* EIP132[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB132       : 1; /* EITB132          */
    uint8 EIMK132       : 1; /* EIMK132          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF132       : 1; /* EIRF132          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT132 : 1; /* EICT132          */
} __type1246;
typedef struct
{                            /* Bit Access       */
    uint8 EIP133        : 4; /* EIP133[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB133       : 1; /* EITB133          */
    uint8 EIMK133       : 1; /* EIMK133          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF133       : 1; /* EIRF133          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT133 : 1; /* EICT133          */
} __type1247;
typedef struct
{                            /* Bit Access       */
    uint8 EIP134        : 4; /* EIP134[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB134       : 1; /* EITB134          */
    uint8 EIMK134       : 1; /* EIMK134          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF134       : 1; /* EIRF134          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT134 : 1; /* EICT134          */
} __type1248;
typedef struct
{                            /* Bit Access       */
    uint8 EIP135        : 4; /* EIP135[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB135       : 1; /* EITB135          */
    uint8 EIMK135       : 1; /* EIMK135          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF135       : 1; /* EIRF135          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT135 : 1; /* EICT135          */
} __type1249;
typedef struct
{                            /* Bit Access       */
    uint8 EIP136        : 4; /* EIP136[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB136       : 1; /* EITB136          */
    uint8 EIMK136       : 1; /* EIMK136          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF136       : 1; /* EIRF136          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT136 : 1; /* EICT136          */
} __type1250;
typedef struct
{                            /* Bit Access       */
    uint8 EIP137        : 4; /* EIP137[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB137       : 1; /* EITB137          */
    uint8 EIMK137       : 1; /* EIMK137          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF137       : 1; /* EIRF137          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT137 : 1; /* EICT137          */
} __type1251;
typedef struct
{                            /* Bit Access       */
    uint8 EIP138        : 4; /* EIP138[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB138       : 1; /* EITB138          */
    uint8 EIMK138       : 1; /* EIMK138          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF138       : 1; /* EIRF138          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT138 : 1; /* EICT138          */
} __type1252;
typedef struct
{                            /* Bit Access       */
    uint8 EIP139        : 4; /* EIP139[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB139       : 1; /* EITB139          */
    uint8 EIMK139       : 1; /* EIMK139          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF139       : 1; /* EIRF139          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT139 : 1; /* EICT139          */
} __type1253;
typedef struct
{                            /* Bit Access       */
    uint8 EIP140        : 4; /* EIP140[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB140       : 1; /* EITB140          */
    uint8 EIMK140       : 1; /* EIMK140          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF140       : 1; /* EIRF140          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT140 : 1; /* EICT140          */
} __type1254;
typedef struct
{                            /* Bit Access       */
    uint8 EIP141        : 4; /* EIP141[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB141       : 1; /* EITB141          */
    uint8 EIMK141       : 1; /* EIMK141          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF141       : 1; /* EIRF141          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT141 : 1; /* EICT141          */
} __type1255;
typedef struct
{                            /* Bit Access       */
    uint8 EIP142        : 4; /* EIP142[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB142       : 1; /* EITB142          */
    uint8 EIMK142       : 1; /* EIMK142          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF142       : 1; /* EIRF142          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT142 : 1; /* EICT142          */
} __type1256;
typedef struct
{                            /* Bit Access       */
    uint8 EIP143        : 4; /* EIP143[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB143       : 1; /* EITB143          */
    uint8 EIMK143       : 1; /* EIMK143          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF143       : 1; /* EIRF143          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT143 : 1; /* EICT143          */
} __type1257;
typedef struct
{                            /* Bit Access       */
    uint8 EIP144        : 4; /* EIP144[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB144       : 1; /* EITB144          */
    uint8 EIMK144       : 1; /* EIMK144          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF144       : 1; /* EIRF144          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT144 : 1; /* EICT144          */
} __type1258;
typedef struct
{                            /* Bit Access       */
    uint8 EIP145        : 4; /* EIP145[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB145       : 1; /* EITB145          */
    uint8 EIMK145       : 1; /* EIMK145          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF145       : 1; /* EIRF145          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT145 : 1; /* EICT145          */
} __type1259;
typedef struct
{                            /* Bit Access       */
    uint8 EIP146        : 4; /* EIP146[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB146       : 1; /* EITB146          */
    uint8 EIMK146       : 1; /* EIMK146          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF146       : 1; /* EIRF146          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT146 : 1; /* EICT146          */
} __type1260;
typedef struct
{                            /* Bit Access       */
    uint8 EIP147        : 4; /* EIP147[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB147       : 1; /* EITB147          */
    uint8 EIMK147       : 1; /* EIMK147          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF147       : 1; /* EIRF147          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT147 : 1; /* EICT147          */
} __type1261;
typedef struct
{                            /* Bit Access       */
    uint8 EIP148        : 4; /* EIP148[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB148       : 1; /* EITB148          */
    uint8 EIMK148       : 1; /* EIMK148          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF148       : 1; /* EIRF148          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT148 : 1; /* EICT148          */
} __type1262;
typedef struct
{                            /* Bit Access       */
    uint8 EIP149        : 4; /* EIP149[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB149       : 1; /* EITB149          */
    uint8 EIMK149       : 1; /* EIMK149          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF149       : 1; /* EIRF149          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT149 : 1; /* EICT149          */
} __type1263;
typedef struct
{                            /* Bit Access       */
    uint8 EIP150        : 4; /* EIP150[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB150       : 1; /* EITB150          */
    uint8 EIMK150       : 1; /* EIMK150          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF150       : 1; /* EIRF150          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT150 : 1; /* EICT150          */
} __type1264;
typedef struct
{                            /* Bit Access       */
    uint8 EIP151        : 4; /* EIP151[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB151       : 1; /* EITB151          */
    uint8 EIMK151       : 1; /* EIMK151          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF151       : 1; /* EIRF151          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT151 : 1; /* EICT151          */
} __type1265;
typedef struct
{                            /* Bit Access       */
    uint8 EIP152        : 4; /* EIP152[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB152       : 1; /* EITB152          */
    uint8 EIMK152       : 1; /* EIMK152          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF152       : 1; /* EIRF152          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT152 : 1; /* EICT152          */
} __type1266;
typedef struct
{                            /* Bit Access       */
    uint8 EIP153        : 4; /* EIP153[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB153       : 1; /* EITB153          */
    uint8 EIMK153       : 1; /* EIMK153          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF153       : 1; /* EIRF153          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT153 : 1; /* EICT153          */
} __type1267;
typedef struct
{                            /* Bit Access       */
    uint8 EIP154        : 4; /* EIP154[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB154       : 1; /* EITB154          */
    uint8 EIMK154       : 1; /* EIMK154          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF154       : 1; /* EIRF154          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT154 : 1; /* EICT154          */
} __type1268;
typedef struct
{                            /* Bit Access       */
    uint8 EIP155        : 4; /* EIP155[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB155       : 1; /* EITB155          */
    uint8 EIMK155       : 1; /* EIMK155          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF155       : 1; /* EIRF155          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT155 : 1; /* EICT155          */
} __type1269;
typedef struct
{                            /* Bit Access       */
    uint8 EIP156        : 4; /* EIP156[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB156       : 1; /* EITB156          */
    uint8 EIMK156       : 1; /* EIMK156          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF156       : 1; /* EIRF156          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT156 : 1; /* EICT156          */
} __type1270;
typedef struct
{                            /* Bit Access       */
    uint8 EIP157        : 4; /* EIP157[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB157       : 1; /* EITB157          */
    uint8 EIMK157       : 1; /* EIMK157          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF157       : 1; /* EIRF157          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT157 : 1; /* EICT157          */
} __type1271;
typedef struct
{                            /* Bit Access       */
    uint8 EIP158        : 4; /* EIP158[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB158       : 1; /* EITB158          */
    uint8 EIMK158       : 1; /* EIMK158          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF158       : 1; /* EIRF158          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT158 : 1; /* EICT158          */
} __type1272;
typedef struct
{                            /* Bit Access       */
    uint8 EIP159        : 4; /* EIP159[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB159       : 1; /* EITB159          */
    uint8 EIMK159       : 1; /* EIMK159          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF159       : 1; /* EIRF159          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT159 : 1; /* EICT159          */
} __type1273;
typedef struct
{                            /* Bit Access       */
    uint8 EIP160        : 4; /* EIP160[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB160       : 1; /* EITB160          */
    uint8 EIMK160       : 1; /* EIMK160          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF160       : 1; /* EIRF160          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT160 : 1; /* EICT160          */
} __type1274;
typedef struct
{                            /* Bit Access       */
    uint8 EIP161        : 4; /* EIP161[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB161       : 1; /* EITB161          */
    uint8 EIMK161       : 1; /* EIMK161          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF161       : 1; /* EIRF161          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT161 : 1; /* EICT161          */
} __type1275;
typedef struct
{                            /* Bit Access       */
    uint8 EIP162        : 4; /* EIP162[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB162       : 1; /* EITB162          */
    uint8 EIMK162       : 1; /* EIMK162          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF162       : 1; /* EIRF162          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT162 : 1; /* EICT162          */
} __type1276;
typedef struct
{                            /* Bit Access       */
    uint8 EIP163        : 4; /* EIP163[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB163       : 1; /* EITB163          */
    uint8 EIMK163       : 1; /* EIMK163          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF163       : 1; /* EIRF163          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT163 : 1; /* EICT163          */
} __type1277;
typedef struct
{                            /* Bit Access       */
    uint8 EIP164        : 4; /* EIP164[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB164       : 1; /* EITB164          */
    uint8 EIMK164       : 1; /* EIMK164          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF164       : 1; /* EIRF164          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT164 : 1; /* EICT164          */
} __type1278;
typedef struct
{                            /* Bit Access       */
    uint8 EIP165        : 4; /* EIP165[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB165       : 1; /* EITB165          */
    uint8 EIMK165       : 1; /* EIMK165          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF165       : 1; /* EIRF165          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT165 : 1; /* EICT165          */
} __type1279;
typedef struct
{                            /* Bit Access       */
    uint8 EIP166        : 4; /* EIP166[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB166       : 1; /* EITB166          */
    uint8 EIMK166       : 1; /* EIMK166          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF166       : 1; /* EIRF166          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT166 : 1; /* EICT166          */
} __type1280;
typedef struct
{                            /* Bit Access       */
    uint8 EIP167        : 4; /* EIP167[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB167       : 1; /* EITB167          */
    uint8 EIMK167       : 1; /* EIMK167          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF167       : 1; /* EIRF167          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT167 : 1; /* EICT167          */
} __type1281;
typedef struct
{                            /* Bit Access       */
    uint8 EIP168        : 4; /* EIP168[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB168       : 1; /* EITB168          */
    uint8 EIMK168       : 1; /* EIMK168          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF168       : 1; /* EIRF168          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT168 : 1; /* EICT168          */
} __type1282;
typedef struct
{                            /* Bit Access       */
    uint8 EIP169        : 4; /* EIP169[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB169       : 1; /* EITB169          */
    uint8 EIMK169       : 1; /* EIMK169          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF169       : 1; /* EIRF169          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT169 : 1; /* EICT169          */
} __type1283;
typedef struct
{                            /* Bit Access       */
    uint8 EIP170        : 4; /* EIP170[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB170       : 1; /* EITB170          */
    uint8 EIMK170       : 1; /* EIMK170          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF170       : 1; /* EIRF170          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT170 : 1; /* EICT170          */
} __type1284;
typedef struct
{                            /* Bit Access       */
    uint8 EIP171        : 4; /* EIP171[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB171       : 1; /* EITB171          */
    uint8 EIMK171       : 1; /* EIMK171          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF171       : 1; /* EIRF171          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT171 : 1; /* EICT171          */
} __type1285;
typedef struct
{                            /* Bit Access       */
    uint8 EIP172        : 4; /* EIP172[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB172       : 1; /* EITB172          */
    uint8 EIMK172       : 1; /* EIMK172          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF172       : 1; /* EIRF172          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT172 : 1; /* EICT172          */
} __type1286;
typedef struct
{                            /* Bit Access       */
    uint8 EIP173        : 4; /* EIP173[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB173       : 1; /* EITB173          */
    uint8 EIMK173       : 1; /* EIMK173          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF173       : 1; /* EIRF173          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT173 : 1; /* EICT173          */
} __type1287;
typedef struct
{                            /* Bit Access       */
    uint8 EIP174        : 4; /* EIP174[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB174       : 1; /* EITB174          */
    uint8 EIMK174       : 1; /* EIMK174          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF174       : 1; /* EIRF174          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT174 : 1; /* EICT174          */
} __type1288;
typedef struct
{                            /* Bit Access       */
    uint8 EIP175        : 4; /* EIP175[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB175       : 1; /* EITB175          */
    uint8 EIMK175       : 1; /* EIMK175          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF175       : 1; /* EIRF175          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT175 : 1; /* EICT175          */
} __type1289;
typedef struct
{                            /* Bit Access       */
    uint8 EIP176        : 4; /* EIP176[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB176       : 1; /* EITB176          */
    uint8 EIMK176       : 1; /* EIMK176          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF176       : 1; /* EIRF176          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT176 : 1; /* EICT176          */
} __type1290;
typedef struct
{                            /* Bit Access       */
    uint8 EIP177        : 4; /* EIP177[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB177       : 1; /* EITB177          */
    uint8 EIMK177       : 1; /* EIMK177          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF177       : 1; /* EIRF177          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT177 : 1; /* EICT177          */
} __type1291;
typedef struct
{                            /* Bit Access       */
    uint8 EIP178        : 4; /* EIP178[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB178       : 1; /* EITB178          */
    uint8 EIMK178       : 1; /* EIMK178          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF178       : 1; /* EIRF178          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT178 : 1; /* EICT178          */
} __type1292;
typedef struct
{                            /* Bit Access       */
    uint8 EIP179        : 4; /* EIP179[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB179       : 1; /* EITB179          */
    uint8 EIMK179       : 1; /* EIMK179          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF179       : 1; /* EIRF179          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT179 : 1; /* EICT179          */
} __type1293;
typedef struct
{                            /* Bit Access       */
    uint8 EIP180        : 4; /* EIP180[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB180       : 1; /* EITB180          */
    uint8 EIMK180       : 1; /* EIMK180          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF180       : 1; /* EIRF180          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT180 : 1; /* EICT180          */
} __type1294;
typedef struct
{                            /* Bit Access       */
    uint8 EIP181        : 4; /* EIP181[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB181       : 1; /* EITB181          */
    uint8 EIMK181       : 1; /* EIMK181          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF181       : 1; /* EIRF181          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT181 : 1; /* EICT181          */
} __type1295;
typedef struct
{                            /* Bit Access       */
    uint8 EIP182        : 4; /* EIP182[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB182       : 1; /* EITB182          */
    uint8 EIMK182       : 1; /* EIMK182          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF182       : 1; /* EIRF182          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT182 : 1; /* EICT182          */
} __type1296;
typedef struct
{                            /* Bit Access       */
    uint8 EIP183        : 4; /* EIP183[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB183       : 1; /* EITB183          */
    uint8 EIMK183       : 1; /* EIMK183          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF183       : 1; /* EIRF183          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT183 : 1; /* EICT183          */
} __type1297;
typedef struct
{                            /* Bit Access       */
    uint8 EIP184        : 4; /* EIP184[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB184       : 1; /* EITB184          */
    uint8 EIMK184       : 1; /* EIMK184          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF184       : 1; /* EIRF184          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT184 : 1; /* EICT184          */
} __type1298;
typedef struct
{                            /* Bit Access       */
    uint8 EIP185        : 4; /* EIP185[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB185       : 1; /* EITB185          */
    uint8 EIMK185       : 1; /* EIMK185          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF185       : 1; /* EIRF185          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT185 : 1; /* EICT185          */
} __type1299;
typedef struct
{                            /* Bit Access       */
    uint8 EIP186        : 4; /* EIP186[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB186       : 1; /* EITB186          */
    uint8 EIMK186       : 1; /* EIMK186          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF186       : 1; /* EIRF186          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT186 : 1; /* EICT186          */
} __type1300;
typedef struct
{                            /* Bit Access       */
    uint8 EIP187        : 4; /* EIP187[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB187       : 1; /* EITB187          */
    uint8 EIMK187       : 1; /* EIMK187          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF187       : 1; /* EIRF187          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT187 : 1; /* EICT187          */
} __type1301;
typedef struct
{                            /* Bit Access       */
    uint8 EIP188        : 4; /* EIP188[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB188       : 1; /* EITB188          */
    uint8 EIMK188       : 1; /* EIMK188          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF188       : 1; /* EIRF188          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT188 : 1; /* EICT188          */
} __type1302;
typedef struct
{                            /* Bit Access       */
    uint8 EIP189        : 4; /* EIP189[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB189       : 1; /* EITB189          */
    uint8 EIMK189       : 1; /* EIMK189          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF189       : 1; /* EIRF189          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT189 : 1; /* EICT189          */
} __type1303;
typedef struct
{                            /* Bit Access       */
    uint8 EIP190        : 4; /* EIP190[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB190       : 1; /* EITB190          */
    uint8 EIMK190       : 1; /* EIMK190          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF190       : 1; /* EIRF190          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT190 : 1; /* EICT190          */
} __type1304;
typedef struct
{                            /* Bit Access       */
    uint8 EIP191        : 4; /* EIP191[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB191       : 1; /* EITB191          */
    uint8 EIMK191       : 1; /* EIMK191          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF191       : 1; /* EIRF191          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT191 : 1; /* EICT191          */
} __type1305;
typedef struct
{                            /* Bit Access       */
    uint8 EIP192        : 4; /* EIP192[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB192       : 1; /* EITB192          */
    uint8 EIMK192       : 1; /* EIMK192          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF192       : 1; /* EIRF192          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT192 : 1; /* EICT192          */
} __type1306;
typedef struct
{                            /* Bit Access       */
    uint8 EIP193        : 4; /* EIP193[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB193       : 1; /* EITB193          */
    uint8 EIMK193       : 1; /* EIMK193          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF193       : 1; /* EIRF193          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT193 : 1; /* EICT193          */
} __type1307;
typedef struct
{                            /* Bit Access       */
    uint8 EIP194        : 4; /* EIP194[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB194       : 1; /* EITB194          */
    uint8 EIMK194       : 1; /* EIMK194          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF194       : 1; /* EIRF194          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT194 : 1; /* EICT194          */
} __type1308;
typedef struct
{                            /* Bit Access       */
    uint8 EIP195        : 4; /* EIP195[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB195       : 1; /* EITB195          */
    uint8 EIMK195       : 1; /* EIMK195          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF195       : 1; /* EIRF195          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT195 : 1; /* EICT195          */
} __type1309;
typedef struct
{                            /* Bit Access       */
    uint8 EIP196        : 4; /* EIP196[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB196       : 1; /* EITB196          */
    uint8 EIMK196       : 1; /* EIMK196          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF196       : 1; /* EIRF196          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT196 : 1; /* EICT196          */
} __type1310;
typedef struct
{                            /* Bit Access       */
    uint8 EIP197        : 4; /* EIP197[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB197       : 1; /* EITB197          */
    uint8 EIMK197       : 1; /* EIMK197          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF197       : 1; /* EIRF197          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT197 : 1; /* EICT197          */
} __type1311;
typedef struct
{                            /* Bit Access       */
    uint8 EIP198        : 4; /* EIP198[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB198       : 1; /* EITB198          */
    uint8 EIMK198       : 1; /* EIMK198          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF198       : 1; /* EIRF198          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT198 : 1; /* EICT198          */
} __type1312;
typedef struct
{                            /* Bit Access       */
    uint8 EIP199        : 4; /* EIP199[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB199       : 1; /* EITB199          */
    uint8 EIMK199       : 1; /* EIMK199          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF199       : 1; /* EIRF199          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT199 : 1; /* EICT199          */
} __type1313;
typedef struct
{                            /* Bit Access       */
    uint8 EIP200        : 4; /* EIP200[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB200       : 1; /* EITB200          */
    uint8 EIMK200       : 1; /* EIMK200          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF200       : 1; /* EIRF200          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT200 : 1; /* EICT200          */
} __type1314;
typedef struct
{                            /* Bit Access       */
    uint8 EIP201        : 4; /* EIP201[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB201       : 1; /* EITB201          */
    uint8 EIMK201       : 1; /* EIMK201          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF201       : 1; /* EIRF201          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT201 : 1; /* EICT201          */
} __type1315;
typedef struct
{                            /* Bit Access       */
    uint8 EIP202        : 4; /* EIP202[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB202       : 1; /* EITB202          */
    uint8 EIMK202       : 1; /* EIMK202          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF202       : 1; /* EIRF202          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT202 : 1; /* EICT202          */
} __type1316;
typedef struct
{                            /* Bit Access       */
    uint8 EIP203        : 4; /* EIP203[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB203       : 1; /* EITB203          */
    uint8 EIMK203       : 1; /* EIMK203          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF203       : 1; /* EIRF203          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT203 : 1; /* EICT203          */
} __type1317;
typedef struct
{                            /* Bit Access       */
    uint8 EIP204        : 4; /* EIP204[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB204       : 1; /* EITB204          */
    uint8 EIMK204       : 1; /* EIMK204          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF204       : 1; /* EIRF204          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT204 : 1; /* EICT204          */
} __type1318;
typedef struct
{                            /* Bit Access       */
    uint8 EIP205        : 4; /* EIP205[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB205       : 1; /* EITB205          */
    uint8 EIMK205       : 1; /* EIMK205          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF205       : 1; /* EIRF205          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT205 : 1; /* EICT205          */
} __type1319;
typedef struct
{                            /* Bit Access       */
    uint8 EIP206        : 4; /* EIP206[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB206       : 1; /* EITB206          */
    uint8 EIMK206       : 1; /* EIMK206          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF206       : 1; /* EIRF206          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT206 : 1; /* EICT206          */
} __type1320;
typedef struct
{                            /* Bit Access       */
    uint8 EIP207        : 4; /* EIP207[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB207       : 1; /* EITB207          */
    uint8 EIMK207       : 1; /* EIMK207          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF207       : 1; /* EIRF207          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT207 : 1; /* EICT207          */
} __type1321;
typedef struct
{                            /* Bit Access       */
    uint8 EIP208        : 4; /* EIP208[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB208       : 1; /* EITB208          */
    uint8 EIMK208       : 1; /* EIMK208          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF208       : 1; /* EIRF208          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT208 : 1; /* EICT208          */
} __type1322;
typedef struct
{                            /* Bit Access       */
    uint8 EIP209        : 4; /* EIP209[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB209       : 1; /* EITB209          */
    uint8 EIMK209       : 1; /* EIMK209          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF209       : 1; /* EIRF209          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT209 : 1; /* EICT209          */
} __type1323;
typedef struct
{                            /* Bit Access       */
    uint8 EIP210        : 4; /* EIP210[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB210       : 1; /* EITB210          */
    uint8 EIMK210       : 1; /* EIMK210          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF210       : 1; /* EIRF210          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT210 : 1; /* EICT210          */
} __type1324;
typedef struct
{                            /* Bit Access       */
    uint8 EIP211        : 4; /* EIP211[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB211       : 1; /* EITB211          */
    uint8 EIMK211       : 1; /* EIMK211          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF211       : 1; /* EIRF211          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT211 : 1; /* EICT211          */
} __type1325;
typedef struct
{                            /* Bit Access       */
    uint8 EIP212        : 4; /* EIP212[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB212       : 1; /* EITB212          */
    uint8 EIMK212       : 1; /* EIMK212          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF212       : 1; /* EIRF212          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT212 : 1; /* EICT212          */
} __type1326;
typedef struct
{                            /* Bit Access       */
    uint8 EIP213        : 4; /* EIP213[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB213       : 1; /* EITB213          */
    uint8 EIMK213       : 1; /* EIMK213          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF213       : 1; /* EIRF213          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT213 : 1; /* EICT213          */
} __type1327;
typedef struct
{                            /* Bit Access       */
    uint8 EIP214        : 4; /* EIP214[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB214       : 1; /* EITB214          */
    uint8 EIMK214       : 1; /* EIMK214          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF214       : 1; /* EIRF214          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT214 : 1; /* EICT214          */
} __type1328;
typedef struct
{                            /* Bit Access       */
    uint8 EIP215        : 4; /* EIP215[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB215       : 1; /* EITB215          */
    uint8 EIMK215       : 1; /* EIMK215          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF215       : 1; /* EIRF215          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT215 : 1; /* EICT215          */
} __type1329;
typedef struct
{                            /* Bit Access       */
    uint8 EIP216        : 4; /* EIP216[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB216       : 1; /* EITB216          */
    uint8 EIMK216       : 1; /* EIMK216          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF216       : 1; /* EIRF216          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT216 : 1; /* EICT216          */
} __type1330;
typedef struct
{                            /* Bit Access       */
    uint8 EIP217        : 4; /* EIP217[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB217       : 1; /* EITB217          */
    uint8 EIMK217       : 1; /* EIMK217          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF217       : 1; /* EIRF217          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT217 : 1; /* EICT217          */
} __type1331;
typedef struct
{                            /* Bit Access       */
    uint8 EIP218        : 4; /* EIP218[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB218       : 1; /* EITB218          */
    uint8 EIMK218       : 1; /* EIMK218          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF218       : 1; /* EIRF218          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT218 : 1; /* EICT218          */
} __type1332;
typedef struct
{                            /* Bit Access       */
    uint8 EIP219        : 4; /* EIP219[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB219       : 1; /* EITB219          */
    uint8 EIMK219       : 1; /* EIMK219          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF219       : 1; /* EIRF219          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT219 : 1; /* EICT219          */
} __type1333;
typedef struct
{                            /* Bit Access       */
    uint8 EIP220        : 4; /* EIP220[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB220       : 1; /* EITB220          */
    uint8 EIMK220       : 1; /* EIMK220          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF220       : 1; /* EIRF220          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT220 : 1; /* EICT220          */
} __type1334;
typedef struct
{                            /* Bit Access       */
    uint8 EIP221        : 4; /* EIP221[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB221       : 1; /* EITB221          */
    uint8 EIMK221       : 1; /* EIMK221          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF221       : 1; /* EIRF221          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT221 : 1; /* EICT221          */
} __type1335;
typedef struct
{                            /* Bit Access       */
    uint8 EIP222        : 4; /* EIP222[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB222       : 1; /* EITB222          */
    uint8 EIMK222       : 1; /* EIMK222          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF222       : 1; /* EIRF222          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT222 : 1; /* EICT222          */
} __type1336;
typedef struct
{                            /* Bit Access       */
    uint8 EIP223        : 4; /* EIP223[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB223       : 1; /* EITB223          */
    uint8 EIMK223       : 1; /* EIMK223          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF223       : 1; /* EIRF223          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT223 : 1; /* EICT223          */
} __type1337;
typedef struct
{                            /* Bit Access       */
    uint8 EIP224        : 4; /* EIP224[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB224       : 1; /* EITB224          */
    uint8 EIMK224       : 1; /* EIMK224          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF224       : 1; /* EIRF224          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT224 : 1; /* EICT224          */
} __type1338;
typedef struct
{                            /* Bit Access       */
    uint8 EIP225        : 4; /* EIP225[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB225       : 1; /* EITB225          */
    uint8 EIMK225       : 1; /* EIMK225          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF225       : 1; /* EIRF225          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT225 : 1; /* EICT225          */
} __type1339;
typedef struct
{                            /* Bit Access       */
    uint8 EIP226        : 4; /* EIP226[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB226       : 1; /* EITB226          */
    uint8 EIMK226       : 1; /* EIMK226          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF226       : 1; /* EIRF226          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT226 : 1; /* EICT226          */
} __type1340;
typedef struct
{                            /* Bit Access       */
    uint8 EIP227        : 4; /* EIP227[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB227       : 1; /* EITB227          */
    uint8 EIMK227       : 1; /* EIMK227          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF227       : 1; /* EIRF227          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT227 : 1; /* EICT227          */
} __type1341;
typedef struct
{                            /* Bit Access       */
    uint8 EIP228        : 4; /* EIP228[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB228       : 1; /* EITB228          */
    uint8 EIMK228       : 1; /* EIMK228          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF228       : 1; /* EIRF228          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT228 : 1; /* EICT228          */
} __type1342;
typedef struct
{                            /* Bit Access       */
    uint8 EIP229        : 4; /* EIP229[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB229       : 1; /* EITB229          */
    uint8 EIMK229       : 1; /* EIMK229          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF229       : 1; /* EIRF229          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT229 : 1; /* EICT229          */
} __type1343;
typedef struct
{                            /* Bit Access       */
    uint8 EIP230        : 4; /* EIP230[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB230       : 1; /* EITB230          */
    uint8 EIMK230       : 1; /* EIMK230          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF230       : 1; /* EIRF230          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT230 : 1; /* EICT230          */
} __type1344;
typedef struct
{                            /* Bit Access       */
    uint8 EIP231        : 4; /* EIP231[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB231       : 1; /* EITB231          */
    uint8 EIMK231       : 1; /* EIMK231          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF231       : 1; /* EIRF231          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT231 : 1; /* EICT231          */
} __type1345;
typedef struct
{                            /* Bit Access       */
    uint8 EIP232        : 4; /* EIP232[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB232       : 1; /* EITB232          */
    uint8 EIMK232       : 1; /* EIMK232          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF232       : 1; /* EIRF232          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT232 : 1; /* EICT232          */
} __type1346;
typedef struct
{                            /* Bit Access       */
    uint8 EIP233        : 4; /* EIP233[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB233       : 1; /* EITB233          */
    uint8 EIMK233       : 1; /* EIMK233          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF233       : 1; /* EIRF233          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT233 : 1; /* EICT233          */
} __type1347;
typedef struct
{                            /* Bit Access       */
    uint8 EIP234        : 4; /* EIP234[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB234       : 1; /* EITB234          */
    uint8 EIMK234       : 1; /* EIMK234          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF234       : 1; /* EIRF234          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT234 : 1; /* EICT234          */
} __type1348;
typedef struct
{                            /* Bit Access       */
    uint8 EIP235        : 4; /* EIP235[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB235       : 1; /* EITB235          */
    uint8 EIMK235       : 1; /* EIMK235          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF235       : 1; /* EIRF235          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT235 : 1; /* EICT235          */
} __type1349;
typedef struct
{                            /* Bit Access       */
    uint8 EIP236        : 4; /* EIP236[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB236       : 1; /* EITB236          */
    uint8 EIMK236       : 1; /* EIMK236          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF236       : 1; /* EIRF236          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT236 : 1; /* EICT236          */
} __type1350;
typedef struct
{                            /* Bit Access       */
    uint8 EIP237        : 4; /* EIP237[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB237       : 1; /* EITB237          */
    uint8 EIMK237       : 1; /* EIMK237          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF237       : 1; /* EIRF237          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT237 : 1; /* EICT237          */
} __type1351;
typedef struct
{                            /* Bit Access       */
    uint8 EIP238        : 4; /* EIP238[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB238       : 1; /* EITB238          */
    uint8 EIMK238       : 1; /* EIMK238          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF238       : 1; /* EIRF238          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT238 : 1; /* EICT238          */
} __type1352;
typedef struct
{                            /* Bit Access       */
    uint8 EIP239        : 4; /* EIP239[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB239       : 1; /* EITB239          */
    uint8 EIMK239       : 1; /* EIMK239          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF239       : 1; /* EIRF239          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT239 : 1; /* EICT239          */
} __type1353;
typedef struct
{                            /* Bit Access       */
    uint8 EIP240        : 4; /* EIP240[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB240       : 1; /* EITB240          */
    uint8 EIMK240       : 1; /* EIMK240          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF240       : 1; /* EIRF240          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT240 : 1; /* EICT240          */
} __type1354;
typedef struct
{                            /* Bit Access       */
    uint8 EIP241        : 4; /* EIP241[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB241       : 1; /* EITB241          */
    uint8 EIMK241       : 1; /* EIMK241          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF241       : 1; /* EIRF241          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT241 : 1; /* EICT241          */
} __type1355;
typedef struct
{                            /* Bit Access       */
    uint8 EIP242        : 4; /* EIP242[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB242       : 1; /* EITB242          */
    uint8 EIMK242       : 1; /* EIMK242          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF242       : 1; /* EIRF242          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT242 : 1; /* EICT242          */
} __type1356;
typedef struct
{                            /* Bit Access       */
    uint8 EIP243        : 4; /* EIP243[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB243       : 1; /* EITB243          */
    uint8 EIMK243       : 1; /* EIMK243          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF243       : 1; /* EIRF243          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT243 : 1; /* EICT243          */
} __type1357;
typedef struct
{                            /* Bit Access       */
    uint8 EIP244        : 4; /* EIP244[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB244       : 1; /* EITB244          */
    uint8 EIMK244       : 1; /* EIMK244          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF244       : 1; /* EIRF244          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT244 : 1; /* EICT244          */
} __type1358;
typedef struct
{                            /* Bit Access       */
    uint8 EIP245        : 4; /* EIP245[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB245       : 1; /* EITB245          */
    uint8 EIMK245       : 1; /* EIMK245          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF245       : 1; /* EIRF245          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT245 : 1; /* EICT245          */
} __type1359;
typedef struct
{                            /* Bit Access       */
    uint8 EIP246        : 4; /* EIP246[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB246       : 1; /* EITB246          */
    uint8 EIMK246       : 1; /* EIMK246          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF246       : 1; /* EIRF246          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT246 : 1; /* EICT246          */
} __type1360;
typedef struct
{                            /* Bit Access       */
    uint8 EIP247        : 4; /* EIP247[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB247       : 1; /* EITB247          */
    uint8 EIMK247       : 1; /* EIMK247          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF247       : 1; /* EIRF247          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT247 : 1; /* EICT247          */
} __type1361;
typedef struct
{                            /* Bit Access       */
    uint8 EIP248        : 4; /* EIP248[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB248       : 1; /* EITB248          */
    uint8 EIMK248       : 1; /* EIMK248          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF248       : 1; /* EIRF248          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT248 : 1; /* EICT248          */
} __type1362;
typedef struct
{                            /* Bit Access       */
    uint8 EIP249        : 4; /* EIP249[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB249       : 1; /* EITB249          */
    uint8 EIMK249       : 1; /* EIMK249          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF249       : 1; /* EIRF249          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT249 : 1; /* EICT249          */
} __type1363;
typedef struct
{                            /* Bit Access       */
    uint8 EIP250        : 4; /* EIP250[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB250       : 1; /* EITB250          */
    uint8 EIMK250       : 1; /* EIMK250          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF250       : 1; /* EIRF250          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT250 : 1; /* EICT250          */
} __type1364;
typedef struct
{                            /* Bit Access       */
    uint8 EIP251        : 4; /* EIP251[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB251       : 1; /* EITB251          */
    uint8 EIMK251       : 1; /* EIMK251          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF251       : 1; /* EIRF251          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT251 : 1; /* EICT251          */
} __type1365;
typedef struct
{                            /* Bit Access       */
    uint8 EIP252        : 4; /* EIP252[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB252       : 1; /* EITB252          */
    uint8 EIMK252       : 1; /* EIMK252          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF252       : 1; /* EIRF252          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT252 : 1; /* EICT252          */
} __type1366;
typedef struct
{                            /* Bit Access       */
    uint8 EIP253        : 4; /* EIP253[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB253       : 1; /* EITB253          */
    uint8 EIMK253       : 1; /* EIMK253          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF253       : 1; /* EIRF253          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT253 : 1; /* EICT253          */
} __type1367;
typedef struct
{                            /* Bit Access       */
    uint8 EIP254        : 4; /* EIP254[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB254       : 1; /* EITB254          */
    uint8 EIMK254       : 1; /* EIMK254          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF254       : 1; /* EIRF254          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT254 : 1; /* EICT254          */
} __type1368;
typedef struct
{                            /* Bit Access       */
    uint8 EIP255        : 4; /* EIP255[3:0]      */
    uint8               : 2; /* Reserved Bits    */
    uint8 EITB255       : 1; /* EITB255          */
    uint8 EIMK255       : 1; /* EIMK255          */
    uint8               : 4; /* Reserved Bits    */
    uint8 EIRF255       : 1; /* EIRF255          */
    uint8               : 2; /* Reserved Bits    */
    const uint8 EICT255 : 1; /* EICT255          */
} __type1369;
typedef struct
{                     /* Bit Access       */
    uint8 EIMK32 : 1; /* EIMK32           */
    uint8 EIMK33 : 1; /* EIMK33           */
    uint8 EIMK34 : 1; /* EIMK34           */
    uint8 EIMK35 : 1; /* EIMK35           */
    uint8 EIMK36 : 1; /* EIMK36           */
    uint8 EIMK37 : 1; /* EIMK37           */
    uint8 EIMK38 : 1; /* EIMK38           */
    uint8 EIMK39 : 1; /* EIMK39           */
    uint8 EIMK40 : 1; /* EIMK40           */
    uint8 EIMK41 : 1; /* EIMK41           */
    uint8 EIMK42 : 1; /* EIMK42           */
    uint8 EIMK43 : 1; /* EIMK43           */
    uint8 EIMK44 : 1; /* EIMK44           */
    uint8 EIMK45 : 1; /* EIMK45           */
    uint8 EIMK46 : 1; /* EIMK46           */
    uint8 EIMK47 : 1; /* EIMK47           */
    uint8 EIMK48 : 1; /* EIMK48           */
    uint8 EIMK49 : 1; /* EIMK49           */
    uint8 EIMK50 : 1; /* EIMK50           */
    uint8 EIMK51 : 1; /* EIMK51           */
    uint8 EIMK52 : 1; /* EIMK52           */
    uint8 EIMK53 : 1; /* EIMK53           */
    uint8 EIMK54 : 1; /* EIMK54           */
    uint8 EIMK55 : 1; /* EIMK55           */
    uint8 EIMK56 : 1; /* EIMK56           */
    uint8 EIMK57 : 1; /* EIMK57           */
    uint8 EIMK58 : 1; /* EIMK58           */
    uint8 EIMK59 : 1; /* EIMK59           */
    uint8 EIMK60 : 1; /* EIMK60           */
    uint8 EIMK61 : 1; /* EIMK61           */
    uint8 EIMK62 : 1; /* EIMK62           */
    uint8 EIMK63 : 1; /* EIMK63           */
} __type1370;
typedef struct
{                     /* Bit Access       */
    uint8 EIMK64 : 1; /* EIMK64           */
    uint8 EIMK65 : 1; /* EIMK65           */
    uint8 EIMK66 : 1; /* EIMK66           */
    uint8 EIMK67 : 1; /* EIMK67           */
    uint8 EIMK68 : 1; /* EIMK68           */
    uint8 EIMK69 : 1; /* EIMK69           */
    uint8 EIMK70 : 1; /* EIMK70           */
    uint8 EIMK71 : 1; /* EIMK71           */
    uint8 EIMK72 : 1; /* EIMK72           */
    uint8 EIMK73 : 1; /* EIMK73           */
    uint8 EIMK74 : 1; /* EIMK74           */
    uint8 EIMK75 : 1; /* EIMK75           */
    uint8 EIMK76 : 1; /* EIMK76           */
    uint8 EIMK77 : 1; /* EIMK77           */
    uint8 EIMK78 : 1; /* EIMK78           */
    uint8 EIMK79 : 1; /* EIMK79           */
    uint8 EIMK80 : 1; /* EIMK80           */
    uint8 EIMK81 : 1; /* EIMK81           */
    uint8 EIMK82 : 1; /* EIMK82           */
    uint8 EIMK83 : 1; /* EIMK83           */
    uint8 EIMK84 : 1; /* EIMK84           */
    uint8 EIMK85 : 1; /* EIMK85           */
    uint8 EIMK86 : 1; /* EIMK86           */
    uint8 EIMK87 : 1; /* EIMK87           */
    uint8 EIMK88 : 1; /* EIMK88           */
    uint8 EIMK89 : 1; /* EIMK89           */
    uint8 EIMK90 : 1; /* EIMK90           */
    uint8 EIMK91 : 1; /* EIMK91           */
    uint8 EIMK92 : 1; /* EIMK92           */
    uint8 EIMK93 : 1; /* EIMK93           */
    uint8 EIMK94 : 1; /* EIMK94           */
    uint8 EIMK95 : 1; /* EIMK95           */
} __type1371;
typedef struct
{                      /* Bit Access       */
    uint8 EIMK96  : 1; /* EIMK96           */
    uint8 EIMK97  : 1; /* EIMK97           */
    uint8 EIMK98  : 1; /* EIMK98           */
    uint8 EIMK99  : 1; /* EIMK99           */
    uint8 EIMK100 : 1; /* EIMK100          */
    uint8 EIMK101 : 1; /* EIMK101          */
    uint8 EIMK102 : 1; /* EIMK102          */
    uint8 EIMK103 : 1; /* EIMK103          */
    uint8 EIMK104 : 1; /* EIMK104          */
    uint8 EIMK105 : 1; /* EIMK105          */
    uint8 EIMK106 : 1; /* EIMK106          */
    uint8 EIMK107 : 1; /* EIMK107          */
    uint8 EIMK108 : 1; /* EIMK108          */
    uint8 EIMK109 : 1; /* EIMK109          */
    uint8 EIMK110 : 1; /* EIMK110          */
    uint8 EIMK111 : 1; /* EIMK111          */
    uint8 EIMK112 : 1; /* EIMK112          */
    uint8 EIMK113 : 1; /* EIMK113          */
    uint8 EIMK114 : 1; /* EIMK114          */
    uint8 EIMK115 : 1; /* EIMK115          */
    uint8 EIMK116 : 1; /* EIMK116          */
    uint8 EIMK117 : 1; /* EIMK117          */
    uint8 EIMK118 : 1; /* EIMK118          */
    uint8 EIMK119 : 1; /* EIMK119          */
    uint8 EIMK120 : 1; /* EIMK120          */
    uint8 EIMK121 : 1; /* EIMK121          */
    uint8 EIMK122 : 1; /* EIMK122          */
    uint8 EIMK123 : 1; /* EIMK123          */
    uint8 EIMK124 : 1; /* EIMK124          */
    uint8 EIMK125 : 1; /* EIMK125          */
    uint8 EIMK126 : 1; /* EIMK126          */
    uint8 EIMK127 : 1; /* EIMK127          */
} __type1372;
typedef struct
{                      /* Bit Access       */
    uint8 EIMK128 : 1; /* EIMK128          */
    uint8 EIMK129 : 1; /* EIMK129          */
    uint8 EIMK130 : 1; /* EIMK130          */
    uint8 EIMK131 : 1; /* EIMK131          */
    uint8 EIMK132 : 1; /* EIMK132          */
    uint8 EIMK133 : 1; /* EIMK133          */
    uint8 EIMK134 : 1; /* EIMK134          */
    uint8 EIMK135 : 1; /* EIMK135          */
    uint8 EIMK136 : 1; /* EIMK136          */
    uint8 EIMK137 : 1; /* EIMK137          */
    uint8 EIMK138 : 1; /* EIMK138          */
    uint8 EIMK139 : 1; /* EIMK139          */
    uint8 EIMK140 : 1; /* EIMK140          */
    uint8 EIMK141 : 1; /* EIMK141          */
    uint8 EIMK142 : 1; /* EIMK142          */
    uint8 EIMK143 : 1; /* EIMK143          */
    uint8 EIMK144 : 1; /* EIMK144          */
    uint8 EIMK145 : 1; /* EIMK145          */
    uint8 EIMK146 : 1; /* EIMK146          */
    uint8 EIMK147 : 1; /* EIMK147          */
    uint8 EIMK148 : 1; /* EIMK148          */
    uint8 EIMK149 : 1; /* EIMK149          */
    uint8 EIMK150 : 1; /* EIMK150          */
    uint8 EIMK151 : 1; /* EIMK151          */
    uint8 EIMK152 : 1; /* EIMK152          */
    uint8 EIMK153 : 1; /* EIMK153          */
    uint8 EIMK154 : 1; /* EIMK154          */
    uint8 EIMK155 : 1; /* EIMK155          */
    uint8 EIMK156 : 1; /* EIMK156          */
    uint8 EIMK157 : 1; /* EIMK157          */
    uint8 EIMK158 : 1; /* EIMK158          */
    uint8 EIMK159 : 1; /* EIMK159          */
} __type1373;
typedef struct
{                      /* Bit Access       */
    uint8 EIMK160 : 1; /* EIMK160          */
    uint8 EIMK161 : 1; /* EIMK161          */
    uint8 EIMK162 : 1; /* EIMK162          */
    uint8 EIMK163 : 1; /* EIMK163          */
    uint8 EIMK164 : 1; /* EIMK164          */
    uint8 EIMK165 : 1; /* EIMK165          */
    uint8 EIMK166 : 1; /* EIMK166          */
    uint8 EIMK167 : 1; /* EIMK167          */
    uint8 EIMK168 : 1; /* EIMK168          */
    uint8 EIMK169 : 1; /* EIMK169          */
    uint8 EIMK170 : 1; /* EIMK170          */
    uint8 EIMK171 : 1; /* EIMK171          */
    uint8 EIMK172 : 1; /* EIMK172          */
    uint8 EIMK173 : 1; /* EIMK173          */
    uint8 EIMK174 : 1; /* EIMK174          */
    uint8 EIMK175 : 1; /* EIMK175          */
    uint8 EIMK176 : 1; /* EIMK176          */
    uint8 EIMK177 : 1; /* EIMK177          */
    uint8 EIMK178 : 1; /* EIMK178          */
    uint8 EIMK179 : 1; /* EIMK179          */
    uint8 EIMK180 : 1; /* EIMK180          */
    uint8 EIMK181 : 1; /* EIMK181          */
    uint8 EIMK182 : 1; /* EIMK182          */
    uint8 EIMK183 : 1; /* EIMK183          */
    uint8 EIMK184 : 1; /* EIMK184          */
    uint8 EIMK185 : 1; /* EIMK185          */
    uint8 EIMK186 : 1; /* EIMK186          */
    uint8 EIMK187 : 1; /* EIMK187          */
    uint8 EIMK188 : 1; /* EIMK188          */
    uint8 EIMK189 : 1; /* EIMK189          */
    uint8 EIMK190 : 1; /* EIMK190          */
    uint8 EIMK191 : 1; /* EIMK191          */
} __type1374;
typedef struct
{                      /* Bit Access       */
    uint8 EIMK192 : 1; /* EIMK192          */
    uint8 EIMK193 : 1; /* EIMK193          */
    uint8 EIMK194 : 1; /* EIMK194          */
    uint8 EIMK195 : 1; /* EIMK195          */
    uint8 EIMK196 : 1; /* EIMK196          */
    uint8 EIMK197 : 1; /* EIMK197          */
    uint8 EIMK198 : 1; /* EIMK198          */
    uint8 EIMK199 : 1; /* EIMK199          */
    uint8 EIMK200 : 1; /* EIMK200          */
    uint8 EIMK201 : 1; /* EIMK201          */
    uint8 EIMK202 : 1; /* EIMK202          */
    uint8 EIMK203 : 1; /* EIMK203          */
    uint8 EIMK204 : 1; /* EIMK204          */
    uint8 EIMK205 : 1; /* EIMK205          */
    uint8 EIMK206 : 1; /* EIMK206          */
    uint8 EIMK207 : 1; /* EIMK207          */
    uint8 EIMK208 : 1; /* EIMK208          */
    uint8 EIMK209 : 1; /* EIMK209          */
    uint8 EIMK210 : 1; /* EIMK210          */
    uint8 EIMK211 : 1; /* EIMK211          */
    uint8 EIMK212 : 1; /* EIMK212          */
    uint8 EIMK213 : 1; /* EIMK213          */
    uint8 EIMK214 : 1; /* EIMK214          */
    uint8 EIMK215 : 1; /* EIMK215          */
    uint8 EIMK216 : 1; /* EIMK216          */
    uint8 EIMK217 : 1; /* EIMK217          */
    uint8 EIMK218 : 1; /* EIMK218          */
    uint8 EIMK219 : 1; /* EIMK219          */
    uint8 EIMK220 : 1; /* EIMK220          */
    uint8 EIMK221 : 1; /* EIMK221          */
    uint8 EIMK222 : 1; /* EIMK222          */
    uint8 EIMK223 : 1; /* EIMK223          */
} __type1375;
typedef struct
{                      /* Bit Access       */
    uint8 EIMK224 : 1; /* EIMK224          */
    uint8 EIMK225 : 1; /* EIMK225          */
    uint8 EIMK226 : 1; /* EIMK226          */
    uint8 EIMK227 : 1; /* EIMK227          */
    uint8 EIMK228 : 1; /* EIMK228          */
    uint8 EIMK229 : 1; /* EIMK229          */
    uint8 EIMK230 : 1; /* EIMK230          */
    uint8 EIMK231 : 1; /* EIMK231          */
    uint8 EIMK232 : 1; /* EIMK232          */
    uint8 EIMK233 : 1; /* EIMK233          */
    uint8 EIMK234 : 1; /* EIMK234          */
    uint8 EIMK235 : 1; /* EIMK235          */
    uint8 EIMK236 : 1; /* EIMK236          */
    uint8 EIMK237 : 1; /* EIMK237          */
    uint8 EIMK238 : 1; /* EIMK238          */
    uint8 EIMK239 : 1; /* EIMK239          */
    uint8 EIMK240 : 1; /* EIMK240          */
    uint8 EIMK241 : 1; /* EIMK241          */
    uint8 EIMK242 : 1; /* EIMK242          */
    uint8 EIMK243 : 1; /* EIMK243          */
    uint8 EIMK244 : 1; /* EIMK244          */
    uint8 EIMK245 : 1; /* EIMK245          */
    uint8 EIMK246 : 1; /* EIMK246          */
    uint8 EIMK247 : 1; /* EIMK247          */
    uint8 EIMK248 : 1; /* EIMK248          */
    uint8 EIMK249 : 1; /* EIMK249          */
    uint8 EIMK250 : 1; /* EIMK250          */
    uint8 EIMK251 : 1; /* EIMK251          */
    uint8 EIMK252 : 1; /* EIMK252          */
    uint8 EIMK253 : 1; /* EIMK253          */
    uint8 EIMK254 : 1; /* EIMK254          */
    uint8 EIMK255 : 1; /* EIMK255          */
} __type1376;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type0 BIT;    /* Bit Access       */
} __type1377;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type1 BIT;    /* Bit Access       */
} __type1378;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type2 BIT;    /* Bit Access       */
} __type1379;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type3 BIT;    /* Bit Access       */
} __type1380;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type4 BIT;    /* Bit Access       */
} __type1381;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type5 BIT;    /* Bit Access       */
} __type1382;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type6 BIT;    /* Bit Access       */
} __type1383;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type7 BIT;    /* Bit Access       */
} __type1384;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type8 BIT;    /* Bit Access       */
} __type1385;
typedef union
{                   /* IOR              */
    uint32  UINT32; /* 32-bit Access    */
    __type9 BIT;    /* Bit Access       */
} __type1386;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type10 BIT;    /* Bit Access       */
} __type1387;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } SMRDR0_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } SMRDR0_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR0_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR0_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR0_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR0_HH;
    } REGS8;
    const __type11 BIT; /* Bit Access       */
} __type1388;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } SMRDR1_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } SMRDR1_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR1_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR1_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR1_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SMRDR1_HH;
    } REGS8;
    const __type12 BIT; /* Bit Access       */
} __type1389;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type13 BIT;    /* Bit Access       */
} __type1390;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type14 BIT;    /* Bit Access       */
} __type1391;
typedef union
{                          /* IOR              */
    uint32         UINT32; /* 32-bit Access    */
    const __type15 BIT;    /* Bit Access       */
} __type1392;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type16 BIT;    /* Bit Access       */
} __type1393;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type17 BIT;    /* Bit Access       */
} __type1394;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type18 BIT;    /* Bit Access       */
} __type1395;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type19 BIT;    /* Bit Access       */
} __type1396;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type20 BIT;    /* Bit Access       */
} __type1397;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type21 BIT;    /* Bit Access       */
} __type1398;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type22 BIT;    /* Bit Access       */
} __type1399;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type23 BIT;    /* Bit Access       */
} __type1400;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type24 BIT;    /* Bit Access       */
} __type1401;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type25 BIT;    /* Bit Access       */
} __type1402;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type26 BIT;    /* Bit Access       */
} __type1403;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type27 BIT;    /* Bit Access       */
} __type1404;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type28 BIT;    /* Bit Access       */
} __type1405;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type29 BIT;    /* Bit Access       */
} __type1406;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type30 BIT;    /* Bit Access       */
} __type1407;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type31 BIT;    /* Bit Access       */
} __type1408;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type32 BIT;    /* Bit Access       */
} __type1409;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type33 BIT;    /* Bit Access       */
} __type1410;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type34 BIT;    /* Bit Access       */
} __type1411;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type35 BIT;    /* Bit Access       */
} __type1412;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type36 BIT;    /* Bit Access       */
} __type1413;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type37 BIT;    /* Bit Access       */
} __type1414;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type38 BIT;    /* Bit Access       */
} __type1415;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type39 BIT;    /* Bit Access       */
} __type1416;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type40 BIT;    /* Bit Access       */
} __type1417;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type41 BIT;    /* Bit Access       */
} __type1418;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type42 BIT;    /* Bit Access       */
} __type1419;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type43 BIT;    /* Bit Access       */
} __type1420;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type44 BIT;    /* Bit Access       */
} __type1421;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type45 BIT;    /* Bit Access       */
} __type1422;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type46 BIT;    /* Bit Access       */
} __type1423;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type47 BIT;    /* Bit Access       */
} __type1424;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type48 BIT;    /* Bit Access       */
} __type1425;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type49 BIT;    /* Bit Access       */
} __type1426;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type50 BIT;    /* Bit Access       */
} __type1427;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type51 BIT;    /* Bit Access       */
} __type1428;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type52 BIT;    /* Bit Access       */
} __type1429;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type53 BIT;    /* Bit Access       */
} __type1430;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type54 BIT;    /* Bit Access       */
} __type1431;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type55 BIT;    /* Bit Access       */
} __type1432;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type56 BIT;    /* Bit Access       */
} __type1433;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type57 BIT;    /* Bit Access       */
} __type1434;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type58 BIT;    /* Bit Access       */
} __type1435;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type59 BIT;    /* Bit Access       */
} __type1436;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type60 BIT;    /* Bit Access       */
} __type1437;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type61 BIT;    /* Bit Access       */
} __type1438;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type62 BIT;    /* Bit Access       */
} __type1439;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type63 BIT;    /* Bit Access       */
} __type1440;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type64 BIT;    /* Bit Access       */
} __type1441;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type65 BIT;    /* Bit Access       */
} __type1442;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type66 BIT;    /* Bit Access       */
} __type1443;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type67 BIT;    /* Bit Access       */
} __type1444;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type68 BIT;    /* Bit Access       */
} __type1445;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type69 BIT;    /* Bit Access       */
} __type1446;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type70 BIT;    /* Bit Access       */
} __type1447;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type71 BIT;    /* Bit Access       */
} __type1448;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type72 BIT;    /* Bit Access       */
} __type1449;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type73 BIT;    /* Bit Access       */
} __type1450;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type74 BIT;    /* Bit Access       */
} __type1451;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type75 BIT;    /* Bit Access       */
} __type1452;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type76 BIT;    /* Bit Access       */
} __type1453;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type77 BIT;    /* Bit Access       */
} __type1454;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type78 BIT;    /* Bit Access       */
} __type1455;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type79 BIT;    /* Bit Access       */
} __type1456;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type80 BIT;    /* Bit Access       */
} __type1457;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type81 BIT;    /* Bit Access       */
} __type1458;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type82 BIT;    /* Bit Access       */
} __type1459;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type83 BIT;    /* Bit Access       */
} __type1460;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type84 BIT;    /* Bit Access       */
} __type1461;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type85 BIT;    /* Bit Access       */
} __type1462;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type86 BIT;    /* Bit Access       */
} __type1463;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type87 BIT;    /* Bit Access       */
} __type1464;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type88 BIT;    /* Bit Access       */
} __type1465;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type89 BIT;    /* Bit Access       */
} __type1466;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type90 BIT;    /* Bit Access       */
} __type1467;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type91 BIT;    /* Bit Access       */
} __type1468;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type92 BIT;    /* Bit Access       */
} __type1469;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type93 BIT;    /* Bit Access       */
} __type1470;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type94 BIT;    /* Bit Access       */
} __type1471;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type95 BIT;    /* Bit Access       */
} __type1472;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type96 BIT;    /* Bit Access       */
} __type1473;
typedef union
{                    /* IOR              */
    uint32   UINT32; /* 32-bit Access    */
    __type97 BIT;    /* Bit Access       */
} __type1474;
typedef union
{                    /* IOR              */
    uint16   UINT16; /* 16-bit Access    */
    __type98 BIT;    /* Bit Access       */
} __type1475;
typedef union
{                          /* IOR              */
    uint16         UINT16; /* 16-bit Access    */
    const __type99 BIT;    /* Bit Access       */
} __type1476;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type100 BIT;    /* Bit Access       */
} __type1477;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type101 BIT;    /* Bit Access       */
} __type1478;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type102 BIT;    /* Bit Access       */
} __type1479;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type103 BIT;    /* Bit Access       */
} __type1480;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type104 BIT;    /* Bit Access       */
} __type1481;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type105 BIT;    /* Bit Access       */
} __type1482;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type106 BIT;    /* Bit Access       */
} __type1483;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type107 BIT;    /* Bit Access       */
} __type1484;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type108 BIT;    /* Bit Access       */
} __type1485;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type109 BIT;    /* Bit Access       */
} __type1486;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type110 BIT;    /* Bit Access       */
} __type1487;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type111 BIT;    /* Bit Access       */
} __type1488;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type112 BIT;    /* Bit Access       */
} __type1489;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type113 BIT;    /* Bit Access       */
} __type1490;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type114 BIT;    /* Bit Access       */
} __type1491;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type115 BIT;    /* Bit Access       */
} __type1492;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type116 BIT;    /* Bit Access       */
} __type1493;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type117 BIT;    /* Bit Access       */
} __type1494;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type118 BIT;    /* Bit Access       */
} __type1495;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type119 BIT;    /* Bit Access       */
} __type1496;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type120 BIT;    /* Bit Access       */
} __type1497;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type121 BIT;    /* Bit Access       */
} __type1498;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type122 BIT;    /* Bit Access       */
} __type1499;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type123 BIT;    /* Bit Access       */
} __type1500;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type124 BIT;    /* Bit Access       */
} __type1501;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type125 BIT;    /* Bit Access       */
} __type1502;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type126 BIT;    /* Bit Access       */
} __type1503;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type127 BIT;    /* Bit Access       */
} __type1504;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type128 BIT;    /* Bit Access       */
} __type1505;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type129 BIT;    /* Bit Access       */
} __type1506;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type130 BIT;    /* Bit Access       */
} __type1507;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type131 BIT;    /* Bit Access       */
} __type1508;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type132 BIT;    /* Bit Access       */
} __type1509;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type133 BIT;    /* Bit Access       */
} __type1510;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type134 BIT;    /* Bit Access       */
} __type1511;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type135 BIT;    /* Bit Access       */
} __type1512;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type136 BIT;    /* Bit Access       */
} __type1513;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type137 BIT;    /* Bit Access       */
} __type1514;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type138 BIT;    /* Bit Access       */
} __type1515;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type139 BIT;    /* Bit Access       */
} __type1516;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type140 BIT;    /* Bit Access       */
} __type1517;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type141 BIT;    /* Bit Access       */
} __type1518;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type142 BIT;    /* Bit Access       */
} __type1519;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type143 BIT;    /* Bit Access       */
} __type1520;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type144 BIT;    /* Bit Access       */
} __type1521;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type145 BIT;    /* Bit Access       */
} __type1522;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type146 BIT;    /* Bit Access       */
} __type1523;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type147 BIT;    /* Bit Access       */
} __type1524;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type148 BIT;    /* Bit Access       */
} __type1525;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type149 BIT;    /* Bit Access       */
} __type1526;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type150 BIT;    /* Bit Access       */
} __type1527;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type151 BIT;    /* Bit Access       */
} __type1528;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type152 BIT;    /* Bit Access       */
} __type1529;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type153 BIT;    /* Bit Access       */
} __type1530;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type154 BIT;    /* Bit Access       */
} __type1531;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type155 BIT;    /* Bit Access       */
} __type1532;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type156 BIT;    /* Bit Access       */
} __type1533;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type157 BIT;    /* Bit Access       */
} __type1534;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type158 BIT;    /* Bit Access       */
} __type1535;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type159 BIT;    /* Bit Access       */
} __type1536;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type160 BIT;    /* Bit Access       */
} __type1537;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type161 BIT;    /* Bit Access       */
} __type1538;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type162 BIT;    /* Bit Access       */
} __type1539;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type163 BIT;    /* Bit Access       */
} __type1540;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type164 BIT;    /* Bit Access       */
} __type1541;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type165 BIT;    /* Bit Access       */
} __type1542;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type166 BIT;    /* Bit Access       */
} __type1543;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type167 BIT;    /* Bit Access       */
} __type1544;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type168 BIT;    /* Bit Access       */
} __type1545;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type169 BIT;    /* Bit Access       */
} __type1546;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type170 BIT;    /* Bit Access       */
} __type1547;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type171 BIT;    /* Bit Access       */
} __type1548;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type172 BIT;    /* Bit Access       */
} __type1549;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type173 BIT;    /* Bit Access       */
} __type1550;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type174 BIT;    /* Bit Access       */
} __type1551;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type175 BIT;    /* Bit Access       */
} __type1552;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type176 BIT;    /* Bit Access       */
} __type1553;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type177 BIT;    /* Bit Access       */
} __type1554;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type178 BIT;    /* Bit Access       */
} __type1555;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type179 BIT;    /* Bit Access       */
} __type1556;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type180 BIT;    /* Bit Access       */
} __type1557;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type181 BIT;    /* Bit Access       */
} __type1558;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type182 BIT;    /* Bit Access       */
} __type1559;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type183 BIT;    /* Bit Access       */
} __type1560;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type184 BIT;    /* Bit Access       */
} __type1561;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type185 BIT;    /* Bit Access       */
} __type1562;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type186 BIT;    /* Bit Access       */
} __type1563;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type187 BIT;    /* Bit Access       */
} __type1564;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type188 BIT;    /* Bit Access       */
} __type1565;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type189 BIT;    /* Bit Access       */
} __type1566;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type190 BIT;    /* Bit Access       */
} __type1567;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type191 BIT;    /* Bit Access       */
} __type1568;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type192 BIT;    /* Bit Access       */
} __type1569;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type193 BIT;    /* Bit Access       */
} __type1570;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type194 BIT;    /* Bit Access       */
} __type1571;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type195 BIT;    /* Bit Access       */
} __type1572;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type196 BIT;    /* Bit Access       */
} __type1573;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type197 BIT;    /* Bit Access       */
} __type1574;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type198 BIT;    /* Bit Access       */
} __type1575;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type199 BIT;    /* Bit Access       */
} __type1576;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type200 BIT;    /* Bit Access       */
} __type1577;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type201 BIT;    /* Bit Access       */
} __type1578;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type202 BIT;    /* Bit Access       */
} __type1579;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type203 BIT;    /* Bit Access       */
} __type1580;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type204 BIT;    /* Bit Access       */
} __type1581;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type205 BIT;    /* Bit Access       */
} __type1582;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type206 BIT;    /* Bit Access       */
} __type1583;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type207 BIT;    /* Bit Access       */
} __type1584;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type208 BIT;    /* Bit Access       */
} __type1585;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type209 BIT;    /* Bit Access       */
} __type1586;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type210 BIT;    /* Bit Access       */
} __type1587;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type211 BIT;    /* Bit Access       */
} __type1588;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type212 BIT;    /* Bit Access       */
} __type1589;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type213 BIT;    /* Bit Access       */
} __type1590;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type214 BIT;    /* Bit Access       */
} __type1591;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type215 BIT;    /* Bit Access       */
} __type1592;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type216 BIT;    /* Bit Access       */
} __type1593;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type217 BIT;    /* Bit Access       */
} __type1594;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type218 BIT;    /* Bit Access       */
} __type1595;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type219 BIT;    /* Bit Access       */
} __type1596;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type220 BIT;    /* Bit Access       */
} __type1597;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type221 BIT;    /* Bit Access       */
} __type1598;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type222 BIT;    /* Bit Access       */
} __type1599;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type223 BIT;    /* Bit Access       */
} __type1600;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type224 BIT;    /* Bit Access       */
} __type1601;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type225 BIT;    /* Bit Access       */
} __type1602;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type226 BIT;    /* Bit Access       */
} __type1603;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type227 BIT;    /* Bit Access       */
} __type1604;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type228 BIT;    /* Bit Access       */
} __type1605;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type229 BIT;    /* Bit Access       */
} __type1606;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type230 BIT;    /* Bit Access       */
} __type1607;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type231 BIT;    /* Bit Access       */
} __type1608;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type232 BIT;    /* Bit Access       */
} __type1609;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type233 BIT;    /* Bit Access       */
} __type1610;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type234 BIT;    /* Bit Access       */
} __type1611;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type235 BIT;    /* Bit Access       */
} __type1612;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type236 BIT;    /* Bit Access       */
} __type1613;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type237 BIT;    /* Bit Access       */
} __type1614;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type238 BIT;    /* Bit Access       */
} __type1615;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type239 BIT;    /* Bit Access       */
} __type1616;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type240 BIT;    /* Bit Access       */
} __type1617;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type241 BIT;    /* Bit Access       */
} __type1618;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type242 BIT;    /* Bit Access       */
} __type1619;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type243 BIT;    /* Bit Access       */
} __type1620;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type244 BIT;    /* Bit Access       */
} __type1621;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type245 BIT;    /* Bit Access       */
} __type1622;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type246 BIT;    /* Bit Access       */
} __type1623;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type247 BIT;    /* Bit Access       */
} __type1624;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type248 BIT;    /* Bit Access       */
} __type1625;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type249 BIT;    /* Bit Access       */
} __type1626;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type250 BIT;    /* Bit Access       */
} __type1627;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type251 BIT;    /* Bit Access       */
} __type1628;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type252 BIT;    /* Bit Access       */
} __type1629;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type253 BIT;    /* Bit Access       */
} __type1630;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type254 BIT;    /* Bit Access       */
} __type1631;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type255 BIT;    /* Bit Access       */
} __type1632;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type256 BIT;    /* Bit Access       */
} __type1633;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type257 BIT;    /* Bit Access       */
} __type1634;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type258 BIT;    /* Bit Access       */
} __type1635;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type259 BIT;    /* Bit Access       */
} __type1636;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type260 BIT;    /* Bit Access       */
} __type1637;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type261 BIT;    /* Bit Access       */
} __type1638;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type262 BIT;    /* Bit Access       */
} __type1639;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type263 BIT;    /* Bit Access       */
} __type1640;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type264 BIT;    /* Bit Access       */
} __type1641;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type265 BIT;    /* Bit Access       */
} __type1642;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type266 BIT;    /* Bit Access       */
} __type1643;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type267 BIT;    /* Bit Access       */
} __type1644;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type268 BIT;    /* Bit Access       */
} __type1645;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type269 BIT;    /* Bit Access       */
} __type1646;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type270 BIT;    /* Bit Access       */
} __type1647;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type271 BIT;    /* Bit Access       */
} __type1648;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type272 BIT;    /* Bit Access       */
} __type1649;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type273 BIT;    /* Bit Access       */
} __type1650;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type274 BIT;    /* Bit Access       */
} __type1651;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type275 BIT;    /* Bit Access       */
} __type1652;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type276 BIT;    /* Bit Access       */
} __type1653;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type277 BIT;    /* Bit Access       */
} __type1654;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type278 BIT;    /* Bit Access       */
} __type1655;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type279 BIT;    /* Bit Access       */
} __type1656;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type280 BIT;    /* Bit Access       */
} __type1657;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type281 BIT;    /* Bit Access       */
} __type1658;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type282 BIT;   /* Bit Access       */
} __type1659;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type283 BIT;    /* Bit Access       */
} __type1660;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type284 BIT;   /* Bit Access       */
} __type1661;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type285 BIT;   /* Bit Access       */
} __type1662;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type286 BIT;   /* Bit Access       */
} __type1663;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type287 BIT;   /* Bit Access       */
} __type1664;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type288 BIT;   /* Bit Access       */
} __type1665;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type289 BIT;   /* Bit Access       */
} __type1666;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type290 BIT;    /* Bit Access       */
} __type1667;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type291 BIT;    /* Bit Access       */
} __type1668;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type292 BIT;   /* Bit Access       */
} __type1669;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type293 BIT;    /* Bit Access       */
} __type1670;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type294 BIT;    /* Bit Access       */
} __type1671;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type295 BIT;    /* Bit Access       */
} __type1672;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type296 BIT;    /* Bit Access       */
} __type1673;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type297 BIT;    /* Bit Access       */
} __type1674;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type298 BIT;    /* Bit Access       */
} __type1675;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type299 BIT;   /* Bit Access       */
} __type1676;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type300 BIT;   /* Bit Access       */
} __type1677;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type301 BIT;   /* Bit Access       */
} __type1678;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type302 BIT;   /* Bit Access       */
} __type1679;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type303 BIT;    /* Bit Access       */
} __type1680;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type304 BIT;    /* Bit Access       */
} __type1681;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type305 BIT;   /* Bit Access       */
} __type1682;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type306 BIT;   /* Bit Access       */
} __type1683;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type307 BIT;    /* Bit Access       */
} __type1684;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type308 BIT;    /* Bit Access       */
} __type1685;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type309 BIT;    /* Bit Access       */
} __type1686;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type310 BIT;    /* Bit Access       */
} __type1687;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type311 BIT;    /* Bit Access       */
} __type1688;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type312 BIT;          /* Bit Access       */
} __type1689;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type313 BIT;   /* Bit Access       */
} __type1690;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type314 BIT;   /* Bit Access       */
} __type1691;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type315 BIT;   /* Bit Access       */
} __type1692;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type316 BIT;    /* Bit Access       */
} __type1693;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type317 BIT;    /* Bit Access       */
} __type1694;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type318 BIT;          /* Bit Access       */
} __type1695;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type319 BIT;    /* Bit Access       */
} __type1696;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type320 BIT;    /* Bit Access       */
} __type1697;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type321 BIT;    /* Bit Access       */
} __type1698;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type322 BIT;   /* Bit Access       */
} __type1699;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type323 BIT;    /* Bit Access       */
} __type1700;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type324 BIT;   /* Bit Access       */
} __type1701;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type325 BIT;   /* Bit Access       */
} __type1702;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type326 BIT;    /* Bit Access       */
} __type1703;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type327 BIT;    /* Bit Access       */
} __type1704;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type328 BIT;    /* Bit Access       */
} __type1705;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type329 BIT;   /* Bit Access       */
} __type1706;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type330 BIT;   /* Bit Access       */
} __type1707;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type331 BIT;    /* Bit Access       */
} __type1708;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type332 BIT;    /* Bit Access       */
} __type1709;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type333 BIT;    /* Bit Access       */
} __type1710;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type334 BIT;   /* Bit Access       */
} __type1711;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type335 BIT;    /* Bit Access       */
} __type1712;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type336 BIT;    /* Bit Access       */
} __type1713;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type337 BIT;    /* Bit Access       */
} __type1714;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type338 BIT;    /* Bit Access       */
} __type1715;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type339 BIT;    /* Bit Access       */
} __type1716;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type340 BIT;    /* Bit Access       */
} __type1717;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type341 BIT;    /* Bit Access       */
} __type1718;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type342 BIT;   /* Bit Access       */
} __type1719;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type343 BIT;   /* Bit Access       */
} __type1720;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type344 BIT;    /* Bit Access       */
} __type1721;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type345 BIT;    /* Bit Access       */
} __type1722;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type346 BIT;    /* Bit Access       */
} __type1723;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type347 BIT;    /* Bit Access       */
} __type1724;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type348 BIT;    /* Bit Access       */
} __type1725;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type349 BIT;    /* Bit Access       */
} __type1726;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type350 BIT;          /* Bit Access       */
} __type1727;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type351 BIT;    /* Bit Access       */
} __type1728;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type352 BIT;    /* Bit Access       */
} __type1729;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type353 BIT;    /* Bit Access       */
} __type1730;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type354 BIT;    /* Bit Access       */
} __type1731;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type355 BIT;   /* Bit Access       */
} __type1732;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type356 BIT;          /* Bit Access       */
} __type1733;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type357 BIT;          /* Bit Access       */
} __type1734;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type358 BIT;   /* Bit Access       */
} __type1735;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type359 BIT;    /* Bit Access       */
} __type1736;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type360 BIT;    /* Bit Access       */
} __type1737;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type361 BIT;    /* Bit Access       */
} __type1738;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type362 BIT;    /* Bit Access       */
} __type1739;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type363 BIT;    /* Bit Access       */
} __type1740;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type364 BIT;    /* Bit Access       */
} __type1741;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type365 BIT;    /* Bit Access       */
} __type1742;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type366 BIT;    /* Bit Access       */
} __type1743;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type367 BIT;    /* Bit Access       */
} __type1744;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type368 BIT;    /* Bit Access       */
} __type1745;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type369 BIT;    /* Bit Access       */
} __type1746;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type370 BIT;    /* Bit Access       */
} __type1747;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type371 BIT;    /* Bit Access       */
} __type1748;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type372 BIT;    /* Bit Access       */
} __type1749;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type373 BIT;    /* Bit Access       */
} __type1750;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type374 BIT;   /* Bit Access       */
} __type1751;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type375 BIT;    /* Bit Access       */
} __type1752;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type376 BIT;    /* Bit Access       */
} __type1753;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type377 BIT;    /* Bit Access       */
} __type1754;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type378 BIT;    /* Bit Access       */
} __type1755;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type379 BIT;    /* Bit Access       */
} __type1756;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type380 BIT;   /* Bit Access       */
} __type1757;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type381 BIT;   /* Bit Access       */
} __type1758;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type382 BIT;   /* Bit Access       */
} __type1759;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type383 BIT;   /* Bit Access       */
} __type1760;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type384 BIT;   /* Bit Access       */
} __type1761;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type385 BIT;   /* Bit Access       */
} __type1762;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type386 BIT;   /* Bit Access       */
} __type1763;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type387 BIT;   /* Bit Access       */
} __type1764;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } FSGD0BPROT0_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } FSGD0BPROT0_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT0_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT0_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT0_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT0_HH;
    } REGS8;
    __type388 BIT; /* Bit Access       */
} __type1765;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } FSGD0BPROT1_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } FSGD0BPROT1_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT1_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT1_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT1_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } FSGD0BPROT1_HH;
    } REGS8;
    __type388 BIT; /* Bit Access       */
} __type1766;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ERRSLV0BCTL_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ERRSLV0BCTL_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BCTL_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BCTL_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BCTL_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BCTL_HH;
    } REGS8;
    __type389 BIT; /* Bit Access       */
} __type1767;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ERRSLV0BSTAT_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ERRSLV0BSTAT_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BSTAT_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BSTAT_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BSTAT_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BSTAT_HH;
    } REGS8;
    const __type390 BIT; /* Bit Access       */
} __type1768;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type391 BIT;    /* Bit Access       */
} __type1769;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ERRSLV0BTYPE_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ERRSLV0BTYPE_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BTYPE_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BTYPE_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BTYPE_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERRSLV0BTYPE_HH;
    } REGS8;
    const __type392 BIT; /* Bit Access       */
} __type1770;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type393 BIT;          /* Bit Access       */
} __type1771;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type389 BIT;          /* Bit Access       */
} __type1772;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type390 BIT;          /* Bit Access       */
} __type1773;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type394 BIT;          /* Bit Access       */
} __type1774;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type395 BIT;          /* Bit Access       */
} __type1775;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } EPC_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } EPC_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } EPC_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } EPC_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } EPC_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } EPC_HH;
    } REGS8;
    __type396 BIT; /* Bit Access       */
} __type1776;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type397 BIT;   /* Bit Access       */
} __type1777;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type398 BIT;   /* Bit Access       */
} __type1778;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDECCCTL_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDECCCTL_PE1_OS_H;
    } REGS16;
    __type399 BIT; /* Bit Access       */
} __type1779;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDERRINT_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDERRINT_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDERRINT_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDERRINT_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDERRINT_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDERRINT_PE1_OS_HH;
    } REGS8;
    __type400 BIT; /* Bit Access       */
} __type1780;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDSTCLR_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDSTCLR_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDSTCLR_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDSTCLR_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDSTCLR_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDSTCLR_PE1_OS_HH;
    } REGS8;
    __type401 BIT; /* Bit Access       */
} __type1781;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDOVFSTR_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IDOVFSTR_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDOVFSTR_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDOVFSTR_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDOVFSTR_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IDOVFSTR_PE1_OS_HH;
    } REGS8;
    const __type402 BIT; /* Bit Access       */
} __type1782;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ID1STERSTR_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ID1STERSTR_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STERSTR_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STERSTR_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STERSTR_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STERSTR_PE1_OS_HH;
    } REGS8;
    const __type403 BIT; /* Bit Access       */
} __type1783;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ID1STEADR0_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ID1STEADR0_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR0_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR0_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR0_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR0_PE1_OS_HH;
    } REGS8;
    const __type404 BIT; /* Bit Access       */
} __type1784;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ID1STEADR1_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ID1STEADR1_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR1_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR1_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR1_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ID1STEADR1_PE1_OS_HH;
    } REGS8;
    const __type405 BIT; /* Bit Access       */
} __type1785;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITECCCTL_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITECCCTL_PE1_OS_H;
    } REGS16;
    __type399 BIT; /* Bit Access       */
} __type1786;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITERRINT_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITERRINT_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITERRINT_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITERRINT_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITERRINT_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITERRINT_PE1_OS_HH;
    } REGS8;
    __type400 BIT; /* Bit Access       */
} __type1787;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITSTCLR_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITSTCLR_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITSTCLR_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITSTCLR_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITSTCLR_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITSTCLR_PE1_OS_HH;
    } REGS8;
    __type406 BIT; /* Bit Access       */
} __type1788;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITOVFSTR_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } ITOVFSTR_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITOVFSTR_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITOVFSTR_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITOVFSTR_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ITOVFSTR_PE1_OS_HH;
    } REGS8;
    const __type407 BIT; /* Bit Access       */
} __type1789;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IT1STERSTR_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IT1STERSTR_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STERSTR_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STERSTR_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STERSTR_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STERSTR_PE1_OS_HH;
    } REGS8;
    const __type408 BIT; /* Bit Access       */
} __type1790;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IT1STEADR0_PE1_OS_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IT1STEADR0_PE1_OS_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STEADR0_PE1_OS_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STEADR0_PE1_OS_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STEADR0_PE1_OS_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IT1STEADR0_PE1_OS_HH;
    } REGS8;
    const __type409 BIT; /* Bit Access       */
} __type1791;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type410 BIT;    /* Bit Access       */
} __type1792;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type411 BIT;    /* Bit Access       */
} __type1793;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type412 BIT;    /* Bit Access       */
} __type1794;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type413 BIT;    /* Bit Access       */
} __type1795;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type414 BIT;    /* Bit Access       */
} __type1796;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type415 BIT;    /* Bit Access       */
} __type1797;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type416 BIT;    /* Bit Access       */
} __type1798;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type417 BIT;    /* Bit Access       */
} __type1799;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type418 BIT;    /* Bit Access       */
} __type1800;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type419 BIT;          /* Bit Access       */
} __type1801;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type420 BIT;    /* Bit Access       */
} __type1802;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type421 BIT;    /* Bit Access       */
} __type1803;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type422 BIT;          /* Bit Access       */
} __type1804;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type400 BIT;          /* Bit Access       */
} __type1805;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type423 BIT;          /* Bit Access       */
} __type1806;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type424 BIT;          /* Bit Access       */
} __type1807;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type425 BIT;          /* Bit Access       */
} __type1808;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type426 BIT;          /* Bit Access       */
} __type1809;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type427 BIT;    /* Bit Access       */
} __type1810;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type428 BIT;    /* Bit Access       */
} __type1811;
typedef union
{                       /* IOR              */
    uint32 UINT32;      /* 32-bit Access    */
    uint8  UINT8 [ 4 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERDB;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ECRD;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } HORD;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } SYND;
    } REGS8;
    __type429 BIT; /* Bit Access       */
} __type1812;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type430 BIT;    /* Bit Access       */
} __type1813;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type431 BIT;    /* Bit Access       */
} __type1814;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type432 BIT;    /* Bit Access       */
} __type1815;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type433 BIT;    /* Bit Access       */
} __type1816;
typedef union
{                       /* IOR              */
    uint32 UINT32;      /* 32-bit Access    */
    uint8  UINT8 [ 4 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ERDB;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } ECRD;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } HORD;
        uint8 dummy0 [ 1 ]; /* Reserved         */
    } REGS8;
} __type1817;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type434 BIT;   /* Bit Access       */
} __type1818;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type435 BIT;   /* Bit Access       */
} __type1819;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type436 BIT;    /* Bit Access       */
} __type1820;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type437 BIT;    /* Bit Access       */
} __type1821;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type438 BIT;    /* Bit Access       */
} __type1822;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type439 BIT;    /* Bit Access       */
} __type1823;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type440 BIT;    /* Bit Access       */
} __type1824;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type441 BIT;   /* Bit Access       */
} __type1825;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } LBRP0;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } LBRP1;
    } REGS8;
    __type442 BIT; /* Bit Access       */
} __type1826;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type443 BIT;   /* Bit Access       */
} __type1827;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type444 BIT;   /* Bit Access       */
} __type1828;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type445 BIT;   /* Bit Access       */
} __type1829;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type446 BIT;   /* Bit Access       */
} __type1830;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type447 BIT;   /* Bit Access       */
} __type1831;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type448 BIT;   /* Bit Access       */
} __type1832;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type449 BIT;   /* Bit Access       */
} __type1833;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type450 BIT;   /* Bit Access       */
} __type1834;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type451 BIT;   /* Bit Access       */
} __type1835;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type452 BIT;   /* Bit Access       */
} __type1836;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type453 BIT;   /* Bit Access       */
} __type1837;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type454 BIT;   /* Bit Access       */
} __type1838;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type455 BIT;   /* Bit Access       */
} __type1839;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type456 BIT;   /* Bit Access       */
} __type1840;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type457 BIT;   /* Bit Access       */
} __type1841;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type458 BIT;   /* Bit Access       */
} __type1842;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type459 BIT;   /* Bit Access       */
} __type1843;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type460 BIT;   /* Bit Access       */
} __type1844;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type461 BIT;   /* Bit Access       */
} __type1845;
typedef union
{                          /* IOR              */
    uint16    UINT16;      /* 16-bit Access    */
    uint8     UINT8 [ 2 ]; /* 8-bit Access     */
    __type462 BIT;         /* Bit Access       */
} __type1846;
typedef union
{                                /* IOR              */
    uint16          UINT16;      /* 16-bit Access    */
    uint8           UINT8 [ 2 ]; /* 8-bit Access     */
    const __type463 BIT;         /* Bit Access       */
} __type1847;
typedef union
{                          /* IOR              */
    uint16    UINT16;      /* 16-bit Access    */
    uint8     UINT8 [ 2 ]; /* 8-bit Access     */
    __type464 BIT;         /* Bit Access       */
} __type1848;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type465 BIT;          /* Bit Access       */
} __type1849;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type466 BIT;          /* Bit Access       */
} __type1850;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type467 BIT;          /* Bit Access       */
} __type1851;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type468 BIT;          /* Bit Access       */
} __type1852;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type469 BIT;          /* Bit Access       */
} __type1853;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type470 BIT;          /* Bit Access       */
} __type1854;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type471 BIT;          /* Bit Access       */
} __type1855;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type472 BIT;          /* Bit Access       */
} __type1856;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type473 BIT;          /* Bit Access       */
} __type1857;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type474 BIT;          /* Bit Access       */
} __type1858;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type475 BIT;          /* Bit Access       */
} __type1859;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type476 BIT;          /* Bit Access       */
} __type1860;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type477 BIT;          /* Bit Access       */
} __type1861;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type478 BIT;          /* Bit Access       */
} __type1862;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type479 BIT;          /* Bit Access       */
} __type1863;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type480 BIT;          /* Bit Access       */
} __type1864;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type481 BIT;          /* Bit Access       */
} __type1865;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type482 BIT;          /* Bit Access       */
} __type1866;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type483 BIT;          /* Bit Access       */
} __type1867;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type484 BIT;          /* Bit Access       */
} __type1868;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type485 BIT;          /* Bit Access       */
} __type1869;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type486 BIT;          /* Bit Access       */
} __type1870;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type487 BIT;          /* Bit Access       */
} __type1871;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type488 BIT;          /* Bit Access       */
} __type1872;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type489 BIT;          /* Bit Access       */
} __type1873;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type490 BIT;          /* Bit Access       */
} __type1874;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type491 BIT;   /* Bit Access       */
} __type1875;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type492 BIT;   /* Bit Access       */
} __type1876;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type493 BIT;          /* Bit Access       */
} __type1877;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type494 BIT;          /* Bit Access       */
} __type1878;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type495 BIT;          /* Bit Access       */
} __type1879;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type496 BIT;          /* Bit Access       */
} __type1880;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type497 BIT;          /* Bit Access       */
} __type1881;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type498 BIT;          /* Bit Access       */
} __type1882;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type499 BIT;          /* Bit Access       */
} __type1883;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type500 BIT;          /* Bit Access       */
} __type1884;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type501 BIT;          /* Bit Access       */
} __type1885;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type502 BIT;          /* Bit Access       */
} __type1886;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type503 BIT;          /* Bit Access       */
} __type1887;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type504 BIT;          /* Bit Access       */
} __type1888;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type505 BIT;          /* Bit Access       */
} __type1889;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type506 BIT;          /* Bit Access       */
} __type1890;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type507 BIT;          /* Bit Access       */
} __type1891;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type508 BIT;          /* Bit Access       */
} __type1892;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type509 BIT;          /* Bit Access       */
} __type1893;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type510 BIT;          /* Bit Access       */
} __type1894;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type511 BIT;          /* Bit Access       */
} __type1895;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type512 BIT;          /* Bit Access       */
} __type1896;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type513 BIT;          /* Bit Access       */
} __type1897;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type514 BIT;          /* Bit Access       */
} __type1898;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type515 BIT;          /* Bit Access       */
} __type1899;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type516 BIT;          /* Bit Access       */
} __type1900;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type517 BIT;          /* Bit Access       */
} __type1901;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type518 BIT;          /* Bit Access       */
} __type1902;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type519 BIT;          /* Bit Access       */
} __type1903;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type520 BIT;          /* Bit Access       */
} __type1904;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type521 BIT;          /* Bit Access       */
} __type1905;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type522 BIT;          /* Bit Access       */
} __type1906;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type523 BIT;          /* Bit Access       */
} __type1907;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type524 BIT;          /* Bit Access       */
} __type1908;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type525 BIT;          /* Bit Access       */
} __type1909;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type526 BIT;          /* Bit Access       */
} __type1910;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type527 BIT;          /* Bit Access       */
} __type1911;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type528 BIT;          /* Bit Access       */
} __type1912;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type529 BIT;          /* Bit Access       */
} __type1913;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type530 BIT;          /* Bit Access       */
} __type1914;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type531 BIT;          /* Bit Access       */
} __type1915;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type532 BIT;          /* Bit Access       */
} __type1916;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type533 BIT;          /* Bit Access       */
} __type1917;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type534 BIT;          /* Bit Access       */
} __type1918;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type535 BIT;   /* Bit Access       */
} __type1919;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type536 BIT;    /* Bit Access       */
} __type1920;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type537 BIT;    /* Bit Access       */
} __type1921;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type538 BIT;    /* Bit Access       */
} __type1922;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type539 BIT;    /* Bit Access       */
} __type1923;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type540 BIT;   /* Bit Access       */
} __type1924;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type541 BIT;   /* Bit Access       */
} __type1925;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type542 BIT;    /* Bit Access       */
} __type1926;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type543 BIT;    /* Bit Access       */
} __type1927;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type544 BIT;    /* Bit Access       */
} __type1928;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type545 BIT;    /* Bit Access       */
} __type1929;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type546 BIT;    /* Bit Access       */
} __type1930;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type547 BIT;   /* Bit Access       */
} __type1931;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type548 BIT;    /* Bit Access       */
} __type1932;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type549 BIT;    /* Bit Access       */
} __type1933;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type550 BIT;    /* Bit Access       */
} __type1934;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type551 BIT;    /* Bit Access       */
} __type1935;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type552 BIT;    /* Bit Access       */
} __type1936;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type553 BIT;    /* Bit Access       */
} __type1937;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type554 BIT;    /* Bit Access       */
} __type1938;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type555 BIT;    /* Bit Access       */
} __type1939;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type556 BIT;    /* Bit Access       */
} __type1940;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type557 BIT;    /* Bit Access       */
} __type1941;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type558 BIT;    /* Bit Access       */
} __type1942;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type559 BIT;    /* Bit Access       */
} __type1943;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type560 BIT;    /* Bit Access       */
} __type1944;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type561 BIT;    /* Bit Access       */
} __type1945;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type562 BIT;    /* Bit Access       */
} __type1946;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type563 BIT;          /* Bit Access       */
} __type1947;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type564 BIT;          /* Bit Access       */
} __type1948;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type565 BIT;          /* Bit Access       */
} __type1949;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type566 BIT;          /* Bit Access       */
} __type1950;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type567 BIT;          /* Bit Access       */
} __type1951;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type568 BIT;          /* Bit Access       */
} __type1952;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type569 BIT;          /* Bit Access       */
} __type1953;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type570 BIT;          /* Bit Access       */
} __type1954;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type571 BIT;          /* Bit Access       */
} __type1955;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type572 BIT;          /* Bit Access       */
} __type1956;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type573 BIT;          /* Bit Access       */
} __type1957;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type574 BIT;          /* Bit Access       */
} __type1958;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type575 BIT;          /* Bit Access       */
} __type1959;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type576 BIT;          /* Bit Access       */
} __type1960;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type577 BIT;          /* Bit Access       */
} __type1961;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type578 BIT;          /* Bit Access       */
} __type1962;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type579 BIT;          /* Bit Access       */
} __type1963;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type580 BIT;    /* Bit Access       */
} __type1964;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type581 BIT;    /* Bit Access       */
} __type1965;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type582 BIT;    /* Bit Access       */
} __type1966;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type583 BIT;    /* Bit Access       */
} __type1967;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type584 BIT;    /* Bit Access       */
} __type1968;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type585 BIT;    /* Bit Access       */
} __type1969;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type586 BIT;   /* Bit Access       */
} __type1970;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type587 BIT;   /* Bit Access       */
} __type1971;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type588 BIT;   /* Bit Access       */
} __type1972;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type589 BIT;    /* Bit Access       */
} __type1973;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type590 BIT;    /* Bit Access       */
} __type1974;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type591 BIT;    /* Bit Access       */
} __type1975;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type592 BIT;    /* Bit Access       */
} __type1976;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type593 BIT;    /* Bit Access       */
} __type1977;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type594 BIT;    /* Bit Access       */
} __type1978;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type595 BIT;    /* Bit Access       */
} __type1979;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type596 BIT;    /* Bit Access       */
} __type1980;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type597 BIT;    /* Bit Access       */
} __type1981;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type598 BIT;    /* Bit Access       */
} __type1982;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type599 BIT;    /* Bit Access       */
} __type1983;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type600 BIT;    /* Bit Access       */
} __type1984;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type601 BIT;    /* Bit Access       */
} __type1985;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type602 BIT;   /* Bit Access       */
} __type1986;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type603 BIT;   /* Bit Access       */
} __type1987;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type604 BIT;   /* Bit Access       */
} __type1988;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type605 BIT;   /* Bit Access       */
} __type1989;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type606 BIT;   /* Bit Access       */
} __type1990;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type607 BIT;   /* Bit Access       */
} __type1991;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type608 BIT;   /* Bit Access       */
} __type1992;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type609 BIT;    /* Bit Access       */
} __type1993;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type610 BIT;    /* Bit Access       */
} __type1994;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type611 BIT;   /* Bit Access       */
} __type1995;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type612 BIT;   /* Bit Access       */
} __type1996;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type613 BIT;   /* Bit Access       */
} __type1997;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type614 BIT;   /* Bit Access       */
} __type1998;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type615 BIT;   /* Bit Access       */
} __type1999;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type616 BIT;   /* Bit Access       */
} __type2000;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type617 BIT;    /* Bit Access       */
} __type2001;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type618 BIT;    /* Bit Access       */
} __type2002;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type619 BIT;   /* Bit Access       */
} __type2003;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type620 BIT;    /* Bit Access       */
} __type2004;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type621 BIT;   /* Bit Access       */
} __type2005;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type622 BIT;   /* Bit Access       */
} __type2006;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type623 BIT;   /* Bit Access       */
} __type2007;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type624 BIT;   /* Bit Access       */
} __type2008;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type625 BIT;   /* Bit Access       */
} __type2009;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type626 BIT;   /* Bit Access       */
} __type2010;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type627 BIT;   /* Bit Access       */
} __type2011;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type628 BIT;   /* Bit Access       */
} __type2012;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type629 BIT;   /* Bit Access       */
} __type2013;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type630 BIT;    /* Bit Access       */
} __type2014;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type631 BIT;    /* Bit Access       */
} __type2015;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type632 BIT;    /* Bit Access       */
} __type2016;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type633 BIT;    /* Bit Access       */
} __type2017;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type634 BIT;    /* Bit Access       */
} __type2018;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type635 BIT;   /* Bit Access       */
} __type2019;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type636 BIT;   /* Bit Access       */
} __type2020;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type637 BIT;    /* Bit Access       */
} __type2021;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type638 BIT;   /* Bit Access       */
} __type2022;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type639 BIT;    /* Bit Access       */
} __type2023;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type640 BIT;    /* Bit Access       */
} __type2024;
typedef union
{                           /* IOR              */
    uint16          UINT16; /* 16-bit Access    */
    const __type641 BIT;    /* Bit Access       */
} __type2025;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type642 BIT;    /* Bit Access       */
} __type2026;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type643 BIT;    /* Bit Access       */
} __type2027;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type644 BIT;    /* Bit Access       */
} __type2028;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type645 BIT;    /* Bit Access       */
} __type2029;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type646 BIT;   /* Bit Access       */
} __type2030;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type647 BIT;   /* Bit Access       */
} __type2031;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type648 BIT;   /* Bit Access       */
} __type2032;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type649 BIT;   /* Bit Access       */
} __type2033;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type650 BIT;   /* Bit Access       */
} __type2034;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type651 BIT;   /* Bit Access       */
} __type2035;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type652 BIT;   /* Bit Access       */
} __type2036;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type653 BIT;   /* Bit Access       */
} __type2037;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type654 BIT;   /* Bit Access       */
} __type2038;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type655 BIT;   /* Bit Access       */
} __type2039;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type656 BIT;   /* Bit Access       */
} __type2040;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type657 BIT;   /* Bit Access       */
} __type2041;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type658 BIT;   /* Bit Access       */
} __type2042;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type659 BIT;   /* Bit Access       */
} __type2043;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type660 BIT;   /* Bit Access       */
} __type2044;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type661 BIT;    /* Bit Access       */
} __type2045;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type662 BIT;    /* Bit Access       */
} __type2046;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type663 BIT;    /* Bit Access       */
} __type2047;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type664 BIT;    /* Bit Access       */
} __type2048;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type665 BIT;    /* Bit Access       */
} __type2049;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type666 BIT;    /* Bit Access       */
} __type2050;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type667 BIT;   /* Bit Access       */
} __type2051;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type668 BIT;   /* Bit Access       */
} __type2052;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type669 BIT;   /* Bit Access       */
} __type2053;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type670 BIT;   /* Bit Access       */
} __type2054;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type671 BIT;   /* Bit Access       */
} __type2055;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type672 BIT;   /* Bit Access       */
} __type2056;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type673 BIT;   /* Bit Access       */
} __type2057;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type674 BIT;   /* Bit Access       */
} __type2058;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type675 BIT;   /* Bit Access       */
} __type2059;
typedef union
{                     /* IOR              */
    uint16    UINT16; /* 16-bit Access    */
    __type676 BIT;    /* Bit Access       */
} __type2060;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type677 BIT;   /* Bit Access       */
} __type2061;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type678 BIT;   /* Bit Access       */
} __type2062;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type679 BIT;   /* Bit Access       */
} __type2063;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type680 BIT;   /* Bit Access       */
} __type2064;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type681 BIT;   /* Bit Access       */
} __type2065;
typedef union
{                          /* IOR              */
    uint8           UINT8; /* 8-bit Access     */
    const __type682 BIT;   /* Bit Access       */
} __type2066;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type683 BIT;   /* Bit Access       */
} __type2067;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type684 BIT;   /* Bit Access       */
} __type2068;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type685 BIT;   /* Bit Access       */
} __type2069;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type686 BIT;   /* Bit Access       */
} __type2070;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type687 BIT;   /* Bit Access       */
} __type2071;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type688 BIT;    /* Bit Access       */
} __type2072;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type689 BIT;    /* Bit Access       */
} __type2073;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type690 BIT;    /* Bit Access       */
} __type2074;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type691 BIT;    /* Bit Access       */
} __type2075;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type692 BIT;    /* Bit Access       */
} __type2076;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type693 BIT;    /* Bit Access       */
} __type2077;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type694 BIT;    /* Bit Access       */
} __type2078;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type695 BIT;    /* Bit Access       */
} __type2079;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type696 BIT;    /* Bit Access       */
} __type2080;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type697 BIT;    /* Bit Access       */
} __type2081;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type698 BIT;    /* Bit Access       */
} __type2082;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type699 BIT;    /* Bit Access       */
} __type2083;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type700 BIT;    /* Bit Access       */
} __type2084;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type701 BIT;    /* Bit Access       */
} __type2085;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type702 BIT;    /* Bit Access       */
} __type2086;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type703 BIT;    /* Bit Access       */
} __type2087;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type704 BIT;    /* Bit Access       */
} __type2088;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type705 BIT;    /* Bit Access       */
} __type2089;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type706 BIT;    /* Bit Access       */
} __type2090;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type707 BIT;    /* Bit Access       */
} __type2091;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type708 BIT;    /* Bit Access       */
} __type2092;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type709 BIT;    /* Bit Access       */
} __type2093;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type710 BIT;    /* Bit Access       */
} __type2094;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type711 BIT;    /* Bit Access       */
} __type2095;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type712 BIT;    /* Bit Access       */
} __type2096;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type713 BIT;    /* Bit Access       */
} __type2097;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type714 BIT;    /* Bit Access       */
} __type2098;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type715 BIT;    /* Bit Access       */
} __type2099;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type716 BIT;    /* Bit Access       */
} __type2100;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type717 BIT;    /* Bit Access       */
} __type2101;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type718 BIT;    /* Bit Access       */
} __type2102;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type719 BIT;    /* Bit Access       */
} __type2103;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type720 BIT;    /* Bit Access       */
} __type2104;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type721 BIT;    /* Bit Access       */
} __type2105;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type722 BIT;    /* Bit Access       */
} __type2106;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type723 BIT;    /* Bit Access       */
} __type2107;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type724 BIT;    /* Bit Access       */
} __type2108;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type725 BIT;    /* Bit Access       */
} __type2109;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type726 BIT;    /* Bit Access       */
} __type2110;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type727 BIT;    /* Bit Access       */
} __type2111;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type728 BIT;    /* Bit Access       */
} __type2112;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type729 BIT;    /* Bit Access       */
} __type2113;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type730 BIT;    /* Bit Access       */
} __type2114;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type731 BIT;    /* Bit Access       */
} __type2115;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type732 BIT;    /* Bit Access       */
} __type2116;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type733 BIT;    /* Bit Access       */
} __type2117;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type734 BIT;    /* Bit Access       */
} __type2118;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type735 BIT;    /* Bit Access       */
} __type2119;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type736 BIT;    /* Bit Access       */
} __type2120;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type737 BIT;    /* Bit Access       */
} __type2121;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type738 BIT;    /* Bit Access       */
} __type2122;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type739 BIT;    /* Bit Access       */
} __type2123;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type740 BIT;    /* Bit Access       */
} __type2124;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type741 BIT;    /* Bit Access       */
} __type2125;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type742 BIT;    /* Bit Access       */
} __type2126;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type743 BIT;    /* Bit Access       */
} __type2127;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type744 BIT;    /* Bit Access       */
} __type2128;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type745 BIT;    /* Bit Access       */
} __type2129;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type746 BIT;    /* Bit Access       */
} __type2130;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type747 BIT;    /* Bit Access       */
} __type2131;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type748 BIT;    /* Bit Access       */
} __type2132;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type749 BIT;    /* Bit Access       */
} __type2133;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type750 BIT;    /* Bit Access       */
} __type2134;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type751 BIT;    /* Bit Access       */
} __type2135;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type752 BIT;    /* Bit Access       */
} __type2136;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type753 BIT;    /* Bit Access       */
} __type2137;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type754 BIT;    /* Bit Access       */
} __type2138;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type755 BIT;    /* Bit Access       */
} __type2139;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type756 BIT;    /* Bit Access       */
} __type2140;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type757 BIT;    /* Bit Access       */
} __type2141;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type758 BIT;    /* Bit Access       */
} __type2142;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type759 BIT;    /* Bit Access       */
} __type2143;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type760 BIT;    /* Bit Access       */
} __type2144;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type761 BIT;    /* Bit Access       */
} __type2145;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type762 BIT;    /* Bit Access       */
} __type2146;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type763 BIT;    /* Bit Access       */
} __type2147;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type764 BIT;    /* Bit Access       */
} __type2148;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type765 BIT;    /* Bit Access       */
} __type2149;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type766 BIT;    /* Bit Access       */
} __type2150;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type767 BIT;    /* Bit Access       */
} __type2151;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type768 BIT;    /* Bit Access       */
} __type2152;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type769 BIT;    /* Bit Access       */
} __type2153;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type770 BIT;    /* Bit Access       */
} __type2154;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type771 BIT;    /* Bit Access       */
} __type2155;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type772 BIT;    /* Bit Access       */
} __type2156;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type773 BIT;    /* Bit Access       */
} __type2157;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type774 BIT;    /* Bit Access       */
} __type2158;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type775 BIT;    /* Bit Access       */
} __type2159;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type776 BIT;    /* Bit Access       */
} __type2160;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type777 BIT;    /* Bit Access       */
} __type2161;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type778 BIT;    /* Bit Access       */
} __type2162;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type779 BIT;    /* Bit Access       */
} __type2163;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type780 BIT;    /* Bit Access       */
} __type2164;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type781 BIT;    /* Bit Access       */
} __type2165;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type782 BIT;    /* Bit Access       */
} __type2166;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type783 BIT;    /* Bit Access       */
} __type2167;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type784 BIT;    /* Bit Access       */
} __type2168;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type785 BIT;    /* Bit Access       */
} __type2169;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type786 BIT;    /* Bit Access       */
} __type2170;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type787 BIT;    /* Bit Access       */
} __type2171;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type788 BIT;    /* Bit Access       */
} __type2172;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type789 BIT;    /* Bit Access       */
} __type2173;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type790 BIT;    /* Bit Access       */
} __type2174;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type791 BIT;    /* Bit Access       */
} __type2175;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type792 BIT;    /* Bit Access       */
} __type2176;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type793 BIT;    /* Bit Access       */
} __type2177;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type794 BIT;    /* Bit Access       */
} __type2178;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type795 BIT;    /* Bit Access       */
} __type2179;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type796 BIT;    /* Bit Access       */
} __type2180;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type797 BIT;    /* Bit Access       */
} __type2181;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type798 BIT;    /* Bit Access       */
} __type2182;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type799 BIT;    /* Bit Access       */
} __type2183;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type800 BIT;    /* Bit Access       */
} __type2184;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type801 BIT;    /* Bit Access       */
} __type2185;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type802 BIT;    /* Bit Access       */
} __type2186;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type803 BIT;    /* Bit Access       */
} __type2187;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type804 BIT;    /* Bit Access       */
} __type2188;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type805 BIT;    /* Bit Access       */
} __type2189;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type806 BIT;    /* Bit Access       */
} __type2190;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type807 BIT;    /* Bit Access       */
} __type2191;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type808 BIT;    /* Bit Access       */
} __type2192;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type809 BIT;    /* Bit Access       */
} __type2193;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type810 BIT;    /* Bit Access       */
} __type2194;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type811 BIT;    /* Bit Access       */
} __type2195;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type812 BIT;    /* Bit Access       */
} __type2196;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type813 BIT;    /* Bit Access       */
} __type2197;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type814 BIT;    /* Bit Access       */
} __type2198;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type815 BIT;    /* Bit Access       */
} __type2199;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type816 BIT;    /* Bit Access       */
} __type2200;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type817 BIT;    /* Bit Access       */
} __type2201;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type818 BIT;    /* Bit Access       */
} __type2202;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type819 BIT;    /* Bit Access       */
} __type2203;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type820 BIT;    /* Bit Access       */
} __type2204;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type821 BIT;    /* Bit Access       */
} __type2205;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type822 BIT;    /* Bit Access       */
} __type2206;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type823 BIT;    /* Bit Access       */
} __type2207;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type824 BIT;    /* Bit Access       */
} __type2208;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type825 BIT;    /* Bit Access       */
} __type2209;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type826 BIT;    /* Bit Access       */
} __type2210;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type827 BIT;    /* Bit Access       */
} __type2211;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type828 BIT;    /* Bit Access       */
} __type2212;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type829 BIT;    /* Bit Access       */
} __type2213;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type830 BIT;    /* Bit Access       */
} __type2214;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type831 BIT;    /* Bit Access       */
} __type2215;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type832 BIT;    /* Bit Access       */
} __type2216;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type833 BIT;    /* Bit Access       */
} __type2217;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type834 BIT;    /* Bit Access       */
} __type2218;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type835 BIT;    /* Bit Access       */
} __type2219;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type836 BIT;    /* Bit Access       */
} __type2220;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type837 BIT;    /* Bit Access       */
} __type2221;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type838 BIT;    /* Bit Access       */
} __type2222;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type839 BIT;    /* Bit Access       */
} __type2223;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type840 BIT;    /* Bit Access       */
} __type2224;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type841 BIT;    /* Bit Access       */
} __type2225;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type842 BIT;    /* Bit Access       */
} __type2226;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type843 BIT;    /* Bit Access       */
} __type2227;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type844 BIT;    /* Bit Access       */
} __type2228;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type845 BIT;    /* Bit Access       */
} __type2229;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type846 BIT;    /* Bit Access       */
} __type2230;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type847 BIT;    /* Bit Access       */
} __type2231;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type848 BIT;    /* Bit Access       */
} __type2232;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type849 BIT;    /* Bit Access       */
} __type2233;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type850 BIT;    /* Bit Access       */
} __type2234;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type851 BIT;    /* Bit Access       */
} __type2235;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type852 BIT;    /* Bit Access       */
} __type2236;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type853 BIT;    /* Bit Access       */
} __type2237;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type854 BIT;    /* Bit Access       */
} __type2238;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type855 BIT;    /* Bit Access       */
} __type2239;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type856 BIT;    /* Bit Access       */
} __type2240;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type857 BIT;    /* Bit Access       */
} __type2241;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type858 BIT;    /* Bit Access       */
} __type2242;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type859 BIT;    /* Bit Access       */
} __type2243;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type860 BIT;    /* Bit Access       */
} __type2244;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type861 BIT;    /* Bit Access       */
} __type2245;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type862 BIT;    /* Bit Access       */
} __type2246;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type863 BIT;    /* Bit Access       */
} __type2247;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type864 BIT;    /* Bit Access       */
} __type2248;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type865 BIT;    /* Bit Access       */
} __type2249;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type866 BIT;          /* Bit Access       */
} __type2250;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type867 BIT;          /* Bit Access       */
} __type2251;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type868 BIT;          /* Bit Access       */
} __type2252;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type869 BIT;          /* Bit Access       */
} __type2253;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type870 BIT;          /* Bit Access       */
} __type2254;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type871 BIT;          /* Bit Access       */
} __type2255;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type872 BIT;          /* Bit Access       */
} __type2256;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type873 BIT;          /* Bit Access       */
} __type2257;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type874 BIT;          /* Bit Access       */
} __type2258;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type875 BIT;          /* Bit Access       */
} __type2259;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type876 BIT;          /* Bit Access       */
} __type2260;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type877 BIT;          /* Bit Access       */
} __type2261;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type878 BIT;          /* Bit Access       */
} __type2262;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type879 BIT;          /* Bit Access       */
} __type2263;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type880 BIT;          /* Bit Access       */
} __type2264;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type881 BIT;    /* Bit Access       */
} __type2265;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type882 BIT;    /* Bit Access       */
} __type2266;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type883 BIT;    /* Bit Access       */
} __type2267;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type884 BIT;          /* Bit Access       */
} __type2268;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type885 BIT;          /* Bit Access       */
} __type2269;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type886 BIT;          /* Bit Access       */
} __type2270;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type887 BIT;          /* Bit Access       */
} __type2271;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type888 BIT;    /* Bit Access       */
} __type2272;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type889 BIT;          /* Bit Access       */
} __type2273;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    const __type890 BIT;          /* Bit Access       */
} __type2274;
typedef union
{                                 /* IOR              */
    uint32          UINT32;       /* 32-bit Access    */
    uint16          UINT16 [ 2 ]; /* 16-bit Access    */
    uint8           UINT8 [ 4 ];  /* 8-bit Access     */
    const __type891 BIT;          /* Bit Access       */
} __type2275;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type892 BIT;          /* Bit Access       */
} __type2276;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type893 BIT;          /* Bit Access       */
} __type2277;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type894 BIT;          /* Bit Access       */
} __type2278;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type895 BIT;          /* Bit Access       */
} __type2279;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type896 BIT;          /* Bit Access       */
} __type2280;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type897 BIT;    /* Bit Access       */
} __type2281;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type898 BIT;          /* Bit Access       */
} __type2282;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type899 BIT;          /* Bit Access       */
} __type2283;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type900 BIT;          /* Bit Access       */
} __type2284;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type901 BIT;          /* Bit Access       */
} __type2285;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type902 BIT;          /* Bit Access       */
} __type2286;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type903 BIT;          /* Bit Access       */
} __type2287;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type904 BIT;          /* Bit Access       */
} __type2288;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type905 BIT;          /* Bit Access       */
} __type2289;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type906 BIT;          /* Bit Access       */
} __type2290;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type907 BIT;          /* Bit Access       */
} __type2291;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type908 BIT;          /* Bit Access       */
} __type2292;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    __type909 BIT;          /* Bit Access       */
} __type2293;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type910 BIT;          /* Bit Access       */
} __type2294;
typedef union
{                           /* IOR              */
    uint32    UINT32;       /* 32-bit Access    */
    uint16    UINT16 [ 2 ]; /* 16-bit Access    */
    uint8     UINT8 [ 4 ];  /* 8-bit Access     */
    __type911 BIT;          /* Bit Access       */
} __type2295;
typedef union
{                    /* IOR              */
    uint8     UINT8; /* 8-bit Access     */
    __type912 BIT;   /* Bit Access       */
} __type2296;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type913 BIT;    /* Bit Access       */
} __type2297;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type914 BIT;    /* Bit Access       */
} __type2298;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type915 BIT;    /* Bit Access       */
} __type2299;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type916 BIT;    /* Bit Access       */
} __type2300;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type917 BIT;    /* Bit Access       */
} __type2301;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type918 BIT;    /* Bit Access       */
} __type2302;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type919 BIT;    /* Bit Access       */
} __type2303;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type920 BIT;    /* Bit Access       */
} __type2304;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type921 BIT;    /* Bit Access       */
} __type2305;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type922 BIT;    /* Bit Access       */
} __type2306;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type923 BIT;    /* Bit Access       */
} __type2307;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type924 BIT;    /* Bit Access       */
} __type2308;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type925 BIT;    /* Bit Access       */
} __type2309;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type926 BIT;    /* Bit Access       */
} __type2310;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type927 BIT;    /* Bit Access       */
} __type2311;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type928 BIT;    /* Bit Access       */
} __type2312;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type929 BIT;    /* Bit Access       */
} __type2313;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type930 BIT;    /* Bit Access       */
} __type2314;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type931 BIT;    /* Bit Access       */
} __type2315;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type932 BIT;    /* Bit Access       */
} __type2316;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type933 BIT;    /* Bit Access       */
} __type2317;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type934 BIT;    /* Bit Access       */
} __type2318;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type935 BIT;    /* Bit Access       */
} __type2319;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type936 BIT;    /* Bit Access       */
} __type2320;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type937 BIT;    /* Bit Access       */
} __type2321;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type938 BIT;    /* Bit Access       */
} __type2322;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type939 BIT;    /* Bit Access       */
} __type2323;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type940 BIT;    /* Bit Access       */
} __type2324;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type941 BIT;    /* Bit Access       */
} __type2325;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type942 BIT;    /* Bit Access       */
} __type2326;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type943 BIT;    /* Bit Access       */
} __type2327;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type944 BIT;    /* Bit Access       */
} __type2328;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type945 BIT;    /* Bit Access       */
} __type2329;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type946 BIT;    /* Bit Access       */
} __type2330;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type947 BIT;    /* Bit Access       */
} __type2331;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type948 BIT;    /* Bit Access       */
} __type2332;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type949 BIT;    /* Bit Access       */
} __type2333;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type950 BIT;    /* Bit Access       */
} __type2334;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type951 BIT;    /* Bit Access       */
} __type2335;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type952 BIT;    /* Bit Access       */
} __type2336;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type953 BIT;    /* Bit Access       */
} __type2337;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type954 BIT;    /* Bit Access       */
} __type2338;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type955 BIT;    /* Bit Access       */
} __type2339;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type956 BIT;    /* Bit Access       */
} __type2340;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type957 BIT;    /* Bit Access       */
} __type2341;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type958 BIT;    /* Bit Access       */
} __type2342;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type959 BIT;    /* Bit Access       */
} __type2343;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type960 BIT;    /* Bit Access       */
} __type2344;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type961 BIT;    /* Bit Access       */
} __type2345;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type962 BIT;    /* Bit Access       */
} __type2346;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type963 BIT;    /* Bit Access       */
} __type2347;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type964 BIT;    /* Bit Access       */
} __type2348;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type965 BIT;    /* Bit Access       */
} __type2349;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type966 BIT;    /* Bit Access       */
} __type2350;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type967 BIT;    /* Bit Access       */
} __type2351;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type968 BIT;    /* Bit Access       */
} __type2352;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type969 BIT;    /* Bit Access       */
} __type2353;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type970 BIT;    /* Bit Access       */
} __type2354;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type971 BIT;    /* Bit Access       */
} __type2355;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type972 BIT;    /* Bit Access       */
} __type2356;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type973 BIT;    /* Bit Access       */
} __type2357;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type974 BIT;    /* Bit Access       */
} __type2358;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type975 BIT;    /* Bit Access       */
} __type2359;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type976 BIT;    /* Bit Access       */
} __type2360;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type977 BIT;    /* Bit Access       */
} __type2361;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type978 BIT;    /* Bit Access       */
} __type2362;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type979 BIT;    /* Bit Access       */
} __type2363;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type980 BIT;    /* Bit Access       */
} __type2364;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type981 BIT;    /* Bit Access       */
} __type2365;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type982 BIT;    /* Bit Access       */
} __type2366;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type983 BIT;    /* Bit Access       */
} __type2367;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type984 BIT;    /* Bit Access       */
} __type2368;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type985 BIT;    /* Bit Access       */
} __type2369;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type986 BIT;    /* Bit Access       */
} __type2370;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type987 BIT;    /* Bit Access       */
} __type2371;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type988 BIT;    /* Bit Access       */
} __type2372;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type989 BIT;    /* Bit Access       */
} __type2373;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type990 BIT;    /* Bit Access       */
} __type2374;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type991 BIT;    /* Bit Access       */
} __type2375;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type992 BIT;    /* Bit Access       */
} __type2376;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type993 BIT;    /* Bit Access       */
} __type2377;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type994 BIT;    /* Bit Access       */
} __type2378;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type995 BIT;    /* Bit Access       */
} __type2379;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type996 BIT;    /* Bit Access       */
} __type2380;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type997 BIT;    /* Bit Access       */
} __type2381;
typedef union
{                     /* IOR              */
    uint32    UINT32; /* 32-bit Access    */
    __type998 BIT;    /* Bit Access       */
} __type2382;
typedef union
{                           /* IOR              */
    uint32          UINT32; /* 32-bit Access    */
    const __type999 BIT;    /* Bit Access       */
} __type2383;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1000 BIT;    /* Bit Access       */
} __type2384;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1001 BIT;    /* Bit Access       */
} __type2385;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1002 BIT;    /* Bit Access       */
} __type2386;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1003 BIT;    /* Bit Access       */
} __type2387;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1004 BIT;    /* Bit Access       */
} __type2388;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1005 BIT;    /* Bit Access       */
} __type2389;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1006 BIT;    /* Bit Access       */
} __type2390;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1007 BIT;    /* Bit Access       */
} __type2391;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1008 BIT;    /* Bit Access       */
} __type2392;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1009 BIT;    /* Bit Access       */
} __type2393;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1010 BIT;    /* Bit Access       */
} __type2394;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1011 BIT;    /* Bit Access       */
} __type2395;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1012 BIT;    /* Bit Access       */
} __type2396;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1013 BIT;    /* Bit Access       */
} __type2397;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1014 BIT;    /* Bit Access       */
} __type2398;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1015 BIT;   /* Bit Access       */
} __type2399;
typedef union
{                      /* IOR              */
    uint16     UINT16; /* 16-bit Access    */
    __type1016 BIT;    /* Bit Access       */
} __type2400;
typedef union
{                      /* IOR              */
    uint16     UINT16; /* 16-bit Access    */
    __type1017 BIT;    /* Bit Access       */
} __type2401;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1018 BIT;   /* Bit Access       */
} __type2402;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1019 BIT;   /* Bit Access       */
} __type2403;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1020 BIT;    /* Bit Access       */
} __type2404;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1021 BIT;    /* Bit Access       */
} __type2405;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1022 BIT;    /* Bit Access       */
} __type2406;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1023 BIT;    /* Bit Access       */
} __type2407;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1024 BIT;   /* Bit Access       */
} __type2408;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1025 BIT;    /* Bit Access       */
} __type2409;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1026 BIT;    /* Bit Access       */
} __type2410;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1027 BIT;    /* Bit Access       */
} __type2411;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1028 BIT;    /* Bit Access       */
} __type2412;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1029 BIT;    /* Bit Access       */
} __type2413;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1030 BIT;    /* Bit Access       */
} __type2414;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1031 BIT;    /* Bit Access       */
} __type2415;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1032 BIT;    /* Bit Access       */
} __type2416;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1033 BIT;    /* Bit Access       */
} __type2417;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1034 BIT;    /* Bit Access       */
} __type2418;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1035 BIT;    /* Bit Access       */
} __type2419;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1036 BIT;    /* Bit Access       */
} __type2420;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1037 BIT;    /* Bit Access       */
} __type2421;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1038 BIT;    /* Bit Access       */
} __type2422;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1039 BIT;    /* Bit Access       */
} __type2423;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1040 BIT;    /* Bit Access       */
} __type2424;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1041 BIT;    /* Bit Access       */
} __type2425;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1042 BIT;    /* Bit Access       */
} __type2426;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1043 BIT;    /* Bit Access       */
} __type2427;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1044 BIT;    /* Bit Access       */
} __type2428;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1045 BIT;    /* Bit Access       */
} __type2429;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1046 BIT;    /* Bit Access       */
} __type2430;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1047 BIT;    /* Bit Access       */
} __type2431;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1048 BIT;    /* Bit Access       */
} __type2432;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1049 BIT;    /* Bit Access       */
} __type2433;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1050 BIT;    /* Bit Access       */
} __type2434;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1051 BIT;    /* Bit Access       */
} __type2435;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1052 BIT;    /* Bit Access       */
} __type2436;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1053 BIT;    /* Bit Access       */
} __type2437;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1054 BIT;    /* Bit Access       */
} __type2438;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1055 BIT;    /* Bit Access       */
} __type2439;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1056 BIT;    /* Bit Access       */
} __type2440;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1057 BIT;    /* Bit Access       */
} __type2441;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1058 BIT;    /* Bit Access       */
} __type2442;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1059 BIT;    /* Bit Access       */
} __type2443;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1060 BIT;    /* Bit Access       */
} __type2444;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1061 BIT;    /* Bit Access       */
} __type2445;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1062 BIT;    /* Bit Access       */
} __type2446;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1063 BIT;    /* Bit Access       */
} __type2447;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1064 BIT;    /* Bit Access       */
} __type2448;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1065 BIT;    /* Bit Access       */
} __type2449;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1066 BIT;    /* Bit Access       */
} __type2450;
typedef union
{                      /* IOR              */
    uint16     UINT16; /* 16-bit Access    */
    __type1067 BIT;    /* Bit Access       */
} __type2451;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1068 BIT;    /* Bit Access       */
} __type2452;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1069 BIT;   /* Bit Access       */
} __type2453;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1070 BIT;   /* Bit Access       */
} __type2454;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1071 BIT;   /* Bit Access       */
} __type2455;
typedef union
{                     /* IOR              */
    uint8      UINT8; /* 8-bit Access     */
    __type1072 BIT;   /* Bit Access       */
} __type2456;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } SP_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } SP_LH;
    } REGS8;
    __type1073 BIT; /* Bit Access       */
} __type2457;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G0MK_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G0MK_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0MK_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0MK_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0MK_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0MK_HH;
    } REGS8;
    __type1074 BIT; /* Bit Access       */
} __type2458;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G0BA_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G0BA_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0BA_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0BA_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0BA_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G0BA_HH;
    } REGS8;
    __type1075 BIT; /* Bit Access       */
} __type2459;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G1MK_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G1MK_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1MK_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1MK_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1MK_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1MK_HH;
    } REGS8;
    __type1076 BIT; /* Bit Access       */
} __type2460;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G1BA_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G1BA_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1BA_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1BA_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1BA_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G1BA_HH;
    } REGS8;
    __type1077 BIT; /* Bit Access       */
} __type2461;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G2MK_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G2MK_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2MK_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2MK_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2MK_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2MK_HH;
    } REGS8;
    __type1078 BIT; /* Bit Access       */
} __type2462;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G2BA_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G2BA_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2BA_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2BA_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2BA_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G2BA_HH;
    } REGS8;
    __type1079 BIT; /* Bit Access       */
} __type2463;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G3MK_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G3MK_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3MK_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3MK_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3MK_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3MK_HH;
    } REGS8;
    __type1080 BIT; /* Bit Access       */
} __type2464;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G3BA_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } G3BA_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3BA_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3BA_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3BA_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } G3BA_HH;
    } REGS8;
    __type1081 BIT; /* Bit Access       */
} __type2465;
typedef union
{                      /* IOR              */
    uint16     UINT16; /* 16-bit Access    */
    __type1082 BIT;    /* Bit Access       */
} __type2466;
typedef union
{                      /* IOR              */
    uint16     UINT16; /* 16-bit Access    */
    __type1083 BIT;    /* Bit Access       */
} __type2467;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1084 BIT;    /* Bit Access       */
} __type2468;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC0_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC0_LH;
    } REGS8;
    __type1085 BIT; /* Bit Access       */
} __type2469;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC1_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC1_LH;
    } REGS8;
    __type1086 BIT; /* Bit Access       */
} __type2470;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC2_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC2_LH;
    } REGS8;
    __type1087 BIT; /* Bit Access       */
} __type2471;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC3_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC3_LH;
    } REGS8;
    __type1088 BIT; /* Bit Access       */
} __type2472;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC4_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC4_LH;
    } REGS8;
    __type1089 BIT; /* Bit Access       */
} __type2473;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC5_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC5_LH;
    } REGS8;
    __type1090 BIT; /* Bit Access       */
} __type2474;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC6_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC6_LH;
    } REGS8;
    __type1091 BIT; /* Bit Access       */
} __type2475;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC7_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC7_LH;
    } REGS8;
    __type1092 BIT; /* Bit Access       */
} __type2476;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC8_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC8_LH;
    } REGS8;
    __type1093 BIT; /* Bit Access       */
} __type2477;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC9_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC9_LH;
    } REGS8;
    __type1094 BIT; /* Bit Access       */
} __type2478;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC10_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC10_LH;
    } REGS8;
    __type1095 BIT; /* Bit Access       */
} __type2479;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC11_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC11_LH;
    } REGS8;
    __type1096 BIT; /* Bit Access       */
} __type2480;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC12_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC12_LH;
    } REGS8;
    __type1097 BIT; /* Bit Access       */
} __type2481;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC13_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC13_LH;
    } REGS8;
    __type1098 BIT; /* Bit Access       */
} __type2482;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC14_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC14_LH;
    } REGS8;
    __type1099 BIT; /* Bit Access       */
} __type2483;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC15_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC15_LH;
    } REGS8;
    __type1100 BIT; /* Bit Access       */
} __type2484;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC16_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC16_LH;
    } REGS8;
    __type1101 BIT; /* Bit Access       */
} __type2485;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC17_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC17_LH;
    } REGS8;
    __type1102 BIT; /* Bit Access       */
} __type2486;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC18_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC18_LH;
    } REGS8;
    __type1103 BIT; /* Bit Access       */
} __type2487;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC19_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC19_LH;
    } REGS8;
    __type1104 BIT; /* Bit Access       */
} __type2488;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC20_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC20_LH;
    } REGS8;
    __type1105 BIT; /* Bit Access       */
} __type2489;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC21_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC21_LH;
    } REGS8;
    __type1106 BIT; /* Bit Access       */
} __type2490;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC22_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC22_LH;
    } REGS8;
    __type1107 BIT; /* Bit Access       */
} __type2491;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC23_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC23_LH;
    } REGS8;
    __type1108 BIT; /* Bit Access       */
} __type2492;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC24_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC24_LH;
    } REGS8;
    __type1109 BIT; /* Bit Access       */
} __type2493;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC25_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC25_LH;
    } REGS8;
    __type1110 BIT; /* Bit Access       */
} __type2494;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC26_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC26_LH;
    } REGS8;
    __type1111 BIT; /* Bit Access       */
} __type2495;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC27_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC27_LH;
    } REGS8;
    __type1112 BIT; /* Bit Access       */
} __type2496;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC28_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC28_LH;
    } REGS8;
    __type1113 BIT; /* Bit Access       */
} __type2497;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC29_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC29_LH;
    } REGS8;
    __type1114 BIT; /* Bit Access       */
} __type2498;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC30_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC30_LH;
    } REGS8;
    __type1115 BIT; /* Bit Access       */
} __type2499;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC31_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC31_LH;
    } REGS8;
    __type1116 BIT; /* Bit Access       */
} __type2500;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } FNC_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } FNC_LH;
    } REGS8;
    const __type1117 BIT; /* Bit Access       */
} __type2501;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } FIC_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } FIC_LH;
    } REGS8;
    const __type1118 BIT; /* Bit Access       */
} __type2502;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR0_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR0_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR0_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR0_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR0_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR0_HH;
    } REGS8;
    __type1119 BIT; /* Bit Access       */
} __type2503;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1120 BIT;    /* Bit Access       */
} __type2504;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1121 BIT;    /* Bit Access       */
} __type2505;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1122 BIT;    /* Bit Access       */
} __type2506;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1123 BIT;    /* Bit Access       */
} __type2507;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1124 BIT;    /* Bit Access       */
} __type2508;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1125 BIT;    /* Bit Access       */
} __type2509;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1126 BIT;    /* Bit Access       */
} __type2510;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1127 BIT;    /* Bit Access       */
} __type2511;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1128 BIT;    /* Bit Access       */
} __type2512;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1129 BIT;    /* Bit Access       */
} __type2513;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1130 BIT;    /* Bit Access       */
} __type2514;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1131 BIT;    /* Bit Access       */
} __type2515;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1132 BIT;    /* Bit Access       */
} __type2516;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1133 BIT;    /* Bit Access       */
} __type2517;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1134 BIT;    /* Bit Access       */
} __type2518;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1135 BIT;    /* Bit Access       */
} __type2519;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1136 BIT;    /* Bit Access       */
} __type2520;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1137 BIT;    /* Bit Access       */
} __type2521;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1138 BIT;    /* Bit Access       */
} __type2522;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1139 BIT;    /* Bit Access       */
} __type2523;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1140 BIT;    /* Bit Access       */
} __type2524;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1141 BIT;    /* Bit Access       */
} __type2525;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1142 BIT;    /* Bit Access       */
} __type2526;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1143 BIT;    /* Bit Access       */
} __type2527;
typedef union
{                            /* IOR              */
    uint32           UINT32; /* 32-bit Access    */
    const __type1144 BIT;    /* Bit Access       */
} __type2528;
typedef union
{                      /* IOR              */
    uint32     UINT32; /* 32-bit Access    */
    __type1145 BIT;    /* Bit Access       */
} __type2529;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC32_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC32_LH;
    } REGS8;
    __type1146 BIT; /* Bit Access       */
} __type2530;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC33_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC33_LH;
    } REGS8;
    __type1147 BIT; /* Bit Access       */
} __type2531;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC34_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC34_LH;
    } REGS8;
    __type1148 BIT; /* Bit Access       */
} __type2532;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC35_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC35_LH;
    } REGS8;
    __type1149 BIT; /* Bit Access       */
} __type2533;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC36_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC36_LH;
    } REGS8;
    __type1150 BIT; /* Bit Access       */
} __type2534;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC37_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC37_LH;
    } REGS8;
    __type1151 BIT; /* Bit Access       */
} __type2535;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC38_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC38_LH;
    } REGS8;
    __type1152 BIT; /* Bit Access       */
} __type2536;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC39_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC39_LH;
    } REGS8;
    __type1153 BIT; /* Bit Access       */
} __type2537;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC40_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC40_LH;
    } REGS8;
    __type1154 BIT; /* Bit Access       */
} __type2538;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC41_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC41_LH;
    } REGS8;
    __type1155 BIT; /* Bit Access       */
} __type2539;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC42_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC42_LH;
    } REGS8;
    __type1156 BIT; /* Bit Access       */
} __type2540;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC43_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC43_LH;
    } REGS8;
    __type1157 BIT; /* Bit Access       */
} __type2541;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC44_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC44_LH;
    } REGS8;
    __type1158 BIT; /* Bit Access       */
} __type2542;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC45_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC45_LH;
    } REGS8;
    __type1159 BIT; /* Bit Access       */
} __type2543;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC46_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC46_LH;
    } REGS8;
    __type1160 BIT; /* Bit Access       */
} __type2544;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC47_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC47_LH;
    } REGS8;
    __type1161 BIT; /* Bit Access       */
} __type2545;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC48_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC48_LH;
    } REGS8;
    __type1162 BIT; /* Bit Access       */
} __type2546;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC49_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC49_LH;
    } REGS8;
    __type1163 BIT; /* Bit Access       */
} __type2547;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC50_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC50_LH;
    } REGS8;
    __type1164 BIT; /* Bit Access       */
} __type2548;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC51_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC51_LH;
    } REGS8;
    __type1165 BIT; /* Bit Access       */
} __type2549;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC52_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC52_LH;
    } REGS8;
    __type1166 BIT; /* Bit Access       */
} __type2550;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC53_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC53_LH;
    } REGS8;
    __type1167 BIT; /* Bit Access       */
} __type2551;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC54_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC54_LH;
    } REGS8;
    __type1168 BIT; /* Bit Access       */
} __type2552;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC55_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC55_LH;
    } REGS8;
    __type1169 BIT; /* Bit Access       */
} __type2553;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC56_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC56_LH;
    } REGS8;
    __type1170 BIT; /* Bit Access       */
} __type2554;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC57_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC57_LH;
    } REGS8;
    __type1171 BIT; /* Bit Access       */
} __type2555;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC58_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC58_LH;
    } REGS8;
    __type1172 BIT; /* Bit Access       */
} __type2556;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC59_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC59_LH;
    } REGS8;
    __type1173 BIT; /* Bit Access       */
} __type2557;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC60_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC60_LH;
    } REGS8;
    __type1174 BIT; /* Bit Access       */
} __type2558;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC61_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC61_LH;
    } REGS8;
    __type1175 BIT; /* Bit Access       */
} __type2559;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC62_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC62_LH;
    } REGS8;
    __type1176 BIT; /* Bit Access       */
} __type2560;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC63_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC63_LH;
    } REGS8;
    __type1177 BIT; /* Bit Access       */
} __type2561;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC64_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC64_LH;
    } REGS8;
    __type1178 BIT; /* Bit Access       */
} __type2562;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC65_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC65_LH;
    } REGS8;
    __type1179 BIT; /* Bit Access       */
} __type2563;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC66_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC66_LH;
    } REGS8;
    __type1180 BIT; /* Bit Access       */
} __type2564;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC67_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC67_LH;
    } REGS8;
    __type1181 BIT; /* Bit Access       */
} __type2565;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC68_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC68_LH;
    } REGS8;
    __type1182 BIT; /* Bit Access       */
} __type2566;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC69_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC69_LH;
    } REGS8;
    __type1183 BIT; /* Bit Access       */
} __type2567;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC70_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC70_LH;
    } REGS8;
    __type1184 BIT; /* Bit Access       */
} __type2568;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC71_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC71_LH;
    } REGS8;
    __type1185 BIT; /* Bit Access       */
} __type2569;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC72_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC72_LH;
    } REGS8;
    __type1186 BIT; /* Bit Access       */
} __type2570;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC73_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC73_LH;
    } REGS8;
    __type1187 BIT; /* Bit Access       */
} __type2571;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC74_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC74_LH;
    } REGS8;
    __type1188 BIT; /* Bit Access       */
} __type2572;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC75_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC75_LH;
    } REGS8;
    __type1189 BIT; /* Bit Access       */
} __type2573;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC76_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC76_LH;
    } REGS8;
    __type1190 BIT; /* Bit Access       */
} __type2574;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC77_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC77_LH;
    } REGS8;
    __type1191 BIT; /* Bit Access       */
} __type2575;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC78_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC78_LH;
    } REGS8;
    __type1192 BIT; /* Bit Access       */
} __type2576;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC79_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC79_LH;
    } REGS8;
    __type1193 BIT; /* Bit Access       */
} __type2577;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC80_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC80_LH;
    } REGS8;
    __type1194 BIT; /* Bit Access       */
} __type2578;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC81_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC81_LH;
    } REGS8;
    __type1195 BIT; /* Bit Access       */
} __type2579;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC82_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC82_LH;
    } REGS8;
    __type1196 BIT; /* Bit Access       */
} __type2580;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC83_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC83_LH;
    } REGS8;
    __type1197 BIT; /* Bit Access       */
} __type2581;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC84_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC84_LH;
    } REGS8;
    __type1198 BIT; /* Bit Access       */
} __type2582;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC85_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC85_LH;
    } REGS8;
    __type1199 BIT; /* Bit Access       */
} __type2583;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC86_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC86_LH;
    } REGS8;
    __type1200 BIT; /* Bit Access       */
} __type2584;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC87_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC87_LH;
    } REGS8;
    __type1201 BIT; /* Bit Access       */
} __type2585;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC88_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC88_LH;
    } REGS8;
    __type1202 BIT; /* Bit Access       */
} __type2586;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC89_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC89_LH;
    } REGS8;
    __type1203 BIT; /* Bit Access       */
} __type2587;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC90_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC90_LH;
    } REGS8;
    __type1204 BIT; /* Bit Access       */
} __type2588;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC91_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC91_LH;
    } REGS8;
    __type1205 BIT; /* Bit Access       */
} __type2589;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC92_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC92_LH;
    } REGS8;
    __type1206 BIT; /* Bit Access       */
} __type2590;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC93_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC93_LH;
    } REGS8;
    __type1207 BIT; /* Bit Access       */
} __type2591;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC94_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC94_LH;
    } REGS8;
    __type1208 BIT; /* Bit Access       */
} __type2592;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC95_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC95_LH;
    } REGS8;
    __type1209 BIT; /* Bit Access       */
} __type2593;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC96_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC96_LH;
    } REGS8;
    __type1210 BIT; /* Bit Access       */
} __type2594;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC97_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC97_LH;
    } REGS8;
    __type1211 BIT; /* Bit Access       */
} __type2595;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC98_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC98_LH;
    } REGS8;
    __type1212 BIT; /* Bit Access       */
} __type2596;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC99_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC99_LH;
    } REGS8;
    __type1213 BIT; /* Bit Access       */
} __type2597;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC100_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC100_LH;
    } REGS8;
    __type1214 BIT; /* Bit Access       */
} __type2598;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC101_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC101_LH;
    } REGS8;
    __type1215 BIT; /* Bit Access       */
} __type2599;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC102_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC102_LH;
    } REGS8;
    __type1216 BIT; /* Bit Access       */
} __type2600;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC103_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC103_LH;
    } REGS8;
    __type1217 BIT; /* Bit Access       */
} __type2601;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC104_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC104_LH;
    } REGS8;
    __type1218 BIT; /* Bit Access       */
} __type2602;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC105_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC105_LH;
    } REGS8;
    __type1219 BIT; /* Bit Access       */
} __type2603;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC106_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC106_LH;
    } REGS8;
    __type1220 BIT; /* Bit Access       */
} __type2604;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC107_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC107_LH;
    } REGS8;
    __type1221 BIT; /* Bit Access       */
} __type2605;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC108_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC108_LH;
    } REGS8;
    __type1222 BIT; /* Bit Access       */
} __type2606;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC109_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC109_LH;
    } REGS8;
    __type1223 BIT; /* Bit Access       */
} __type2607;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC110_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC110_LH;
    } REGS8;
    __type1224 BIT; /* Bit Access       */
} __type2608;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC111_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC111_LH;
    } REGS8;
    __type1225 BIT; /* Bit Access       */
} __type2609;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC112_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC112_LH;
    } REGS8;
    __type1226 BIT; /* Bit Access       */
} __type2610;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC113_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC113_LH;
    } REGS8;
    __type1227 BIT; /* Bit Access       */
} __type2611;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC114_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC114_LH;
    } REGS8;
    __type1228 BIT; /* Bit Access       */
} __type2612;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC115_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC115_LH;
    } REGS8;
    __type1229 BIT; /* Bit Access       */
} __type2613;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC116_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC116_LH;
    } REGS8;
    __type1230 BIT; /* Bit Access       */
} __type2614;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC117_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC117_LH;
    } REGS8;
    __type1231 BIT; /* Bit Access       */
} __type2615;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC118_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC118_LH;
    } REGS8;
    __type1232 BIT; /* Bit Access       */
} __type2616;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC119_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC119_LH;
    } REGS8;
    __type1233 BIT; /* Bit Access       */
} __type2617;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC120_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC120_LH;
    } REGS8;
    __type1234 BIT; /* Bit Access       */
} __type2618;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC121_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC121_LH;
    } REGS8;
    __type1235 BIT; /* Bit Access       */
} __type2619;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC122_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC122_LH;
    } REGS8;
    __type1236 BIT; /* Bit Access       */
} __type2620;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC123_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC123_LH;
    } REGS8;
    __type1237 BIT; /* Bit Access       */
} __type2621;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC124_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC124_LH;
    } REGS8;
    __type1238 BIT; /* Bit Access       */
} __type2622;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC125_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC125_LH;
    } REGS8;
    __type1239 BIT; /* Bit Access       */
} __type2623;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC126_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC126_LH;
    } REGS8;
    __type1240 BIT; /* Bit Access       */
} __type2624;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC127_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC127_LH;
    } REGS8;
    __type1241 BIT; /* Bit Access       */
} __type2625;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC128_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC128_LH;
    } REGS8;
    __type1242 BIT; /* Bit Access       */
} __type2626;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC129_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC129_LH;
    } REGS8;
    __type1243 BIT; /* Bit Access       */
} __type2627;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC130_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC130_LH;
    } REGS8;
    __type1244 BIT; /* Bit Access       */
} __type2628;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC131_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC131_LH;
    } REGS8;
    __type1245 BIT; /* Bit Access       */
} __type2629;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC132_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC132_LH;
    } REGS8;
    __type1246 BIT; /* Bit Access       */
} __type2630;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC133_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC133_LH;
    } REGS8;
    __type1247 BIT; /* Bit Access       */
} __type2631;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC134_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC134_LH;
    } REGS8;
    __type1248 BIT; /* Bit Access       */
} __type2632;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC135_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC135_LH;
    } REGS8;
    __type1249 BIT; /* Bit Access       */
} __type2633;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC136_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC136_LH;
    } REGS8;
    __type1250 BIT; /* Bit Access       */
} __type2634;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC137_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC137_LH;
    } REGS8;
    __type1251 BIT; /* Bit Access       */
} __type2635;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC138_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC138_LH;
    } REGS8;
    __type1252 BIT; /* Bit Access       */
} __type2636;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC139_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC139_LH;
    } REGS8;
    __type1253 BIT; /* Bit Access       */
} __type2637;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC140_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC140_LH;
    } REGS8;
    __type1254 BIT; /* Bit Access       */
} __type2638;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC141_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC141_LH;
    } REGS8;
    __type1255 BIT; /* Bit Access       */
} __type2639;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC142_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC142_LH;
    } REGS8;
    __type1256 BIT; /* Bit Access       */
} __type2640;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC143_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC143_LH;
    } REGS8;
    __type1257 BIT; /* Bit Access       */
} __type2641;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC144_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC144_LH;
    } REGS8;
    __type1258 BIT; /* Bit Access       */
} __type2642;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC145_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC145_LH;
    } REGS8;
    __type1259 BIT; /* Bit Access       */
} __type2643;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC146_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC146_LH;
    } REGS8;
    __type1260 BIT; /* Bit Access       */
} __type2644;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC147_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC147_LH;
    } REGS8;
    __type1261 BIT; /* Bit Access       */
} __type2645;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC148_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC148_LH;
    } REGS8;
    __type1262 BIT; /* Bit Access       */
} __type2646;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC149_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC149_LH;
    } REGS8;
    __type1263 BIT; /* Bit Access       */
} __type2647;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC150_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC150_LH;
    } REGS8;
    __type1264 BIT; /* Bit Access       */
} __type2648;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC151_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC151_LH;
    } REGS8;
    __type1265 BIT; /* Bit Access       */
} __type2649;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC152_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC152_LH;
    } REGS8;
    __type1266 BIT; /* Bit Access       */
} __type2650;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC153_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC153_LH;
    } REGS8;
    __type1267 BIT; /* Bit Access       */
} __type2651;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC154_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC154_LH;
    } REGS8;
    __type1268 BIT; /* Bit Access       */
} __type2652;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC155_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC155_LH;
    } REGS8;
    __type1269 BIT; /* Bit Access       */
} __type2653;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC156_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC156_LH;
    } REGS8;
    __type1270 BIT; /* Bit Access       */
} __type2654;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC157_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC157_LH;
    } REGS8;
    __type1271 BIT; /* Bit Access       */
} __type2655;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC158_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC158_LH;
    } REGS8;
    __type1272 BIT; /* Bit Access       */
} __type2656;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC159_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC159_LH;
    } REGS8;
    __type1273 BIT; /* Bit Access       */
} __type2657;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC160_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC160_LH;
    } REGS8;
    __type1274 BIT; /* Bit Access       */
} __type2658;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC161_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC161_LH;
    } REGS8;
    __type1275 BIT; /* Bit Access       */
} __type2659;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC162_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC162_LH;
    } REGS8;
    __type1276 BIT; /* Bit Access       */
} __type2660;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC163_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC163_LH;
    } REGS8;
    __type1277 BIT; /* Bit Access       */
} __type2661;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC164_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC164_LH;
    } REGS8;
    __type1278 BIT; /* Bit Access       */
} __type2662;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC165_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC165_LH;
    } REGS8;
    __type1279 BIT; /* Bit Access       */
} __type2663;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC166_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC166_LH;
    } REGS8;
    __type1280 BIT; /* Bit Access       */
} __type2664;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC167_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC167_LH;
    } REGS8;
    __type1281 BIT; /* Bit Access       */
} __type2665;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC168_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC168_LH;
    } REGS8;
    __type1282 BIT; /* Bit Access       */
} __type2666;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC169_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC169_LH;
    } REGS8;
    __type1283 BIT; /* Bit Access       */
} __type2667;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC170_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC170_LH;
    } REGS8;
    __type1284 BIT; /* Bit Access       */
} __type2668;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC171_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC171_LH;
    } REGS8;
    __type1285 BIT; /* Bit Access       */
} __type2669;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC172_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC172_LH;
    } REGS8;
    __type1286 BIT; /* Bit Access       */
} __type2670;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC173_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC173_LH;
    } REGS8;
    __type1287 BIT; /* Bit Access       */
} __type2671;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC174_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC174_LH;
    } REGS8;
    __type1288 BIT; /* Bit Access       */
} __type2672;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC175_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC175_LH;
    } REGS8;
    __type1289 BIT; /* Bit Access       */
} __type2673;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC176_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC176_LH;
    } REGS8;
    __type1290 BIT; /* Bit Access       */
} __type2674;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC177_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC177_LH;
    } REGS8;
    __type1291 BIT; /* Bit Access       */
} __type2675;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC178_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC178_LH;
    } REGS8;
    __type1292 BIT; /* Bit Access       */
} __type2676;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC179_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC179_LH;
    } REGS8;
    __type1293 BIT; /* Bit Access       */
} __type2677;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC180_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC180_LH;
    } REGS8;
    __type1294 BIT; /* Bit Access       */
} __type2678;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC181_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC181_LH;
    } REGS8;
    __type1295 BIT; /* Bit Access       */
} __type2679;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC182_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC182_LH;
    } REGS8;
    __type1296 BIT; /* Bit Access       */
} __type2680;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC183_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC183_LH;
    } REGS8;
    __type1297 BIT; /* Bit Access       */
} __type2681;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC184_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC184_LH;
    } REGS8;
    __type1298 BIT; /* Bit Access       */
} __type2682;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC185_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC185_LH;
    } REGS8;
    __type1299 BIT; /* Bit Access       */
} __type2683;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC186_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC186_LH;
    } REGS8;
    __type1300 BIT; /* Bit Access       */
} __type2684;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC187_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC187_LH;
    } REGS8;
    __type1301 BIT; /* Bit Access       */
} __type2685;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC188_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC188_LH;
    } REGS8;
    __type1302 BIT; /* Bit Access       */
} __type2686;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC189_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC189_LH;
    } REGS8;
    __type1303 BIT; /* Bit Access       */
} __type2687;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC190_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC190_LH;
    } REGS8;
    __type1304 BIT; /* Bit Access       */
} __type2688;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC191_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC191_LH;
    } REGS8;
    __type1305 BIT; /* Bit Access       */
} __type2689;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC192_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC192_LH;
    } REGS8;
    __type1306 BIT; /* Bit Access       */
} __type2690;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC193_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC193_LH;
    } REGS8;
    __type1307 BIT; /* Bit Access       */
} __type2691;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC194_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC194_LH;
    } REGS8;
    __type1308 BIT; /* Bit Access       */
} __type2692;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC195_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC195_LH;
    } REGS8;
    __type1309 BIT; /* Bit Access       */
} __type2693;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC196_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC196_LH;
    } REGS8;
    __type1310 BIT; /* Bit Access       */
} __type2694;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC197_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC197_LH;
    } REGS8;
    __type1311 BIT; /* Bit Access       */
} __type2695;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC198_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC198_LH;
    } REGS8;
    __type1312 BIT; /* Bit Access       */
} __type2696;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC199_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC199_LH;
    } REGS8;
    __type1313 BIT; /* Bit Access       */
} __type2697;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC200_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC200_LH;
    } REGS8;
    __type1314 BIT; /* Bit Access       */
} __type2698;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC201_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC201_LH;
    } REGS8;
    __type1315 BIT; /* Bit Access       */
} __type2699;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC202_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC202_LH;
    } REGS8;
    __type1316 BIT; /* Bit Access       */
} __type2700;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC203_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC203_LH;
    } REGS8;
    __type1317 BIT; /* Bit Access       */
} __type2701;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC204_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC204_LH;
    } REGS8;
    __type1318 BIT; /* Bit Access       */
} __type2702;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC205_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC205_LH;
    } REGS8;
    __type1319 BIT; /* Bit Access       */
} __type2703;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC206_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC206_LH;
    } REGS8;
    __type1320 BIT; /* Bit Access       */
} __type2704;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC207_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC207_LH;
    } REGS8;
    __type1321 BIT; /* Bit Access       */
} __type2705;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC208_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC208_LH;
    } REGS8;
    __type1322 BIT; /* Bit Access       */
} __type2706;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC209_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC209_LH;
    } REGS8;
    __type1323 BIT; /* Bit Access       */
} __type2707;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC210_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC210_LH;
    } REGS8;
    __type1324 BIT; /* Bit Access       */
} __type2708;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC211_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC211_LH;
    } REGS8;
    __type1325 BIT; /* Bit Access       */
} __type2709;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC212_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC212_LH;
    } REGS8;
    __type1326 BIT; /* Bit Access       */
} __type2710;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC213_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC213_LH;
    } REGS8;
    __type1327 BIT; /* Bit Access       */
} __type2711;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC214_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC214_LH;
    } REGS8;
    __type1328 BIT; /* Bit Access       */
} __type2712;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC215_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC215_LH;
    } REGS8;
    __type1329 BIT; /* Bit Access       */
} __type2713;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC216_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC216_LH;
    } REGS8;
    __type1330 BIT; /* Bit Access       */
} __type2714;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC217_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC217_LH;
    } REGS8;
    __type1331 BIT; /* Bit Access       */
} __type2715;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC218_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC218_LH;
    } REGS8;
    __type1332 BIT; /* Bit Access       */
} __type2716;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC219_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC219_LH;
    } REGS8;
    __type1333 BIT; /* Bit Access       */
} __type2717;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC220_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC220_LH;
    } REGS8;
    __type1334 BIT; /* Bit Access       */
} __type2718;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC221_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC221_LH;
    } REGS8;
    __type1335 BIT; /* Bit Access       */
} __type2719;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC222_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC222_LH;
    } REGS8;
    __type1336 BIT; /* Bit Access       */
} __type2720;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC223_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC223_LH;
    } REGS8;
    __type1337 BIT; /* Bit Access       */
} __type2721;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC224_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC224_LH;
    } REGS8;
    __type1338 BIT; /* Bit Access       */
} __type2722;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC225_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC225_LH;
    } REGS8;
    __type1339 BIT; /* Bit Access       */
} __type2723;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC226_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC226_LH;
    } REGS8;
    __type1340 BIT; /* Bit Access       */
} __type2724;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC227_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC227_LH;
    } REGS8;
    __type1341 BIT; /* Bit Access       */
} __type2725;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC228_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC228_LH;
    } REGS8;
    __type1342 BIT; /* Bit Access       */
} __type2726;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC229_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC229_LH;
    } REGS8;
    __type1343 BIT; /* Bit Access       */
} __type2727;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC230_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC230_LH;
    } REGS8;
    __type1344 BIT; /* Bit Access       */
} __type2728;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC231_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC231_LH;
    } REGS8;
    __type1345 BIT; /* Bit Access       */
} __type2729;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC232_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC232_LH;
    } REGS8;
    __type1346 BIT; /* Bit Access       */
} __type2730;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC233_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC233_LH;
    } REGS8;
    __type1347 BIT; /* Bit Access       */
} __type2731;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC234_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC234_LH;
    } REGS8;
    __type1348 BIT; /* Bit Access       */
} __type2732;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC235_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC235_LH;
    } REGS8;
    __type1349 BIT; /* Bit Access       */
} __type2733;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC236_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC236_LH;
    } REGS8;
    __type1350 BIT; /* Bit Access       */
} __type2734;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC237_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC237_LH;
    } REGS8;
    __type1351 BIT; /* Bit Access       */
} __type2735;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC238_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC238_LH;
    } REGS8;
    __type1352 BIT; /* Bit Access       */
} __type2736;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC239_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC239_LH;
    } REGS8;
    __type1353 BIT; /* Bit Access       */
} __type2737;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC240_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC240_LH;
    } REGS8;
    __type1354 BIT; /* Bit Access       */
} __type2738;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC241_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC241_LH;
    } REGS8;
    __type1355 BIT; /* Bit Access       */
} __type2739;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC242_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC242_LH;
    } REGS8;
    __type1356 BIT; /* Bit Access       */
} __type2740;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC243_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC243_LH;
    } REGS8;
    __type1357 BIT; /* Bit Access       */
} __type2741;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC244_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC244_LH;
    } REGS8;
    __type1358 BIT; /* Bit Access       */
} __type2742;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC245_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC245_LH;
    } REGS8;
    __type1359 BIT; /* Bit Access       */
} __type2743;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC246_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC246_LH;
    } REGS8;
    __type1360 BIT; /* Bit Access       */
} __type2744;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC247_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC247_LH;
    } REGS8;
    __type1361 BIT; /* Bit Access       */
} __type2745;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC248_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC248_LH;
    } REGS8;
    __type1362 BIT; /* Bit Access       */
} __type2746;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC249_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC249_LH;
    } REGS8;
    __type1363 BIT; /* Bit Access       */
} __type2747;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC250_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC250_LH;
    } REGS8;
    __type1364 BIT; /* Bit Access       */
} __type2748;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC251_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC251_LH;
    } REGS8;
    __type1365 BIT; /* Bit Access       */
} __type2749;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC252_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC252_LH;
    } REGS8;
    __type1366 BIT; /* Bit Access       */
} __type2750;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC253_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC253_LH;
    } REGS8;
    __type1367 BIT; /* Bit Access       */
} __type2751;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC254_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC254_LH;
    } REGS8;
    __type1368 BIT; /* Bit Access       */
} __type2752;
typedef union
{                       /* IOR              */
    uint16 UINT16;      /* 16-bit Access    */
    uint8  UINT8 [ 2 ]; /* 8-bit Access     */
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC255_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /*  8-bit Access    */
        } EIC255_LH;
    } REGS8;
    __type1369 BIT; /* Bit Access       */
} __type2753;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR1_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR1_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR1_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR1_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR1_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR1_HH;
    } REGS8;
    __type1370 BIT; /* Bit Access       */
} __type2754;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR2_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR2_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR2_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR2_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR2_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR2_HH;
    } REGS8;
    __type1371 BIT; /* Bit Access       */
} __type2755;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR3_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR3_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR3_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR3_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR3_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR3_HH;
    } REGS8;
    __type1372 BIT; /* Bit Access       */
} __type2756;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR4_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR4_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR4_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR4_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR4_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR4_HH;
    } REGS8;
    __type1373 BIT; /* Bit Access       */
} __type2757;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR5_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR5_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR5_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR5_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR5_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR5_HH;
    } REGS8;
    __type1374 BIT; /* Bit Access       */
} __type2758;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR6_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR6_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR6_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR6_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR6_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR6_HH;
    } REGS8;
    __type1375 BIT; /* Bit Access       */
} __type2759;
typedef union
{                        /* IOR              */
    uint32 UINT32;       /* 32-bit Access    */
    uint16 UINT16 [ 2 ]; /* 16-bit Access    */
    uint8  UINT8 [ 4 ];  /* 8-bit Access     */
    struct
    {
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR7_L;
        union
        {                  /* IOR              */
            uint16 UINT16; /* 16-bit Access    */
        } IMR7_H;
    } REGS16;
    struct
    {
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR7_LL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR7_LH;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR7_HL;
        union
        {                /* IOR              */
            uint8 UINT8; /* 8-bit Access     */
        } IMR7_HH;
    } REGS8;
    __type1376 BIT; /* Bit Access       */
} __type2760;

typedef struct
{                                  /* Module           */
    __type1377       CMNCR;        /* CMNCR            */
    __type1378       SSLDR;        /* SSLDR            */
    __type1379       SPBCR;        /* SPBCR            */
    __type1380       DRCR;         /* DRCR             */
    __type1381       DRCMR;        /* DRCMR            */
    __type1382       DREAR;        /* DREAR            */
    __type1383       DROPR;        /* DROPR            */
    __type1384       DRENR;        /* DRENR            */
    __type1385       SMCR;         /* SMCR             */
    __type1381       SMCMR;        /* SMCMR            */
    __type1386       SMADR;        /* SMADR            */
    __type1383       SMOPR;        /* SMOPR            */
    __type1387       SMENR;        /* SMENR            */
    uint8            dummy0 [ 4 ]; /* Reserved         */
    const __type1388 SMRDR0;       /* SMRDR0           */
    const __type1389 SMRDR1;       /* SMRDR1           */
    __type1390       SMWDR0;       /* SMWDR0           */
    __type1391       SMWDR1;       /* SMWDR1           */
    const __type1392 CMNSR;        /* CMNSR            */
    uint8            dummy1 [ 4 ]; /* Reserved         */
    __type1393       CKDLY;        /* CKDLY            */
    uint8            dummy2 [ 4 ]; /* Reserved         */
    __type1394       DRDMCR;       /* DRDMCR           */
    __type1395       DRDRENR;      /* DRDRENR          */
    __type1394       SMDMCR;       /* SMDMCR           */
    __type1396       SMDRENR;      /* SMDRENR          */
    __type1397       SPODLY;       /* SPODLY           */
} __type2761;
typedef struct
{                                          /* Module           */
    __type1398       P1;                   /* P1               */
    uint8            dummy3 [ 2 ];         /* Reserved         */
    __type1399       PSR1;                 /* PSR1             */
    __type1400       PNOT1;                /* PNOT1            */
    uint8            dummy4 [ 2 ];         /* Reserved         */
    const __type1401 PPR1;                 /* PPR1             */
    uint8            dummy5 [ 2 ];         /* Reserved         */
    __type1402       PM1;                  /* PM1              */
    uint8            dummy6 [ 2 ];         /* Reserved         */
    __type1403       PMC1;                 /* PMC1             */
    uint8            dummy7 [ 2 ];         /* Reserved         */
    __type1404       PFC1;                 /* PFC1             */
    uint8            dummy8 [ 2 ];         /* Reserved         */
    __type1405       PFCE1;                /* PFCE1            */
    uint8            dummy9 [ 2 ];         /* Reserved         */
    __type1406       PMSR1;                /* PMSR1            */
    __type1407       PMCSR1;               /* PMCSR1           */
    uint8            dummy10 [ 8 ];        /* Reserved         */
    __type1408       PINV1;                /* PINV1            */
    uint8            dummy11 [ 78 ];       /* Reserved         */
    __type1409       P3;                   /* P3               */
    uint8            dummy12 [ 2 ];        /* Reserved         */
    __type1410       PSR3;                 /* PSR3             */
    __type1411       PNOT3;                /* PNOT3            */
    uint8            dummy13 [ 2 ];        /* Reserved         */
    const __type1412 PPR3;                 /* PPR3             */
    uint8            dummy14 [ 2 ];        /* Reserved         */
    __type1413       PM3;                  /* PM3              */
    uint8            dummy15 [ 2 ];        /* Reserved         */
    __type1414       PMC3;                 /* PMC3             */
    uint8            dummy16 [ 2 ];        /* Reserved         */
    __type1415       PFC3;                 /* PFC3             */
    uint8            dummy17 [ 2 ];        /* Reserved         */
    __type1416       PFCE3;                /* PFCE3            */
    uint8            dummy18 [ 2 ];        /* Reserved         */
    __type1417       PMSR3;                /* PMSR3            */
    __type1418       PMCSR3;               /* PMCSR3           */
    uint8            dummy19 [ 8 ];        /* Reserved         */
    __type1419       PINV3;                /* PINV3            */
    uint8            dummy20 [ 398 ];      /* Reserved         */
    __type1420       P10;                  /* P10              */
    uint8            dummy21 [ 2 ];        /* Reserved         */
    __type1421       PSR10;                /* PSR10            */
    __type1422       PNOT10;               /* PNOT10           */
    uint8            dummy22 [ 2 ];        /* Reserved         */
    const __type1423 PPR10;                /* PPR10            */
    uint8            dummy23 [ 2 ];        /* Reserved         */
    __type1424       PM10;                 /* PM10             */
    uint8            dummy24 [ 2 ];        /* Reserved         */
    __type1425       PMC10;                /* PMC10            */
    uint8            dummy25 [ 2 ];        /* Reserved         */
    __type1426       PFC10;                /* PFC10            */
    uint8            dummy26 [ 2 ];        /* Reserved         */
    __type1427       PFCE10;               /* PFCE10           */
    uint8            dummy27 [ 2 ];        /* Reserved         */
    __type1428       PMSR10;               /* PMSR10           */
    __type1429       PMCSR10;              /* PMCSR10          */
    uint8            dummy28 [ 8 ];        /* Reserved         */
    __type1430       PINV10;               /* PINV10           */
    uint8            dummy29 [ 14 ];       /* Reserved         */
    __type1431       P11;                  /* P11              */
    uint8            dummy30 [ 2 ];        /* Reserved         */
    __type1432       PSR11;                /* PSR11            */
    __type1433       PNOT11;               /* PNOT11           */
    uint8            dummy31 [ 2 ];        /* Reserved         */
    const __type1434 PPR11;                /* PPR11            */
    uint8            dummy32 [ 2 ];        /* Reserved         */
    __type1435       PM11;                 /* PM11             */
    uint8            dummy33 [ 2 ];        /* Reserved         */
    __type1436       PMC11;                /* PMC11            */
    uint8            dummy34 [ 2 ];        /* Reserved         */
    __type1437       PFC11;                /* PFC11            */
    uint8            dummy35 [ 6 ];        /* Reserved         */
    __type1438       PMSR11;               /* PMSR11           */
    __type1439       PMCSR11;              /* PMCSR11          */
    uint8            dummy36 [ 8 ];        /* Reserved         */
    __type1440       PINV11;               /* PINV11           */
    uint8            dummy37 [ 270 ];      /* Reserved         */
    __type1441       P16;                  /* P16              */
    uint8            dummy38 [ 2 ];        /* Reserved         */
    __type1442       PSR16;                /* PSR16            */
    __type1443       PNOT16;               /* PNOT16           */
    uint8            dummy39 [ 2 ];        /* Reserved         */
    const __type1444 PPR16;                /* PPR16            */
    uint8            dummy40 [ 2 ];        /* Reserved         */
    __type1445       PM16;                 /* PM16             */
    uint8            dummy41 [ 2 ];        /* Reserved         */
    __type1446       PMC16;                /* PMC16            */
    uint8            dummy42 [ 2 ];        /* Reserved         */
    __type1447       PFC16;                /* PFC16            */
    uint8            dummy43 [ 2 ];        /* Reserved         */
    __type1448       PFCE16;               /* PFCE16           */
    uint8            dummy44 [ 2 ];        /* Reserved         */
    __type1449       PMSR16;               /* PMSR16           */
    __type1450       PMCSR16;              /* PMCSR16          */
    uint8            dummy45 [ 8 ];        /* Reserved         */
    __type1451       PINV16;               /* PINV16           */
    uint8            dummy46 [ 14 ];       /* Reserved         */
    __type1452       P17;                  /* P17              */
    uint8            dummy47 [ 2 ];        /* Reserved         */
    __type1453       PSR17;                /* PSR17            */
    __type1454       PNOT17;               /* PNOT17           */
    uint8            dummy48 [ 2 ];        /* Reserved         */
    const __type1455 PPR17;                /* PPR17            */
    uint8            dummy49 [ 2 ];        /* Reserved         */
    __type1456       PM17;                 /* PM17             */
    uint8            dummy50 [ 2 ];        /* Reserved         */
    __type1457       PMC17;                /* PMC17            */
    uint8            dummy51 [ 2 ];        /* Reserved         */
    __type1458       PFC17;                /* PFC17            */
    uint8            dummy52 [ 2 ];        /* Reserved         */
    __type1459       PFCE17;               /* PFCE17           */
    uint8            dummy53 [ 2 ];        /* Reserved         */
    __type1460       PMSR17;               /* PMSR17           */
    __type1461       PMCSR17;              /* PMCSR17          */
    uint8            dummy54 [ 8 ];        /* Reserved         */
    __type1462       PINV17;               /* PINV17           */
    uint8            dummy55 [ 206 ];      /* Reserved         */
    __type1463       P21;                  /* P21              */
    uint8            dummy56 [ 2 ];        /* Reserved         */
    __type1464       PSR21;                /* PSR21            */
    __type1465       PNOT21;               /* PNOT21           */
    uint8            dummy57 [ 2 ];        /* Reserved         */
    const __type1466 PPR21;                /* PPR21            */
    uint8            dummy58 [ 2 ];        /* Reserved         */
    __type1467       PM21;                 /* PM21             */
    uint8            dummy59 [ 2 ];        /* Reserved         */
    __type1468       PMC21;                /* PMC21            */
    uint8            dummy60 [ 2 ];        /* Reserved         */
    __type1469       PFC21;                /* PFC21            */
    uint8            dummy61 [ 6 ];        /* Reserved         */
    __type1470       PMSR21;               /* PMSR21           */
    __type1471       PMCSR21;              /* PMCSR21          */
    uint8            dummy62 [ 8 ];        /* Reserved         */
    __type1472       PINV21;               /* PINV21           */
    uint8            dummy63 [ 1294 ];     /* Reserved         */
    __type1473       P42;                  /* P42              */
    uint8            dummy64 [ 2 ];        /* Reserved         */
    __type1474       PSR42;                /* PSR42            */
    __type1475       PNOT42;               /* PNOT42           */
    uint8            dummy65 [ 2 ];        /* Reserved         */
    const __type1476 PPR42;                /* PPR42            */
    uint8            dummy66 [ 2 ];        /* Reserved         */
    __type1477       PM42;                 /* PM42             */
    uint8            dummy67 [ 2 ];        /* Reserved         */
    __type1478       PMC42;                /* PMC42            */
    uint8            dummy68 [ 2 ];        /* Reserved         */
    __type1479       PFC42;                /* PFC42            */
    uint8            dummy69 [ 2 ];        /* Reserved         */
    __type1480       PFCE42;               /* PFCE42           */
    uint8            dummy70 [ 2 ];        /* Reserved         */
    __type1481       PMSR42;               /* PMSR42           */
    __type1482       PMCSR42;              /* PMCSR42          */
    uint8            dummy71 [ 8 ];        /* Reserved         */
    __type1483       PINV42;               /* PINV42           */
    uint8            dummy72 [ 14 ];       /* Reserved         */
    __type1484       P43;                  /* P43              */
    uint8            dummy73 [ 2 ];        /* Reserved         */
    __type1485       PSR43;                /* PSR43            */
    __type1486       PNOT43;               /* PNOT43           */
    uint8            dummy74 [ 2 ];        /* Reserved         */
    const __type1487 PPR43;                /* PPR43            */
    uint8            dummy75 [ 2 ];        /* Reserved         */
    __type1488       PM43;                 /* PM43             */
    uint8            dummy76 [ 2 ];        /* Reserved         */
    __type1489       PMC43;                /* PMC43            */
    uint8            dummy77 [ 2 ];        /* Reserved         */
    __type1490       PFC43;                /* PFC43            */
    uint8            dummy78 [ 2 ];        /* Reserved         */
    __type1491       PFCE43;               /* PFCE43           */
    uint8            dummy79 [ 2 ];        /* Reserved         */
    __type1492       PMSR43;               /* PMSR43           */
    __type1493       PMCSR43;              /* PMCSR43          */
    uint8            dummy80 [ 8 ];        /* Reserved         */
    __type1494       PINV43;               /* PINV43           */
    uint8            dummy81 [ 14 ];       /* Reserved         */
    __type1495       P44;                  /* P44              */
    uint8            dummy82 [ 2 ];        /* Reserved         */
    __type1496       PSR44;                /* PSR44            */
    __type1497       PNOT44;               /* PNOT44           */
    uint8            dummy83 [ 2 ];        /* Reserved         */
    const __type1498 PPR44;                /* PPR44            */
    uint8            dummy84 [ 2 ];        /* Reserved         */
    __type1499       PM44;                 /* PM44             */
    uint8            dummy85 [ 2 ];        /* Reserved         */
    __type1500       PMC44;                /* PMC44            */
    uint8            dummy86 [ 2 ];        /* Reserved         */
    __type1501       PFC44;                /* PFC44            */
    uint8            dummy87 [ 2 ];        /* Reserved         */
    __type1502       PFCE44;               /* PFCE44           */
    uint8            dummy88 [ 2 ];        /* Reserved         */
    __type1503       PMSR44;               /* PMSR44           */
    __type1504       PMCSR44;              /* PMCSR44          */
    uint8            dummy89 [ 8 ];        /* Reserved         */
    __type1505       PINV44;               /* PINV44           */
    uint8            dummy90 [ 14 ];       /* Reserved         */
    __type1506       P45;                  /* P45              */
    uint8            dummy91 [ 2 ];        /* Reserved         */
    __type1507       PSR45;                /* PSR45            */
    __type1508       PNOT45;               /* PNOT45           */
    uint8            dummy92 [ 2 ];        /* Reserved         */
    const __type1509 PPR45;                /* PPR45            */
    uint8            dummy93 [ 2 ];        /* Reserved         */
    __type1510       PM45;                 /* PM45             */
    uint8            dummy94 [ 2 ];        /* Reserved         */
    __type1511       PMC45;                /* PMC45            */
    uint8            dummy95 [ 2 ];        /* Reserved         */
    __type1512       PFC45;                /* PFC45            */
    uint8            dummy96 [ 2 ];        /* Reserved         */
    __type1513       PFCE45;               /* PFCE45           */
    uint8            dummy97 [ 2 ];        /* Reserved         */
    __type1514       PMSR45;               /* PMSR45           */
    __type1515       PMCSR45;              /* PMCSR45          */
    uint8            dummy98 [ 8 ];        /* Reserved         */
    __type1516       PINV45;               /* PINV45           */
    uint8            dummy99 [ 5326 ];     /* Reserved         */
    __type1517       PCR1_0;               /* PCR1_0           */
    __type1518       PCR1_1;               /* PCR1_1           */
    __type1517       PCR1_2;               /* PCR1_2           */
    uint8            dummy100 [ 124 ];     /* Reserved         */
    __type1518       PCR3_2;               /* PCR3_2           */
    __type1517       PCR3_3;               /* PCR3_3           */
    __type1517       PCR3_4;               /* PCR3_4           */
    __type1517       PCR3_5;               /* PCR3_5           */
    __type1517       PCR3_6;               /* PCR3_6           */
    __type1517       PCR3_7;               /* PCR3_7           */
    __type1517       PCR3_8;               /* PCR3_8           */
    __type1517       PCR3_9;               /* PCR3_9           */
    uint8            dummy101 [ 408 ];     /* Reserved         */
    __type1519       PCR10_0;              /* PCR10_0          */
    __type1519       PCR10_1;              /* PCR10_1          */
    __type1519       PCR10_2;              /* PCR10_2          */
    __type1519       PCR10_3;              /* PCR10_3          */
    __type1519       PCR10_4;              /* PCR10_4          */
    __type1519       PCR10_5;              /* PCR10_5          */
    __type1519       PCR10_6;              /* PCR10_6          */
    __type1519       PCR10_7;              /* PCR10_7          */
    __type1519       PCR10_8;              /* PCR10_8          */
    __type1519       PCR10_9;              /* PCR10_9          */
    __type1519       PCR10_10;             /* PCR10_10         */
    __type1519       PCR10_11;             /* PCR10_11         */
    uint8            dummy102 [ 16 ];      /* Reserved         */
    __type1520       PCR11_0;              /* PCR11_0          */
    __type1520       PCR11_1;              /* PCR11_1          */
    __type1520       PCR11_2;              /* PCR11_2          */
    __type1520       PCR11_3;              /* PCR11_3          */
    uint8            dummy103 [ 304 ];     /* Reserved         */
    __type1521       PCR16_0;              /* PCR16_0          */
    __type1521       PCR16_1;              /* PCR16_1          */
    __type1521       PCR16_2;              /* PCR16_2          */
    __type1521       PCR16_3;              /* PCR16_3          */
    __type1521       PCR16_4;              /* PCR16_4          */
    __type1521       PCR16_5;              /* PCR16_5          */
    __type1521       PCR16_6;              /* PCR16_6          */
    __type1521       PCR16_7;              /* PCR16_7          */
    __type1521       PCR16_8;              /* PCR16_8          */
    __type1521       PCR16_9;              /* PCR16_9          */
    __type1521       PCR16_10;             /* PCR16_10         */
    __type1521       PCR16_11;             /* PCR16_11         */
    uint8            dummy104 [ 16 ];      /* Reserved         */
    __type1521       PCR17_0;              /* PCR17_0          */
    __type1521       PCR17_1;              /* PCR17_1          */
    __type1521       PCR17_2;              /* PCR17_2          */
    __type1521       PCR17_3;              /* PCR17_3          */
    __type1522       PCR17_4;              /* PCR17_4          */
    __type1522       PCR17_5;              /* PCR17_5          */
    __type1522       PCR17_6;              /* PCR17_6          */
    __type1522       PCR17_7;              /* PCR17_7          */
    __type1522       PCR17_8;              /* PCR17_8          */
    __type1522       PCR17_9;              /* PCR17_9          */
    __type1522       PCR17_10;             /* PCR17_10         */
    __type1522       PCR17_11;             /* PCR17_11         */
    uint8            dummy105 [ 208 ];     /* Reserved         */
    __type1523       PCR21_0;              /* PCR21_0          */
    __type1523       PCR21_1;              /* PCR21_1          */
    __type1524       PCR21_2;              /* PCR21_2          */
    __type1524       PCR21_3;              /* PCR21_3          */
    __type1524       PCR21_4;              /* PCR21_4          */
    __type1524       PCR21_5;              /* PCR21_5          */
    uint8            dummy106 [ 1348 ];    /* Reserved         */
    __type1518       PCR42_7;              /* PCR42_7          */
    __type1517       PCR42_8;              /* PCR42_8          */
    __type1518       PCR42_9;              /* PCR42_9          */
    __type1517       PCR42_10;             /* PCR42_10         */
    uint8            dummy107 [ 20 ];      /* Reserved         */
    __type1517       PCR43_0;              /* PCR43_0          */
    __type1517       PCR43_1;              /* PCR43_1          */
    uint8            dummy108 [ 60 ];      /* Reserved         */
    __type1517       PCR44_1;              /* PCR44_1          */
    __type1517       PCR44_2;              /* PCR44_2          */
    __type1517       PCR44_3;              /* PCR44_3          */
    __type1517       PCR44_4;              /* PCR44_4          */
    uint8            dummy109 [ 4 ];       /* Reserved         */
    __type1517       PCR44_6;              /* PCR44_6          */
    __type1517       PCR44_7;              /* PCR44_7          */
    __type1517       PCR44_8;              /* PCR44_8          */
    __type1517       PCR44_9;              /* PCR44_9          */
    __type1517       PCR44_10;             /* PCR44_10         */
    __type1517       PCR44_11;             /* PCR44_11         */
    uint8            dummy110 [ 16 ];      /* Reserved         */
    __type1517       PCR45_0;              /* PCR45_0          */
    __type1517       PCR45_1;              /* PCR45_1          */
    __type1517       PCR45_2;              /* PCR45_2          */
    __type1517       PCR45_3;              /* PCR45_3          */
    __type1517       PCR45_4;              /* PCR45_4          */
    __type1517       PCR45_5;              /* PCR45_5          */
    __type1517       PCR45_6;              /* PCR45_6          */
    __type1517       PCR45_7;              /* PCR45_7          */
    __type1517       PCR45_8;              /* PCR45_8          */
    __type1517       PCR45_9;              /* PCR45_9          */
    __type1517       PCR45_10;             /* PCR45_10         */
    __type1517       PCR45_11;             /* PCR45_11         */
    __type1517       PCR45_12;             /* PCR45_12         */
    __type1517       PCR45_13;             /* PCR45_13         */
    uint8            dummy111 [ 6296776 ]; /* Reserved         */
    __type1525       PIBC1;                /* PIBC1            */
    uint8            dummy112 [ 2 ];       /* Reserved         */
    __type1526       PBDC1;                /* PBDC1            */
    uint8            dummy113 [ 2 ];       /* Reserved         */
    __type1527       PIPC1;                /* PIPC1            */
    uint8            dummy114 [ 2 ];       /* Reserved         */
    __type1528       PU1;                  /* PU1              */
    uint8            dummy115 [ 2 ];       /* Reserved         */
    __type1529       PD1;                  /* PD1              */
    uint8            dummy116 [ 2 ];       /* Reserved         */
    __type1530       PODC1;                /* PODC1            */
    __type1531       PDSC1;                /* PDSC1            */
    __type1532       PIS1;                 /* PIS1             */
    uint8            dummy117 [ 6 ];       /* Reserved         */
    __type1533       PISA1;                /* PISA1            */
    uint8            dummy118 [ 6 ];       /* Reserved         */
    __type1534       PPCMD1;               /* PPCMD1           */
    uint8            dummy119 [ 4 ];       /* Reserved         */
    const __type1535 PPROTS1;              /* PPROTS1          */
    uint8            dummy120 [ 72 ];      /* Reserved         */
    __type1536       PIBC3;                /* PIBC3            */
    uint8            dummy121 [ 2 ];       /* Reserved         */
    __type1537       PBDC3;                /* PBDC3            */
    uint8            dummy122 [ 2 ];       /* Reserved         */
    __type1538       PIPC3;                /* PIPC3            */
    uint8            dummy123 [ 2 ];       /* Reserved         */
    __type1539       PU3;                  /* PU3              */
    uint8            dummy124 [ 2 ];       /* Reserved         */
    __type1540       PD3;                  /* PD3              */
    uint8            dummy125 [ 2 ];       /* Reserved         */
    __type1541       PODC3;                /* PODC3            */
    __type1542       PDSC3;                /* PDSC3            */
    __type1543       PIS3;                 /* PIS3             */
    uint8            dummy126 [ 6 ];       /* Reserved         */
    __type1544       PISA3;                /* PISA3            */
    uint8            dummy127 [ 6 ];       /* Reserved         */
    __type1545       PPCMD3;               /* PPCMD3           */
    uint8            dummy128 [ 4 ];       /* Reserved         */
    const __type1546 PPROTS3;              /* PPROTS3          */
    uint8            dummy129 [ 392 ];     /* Reserved         */
    __type1547       PIBC10;               /* PIBC10           */
    uint8            dummy130 [ 2 ];       /* Reserved         */
    __type1548       PBDC10;               /* PBDC10           */
    uint8            dummy131 [ 14 ];      /* Reserved         */
    __type1549       PODC10;               /* PODC10           */
    uint8            dummy132 [ 20 ];      /* Reserved         */
    __type1550       PPCMD10;              /* PPCMD10          */
    uint8            dummy133 [ 4 ];       /* Reserved         */
    const __type1551 PPROTS10;             /* PPROTS10         */
    uint8            dummy134 [ 8 ];       /* Reserved         */
    __type1552       PIBC11;               /* PIBC11           */
    uint8            dummy135 [ 2 ];       /* Reserved         */
    __type1553       PBDC11;               /* PBDC11           */
    uint8            dummy136 [ 14 ];      /* Reserved         */
    __type1554       PODC11;               /* PODC11           */
    uint8            dummy137 [ 20 ];      /* Reserved         */
    __type1555       PPCMD11;              /* PPCMD11          */
    uint8            dummy138 [ 4 ];       /* Reserved         */
    const __type1556 PPROTS11;             /* PPROTS11         */
    uint8            dummy139 [ 264 ];     /* Reserved         */
    __type1557       PIBC16;               /* PIBC16           */
    uint8            dummy140 [ 2 ];       /* Reserved         */
    __type1558       PBDC16;               /* PBDC16           */
    uint8            dummy141 [ 2 ];       /* Reserved         */
    __type1559       PIPC16;               /* PIPC16           */
    uint8            dummy142 [ 10 ];      /* Reserved         */
    __type1560       PODC16;               /* PODC16           */
    __type1561       PDSC16;               /* PDSC16           */
    __type1562       PIS16;                /* PIS16            */
    uint8            dummy143 [ 6 ];       /* Reserved         */
    __type1563       PISA16;               /* PISA16           */
    uint8            dummy144 [ 6 ];       /* Reserved         */
    __type1564       PPCMD16;              /* PPCMD16          */
    uint8            dummy145 [ 4 ];       /* Reserved         */
    const __type1565 PPROTS16;             /* PPROTS16         */
    uint8            dummy146 [ 8 ];       /* Reserved         */
    __type1566       PIBC17;               /* PIBC17           */
    uint8            dummy147 [ 2 ];       /* Reserved         */
    __type1567       PBDC17;               /* PBDC17           */
    uint8            dummy148 [ 2 ];       /* Reserved         */
    __type1568       PIPC17;               /* PIPC17           */
    uint8            dummy149 [ 10 ];      /* Reserved         */
    __type1569       PODC17;               /* PODC17           */
    __type1570       PDSC17;               /* PDSC17           */
    __type1571       PIS17;                /* PIS17            */
    uint8            dummy150 [ 6 ];       /* Reserved         */
    __type1572       PISA17;               /* PISA17           */
    uint8            dummy151 [ 6 ];       /* Reserved         */
    __type1573       PPCMD17;              /* PPCMD17          */
    uint8            dummy152 [ 4 ];       /* Reserved         */
    const __type1574 PPROTS17;             /* PPROTS17         */
    uint8            dummy153 [ 200 ];     /* Reserved         */
    __type1575       PIBC21;               /* PIBC21           */
    uint8            dummy154 [ 2 ];       /* Reserved         */
    __type1576       PBDC21;               /* PBDC21           */
    uint8            dummy155 [ 2 ];       /* Reserved         */
    __type1577       PIPC21;               /* PIPC21           */
    uint8            dummy156 [ 2 ];       /* Reserved         */
    __type1578       PU21;                 /* PU21             */
    uint8            dummy157 [ 2 ];       /* Reserved         */
    __type1579       PD21;                 /* PD21             */
    uint8            dummy158 [ 2 ];       /* Reserved         */
    __type1580       PODC21;               /* PODC21           */
    uint8            dummy159 [ 20 ];      /* Reserved         */
    __type1581       PPCMD21;              /* PPCMD21          */
    uint8            dummy160 [ 4 ];       /* Reserved         */
    const __type1582 PPROTS21;             /* PPROTS21         */
    uint8            dummy161 [ 1288 ];    /* Reserved         */
    __type1583       PIBC42;               /* PIBC42           */
    uint8            dummy162 [ 2 ];       /* Reserved         */
    __type1584       PBDC42;               /* PBDC42           */
    uint8            dummy163 [ 2 ];       /* Reserved         */
    __type1585       PIPC42;               /* PIPC42           */
    uint8            dummy164 [ 2 ];       /* Reserved         */
    __type1586       PU42;                 /* PU42             */
    uint8            dummy165 [ 2 ];       /* Reserved     