#ifndef _DATA_AVGFUEL_H_
#define _DATA_AVGFUEL_H_

#include "g_includes.h"
#include "CAN_Lib.h"

/******************************************************************************
尿素
******************************************************************************/

/*** 控制结构 ***/
typedef struct 
{  
  uint32_t  RateSum;
  uint32_t  RateASum;

  uint32_t  TripASum;

  uint16_t  TripASum_UnFar;

  uint16_t  ValueA;

  uint16_t  ValueA_Dis;

  uint16_t  FlashtimeA;

  uint16_t  First_timeA;

  uint8_t   ValidA;

  uint8_t   ValidA_Dis;


  uint32_t   TripSum_FlgA;

  uint8_t   Flg_18FEF200;
  uint8_t   Flg_2C0; 

  uint16_t ValueA_Last;
  


}DataAvgFuelStruct;
extern  DataAvgFuelStruct g_aveFuel;   
//输入10倍,输出10倍
uint16_t Data_L_100KM_To_KM_L( uint16_t L_100km_10p );
void  Data_AvgFuel_KL30_Init(void);
void Data_AvgFuel_A_Default(void);

void  Data_AvgFuel_A_KL30_Init(void);

void  Data_AvgFuel_KL15_Init ( void );
void  Data_AvgFuel_Display( void );
void  Data_AvgFuel_Processing_Service(void);
void  Data_AvgFuel_TripA_Display_Service(void);




uint32_t GET_AvgFuel_ConsOf100msUL_Value(void);

void AvgFuel_ConsOf100msUL_Set(uint16_t FuelCons);

void Data_Fuel_Consumption_Count_ISR(void);
void Data_AvgFuel_TripA_Clear(void);


void Data_AvgFuel_Trip_ADD(uint32_t KM_Data);

uint8_t GET_AvgFuel_TripA_Valid(void);
uint8_t GET_AvgFuel_TripA_500_Valid(void);
uint16_t GET_AvgFuel_TripA_Value_Dis(void);


void CAN_18FEF200_Receive(void);
void CAN_2C0_Receive(void);
void Can_AvgFuel_KL30_WakeUp_Init(void);


#endif
