/*
 * @Filename: 
 * @Descripttionn: 
 * @version:  
 * @Author: TianYu
 * @Date: 2022-11-15 10:14:18
 * @LastEditTime: 2023-06-09 17:39:00
 */
#ifndef _NM_CONFIG_H_
#define _NM_CONFIG_H_


typedef struct {
    uint32_t AppId;
    uint16_t AppCycleTime;  //unit:ms
    uint16_t AppCycleTimeMax;  //unit:ms
    uint32_t AppLen;
    uint8_t AppData[8];
}AppMsgTime_t;  /* qitiancun */

typedef struct {
    uint32_t NmIdBase;                    //default:0x400
    uint32_t NmIdBottom;                  //default:0x4ff
    uint8_t  NmIdOwn;                    //default:0x4;
    uint8_t  NmRxLimit;                  //default:0x4
    uint8_t  NmTxLimit;                  //default:0x8
    uint16_t NmTimeType;                  //default:100,unit:ms
    uint16_t NmTimeMax;                   //default:260,unit:ms
    uint16_t NmTimeError;                 //default:1000,unit:ms
    uint16_t NmTimeWaitBusSleep;          //default:1500,unit:ms
    uint16_t NmTimeRequestSleepInd;       //default:5000,unit:ms
    uint8_t  NmTimeRequestLimpSleepInd;    //default:4
    uint16_t VoltUpLimit;                 //default:1810
    uint16_t VoltDownLimit;               //default:690
    uint8_t  BusoffFastRecoverCnt;        
    uint16_t BusoffFastRecoverTime; 
    uint16_t BusoffSlowRecoverTime; 
}OSEK_NM_INIT;

extern char *GetOsekNmVersion(void);
extern uint8_t *GetNmSaveData(uint16_t *len);
extern void SetNmSaveData(uint8_t *data, uint16_t len);
extern void InitNM(OSEK_NM_INIT *NmInit);

extern void OsekNM_Manage_Main(void);
extern void NmSetBatVolt(uint16_t n);
extern uint8_t GetNmBusSleepSt(void);

extern void NM_RemoteWakeup_Fun(void);
extern void NM_SetIgnState(uint8_t IgnPosition);
extern void NM_Receive_isr_Fun(uint32_t id, uint8_t *pBuf);
extern void NM_TranMsgSuccessDetect(void);
extern void NM_TranMsgErrorDetect(void); 
extern void NmSetLastId(uint32_t id);

extern void NM_Init_App_Fun(unsigned char n, AppMsgTime_t *msg);
extern void NM_Set_App_Fun(unsigned char n, unsigned char *data, unsigned char len);

extern unsigned char NM_GetCanBusoffOccurCnt(void);
extern void NM_ResetCanBusoffOccurCnt(void);
extern uint8_t GetLimphomeState(void);
extern uint8_t GetAppSendState(void);
#endif

