
#include "Simulated_IIC_Master.h"
#include "Watchdog.h"
#include "rh850_macros.h"



uint8_t IICReceivedACK;

/******************************************************************************
��������IIC_Init
��  �ܣ���ʼ��IIC����
��  ������
����ֵ����
******************************************************************************/
void IIC_Init(void)
{
	EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
	IIC_Delay();
	IIC_Delay();

	EEPROM_SDA_DIR = GPIO_DIR_IN; //SDA???????????,IO?????????,??????SDA?????????????????,???SDA = 1
	IIC_Delay();
	IIC_Delay();

	IICReceivedACK = IIC_INVALID_ACK;
}

/******************************************************************************
????????IIC_Start
??  ?????IIC???????????????,???????IIC???
??  ??????
?????????
******************************************************************************/
void IIC_Start(void)
{
	IICReceivedACK = IIC_INVALID_ACK;

	EEPROM_SDA_DIR = GPIO_DIR_IN; //SDA???????????,IO?????????,??????SDA?????????????????,???SDA = 1
	IIC_Delay();
	IIC_Delay();

	EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
	IIC_Delay();
	IIC_Delay();

	EEPROM_SDA_DIR = GPIO_DIR_OUT; //SDA???0,???SDA = 0
	EEPROM_SDA_OUT =  0;
	IIC_Delay();
	IIC_Delay();

	EEPROM_SCL_DIR = GPIO_DIR_OUT; //SCL???0,???SCL = 0
	EEPROM_SCL_OUT =  0;
	IIC_Delay();
}

/******************************************************************************
????????IIC_Stop
??  ?????IIC??????????????,??????IIC???
??  ??????
?????????
******************************************************************************/
void IIC_Stop(void)
{
	IICReceivedACK = IIC_INVALID_ACK;

	EEPROM_SDA_DIR = GPIO_DIR_OUT; //SDA???0,???SDA = 0
	EEPROM_SDA_OUT =  0;
	IIC_Delay();
	IIC_Delay();

	EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
	IIC_Delay();
	IIC_Delay();

	EEPROM_SDA_DIR = GPIO_DIR_IN; //SDA???????????,IO?????????,??????SDA?????????????????,???SDA = 1
	IIC_Delay();
	IIC_Delay();
}

/******************************************************************************
????????IIC_Transmit_Data
??  ?????IIC?????????1???????
??  ????Data???????????
??????????????????????(ACK)  0 - ACK  1 - NAK
******************************************************************************/
void IIC_Transmit_Data(uint8_t Data)
{
	uint8_t i;

	IICReceivedACK = IIC_INVALID_ACK;

	for (i = 0; i < 8; i++)
	{
		if (Data & 0x80)
			EEPROM_SDA_DIR = GPIO_DIR_IN; //SDA???????????,IO?????????,??????SDA?????????????????,???SDA = 1
		else
		{
			EEPROM_SDA_DIR = GPIO_DIR_OUT; //SDA???0,???SDA = 0
			EEPROM_SDA_OUT =  0;
		}
		IIC_Delay();
		IIC_Delay();

		EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
		IIC_Delay();
		IIC_Delay();

		EEPROM_SCL_DIR = GPIO_DIR_OUT; //SCL???0,???SCL = 0
		EEPROM_SCL_OUT =  0;
		IIC_Delay();

		//Data <<= 1;
		Data = (uint8_t)(Data << 1);
	}

	EEPROM_SDA_DIR = GPIO_DIR_IN; //????SDA???????
	IIC_Delay();
	IIC_Delay();

	EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
	IIC_Delay();
	IIC_Delay();

	IICReceivedACK = EEPROM_SDA_INPUT;

	EEPROM_SCL_DIR = GPIO_DIR_OUT; //SCL???0,???SCL = 0
	EEPROM_SCL_OUT =  0;
	IIC_Delay();
}

/******************************************************************************
????????IIC_Receive_Data
??  ?????IIC?????????1???????
??  ??????
??????????????????
******************************************************************************/
uint8_t IIC_Receive_Data(void)
{
	uint8_t i;
	uint8_t Data;

	Data = 0;

	EEPROM_SDA_DIR = GPIO_DIR_IN; //????SDA???????
	IIC_Delay();
	IIC_Delay();

	for (i = 0; i < 8; i++)
	{
		Data <<= 1;

		EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
		IIC_Delay();
		IIC_Delay();
		IIC_Delay();

		Data |= EEPROM_SDA_INPUT;

		EEPROM_SCL_DIR = GPIO_DIR_OUT; //SCL???0,???SCL = 0
		EEPROM_SCL_OUT =  0;
		IIC_Delay();
		IIC_Delay();
	}

	return Data;
}

/******************************************************************************
????????IIC_Transmit_ACK
??  ?????IIC???????????????
??  ????ACK?????????????? IIC_ACK  ??????
                              IIC_NAK  ?????
?????????
******************************************************************************/
void IIC_Transmit_ACK(uint8_t ACK)
{
	IICReceivedACK = IIC_INVALID_ACK;

	if (ACK > IIC_NAK)
		return;

	if (ACK)
		EEPROM_SDA_DIR = GPIO_DIR_IN; //SDA???????????,IO?????????,??????SDA?????????????????,???SDA = 1
	else
	{
		EEPROM_SDA_DIR = GPIO_DIR_OUT; //SDA???0,???SDA = 0
		EEPROM_SDA_OUT =  0;
	}
	IIC_Delay();

	EEPROM_SCL_DIR = GPIO_DIR_IN; //SCL???????????,IO?????????,??????SCL?????????????????,???SCL = 1
	IIC_Delay();
	IIC_Delay();

	EEPROM_SCL_DIR = GPIO_DIR_OUT; //SCL???0,???SCL = 0
	EEPROM_SCL_OUT =  0;
	IIC_Delay();
}

/******************************************************************************
????????IIC_Receive_ACK
??  ??????????????????????????
??  ??????
??????????????????????????????IIC_ACK         ??????
                                  IIC_NAK         ?????
                                  IIC_INVALID_ACK ??��????????(???????��???)
******************************************************************************/
uint8_t IIC_Receive_ACK(void)
{
	uint8_t ACK;

	ACK = IICReceivedACK;
	IICReceivedACK = IIC_INVALID_ACK;

	return ACK;
}

/******************************************************************************
????????IIC_Delay
??  ??????5us,????????????��???????
        ??????????IIC_5us_DELAY_CALIBRATION????��?????????5us????
??  ????ACK?????????????  0 - ACK  1 - NAK
?????????
******************************************************************************/
void IIC_Delay(void)
{
	uint8_t i;

	for (i = 0; i < IIC_FREQ_CALIBRATION; i++)
		nop();
}
