#ifndef POPUP_ALARM_H__
#define POPUP_ALARM_H__
/*********************************************************************************/
//#define POP_PLATFORM_16BIT
#ifdef POP_PLATFORM_16BIT
typedef unsigned char Pop_uint8_t;
typedef unsigned int Pop_uint16_t;
typedef unsigned long Pop_uint32_t;
#else
typedef unsigned char Pop_uint8_t;
typedef unsigned short Pop_uint16_t;
typedef unsigned int Pop_uint32_t;
typedef unsigned long long Pop_uint64_t;
#endif
/*********************************************************************************/
/*所有弹出报警列表   */
/*该枚举必须和 stPopAlarmAttribute 一一对应*/
typedef enum
{
	POP_ALARM_DPF = 0U,					/*  DPF再生中，请勿熄火，延时一分钟消失*/
	POP_ALARM_DOOR,						/* 门未关 */
	POP_ALARM_TEMP,						/* 水温高 */
	POP_ALARM_ENGINE_LUBRICATE,			/*  清检查引擎润滑系统*/
	POP_ALARM_FUEL_SEN_FAIL,			/*  燃油传感器故障*/
	POP_ALARM_TBOX_DISMANTLE,			/*  TBOX 被拆除 */
	POP_ALARM_PAR_FULL_MANUAL_RESET,	/*  颗粒捕集器集满，请按说明书手动复位*/
	POP_ALARM_PAR_FULL_SERVICE_RESET,	/*  颗粒捕集器集满，请联系服务站复位*/
	POP_ALARM_UREA_LOW_20,				/* 尿素液位低，最高车速已限制至20KM/H,请添加尿素 */
	POP_ALARM_UREA_FAIL_20,				/* 尿素质量不合格，最高车速20，请更换尿素 */
	POP_ALARM_EMISSION_FAIL_20,			/* 排放系统故障，最高车速20，请至维修站检查 */
	POP_ALARM_UREA_LOW_RESET_20,		/* 尿素液位低，重启后将限速为20KM/H,请添加尿素 */
	POP_ALARM_UREA_FAIL_RESET_20,		/* 尿素质量不合格，重启，请更换尿素 */
	POP_ALARM_EMISSION_FAIL_RESET_20,	/* 排放系统故障，重启，请至维修站检查 */
	POP_ALARM_UREA_LOW_TORQUE_LIMIT_75, /*  尿素液位地，扭矩已限制至75%，请添加尿素*/
	POP_ALARM_UREA_LOW_TORQUE_LIMIT_50, /*  扭矩已限制至75%，*/
	POP_ALARM_LIMIT_75_CHANGE,			/* 扭矩已限制至75%， XX时间之后将限速20 ，请更换尿素*/
	POP_ALARM_LIMIT_75_SERVICE,			/*  扭矩已限制至75%，XX时间之后将限速20 ，请至维修站检查*/
	POP_ALARM_UREA_LOW_LIMIT_75,		/*  尿素液位地，停车后扭矩限制75%，请添加尿素*/
	POP_ALARM_UREA_FAIL_LIMIT_75,		/*  尿素质量不合格，停止后扭矩限制75%，请更换尿素*/
	POP_ALARM_EMISSION_FAIL_LIMIT_75,	/*  排放系统故障，停止后扭矩限制75%，请至维修站检查*/
	POP_ALARM_UREA_LOW_ADD,				/*  尿素液位低，请添加尿素*/
	POP_ALARM_UREA_FAIL_CHANGE,			/* 尿素质量不合格， XX时间之后将限制75 ，请更换尿素*/
	POP_ALARM_EMISSION_FAIL_SERVICE,	/*  排放系统故障，XX时间之后将限制75 ，请至维修站检查*/
	POP_ALARM_ESC_FAILURE,				/* ESP故障 */
	POP_ALARM_ESC_ATCIVE,				/* ESP激活 */
	POP_ALARM_ESC_CLOSE,				/* ESP关闭 */
	POP_ALARM_TPMS_CONFIG_ERROR,		/*  胎压配置错误*/
	POP_ALARM_TPMS,						/*  胎压异常*/
	POP_ALARM_TSAFE_BELT,				/*  请系安全带*/
	POP_ALARM_START_IN_P,				/* 请挂P档启动车辆 */
	POP_ALARM_BRAKE_TO_SHIFT,			/* 请踩制动换挡 */
	POP_ALARM_P_INVALID,				/* P档无效，请用紧急解锁 */
	POP_ALARM_PARK_IN_P,				/* 仅限停车挂P档 */
	POP_ALARM_GEARBOX_FAILURE,			/* 变速箱严重故障 */
	POP_ALARM_RADAR_FAILURE,			/* 倒车雷达故障 */
	POP_ALARM_GEARBOX_CAUTION,			/* 变速箱警示 */
	POP_ALARM_GEARBOX_HIGH_TEMP,		/* 变速箱温度高 */
	POP_ALARM_LDWS_CLOSE,		        /* LDWS功能关闭 */
	POP_ALARM_LDWS_FAILURE,		        /* LDWS功能故障 */
	POP_ALARM_LDWS_ATCIVE,		        /* LDWS功能激活 */
	POP_ALARM_LDWS_L,		            /* LDWS左右偏离 */
	POP_ALARM_LDWS_R,		            /* LDWS左右偏离 */
	POP_ALARM_HILL_HOLD_MALF,			/* 坡道保持故障 */
	POP_ALARM_POSITION_LIGHT,			/* 位置灯未关，请检查 */
	POP_ALARM_KEY,						/* 车辆钥匙请随身携带 */

	POP_ALARM_MAX,
} Pop_Alarm_en_t;

/*报警组枚举，数值越小组优先级越高*/
/*该枚举必须和 stPopAlarmGroupAttribute 一一对应*/
typedef enum
{
	POP_GROUP_0 = 0U,
	POP_GROUP_MAX, /*最大值*/
} Pop_Alarm_Group_en_t;
/*报警类型枚举*/
/*该枚举必须和 stPopAlarmTypeAttribute 一一对应*/
typedef enum
{
	POP_TYPE_0 = 0U,
	POP_TYPE_1,
	POP_TYPE_MAX, /*最大值*/
} Pop_Alarm_Type_en_t;
/*可查询的报警隐藏队列枚举,需根据不同项目而修改*/
typedef enum
{
	POP_HIDE_QUEUE_0 = 0U,
	POP_HIDE_QUEUE_MAX, /*最大值*/
} Pop_Hide_Queue_en_t;
/****************************************Do not modify the following***********************************************************/
/****************************************Do not modify the following***********************************************************/
/****************************************Do not modify the following***********************************************************/
/*当前文件版本号*/
#define POP_VERSION_NUM 0X22U
/*********************************************************************************/
#define POP_RAM_DATA_LEN (POP_ALARM_MAX * 6UL + POP_HIDE_QUEUE_MAX * 4UL)
/*********************************************************************************/
/*报警触发条件*/
typedef enum
{
	POP_ALARM_TRIGGER_1 = 0x01U,
	POP_ALARM_TRIGGER_2 = 0x02U,
	POP_ALARM_TRIGGER_3 = 0x04U,
	POP_ALARM_TRIGGER_4 = 0x08U,
	POP_ALARM_TRIGGER_5 = 0x10U,
	POP_ALARM_TRIGGER_6 = 0x20U,
	POP_ALARM_TRIGGER_7 = 0x40U,
	POP_ALARM_TRIGGER_8 = 0x80U,
	POP_ALARM_TRIGGER_ALL = 0xFFU,
} Pop_Alarm_Trigger_Condition_en_t;
/*报警显示方式*/
typedef enum
{
	POPUP_DISPLAY_CYCLY = 0U, /*按照排序进行循环显示*/
	POPUP_DISPLAY_FIX,		  /*显示时间完成后不自动切换到下一个报警*/
} Popup_Display_Type_en_t;
/*报警触发时相同优先级之间的排序方式*/
typedef enum
{
	POP_SORTORD_FIRST = 0U, /*先触发先报警*/
	POP_SORTORD_AFTER,		/*后触发先报警*/
	POP_SORTORD_MAX,
} Popup_Sortord_Type_en_t;
/*报警正在显示时的消失/切换方式*/
typedef enum
{
	POP_DELAY_NULL = 0U, /*立即消失，不需满足最小显示时长*/
	POP_DELAY_MIN,		 /*满足最小显示时长后消失*/
	POP_DELAY_NORMAL,	 /*满足当前显示周期之后消失*/
	POP_DELAY_MAX,
} Popup_Delay_Time_en_t;
/*报警被打断时的处理方式*/
typedef enum
{
	POP_RECOVER_NONE = 0U, /*不可恢复，进入隐藏队列(不管可否被查询)*/
	POP_RECOVER_FIRST,	   /*可恢复，从首次显示开始*/
	POP_RECOVER_CYCLE,	   /*可恢复，从轮循队列开始*/
	POP_RECOVER_CONTINUE,  /*not support*/
} POP_Break_Type_en_t;
/*允许隐藏的报警在什么阶段允许触发主动隐藏动作*/
typedef enum
{
	POP_ALLOW_HIDE_FIRST_CYCLE = 0U, /*首次显示和轮循显示阶段都可以*/
	POP_ALLOW_HIDE_CYCLE_ONLY,		 /*仅轮循显示阶段*/
	POP_ALLOW_HIDE_FIRST_ONLY,		 /*仅首次显示阶段*/
	POP_ALLOW_HIDE_FORBID,			 /*不允许主动隐藏*/
} Popup_Allow_Hide_Stage_en_t;
/*操作函数返回状态*/
typedef enum
{
	POP_OPERATE_SUCCESS = 0UL, /*函数操作成功*/
	POP_OPERATE_FAIL,		   /*函数操作失败*/
} Pop_Operate_Type_en_t;
/*************************************************************************************/
/**报警组属性****/
typedef struct
{
	/*报警组显示方式，轮显还是固定*/
	Popup_Display_Type_en_t enPopGroupDisplayType;
	/*该报警组打断正在显示的其他报警组内报警时，正在显示的报警的消失/切换方式*/
	Popup_Delay_Time_en_t enPopAlarmGroupDelay;
	/*该报警组内报警在显示时被其他报警组打断时的恢复方式选择*/
	POP_Break_Type_en_t enPopGroupBreak;
} Popup_Alarm_Group_Attribute_st_t;
/*报警类型属性,仅限组内报警之间的处理*/
typedef struct
{
	/*同组内，报警首次显示阶段的显示方式。轮显还是固定显示。*/
	Popup_Display_Type_en_t enPopDisplayFirstType;
	/*同组内，报警非首次显示阶段的显示方式。轮显还是固定显示。*/
	Popup_Display_Type_en_t enPopDisplaySecondType;
	/*正在显示的报警如果能被该报警打断时，当前显示报警的消失/切换方式。适用于同组内*/
	Popup_Delay_Time_en_t enPopAlarmDelay;
	/*该报警显示时被同组报警打断后的恢复方式*/
	POP_Break_Type_en_t enPopBreak;
	/*发生优先级比较时发现优先级相同，该报警的处理排序方式。*/
	Popup_Sortord_Type_en_t enPopSortord;
	/*报警最小显示时长（单位100ms）。不同情况下可允许不满足此限制条件*/
	Pop_uint8_t u8PopMinTime;
	/*报警首次显示时长（单位100ms），参数不可为0。固定就显示一次，之后进入轮循显示周期*/
	Pop_uint8_t u8PopFirstTime;
	/*报警单次轮循显示时长（单位100ms），只需要显示一次的报警，轮显时间填0*/
	Pop_uint8_t u8PopCycleTime;
	/*要隐藏到的查询队列。从0开始。无需查询填 POP_HIDE_QUEUE_MAX */
	Pop_uint8_t u8PopHideQueue; //Pop_Hide_Queue_en_t
	/*如果报警允许触发主动隐藏动作，那么在哪个阶段允许触发*/
	Popup_Allow_Hide_Stage_en_t enPopHideStage;
} Popup_Alarm_Type_Attribute_st_t;
typedef struct
{
	/*报警组别。从0开始顺序填写。同组的连续写，不同组的由小到大填写。*/
	Pop_Alarm_Group_en_t enPopAlarmGroup;
	/*报警类型*/
	Pop_Alarm_Type_en_t enPopAlarmType;
	/*报警首次显示时的优先级。*/
	Pop_uint8_t u8PopFirstPrio;	
	/*报警轮循显示时的优先级*/
	Pop_uint8_t u8PopCyclePrio;
	/*要绑定的声音报警索引。注意声音报警触发/删除条件和对应弹窗完全一致时才可以绑定*/
	Pop_uint16_t u16PopBindingSound;
} Popup_Alarm_Attribute_st_t;
typedef void (*Pop_Sound_Operation)(Pop_Alarm_en_t enPopAlarm, Pop_Alarm_Trigger_Condition_en_t enAlarmTrigger);
typedef void (*Pop_Sound_Handle)(Pop_Alarm_en_t enPopAlarm);
/* 弹出报警初始化参数 */
typedef struct
{
	const Popup_Alarm_Attribute_st_t *pstPopAlarmAttribute;
	const Popup_Alarm_Type_Attribute_st_t *pstPopAlarmTypeAttribute;
	const Popup_Alarm_Group_Attribute_st_t *pstPopAlarmGroupAttribute;
	/*一共有多少个报警组，不可为0。POP_GROUP_MAX*/
	Pop_Alarm_Group_en_t enPopGroupLen;
	/*一共有多少个报警类型，不可为0。POP_TYPE_MAX*/
	Pop_Alarm_Type_en_t enPopTypeLen;
	/*一共有多少个报警，不可为0。 POP_ALARM_MAX */
	Pop_Alarm_en_t enPopAlarmLen;
	/*一共有多少个可查询的报警隐藏队列,可为0。 POP_HIDE_QUEUE_MAX*/
	Pop_Hide_Queue_en_t enPopAlarmHideLen;
	/*声音报警申请函数*/
	Pop_Sound_Operation pfnPopSoundRequestCallBack;
	/*声音报警删除函数*/
	Pop_Sound_Operation pfnPopSoundDeleteCallBack;
	/*声音报警恢复函数*/
	Pop_Sound_Handle pfnPopSoundEnableCallBack;
	/*声音报警暂停函数*/
	Pop_Sound_Handle pfnPopSoundSuspendCallBack;
} Pop_Init_st_t;
/*************************************************************************************/
/*每次KL30和唤醒时都要调用一次*/
void Pop_Alarm_Init(Pop_uint8_t *pu8PopRamData, const Pop_Init_st_t *pstPopAlarmInit);
/*只要报警有效就会返回申请成功，即使已经成功申请过。*/
Pop_Operate_Type_en_t Pop_Alarm_Request_Normal(Pop_Alarm_en_t enPopAlarm);
/*报警删除。enPopDelay：如果删除的报警是当前正在显示的报警，那么设置消失方式。*/
Pop_Operate_Type_en_t Pop_Alarm_Delete_Normal(Pop_Alarm_en_t enPopAlarm, Popup_Delay_Time_en_t enPopDelay);
/*报警申请，多个条件*/
Pop_Operate_Type_en_t Pop_Alarm_Request_Mul(Pop_Alarm_en_t enPopAlarm, Pop_Alarm_Trigger_Condition_en_t enAlarmTrigger);
/*报警删除，多个条件*/
Pop_Operate_Type_en_t Pop_Alarm_Delete_Mul(Pop_Alarm_en_t enPopAlarm, Popup_Delay_Time_en_t enPopDelay, Pop_Alarm_Trigger_Condition_en_t enAlarmTrigger);
/*获取当前需要显示的报警*/
Pop_Alarm_en_t Pop_Alarm_Get_Current(void);
/*触发主动隐藏当前显示的报警*/
/*返回0：隐藏失败，
返回1：隐藏成功*/
Pop_uint16_t Pop_Alarm_Hide_Current(void);
/*主动隐藏触发，全部。*/
/*返回一共成功隐藏了多少个报警*/
Pop_uint16_t Pop_Alarm_Hide_All(void);
/*把某个隐藏队列中的报警，赋值到一个数组中。
u8PopHideQueue :隐藏报警队列序号
enPopHideAlarmArray ：赋值到的目标数组，
u16PopHideNUM：本次读取的报警数长度
返回 实际有效赋值长度
*/
Pop_uint16_t Pop_Alarm_Get_Hide(Pop_uint8_t u8PopHideQueue, Pop_Alarm_en_t enPopHideAlarmArray[], Pop_uint16_t u16PopHideAlarmGetNUM);
/*获取某个隐藏队列中报警数量*/
Pop_uint16_t Pop_Alarm_Get_Hide_NUM(Pop_uint8_t u8PopHideQueue);
/*主循环实时调用*/
void Pop_Alarm_Service(void);
/*弹出报警计时相关，多少百ms调用一次，那就传入多少*/
void Pop_Alarm_Handle_Time(Pop_uint8_t u8PopTimeBase);
/*************************************************************************************/
#endif
