#include "UDS_2FService_Main.h"
#include "GUI.h"

/**
  *2F服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
 _2FDID3F80 LEDContrl;
 uint8_t DiagVSpeedValue[2] = {0, 0};
 uint8_t DiagESpeedValue[2] = {0, 0};
 uint8_t DiagBackLight = 0;
 uint8_t DiagLCD = 0;
 uint8_t DiagBuzzer = 0;
void UDS_Service_2F_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC11();                                            /*2F服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC7F();                                            /*2F服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC33();                                            /*2F服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC13_MinLengthCheck();                             /*2F服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC31();                                            /*2F服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC13_TotalLengthCheck();                           /*2F服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC31_Total();                                     /*2F服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2FService_NRC22();                                            /*2F服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_2FService_DID();                                                    /*2F服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *2F服务子功能
  */
void UDS_2FService_DID(void)
{
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*2F服务DID判断*/
    {
        case 0x3F80:
            UDS_2FService_DID_3F80( );
        break;
        case 0x3F81:
            UDS_2FService_DID_3F81( );
        break;
        case 0x3F82:
            UDS_2FService_DID_3F82( );
        break;
        case 0x3F83:
            UDS_2FService_DID_3F83( );
        break;
        case 0x3F84:
            UDS_2FService_DID_3F84( );
        break;
        case 0x3F85:
            UDS_2FService_DID_3F85( );
        break;
        default:
        break;
    }
}

/**
  *2F服务DID3F80
  *LED
  */
void UDS_2FService_DID_3F80(void)
{
    uint8_t len = 0;
    //BuzzerTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    Set_DIAG_TelltalesCtrlsts(DiagMSG.msgData.DidDetail.Data[0]);

    if(DiagMSG.msgData.DidDetail.Data[0] == 0)
    {
        len = 3;
    }
    else
    {
        LEDContrl.Data[0] = DiagMSG.msgData.DidDetail.Data[1];
        LEDContrl.Data[1] = DiagMSG.msgData.DidDetail.Data[2];
        LEDContrl.Data[2] = DiagMSG.msgData.DidDetail.Data[3];
        LEDContrl.Data[3] = DiagMSG.msgData.DidDetail.Data[4];
        len = 7;
    }
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, len, DiagMSG.msgData.Data);    
}

/**
  *2F服务DID3F81
  *Vehicle_Speed
  */
void UDS_2FService_DID_3F81(void)
{
    uint8_t len = 0;
    //BuzzerTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    Set_DIAG_Vehicle_Speedsts(DiagMSG.msgData.DidDetail.Data[0]);
    if(DiagMSG.msgData.DidDetail.Data[0] == 0)
    {
        len = 3;
    }
    else
    {
        DiagVSpeedValue[0] = DiagMSG.msgData.DidDetail.Data[1];
        DiagVSpeedValue[1] = DiagMSG.msgData.DidDetail.Data[2];
        len = 5;
    }
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, len, DiagMSG.msgData.Data);    
}

/**
  *2F服务DID3F82
  *Engine_Speed
  */
void UDS_2FService_DID_3F82(void)
{
    uint8_t len = 0;
    Set_DIAG_Engine_Speedsts(DiagMSG.msgData.DidDetail.Data[0]);
    //BuzzerTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    if(DiagMSG.msgData.DidDetail.Data[0] == 0)
    {
        len = 3;
    }
    else
    {
        DiagESpeedValue[0] = DiagMSG.msgData.DidDetail.Data[1];
        DiagESpeedValue[1] = DiagMSG.msgData.DidDetail.Data[2];
        len = 5;
    }
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, len, DiagMSG.msgData.Data);    
}

/**
  *2F服务DID3F83
  *BACKLIGHT
  */
void UDS_2FService_DID_3F83(void)
{
    uint8_t len = 0;
    //BuzzerTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    Set_DIAG_BACKLIGHTsts(DiagMSG.msgData.DidDetail.Data[0]);
    if(DiagMSG.msgData.DidDetail.Data[0] == 0)
    {
        len = 3;
    }
    else
    {
        DiagBackLight = DiagMSG.msgData.DidDetail.Data[1];
        len = 4;
    }
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, len, DiagMSG.msgData.Data);    
}

/**
  *2F服务DID3F84
  *LCD
  */
void UDS_2FService_DID_3F84(void)
{
    uint8_t len = 0;
    Display_Diag_Ctrl(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    //Set_DIAG_LCDsts(DiagMSG.msgData.DidDetail.Data[0]);
    //BuzzerTest(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    if(DiagMSG.msgData.DidDetail.Data[0] == 0)
    {
        len = 3;
    }
    else
    {
        //DiagLCD = DiagMSG.msgData.DidDetail.Data[1];
        len = 4;
    }
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, len, DiagMSG.msgData.Data);    
}

/**
  *2F服务DID3F84
  *BUZZER
  */
void UDS_2FService_DID_3F85(void)
{
    uint8_t len = 0;
    Sound_Diag_Ctrl(DiagMSG.msgData.DidDetail.Data[0], DiagMSG.msgData.DidDetail.Data[1]);
    if(DiagMSG.msgData.DidDetail.Data[0] == 0)
    {
        len = 3;
    }
    else
    {
        DiagBuzzer = DiagMSG.msgData.DidDetail.Data[1];
        len = 4;
    }
    UDS_Service_Response(0x2Fu, POSITIVE_RSP, DIAG_ID_Tx, len, DiagMSG.msgData.Data);    
}