#ifndef _BACKLIGHT_H_
#define _BACKLIGHT_H_

/******************************************************************************
头文件
******************************************************************************/
#include "stdint.h"


#define BACKLIGHT_AVE_RES_MAX    (32U)

/*背光调节模式*/
typedef enum
{
    NOUSED_DIMMING = 0U,
    DIMMER_DIMMING,
    IHU_DIMMING,
    OTHER_DIMMING,
} BackLight_Mode_Enum;

/*背光控制*/
typedef struct
{
    uint16_t    LCDPWMLast;
    uint16_t    PointerPWMLast;
    
    uint16_t    PanelPWMLast;    


} ST_BackLightCtrlStruct;

/*白天/夜晚照明*/
enum
{
    DAY_LIGHT = 0U,
    NIGHT_LIGHT,
};

/*调光等级*/
enum
{
    LCM_Level_0 = 0U ,
    LCM_Level_1  ,
    LCM_Level_2  ,
    LCM_Level_3  ,
    LCM_Level_4  ,
    LCM_Level_5  ,
    LCM_Level_6  ,
    LCM_Level_7  ,
    LCM_Level_8  ,
    LCM_Level_9  ,
    LCM_Level_10 ,
    LCM_Level_11 ,  /* Level_11 对应白天，占空比为100% */
    LCM_Level_MAX,
};


/*占空比逼近周期,单位ms */
#define  BL_PWM_DUTY_CYCLE_APPR_SPEED      (4U)


/******************************************************************************
函数声明
******************************************************************************/
uint8_t BackLight_GetLevel_For_Send(void);
void BackLight_Ctrl_Service(void);
void BackLight_IG_ON_Init(void);
void BackLight_IG_OFF_Init(void);
void BackLight_30_Init(void);
void BackLight_Sleep_Init(void);
void BackLight_Wakeup_Init(void);

/*诊断调用设置背光模式*/
void BackLight_Mode_Set( uint8_t  Mode );
/*背光外发周期控制函数，1：20ms快速外发3帧，0：100ms发送*/
uint8_t Get_BackLight_Send_Timer(void);
/*出现快速发送3帧后，调用清除函数*/
void BackLight_Send_TimerFlag_Clear(void);

void BackLight_LCD_ON(void);
void BackLight_LCD_OFF(void);


uint16_t  BackLight_Get_LCDPWM( void );
uint16_t  BackLight_Get_PointerPWM( void );
uint16_t  BackLight_Get_PanelPWM( void );

#endif



